<?php
/**
 * Fichier recap_matiere.php
 * @abstract page qui affiche les notes pour la matire slectionne
 * @author Eric Dondelinger
 * @version 0.1
 * @todo  voir utiliser cette page pour optimisation via les fonctionnalits zend core
 */

session_start();

require("./classes/ListeEval.php");
require("./classes/ListeUser.php");

if ($_SESSION["estProf"] != "O"){
	header('Location: errorPage.php');
}

if (!isset($_GET["mat"])){
	header('Location: accueil_prof.php');
}

// c'est ici que l'on valide une nouvelle saisie de rsultat
if (isset($_GET["libeval"])){
	
	$eval = new DAOEvaluation();
	$eval->setCode_mat($_GET['mat']);
	$eval->setCoef_eval($_GET['coefeval']);
	$eval->setDate_eval($_GET['dateeval']);
	$eval->setLib_eval($_GET['libeval']);
	$eval->setLibplus_eval($_GET['desdeval']);
	$eval->save();
	
	for ($i = 0; $i< $_GET["nbetud"]; $i++){
		$resu = new DAOResultat();
		$resu->setCodeEval($eval->getCode_eval());
		$resu->setCodeUser($_GET["user".$i.""]);
		$resu->setNote($_GET["note".$i.""]);
		$resu->save();
	}
}

$matiere = new DAOMatiere();
$matiere->loadByID($_GET["mat"]);

$listeE = new ListeEval();
$listeE->loadListeByMatiere($matiere->getCode_mat());

$listeU = new ListeUser();
$listeU->loadListeByClasse($matiere->getCode_classe());

echo("Connect : ".$_SESSION['prenom_user']." ".$_SESSION['nom_user']);
?>

<h2>Voici la liste de vos lves et leur rsultat pour la matire <?=$matiere->getLib_mat()?> de la classe <?=$matiere->getCode_classe()?></h2>
<h3>Renseignez la colonne vide pour ajouter un nouveau rsultat (le descriptif de la nouvelle valuation est  renseigner dans le formulaire sous la liste)</h3>
<br/>
<form action="recap_matiere.php">
<table border="1">
	<tr>
		<th>Nom lve</th>
<?php
	// on rcupre les valuations disponibles dans cette matire pour crer l'entte.
	$tabEval = $listeE->getListe();
	for ($i = 0; $i<count($tabEval); $i++){
		$e = $tabEval[$i];
		echo("<th>Eval ".$e->getCode_eval()."</th>");
	}
?>
	<th>Nouvelle</th>
	</tr>
<?php
// on rcupre les tudiants suivant cette matire
$tabEtu = $listeU->getListe();
for ($i = 0; $i < count($tabEtu); $i++){
	$etu = $tabEtu[$i];
	echo("<tr><td>".$etu->getNom_user()." ".$etu->getPrenom_user()."</td>");
	// on va chercher les notes pour chaque valuation de l'tudiant actuel
	for ($j = 0; $j<count($tabEval); $j++){
		$e = $tabEval[$j];
		$re = new DAOResultat();
		$re->loadResultat($etu->getCode_user(), $e->getCode_eval());
		echo("<td>".$re->getNote()."</td>");
	}
	echo("<td><input type=\"hidden\" name=\"user".$i."\" value=\"".$etu->getCode_user()."\">");
	echo("<input type=\"text\" name=\"note".$i."\" value=\"\">");
	echo("</tr>");
}
?>
</table>
<br/>
<table>
	<tr>
		<td>Description de la nouvelle valuation : </td><td><input type="text" name="libeval"></td>
	</tr>
	<tr>
		<td>Coefficient de la nouvelle valuation :</td><td><input type="text" name="coefeval"></td>
	</tr>
	<tr>
		<td>Date de la nouvelle valuation (AAAAMMJJ) :</td><td><input type="text" name="dateeval"></td>
	</tr>
	<tr>
		<td>Description dtaille (facultatif) : </td><td><input type="text" name="desdeval"></td>
	</tr>
	<tr>
		<td><input type="hidden" name="mat" value="<?=$_GET['mat']?>"><input type="hidden" name="nbetud" value="<?=$i?>"></td><td><input type="submit" value="Envoyer"></td>
	</tr>
</table>

</form>