<?php
require_once("DataBase.php");

class DAOUser {

	// Attributs privs correspondants aux champs de la table user
	private $code_user;
	private $nom_user;
	private $prenom_user;
	private $pass_user;
	private $code_classe;
	
	// Constructeur par dfaut de la classe
	public function DAOUser() {
	}
	
	// Mthodes GET d'accs aux attributs
	public function getCode_user(){
		return $this->code_user;
	}
	public function getNom_user(){
		return $this->nom_user;
	}
	public function getPrenom_user(){
		return $this->prenom_user;
	}
	public function getPass_user(){
		return $this->pass_user;
	}
	public function getCode_classe(){
		return $this->code_classe;
	}
	
	// Mthodes SET d'affectation des attributs
	public function setCode_user($c){
		$this->code_user = $c;
	}
	public function setNom_user($n){
		$this->nom_user = $n;
	}
	public function setPrenom_user($p){
		$this->prenom_user = $p;
	}
	public function setPass_user($p){
		$this->pass_user = $p;
	}
	public function setCode_classe($c){
		$this->code_classe = $c;
	}
	
	public function DAOUser_toString(){
		echo "Classe DAOUser : ".$this->getCode_user()." ".$this->getNom_user();
	}

	// Mthode de chargement d'un user dont l'ID est fourni en paramtre
	public function loadByID($id){
		$db = new DataBaseAccess();
		$db->executerRequete("select * from user where code_user = '".$id."'");
		if ($db->nombreLignesTrouvees() > 0){
			$resultat = $db->ligneResultat();
			$this->setCode_user($resultat['code_user']);
			$this->setNom_user($resultat['nom_user']);
			$this->setPrenom_user($resultat['prenom_user']);
			$this->setPass_user($resultat['pass_user']);
			$this->setCode_classe($resultat['code_classe']);
			return true;
		}else{
			return false;
		}
	}
}

class DAOClasse {
	// attributs privs
	private $code_classe;
	private $lib_classe;
	private $effectif_classe;
	
	public function DAOClasse(){
	}
	
	// GETTERS
	public function getCode_classe(){
		return $this->code_classe;
	}
	public function getLib_classe(){
		return $this->lib_classe;
	}
	public function getEffectif_classe(){
		return $this->effectif_classe;
	}
	
	// SETTERS
	public function setCode_classe($c){
		$this->code_classe = $c;
	}
	public function setLib_classe($l){
		$this->lib_classe = $l;
	}
	public function setEffectif_classe($e){
		$this->effectif_classe = $e;
	}
	
	// Chargement d'une classe par code classe pass en param
	public function loadByID($id){
		$db = new DataBaseAccess();
		$db->executerRequete("select * from classe where code_classe = '".$id."'");
		if ($db->nombreLignesTrouvees() > 0){
			$resultat = $db->ligneResultat();
			$this->setCode_classe($resultat['code_classe']);
			$this->setLib_classe($resultat['lib_classe']);
			$this->setEffectif_classe($resultat['effectif_classe']);
			return true;
		}else{
			return false;
		}
	}
	
}

class DAOMatiere {
	// attributs privs
	private $code_mat;
	private $lib_mat;
	private $code_classe;
	
	public function DAOMatiere(){
	}
	
	// GETTERS
	public function getCode_mat(){
		return $this->code_mat;
	}
	
	public function getLib_mat(){
		return $this->lib_mat;
	}
	public function getCode_classe(){
		return $this->code_classe;
	}	
	
	// SETTERS
	public function setCode_mat($c){
		$this->code_mat = $c;
	}
	public function setLib_mat($l){
		$this->lib_mat = $l;
	}
	public function setCode_classe($c){
		$this->code_classe = $c;
	}
	
	// Chargement d'une matire par code matire pass en param
	public function loadByID($id){
		$db = new DataBaseAccess();
		$db->executerRequete("select * from matiere where code_mat = ".$id);
		if ($db->nombreLignesTrouvees() > 0){
			$resultat = $db->ligneResultat();
			$this->setCode_mat($resultat['code_mat']);
			$this->setLib_mat($resultat['lib_mat']);
			$this->setCode_classe($resultat['code_classe']);
			return true;
		}else{
			return false;
		}
	}
}

class DAOEvaluation {
	// attributs privs
	private $code_eval;
	private $lib_eval;
	private $date_eval;
	private $libplus_eval;
	private $coef_eval;
	private $code_mat;
	
	public function DAOEvaluation(){
	}
	
	// GETTERS
	public function getCode_eval(){
		return $this->code_eval;
	}
	public function getLib_eval(){
		return $this->lib_eval;
	}
	public function getDate_eval(){
		return $this->date_eval;
	}
	public function getLibplus_eval(){
		return $this->libplus_eval;
	}
	public function getCoef_eval(){
		return $this->coef_eval;
	}
	public function getCode_mat(){
		return $this->code_mat;
	}
	
	// SETTERS
	public function setCode_eval($c){
		$this->code_eval = $c;
	}
	public function setLib_eval($l){
		$this->lib_eval = $l;
	}
	public function setDate_eval($d){
		$this->date_eval = $d;
	}
	public function setLibplus_eval($l){
		$this->libplus_eval = $l;
	}
	public function setCoef_eval($c){
		$this->coef_eval = $c;
	}
	public function setCode_mat($c){
		$this->code_mat = $c;
	}
		
	// Chargement d'une evaluation
	public function loadByID($id){
		$db = new DataBaseAccess();
		$db->executerRequete("select * from evaluation where code_eval = ".$id);
		if ($db->nombreLignesTrouvees() > 0){
			$resultat = $db->ligneResultat();
			$this->setCode_eval($resultat['code_eval']);
			$this->setLib_eval($resultat['lib_eval']);
			$this->setDate_eval($resultat['date_eval']);
			$this->setLibplus_eval($resultat['libplus_eval']);
			$this->setCoef_eval($resultat['coef_eval']);
			$this->setCode_mat($resultat['code_mat']);
			return true;
		}else{
			return false;
		}
	}
	
	public function save(){
		$db = new DataBaseAccess();
		$this->setCode_eval($this->getNewId());
		$db->executerRequete("insert into evaluation values (".$this->getCode_eval().", '".$this->getLib_eval()."', '".$this->getDate_eval()."', '".$this->getLibplus_eval()."',".$this->getCoef_eval().",'".$this->getCode_mat()."')");
	}
	
	private function getNewId(){
		$db = new DataBaseAccess();
		$db->executerRequete("select count(*) as nb from evaluation");
		$resu = $db->ligneResultat();
		$nid = $resu['nb'];
		$nid++;
		return $nid;
	}
}

class DAOResultat {
	private $codeEval;
	private $codeUser;
	private $note;
	
	public function DAOResultat(){
	}
	
	// GETTERS
	public function getCodeEval(){
		return $this->codeEval;
	}
	public function getCodeUser(){
		return $this->codeUser;
	}
	public function getNote(){
		return $this->note;
	}
	// SETTERS
	public function setCodeEval($c){
		$this->codeEval = $c;
	}
	public function setCodeUser($c){
		$this->codeUser = $c;
	}
	public function setNote($n){
		$this->note = $n;
	}
	
	public function save(){
		$db = new DataBaseAccess();
		$db->executerRequete("insert into resultat values (".$this->getCodeEval().", '".$this->getCodeUser()."', ".$this->getNote().")");
	}
	
	public function loadResultat($u, $e){
		$db = new DataBaseAccess();
		$db->executerRequete("select * from resultat where code_user = '".$u."' and code_eval = ".$e);
		if ($db->nombreLignesTrouvees() > 0){
			$resultat = $db->ligneResultat();
			$this->setCodeUser($resultat['code_user']);
			$this->setCodeEval($resultat['code_eval']);
			$this->setNote($resultat['note']);
			return true;
		}else{
			return false;
		}
	}
}
?>