drop database;

set sql dialect 1;

create database "e:\documents\uml\compta\comptabilite.gdb" user "SYSDBA" password "masterkey";

create table compte (
	numCpte varchar(10) not null,
	intituleCpte varchar(50),
	typeCpte smallint,
	primary key(numCpte)
);

create table ecriture(
	numEcr integer not null,
	dateEcr date,
	libelleEcr varchar(50),
	primary key(numEcr)
);

create table mouvement(
	numEcr integer not null,
	numCpte varchar(10) not null,
	debit decimal(10,2) not null,
	credit decimal(10,2) not null,
	primary key(numEcr,numCpte),
	foreign key(numEcr) references ecriture(numEcr),
	foreign key(numCpte) references compte(numCpte)
);

create generator genEcrId;
set generator genEcrId to 0;

set term ^;
create procedure idNouvelleEcr
returns (idNew integer)
as
begin
	idNew=gen_id(genEcrId,1);
end^
set term ;^

set term ^;
create procedure sommeDebitEcr(ecr integer)
returns (val decimal(10,2))
as
begin
	select sum(debit)
	from mouvement
	where numEcr=:ecr
	into :val;
end^
set term ;^

set term ^;
create procedure sommeCreditEcr(ecr integer)
returns (val decimal(10,2))
as
begin
	select sum(credit)
	from mouvement
	where numEcr=:ecr
	into :val;
end^
set term ;^

set term ^;
create procedure resultat
returns (res decimal(10,2))
as
begin
	select sum(credit)-sum(debit)
	from mouvement
	where numCpte in (select numCpte from compte where typeCpte > 2)
	into :res;
end^
set term ;^