unit Cu_mouvement;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Cu_controleur, Cu_compte;
// 	Ajouter Cu_maitre si il y a des champs rfrence dans la table tb ou dans les vues

type
  TC_mouvement = class(TC_controleur)
    tbNUMECR: TIntegerField;
    tbNUMCPTE: TStringField;
    tbDEBIT: TFloatField;
    tbCREDIT: TFloatField;
    tbIntituleCompte: TStringField;
    ps_sommeDebitEcr: TStoredProc;
    ps_sommeCreditEcr: TStoredProc;
    rq_avecEcrCpte: TQuery;
    rq_avecEcrCpteNUMCPTE: TStringField;
    rq_avecEcrCpteINTITULECPTE: TStringField;
    rq_avecEcrCpteTYPECPTE: TSmallintField;
    rq_avecEcrCpteNUMECR: TIntegerField;
    rq_avecEcrCpteDATEECR: TDateTimeField;
    rq_avecEcrCpteLIBELLEECR: TStringField;
    rq_avecEcrCpteDEBIT: TFloatField;
    rq_avecEcrCpteCREDIT: TFloatField;
    qr_AjoutIntermediaire: TQuery;
    qr_suppIntermediaire: TQuery;
    qr_ajout: TQuery;
    qr_suppReouverture: TQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
// 	On trouve ici les requtes produisant les diffrentes vues
//	ATTENTION, chaque requte suceptible d'tre synchronise doit tre formate comme suit :
		//	- mots cls SQL en minuscules
    //	- pas de point-virgule (;)  la fin
    //	- condition where entirement parenthse si elle est complexe (... or ...)
    //	- clause from sur une seule ligne s'il n'y a pas de clause where
    //	- clause order sur une seule ligne (la dernire)
//	Remarque : mettre tag  -1 interdit la synchronisation d'une requte

  private
// 	Ajouter la dclaration des contrleurs de rfrence (table matre)
		//  refMaitre:TC_maitre;
		refCompte:TC_compte;
  public
//	Ajouter les diffrentes procdures de synchronisation
		//	procedure synchroMaitre(var ds_maitre:TDataSource);
		procedure synchroEcriture(var ds_ecriture:TDataSource);
		procedure synchroCompte(var ds_compte:TDataSource);

//	Ajouter les diffrentes procdures permettant le changement de vue
		//  procedure vueMaRequete;
    procedure vueAvecEcrCpte;

//	Ajouter les fonctions membres de la classe contrle
		function sommeDebitEcr(ecr:integer):Currency;
		function sommeCreditEcr(ecr:integer):Currency;
    procedure ajoutMouvementIntermediaire(resultat:Currency);
    procedure suppMouvementIntermediaire;
    procedure ajoutMouvement(numEcr:integer;numCpte:String;debit,credit:Currency);
    procedure suppReouverture(numEcr:integer);
end;

var
  C_mouvement: TC_mouvement;

implementation

{$R *.DFM}

procedure TC_mouvement.DataModuleCreate(Sender: TObject);
begin
  inherited;
// 	Ajouter la cration des contrleurs de rfrence et des champs rfrence
//	les champs rfrence comme "libelleMaitre" doivent tre crs en mode graphique
		// 	refMaitre:=TC_maitre.Create(Self);
		//  tbLibelleMaitre.LookupDataSet:=refMaitre.donnees;
	refCompte:=TC_compte.Create(Self);
  tbIntituleCompte.LookupDataSet:=refCompte.donnees;
	tb.Open;
end;

procedure TC_mouvement.DataModuleDestroy(Sender: TObject);
begin
  inherited;
// 	Ajouter la destruction des contrleurs de rfrence
		//  refMaitre.Free;
	refCompte.Free;
end;

//	Dfinitions des procdures de synchronisation
		//	procedure TC_maTable.synchroMaitre(var ds_maitre:TDataSource);
		//	begin
		//		synchroniser(ds_maitre,'champPere','champFils');
		//	end;
		//	Exemple TC_employe.synchroService : synchroniser(ds_service,'code','codeSce')
		//	Remarque : il peut y avoir plusieurs champs spars par un ; (point-virgule)
procedure TC_mouvement.synchroEcriture(var ds_ecriture:TDataSource);
begin
	synchroniser(ds_ecriture,'numEcr','numEcr');
end;
procedure TC_mouvement.synchroCompte(var ds_compte:TDataSource);
begin
	synchroniser(ds_compte,'numCpte','numCpte');
end;

//	Dfinition des diffrentes vues
		//	procedure TC_maTable.vueMaRequete;
		//	begin
		//		changerVue(rq_maRequete);
		//	end;
procedure TC_mouvement.vueAvecEcrCpte;
begin
	changerVue(rq_avecEcrCpte);
end;

//	Dfinition des mthodes de la classe contrle
function TC_mouvement.sommeDebitEcr(ecr:integer):Currency;
begin
	ps_sommeDebitEcr.ParamByName('ECR').AsInteger:=ecr;
  ps_sommeDebitEcr.ExecProc;
  sommeDebitEcr:=ps_sommeDebitEcr.paramByName('VAL').AsCurrency;
end;

function TC_mouvement.sommeCreditEcr(ecr:integer):Currency;
begin
	ps_sommeCreditEcr.ParamByName('ECR').AsInteger:=ecr;
  ps_sommeCreditEcr.ExecProc;
  sommeCreditEcr:=ps_sommeCreditEcr.paramByName('VAL').AsCurrency;
end;

procedure TC_mouvement.ajoutMouvementIntermediaire(resultat:Currency);
begin
	if resultat > 0 then
  	begin
    	qr_ajoutIntermediaire.ParamByName('DEBIT').AsCurrency:=0;
    	qr_ajoutIntermediaire.ParamByName('CREDIT').AsCurrency:=resultat;
    end
  else
  	begin
    	qr_ajoutIntermediaire.ParamByName('DEBIT').AsCurrency:=-resultat;
    	qr_ajoutIntermediaire.ParamByName('CREDIT').AsCurrency:=0;
    end;
  qr_ajoutIntermediaire.ExecSQL;
end;

procedure TC_mouvement.suppMouvementIntermediaire;
begin
  qr_suppIntermediaire.ExecSQL;
end;

procedure TC_mouvement.ajoutMouvement(numEcr:integer;numCpte:String;debit,credit:Currency);
begin
	qr_ajout.Params[0].AsInteger:=numEcr;
	qr_ajout.Params[1].AsString:=numCpte;
	qr_ajout.Params[2].AsFloat:=debit;
	qr_ajout.Params[3].AsFloat:=credit;
	qr_ajout.ExecSQL;
end;

procedure TC_mouvement.suppReouverture(numEcr:integer);
begin
	qr_suppReouverture.ParamByName('num').AsInteger:=numEcr;
  qr_suppReouverture.ExecSQL;
end;

end.
