unit Cu_ecriture;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Cu_controleur;
// 	Ajouter Cu_maitre si il y a des champs rfrence dans la table tb ou dans les vues

type
  TC_ecriture = class(TC_controleur)
    tbNUMECR: TIntegerField;
    tbDATEECR: TDateTimeField;
    tbLIBELLEECR: TStringField;
    ps_idNouvelleEcr: TStoredProc;
    qr_intermediaire: TQuery;
    qr_suppReouverture: TQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure tbAfterInsert(DataSet: TDataSet);
// 	On trouve ici les requtes produisant les diffrentes vues
//	ATTENTION, chaque requte suceptible d'tre synchronise doit tre formate comme suit :
		//	- mots cls SQL en minuscules
    //	- pas de point-virgule (;)  la fin
    //	- condition where entirement parenthse si elle est complexe (... or ...)
    //	- clause from sur une seule ligne s'il n'y a pas de clause where
    //	- clause order sur une seule ligne (la dernire)
//	Remarque : mettre tag  -1 interdit la synchronisation d'une requte

  private
// 	Ajouter la dclaration des contrleurs de rfrence (table matre)
		//  refMaitre:TC_maitre;

  public
//	Ajouter les diffrentes procdures de synchronisation
		//	procedure synchroMaitre(var ds_maitre:TDataSource);

//	Ajouter les diffrentes procdures permettant le changement de vue
		//  procedure vueMaRequete;

//	Ajouter les fonctions membres de la classe contrle
		function valide:boolean;
    procedure ajoutResultatIntermediaire(resultat:Currency);
    procedure suppResultatIntermediaire;
    function ajoutEcriture(dateEcr:TDate;libelleEcr:String):integer;
    procedure suppReouverture(numEcr:integer);
  end;

var
  C_ecriture: TC_ecriture;

implementation

uses Cu_mouvement;

{$R *.DFM}

procedure TC_ecriture.DataModuleCreate(Sender: TObject);
begin
  inherited;
// 	Ajouter la cration des contrleurs de rfrence et des champs rfrence
//	les champs rfrence comme "libelleMaitre" doivent tre crs en mode graphique
		// 	refMaitre:=TC_maitre.Create(Self);
		//  tbLibelleMaitre.LookupDataSet:=refMaitre.donnees;

	tb.Open;
end;

procedure TC_ecriture.DataModuleDestroy(Sender: TObject);
begin
  inherited;
// 	Ajouter la destruction des contrleurs de rfrence
		//  refMaitre.Free;
end;

//	Dfinitions des procdures de synchronisation
		//	procedure TC_maTable.synchroMaitre(var ds_maitre:TDataSource);
		//	begin
		//		synchroniser(ds_maitre,'champPere','champFils');
		//	end;
		//	Exemple TC_employe.synchroService : synchroniser(ds_service,'code','codeSce')
		//	Remarque : il peut y avoir plusieurs champs spars par un ; (point-virgule)

//	Dfinition des diffrentes vues
		//	procedure TC_maTable.vueMaRequete;
		//	begin
		//		changerVue(rq_maRequete);
		//	end;

//	Dfinition des mthodes de la classe contrle
function TC_ecriture.valide:boolean;
var controlMouvement:TC_mouvement;
		ecr:integer;
    res:boolean;
begin
	ecr:=donnees.FieldValues['numEcr'];
	controlMouvement:=TC_mouvement.Create(Self);
	res:=(controlMouvement.sommeDebitEcr(ecr)=controlMouvement.sommeCreditEcr(ecr));
  controlMouvement.Free;
  valide:=res;
end;

procedure TC_ecriture.ajoutResultatIntermediaire(resultat:Currency);
var controlMouvement:TC_mouvement;
begin
	controlMouvement:=TC_mouvement.Create(Self);
	qr_intermediaire.SQL.Text:='insert into ecriture values(0,null,null)';
	qr_intermediaire.ExecSQL;
  controlMouvement.ajoutMouvementIntermediaire(resultat);
  controlMouvement.Free;
end;

procedure TC_ecriture.suppResultatIntermediaire;
var controlMouvement:TC_mouvement;
begin
	controlMouvement:=TC_mouvement.Create(Self);
  controlMouvement.suppMouvementIntermediaire;
	qr_intermediaire.SQL.Text:='delete from ecriture where numEcr=0';
	qr_intermediaire.ExecSQL;
  controlMouvement.Free;
end;

procedure TC_ecriture.tbAfterInsert(DataSet: TDataSet);
begin
  inherited;
	ps_idNouvelleEcr.ExecProc;
  tb.FieldValues['numEcr']:=ps_idNouvelleEcr.ParamByName('idNew').AsInteger;
end;

function TC_ecriture.ajoutEcriture(dateEcr:TDate;libelleEcr:String):integer;
begin
	tb.Insert;
  tb.FieldValues['dateEcr']:=dateEcr;
  tb.FieldValues['libelleEcr']:=libelleEcr;
  tb.Post;
  ajoutEcriture:=tb.FieldValues['numEcr'];
end;

procedure TC_ecriture.suppReouverture(numEcr:integer);
begin
	qr_suppReouverture.ParamByName('num').AsInteger:=numEcr;
  qr_suppReouverture.ExecSQL;
end;

end.
