unit Au_compta;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  IBDatabase, Db, DBTables;

type
  TA_compta = class(TDataModule)
    db: TDatabase;
    ps_resultat: TStoredProc;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
  public
// Ajouter les mthodes de l'objet applicatif
    procedure planComptes;
    procedure saisieEcritures;
    procedure verifierEcriture;
    procedure grandLivre;
    procedure imprimerJournal;
    procedure imprimerBalance;
    procedure imprimerCompteResultat;
		procedure imprimerBilanIntermediaire;
    procedure imprimerBilan;
    procedure regroupement;
    procedure imprimerBalanceApresRes;
    procedure reouverture;
  end;

var
  A_compta: TA_compta;

implementation

uses Fu_compte, Fu_ecriture, Fu_grandLivre, Ru_journal, Ru_balance,
  Ru_compteResultat, Ru_bilan, Cu_ecriture, Cu_compte, Cu_mouvement;

{$R *.DFM}

procedure TA_compta.DataModuleCreate(Sender: TObject);
begin
	db.Open;
end;

procedure TA_compta.DataModuleDestroy(Sender: TObject);
begin
	db.Close;
end;

// Ajouter la dfinition des mthodes de l'objet applicatif
procedure TA_compta.planComptes;
begin
	F_compte.Show;
end;

procedure TA_compta.saisieEcritures;
begin
	F_ecriture.controlEcriture.rafraichir;
	F_ecriture.controlMouvement.synchroEcriture(F_ecriture.ds_ecriture);
  F_ecriture.controlMouvement.trier('credit');
	F_ecriture.Show;
end;

procedure TA_compta.verifierEcriture;
begin
	if F_ecriture.controlEcriture.valide then
		ShowMessage('Ecriture correcte')
  else
  	ShowMessage('Ecriture incorrecte');
end;

procedure TA_compta.grandLivre;
begin
	F_grandLivre.controlCompte.vueSoldes;
	F_grandLivre.controlMouvement.vueAvecEcrCpte;
	F_grandLivre.controlMouvement.synchroCompte(F_grandLivre.ds_compte);
  F_grandLivre.controlMouvement.trier('numEcr');
  F_grandLivre.Show;
end;

procedure TA_compta.imprimerJournal;
begin
	R_journal.controlMouvement.vueAvecEcrCpte;
  R_journal.controlMouvement.trier('numEcr;credit');
  R_journal.rp.PreviewModal;
end;

procedure TA_compta.imprimerBalance;
begin
	R_balance.controlCompte.vueSoldes;
  R_balance.rp.PreviewModal;
end;

procedure TA_compta.imprimerCompteResultat;
begin
	R_compteResultat.controlCompte.vueSoldes;
  R_compteResultat.controlCompte.filtrer('typeCpte=3 or typeCpte=4');
  R_compteResultat.controlCompte.trier('typeCpte');
	R_compteResultat.rp.PreviewModal;
end;

procedure TA_compta.imprimerBilanIntermediaire;
var controlEcriture:TC_ecriture;
		resultatComptable:Currency;
begin
	ps_resultat.ExecProc;
	resultatComptable:=ps_resultat.ParamByName('RES').AsCurrency;
	controlEcriture:=TC_ecriture.Create(Self);
  controlEcriture.ajoutResultatIntermediaire(resultatComptable);
	imprimerBilan;
  controlEcriture.suppResultatIntermediaire;
  controlEcriture.Free;
end;

procedure TA_compta.imprimerBilan;
begin
	R_bilan.controlCompte.vueSoldes;
  R_bilan.controlCompte.filtrer('typeCpte=1 or typeCpte=2');
  R_bilan.controlCompte.trier('typeCpte');
  R_bilan.rp.PreviewModal;
end;

procedure TA_compta.regroupement;
var	controlEcriture:TC_ecriture;
		controlCompte:TC_compte;
		controlMouvement:TC_mouvement;
		numEcr:integer;
    total,montant:Currency;
    numCpte:String;
begin
	if MessageDlg('Le regroupement est irrversible, continuer ?',mtConfirmation,mbOKCancel,0) = mrOk then
  	begin
    	controlEcriture:=TC_ecriture.Create(Self);
      controlCompte:=TC_compte.Create(Self);
      controlMouvement:=TC_mouvement.Create(Self);
      controlCompte.vueSoldes;
	// regroupement des charges
      numEcr:=controlEcriture.ajoutEcriture(Date,'Regroupement charges');
      controlCompte.filtrer('typeCpte=3');
      controlCompte.donnees.First;
			total:=0;
      while not controlCompte.donnees.Eof do begin
				montant:= - controlCompte.donnees.FieldValues['Solde'];
        numCpte:=controlCompte.donnees.FieldValues['numCpte'];
				total:=total+montant;
        controlMouvement.ajoutMouvement(numEcr,numCpte,0,montant);
      	controlCompte.donnees.Next;
      end;
      controlMouvement.ajoutMouvement(numEcr,'12',total,0);
	// regroupement des produits
      numEcr:=controlEcriture.ajoutEcriture(Date,'Regroupement produits');
      controlCompte.filtrer('typeCpte=4');
      controlCompte.donnees.First;
			total:=0;
      while not controlCompte.donnees.Eof do begin
				montant:=controlCompte.donnees.FieldValues['Solde'];
        numCpte:=controlCompte.donnees.FieldValues['numCpte'];
				total:=total+montant;
        controlMouvement.ajoutMouvement(numEcr,numCpte,montant,0);
      	controlCompte.donnees.Next;
      end;
      controlMouvement.ajoutMouvement(numEcr,'12',0,total);
      controlMouvement.Free;
      controlCompte.Free;
      controlEcriture.Free;
    end
  else
  	ShowMessage('Regroupement annul');
end;

procedure TA_compta.imprimerBalanceApresRes;
begin
	R_balance.controlCompte.vueSoldes;
  R_balance.controlCompte.filtrer('typeCpte=1 or typeCpte=2');
  R_balance.rp.PreviewModal;
end;

procedure TA_compta.reouverture;
var	controlEcriture:TC_ecriture;
		controlCompte:TC_compte;
		controlMouvement:TC_mouvement;
		numEcr:integer;
    solde:Currency;
    numCpte:String;
begin
	if MessageDlg('La rouverture est irrversible, continuer ?',mtConfirmation,mbOKCancel,0) = mrOk then
  	begin
    	controlEcriture:=TC_ecriture.Create(Self);
      controlCompte:=TC_compte.Create(Self);
      controlMouvement:=TC_mouvement.Create(Self);
      controlCompte.vueSoldes;
      numEcr:=controlEcriture.ajoutEcriture(Date,'Rouverture des comptes');
      controlCompte.donnees.First;
      while not controlCompte.donnees.Eof do begin
				solde:=controlCompte.donnees.FieldValues['Solde'];
        numCpte:=controlCompte.donnees.FieldValues['numCpte'];
        if solde<0 then
        	controlMouvement.ajoutMouvement(numEcr,numCpte,-solde,0)
        else
        	if solde>0 then
        		controlMouvement.ajoutMouvement(numEcr,numCpte,0,solde);
          // ne rien faire pour les soldes nuls
      	controlCompte.donnees.Next;
      end;
			controlMouvement.suppReouverture(numEcr);
      controlEcriture.suppReouverture(numEcr);
      controlMouvement.Free;
      controlCompte.Free;
      controlEcriture.Free;
    end
  else
  	ShowMessage('Rouverture annule');
end;

end.
