unit Cu_controleur;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type
  TC_controleur = class(TDataModule)
    tb: TTable;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    vue_courante:TQuery;
    tbTriCourant,tbSynchroCourante:String;
		function unir(s1,s2:String):String;
		procedure synchroniserVue(var ds:TDataSource;champPere,champFils:String);
	protected
		procedure changerVue(var nouvelleVue:TQuery);
    procedure synchroniser(var ds:TDataSource;champPere,champFils:String);
  public
    procedure vueTable;
    function donnees:TDataSet;
    procedure rafraichir;
  	procedure annulerSynchro;
    procedure filtrer(filtre:String);
		procedure annulerFiltre;
  	procedure trier(champsTri:String);
    procedure annulerTri;
    procedure lectureSeule(onOff:boolean);
  end;

var
  C_controleur: TC_controleur;

implementation

{$R *.DFM}

procedure TC_controleur.DataModuleCreate(Sender: TObject);
begin
	vue_courante:=nil;
  tbTriCourant:='';
  tbSynchroCourante:='';
	if tb.Active then tb.Close;
end;

procedure TC_controleur.DataModuleDestroy(Sender: TObject);
begin
	if vue_courante=nil then
  	tb.close
  else
  	vue_courante.Close;
end;

procedure TC_controleur.filtrer(filtre:String);
begin
  vue_courante.Filter:=filtre;
  vue_courante.Filtered:=true;
end;

procedure TC_controleur.annulerFiltre;
begin
  vue_courante.Filter:='';
  vue_courante.Filtered:=false;
end;

function TC_controleur.unir(s1,s2:String):String;
// s1 est prioritaire sur s2 : --> s1 + ce qui est dans s2 et pas dans s1
var	ssch:String;
begin
	s2:=s2+';';
	ssch:=copy(s2,1,pos(';',s2)-1);
  while ssch<>'' do begin
  	s2:=copy(s2,pos(';',s2)+1,length(s2));
    if pos(ssch,s1)=0 then
    	s1:=s1+';'+ssch;
		ssch:=copy(s2,1,pos(';',s2)-1);
  end;
  unir:=s1;
end;
procedure TC_controleur.synchroniserVue(var ds:TDataSource;champPere,champFils:String);
var
	nl, posFrom, posWhere, nlFrom, nlWhere, limitePere, limiteFils:integer;
  fini, avecWhere, finCondition, avecAnd:boolean;
  debutLigneWhere, finLigneWhere, condition, pere, fils:String;
begin
	if vue_courante.tag>0 then	// synchronisation active
  	annulerSynchro;
  vue_courante.Close;
	nl:=0;posWhere:=0;nlWhere:=0;nlFrom:=0;
  fini:=false;avecWhere:=false;
  while not fini do begin
  	posFrom:=pos('from',vue_courante.SQL[nl]);
    if posFrom > 0 then nlFrom:=nl;
    posWhere:=pos('where',vue_courante.SQL[nl]);
    if posWhere > 0 then
    	begin
      	fini:=true;
        avecWhere:=true;
        nlWhere:=nl;
      end
    else
    	if nl = (vue_courante.SQL.Count-1) then
      	fini:=true
      else
      	nl:=nl+1
  end;
  condition:='';avecAnd:=false;finCondition:=false;
  repeat
	  limiteFils:=pos(';',champFils);
    if limiteFils > 0 then
    	begin
    		fils:=copy(champFils,1,limiteFils-1);
      	champFils:=copy(champFils,limiteFils+1,length(champFils));
  			limitePere:=pos(';',champPere);
      	pere:=copy(champPere,1,limitePere-1);
      	champPere:=copy(champPere,limitePere+1,length(champPere));
      end
    else
    	begin
      	fils:=champFils;
        pere:=ChampPere;
        finCondition:=true;
      end;
    if avecAnd then
    	condition:=condition + ' and '
    else
    	avecAnd:=true;
    condition:=condition + fils + '=:' + pere;
  until finCondition;
  if avecWhere then
  	begin
			debutLigneWhere:=copy(vue_courante.SQL[nlWhere],1,posWhere-1);
      finLigneWhere:=copy(vue_courante.SQL[nlWhere],posWhere+6,length(vue_courante.SQL[nlWhere]));
      vue_courante.SQL[nlWhere]:=debutLigneWhere;
      vue_courante.SQL.Insert(nlWhere+1,'where ' + condition);
      vue_courante.SQL.Insert(nlWhere+2,'and ' + finLigneWhere);
      vue_courante.Tag:=1;	// marque synchro avec where
    end
  else
  	begin
      vue_courante.SQL.Insert(nlFrom+1,'where ' + condition);
      vue_courante.Tag:=2;	// marque synchro sans where
    end;
  vue_courante.DataSource:=ds;
  vue_courante.Prepare;
  vue_courante.Open;
end;

procedure TC_controleur.synchroniser(var ds:TDataSource;champPere,champFils:String);
begin
	if vue_courante=nil then
  	begin
			tb.Close;
  		tb.MasterSource:=ds;
  		tb.MasterFields:=champPere;
      tbSynchroCourante:=champFils;
  		tb.IndexFieldNames:=unir(tbSynchroCourante,tbTriCourant);
  		tb.Open;
    end
  else
  	begin
			if vue_courante.Tag=-1 then	// synchronisation interdite
				ShowMessage('Erreur, synchronisation de ' + vue_courante.Name + ' interdite')
      else
				synchroniserVue(ds,champPere,champFils);
    end
end;

procedure TC_controleur.annulerSynchro;
var
	nl, nlWhere:integer;
  whereTrouve:boolean;
begin
	nlWhere:=0;
	if vue_courante=nil then
  	begin
			tb.Close;
  		tb.MasterSource:=nil;
  		tb.MasterFields:='';
      tbSynchroCourante:='';
  		tb.IndexFieldNames:=unir(tbSynchroCourante,tbTriCourant);
  		tb.Open;
    end
  else
  	begin
      if vue_courante.Tag > 0 then	// vue synchronise
      	begin
    			vue_courante.Close;
      		vue_courante.DataSource:=nil;
          nl:=0;whereTrouve:=false;
          while not whereTrouve do begin
          	if pos('where',vue_courante.SQL[nl])>0 then
            	begin
                whereTrouve:=true;
                nlWhere:=nl;
              end
            else
            	nl:=nl+1;
          end;
          if vue_courante.Tag=1 then	// synchronise avec where initial
          	begin
							vue_courante.SQL[nlWhere+1]:='where ' + copy(vue_courante.SQL[nlWhere+1],5,length(vue_courante.SQL[nlWhere+1]));
							vue_courante.SQL.Delete(nlWhere);
            end
          else 	// synchronise sans where initial
							vue_courante.SQL.Delete(nlWhere);
					vue_courante.Tag:=0;	// marque non synchronise
      		vue_courante.Open;
        end;
		end;
end;
procedure TC_controleur.trier(champsTri:String); 	// champs spars par ;
var posOrder, posPv:integer;
begin
	if vue_courante=nil then
  	begin
  		tb.Close;
      tbTriCourant:=champsTri;
  		tb.IndexFieldNames:=unir(tbSynchroCourante,tbTriCourant);
      tb.Open;
    end
  else
  	begin
			posPv:=pos(';',champsTri);
			while (posPv >0) do begin
      	champsTri:=copy(champsTri,1,posPv-1)+','+copy(champsTri,posPv+1,length(champsTri));
				posPv:=pos(';',champsTri);
      end;
			vue_courante.Close;
      posOrder:=pos('order',vue_courante.SQL[vue_courante.SQL.Count-1]);
      if	posOrder > 0 then
      	begin
  				vue_courante.SQL[vue_courante.SQL.Count-1]:=copy(vue_courante.SQL[vue_courante.SQL.Count-1],1,posOrder-1);
					if vue_courante.SQL[vue_courante.SQL.Count-1]='' then
          	vue_courante.SQL.Delete(vue_courante.SQL.Count-1);
        end;
  		vue_courante.SQL.Append('order by ' + champsTri);
  		vue_courante.Open;
    end;
end;

procedure TC_controleur.annulerTri;
var posOrder:integer;
begin
	if vue_courante=nil then
  	begin
			tb.Close;
      tbTriCourant:='';
  		tb.IndexFieldNames:=unir(tbSynchroCourante,tbTriCourant);
  		tb.IndexFieldNames:='';
  		tb.Open;
    end
  else
  	begin
			vue_courante.Close;
      posOrder:=pos('order',vue_courante.SQL[vue_courante.SQL.Count-1]);
      if	posOrder > 0 then
      	begin
  				vue_courante.SQL[vue_courante.SQL.Count-1]:=copy(vue_courante.SQL[vue_courante.SQL.Count-1],1,posOrder-1);
					if vue_courante.SQL[vue_courante.SQL.Count-1]='' then
          	vue_courante.SQL.Delete(vue_courante.SQL.Count-1);
        end;
  		vue_courante.Open;
    end;
end;

function TC_controleur.donnees:TDataSet;
begin
	if vue_courante=nil then
  	donnees:=tb
  else
		donnees:=vue_courante;
end;

procedure TC_controleur.vueTable();
begin
	if vue_courante<>nil then
		vue_courante.Close
  else
  	tb.Close;
  vue_courante:=nil;
  tb.Open;
end;

procedure TC_controleur.changerVue(var nouvelleVue:TQuery);
begin
	if vue_courante=nil then
  	tb.Close
  else
		vue_courante.Close;
  vue_courante:=nouvelleVue;
  vue_courante.Open;
end;

procedure TC_controleur.rafraichir;
begin
	donnees.Close;
  donnees.Open;
end;

procedure TC_controleur.lectureSeule(onOff:boolean);
begin
	if vue_courante=nil then
		begin
    	tb.Close;
      tb.ReadOnly:=onOff;
      tb.Open;
    end
  else
  	begin
			vue_courante.Close;
      vue_courante.RequestLive:=not(onOff);
  		vue_courante.Open;
    end;
end;

end.
