unit Cu_employe;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Cu_controleur, Cu_service;
// 	Ajouter Cu_maitre si il y a des champs rfrence dans la table tb ou dans les vues

type
  TC_employe = class(TC_controleur)
    tbMATRICULE: TStringField;
    tbNOM: TStringField;
    tbSALAIRE: TIntegerField;
    tbCODESCE: TStringField;
    tbDesignationService: TStringField;
    tbDoubleSalaire: TIntegerField;
    rq_Supp5000: TQuery;
    ps_sommeSalaire: TStoredProc;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure tbCalcFields(DataSet: TDataSet);
// 	On trouve ici les requtes produisant les diffrentes vues
//	ATTENTION, chaque requte suceptible d'tre synchronise ou trie doit tre formate comme suit :
		//	- mots cls SQL en minuscules
    //	- pas de point-virgule (;)  la fin
    //	- condition where entirement parenthse si elle est complexe (... or ...)
    //	- clause from sur une seule ligne s'il n'y a pas de clause where
    //	- clause order sur une seule ligne (la dernire)
//	Remarque : mettre tag  -1 interdit la synchronisation d'une requte

  private
// 	Ajouter la dclaration des contrleurs de rfrence (table matre)
		//  refMaitre:TC_maitre;
    refService:TC_service;

  public
//	Ajouter les diffrentes procdures de synchronisation
		//	procedure synchroMaitre(var ds_maitre:TDataSource);
    procedure synchroService(var ds_service:TDataSource);

//	Ajouter les diffrentes procdures permettant le changement de vue
		//  procedure vueMaRequete;
    procedure vueSupp5000;

//	Ajouter les fonctions membres de la classe contrle
		function sommeSalaire(sce:String):integer;

  end;

var
  C_employe: TC_employe;

implementation

{$R *.DFM}

procedure TC_employe.DataModuleCreate(Sender: TObject);
begin
  inherited;
// 	Ajouter la cration des contrleurs de rfrence et des champs rfrence
//	les champs rfrence comme "libelleMaitre" doivent tre crs en mode graphique
		// 	refMaitre:=TC_maitre.Create(Self);
		//  tbLibelleMaitre.LookupDataSet:=refMaitre.donnees;
	refService:=TC_service.Create(Self);
  tbDesignationService.LookupDataSet:=refService.donnees;

	tb.Open;
end;

procedure TC_employe.DataModuleDestroy(Sender: TObject);
begin
  inherited;
// 	Ajouter la destruction des contrleurs de rfrence
		//  refMaitre.Free;
	refService.Free;
end;

//	Dfinitions des procdures de synchronisation
		//	procedure TC_maTable.synchroMaitre(var ds_maitre:TDataSource);
		//	begin
		//		synchroniser(ds_maitre,'champPere','champFils');
		//	end;
		//	Exemple TC_employe.synchroService : synchroniser(ds_service,'code','codeSce')
		//	Remarque : il peut y avoir plusieurs champs spars par un ; (point-virgule)
procedure TC_employe.synchroService(var ds_service:TDataSource);
begin
	synchroniser(ds_service,'code','codeSce');
end;

//	Dfinition des diffrentes vues
		//	procedure TC_maTable.vueMaRequete;
		//	begin
		//		changerVue(rq_maRequete);
		//	end;
procedure TC_employe.vueSupp5000;
begin
	changerVue(rq_supp5000);
end;

//	Dfinition des mthodes de la classe contrle
function TC_employe.sommeSalaire(sce:String):integer;
begin
	ps_sommeSalaire.ParamByName('SCE').AsString:=sce;
	ps_sommeSalaire.ExecProc;
  sommeSalaire:=ps_sommeSalaire.ParamByName('VAL').AsInteger;
end;

procedure TC_employe.tbCalcFields(DataSet: TDataSet);
begin
  inherited;
	tbDoubleSalaire.AsInteger:=tbSalaire.AsInteger*2;
end;

end.
