unit Au_empSce;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type
  TA_empSce = class(TDataModule)
    db: TDatabase;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private

  public
// Ajouter les mthodes de l'objet applicatif
		procedure employe;
    procedure service;
    procedure empSce;
    procedure listing;
    procedure stats;
    procedure empParSalaire;
    procedure empNonTries;
		procedure masseSalariale;
    procedure synchroOn;
    procedure synchroOff;
  end;

var
  A_empSce: TA_empSce;

implementation

uses Cu_employe, Fu_employe, Cu_service, Fu_service, Fu_empSce, Ru_listing,
  Fu_stats;

{$R *.DFM}

procedure TA_empSce.DataModuleCreate(Sender: TObject);
begin
	db.Open;
end;

procedure TA_empSce.DataModuleDestroy(Sender: TObject);
begin
	db.Close;
end;

// Ajouter la dfinition des mthodes de l'objet applicatif

procedure TA_empSce.employe;
begin
	F_employe.Show;	
end;

procedure TA_empSce.service;
begin
	F_service.Show;
end;

procedure TA_empSce.empSce;
begin
	F_empSce.controlEmploye.vueSupp5000;
  F_empSce.controlEmploye.synchroService(f_empSce.ds_service);
  F_empSce.controlService.lectureSeule(true);
  F_empSce.Show;
end;

procedure TA_empSce.listing;
begin
	R_listing.controlEmploye.trier('nom');
  R_listing.rp.PreviewModal;
end;

procedure TA_empSce.stats;
var controlService:TC_service;
		nb,total:integer;
begin
	controlService:=TC_service.Create(Self);
  total:=0;
  nb:=controlService.donnees.RecordCount;
	controlService.donnees.First;
  while not controlService.donnees.Eof do begin
  	total:=total+controlService.masseSalariale;
  	controlService.donnees.Next;
  end;
  controlService.Free;
  F_stats.ed_nbServices.Text:=IntToStr(nb);
  F_stats.ed_totalSalaire.Text:=IntToStr(total);
  F_stats.Show;
end;

procedure TA_empSce.empParSalaire;
begin
	F_employe.controlEmploye.trier('salaire');
end;

procedure TA_empSce.empNonTries;
begin
	F_employe.controlEmploye.annulerTri;
end;

procedure TA_empSce.masseSalariale;
begin
  ShowMessage(IntToStr(F_service.controlService.masseSalariale));
end;

procedure TA_empSce.synchroOn;
begin
  F_empSce.controlEmploye.synchroService(f_empSce.ds_service);
end;

procedure TA_empSce.synchroOff;
begin
  F_empSce.controlEmploye.annulerSynchro;
end;

end.
