#include<iostream.h>
#include <typeinfo.h>
#include <stdlib.h>
#include<conio.h>
#include<string.h>
typedef char chaine[15];
enum booleen {faux,vrai};
const int MAX_COUREURS = 10;
const int MAX_ETAPES =5;
class Etape;
class Coureur;
class Place;
 class Vehicule
{
 public:
 		Vehicule(){}
    	Vehicule(int num);
   	virtual  float getCoefficient()=0;
    	int getNumero();
 private:
     int numero;
 } ;
//-----------------------------------------------------------------------------------------------
class Voiture : public Vehicule
{
public :
	   Voiture(){}
   	Voiture(int num, int puis);
    	float getCoefficient();
private:
     int puissance;
};
 //-----------------------------------------------------------------------------------------------
class Camion : public Vehicule
{
public:
	   Camion(){}
   	Camion(int num,int pds);
    	float getCoefficient();
private:
    	int poids;
} ;
//-----------------------------------------------------------------------------------------------
class Coureur
{
public :
	 	Coureur(chaine nom);
      Coureur(){}
   	void setVehicule(Vehicule * vehicule);
   	char * getNom();
		Vehicule * getVehicule();
 		void setCumulTemps(int temps );
   	int getCumulTemps();
   	int getNumero();
		void afficheInfo();
   	~Coureur(){delete monVehicule;}
private:
    	int cumulTemps;
		int numero;
   	chaine nom;
		Vehicule * monVehicule;
 } ;
//----------------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------------
class Place
{
 public:
		Place(Coureur * uncoureur,Etape * uneetape,int t);
		~Place(){delete uneEtape;delete unCoureur;}
 private:
		int temps;
		Etape * uneEtape;
		Coureur * unCoureur;
 };
//--------------------------------------------------------------------------------
  class Etape
{
public:
		Etape(){};
		Etape(int num, int km);
		void addPlace(Place * uneplace);
		int getNumero();
private:
		int numero;
		int distance;
		Place *  mesPlaces[MAX_COUREURS] ;
};
//----------------------------------------------------------------------------------------------
 class Rallye
{
public:
		Rallye(int nbetapes,int nbcoureurs);
		void addCoureur(Coureur * coureur);
		int getNbCoureurs();
		Coureur * getCoureur(int n);
		Etape * getEtape(int n);
		void palmares();
private:
		 int nbEtapes;
		 int nbCoureurs;
		 Coureur * lesCoureurs[MAX_COUREURS];
		 Etape * mesEtapes[MAX_ETAPES];
 };
 //--------------------------------------------------------------------------------
 class IUPreparer
 {
public:
	IUPreparer(){}

	Rallye * preparer();
	Rallye * getLeRallye(){return leRallye;}
 private:
	Rallye * leRallye;
   Coureur * saisirCoureur();
   void saisirRallye();
  	void saisirVehicule(Coureur * coureur);
 };
 //-----------------------------------------------------------------------------
 class IUArrivee
 {
public:
	IUArrivee(Rallye * lerallye){leRallye = lerallye;}
   void saisirPlace();
   void saisirArrivee();
private:

	Rallye * leRallye;


 };
 //-----------------------------------------------------------------------------
Vehicule::Vehicule(int num)
	{
		numero = num;
	}
int Vehicule::getNumero()
	 {
		return numero;
	 }
	//---------------------------------------------------------------------------
Voiture::Voiture(int num, int puis):Vehicule(num)
	{
		puissance = puis;
	}
float Voiture::getCoefficient()
	 {
	  int dif = puissance - 20;
	  return 1 + 0.05*dif;
	 }
//------------------------------------------------------------------------
Camion::Camion(int num,int pds):Vehicule(num)
	{
		poids = pds;
	}
float Camion::getCoefficient()
	 {
		int dif = poids - 2000;
	  return 1-0.1*(dif/100);
	 }
	//-------------------------------------------------------------------------
Coureur::Coureur( chaine unNom)
	{
    	static int nbCoureurs=0;
		strcpy(nom,unNom);
		numero = ++nbCoureurs;
		cumulTemps = 0;
  	}
void Coureur::setVehicule(Vehicule * vehicule)
	{
		monVehicule = vehicule;
	}
char * Coureur::getNom()
	{
		return nom;
	}
Vehicule * Coureur::getVehicule()
	{
		return monVehicule;
	}
void Coureur::setCumulTemps(int temps)
	{
		cumulTemps+=monVehicule->getCoefficient()*temps;
	}
int Coureur::getCumulTemps()
	{
		return cumulTemps;
	}
int Coureur::getNumero()
	{
		return numero;
	}
void Coureur::afficheInfo()
{
 cout<<"\nNom :"<<nom<<"\tnumero :"<<numero<<"\tTemps :"<<cumulTemps;
 cout<<"\tVehicule numero :"<<monVehicule->getNumero();
}
  //--------------------------------------------------------------------------

Rallye::Rallye(int nbetapes,int nbcoureurs)
	{
		nbEtapes = nbetapes;
		nbCoureurs = nbcoureurs;
		for(int i= 0;i<nbetapes;i++)
		{
		 Etape * e =  new Etape(i+1, random(200)+200);
		mesEtapes[i]=e;
		}
	}
void Rallye::addCoureur(Coureur * uncoureur)
	{
	  static int n=0;
	  lesCoureurs[n++] = uncoureur;
	}
	int Rallye::getNbCoureurs()
	{
		return nbCoureurs;
	}
	Coureur * Rallye::getCoureur(int n)
	{
		return lesCoureurs[n];
	}
	 Etape * Rallye::getEtape(int n)
	 {
	  return mesEtapes[n];
	 }
	void Rallye::palmares()
	{
	for(int i=0;i<nbCoureurs;i++)
		   lesCoureurs[i]->afficheInfo();
	}
  //----------------------------------------------------------------------------
  Etape::Etape(int num, int km)
	{
		numero = num;
		distance = km;
	}
	void Etape::addPlace(Place * uneplace)
	{
		static int n=0;

		mesPlaces[n++] = uneplace;
	}
	int Etape::getNumero()
	{

		return numero;
	}

  //---------------------------------------------------------------------------
  Place::Place(Coureur * uncoureur,Etape * uneetape,int t)
	{
		uneEtape = uneetape;
		unCoureur = uncoureur;
		temps = t;
		unCoureur->setCumulTemps(temps);
	}
	//--------------------------------------------------------------------------

  void IUPreparer::saisirRallye()
  {
	int n,c;
	cout<<"\nNombre d'tapes :";
	cin>>n;
	cout<<"\nNombre de coureurs :";
	cin>>c;
	leRallye = new Rallye(n,c);

  }
  Coureur * IUPreparer::saisirCoureur()
  {
			chaine nom;
			cout<< "\nNom du coureur";
		  	cin>>nom;
		  	Coureur * c ;
         c= new Coureur(nom);
			leRallye->addCoureur(c);
		  	return c;

  }
  void IUPreparer::saisirVehicule(Coureur * coureur)
  {
			int num,puis,pds,choix;
			Vehicule * v;
			cout<<"\nSaisir une voiture 1";
			cout<<"\nSaisir un camion 2";
			cin>>choix;
			switch(choix)
			{
				case 1:
					cout<<"\nnumero de voiture svp:";
					cin>>num ;
					cout<<"\n puissance svp:";
					cin>>puis;
					v = new Voiture(num,puis);
					break;
				case 2:
					cout<< "\nnumero du camion svp:" ;
					cin>>num;
					cout<< "\npoids svp:";
					cin>>pds;
					v = new Camion(num,pds);
					break;

			}
			if(choix==1 || choix==2)
			{
				 coureur->setVehicule(v);

			}
  }
  Rallye * IUPreparer::preparer()
  {
		saisirRallye();
		for(int i =0;i<leRallye->getNbCoureurs();i++)
		  {
		  Coureur * c= saisirCoureur();
		 	saisirVehicule(c);


		  }
      return leRallye;

  }
  //----------------------------------------------------------------------------
  void IUArrivee::saisirPlace()
  {
   static int numetape=0;
      int temps=0;
      Place * p;
		cout<<"\n nb de vehicules "<<leRallye->getNbCoureurs();
      cout<< "\nnumero de l'etape :"<<++numetape;
		cout<<"\n Voitures:";
		for (int i = 0;i<leRallye->getNbCoureurs();i++)
		  {

		   Coureur * c =	leRallye->getCoureur(i);
		  if(typeid(*(c->getVehicule()))==typeid(Voiture))
				{
				cout<<"\n nom:"<< c->getNom();
            cout<< "\nTemps de l'etape svp:";
				cin>>temps;
				p = new Place(c,leRallye->getEtape(numetape-1),temps);
            leRallye->getEtape(numetape-1)->addPlace(p);
				}
			}
		cout<<"\n Camions:";
		for (int i = 0;i<leRallye->getNbCoureurs();i++)
		  {
		   Coureur * c =	leRallye->getCoureur(i);

		  if(typeid(*(c->getVehicule()))==typeid(Camion))
				{
				cout<<"\n nom: "<< c->getNom();
            cout<< "\nTemps de l'etape svp:";
				cin>>temps;
				p = new Place(c,leRallye->getEtape(numetape-1),temps);
            leRallye->getEtape(numetape-1)->addPlace(p);
				}
  }
  leRallye->palmares();
  }
  void IUArrivee::saisirArrivee()
  {
     char encore='o';
     while (toupper(encore)=='O')
        saisirPlace();




  }
  //----------------------------------------------------------------------------
  void main()
  {



	IUPreparer * i = new IUPreparer();
    Rallye * r=i->preparer();
   IUArrivee * a = new IUArrivee(r);
   a->saisirPlace();
	//i->getLeRallye()->palmares();

   getch();
  }

