using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.IO;

namespace GestionPostes
{
	public class ServiceGestionGhost : System.ServiceProcess.ServiceBase
	{
		// CONFIGURATION
        string cheminShutdown = "c:\\config\\shutdown.exe";
        string cheminMessage = "c:\\config\\message.exe";
        int numPortService = 65402;
        int numPortGestion = 65400;
        char separateurChar = (char)219;
        // FIN DE CONFIGURATION
        Socket s;
        EndPoint localEP;
        EndPoint remoteEP;
        byte[] message = new byte[1024];

        /// <summary> 
		/// Variable ncessaire au concepteur.
		/// </summary>
		private System.ComponentModel.Container components = null;
		public ServiceGestionGhost()
		{
			// Cet appel est requis par le Concepteur de composants Windows.Forms.
			InitializeComponent();

			// TODO: ajoutez les initialisations aprs l'appel  InitComponent
		}
		static void Main()
		{
			System.ServiceProcess.ServiceBase[] ServicesToRun;
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new ServiceGestionGhost() };
			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}
		/// <summary> 
		/// Mthode requise pour la prise en charge du concepteur - ne modifiez pas 
		/// le contenu de cette mthode avec l'diteur de code.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// ServiceGestionGhost
			// 
			this.CanShutdown = true;
			this.ServiceName = "ServiceGestionGhost";

		}
		/// <summary>
		/// Nettoyage des ressources utilises.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Dmarrage du service.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			// TODO: ajoutez ici le code pour dmarrer votre service.
			try
			{
				s=new Socket(AddressFamily.InterNetwork,SocketType.Dgram,ProtocolType.Udp);
                IPAddress adrIpLocale = getAdrIpV4(Dns.GetHostName());
				localEP=(EndPoint)new IPEndPoint(adrIpLocale,numPortService);
				s.Bind(localEP);
				remoteEP=(EndPoint) new IPEndPoint(IPAddress.Any,0);
				Array.Clear(message,0,message.Length);
				s.BeginReceiveFrom(message,0,1024,SocketFlags.None,ref remoteEP,new AsyncCallback(beginReceiveFrom_CallBack),null);
                envoyerConnexion(true);
            }
			catch (Exception pb)
			{
				EventLog.WriteEntry("Administration Poste","System.OnStart : "+pb.ToString(),EventLogEntryType.Error,401);
			}
		}
        private IPAddress getAdrIpV4(string hote)
        {
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void envoyerConnexion(bool ok)
        {
            try
            {
                string etat;
                if (ok)
                {
                    etat = "ok";
                }
                else
                {
                    etat = "ko";
                }
                byte[] messageTest = new byte[100];
                Socket sTest = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
                sTest.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast, 1);
                string nomPoste = Dns.GetHostName();
                IPAddress adrIpLocale = getAdrIpV4(nomPoste);
                EndPoint localEP = (EndPoint)new IPEndPoint(adrIpLocale, 0);
                sTest.Bind(localEP);
                remoteEP = (EndPoint)new IPEndPoint(IPAddress.Broadcast, numPortGestion);
                messageTest = UTF8Encoding.UTF8.GetBytes(nomPoste + separateurChar + adrIpLocale + separateurChar + etat + separateurChar);
                sTest.SendTo(messageTest, remoteEP);
                sTest.Close();
            }
            catch (Exception pb)
            {
                EventLog.WriteEntry("Administration Poste", "System.envoyerConnexion : " + pb.ToString(), EventLogEntryType.Error, 402);
            }
        }
        private void beginReceiveFrom_CallBack(IAsyncResult ar)
		{
            string strAction="noAction";
            Process psMessage;
            Process ps;
            ProcessStartInfo psInfoMessage;
            ProcessStartInfo psInfo;
            try
			{
                s.EndReceiveFrom(ar, ref remoteEP);
                strAction = Encoding.UTF8.GetString(message, 0, message.Length);
                strAction = strAction.Replace("\0", " ").Trim();
                switch (strAction)
                {
                    case "ghoster":
                        psMessage = new Process();
                        psInfoMessage = new ProcessStartInfo(cheminMessage);
                        psMessage.StartInfo = psInfoMessage;
                        psMessage.Start();
                        psMessage.WaitForExit(30000);                       
                        File.Copy("c:\\config\\boot.gho", "c:\\boot.ini", true);
                        // autoexec.bat copie boot.ok dans boot.ini
                        ps = new Process();
                        psInfo = new ProcessStartInfo(cheminShutdown, " -r -f -t 30");
                        psInfo.CreateNoWindow = true;
                        psInfo.UseShellExecute = false;
                        ps.StartInfo = psInfo;
                        ps.Start();
                        break;
                    case "testerConnexion":
                        envoyerConnexion(true);
                        break;
                }
                remoteEP = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
                Array.Clear(message, 0, message.Length);
                s.BeginReceiveFrom(message, 0, 1024, SocketFlags.None, ref remoteEP, new AsyncCallback(beginReceiveFrom_CallBack), null);
            }
			catch (Exception pb)
			{
                EventLog.WriteEntry("Administration Poste", strAction+" : " + pb.ToString(), EventLogEntryType.Error, 106);
			}
		}

		/// <summary>
		/// Arrt du service.
		/// </summary>
		protected override void OnStop()
		{
			try
			{
                envoyerConnexion(false);
                s.Close();
			}
			catch (Exception pb)
			{
				EventLog.WriteEntry("Administration Poste","System.OnStop : "+pb.ToString(),EventLogEntryType.Error,404);
			}
		}
		protected override void OnShutdown()
		{
			try
			{
				base.OnShutdown ();
                envoyerConnexion(false);
                s.Close();
			}
			catch (Exception pb)
			{
				EventLog.WriteEntry("Administration Poste","System.OnShutdown : "+pb.ToString(),EventLogEntryType.Error,405);
			}
		}
	}
}
