using System;
using System.Drawing;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Globalization;
using System.Runtime.InteropServices;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Diagnostics;
using System.Text;

namespace GestionPostes
{
    /// <summary>
    /// Description rsume de Form1.
    /// </summary>
    public class Fm_principal : System.Windows.Forms.Form
    {
        // CONFIGURATION
        string ficPostes = "c:\\config\\postes.txt";
        int numPortService = 65402;
        int numPortGestion = 65400;
        char separateurChar = (char)219;
        // FIN CONFIGURATION

        private System.Windows.Forms.ListBox lb_postes;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Button bt_quitter;
        private System.Windows.Forms.Button bt_testerConnexion;
        private System.Windows.Forms.Button bt_effacerSelection;
        private Button bt_demarrer;
        private Button bt_ghoster;
        private Label label2;
        private Label label3;
        private TextBox tb_sessionsGhost;
        /// <summary>
        /// Variable ncessaire au concepteur.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Fm_principal()
        {
            CheckForIllegalCrossThreadCalls = false;
            //
            // Requis pour la prise en charge du Concepteur Windows Forms
            //
            InitializeComponent();
            init();
        }

        /// <summary>
        /// Nettoyage des ressources utilises.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Code gnr par le Concepteur Windows Form
        /// <summary>
        /// Mthode requise pour la prise en charge du concepteur - ne modifiez pas
        /// le contenu de cette mthode avec l'diteur de code.
        /// </summary>
        private void InitializeComponent()
        {
            this.lb_postes = new System.Windows.Forms.ListBox();
            this.label1 = new System.Windows.Forms.Label();
            this.bt_quitter = new System.Windows.Forms.Button();
            this.bt_testerConnexion = new System.Windows.Forms.Button();
            this.bt_effacerSelection = new System.Windows.Forms.Button();
            this.bt_demarrer = new System.Windows.Forms.Button();
            this.bt_ghoster = new System.Windows.Forms.Button();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.tb_sessionsGhost = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // lb_postes
            // 
            this.lb_postes.Location = new System.Drawing.Point(12, 25);
            this.lb_postes.Name = "lb_postes";
            this.lb_postes.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
            this.lb_postes.Size = new System.Drawing.Size(332, 511);
            this.lb_postes.TabIndex = 3;
            this.lb_postes.SelectedIndexChanged += new System.EventHandler(this.lb_postes_SelectedIndexChanged);
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(16, 6);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(65, 16);
            this.label1.TabIndex = 2;
            this.label1.Text = "Poste";
            // 
            // bt_quitter
            // 
            this.bt_quitter.Location = new System.Drawing.Point(354, 513);
            this.bt_quitter.Name = "bt_quitter";
            this.bt_quitter.Size = new System.Drawing.Size(152, 23);
            this.bt_quitter.TabIndex = 11;
            this.bt_quitter.Text = "Quitter";
            this.bt_quitter.Click += new System.EventHandler(this.bt_quitter_Click);
            // 
            // bt_testerConnexion
            // 
            this.bt_testerConnexion.Location = new System.Drawing.Point(354, 437);
            this.bt_testerConnexion.Name = "bt_testerConnexion";
            this.bt_testerConnexion.Size = new System.Drawing.Size(152, 23);
            this.bt_testerConnexion.TabIndex = 18;
            this.bt_testerConnexion.Text = "Tester les connexions";
            this.bt_testerConnexion.Click += new System.EventHandler(this.bt_testerConnexion_Click);
            // 
            // bt_effacerSelection
            // 
            this.bt_effacerSelection.Location = new System.Drawing.Point(354, 25);
            this.bt_effacerSelection.Name = "bt_effacerSelection";
            this.bt_effacerSelection.Size = new System.Drawing.Size(152, 23);
            this.bt_effacerSelection.TabIndex = 20;
            this.bt_effacerSelection.Text = "Effacer la slection";
            this.bt_effacerSelection.Click += new System.EventHandler(this.bt_effacerSelection_Click);
            // 
            // bt_demarrer
            // 
            this.bt_demarrer.Location = new System.Drawing.Point(354, 408);
            this.bt_demarrer.Name = "bt_demarrer";
            this.bt_demarrer.Size = new System.Drawing.Size(152, 23);
            this.bt_demarrer.TabIndex = 22;
            this.bt_demarrer.Text = "Dmarrer les postes";
            this.bt_demarrer.Click += new System.EventHandler(this.bt_demarrer_Click);
            // 
            // bt_ghoster
            // 
            this.bt_ghoster.Location = new System.Drawing.Point(354, 466);
            this.bt_ghoster.Name = "bt_ghoster";
            this.bt_ghoster.Size = new System.Drawing.Size(152, 23);
            this.bt_ghoster.TabIndex = 23;
            this.bt_ghoster.Text = "Ghoster les postes";
            this.bt_ghoster.Click += new System.EventHandler(this.bt_ghoster_Click);
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(103, 6);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(65, 16);
            this.label2.TabIndex = 24;
            this.label2.Text = "Ghost";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(359, 104);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(90, 13);
            this.label3.TabIndex = 25;
            this.label3.Text = "Sessions GHOST";
            // 
            // tb_sessionsGhost
            // 
            this.tb_sessionsGhost.Location = new System.Drawing.Point(360, 120);
            this.tb_sessionsGhost.Multiline = true;
            this.tb_sessionsGhost.Name = "tb_sessionsGhost";
            this.tb_sessionsGhost.ReadOnly = true;
            this.tb_sessionsGhost.Size = new System.Drawing.Size(140, 89);
            this.tb_sessionsGhost.TabIndex = 26;
            // 
            // Fm_principal
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(518, 542);
            this.Controls.Add(this.tb_sessionsGhost);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.bt_ghoster);
            this.Controls.Add(this.bt_demarrer);
            this.Controls.Add(this.bt_effacerSelection);
            this.Controls.Add(this.bt_testerConnexion);
            this.Controls.Add(this.bt_quitter);
            this.Controls.Add(this.lb_postes);
            this.Controls.Add(this.label1);
            this.Name = "Fm_principal";
            this.Text = "Gestion des postes de travail";
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// Point d'entre principal de l'application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.Run(new Fm_principal());
        }
        [DllImport("user32.dll", EntryPoint = "SendMessage")]
        public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int[] lParam);
        int LB_SETTABSTOPS = 0x0192;
        private List<string> adressesMac = new List<string>();
        private List<string> nomsHote = new List<string>();
        private List<string> sessionGhost = new List<string>();
        private List<string> postesConnectes = new List<string>();
        private Dictionary<string, int> indicePoste = new Dictionary<string, int>();
        private Dictionary<string, IPAddress> adrIpPoste = new Dictionary<string, IPAddress>();
        Socket s;
        EndPoint localEP;
        EndPoint remoteEP;
        byte[] message = new byte[40];

        private IPAddress getAdrIpV4(string hote)
        {
            try
            {
                IPHostEntry ipLocales = Dns.GetHostEntry(hote);
                foreach (IPAddress ip in ipLocales.AddressList)
                {
                    if (ip.AddressFamily == AddressFamily.InterNetwork)
                    {
                        return ip;
                    }
                }
                return null; // aucune adresse IP V4
            }
            catch
            {
                return null; // Echec de la recherche DNS
            }
        }
        private void init()
        {
            int[] tabs ={ 60, 100 };
            SendMessage(lb_postes.Handle, LB_SETTABSTOPS, tabs.Length, tabs);
            StreamReader reader = new StreamReader(ficPostes);
            string ligneConfig;
            string[] configPoste;
            ligneConfig = reader.ReadLine();
            lb_postes.Items.Clear();
            int i = 0;
            while (ligneConfig != null)
            {
                if (ligneConfig != "")
                {
                    configPoste = ligneConfig.Split(new char[] { '/' });
                    adressesMac.Add(configPoste[0].ToUpper());
                    nomsHote.Add(configPoste[2]);
                    sessionGhost.Add(configPoste[3]);
                    indicePoste[configPoste[2]] = i;
                    lb_postes.Items.Add(configPoste[2] + "\t" + configPoste[3] + "\t");
                    i++;
                }
                ligneConfig = reader.ReadLine();
            }
            reader.Close();
            initReception();
            bt_testerConnexion_Click(null, null);
        }
        private void initReception()
        {
            try
            {
                s = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
                IPAddress adrIpLocale = getAdrIpV4(Dns.GetHostName());
                localEP = (EndPoint)new IPEndPoint(adrIpLocale, numPortGestion);
                s.Bind(localEP);
                remoteEP = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
                Array.Clear(message, 0, message.Length);
                s.BeginReceiveFrom(message, 0, 40, SocketFlags.None, ref remoteEP, new AsyncCallback(beginReceiveFrom_CallBack), null);
            }
            catch (Exception pb)
            {
                MessageBox.Show(pb.ToString());
            }
        }
        private void beginReceiveFrom_CallBack(IAsyncResult ar)
        {
            try
            {
                s.EndReceiveFrom(ar, ref remoteEP);
                string strMessage;
                strMessage = Encoding.UTF8.GetString(message, 0, message.Length);
                string[] elements = strMessage.Split(new char[] { separateurChar });
                if (elements[2] == "ok")
                {
                    adrIpPoste[elements[0]] = IPAddress.Parse(elements[1]);
                    changerEtat(elements[0], true);
                }
                else
                {
                    changerEtat(elements[0], false);
                }
                remoteEP = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
                Array.Clear(message, 0, message.Length);
                s.BeginReceiveFrom(message, 0, 40, SocketFlags.None, ref remoteEP, new AsyncCallback(beginReceiveFrom_CallBack), null);
            }
            catch (Exception pb)
            {
                MessageBox.Show(pb.ToString());
            }
        }
        private byte[] sequenceMagique(string adrMac)
        {
            int coefDeplacmt = 0;
            if (adrMac.Length == 17)
            {
                coefDeplacmt = 1;
            }
            int deplact = 0;
            byte[] bytesAdrMac = new byte[6];
            int i = 0;
            for (i = 0; i < 6; i++)
            {
                bytesAdrMac[i] = byte.Parse(adrMac.Substring(2 * i + coefDeplacmt * deplact++, 2), NumberStyles.AllowHexSpecifier);
            }
            byte[] sequence = new byte[102];
            int pos = 0;
            for (pos = 0; pos < 6; pos++)
            {
                sequence[pos] = 255;	// 6 fois "FF"
            }
            int nb = 0;
            pos = 6;
            for (nb = 0; nb < 16; nb++)	// 16 fois l'adresse MAC
            {
                for (i = 0; i < 6; i++)
                {
                    sequence[pos++] = bytesAdrMac[i];
                }
            }
            return sequence;
        }
        private void bt_quitter_Click(object sender, System.EventArgs e)
        {
            Close();
        }
        private void changerEtat(string nomPoste, bool ok)
        {
            if (nomPoste.Substring(0, 5).ToLower() != "image")
            {
                try
                {
                    int i = indicePoste[nomPoste];
                    bool selected = lb_postes.SelectedIndices.Contains(i);
                    string[] elements;
                    string etat;
                    elements = lb_postes.Items[i].ToString().Split(new char[] { '\t' });
                    if (ok)
                    {
                        if (!postesConnectes.Contains(nomPoste))
                        {
                            postesConnectes.Add(nomPoste);
                        }
                        etat = "\t+";
                    }
                    else
                    {
                        postesConnectes.Remove(nomPoste);
                        etat = "\t";
                    }
                    lb_postes.Items[i] = elements[0] + "\t" + elements[1] + etat;
                    lb_postes.SetSelected(i, selected);
                }
                catch (Exception pb)
                {
                    MessageBox.Show(nomPoste + ":" + pb.ToString());
                }
            }
        }
        private void bt_testerConnexion_Click(object sender, System.EventArgs e)
        {
            try
            {
                List<int> selected = new List<int>();
                foreach (int i in lb_postes.SelectedIndices)
                {
                    selected.Add(i);
                }
                string[] elements;
                for (int i = 0; i < lb_postes.Items.Count; i++)
                {
                    elements = lb_postes.Items[i].ToString().Split(new char[] { '\t' });
                    lb_postes.Items[i] = elements[0] + "\t" + elements[1] + "\t";
                }
                byte[] message = new byte[15];
                message = UTF8Encoding.UTF8.GetBytes("testerConnexion");
                Socket s = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
                s.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast, 1);
                IPAddress adrIpLocale = getAdrIpV4(Dns.GetHostName());
                EndPoint localEP = (EndPoint)new IPEndPoint(adrIpLocale, 0);
                s.Bind(localEP);
                EndPoint remoteEP = (EndPoint)new IPEndPoint(IPAddress.Broadcast, numPortService);
                s.SendTo(message, remoteEP);
                s.Close();
                lb_postes.ClearSelected();
                int nbDeconnectes = 0;
                foreach (int i in selected)
                {
                    lb_postes.SetSelected(i, true);
                    if (!postesConnectes.Contains(nomsHote[i]))
                    {
                        nbDeconnectes++;
                    }
                }
                if (nbDeconnectes > 0)
                {
                    MessageBox.Show("Nombre de postes slectionns non connects : " + nbDeconnectes.ToString());
                }
                else
                {
                    if (selected.Count > 0)
                    {
                        MessageBox.Show("Tous les postes slectionns sont connects.");
                    }
                }
            }
            catch (Exception pb)
            {
                MessageBox.Show(pb.ToString());
            }
        }
        private void bt_effacerSelection_Click(object sender, System.EventArgs e)
        {
            lb_postes.ClearSelected();
        }
        private void bt_demarrer_Click(object sender, EventArgs e)
        {
            if (lb_postes.SelectedIndices.Count == 0)
            {
                MessageBox.Show("Aucun poste slectionn !");
            }
            else
            {
                Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Raw, ProtocolType.Raw);
                IPAddress AdrIpLocale = IPAddress.Parse("127.0.0.1");
                IPEndPoint localEP = new IPEndPoint(AdrIpLocale, 0);
                sock.Bind(localEP);
                sock.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast, 1);
                EndPoint remoteEP = (EndPoint)new IPEndPoint(IPAddress.Broadcast, 0);
                byte[] messageBytes;
                foreach (int i in lb_postes.SelectedIndices)
                {
                    messageBytes = sequenceMagique(adressesMac[i].ToString());
                    sock.SendTo(messageBytes, remoteEP);
                }
                sock.Close();
            }
        }

        private void bt_ghoster_Click(object sender, EventArgs e)
        {
            if (lb_postes.SelectedIndices.Count == 0)
            {
                MessageBox.Show("Aucun poste slectionn !");
            }
            else
            {
                byte[] message = new byte[7];
                message = UTF8Encoding.UTF8.GetBytes("ghoster");
                Socket s = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
                IPAddress adrIpLocale = getAdrIpV4(Dns.GetHostName());
                IPAddress adrIpDistante;
                EndPoint localEP = (EndPoint)new IPEndPoint(adrIpLocale, 0);
                s.Bind(localEP);
                foreach (int i in lb_postes.SelectedIndices)
                {
                    if (postesConnectes.Contains(nomsHote[i]))
                    {
                        adrIpDistante = adrIpPoste[nomsHote[i]];
                        EndPoint remoteEP = (EndPoint)new IPEndPoint(adrIpDistante, numPortService);
                        s.SendTo(message, remoteEP);
                    }
                    else
                    {
                        MessageBox.Show("Le poste " + nomsHote[i] + " ne sera pas rinstall car il n'est pas connect.");
                    }
                }
                s.Close();
            }
        }

        private void lb_postes_SelectedIndexChanged(object sender, EventArgs e)
        {
            tb_sessionsGhost.Clear();
            foreach (int i in lb_postes.SelectedIndices)
            {
                if (!tb_sessionsGhost.Text.Contains(sessionGhost[i]))
                {
                    tb_sessionsGhost.Text += sessionGhost[i] + Environment.NewLine;
                }
            }
        }
    }
}
