using System;
using System.IO;
using System.Management;
using System.Management.Instrumentation;
using System.Diagnostics;
using Microsoft.Win32;
using System.Collections;
using System.Threading;

namespace ConfigPoste
{
	/// <summary>
	/// Description rsume de Class1.
	/// </summary>
	class Principal
	{
		/// <summary>
		/// Point d'entre principal de l'application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
            // Configuration
            int numPortService = 65402;
            int numPortGestion = 65400;
            string ficParam = "c:\\config\\param.txt";
			string ficPostes="c:\\config\\postes.txt";
			string ficEtat="c:\\config\\etat.txt";
			string ficErreur="c:\\config\\erreur.txt";
            string ficBootIni = "c:\\config\\boot.ok";
            string cheminShutdown = "c:\\config\\shutdown.exe";
            // Fin de configuration
            StreamReader reader = new StreamReader(ficEtat);
			StreamWriter writer;
            RegistryKey cle;
            try
			{
                // lecture de l'tat de la machine
                string etatMachine = reader.ReadLine();
                reader.Close();
                if (etatMachine != "ok")
                // ne rien faire si le poste est rinstall
				{
                    // lecture des paramtres
                    reader = new StreamReader(ficParam);
                    string nomDomaine = reader.ReadLine();
                    string localUser = reader.ReadLine();
                    string localPassword = reader.ReadLine();
                    string domainUser = reader.ReadLine();
                    string domainPassword = reader.ReadLine();
                    string masque = reader.ReadLine();
                    reader.Close();
                    // Paramtrage
                    Process ps;
                    ProcessStartInfo psInfo;
                    switch (etatMachine)
					{
						case "ghostee":
                            File.Copy(ficBootIni, "c:\\boot.ini", true);
                            // Lecture du fichier des adresses MAC
							Hashtable adresseIP=new Hashtable();
							Hashtable nomPoste=new Hashtable();
							string[] configPoste;
							reader=new StreamReader(ficPostes);
							string ligneConfig;
							ligneConfig=reader.ReadLine();
							while (ligneConfig!=null)
							{
								configPoste=ligneConfig.Split(new char[]{'/'});
								adresseIP.Add(configPoste[0],configPoste[1]);
								nomPoste.Add(configPoste[0],configPoste[2]);
								ligneConfig=reader.ReadLine();
							}
							reader.Close();

							// Modification de l'adresse IP et du nom 
							ManagementScope machine=new ManagementScope("\\\\.\\root\\cimv2");
							string nomMachine = "";
                            string ipMachine = "";

							// Modification de l'adresse IP
							string reqWml="select * from Win32_NetworkAdapterConfiguration where IPEnabled=true";
							ObjectQuery requete=new ObjectQuery(reqWml);
							ManagementObjectSearcher recherche=new ManagementObjectSearcher(machine,requete);
							ManagementObjectCollection resultat=recherche.Get();
							foreach (ManagementObject carteReseau in resultat)	// en pratique une ou deux cartes
							{
                                nomMachine = (string)nomPoste[carteReseau["MACAddress"].ToString().ToUpper()];
                                if (nomMachine!=null)
                                {
                                    ipMachine = (string)adresseIP[carteReseau["MACAddress"].ToString().ToUpper()];
                                    if (ipMachine == "0.0.0.0")
                                    {
                                        // Passage en dhcp
                                        ManagementBaseObject inParams = carteReseau.GetMethodParameters("EnableDHCP");
                                        carteReseau.InvokeMethod("EnableDHCP", inParams, null);
                                    }
                                    else
                                    {
                                        ManagementBaseObject inParams = carteReseau.GetMethodParameters("EnableStatic");
                                        inParams["IPAddress"] = new string[] { ipMachine };
                                        inParams["SubnetMask"] = new string[] { masque };
                                        carteReseau.InvokeMethod("EnableStatic", inParams, null);
                                    }
                                    break;
                                }
							}

							// Modification du nom de la machine
							reqWml="select * from Win32_ComputerSystem";
							requete=new ObjectQuery(reqWml);
							recherche=new ManagementObjectSearcher(machine,requete);
							resultat=recherche.Get();
							foreach (ManagementObject station in resultat)	// en pratique une seule !!!
							{
								ManagementBaseObject inParams=station.GetMethodParameters("Rename");
								inParams["Name"]=nomMachine;
								inParams["Password"]=localPassword;
								inParams["UserName"]=localUser;
								station.InvokeMethod("Rename",inParams,null);
							}

							// Modification de l'tat
							writer=new StreamWriter(ficEtat,false);
							writer.Write("okNomEtAdrIP");
							writer.Close();

							// Redmarrage de la machine
							arreterMachine(cheminShutdown,true); // Reboot forc
							break;

						case "okNomEtAdrIP":                          
                            // Intgration au domaine
							machine=new ManagementScope("\\\\.\\root\\cimv2");
							reqWml="select * from Win32_ComputerSystem";
							requete=new ObjectQuery(reqWml);
							recherche=new ManagementObjectSearcher(machine,requete);
							resultat=recherche.Get();
							foreach (ManagementObject station in resultat)	// en pratique une seule !!!
							{
								ManagementBaseObject inParams=station.GetMethodParameters("JoinDomainOrWorkgroup");
								inParams["AccountOU"]=null;
                                inParams["FJoinOptions"] = 3;
								inParams["Name"]=nomDomaine; 
								inParams["Password"]=domainPassword;
								inParams["UserName"]=domainUser;
								station.InvokeMethod("JoinDomainOrWorkgroup",inParams,null);
							}

                            // Ouverture des ports ncessaires  l'administration distante
                            ps = new Process();
                            psInfo = new ProcessStartInfo("netsh", " firewall add portopening UDP " + numPortGestion + " admPoste1");
                            psInfo.CreateNoWindow = true;
                            psInfo.UseShellExecute = false;
                            ps.StartInfo = psInfo;
                            ps.Start();
                            ps.WaitForExit();
                            ps = new Process();
                            psInfo = new ProcessStartInfo("netsh", " firewall add portopening UDP " + numPortService + " admPoste2");
                            psInfo.CreateNoWindow = true;
                            psInfo.UseShellExecute = false;
                            ps.StartInfo = psInfo;
                            ps.Start();
                            ps.WaitForExit();

                            // suppression du fichier de paramtres
                            File.Delete(ficParam);

                            // Dsactivation de l'ouverture automatique de session
                            cle = Registry.LocalMachine.OpenSubKey("SOFTWARE", true).OpenSubKey("Microsoft", true).OpenSubKey("Windows NT", true).OpenSubKey("CurrentVersion").OpenSubKey("Winlogon", true);
                            cle.SetValue("AutoAdminLogon", "0");
                            cle.SetValue("DefaultPassword", "???");
                            cle.SetValue("DefaultUserName", "???");
                            cle.SetValue("DefaultDomainName", nomDomaine);

                            // Modification de l'tat
                            writer = new StreamWriter(ficEtat, false);
                            writer.Write("ok");
                            writer.Close();
                            arreterMachine(cheminShutdown, false); // PowerOff forc
							break;
                    }
				}
			}
			catch(Exception pb)
			{
				// Mmorisation du message d'erreur
				writer=new StreamWriter(ficErreur,false);
				writer.Write("Erreur : " + pb.ToString());
				writer.Close();

				// Suppression du fichier de paramtrage
				reader.Close();
				File.Delete(ficParam);
			}
		}
		static void arreterMachine(string cheminShutdown, bool reboot)
		{
            Process ps = new Process();
            ProcessStartInfo psInfo;
            if (reboot)
            {
                psInfo = new ProcessStartInfo(cheminShutdown, " -r -f");
            }
            else
            {
                psInfo = new ProcessStartInfo(cheminShutdown, " -u -f");
            }
            psInfo.CreateNoWindow = true;
            psInfo.UseShellExecute = false;
            ps.StartInfo = psInfo;
            ps.Start();
        }
	}
}
