create table Lieu
  (
     id smallint  not null  ,
     libelle varchar(32)  null  ,
     codePostal CHAR(5) NOT NULL,
     telephone CHAR(10) NULL,
     typeLieu CHAR(1) NOT NULL,
     constraint PK_LIEU primary key (id)
  ) 
go

create table Action
  (
     code char(5)  not null  ,
     numeroActivite smallint  not null  ,
     intitule varchar(255) not null  ,
     cout smallint not null  ,
     duree smallint not null  ,
     dateCreation datetime not null ,
     constraint PK_ACTION primary key (code)
  ) 
go

create table Session
  (
     numero smallint identity (1, 1)   ,
     codeAction char(5)  not null  ,
     idLieu smallint  not null  ,
     nombreMaxParticipant smallint not null  ,
     dateSession datetime not null  ,
     coutPrevu decimal(7,2) not null  ,
     coutReel decimal(7,2) null  ,
     forfaitJournalier DECIMAL(6,2) NULL,
     distanceMin INTEGER NULL,
     constraint PK_SESSION primary key (numero)
  ) 
go

create table Agent
  (
     code char(8)  not null  ,
     idAdminLieu  smallint  not null  ,
     civilite char(3) not null  ,
     prenom varchar(32)  not null  ,
     nom varchar(32)  null  ,
     adresse1 varchar(40)  null  ,
     adresse2 varchar(32)  null  ,
     codePostal char(5)  null  ,
     ville varchar(32)  null  ,
     dateNaissance datetime not null  ,
     dateEmbauche datetime not null   ,
     constraint PK_AGENT primary key (code)
  ) 
go

create table Activite
  (
     numero smallint  not null  ,
     libelle varchar(20)  null  ,
     constraint PK_ACTIVITE primary key (numero)
  ) 
go

create table Distance
  (
     idLieuFormation smallint  not null  ,
     idLieuAdministratif smallint  not null  ,
     distanceEntreLieu smallint not null  ,
     constraint PK_DISTANCE primary key (idLieuFormation, idLieuAdministratif)
  ) 
go

create table Inscription
  (
     numeroSession smallint  not null  ,
     codeAgent char(8)  not null  ,
     presence smallint not null default 0,
     fraisHebergement decimal(6,2)  null  ,
     constraint PK_INSCRIPTION primary key (numeroSession, codeAgent)
  ) 
go

CREATE TABLE Parametre(
  id smallint primary key,
  forfaitJournalier DECIMAL(6,2) NOT NULL,
  distanceMin INTEGER NOT NULL
)
go



alter table ACTION 
     add constraint FK_ACTION_ACTIVITE foreign key (numeroActivite) 
               references ACTIVITE (numero)
go

alter table SESSION 
     add constraint FK_SESSION_ACTION foreign key (codeAction) 
               references ACTION (code)
go

alter table SESSION 
     add constraint FK_SESSION_LIEU foreign key (idLieu) 
               references LIEU (id)
go

alter table AGENT 
     add constraint FK_AGENT_LIEU foreign key (idAdminLieu) 
               references LIEU (id)
go

alter table DISTANCE 
     add constraint FK_DISTANCE_LIEU foreign key (idLieuFormation) 
               references LIEU (id)
go

alter table DISTANCE 
     add constraint FK_DISTANCE_LIEU1 foreign key (idLieuAdministratif) 
               references LIEU (id)
go

alter table INSCRIPTION 
     add constraint FK_INSCRIPTION_SESSION foreign key (numeroSession) 
               references SESSION (numero)
go

alter table INSCRIPTION 
     add constraint FK_INSCRIPTION_AGENT foreign key (codeAgent) 
               references AGENT (code)
go

insert into Parametre values(1,54,60);
go

insert into Lieu values(1,'Bergerac','24300','0553222525','A');
insert into Lieu values(2,'Nontron','24300','0553605014','A');
insert into Lieu values(3,'Prigueux','24000','0553027979','F');
insert into Lieu values(4,'Sarlat-la-Canda','24200','0553590021','A');
insert into Lieu values(5,'Terrasson','24500','0553678124','A');
insert into Lieu values(6,'Castillon','33350','0561380074','A');
insert into Lieu values(7,'Arcachon','33120','0524156710','A');
insert into Lieu values(8,'St Andr de Cubzac','33240','0557435611','A');
insert into Lieu values(9,'Bordeaux','33000','0556325000','F');
insert into Lieu values(10,'Langon','33210','0538149570','A');
insert into Lieu values(11,'Libourne','33500','0557550165','A');
insert into Lieu values(12,'Agen','47000','0553778146','F');
insert into Lieu values(13,'Marmande','47200','0558991400','A');
insert into Lieu values(14,'Villeneuve-sur-Lot','47300','0558462655','A');
insert into Lieu values(15,'Bayonne','64100','0559429107','A');
insert into Lieu values(16,'Biarritz','64200','0559438383','A');
insert into Lieu values(17,'St Jean Pied de Port','64450','0559003468','A');
insert into Lieu values(18,'Pau','64000','0559333300','F');
insert into Lieu values(19,'Dax','40100','0538642594','A');
insert into Lieu values(20,'Labouheyre','40300','0538162595','A');
insert into Lieu values(21,'Mont de Marsan','40000','0538361806','F');
insert into Lieu values(22,'Saintes','17100','0561038460','F');
insert into Lieu values(23,'Royan','17200','0561032618','A');
insert into Lieu values(24,'Rochefort','17100','0561319254','A');
insert into Lieu values(25,'La Rochelle','17000','0561003195','A');
insert into Lieu values(26,'Angoulme','16000','0563881904','F');
insert into Lieu values(27,'Cognac','16100','0563830674','A');
insert into Lieu values(28,'Ruffec','16350','0563062219','A');
insert into Lieu values(29,'Montmorillon','86350','0586310688','A');
insert into Lieu values(30,'Poitiers','86000','0586303684','F');
insert into Lieu values(31,'Chtellerault','86100','0586216983','A');
insert into Lieu values(32,'Loudun','86200','0586334821','A');
go

insert into Activite values(1,'Exploitation');
insert into Activite values(2,'Traction');
insert into Activite values(3,'Matriel');
insert into Activite values(4,'Gestion');
insert into Activite values(5,'Voyageurs');
insert into Activite values(6,'Informatique');
go

insert into Action values('E0323',1,'Formation conception des roulements',3870,36,'15/7/2003');
insert into Action values('T0447',2,'Formation conducteur de ligne module 1',5240,84,'30/6/2004');
insert into Action values('T0448',2,'Formation conducteur de ligne module 2',6370,66,'30/6/2004');
insert into Action values('T0449',2,'Formation conducteur de ligne module 3',8430,66,'30/6/2004');
insert into Action values('T0450',2,'Formation conducteur de ligne module 4',9970,60,'30/6/2004');
insert into Action values('T0476',2,'Formation conducteur TGV module 1',15270,120,'14/3/2004');
insert into Action values('T0477',2,'Formation conducteur TGV module 2',15840,120,'14/3/2004');
insert into Action values('T0478',2,'Formation conducteur TGV module 3',16300,120,'14/3/2004');
insert into Action values('T0479',2,'Formation conducteur TGV module 4',18450,120,'14/3/2004');
insert into Action values('T0480',2,'Formation conducteur TGV module 5',20600,120,'14/3/2004');
insert into Action values('E0335',1,'Formation soudeur inox niveau 1',2110,24,'7/10/2003');
insert into Action values('E0336',1,'Formation soudeur inox niveau 2',4230,36,'7/10/2003');
insert into Action values('M0546',3,'Formation gestion de stocks',1750,18,'15/4/2005');
insert into Action values('M0522',3,'Formation paramtrage des stocks',4200,36,'14/9/2005');
insert into Action values('M0475',3,'Formation paramtrage et gestion du rfrentiel de production',5350,36,'5/9/2004');
insert into Action values('M0427',3,'Stocks locaux Module A',1590,24,'16/1/2004');
insert into Action values('M0428',3,'Stocks locaux Module B',2760,24,'16/1/2004');
insert into Action values('M0429',3,'Stocks locaux Module C',3260,24,'16/1/2004');
insert into Action values('V0449',5,'Mener un entretien d''embauche pour technicien d''accueil',5610,42,'2/4/2004');
insert into Action values('V0484',5,'Charg d''accueil et services clientle',4760,42,'19/2/2004');
insert into Action values('G0548',4,'Gestion de sinistres',2870,30,'13/6/2005');
insert into Action values('V0377',5,'Rdacteur au contentieux',1300,18,'12/6/2003');
insert into Action values('V0422',5,'Charg commercial auprs des entreprises',4330,24,'8/10/2004');
insert into Action values('G0376',4,'Formation  l''audit administratif',3550,36,'11/4/2003');
insert into Action values('M0566',3,'Grer le patrimoine Module 1',1050,12,'14/4/2005');
insert into Action values('M0567',3,'Grer le patrimoine Module 2',2170,24,'14/4/2005');
insert into Action values('E0473',1,'Formation topographie pour ingnieur d''tudes',5370,30,'19/1/2004');
insert into Action values('E0311',1,'La matrise d''ouvrages Module 1',1030,12,'15/2/2003');
insert into Action values('E0312',1,'La matrise d''ouvrages Module 2',3390,18,'15/2/2003');
insert into Action values('E0313',1,'La matrise d''ouvrages Module 3',3870,24,'15/2/2003');
insert into Action values('E0322',1,'Formation dessinateur en ouvrage d''art',8360,48,'8/4/2003');
insert into Action values('E0443',1,'Mtreur niveau 1',2990,36,'3/8/2004');
insert into Action values('E0444',1,'Mtreur niveau 2',3630,36,'3/8/2004');
insert into Action values('E0477',1,'Chef de chantier gros uvre',4120,30,'18/10/2004');
insert into Action values('E0453',1,'Charpentier mtallique',4900,42,'3/11/2004');
insert into Action values('E0337',1,'Construction de charpentes bois',5260,42,'20/8/2003');
insert into Action values('E0459',1,'Electricien btiment',5080,48,'17/2/2004');
insert into Action values('E0581',1,'Formation lectricien roulant',1530,12,'14/8/2005');
insert into Action values('E0452',1,'Agent de maintenance matriel roulant',6430,42,'16/10/2004');
insert into Action values('E0449',1,'Agent de maintenance en chauffage',5220,42,'3/6/2004');
insert into Action values('E0385',1,'Formation peintre applicateur de revtements spciaux Niveau 1',1810,18,'10/9/2003');
insert into Action values('E0386',1,'Formation peintre applicateur de revtements spciaux Niveau 2',2080,18,'10/9/2003');
insert into Action values('E0374',1,'Responsable technique de maintenance',7900,54,'12/3/2003');
insert into Action values('E0479',1,'Technicien de maintenance',6730,42,'2/3/2004');
insert into Action values('E0533',1,'Formation chef de chantier roulant',4600,42,'9/8/2005');
insert into Action values('E0347',1,'Formation technicien de chantier roulant',5110,30,'13/12/2003');
insert into Action values('E0425',1,'Formation conducteur de travaux',3430,24,'2/11/2004');
insert into Action values('E0532',1,'Formation Directeur de travaux',1890,12,'17/6/2005');
insert into Action values('E0454',1,'Contrleur de catnaires grandes lignes',2800,18,'6/11/2004');
insert into Action values('E0513',1,'Contrleur de catnaires TGV',2850,18,'11/3/2005');
insert into Action values('E0573',1,'Formation grutier sur voies',3720,36,'3/3/2005');
insert into Action values('E0356',1,'Mcanicien d''engin',1500,12,'11/10/2003');
insert into Action values('G0580',4,'Formation assistant comptable',7740,66,'7/7/2005');
insert into Action values('G0366',4,'Formation comptable module A',1310,18,'17/7/2003');
insert into Action values('G0367',4,'Formation comptable module B',1560,18,'17/7/2003');
insert into Action values('G0363',4,'Contrleur budgtaire',2280,60,'18/3/2003');
insert into Action values('G0579',4,'Contrleur de gestion',1750,12,'12/4/2005');
insert into Action values('I0553',6,'Formation administrateur de bases de donnes',2720,30,'10/7/2005');
insert into Action values('I0456',6,'Formation rseaux informatiques niveau 1',3680,12,'17/8/2004');
insert into Action values('I0562',6,'Formation rseaux informatiques niveau 2',4090,12,'13/9/2005');
insert into Action values('I0357',6,'Formation aux outils bureautiques : Excel module A',1550,12,'19/3/2003');
insert into Action values('I0381',6,'Formation aux outils bureautiques : Excel module B',1760,12,'17/10/2003');
insert into Action values('G0476',4,'Formation assistant commercial auprs de la clientle',4300,48,'6/10/2004');
insert into Action values('G0417',4,'Formation assistant de direction',3380,30,'17/12/2004');
insert into Action values('G0437',4,'Secrtaire comptable',3390,30,'8/6/2004');
insert into Action values('T0431',2,'Formation conducteur de marchandises niveau 1',6140,60,'11/10/2004');
insert into Action values('T0432',2,'Formation conducteur de marchandises niveau 2',7350,60,'11/10/2004');
insert into Action values('T0433',2,'Formation conducteur de marchandises niveau 3',8200,84,'11/10/2004');
insert into Action values('T0330',2,'Formation contrleur sur lignes module A',3660,30,'4/3/2003');
insert into Action values('T0331',2,'Formation contrleur sur lignes module B',4360,30,'4/3/2003');
go

set identity_insert session on
go
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(1,'G0366',9,4,'3/1/2005',68,98.20,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(2,'T0431',3,2,'3/1/2005',762,797.50,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(3,'G0417',9,6,'3/1/2005',644,645.44,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(4,'V0377',9,1,'5/1/2005',108,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(5,'E0356',26,7,'6/1/2005',317,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(6,'E0443',9,8,'10/1/2005',591,831.20,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(7,'I0456',9,5,'10/1/2005',400,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(8,'E0533',9,4,'10/1/2005',235,242.58,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(9,'T0450',22,1,'17/1/2005',413,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(10,'E0459',30,8,'17/1/2005',2392,1620.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(11,'M0566',30,2,'19/1/2005',75,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(12,'E0454',9,6,'19/1/2005',202,200.90,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(13,'G0363',9,3,'24/1/2005',777,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(14,'G0580',9,6,'24/1/2005',619,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(15,'I0357',9,10,'25/1/2005',197,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(16,'I0381',18,10,'25/1/2005',238,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(17,'E0425',18,8,'25/1/2005',1264,1043.82,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(18,'E0581',26,6,'27/1/2005',330,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(19,'T0448',30,2,'31/1/2005',1005,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(20,'T0476',22,2,'31/1/2005',2304,1728.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(21,'T0479',3,1,'31/1/2005',1129,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(22,'T0330',12,4,'31/1/2005',871,848.16,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(23,'I0357',30,10,'3/2/2005',306,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(24,'M0428',30,3,'8/2/2005',320,455.70,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(25,'E0513',21,4,'8/2/2005',446,388.14,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(26,'E0581',9,6,'9/2/2005',360,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(27,'M0546',30,2,'9/2/2005',78,108.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(28,'T0432',9,2,'14/2/2005',637,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(29,'T0433',9,2,'14/2/2005',334,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(30,'E0479',3,7,'14/2/2005',1126,1350.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(31,'E0425',3,8,'15/2/2005',693,790.74,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(32,'I0381',3,10,'17/2/2005',344,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(33,'T0331',30,3,'21/2/2005',476,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(34,'G0476',12,5,'21/2/2005',2436,1620.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(35,'I0553',9,4,'21/2/2005',321,410.96,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(36,'T0447',30,2,'28/2/2005',1610,1188.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(37,'E0459',9,8,'28/2/2005',1339,972.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(38,'E0477',18,4,'28/2/2005',490,778.52,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(39,'V0484',18,5,'28/2/2005',1006,1344.30,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(40,'E0443',9,8,'7/3/2005',637,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(41,'E0347',9,8,'7/3/2005',713,604.04,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(42,'E0479',9,7,'7/3/2005',1360,1312.20,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(43,'E0312',18,6,'8/3/2005',358,407.32,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(44,'E0449',9,4,'14/3/2005',406,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(45,'E0335',30,4,'15/3/2005',269,380.82,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(46,'I0562',9,4,'17/3/2005',210,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(47,'T0331',18,3,'21/3/2005',681,637.52,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(48,'E0322',9,8,'21/3/2005',519,648.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(49,'E0337',30,6,'21/3/2005',720,810.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(50,'E0459',9,8,'21/3/2005',426,324.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(51,'E0477',9,4,'21/3/2005',169,189.48,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(52,'G0437',22,8,'21/3/2005',1728,1455.52,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(53,'I0456',9,5,'22/3/2005',420,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(54,'M0546',18,2,'22/3/2005',76,108.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(55,'E0581',12,8,'23/3/2005',368,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(56,'E0454',12,6,'29/3/2005',323,297.26,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(57,'E0356',21,7,'31/3/2005',336,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(58,'M0566',21,2,'31/3/2005',84,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(59,'E0311',30,6,'31/3/2005',410,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(60,'E0444',9,5,'4/4/2005',251,212.45,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(61,'T0331',12,3,'4/4/2005',253,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(62,'V0484',9,5,'4/4/2005',607,784.74,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(63,'M0427',30,4,'4/4/2005',560,601.26,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(64,'G0437',9,8,'4/4/2005',465,613.16,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(65,'G0548',3,2,'4/4/2005',432,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(66,'V0449',9,2,'4/4/2005',259,270.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(67,'V0377',22,2,'5/4/2005',221,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(68,'E0336',12,4,'11/4/2005',1040,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(69,'T0330',30,4,'11/4/2005',406,648.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(70,'E0347',3,8,'11/4/2005',1375,1195.28,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(71,'E0335',30,4,'12/4/2005',510,477.33,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(72,'G0367',9,3,'13/4/2005',216,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(73,'I0456',9,5,'13/4/2005',380,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(74,'I0357',3,10,'14/4/2005',216,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(75,'T0448',12,2,'18/4/2005',1433,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(76,'T0449',18,1,'18/4/2005',952,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(77,'E0452',3,6,'18/4/2005',1848,1607.40,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(78,'E0453',26,5,'18/4/2005',774,1046.22,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(79,'E0385',22,3,'19/4/2005',199,312.74,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(80,'I0381',30,10,'20/4/2005',255,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(81,'E0322',9,8,'25/4/2005',1465,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(82,'E0477',3,4,'25/4/2005',875,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(83,'G0476',22,5,'25/4/2005',1038,972.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(84,'E0454',3,5,'27/4/2005',398,473.48,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(85,'E0532',3,2,'28/4/2005',104,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(86,'T0480',9,1,'2/5/2005',167,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(87,'E0374',9,4,'2/5/2005',380,378.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(88,'G0376',30,2,'2/5/2005',548,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(89,'G0437',18,8,'2/5/2005',1326,1671.72,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(90,'T0477',3,2,'9/5/2005',2082,1728.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(91,'M0522',18,2,'9/5/2005',412,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(92,'E0454',21,5,'11/5/2005',168,191.08,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(93,'T0431',18,2,'16/5/2005',1081,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(94,'T0331',9,3,'16/5/2005',196,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(95,'E0356',9,7,'16/5/2005',320,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(96,'I0562',9,4,'17/5/2005',210,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(97,'E0444',9,5,'23/5/2005',202,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(98,'I0381',30,10,'30/5/2005',156,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(99,'E0347',9,8,'30/5/2005',251,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(100,'G0366',3,4,'1/6/2005',296,403.92,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(101,'I0456',3,5,'2/6/2005',385,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(102,'E0581',30,8,'2/6/2005',291,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(103,'M0429',22,2,'6/6/2005',229,324.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(104,'E0449',9,4,'6/6/2005',398,270.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(105,'G0417',9,6,'6/6/2005',150,180.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(106,'E0313',26,4,'7/6/2005',558,458.94,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(107,'I0357',3,10,'8/6/2005',261,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(108,'T0478',9,1,'13/6/2005',224,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(109,'E0452',18,6,'13/6/2005',839,1080.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(110,'E0573',18,3,'13/6/2005',515,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(111,'T0447',9,2,'20/6/2005',433,594.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(112,'E0443',9,8,'20/6/2005',479,421.20,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(113,'T0433',9,2,'20/6/2005',1533,1188.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(114,'E0477',12,6,'20/6/2005',731,993.72,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(115,'E0479',9,7,'20/6/2005',1358,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(116,'M0567',30,2,'21/6/2005',285,324.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(117,'E0356',9,7,'22/6/2005',267,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(118,'T0448',18,2,'27/6/2005',992,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(119,'E0425',9,10,'27/6/2005',336,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(120,'V0484',21,5,'27/6/2005',1473,1350.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(121,'T0449',9,1,'4/7/2005',683,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(122,'E0443',26,8,'4/7/2005',2153,1501.15,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(123,'V0422',9,3,'5/7/2005',380,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(124,'T0432',30,2,'11/7/2005',1200,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(125,'E0323',3,4,'11/7/2005',806,648.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(126,'E0459',21,10,'11/7/2005',3460,2586.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(127,'G0437',3,8,'11/7/2005',1203,1253.28,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(128,'E0336',26,3,'18/7/2005',419,635.95,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(129,'E0444',30,5,'18/7/2005',544,419.85,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(130,'E0454',9,5,'19/7/2005',77,108.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(131,'I0357',9,10,'19/7/2005',208,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(132,'I0562',3,4,'22/8/2005',234,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(133,'E0479',9,7,'29/8/2005',579,790.44,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(134,'G0580',9,6,'29/8/2005',892,864.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(135,'V0484',3,5,'29/8/2005',995,1080.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(136,'I0553',9,4,'5/9/2005',199,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(137,'E0386',9,2,'6/9/2005',78,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(138,'E0425',9,10,'6/9/2005',110,162.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(139,'T0330',3,4,'12/9/2005',808,790.28,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(140,'E0374',9,5,'12/9/2005',872,1125.44,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(141,'G0476',9,5,'12/9/2005',333,324.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(142,'G0367',9,3,'14/9/2005',220,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(143,'T0450',3,1,'19/9/2005',431,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(144,'E0444',9,5,'19/9/2005',166,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(145,'E0473',9,2,'19/9/2005',143,216.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(146,'M0522',18,2,'19/9/2005',343,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(147,'G0417',12,6,'26/9/2005',868,985.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(148,'E0335',21,5,'3/10/2005',760,810.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(149,'I0562',21,4,'3/10/2005',241,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(150,'G0548',30,2,'3/10/2005',403,372.36,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(151,'T0330',3,4,'10/10/2005',810,779.28,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(152,'I0381',12,10,'13/10/2005',301,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(153,'E0336',30,3,'17/10/2005',459,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(154,'I0553',9,4,'17/10/2005',207,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(155,'E0477',9,6,'24/10/2005',523,432.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(156,'G0579',22,2,'26/10/2005',112,0.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(157,'E0347',12,8,'14/11/2005',382,562.32,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(158,'E0453',3,5,'14/11/2005',1482,1350.00,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(159,'V0449',26,2,'14/11/2005',505,518.10,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(160,'T0447',12,2,'21/11/2005',460,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(161,'E0452',9,6,'21/11/2005',1064,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(162,'M0567',9,2,'28/11/2005',220,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(163,'M0475',30,3,'28/11/2005',306,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(164,'E0533',26,4,'5/12/2005',468,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(165,'M0546',9,2,'5/12/2005',80,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(166,'E0513',9,4,'6/12/2005',368,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(167,'E0581',12,8,'7/12/2005',408,Null,54,60);
insert into Session (numero, codeAction, idLieu, nombreMaxParticipant, dateSession, coutPrevu, coutReel, forfaitJournalier, distanceMin) values(168,'M0427',30,4,'13/12/2005',361,Null,54,60);
go
set identity_insert session off
go

insert into Agent values('5517282W',1,'M.','Jean Yves','Etienne','GAUJAC ','ST ROMAIN DE MONPAZIER','24540','MONPAZIER','23/2/1955','1/3/1983');
insert into Agent values('8254566E',1,'Mme','Valrie','Davion','8 RUE ALPHONSE DAUDET','','24600','RIBERAC','11/8/1982','1/3/2001');
insert into Agent values('5510841V',1,'M.','Hugues','Bee','LES COTEAUX','ST ANTOINE DE BREUILH','24230','VELINES','20/7/1955','1/4/1986');
insert into Agent values('7764660Y',2,'Mme','Virginie','Fournial','LE BOURG','','24640','CUBJAC','10/1/1977','1/2/1996');
insert into Agent values('8238335M',2,'Mme','Christelle','Maingaud','LE PETIT BARDOT','ST AUBIN DE CADELECH','24500','EYMET','20/9/1982','1/4/2003');
insert into Agent values('6560748Y',2,'Mme','Sandrine','Gomez','LACHENAL, ANNESSE ET BEAULIEU','','24430','RAZAC','25/5/1965','1/9/1987');
insert into Agent values('7193988C',3,'M.','Guillaume','Rapon','LE PRIEURE ','ST CAPRAISE D''EYMET','24500','EYMET','4/5/1971','1/11/1992');
insert into Agent values('7478532P',3,'M.','Olivier','Duchemin','31 RUE SEVENE','','24000','PERIGUEUX','26/8/1974','1/4/1994');
insert into Agent values('7754232N',3,'M.','Bertrand','Moreno','MONTANCEIX','ROUTE DE MONTREM','24110','SAINT ASTIER','5/7/1977','1/5/1999');
insert into Agent values('7311462R',3,'Mme','Sophie','Bellanger','LES MOLLES ','','24220','SAINT CYPRIEN','12/4/1973','1/9/1997');
insert into Agent values('7346037Y',3,'M.','Stphane','Nissack','70 BLD JOHN KENNEDY','','24750','TRELISSAC','28/2/1973','1/9/1995');
insert into Agent values('7696789A',4,'Mme','Nathalie','Mormin','9 ALLEE DES ORMEAUX','','24750','CHAMPCEVINEL','19/9/1976','1/3/1999');
insert into Agent values('6993559V',4,'Mme','Marie Elodie','Peyraud','LE COUSTAL LA CANEDA','','24200','SARLAT','28/8/1969','1/3/1993');
insert into Agent values('6308398E',5,'M.','Jean Marc','Mauduit','MAISON NEUVE','','24750','CHAMPCEVINEL','18/11/1963','1/8/1989');
insert into Agent values('5316900P',5,'Mme','Sandrine','Taxile','LA CHARTREUSE  RN 21','LES FARGUES DU PIC','24660','NOTRE DAME DE SAVILLE','29/5/1953','1/7/1976');
insert into Agent values('8058123E',6,'Mme','Christelle','Mounie','3 CHEMIN DE LA FORET','','33480','AVENSAN','15/2/1980','1/11/2001');
insert into Agent values('7750860Y',6,'Mme','Delphine','Brand','ROUTE DE BORDEAUX','','33430','BAZAS','17/8/1977','1/1/1999');
insert into Agent values('8133999D',6,'Mme','Stphanie','Lopez','14 CHEMIN DES TANNERIES','','33410','BEGUERY-CADILLAC','14/7/1981','1/8/2001');
insert into Agent values('6086843J',6,'Mme','Marie Pierre','Tabourel','LA MOULEYRE ','','33540','BLASIMON','19/4/1960','1/12/1988');
insert into Agent values('7793176U',6,'Mme','Katia','Otero','PLACE DES CAPUCINS','','33410','CADILLAC S/GARONNE','23/11/1977','1/1/1999');
insert into Agent values('7642838H',6,'M.','Gery','Algudo','65 RUE HENRI DE FRANCE','','33880','CAMBES','10/4/1976','1/1/1998');
insert into Agent values('8189739Q',6,'Mme','Sverine','Chateauneuf','25 ROUTE DE MEYNAC','','33360','CAMBLANES','2/5/1981','1/3/2002');
insert into Agent values('7500803X',6,'M.','Eric','Oheix','3 CHEMIN DU CARAT','','33360','CAMBLANES','8/11/1975','1/12/1999');
insert into Agent values('5373401D',6,'M.','Stphane','Doillon','6 ALLE DU MOULIN DE SONNEY','','33360','CARIGNAN','11/9/1953','1/12/1985');
insert into Agent values('6282947Q',6,'M.','Stphane','Mefalezi','57 ROUTE DE LATRESNE','','33360','CARIGNAN','7/4/1962','1/9/1983');
insert into Agent values('8139425B',6,'Mme','Chrystel','Migaud','6 ALLEE DU MOULIN DE SONNEY','','33360','CARIGNAN','20/11/1981','1/5/2000');
insert into Agent values('7944901M',6,'M.','Jean Christophe','Lascols','LA TUILERIE ','GARDEGAN','33350','CASTILLON','10/1/1979','1/10/2000');
insert into Agent values('6540490D',6,'Mme','Magali','Bilounga','18 CHEMIN DE SEMENSAN','','33590','JAU-DIGNAC-LOIRAC','12/2/1965','1/8/1993');
insert into Agent values('6963884P',6,'Mme','Batrice','Leroy','LIEU DIT  PEYMAUD ','','33750','NERIGEAN','24/7/1969','1/11/1997');
insert into Agent values('7707777U',6,'M.','Michael','Chaperon','LIEU DIT PERINOT','','33750','ST QUENTIN DE BARON','29/12/1977','1/7/2001');
insert into Agent values('7838676A',6,'M.','Thomas','Desenne','N 4 BARBOT EST','','33220','ST QUENTIN DE CAPLON','17/8/1978','1/2/2001');
insert into Agent values('5542593H',6,'M.','Jean Franois','Tomona','ROUTE DE BERGERAC','VINEUILH','33220','STE FOY LA GRANDE','27/1/1955','1/6/1979');
insert into Agent values('7644063P',7,'Mme','Karine','Beaufort','LOTISSEMENT DU PAGE','8 ALLEE DE LA PINEDE','33510','ANDERNOS','17/10/1976','1/9/1996');
insert into Agent values('5646951Q',7,'M.','Bruno','Guichard','11 AVENUE GUSTAVE EIFFEL','','33510','ANDERNOS','22/9/1956','1/7/1984');
insert into Agent values('8172625N',7,'Mme','Caroline','Malbat','28 AVENUE JEAN BAPTISTE LULLY','','33510','ANDERNOS','15/8/1981','1/2/2004');
insert into Agent values('5771041W',7,'Mme','Virginie','Adhead','49 BLD DU GAL LECLERC','','33120','ARCACHON','19/8/1957','1/12/1986');
insert into Agent values('5369349Z',7,'Mme','Christelle','Hulne','186 BLD DE LA COTE D''ARGENT','','33120','ARCACHON','17/3/1953','1/7/1990');
insert into Agent values('6220281A',7,'M.','Jrome','Alligner','10 AV DE L''AMASSE','','33610','CESTAS','16/1/1962','1/4/1988');
insert into Agent values('7576632V',7,'Mme','Nathalie','Brougat','26 ALLE DU ROUQUET','','33610','CESTAS','6/6/1975','1/10/1995');
insert into Agent values('6778779N',7,'Mme','Valrie','Dillmann','19 CHEMIN DE LA LOUVETIERE','','33610','CESTAS','22/3/1967','1/11/1995');
insert into Agent values('6586198L',7,'Mme','Sverine','Duffour','6 ALLEE DES GALIPS','','33610','CESTAS','20/2/1965','1/2/1986');
insert into Agent values('7869621L',7,'M.','Jean Franois','Dufourg','19 CHEMIN DE LA LOUVETIERE','','33610','CESTAS','12/3/1978','1/8/1999');
insert into Agent values('6682067R',7,'Mme','Jose','Fekkane','42 AV DE L''AMASSE','','33610','CESTAS','15/4/1966','1/7/1986');
insert into Agent values('5783214C',7,'M.','Richard','Tora','22 ALLEE DU PAS DU RENARD','','33610','CESTAS','19/4/1957','1/6/1977');
insert into Agent values('7466117V',7,'Mme','Sverine','Bunel','187 AVENUE DE L''HIPPODROME','','33320','EYSINES','30/11/1974','1/3/1995');
insert into Agent values('7351040L',7,'M.','Laurent','Van Campenhout','19 RUE DE LA RENAISSANCE','','33320','EYSINES','21/10/1973','1/3/1998');
insert into Agent values('6688548L',7,'Mme','Sandrine','Bilhere','6 ALLEE DU MUGUET','','33170','GRADIGNAN','24/12/1966','1/6/1996');
insert into Agent values('5895986F',7,'Mme','Laurence','Brodur','3 ALLEE PIERRE DAC','','33170','GRADIGNAN','3/12/1958','1/8/1984');
insert into Agent values('5380675K',7,'M.','Jean','Campos','26 ALLEE DU MOULIN DE CAZAU','','33170','GRADIGNAN','15/8/1953','1/2/1975');
insert into Agent values('6702307R',7,'Mme','Claire','Labbe','RESIDENCE DU PARC BAT A','AVENUE CHARLES DE GAULLE','33170','GRADIGNAN','27/10/1967','1/5/1995');
insert into Agent values('5842699K',7,'Mme','Nathalie','Benmoussa','17 COURS DE LA MARNE','','33470','GUJAN MESTRAS','16/9/1958','1/12/1979');
insert into Agent values('6561519L',7,'Mme','Sandrine','Larrieu','34 ALLEE FRANCOIS MAURIAC','','33470','GUJAN MESTRAS','18/3/1965','1/6/1992');
insert into Agent values('6627296H',7,'Mme','Sandra','Fiers','46 CHEMIN DES FACTEURS','','33260','LA TESTE','12/2/1966','1/11/1992');
insert into Agent values('6530689A',7,'Mme','Sandra','Serra','46 RUE JEAN MOULIN','','33260','LA TESTE','18/1/1965','1/11/1992');
insert into Agent values('6293908E',7,'Mme','Sverine','Danis','662 ALLEE MONTESQUIEU','','33290','LE PIAN MEDOC','28/9/1962','1/1/1986');
insert into Agent values('5841080A',7,'M.','Jean Paul','Foubert','1129 ALLEE DES BRUYERES','FEYDIEU','33290','LE PIAN MEDOC','16/4/1958','1/12/1987');
insert into Agent values('7879178Z',7,'Mme','Carine','Dorr','14 RUE DU PONT NEUF','','33470','LE TEICH','12/10/1978','1/10/2003');
insert into Agent values('6281459Y',7,'Mme','Laurence','Borel','39 ROUTE DE MIQUEU','ST GERMAIN D''ESTEUIL','33340','LESPARRE','26/5/1962','1/8/1989');
insert into Agent values('7968655G',7,'Mme','Nathalie','Avril','31 AVENUE DES CHENES','','33700','MERIGNAC','10/5/1979','1/7/2004');
insert into Agent values('5639922A',7,'Mme','Christine','Pasquier','PARC DE CAPEYRON','12 RUE DES CEPAGES','33700','MERIGNAC','23/2/1956','1/10/1979');
insert into Agent values('6877795P',7,'Mme','Marine','Amice','33 BD DE LADORNE','','33600','PESSAC','28/3/1968','1/6/1995');
insert into Agent values('6174331E',7,'Mme','Sandrine','Cassagne','RES TOURNEBRIDE APP 22BIS','','33600','PESSAC','17/5/1961','1/9/1981');
insert into Agent values('5361186B',7,'M.','Frderic','Kettelbutter','2 RUE DE LOS ANGELES','','33600','PESSAC','29/7/1953','1/6/1978');
insert into Agent values('8467597K',7,'Mme','Caroline','Etcheverry','31 BD DES CRETS','DOMAINE DE LA FORET','33115','PYLA SUR MER','21/11/1984','1/3/2005');
insert into Agent values('7327694K',7,'M.','Alexandre','Pailler','4 LA PROVENCE','','33490','SAINT MAIXANT','10/4/1973','1/8/1995');
insert into Agent values('8350816Z',7,'Mme','Sylvie','Brechaire','RES ST MARTIN II','BAT 10 APPT 56','33140','VILLENAVE D''ORNON','31/12/1983','1/7/2002');
insert into Agent values('5701341K',7,'Mme','Emmanuelle','Bureau','54 RUE COMBACET','','33140','VILLENAVE D''ORNON','18/6/1957','1/7/1979');
insert into Agent values('6660800A',7,'Mme','Sandrine','Geldy','17 RUE CAMILLE DESMOULINS','','33140','VILLENAVE D''ORNON','24/7/1966','1/6/1990');
insert into Agent values('7516105E',8,'Mme','Valrie','Francois','LIEU DIT CHAUVET','','33440','AMBARES','20/8/1975','1/6/2001');
insert into Agent values('7975908Q',8,'M.','Xavier','Sardain','14 HAMEAU DE LA CLAIRIERE','','33440','AMBARES','10/4/1979','1/5/1998');
insert into Agent values('7540751U',8,'M.','Jrome','Tesseron','2 AVENUE DE LA GARONNE -','ST LOUIS DE MONTFERRAUD','33440','AMBARES','16/8/1975','1/4/1996');
insert into Agent values('8045964N',8,'M.','Thierry','Dupas','79 RUE DE L''HOPITAL','','33390','BLAYE','14/5/1980','1/9/2004');
insert into Agent values('6573279U',8,'M.','Stphane','Queva','19 RUE URBAIN CHASSELOUP','','33390','BLAYE','19/5/1965','1/1/1988');
insert into Agent values('7831940D',8,'M.','Raphael','Matusiak','47 RUE VALENTIN BERNARD','','33710','BOURG S/GIRONDE','30/5/1978','1/12/2000');
insert into Agent values('5916945M',8,'M.','Rodolphe','Thevenet','12 HAMEAU BOUTINEAU','','33620','CAVIGNAC','7/9/1959','1/8/1981');
insert into Agent values('6431481Q',8,'M.','Jean Philippe','Abdi','1 AVENUE LEO LAGRANGE','','33110','LE BOUSCAT','29/2/1964','1/9/1988');
insert into Agent values('7535106H',8,'M.','Raphael','Mazens','38 RUE PASTEUR','','33110','LE BOUSCAT','8/6/1975','1/2/1998');
insert into Agent values('7784916Q',8,'M.','Benoit','Champion','33 RUE ROBILLARD','','33240','ST ANDRE DE CUBZAC','18/9/1977','1/5/1997');
insert into Agent values('8275121X',8,'M.','Yong','Ly','ST GENES DE FRONSAC','','33240','ST GENES DE FRONSAC','1/6/1982','1/3/2001');
insert into Agent values('8073747M',8,'M.','Edward','Juy','8 AVENUE GINETTE MAROIS','','33148','TAUSSAT','3/2/1980','1/3/1998');
insert into Agent values('7599760J',9,'Mme','Batrice','Delvaux','32 ALLEE DU COMPTE','','33460','ARSAC','20/6/1975','1/4/1996');
insert into Agent values('7183178C',9,'Mme','Karine','Jean','21 RUE ALBERT THOMAS','','33130','BEGLES','30/1/1971','1/1/1989');
insert into Agent values('7281770T',9,'Mme','Sandrine','Lefevre','199 BLD ALBERT 1ER','','33130','BEGLES','6/11/1972','1/8/1994');
insert into Agent values('5983559U',9,'M.','Thierry','Akakpo','RES PETIT FONGRAVEY','AV DU 11 NOVEMBRE','33290','BLANQUEFORT','16/5/1959','1/4/1981');
insert into Agent values('6565428K',9,'Mme','Laure','Duchaufour','25 AVENUE DE L''EUROPE','','33290','BLANQUEFORT','22/1/1965','1/12/1990');
insert into Agent values('8086443M',9,'Mme','Caroline','Foutrier','RUE DES JONQUILLES N 11','LE VERSANT','33290','BLANQUEFORT','7/7/1980','1/5/2000');
insert into Agent values('5258943T',9,'M.','Benoit','Haquet','13 RUE CHARLES GOUNOD','','33290','BLANQUEFORT','21/11/1952','1/6/1976');
insert into Agent values('7526716N',9,'M.','Serge','Reis Pinto','14 RUE GEORGE SAND','','33290','BLANQUEFORT','4/3/1975','1/4/2002');
insert into Agent values('7459234N',9,'M.','Fabien','Venere','817 RUE MONTAIGNE','LE PIAN MEDOC','33290','BLANQUEFORT','2/12/1974','1/10/1995');
insert into Agent values('7190584C',9,'Mme','Vanessa','Amar','15 RUE DE LANDIRAS','','33000','BORDEAUX','16/4/1971','1/5/1995');
insert into Agent values('8318150T',9,'Mme','Fairouz','Auger','44 RUE RODRIGUES PEREIRE','','33000','BORDEAUX','2/2/1983','1/11/2003');
insert into Agent values('5526502T',9,'Mme','Catherine','Bachelot','57 RUE A.MAGINOT','36 RES ANTINEA','33200','BORDEAUX','11/10/1955','1/1/1986');
insert into Agent values('6071993T',9,'Mme','Frdrique','Barre','7 PLACE DE L''EGLISE ST AUGUSTIN','','33000','BORDEAUX','23/4/1960','1/12/1985');
insert into Agent values('7141033T',9,'M.','Guillaume','Barthalay','64 RUE ROSA BONHEUR','','33000','BORDEAUX','5/2/1971','1/2/1991');
insert into Agent values('7715615N',9,'Mme','Anne','Bazin','49 RUE CADROIN','','33000','BORDEAUX','29/3/1977','1/12/1998');
insert into Agent values('6345507Q',9,'Mme','Anne Sandra','Beteille','16 RUE MARSAN','','33000','BORDEAUX','5/9/1963','1/7/1990');
insert into Agent values('5271776R',9,'Mme','Karine','Bettcher','32 RUE LOUIS MIE','','33000','BORDEAUX','16/11/1952','1/6/1974');
insert into Agent values('7705335P',9,'M.','Lionel','Blouin','58 RUE LEYTEIRE','','33000','BORDEAUX','27/3/1977','1/2/1997');
insert into Agent values('8512520P',9,'Mme','Cendrine','Boissier','126/128  RUE BELLEVILLE','APPT 22 RUE BELLEVILLE','33000','BORDEAUX','8/5/1985','1/10/2004');
insert into Agent values('6346754W',9,'M.','Jean Franois','Bougault','39 TER RUE WALTER POUPOT','','33000','BORDEAUX','29/8/1963','1/8/1984');
insert into Agent values('7551507K',9,'Mme','Christine','Bouget','20 RUE ROGER MIRASSOU','','33800','BORDEAUX','7/8/1975','1/11/1998');
insert into Agent values('6460394T',9,'Mme','Stphanie','Bouvet','4 RUE CHARLES LEVEQUE','','33000','BORDEAUX','3/5/1964','1/7/1993');
insert into Agent values('8058465B',9,'Mme','Sybille','Cabot','114 RUE DE LA BENAUGE','','33100','BORDEAUX','2/8/1980','1/12/2001');
insert into Agent values('6238651T',9,'Mme','Sylvie','Campet','24 RUE RAYMOND BORDIER','','33200','BORDEAUX','5/10/1962','1/12/1990');
insert into Agent values('6306978L',9,'Mme','Murielle','Carabin','7 RUE DE LA CROIX BLANCHE','','33000','BORDEAUX','19/6/1963','1/6/1992');
insert into Agent values('5806661N',9,'M.','Jean Claude','Chadouteau','71 RUE MONDENARD','','33000','BORDEAUX','11/1/1958','1/1/1980');
insert into Agent values('8563996R',9,'Mme','Dominique','Chagnaud','RES. LES TRIADES - BAT A','35 RUE DE LALANDE','33000','BORDEAUX','5/6/1985','1/7/2004');
insert into Agent values('6858363T',9,'Mme','Laurence','Chailloux','31-33 RUE PAULINE KERGOMARD','','33000','BORDEAUX','15/12/1968','1/7/1995');
insert into Agent values('7702013D',9,'M.','Frderic','Chaissac','12 RUE PASCAL MOTHES','','33800','BORDEAUX','25/9/1977','1/8/1998');
insert into Agent values('5314211R',9,'Mme','Cline','Chouraqui','36 RUE GINER DE LOS RIOS','','33800','BORDEAUX','23/8/1953','1/3/1982');
insert into Agent values('6051031H',9,'Mme','Rachel','Chrismant','23 BIS RUE DU DR ROUX','','33200','BORDEAUX','16/2/1960','1/9/1984');
insert into Agent values('6297469A',9,'M.','Yann','Clair','17 PLACE DES QUINCONCES','','33000','BORDEAUX','7/7/1962','1/5/1986');
insert into Agent values('7676645E',9,'Mme','Delphine','Coeffe','7 PLACE DU CHAMP DE MARS','','33000','BORDEAUX','24/5/1976','1/7/2001');
insert into Agent values('8007349Q',9,'Mme','Ccile','Cosme','20 AVENUE EMILE COUNORD','RES DU JARDIN PUBLIC','33300','BORDEAUX','13/10/1980','1/8/2001');
insert into Agent values('6220726J',9,'M.','Jean Franois','Daganaud','27 RUE DE GRASSI','','33000','BORDEAUX','13/3/1962','1/1/1986');
insert into Agent values('7466416V',9,'M.','Guillaume','Dagnas','RES LE PONANT-BAT B - APT 229','LES TERRASSES DU 8 MAI 45','33100','BORDEAUX','24/11/1974','1/9/1997');
insert into Agent values('8164504L',9,'Mme','Graldine','Damnanville','187 RUE DU JARDIN PUBLIC','','33000','BORDEAUX','29/6/1981','1/12/2001');
insert into Agent values('5723379P',9,'Mme','Paula','De Souza','8 RUE DES CORDELIERS','','33000','BORDEAUX','23/4/1957','1/4/1976');
insert into Agent values('5466810K',9,'Mme','Cline','Dechazal','69 RUE LACANAU','','33200','BORDEAUX','16/1/1954','1/5/1982');
insert into Agent values('7456791H',9,'Mme','Nathalie','Delhomme','42 RUE FERBEYRE','','33200','BORDEAUX','16/12/1974','1/2/1997');
insert into Agent values('5518628J',9,'Mme','Claire','Deney','26 RUE CASTEJA','','33000','BORDEAUX','10/5/1955','1/1/1985');
insert into Agent values('6889873T',9,'Mme','Sandrine','Devaud','33 RUE NOTRE DAME','','33000','BORDEAUX','30/6/1968','1/3/1989');
insert into Agent values('8176007P',9,'M.','Pierre','Doukakis','323 AV DE LATTRE DE TASSIGNY','APPT 54','33200','BORDEAUX','21/9/1981','1/11/2000');
insert into Agent values('8100862K',9,'Mme','Vronique','Dupont','3 RES. MAHELA n 233','2 TER RUE DE BETHMANN','33000','BORDEAUX','17/8/1981','1/8/2002');
insert into Agent values('5538883A',9,'M.','Sylvain','Duteuil','18 CITE MOUNEYRA  APPT 12','','33000','BORDEAUX','6/11/1955','1/6/1990');
insert into Agent values('5720118V',9,'M.','Johann','Faux','11 RUE DARNAL','','33000','BORDEAUX','24/9/1957','1/12/1981');
insert into Agent values('8016017M',9,'Mme','Laurence','Fazio','58 RUE MAZARIN','','33000','BORDEAUX','11/4/1980','1/3/2000');
insert into Agent values('8275094T',9,'Mme','Sophie','Fernandez','61 RUE ULYSSE GAYON','','33000','BORDEAUX','24/9/1982','1/4/2003');
insert into Agent values('6202630P',9,'Mme','Asma','Ferriere','4 RUE CRUCHINET','','33800','BORDEAUX','26/7/1962','1/4/1986');
insert into Agent values('6439971U',9,'M.','Stphane','Flebus','202 RUE DE PESSAC','APPT 25','33000','BORDEAUX','26/7/1964','1/7/1985');
insert into Agent values('5903176W',9,'M.','Ludovic','Fontaine','45 RUE VITAL CARLES','','33000','BORDEAUX','7/12/1959','1/4/1994');
insert into Agent values('6539439L',9,'M.','Gilles','Fontes','12 RUE CHARLES MONSELET','','33000','BORDEAUX','1/1/1965','1/8/1988');
insert into Agent values('6140875P',9,'M.','David','Fort','77 RUE KLEBER','','33800','BORDEAUX','16/10/1961','1/11/1982');
insert into Agent values('6382597F',9,'M.','Hassan','Francais','98 COURS ALSACE LORRAINE','5 ETAGE RESIDENCE SIBAL','33000','BORDEAUX','21/5/1963','1/2/1991');
insert into Agent values('5720574Q',9,'Mme','Christine','Fromentiere','12 RUE PORTE DE LA MONNAIE','','33800','BORDEAUX','23/9/1957','1/2/1986');
insert into Agent values('5728436L',9,'M.','Stphane','Gimel','33 RUE GOUAIS LAMOS - LE CLOS','ST AUGUSTIN BAT B N228','33000','BORDEAUX','19/5/1957','1/10/1988');
insert into Agent values('7950856K',9,'M.','Christophe','Ginocchio','8 RUE BRIZARD','','33000','BORDEAUX','8/12/1979','1/2/2002');
insert into Agent values('6874992T',9,'M.','Franck','Glath','1 RUE PORTES DE CAUDERAN','','33200','BORDEAUX','19/3/1968','1/7/1989');
insert into Agent values('8086567X',9,'M.','Thierry','Grandeau','146 RUE DU PALAIS GALLIEN','','33000','BORDEAUX','13/12/1980','1/12/2001');
insert into Agent values('7532892B',9,'M.','Franck','Grandis','31 RUE BREMONTIER','','33800','BORDEAUX','8/12/1975','1/8/2003');
insert into Agent values('5791758P',9,'Mme','Agns','Grandmougin','61 RUE DE CARDOZE','','33200','BORDEAUX','6/9/1957','1/9/1995');
insert into Agent values('8196193F',9,'M.','Thierry','Gras','33 RUE BOUFFARD','','33000','BORDEAUX','12/6/1981','1/7/2003');
insert into Agent values('5855699Q',9,'Mme','Corine','Grignon','100 RUE DE LASEPPE','RES ST JAMES APPT 35','33000','BORDEAUX','15/7/1958','1/2/1979');
insert into Agent values('7823055W',9,'M.','Jrome','Grize','160 RUE PASTEUR','RESIDENCE LES FONTAINES','33200','BORDEAUX','14/9/1978','1/6/2001');
insert into Agent values('7126217N',9,'M.','Roger','Guenou','10 RUE ERNEST RENAN','','33000','BORDEAUX','12/3/1971','1/8/1993');
insert into Agent values('5669158D',9,'M.','Stphane','Harribey','33 RUE JIEL-LAVAL','','33200','BORDEAUX','20/4/1956','1/7/1992');
insert into Agent values('8477522Y',9,'Mme','Virginie','Hein','48 AVENUE CARNOT','','33200','BORDEAUX','24/6/1984','1/5/2004');
insert into Agent values('8033759X',9,'M.','Cyrille','Henaux','57 RUE DU TONDU','','33000','BORDEAUX','8/8/1980','1/3/2001');
insert into Agent values('6744846E',9,'Mme','Delphine','Heraud','15 RUE ROCHAMBEAU','','33000','BORDEAUX','19/6/1967','1/9/1998');
insert into Agent values('7955296L',9,'Mme','Sandrine','Iriberri','RESIDENCE MARLY','178 RUE STEHELIN','33200','BORDEAUX','12/5/1979','1/4/2002');
insert into Agent values('7657837L',9,'M.','Nicolas','Jacqueline','12 RUE TOUR DE GASSIES','','33000','BORDEAUX','16/3/1976','1/2/1999');
insert into Agent values('6635724U',9,'Mme','Linda','Jambon','49 RUE DU CHALET','RESIDENCE LA TEOULERE','33000','BORDEAUX','9/8/1966','1/5/1986');
insert into Agent values('6338288U',9,'Mme','Karine','Jean','317 AV MARECHAL DE LATTRE DE','TASSIGNY','33200','BORDEAUX','9/5/1963','1/7/1985');
insert into Agent values('8156278V',9,'Mme','Anne Genevieve','Joubert','135 RUE DE KATER','','33000','BORDEAUX','6/5/1981','1/1/2002');
insert into Agent values('7635237W',9,'Mme','Marie','Kamoizan','5 RUE DE LA ROUSSELLE','','33000','BORDEAUX','30/7/1976','1/2/1996');
insert into Agent values('8379854M',9,'M.','Emmanuel','Kesteloot','48 AVENUE CARNOT','','33200','BORDEAUX','3/1/1983','1/2/2003');
insert into Agent values('6761916J',9,'M.','David','Kouakou','18 RUE SULLIVAN APPT 7','','33000','BORDEAUX','26/3/1967','1/11/1986');
insert into Agent values('5927155K',9,'Mme','Nathalie','Kpenou','21 IMPASSE STE URSULE','RESIDENCE ATHENE APPT 281','33000','BORDEAUX','19/2/1959','1/1/1994');
insert into Agent values('6518861U',9,'M.','Laurent','Labat','56 ALLEE DE TOURNY','','33000','BORDEAUX','11/2/1965','1/10/1984');
insert into Agent values('6831956P',9,'Mme','Valrie','Lacroix','39 RUE D''AUSTERLITZ','RES MIRO - APT 15','33200','BORDEAUX','16/3/1968','1/10/1994');
insert into Agent values('6506338G',9,'M.','Alexandre','Lafitte','90 RUE ERNEST RENAN','','33000','BORDEAUX','17/3/1965','1/6/1984');
insert into Agent values('5363278A',9,'Mme','Marie Caroline','Landais','162 RUE DAVID JOHNSTON','','33000','BORDEAUX','2/4/1953','1/1/1977');
insert into Agent values('8175321U',9,'Mme','Karine','Lanouhe','33 RUE ST REMI','','33000','BORDEAUX','17/11/1981','1/3/2003');
insert into Agent values('6459452U',9,'Mme','Pascale','Larrieu','4 PASSAGE DES MARRONNIERS','','33000','BORDEAUX','28/8/1964','1/4/1987');
insert into Agent values('8160529Q',9,'M.','Gwenael','Lautric','12 RUE ARAGO','','33300','BORDEAUX','5/10/1981','1/3/2001');
insert into Agent values('7515501Y',9,'M.','Bernard','Le Cam','16 RUE POUDESSAN','','33000','BORDEAUX','5/11/1975','1/12/1996');
insert into Agent values('5755049N',9,'Mme','Corinne','Le Fur','75 COURS DE LA SOMME','','33000','BORDEAUX','4/4/1957','1/10/1979');
insert into Agent values('8399203U',9,'M.','Cdric','Le Pape','61 COURS ARISTIDE BRIAND','','33000','BORDEAUX','21/2/1983','1/4/2002');
insert into Agent values('6131018A',9,'Mme','Sverine','Lenoble','61 RUE DU MIRAIL','','33000','BORDEAUX','9/12/1961','1/3/1992');
insert into Agent values('7698457N',9,'Mme','Nadia','Louineau','6 RUE DE LA BOETIE','','33000','BORDEAUX','7/1/1976','1/4/1995');
insert into Agent values('6388893Z',9,'Mme','Emmanuelle','Louisy','39 RUE GEORGES BAZIADOLY','','33200','BORDEAUX','23/6/1963','1/5/1993');
insert into Agent values('6358181R',9,'M.','Stphane','Martial','40 RUE MEXICO','','33200','BORDEAUX','11/7/1963','1/2/1991');
insert into Agent values('8241526F',9,'Mme','Caroline','Martin','29 RUE GABRIEL LEGLISE','','33200','BORDEAUX','19/5/1982','1/5/2004');
insert into Agent values('6488615T',9,'Mme','Frdrique','Martinez','RES ST JAMES - APT 45','100 RUE LASEPPE','33000','BORDEAUX','27/11/1964','1/3/1991');
insert into Agent values('8033860G',9,'Mme','Florence','Martins','19 RUE DES PALANQUES','','33000','BORDEAUX','14/1/1980','1/9/2001');
insert into Agent values('6115516A',9,'Mme','Carine','Merceron','26 RUE DE LA JALLE','','33000','BORDEAUX','3/1/1961','1/10/1986');
insert into Agent values('7284727G',9,'Mme','Sibylle','Minne','272 RUE STE CATHERINE','','33000','BORDEAUX','16/3/1972','1/2/1991');
insert into Agent values('6746976V',9,'Mme','Anne','Mongis','3 RUE PAUL LOUIS LANDE','','33000','BORDEAUX','11/4/1967','1/6/1990');
insert into Agent values('6360601X',9,'Mme','Veronik','Monier','9 RUE LAMOLINERIE','','33200','BORDEAUX','4/5/1963','1/4/1983');
insert into Agent values('7113296U',9,'Mme','Marie Pierre','Mouledous','3 RUE DU PARC','','33200','BORDEAUX','17/11/1971','1/6/1996');
insert into Agent values('8116381D',9,'Mme','Stphanie','Nicot','35 RUE KIESER','','33000','BORDEAUX','14/10/1981','1/10/2003');
insert into Agent values('6951701X',9,'Mme','Carine','Oliveira','7 RUE D''ENGHIEN','','33000','BORDEAUX','14/8/1969','1/6/1998');
insert into Agent values('7653904L',9,'M.','David','Oriol','34 RUE BILLAUDEL','','33800','BORDEAUX','16/1/1976','1/5/2004');
insert into Agent values('7110865B',9,'Mme','Anne','Perovitch','3 RUE DU PARC','','33200','BORDEAUX','11/10/1971','1/4/1998');
insert into Agent values('7693355T',9,'Mme','Sandrine','Petit','RES DU HAUT BRION A 102','19 RUE DU HAUT BRION','33000','BORDEAUX','10/5/1976','1/1/1999');
insert into Agent values('6083331R',9,'Mme','Lydie','Pion','160 RUE DES ORANGERS','','33200','BORDEAUX','30/1/1960','1/5/1987');
insert into Agent values('8470180T',9,'Mme','Karine','Plumet','LE PONANT D453','2 TERRASSE DU 8 MAI 1945','33000','BORDEAUX','25/1/1984','1/3/2003');
insert into Agent values('5344123E',9,'Mme','Annette','Pracastin','27 RUE ST JAMES','','33000','BORDEAUX','6/8/1953','1/5/1987');
insert into Agent values('6243541H',9,'Mme','Sandrine','Prevot','105 RUE JUDAIQUE','','33000','BORDEAUX','19/6/1962','1/3/1989');
insert into Agent values('7053995L',9,'Mme','Sophie','Puydebois','71 RUE HUGUERIE','','33000','BORDEAUX','20/12/1970','1/1/1997');
insert into Agent values('6042179L',9,'Mme','Clmence','Quentin','6 RUE DE RUAT','','33000','BORDEAUX','10/3/1960','1/7/1984');
insert into Agent values('8080028P',9,'Mme','Flore','Ramiliarijaona','38 RUE FRAGONARD','RESIDENCE MARLY I','33200','BORDEAUX','26/7/1980','1/6/2003');
insert into Agent values('6306408R',9,'Mme','Nathalie','Ribet','7 AVENUE CARNOT','','33200','BORDEAUX','4/11/1963','1/12/1990');
insert into Agent values('7750324Q',9,'M.','Thierry','Rocher','15 RUE LATESTA','RES. LES AMBASSADEURS ','33200','BORDEAUX','18/10/1977','1/12/1998');
insert into Agent values('5645722E',9,'M.','Wilhelm','Sainterent','RUE STE ETIENNE N 6','','33000','BORDEAUX','11/12/1956','1/7/1978');
insert into Agent values('8278884M',9,'Mme','Bnedicte','Sauvarin','4 RUE COTREL','','33000','BORDEAUX','16/3/1982','1/3/2004');
insert into Agent values('8021509G',9,'M.','Philippe','Senescal','19 RUE MARSAN','','33300','BORDEAUX','8/2/1980','1/10/2000');
insert into Agent values('5374242T',9,'Mme','Fabienne','Soler','25 COURS ARISTIDE BRIAND','','33800','BORDEAUX','10/1/1953','1/12/1978');
insert into Agent values('6130227Q',9,'Mme','Sophie','Soubre','28 RUE J. J. ROUSSEAU','BAT B APPT 33','33200','BORDEAUX','1/11/1961','1/12/1990');
insert into Agent values('6406165Y',9,'Mme','Anne','Tassone','193 RUE GEORGES MANDEL','','33000','BORDEAUX','5/11/1964','1/9/1987');
insert into Agent values('8036540V',9,'M.','Vincent','Teisseire','5 RUE CASTELMORON','','33000','BORDEAUX','15/5/1980','1/2/2005');
insert into Agent values('6254849Z',9,'Mme','Pascale','Travet','34 CRS DE LA LIBERATION','','33000','BORDEAUX','29/4/1962','1/11/2000');
insert into Agent values('8358038Z',9,'M.','Franois','Trevisanut','34 RUE GEORGES MAUDEL','','33000','BORDEAUX','17/10/1983','1/5/2004');
insert into Agent values('8392727E',9,'Mme','Jarmila','Vallee','9 PLACE CHARLES GRUET','','33000','BORDEAUX','19/4/1983','1/11/2002');
insert into Agent values('5723481A',9,'M.','Guillaume','Yao','4 PASSAGE LALIMENT','','33000','BORDEAUX','6/10/1957','1/4/1978');
insert into Agent values('7447588E',9,'M.','Laurent','Brocas','31 AVENUE DE LA BELLE ETOILE','','33270','BOULIAC','20/7/1974','1/3/1995');
insert into Agent values('7140024W',9,'Mme','Sabine','Dageville','18 RUE PENAULT D''ARMANCOUR','','33520','BRUGES','3/4/1971','1/5/1990');
insert into Agent values('5660861K',9,'M.','Jeff','Inaudiere','10 RUE CLAUDE DEBUSSY','','33520','BRUGES','18/5/1956','1/8/1980');
insert into Agent values('5289449B',9,'Mme','Isabelle','Lardy','10 RUE CLAUDE DEBUSSY','','33520','BRUGES','29/7/1952','1/5/1985');
insert into Agent values('8018131K',9,'M.','Paul','Lemoine','397 ROUTE DU MEDOC','RES DU PARC ST ESTEPHE','33520','BRUGES','7/5/1980','1/8/2000');
insert into Agent values('5994696Z',9,'M.','Cdric','Marot','12 RUE DES ECOLES','','33520','BRUGES','22/9/1959','1/11/1981');
insert into Agent values('6988388Z',9,'Mme','Karine','Maurice','34 RUE A.BERT','','33520','BRUGES','10/2/1969','1/11/1989');
insert into Agent values('5592100V',9,'Mme','Virginie','Patard','3 RUE MAL DE LATTRE TASSIGNY','','33520','BRUGES','1/10/1955','1/4/1980');
insert into Agent values('5937418Q',9,'M.','Sbastien','Vergiat','RES ST ESTEPHE','397 ROUTE DU MEDOC','33520','BRUGES','17/4/1959','1/7/1985');
insert into Agent values('7586408W',9,'M.','Pascal','Dufour','13 RUE JEAN JAURES','','33560','CARBON BLANC','27/2/1975','1/7/1998');
insert into Agent values('7422453J',9,'Mme','Graldine','Loisel','35 BIS RUE JEAN JAURES','','33560','CARBON BLANC','26/5/1974','1/10/1994');
insert into Agent values('6662847A',9,'Mme','Anne','Sable','16 BIS RUE JEAN JAURES','','33560','CARBON BLANC','5/9/1966','1/12/1993');
insert into Agent values('6839503T',9,'Mme','Christele','Velvet','9 RUE DE L''ISLE','','33480','CASTELNAU DU MEDOC','27/3/1968','1/11/1991');
insert into Agent values('5872251G',9,'Mme','Stphanie','Mitteau','3 CHEMIN DE CANTELAUDE','','33610','CESTAS','21/9/1958','1/8/1983');
insert into Agent values('8279316G',9,'M.','Jean Christophe','Montial','22 ALLEE DU PAS DU RENARD','','33610','CESTAS','29/3/1982','1/8/2003');
insert into Agent values('5437191Q',9,'Mme','Isabelle','Gauois','43-45 RUE DU LYCEE TECHNIQUE','','33320','EYSINES','16/7/1954','1/11/1973');
insert into Agent values('5658246T',9,'Mme','Nellie','Imperiale','5 ALLEE DU CHAMP DE CANSES','LE VIGEAU','33320','EYSINES','19/3/1956','1/7/1976');
insert into Agent values('5906259X',9,'M.','Jean Jacques','Lebon','23 ALLEE VAUBAN','','33320','EYSINES','19/11/1959','1/6/1981');
insert into Agent values('7621538F',9,'M.','Denis','Pinaud','100 RUE DU MONTALIEU','','33320','EYSINES','21/2/1976','1/4/2000');
insert into Agent values('5490558Y',9,'M.','David','Prizzi','51 RUE AUGUSTE RENOIR','','33320','EYSINES','22/10/1954','1/11/1981');
insert into Agent values('5376567V',9,'Mme','Karole','Telephe','67 RUE DU MONTALIEU','','33320','EYSINES','12/4/1953','1/8/1984');
insert into Agent values('6228835Y',9,'M.','Olivier','Faivre','14 AVENUE GASTON CABANNES','','33270','FLOIRAC','5/11/1962','1/4/1981');
insert into Agent values('5679527Z',9,'M.','Igor','Elbaz','RES LOUSTALOT H3','','33170','GRADIGNAN','20/11/1956','1/5/1983');
insert into Agent values('7790697Z',9,'Mme','Christine','Malagane','2 RUE DES CHARMES','','33170','GRADIGNAN','4/9/1977','1/4/1998');
insert into Agent values('6505921D',9,'Mme','Stphanie','Toledano','26 ALLEE DU MOULIN DE CAZAU','','33170','GRADIGNAN','18/9/1965','1/4/1992');
insert into Agent values('5345011V',9,'Mme','Alice','Pluchet','71 RUE VICTOR HUGO','','33185','LA HAILLAN','1/4/1953','1/5/1971');
insert into Agent values('5969300V',9,'Mme','Armelle','Balouka','35 RUE FRANCIS DE PRESSENSE','','33110','LE BOUSCAT','26/7/1959','1/9/1993');
insert into Agent values('8537312M',9,'Mme','Katia','Di Mascio','10 RUE ERNEST ROYER','','33110','LE BOUSCAT','21/12/1985','1/7/2005');
insert into Agent values('6054503G',9,'Mme','Virginie','Gerbault','117 AVENUE ARISTIDE BRIAND','','33110','LE BOUSCAT','20/5/1960','1/10/1983');
insert into Agent values('7744618N',9,'M.','David','Julien','69 RUE LAHARPE','','33110','LE BOUSCAT','30/9/1977','1/9/2002');
insert into Agent values('8468091X',9,'M.','Stphane','Poussard','27 RUE LAFON FELINE','','33110','LE BOUSCAT','1/7/1984','1/9/2004');
insert into Agent values('6147571T',9,'M.','Serge','Thomas','RES  LES PORTES DU BOUSCAT ','APT 405 - 9 AVENUE VICTOR HUGO','33110','LE BOUSCAT','7/8/1961','1/3/1989');
insert into Agent values('6526131W',9,'Mme','Vronique','Colleville','26 RUE DE LOS HEROS','','33185','LE HAILAN','24/12/1965','1/8/1992');
insert into Agent values('8087591K',9,'M.','Christophe','Djibo','134 CHEMIN DE TRETINOT',' LOUENS ','33290','LE PIAN MEDOC','17/5/1980','1/4/2001');
insert into Agent values('6124247Q',9,'Mme','Nancy','Aupetit','9 ALLE JEAN DE LA FONTAINE','','33320','LE TAILLAN','23/4/1961','1/11/1984');
insert into Agent values('8208554R',9,'Mme','Virginie','Pinto','1 RUE MONTESQUIEU',' LA BOETIE ','33320','LE TAILLAN','6/4/1982','1/11/2003');
insert into Agent values('5500339E',9,'Mme','Benita','Breard','141 ROUTE DE BORDEAUX','','33310','LORMONT','17/6/1955','1/1/1990');
insert into Agent values('7190103E',9,'Mme','Caroline','Dubois','RESIDENCE LE SULLY','BAT D APPT 33','33310','LORMONT','28/10/1971','1/2/1994');
insert into Agent values('5765889W',9,'Mme','Sverine','Grivaz','24 AVENUE DE LA LIBERATION','','33310','LORMONT','15/5/1957','1/4/1996');
insert into Agent values('7356505B',9,'M.','Florent','Peronnau','18 AVENUE YVES MONTAND','','33310','LORMONT','17/12/1973','1/5/1996');
insert into Agent values('7721073W',9,'Mme','Patricia','Attal','59 RUE SEGUINEAU','RES BATTESTI TOUR N 2','33700','MERIGNAC','6/6/1977','1/3/2001');
insert into Agent values('5268414M',9,'Mme','Sandrine','Auclerc','N 52 B 41 RUE DE LA PAIX','RESIDENCE ANTARES','33700','MERIGNAC','9/11/1952','1/5/1977');
insert into Agent values('5501250V',9,'Mme','Sophie','Bremond','6 SQUARE TUILERIE','','33700','MERIGNAC','6/3/1955','1/1/1980');
insert into Agent values('5860242D',9,'Mme','Adelaide','Briand','12 RUE JEAN XXIII','','33700','MERIGNAC','14/9/1958','1/8/1979');
insert into Agent values('7395875V',9,'Mme','Carine','Cappellaro','20 BIS RUE LOUIS COULLET','','33700','MERIGNAC','10/3/1973','1/1/2000');
insert into Agent values('5847077U',9,'M.','Arnaud','Castellotti','251 AVENUE DE LA MARNE','','33700','MERIGNAC','30/10/1958','1/6/1977');
insert into Agent values('8170022J',9,'Mme','Nathalie','Chabot','33 AV FRERES ROBINSON','','33700','MERIGNAC','27/9/1981','1/10/2004');
insert into Agent values('8050258F',9,'Mme','Caroline','Chaigneau','10 RUE DE PROVENCE','','33700','MERIGNAC','20/1/1980','1/6/2002');
insert into Agent values('6128178N',9,'M.','Laurent','Crom','83/97 AV BON AIR','RES BASSY APPT 100 BAT B','33700','MERIGNAC','25/8/1961','1/2/1990');
insert into Agent values('6266525Q',9,'Mme','Stphanie','Gay','56 IMPASSE DE MARLY','','33700','MERIGNAC','1/11/1962','1/5/1985');
insert into Agent values('6952227U',9,'Mme','Sandrine','Herida','40 RUE ALFRED DE VIGNY','','33700','MERIGNAC','7/2/1969','1/3/1990');
insert into Agent values('7138408P',9,'Mme','Sophie','Joffre','7 PLACE VAN GOGH - RES PARC DU','CHATEAU DES TILLEULS - E','33700','MERIGNAC','5/12/1971','1/12/1996');
insert into Agent values('5966381X',9,'Mme','Isabelle','Laloe','17 RUE MARCEL CERDAN','','33700','MERIGNAC','26/9/1959','1/10/1982');
insert into Agent values('6688002T',9,'M.','Regis','Lhoste','9 AV DES TOURELLES DE CHARLIN','','33700','MERIGNAC','31/5/1966','1/12/1989');
insert into Agent values('7832516E',9,'M.','Bertrand','Malaussen','APPT N 29 D 03','7 RUE PABLO PICASSO','33700','MERIGNAC','12/1/1978','1/11/1997');
insert into Agent values('6191871V',9,'M.','Olivier','Mary','83/97 AV BON AIR','BAT A APPT 36','33700','MERIGNAC','23/12/1961','1/12/1982');
insert into Agent values('8216213R',9,'M.','Benoit','Sarres','83/97 AV BON AIR','BAT B APPT 79','33700','MERIGNAC','22/10/1982','1/8/2003');
insert into Agent values('7292674V',9,'M.','Jean Claude','Simic','RES GIACOMETTI APPT 330 BAT C','RUE BIR HAKEIM','33700','MERIGNAC','6/1/1972','1/12/1995');
insert into Agent values('7114912A',9,'Mme','Valrie','Soufflard','5 RUE ROBERT LAURENT','','33700','MERIGNAC','2/5/1971','1/11/1992');
insert into Agent values('8046527A',9,'M.','Alexandre','Vallaud','RESIDENCE LES TOURELLES TOUR 6','4 RUE RAOUL PONCHON','33700','MERIGNAC','24/5/1980','1/4/2003');
insert into Agent values('6263957Z',9,'M.','Eric','Vendittozzi','251 AV DE LA MARNE','','33700','MERIGNAC','8/1/1962','1/11/1986');
insert into Agent values('7992279K',9,'Mme','Sylvie','Weber','7 RUE GABRIEL DUPUY','','33700','MERIGNAC','18/5/1979','1/3/1999');
insert into Agent values('5685000Y',9,'M.','Anthony','Boullier','PLAUTIGNAN ','','33340','ORDONNAC','15/2/1956','1/5/1983');
insert into Agent values('8227000R',9,'M.','Arnaud','Boide','49 RUE DE MACAU','','33290','PAREMPUYRE','11/7/1982','1/7/2003');
insert into Agent values('6916001T',9,'Mme','Maite','Bourgeois','4 RUE DES PALUS','','33290','PAREMPUYRE','21/1/1969','1/3/1994');
insert into Agent values('7796407F',9,'M.','Alessandro','Dupin Gilet','15 RUE DU MAQUIS DES VIGNES','','33250','PAUILLAC','1/8/1977','1/11/1999');
insert into Agent values('6308400G',9,'Mme','Corrine','Azura','81 RUE ROGER COHE','RESIDENCE LE NEPTUNE APPT 97','33600','PESSAC','16/11/1963','1/8/1987');
insert into Agent values('6016236M',9,'Mme','Sophie','Baif','8 RUE DU COMTE','','33600','PESSAC','23/5/1960','1/8/1981');
insert into Agent values('5422967E',9,'M.','Frderic','Bonnardel','39 AVENUE DU VALLON','','33600','PESSAC','22/10/1954','1/12/1983');
insert into Agent values('7869824G',9,'Mme','Peggy','Cohen','16 AVENUE JEAN MOULIN','','33600','PESSAC','6/4/1978','1/11/1999');
insert into Agent values('8109230F',9,'M.','Carlos','Colorado','5 RUE DE GRECE','','33600','PESSAC','8/10/1981','1/6/2000');
insert into Agent values('8334518J',9,'Mme','Sverine','Gabillat','5 RUE DE GRECE','7 C CLUB DES PRINCES','33600','PESSAC','6/3/1983','1/10/2002');
insert into Agent values('7281548B',9,'M.','Sylvain','Gallego','27 RUE ANDRE GILLES','','33600','PESSAC','13/6/1972','1/4/1998');
insert into Agent values('7511480C',9,'Mme','Maitena','Heraud','52 RUE JEAN DE LA FONTAINE','','33600','PESSAC','7/5/1975','1/2/1995');
insert into Agent values('7191898F',9,'M.','Fabien','Jaroussie','9 RUE DES COLIBRIS','','33600','PESSAC','2/3/1971','1/4/1992');
insert into Agent values('7873280N',9,'M.','Jrome','Lauer','4 ALLEE DES VERDIERS','','33600','PESSAC','25/6/1978','1/6/1999');
insert into Agent values('5891178E',9,'Mme','Marie Christine','Merlin','12 AVENUE DES SABLES','','33600','PESSAC','14/10/1958','1/5/1982');
insert into Agent values('5561384H',9,'Mme','Sandrine','Mino','31 RUE BOILEAU','','33600','PESSAC','16/5/1955','1/2/1975');
insert into Agent values('6874492Z',9,'Mme','Virginie','Murat','7 RUE CENDRILLON','LE BOIS DE LA PRINCESSE','33600','PESSAC','25/4/1968','1/8/1991');
insert into Agent values('8596900G',9,'M.','Rodolphe','Pariente','29 BIS AVENUE DE MADRAN','','33600','PESSAC','19/1/1985','1/7/2005');
insert into Agent values('7376050W',9,'M.','Frderic','Plaideau','52 AVENUE DU VALLON','','33600','PESSAC','10/11/1973','1/2/1999');
insert into Agent values('6183516N',9,'Mme','Christel','Plana','6 RUE DES PERDRIX','L''OREE DU BOIS','33600','PESSAC','31/5/1961','1/3/1984');
insert into Agent values('7426830R',9,'Mme','Sandrine','Poulet','110 AVENUE PASTEUR','','33600','PESSAC','18/5/1974','1/5/1994');
insert into Agent values('7067529X',9,'Mme','Isabelle','Regeffe','7 RUE CENDRILLON','LE BOIS DE LA PRINCESSE','33600','PESSAC','1/5/1970','1/4/1995');
insert into Agent values('5786167M',9,'Mme','Violaine','Saugnac','14 RUE DE FLANDRE','','33600','PESSAC','11/5/1957','1/10/1985');
insert into Agent values('5908399Y',9,'M.','Jrome','Costes','6 RUE J.B. CHARDIN','','33160','ST MEDARD EN JALLES','31/3/1959','1/2/1983');
insert into Agent values('7452659R',9,'Mme','Stphanie','Dufourcq','37 RUE JEAN DUPERRIER','','33160','ST MEDARD EN JALLES','4/4/1974','1/12/1999');
insert into Agent values('7238168Z',9,'Mme','Elisabeth','Lallemant','PASSAGE PICHELEBRE','','33160','ST MEDARD EN JALLES','26/8/1972','1/11/2000');
insert into Agent values('7767226M',9,'Mme','Isabelle','Marchand','41 AVENUE JJ ROUSSEAU','','33160','ST MEDARD EN JALLES','16/1/1977','1/8/1999');
insert into Agent values('8025666A',9,'Mme','Gwenaelle','Neveu','4 RUE JEAN BAPTISTE CHARDIN','','33160','ST MEDARD EN JALLES','19/8/1980','1/1/2000');
insert into Agent values('8117984W',9,'Mme','Muriel','Rigal','1 ALLEE DES FOUGERES','LE CLUB DES PINS','33160','ST MEDARD EN JALLES','3/6/1981','1/11/2003');
insert into Agent values('8282310L',9,'M.','Ludovic','Touchais','4 RUE ANTOINE WATTEAU','','33160','ST MEDARD EN JALLES','23/6/1982','1/4/2003');
insert into Agent values('6694924R',9,'M.','Cdric','Benoit','27 RUE DU GAL ANDRE','','33400','TALENCE','9/1/1966','1/11/1990');
insert into Agent values('7385936R',9,'Mme','Valrie','Bertault','22 RUE BOURBAKI','','33400','TALENCE','15/2/1973','1/3/1996');
insert into Agent values('5227945Z',9,'M.','Laurent','Cabaco','125 COURS GAMBETTA','RESIDENCE GAMBETTA BAT A1','33400','TALENCE','13/8/1952','1/1/1980');
insert into Agent values('7502300Z',9,'Mme','Cline','Commissaire','RESIDENCE VALENTIN','80 COURS GAMBETTA','33400','TALENCE','1/6/1975','1/4/1994');
insert into Agent values('6005141C',9,'M.','Nicolas','Conter','178 CHEMIN DE SUZON','','33400','TALENCE','27/12/1960','1/2/1993');
insert into Agent values('7554563G',9,'M.','Stphane','Foubert','RES.VOLTAIRE -BAT 2 -ENTREE E','230 CHEMIN DE SUZON','33400','TALENCE','19/12/1975','1/12/1998');
insert into Agent values('6497569A',9,'Mme','Karine','Francon','91 CHEMIN DE SUZON','','33400','TALENCE','17/9/1964','1/2/1984');
insert into Agent values('5703629X',9,'Mme','Cline','Goutefangea','38 RUE JULES VALLES','','33400','TALENCE','21/12/1957','1/1/1982');
insert into Agent values('6340694J',9,'Mme','Alexa','Mericq','3 LESTEYROT','2 AVENUE DE THOUARS','33400','TALENCE','19/3/1963','1/12/1987');
insert into Agent values('8120143T',9,'M.','Matthieu','Aniots','19 RUE GEORGES TEXIER','','33140','VILLENAVE D''ORNON','22/9/1981','1/7/2002');
insert into Agent values('5379323Q',9,'Mme','Sylvie','Huret','CHEMIN DE COUHINS','','33140','VILLENAVE D''ORNON','29/8/1953','1/2/1978');
insert into Agent values('7269589C',9,'M.','Renaud','Le','9 RUE RABELAIS','','33140','VILLENAVE D''ORNON','21/6/1972','1/6/1993');
insert into Agent values('8083142Z',9,'Mme','Batrice','Mauri','11 ALLEE DES ACACIAS','L''OREE DU BOIS','33140','VILLENAVE D''ORNON','27/5/1980','1/8/2001');
insert into Agent values('6544512A',10,'Mme','Marie Claire','Audouin','5 RUE LES FAURES','','33640','CASTRES','21/11/1965','1/9/1994');
insert into Agent values('7430099V',10,'M.','Stphane','Maxiola','CHATEAU LARQUEY','','33490','CAUDROT','29/1/1974','1/8/1996');
insert into Agent values('7440792T',10,'Mme','Stphanie','Faye','FOUET','SADIRAC','33670','CREON','26/1/1974','1/2/1997');
insert into Agent values('5859545W',10,'M.','Jrome','Garcia','2 CHEMIN DE BERNADON','SADIRAC','33670','CREON','5/3/1958','1/5/1984');
insert into Agent values('7874860F',10,'Mme','Isabelle','Gibert','21 LOTISSEMENT LA PIMPINE','','33670','CREON','4/10/1978','1/12/2003');
insert into Agent values('6187959T',10,'M.','Stphane','Freppel','3 RUE GUSTAVE EIFFEL','','33320','EYSINES','25/5/1961','1/4/1983');
insert into Agent values('5888728R',10,'Mme','Nadege','Mapas','20 AVENUE DE LA POMPE','','33320','EYSINES','1/5/1958','1/1/1977');
insert into Agent values('8544662B',10,'M.','Nicolas','Baheux','LANDE BASSE','','33340','GAILLAN','25/1/1985','1/3/2003');
insert into Agent values('5838106T',10,'Mme','Florence','Quiros','9 ALLEE DES ORMEAUX','','33210','LANGON','4/11/1958','1/2/1978');
insert into Agent values('7968175K',10,'M.','Christophe','Vieira','53 ROUTE DES GRAVES','','33125','LOUCHATS','12/6/1979','1/2/1999');
insert into Agent values('8053034Y',10,'Mme','Sophie','Labreze','SEGUINARD ','','33190','MONGAUZY','4/10/1980','1/2/2001');
insert into Agent values('6866890L',10,'Mme','Nadege','Magueres','LE BOURG','','33210','ROAILLAN','16/6/1968','1/10/1990');
insert into Agent values('5612407T',10,'M.','Bruno','Bargues','1486 LE GENDRE','','33125','ST MAGNE','20/5/1956','1/5/1986');
insert into Agent values('5385977Y',10,'Mme','Laure','Leveque','ALLEE DES AUBIERS','','33210','TOULENNE','24/2/1953','1/8/1977');
insert into Agent values('5628635G',11,'M.','Stphan','Claisse','10 RUE MALBEC','','33370','ARTIGUES','28/3/1956','1/7/1981');
insert into Agent values('5644162J',11,'Mme','Ccile','Dujarrrier','RUE DE LA COURREGE','','33370','ARTIGUES','28/11/1956','1/11/1977');
insert into Agent values('7982521D',11,'M.','Fabien','Ignard','DOMAINE DE PINCHAGUT','','33113','BOURIDEYS','6/7/1979','1/6/2002');
insert into Agent values('5610338U',11,'M.','Christophe','Arnal','LA PEITE GUEYTINE','GUITRES','33230','COUTRAS','17/4/1956','1/8/1980');
insert into Agent values('6171946M',11,'M.','David','Pomariega','19  LE CAILLOU ','LES PEINTURES','33230','COUTRAS','26/4/1961','1/7/1980');
insert into Agent values('6652760L',11,'Mme','Marie Odile','Baudet','15 AVENUE DE LA PALOMBIERE','','33138','LANTON','27/4/1966','1/2/1989');
insert into Agent values('6542320T',11,'M.','Bruno','Bonnin','21 RUE WALDECK ROUSSEAU','','33500','LIBOURNE','17/1/1965','1/8/1984');
insert into Agent values('5207415J',11,'Mme','Stphanie','Denoual','51 RUE PLINE PARMENTIER','','33500','LIBOURNE','3/4/1952','1/8/1980');
insert into Agent values('8070181L',11,'M.','Christophe','Lemaire','17 AVENUE DE VERDUN','','33500','LIBOURNE','29/5/1980','1/6/2003');
insert into Agent values('7954339W',11,'Mme','Ccile','Balan',' LES EYCARDS ','CANTENAC','33460','MARGAUX','4/4/1979','1/12/1999');
insert into Agent values('6829118E',11,'M.','Aboubahr','Raguin','36 ROUTE DE TOUTY','','33370','POMPIGNAC','1/9/1968','1/7/1988');
insert into Agent values('5998956E',11,'M.','Marc','Le Cour','SAINT CHRISTOLY DE BLAYE','','33920','SAINT SAVIN','24/3/1959','1/2/1982');
insert into Agent values('5388753Q',11,'Mme','Laure','Cougniot','LE SILLAT N 2','','33910','SAVIGNAC S/L''ISLE','21/5/1953','1/2/1982');
insert into Agent values('6168076F',11,'Mme','Laetitia','Cosculluela','31 VILLEPREUX VILLAGE','','33160','ST AUBIN DE MEDOC','10/8/1961','1/10/1981');
insert into Agent values('6917334R',11,'Mme','Nathalie','Icarre','40 VILLEPREUX VILLAGE','','33160','ST AUBIN DE MEDOC','26/9/1969','1/5/1993');
insert into Agent values('6190470X',11,'Mme','Patricia','Da Costa','CHATEAU GRAND CORBIN','','33330','ST EMILION','8/1/1961','1/9/1983');
insert into Agent values('5582467Z',11,'Mme','Corinne','Lamotte','CHATEAU HAUT SEGOTTES','','33330','ST EMILION','29/7/1955','1/2/1988');
insert into Agent values('6748778D',11,'Mme','Karin','Lataste','JAUGUE BLANC ','','33330','ST EMILION','10/1/1967','1/10/1990');
insert into Agent values('7976935G',11,'M.','Laurent','Bodson','LE BOURG','','33180','ST ESTEPHE','16/11/1979','1/12/1999');
insert into Agent values('8420323A',11,'Mme','Ana Paula','Buffin','CHATEAU BALAC','','33112','ST LAURENT DU MEDOC','14/8/1984','1/2/2004');
insert into Agent values('5592638E',11,'M.','Jean Franois','Champin','3 CHEMIN DE FABRE','','33370','TRESSES','5/12/1955','1/1/1979');
insert into Agent values('7774105P',11,'M.','Vincent','Leglise','28 PARC DE CADOUIN POMPIGNAC','','33370','TRESSES','15/9/1977','1/7/2002');
insert into Agent values('7766972L',12,'M.','Jean Philippe','Pinna','DOMAINE DE LASSOLE','','47450','COLAYRAC ST CIRQ','25/10/1977','1/4/1998');
insert into Agent values('5646809L',12,'Mme','Brangere','Routmene','ROUTE DES BERGERONNETTES','','47450','COLAYRAC ST CIRQ','3/2/1956','1/2/1995');
insert into Agent values('8431413E',12,'Mme','Janig','Boureau','LE BOSQ ','','47490','SAINT HILAIRE','12/2/1984','1/4/2003');
insert into Agent values('7700469A',13,'Mme','Helena','Dunand','84 AVENUE GAMBETTA','','47500','FUMEL','12/9/1977','1/7/2002');
insert into Agent values('7677974Z',13,'Mme','Valrie','Parnaudeau','9 COURS ROMAS','','47600','NETZAC','5/3/1976','1/10/1995');
insert into Agent values('6855368M',14,'Mme','Sverine','Murati','FAUGUEROLLES','','47400','TONNEINS','28/6/1968','1/1/1993');
insert into Agent values('8088358U',12,'M.','Stphane','Delcroix','193 RUE PAUL VALERY','','47000','AGEN','7/3/1980','1/5/2000');
insert into Agent values('8012062N',12,'Mme','Hlne','Nart',' LE PIGEONNIER ','','47470','CAUZAC','1/1/1980','1/2/2000');
insert into Agent values('7852679W',12,'M.','Cdric','Dalard','ROUMAGNE','','47800','MIRAMONT DE GUYENNE','7/9/1978','1/11/1998');
insert into Agent values('6882038B',12,'Mme','Katell','Detat','PLACE DE L''HOTEL DE VILLE','','47800','MIRAMONT DE GUYENNE','2/5/1968','1/10/1990');
insert into Agent values('7985123G',12,'Mme','Caroline','Bisotey','16 RUE JEAN DE JEANNE','','33770','SALLES','3/3/1979','1/9/2001');
insert into Agent values('8126260R',13,'Mme','Carole','Paul','AU CHEY ','','47190','AIGUILLON','12/3/1981','1/8/2000');
insert into Agent values('7133679Z',13,'Mme','Cheistel','Boucharel','ESCOUBET','','47160','DAMAZAN','28/3/1971','1/10/1996');
insert into Agent values('7887394E',13,'M.','Christophe','Vaissie','11 BOULEVARD FOURCADE','','47200','MARMANDE','29/8/1978','1/12/2004');
insert into Agent values('7066334Y',14,'Mme','Sophie','Magontier','AU CHEY ','','47190','AIGUILLON','14/9/1970','1/4/1991');
insert into Agent values('5320239U',14,'M.','Thierry','Lafon','15 RUE PABLO PICASSO','','47300','VILLENEUVE S/LOT','2/2/1953','1/7/1991');
insert into Agent values('7638866Q',14,'Mme','Marie','Roux','2 RUE PAUL CLAUDEL','','47300','VILLENEUVE S/LOT','26/3/1976','1/10/1997');
insert into Agent values('8433036U',15,'M.','Rodolphe','Chalumeau','115 RUE DE CHASSIN','','64600','ANGLET','13/12/1984','1/1/2003');
insert into Agent values('7426359E',15,'M.','Christophe','Hang','52 AVENUE DE MONTBRUN','','64600','ANGLET','17/5/1974','1/2/1997');
insert into Agent values('7590878E',15,'Mme','Christel','Couvin','10 AV DE BEYRIS','','64100','BAYONNE','5/6/1975','1/2/1998');
insert into Agent values('7105454V',15,'M.','Cyril','Orfanidis','RUE GEORGES BERGES','BALICHON','64100','BAYONNE','1/1/1971','1/9/1993');
insert into Agent values('7108760N',15,'Mme','Batrice','Moyon','ERRETEGIA','','64210','BIDART','4/9/1971','1/1/1999');
insert into Agent values('7240317K',15,'Mme','Emmanuelle','Streb','CHEMIN MARIENEKO BIDEA','','64210','BIDART','11/3/1972','1/2/1996');
insert into Agent values('7065604E',15,'Mme','Nadine','Serre','11 AVENUE DU GOLF','','64500','CIBOURE','18/6/1970','1/7/1999');
insert into Agent values('5997101N',15,'Mme','Myriam','Besanger','RUE DES MONTS','','64400','OLORON STE MARIE','6/2/1959','1/5/1980');
insert into Agent values('5521117P',15,'Mme','Stphanie','Ingolif','19 RUE DU CAMBEILHOU','','64400','OLORON STE MARIE','30/8/1955','1/5/1984');
insert into Agent values('5843816Z',16,'Mme','Nathalie','Peronnet','N 9 RUE D''ALSACE','','64200','BIARRITZ','13/1/1958','1/2/1984');
insert into Agent values('7118839U',16,'Mme','Sophie','Sartron','RUE DE LARRE-VILLA HARITZAGA','QUARTIER LA NEGRESSE','64200','BIARRITZ','6/4/1971','1/8/1999');
insert into Agent values('6021979E',16,'Mme','Vigee','Mona','ERRETEGIA','','64210','BIDART','30/12/1960','1/6/1990');
insert into Agent values('5294136W',16,'M.','Xavier','Billa','8 RUE DU MARECHAL JUIN','','64140','LONS','29/4/1952','1/5/1991');
insert into Agent values('7803406N',16,'Mme','Stphanie','Pasti','13 PASSADE DE L''AYGUELADE','','64140','LONS','12/7/1978','1/9/2001');
insert into Agent values('8132442L',16,'M.','Matthieu','Dessort','15 AVENUE LARRAMENDY','','64500','ST JEAN DE LUZ','29/8/1981','1/1/2004');
insert into Agent values('6975713X',16,'Mme','Karine','Dumarcher','MALO-BAITA','','64122','URRUGNE','11/6/1969','1/1/1997');
insert into Agent values('7496457Y',17,'Mme','Marie Sandrine','Marchal','RESTAURANT LES 3 FONTAINES','','64310','ASCAIN','29/11/1974','1/12/2000');
insert into Agent values('7461935Z',17,'Mme','Christine','Plaideau','ROUTE DE MORLAAS','','64160','BUROS','20/11/1974','1/7/1995');
insert into Agent values('7554281A',17,'Mme','Corinne','Villemer','MAISON  HEGUIA ','MENDIONDE','64240','HASPARREN','2/6/1975','1/3/1998');
insert into Agent values('8140282H',17,'Mme','Viviane','Feghali','CHEMIN DE HALAGE','VILLA  NYANGA ','64990','LAHONCE','16/3/1981','1/11/2001');
insert into Agent values('7405439Q',17,'Mme','Nathalie','Buisson','8 LOTISSEMENT  LES HAUTS DU GAVE','','64800','MIREPEIX','3/3/1974','1/7/1997');
insert into Agent values('8457583A',17,'Mme','Marie Laure','Bretou','RUE DU FAUBOURG','','64190','NAVARRENX','20/6/1984','1/11/2003');
insert into Agent values('8110994Y',17,'M.','Thomas','Ferte','ABITAIN','','64390','SAVETERRE DE BEARN','20/2/1981','1/11/2000');
insert into Agent values('6699185Y',18,'Mme','Chantal','Teurlay','CHALET GASCOGNE','','64440','EAUX-BONNES','10/9/1966','1/7/1993');
insert into Agent values('7471808F',18,'M.','Jean Pierre','Lureau','QUARTIER DU LUY','SAUVAGNON','64230','LESCAR','21/7/1974','1/3/1997');
insert into Agent values('6873246V',18,'Mme','Anne','Potonne','8 RUE DE BIGORRE','','64230','LESCAR','22/3/1968','1/3/1990');
insert into Agent values('7297879C',18,'Mme','Sophie','Dupouy','10 CHEMIN DE PRATS','ESTOS','64400','OLORON STE MARIE','17/12/1972','1/7/1999');
insert into Agent values('7994299F',18,'M.','Jrome','Brun','ROUTE D''ARTHEZ','BALANSUN','64300','ORTHEZ','19/9/1979','1/9/2001');
insert into Agent values('7097788M',18,'M.','Benoit','Bazin','21 RUE DE COUFRAS','','64000','PAU','4/7/1970','1/1/1997');
insert into Agent values('5752985V',18,'M.','Olivier','Cany','20 RUE DES MUSTANGS','','64000','PAU','15/2/1957','1/9/1985');
insert into Agent values('6386889W',18,'M.','Stphane','Oudot','6 RUE DES FRERES CAMON','','64000','PAU','19/12/1963','1/1/1986');
insert into Agent values('6771168Q',18,'M.','Olivier','Martins','FERME FORGUES','CHEMIN DE DEVEZE','64121','SERRES CASTET','23/7/1967','1/2/1992');
insert into Agent values('7356133X',18,'Mme','Astrid','Prevot','12 RUE DU BRUSCOS','','64121','SERRES CASTET','19/6/1973','1/4/1995');
insert into Agent values('7439683M',19,'M.','Grgoire','Joudoux','QU DE LA CHINE','','40280','BENQUET','9/6/1974','1/4/2001');
insert into Agent values('6512883W',19,'Mme','Stphanie','Pochet','RUE JOSEPH DE LAURENS','','40100','DAX','3/4/1965','1/9/1990');
insert into Agent values('6278957D',19,'M.','Cyril','Geoffroy','11 ROUTE D''ESCOURCE','','40200','MIMIZAN','20/7/1962','1/2/1989');
insert into Agent values('8262247D',19,'M.','Arnaud','Zvach','3 RUE DES BRUYERES','','40460','SANGUINET','17/11/1982','1/2/2003');
insert into Agent values('7339861K',19,'M.','Sylvain','Broussier','L''OREE DU BOIS','','40180','SAUGNAC & CAMBRON','1/4/1973','1/12/1997');
insert into Agent values('7160300K',19,'M.','Philippe','Feyt','ARTIGUES','','40250','SOUGROSSE','8/10/1971','1/3/1994');
insert into Agent values('8578906Y',19,'M.','Pascal','Fevrier','STATION FINA','PUJO LE PLAN','40190','VILLENEUVE DE MARSAN','21/1/1985','1/11/2004');
insert into Agent values('8261920Y',20,'M.','David','Cissokho','116 RUE DE GARENNE BAT A','RESIDENCE DES LACS','40600','BISCAROSSE','1/10/1982','1/4/2003');
insert into Agent values('8574806R',20,'M.','Omar','Clement','7 C M. BEZIAT VILLA BAGATELLE','ROUTE NICOLAS','40320','EUGENIE LES BAINS','29/10/1985','1/11/2004');
insert into Agent values('6674312M',20,'M.','Franois','Vautour','3 AVENUE DE VILLENEUVE','','40270','GRENADE S/ADOUR','16/1/1966','1/3/1992');
insert into Agent values('6682995A',20,'M.','Arnaud','Zlotnik','EL RETIRO ','AVENUE DE LA MOLIE','40150','HOSSEGOR','18/7/1966','1/9/1987');
insert into Agent values('7705385U',20,'Mme','Ariane','Pellegrini','8 AVENUE LAMARQUE CANDO','','40200','MIMIZAN','15/3/1977','1/11/1999');
insert into Agent values('5661462N',20,'M.','Olivier','Poublan','MOULIN DE BARBE','ST PAUL EN BORN','40200','MIMIZAN','25/11/1956','1/5/1982');
insert into Agent values('6388977Q',20,'Mme','Stphanie','Saint Marty','34 AVENUE DU LAC','','40200','MIMIZAN','20/8/1963','1/8/1985');
insert into Agent values('7523282F',20,'M.','Christophe','Andre','LA GASTISE ','','40500','MONTGAILLARD','2/2/1975','1/4/1996');
insert into Agent values('8237832Q',20,'M.','Stphane','Pierrard','AU BOURG ','','40500','MONTGAILLARD','2/10/1982','1/11/2002');
insert into Agent values('5884934T',20,'M.','Jorge','Gauthier Rapin','2 ALLEE DES TOURTERELLES','','40140','SOUSTONS','26/11/1958','1/11/1979');
insert into Agent values('7286975A',21,'Mme','Sandrine','Castillon','MAISON LUCAZEDIEU','','40330','AMOU','17/8/1972','1/8/1999');
insert into Agent values('7213583B',21,'Mme','Laurence','Dupuy','HOTEL DES VOYAGEURS','RUE ST PIERRE','40330','AMOU','14/2/1972','1/11/2000');
insert into Agent values('5458854M',21,'Mme','Fatima','Baeza','CHEMIN DES THUYAS','','40230','BENESSE MARENNE','7/10/1954','1/2/1980');
insert into Agent values('7967964F',21,'Mme','Dominique','Wetterwald','34 AVENUE DES OISEAUX','','40200','MIMIZAN','14/7/1979','1/10/2004');
insert into Agent values('7475472N',21,'Mme','Cline','Cabrol','LAYAT  CAMPAGNE','','40090','MONT DE MARSAN','2/10/1974','1/11/1996');
insert into Agent values('8456797W',21,'Mme','Sophie','Pouzere','93 AVENUE FOCH','','40000','MONT DE MARSAN','6/10/1984','1/8/2004');
insert into Agent values('5369403H',21,'Mme','Christel','Montagnini','QUARTIER SAUBOUA','','40410','PISSOS','8/1/1953','1/5/1975');
insert into Agent values('6258382P',21,'M.','Franck','Henaff','1 LOT TALUCAT','','40200','ST PAUL EN BORN','9/2/1962','1/2/1996');
insert into Agent values('6669582W',22,'Mme','Sandrine','Lefebvre','2 RUE DE PABAN','','17100','LES GONDS','29/1/1966','1/3/1993');
insert into Agent values('8115258H',22,'Mme','Carole','Vergnaud','2 ALLEE DES PLATANES','','17270','MONTGUYOU','25/6/1981','1/10/2001');
insert into Agent values('5726468X',22,'Mme','Cline','Gayon','20 RUE DE LA CHAPELLE','LAUZIERES','17137','NIEUL SUR MER','11/11/1957','1/2/1988');
insert into Agent values('8206560Z',22,'Mme','Ccile','Sananikone','16 A LOTISSEMENT CHASSERAT','ESNANDES','17137','NIEUL SUR MER','9/8/1982','1/5/2004');
insert into Agent values('6974703Z',22,'Mme','Valrie','Fraval','19 RUE ARC DE TRIOMPHE','','17100','SAINTES','5/1/1969','1/6/1989');
insert into Agent values('7820082P',22,'M.','Eric','Caban','RUE DES GRASILIERS','','17540','ST SAUVEUR D''AUNIS','27/5/1978','1/7/1998');
insert into Agent values('6899621N',23,'M.','Laurent','Karali','5 RUE DES PASSEREAUX','','17290','AIGREFEUILLE D AUNIS','27/6/1968','1/7/1993');
insert into Agent values('6988115C',23,'Mme','Agns','Fortin','20 ROUTE DE BAUCHAIL','','17100','BUSSAC S/CHARENTE','27/4/1969','1/9/1991');
insert into Agent values('7374569L',23,'Mme','Stphanie','Deynu','LA ROCHE','','17240','LORIGNAC','13/11/1973','1/4/1998');
insert into Agent values('7734381L',23,'M.','Lionel','Herr','RUE DE LONGEVES','LE BREUIL ST OVEN D''AUNIS','17230','MARANS','14/11/1977','1/6/2003');
insert into Agent values('5584995X',23,'M.','Manuel','Blanc','116 AVENUE DES SEMIS','','17200','ROYAN','21/5/1955','1/8/1982');
insert into Agent values('6894003G',23,'M.','Fabien','Bourgery','5 ALLEE DE LA FOUINE','','17200','ROYAN','10/5/1968','1/3/1990');
insert into Agent values('5418294A',23,'M.','Herv','Laureti','35 RUE GAMBETTA','','17200','ROYAN','21/6/1954','1/9/1975');
insert into Agent values('6853975Y',24,'M.','Nicolas','Marty','DOMAINE DE RESERVAT','','17270','CLERAC','29/11/1968','1/9/1989');
insert into Agent values('5621511N',24,'M.','Sbastien','Ferrand','6 RUE DU GENERAL LECLERC','','17390','LA TREMBLADE','29/12/1956','1/7/1986');
insert into Agent values('5713208J',24,'Mme','Nathalie','Benamar','32 RUE DE LA DESCENDERIE','','17140','LAGORD','23/11/1957','1/7/1991');
insert into Agent values('6851923T',24,'Mme','Annie-Claire','Nguyen-Ngoc','29 RUE MAXIME BOURDEAU','','17160','MATHA','9/2/1968','1/4/1991');
insert into Agent values('8402399T',24,'Mme','Isabelle','Giavara','RUE DE SAINTONGE','','17510','NERE','10/3/1984','1/5/2003');
insert into Agent values('5350113Q',24,'Mme','Bnedicte','Fouin','RUE HERPES','','17490','NEUVICQ LE CHATEAU','3/2/1953','1/3/1974');
insert into Agent values('8171791G',24,'Mme','Juliette','Floirac','6 RUE DE VOLTAIRE','FIEF DE LAFOND','17138','PUILBOREAU','26/11/1981','1/11/2001');
insert into Agent values('6469038N',25,'M.','Virgil','Charry','ST LAURENT DE LA PREE','LES COTEAUX','17450','FOURAS','23/4/1964','1/10/1987');
insert into Agent values('7485403H',25,'M.','Christophe','Bellicard','70 RUE DES GONTHIERES','','17000','LA ROCHELLE','1/2/1974','1/12/1995');
insert into Agent values('5622359K',25,'Mme','Linda','Bouchet','61 RUE MONTMIRAIL','','17000','LA ROCHELLE','17/4/1956','1/5/1977');
insert into Agent values('7263658F',25,'Mme','Laurence','Boulay','26 RUE DE L OISE','','17000','LA ROCHELLE','11/1/1972','1/11/1996');
insert into Agent values('5709857R',25,'Mme','Cline','Martin','99 RUE EMILE NORMANDIN','','17000','LA ROCHELLE','4/5/1957','1/11/1984');
insert into Agent values('6245903A',25,'M.','Thierry','Battin','4 RUE PABLO NERUDA','','17430','TONNAY-CHARENTE','22/3/1962','1/5/1988');
insert into Agent values('7862678P',26,'Mme','Carole','Carrias','APPT 54  LE TAILLEFER ','PLACE ST MARTIAL','16000','ANGOULEME','27/5/1978','1/2/2000');
insert into Agent values('6254490J',26,'M.','Jean','Ferreira','LE BOUT DES PONTS','','16200','JARNAC','27/8/1962','1/12/1984');
insert into Agent values('6045529C',26,'M.','Christophe','Speckens','LES EGAUDS NERCILLAC','','16200','JARNAC','19/12/1960','1/10/1980');
insert into Agent values('7201786D',26,'M.','Vincent','Sissac','265 TER AVENUE DU GENERAL DE GAULLE','','16800','SOYAUX','6/7/1972','1/8/1997');
insert into Agent values('8142275Z',26,'Mme','Christelle','Heraud','RUE DE LA MADELEINE','','16240','VILLEFAGNAN','3/7/1981','1/7/2002');
insert into Agent values('6700211N',27,'Mme','Leire','Chevalier','LE CANTON BULET','ST SULPICE DE COGNAC','16370','CHERVES RICHEMONT','1/9/1967','1/7/1992');
insert into Agent values('6712898D',27,'M.','Samuel','Barbeau','RUE DU FIEF AUX DAMES','','16100','COGNAC','15/6/1967','1/5/1994');
insert into Agent values('7197590T',27,'Mme','Catherine','Verdant','60 BLD DENFERT ROCHEREAU','','16100','COGNAC','22/12/1971','1/11/1991');
insert into Agent values('7139149V',27,'Mme','Emmanuelle','Nascimento','ROUTE DE CHAZELLES','','16110','PRANZAC','30/6/1971','1/5/1993');
insert into Agent values('5437565X',27,'Mme','Florence','Lanoir','BAT Q4 N27 RUE JULES RENARD','','16800','SOYAUX','23/10/1954','1/9/1983');
insert into Agent values('6506589E',27,'M.','Vincent','Leverdez','CHEZ GORON','','16370','ST SULPICE DE COGNAC','11/7/1965','1/6/1991');
insert into Agent values('8101457G',28,'M.','Olivier','Giresse','DOMAINE DU LAUBARET','','16130','GENSAC LA PALLUE','26/9/1981','1/3/2000');
insert into Agent values('8119337R',28,'Mme','Alexandra','Cabos','LE PUY DE NANTEUIL','','16600','MORNAC','28/1/1981','1/7/1999');
insert into Agent values('6183888T',29,'Mme','Catherine','Caniou','80 AVENUE DES AMANDIERS','','86180','BUXEROLLES','23/11/1961','1/11/1988');
insert into Agent values('6687655Q',29,'Mme','Ida','Le Du','21 RUE DES BUIS','','86280','ST BENOIT','27/1/1966','1/7/1988');
insert into Agent values('8192254Z',29,'M.','Christophe','Lebon','40 RUE JACQUES CARTIER','','86280','ST BENOIT','25/9/1981','1/5/2004');
insert into Agent values('6240370L',29,'M.','Olivier','Pruneau','LA ROCHE','','86580','VOUNEUIL/BIARD','13/10/1962','1/3/1985');
insert into Agent values('8298357D',30,'M.','Serge','Riviere','3 RUE ROMAINE','','86240','LIGUGE','22/7/1982','1/3/2004');
insert into Agent values('6378559R',30,'Mme','Leila','Dubreuil','LE BOURG','','86460','MAUPREVOIR','3/12/1963','1/3/1990');
insert into Agent values('7323427X',30,'Mme','Karine','Prevost','10 RUE DE LA FEE MELUSINE','','86470','MONTREUIL BONNIN','13/10/1973','1/3/1998');
insert into Agent values('6232351V',30,'M.','Fabrice','Berthier','5 RUE SAINTE LOUBETTE','','86000','POITIERS','13/8/1962','1/9/1989');
insert into Agent values('7413719Q',30,'Mme','Caroline','Brukhnoff','RUE DE EBG DU PONT NEUF','RES COLIGNY - APPT 20','86000','POITIERS','23/2/1974','1/1/1996');
insert into Agent values('8173943W',30,'M.','Stphane','Carliton','1-49 RESIDENCE BEAUPUY','','86000','POITIERS','5/12/1981','1/8/2000');
insert into Agent values('8105301K',30,'Mme','Vronique','Defontaine','127 GRAND RUE','','86000','POITIERS','27/3/1981','1/3/2004');
insert into Agent values('5339675V',30,'Mme','Franoise','Gouin','21 RUE DE LA VALLEE MONNAIE','','86000','POITIERS','30/11/1953','1/8/1977');
insert into Agent values('5547465D',30,'Mme','Claire','Guichane','33 RUE DU LIEUTENANT COLONEL','BRIAND','86000','POITIERS','6/12/1955','1/1/1980');
insert into Agent values('6432491N',30,'Mme','Ana Helena','Lahmied','90 RUE CARNOT','RESIDENCE CARNOT BLOSSAC','86000','POITIERS','28/8/1964','1/9/1988');
insert into Agent values('7294922N',30,'Mme','Sylvia','Maney','4 RESIDENCE DES TILLEULS','','86000','POITIERS','14/10/1972','1/3/1995');
insert into Agent values('7070771W',30,'Mme','Alexa','Maufrond','17 BIS RUE DU MAINE','','86000','POITIERS','26/3/1970','1/3/1996');
insert into Agent values('6136002T',30,'Mme','Catherine','Soloy','6 BIS AVENUE HOCHE  APPT 114','CITE SAINT ELOI','86000','POITIERS','17/10/1961','1/8/1987');
insert into Agent values('5364047L',31,'M.','Jean Christophe','Daniel','7 IMPASSE DE LA SABOTERIE','','86180','BRUXEROLLES','23/9/1953','1/9/1977');
insert into Agent values('5290570V',31,'Mme','Carine','Richard','52 CHEMIN DU ROC','','86100','CHATELLERAULT','11/2/1952','1/8/1976');
insert into Agent values('6095349E',31,'Mme','Anne','Diouf','7 RUE DE LA MORLIANE','','86700','COUHE VERAC','10/9/1960','1/4/1980');
insert into Agent values('8452410C',31,'Mme','Florence','Tcharaktchiev','27 RUE BANGOURA MORIDE','','86170','NEUVILLE DE POITOU','29/3/1984','1/3/2005');
insert into Agent values('6756018Y',31,'Mme','Sahondra','Portebois','LES GRANDES FORETS','','86350','ST SECONDIN','26/7/1967','1/1/1990');
insert into Agent values('6154954T',31,'Mme','Hlne','Pressac','LES GRANDES FORETS','','86350','ST SECONDIN','20/5/1961','1/11/1992');
insert into Agent values('5753641H',31,'Mme','Hlne','Destang','2 IMPASSE DES CHAILS','PRECHARAUX','86580','VOUNEUIL/BIARD','9/12/1957','1/11/1979');
insert into Agent values('5955258G',32,'Mme','Caroline','Metereau','1 RUE BASSE FONTAINE','','86240','FONTAINE LE COMTE','9/8/1959','1/8/1989');
insert into Agent values('7714468R',32,'M.','Didier','Wantiez','1 CITE DE LA GRANGE','','86200','LOUDUN','12/2/1977','1/6/2001');
insert into Agent values('7975245V',32,'M.','Charles','Guerchon','RUE DU CHENE','','86450','PLEUMARTIN','3/4/1979','1/10/1999');
go


insert into Distance values(3,1,48);
insert into Distance values(3,2,44);
insert into Distance values(3,3,0);
insert into Distance values(3,4,56);
insert into Distance values(3,5,49);
insert into Distance values(3,6,81);
insert into Distance values(3,7,177);
insert into Distance values(3,8,116);
insert into Distance values(3,9,123);
insert into Distance values(3,10,121);
insert into Distance values(3,11,88);
insert into Distance values(3,12,125);
insert into Distance values(3,13,103);
insert into Distance values(3,14,97);
insert into Distance values(3,15,285);
insert into Distance values(3,16,8);
insert into Distance values(3,17,305);
insert into Distance values(3,18,248);
insert into Distance values(3,19,235);
insert into Distance values(3,20,204);
insert into Distance values(3,21,191);
insert into Distance values(3,22,144);
insert into Distance values(3,23,176);
insert into Distance values(3,24,188);
insert into Distance values(3,25,215);
insert into Distance values(3,26,89);
insert into Distance values(3,27,123);
insert into Distance values(3,28,121);
insert into Distance values(3,29,156);
insert into Distance values(3,30,199);
insert into Distance values(3,31,212);
insert into Distance values(3,32,224);
insert into Distance values(9,1,96);
insert into Distance values(9,2,156);
insert into Distance values(9,3,123);
insert into Distance values(9,4,156);
insert into Distance values(9,5,163);
insert into Distance values(9,6,43);
insert into Distance values(9,7,59);
insert into Distance values(9,8,25);
insert into Distance values(9,9,0);
insert into Distance values(9,10,48);
insert into Distance values(9,11,29);
insert into Distance values(9,12,129);
insert into Distance values(9,13,85);
insert into Distance values(9,14,129);
insert into Distance values(9,15,189);
insert into Distance values(9,16,197);
insert into Distance values(9,17,212);
insert into Distance values(9,18,188);
insert into Distance values(9,19,144);
insert into Distance values(9,20,92);
insert into Distance values(9,21,121);
insert into Distance values(9,22,111);
insert into Distance values(9,23,113);
insert into Distance values(9,24,132);
insert into Distance values(9,25,164);
insert into Distance values(9,26,123);
insert into Distance values(9,27,111);
insert into Distance values(9,28,156);
insert into Distance values(9,29,235);
insert into Distance values(9,30,224);
insert into Distance values(9,31,256);
insert into Distance values(9,32,267);
insert into Distance values(12,1,88);
insert into Distance values(12,2,177);
insert into Distance values(12,3,125);
insert into Distance values(12,4,96);
insert into Distance values(12,5,132);
insert into Distance values(12,6,103);
insert into Distance values(12,7,164);
insert into Distance values(12,8,145);
insert into Distance values(12,9,129);
insert into Distance values(12,10,83);
insert into Distance values(12,11,116);
insert into Distance values(12,12,0);
insert into Distance values(12,13,57);
insert into Distance values(12,14,28);
insert into Distance values(12,15,204);
insert into Distance values(12,16,209);
insert into Distance values(12,17,205);
insert into Distance values(12,18,152);
insert into Distance values(12,19,151);
insert into Distance values(12,20,148);
insert into Distance values(12,21,108);
insert into Distance values(12,22,217);
insert into Distance values(12,23,233);
insert into Distance values(12,24,252);
insert into Distance values(12,25,272);
insert into Distance values(12,26,184);
insert into Distance values(12,27,236);
insert into Distance values(12,28,243);
insert into Distance values(12,29,276);
insert into Distance values(12,30,279);
insert into Distance values(12,31,311);
insert into Distance values(12,32,345);
insert into Distance values(18,1,203);
insert into Distance values(18,2,285);
insert into Distance values(18,3,248);
insert into Distance values(18,4,249);
insert into Distance values(18,5,251);
insert into Distance values(18,6,197);
insert into Distance values(18,7,167);
insert into Distance values(18,8,195);
insert into Distance values(18,9,188);
insert into Distance values(18,10,137);
insert into Distance values(18,11,177);
insert into Distance values(18,12,152);
insert into Distance values(18,13,148);
insert into Distance values(18,14,167);
insert into Distance values(18,15,96);
insert into Distance values(18,16,97);
insert into Distance values(18,17,71);
insert into Distance values(18,18,0);
insert into Distance values(18,19,56);
insert into Distance values(18,20,123);
insert into Distance values(18,21,72);
insert into Distance values(18,22,288);
insert into Distance values(18,23,275);
insert into Distance values(18,24,315);
insert into Distance values(18,25,343);
insert into Distance values(18,26,281);
insert into Distance values(18,27,281);
insert into Distance values(18,28,325);
insert into Distance values(18,29,396);
insert into Distance values(18,30,392);
insert into Distance values(18,31,433);
insert into Distance values(18,32,484);
insert into Distance values(21,1,144);
insert into Distance values(21,2,224);
insert into Distance values(21,3,191);
insert into Distance values(21,4,184);
insert into Distance values(21,5,204);
insert into Distance values(21,6,111);
insert into Distance values(21,7,101);
insert into Distance values(21,8,123);
insert into Distance values(21,9,121);
insert into Distance values(21,10,85);
insert into Distance values(21,11,123);
insert into Distance values(21,12,108);
insert into Distance values(21,13,93);
insert into Distance values(21,14,125);
insert into Distance values(21,15,103);
insert into Distance values(21,16,111);
insert into Distance values(21,17,109);
insert into Distance values(21,18,72);
insert into Distance values(21,19,56);
insert into Distance values(21,20,63);
insert into Distance values(21,21,0);
insert into Distance values(21,22,219);
insert into Distance values(21,23,204);
insert into Distance values(21,24,239);
insert into Distance values(21,25,268);
insert into Distance values(21,26,225);
insert into Distance values(21,27,216);
insert into Distance values(21,28,264);
insert into Distance values(21,29,331);
insert into Distance values(21,30,321);
insert into Distance values(21,31,364);
insert into Distance values(21,32,379);
insert into Distance values(22,1,155);
insert into Distance values(22,2,112);
insert into Distance values(22,3,144);
insert into Distance values(22,4,203);
insert into Distance values(22,5,188);
insert into Distance values(22,6,121);
insert into Distance values(22,7,168);
insert into Distance values(22,8,89);
insert into Distance values(22,9,111);
insert into Distance values(22,10,144);
insert into Distance values(22,11,100);
insert into Distance values(22,12,217);
insert into Distance values(22,13,172);
insert into Distance values(22,14,201);
insert into Distance values(22,15,295);
insert into Distance values(22,16,304);
insert into Distance values(22,17,325);
insert into Distance values(22,18,288);
insert into Distance values(22,19,248);
insert into Distance values(22,20,173);
insert into Distance values(22,21,219);
insert into Distance values(22,22,0);
insert into Distance values(22,23,43);
insert into Distance values(22,24,43);
insert into Distance values(22,25,69);
insert into Distance values(22,26,64);
insert into Distance values(22,27,39);
insert into Distance values(22,28,79);
insert into Distance values(22,29,155);
insert into Distance values(22,30,128);
insert into Distance values(22,31,159);
insert into Distance values(22,32,160);
insert into Distance values(26,1,119);
insert into Distance values(26,2,49);
insert into Distance values(26,3,89);
insert into Distance values(26,4,129);
insert into Distance values(26,5,115);
insert into Distance values(26,6,92);
insert into Distance values(26,7,171);
insert into Distance values(26,8,91);
insert into Distance values(26,9,123);
insert into Distance values(26,10,152);
insert into Distance values(26,11,92);
insert into Distance values(26,12,184);
insert into Distance values(26,13,144);
insert into Distance values(26,14,149);
insert into Distance values(26,15,297);
insert into Distance values(26,16,307);
insert into Distance values(26,17,327);
insert into Distance values(26,18,281);
insert into Distance values(26,19,251);
insert into Distance values(26,20,179);
insert into Distance values(26,21,225);
insert into Distance values(26,22,64);
insert into Distance values(26,23,103);
insert into Distance values(26,24,111);
insert into Distance values(26,25,137);
insert into Distance values(26,26,0);
insert into Distance values(26,27,39);
insert into Distance values(26,28,45);
insert into Distance values(26,29,111);
insert into Distance values(26,30,117);
insert into Distance values(26,31,148);
insert into Distance values(26,32,161);
insert into Distance values(30,1,229);
insert into Distance values(30,2,167);
insert into Distance values(30,3,199);
insert into Distance values(30,4,243);
insert into Distance values(30,5,229);
insert into Distance values(30,6,189);
insert into Distance values(30,7,283);
insert into Distance values(30,8,205);
insert into Distance values(30,9,224);
insert into Distance values(30,10,261);
insert into Distance values(30,11,201);
insert into Distance values(30,12,279);
insert into Distance values(30,13,264);
insert into Distance values(30,14,267);
insert into Distance values(30,15,416);
insert into Distance values(30,16,425);
insert into Distance values(30,17,440);
insert into Distance values(30,18,392);
insert into Distance values(30,19,363);
insert into Distance values(30,20,284);
insert into Distance values(30,21,321);
insert into Distance values(30,22,128);
insert into Distance values(30,23,181);
insert into Distance values(30,24,141);
insert into Distance values(30,25,136);
insert into Distance values(30,26,117);
insert into Distance values(30,27,149);
insert into Distance values(30,28,68);
insert into Distance values(30,29,51);
insert into Distance values(30,30,0);
insert into Distance values(30,31,32);
insert into Distance values(30,32,55);
go

insert into Inscription values(1,'6488615T',-1,0.00);
insert into Inscription values(1,'6497569A',-1,0.00);
insert into Inscription values(1,'6963884P',-1,0.00);
insert into Inscription values(1,'7108760N',-1,98.20);
insert into Inscription values(2,'6254490J',-1,405.80);
insert into Inscription values(2,'6874992T',-1,391.70);
insert into Inscription values(3,'6662847A',-1,0.00);
insert into Inscription values(3,'6756018Y',-1,305.00);
insert into Inscription values(3,'7110865B',0,0.00);
insert into Inscription values(3,'8140282H',-1,213.44);
insert into Inscription values(3,'8142275Z',-1,0.00);
insert into Inscription values(3,'8171791G',-1,303.88);
insert into Inscription values(4,'8139425B',-1,0.00);
insert into Inscription values(5,'5660861K',-1,0.00);
insert into Inscription values(5,'6293908E',-1,0.00);
insert into Inscription values(5,'6439971U',-1,0.00);
insert into Inscription values(5,'7702013D',-1,0.00);
insert into Inscription values(5,'8379854M',-1,0.00);
insert into Inscription values(6,'6560748Y',-1,234.70);
insert into Inscription values(6,'6851923T',-1,201.55);
insert into Inscription values(6,'7140024W',-1,0.00);
insert into Inscription values(6,'7430099V',-1,0.00);
insert into Inscription values(6,'7803406N',-1,197.65);
insert into Inscription values(6,'7950856K',-1,0.00);
insert into Inscription values(6,'7967964F',-1,358.90);
insert into Inscription values(7,'7263658F',-1,0.00);
insert into Inscription values(7,'7496457Y',-1,0.00);
insert into Inscription values(7,'8172625N',-1,0.00);
insert into Inscription values(7,'8334518J',-1,0.00);
insert into Inscription values(8,'5350113Q',-1,242.58);
insert into Inscription values(8,'6761916J',-1,0.00);
insert into Inscription values(8,'7968655G',-1,0.00);
insert into Inscription values(8,'8208554R',-1,0.00);
insert into Inscription values(9,'6071993T',-1,797.40);
insert into Inscription values(10,'5783214C',-1,0.00);
insert into Inscription values(10,'5983559U',-1,645.68);
insert into Inscription values(10,'6005141C',-1,411.52);
insert into Inscription values(10,'7191898F',-1,632.48);
insert into Inscription values(10,'7339861K',-1,578.48);
insert into Inscription values(10,'8101457G',-1,418.64);
insert into Inscription values(10,'8173943W',-1,0.00);
insert into Inscription values(11,'7197590T',-1,0.00);
insert into Inscription values(11,'7502300Z',-1,0.00);
insert into Inscription values(12,'5294136W',-1,148.52);
insert into Inscription values(12,'7774105P',-1,0.00);
insert into Inscription values(12,'8087591K',-1,0.00);
insert into Inscription values(12,'8120143T',-1,0.00);
insert into Inscription values(12,'8544662B',-1,0.00);
insert into Inscription values(12,'8574806R',-1,92.90);
insert into Inscription values(13,'5997101N',-1,576.30);
insert into Inscription values(13,'7108760N',-1,441.10);
insert into Inscription values(13,'7653904L',-1,0.00);
insert into Inscription values(14,'5645722E',-1,0.00);
insert into Inscription values(14,'6054503G',-1,0.00);
insert into Inscription values(14,'7193988C',-1,437.47);
insert into Inscription values(14,'7294922N',-1,466.51);
insert into Inscription values(14,'7500803X',-1,0.00);
insert into Inscription values(15,'5289449B',-1,0.00);
insert into Inscription values(15,'5500339E',-1,0.00);
insert into Inscription values(15,'5622359K',-1,0.00);
insert into Inscription values(15,'6573279U',-1,0.00);
insert into Inscription values(15,'6963884P',-1,0.00);
insert into Inscription values(15,'7067529X',-1,0.00);
insert into Inscription values(15,'7693355T',-1,0.00);
insert into Inscription values(15,'8007349Q',-1,0.00);
insert into Inscription values(15,'8164504L',-1,0.00);
insert into Inscription values(15,'8237832Q',-1,0.00);
insert into Inscription values(16,'5339675V',-1,0.00);
insert into Inscription values(16,'6243541H',-1,0.00);
insert into Inscription values(16,'6338288U',-1,0.00);
insert into Inscription values(16,'7440792T',-1,0.00);
insert into Inscription values(16,'7496457Y',-1,0.00);
insert into Inscription values(16,'7599760J',-1,0.00);
insert into Inscription values(16,'8086443M',-1,0.00);
insert into Inscription values(16,'8456797W',0,0.00);
insert into Inscription values(17,'5791758P',-1,166.02);
insert into Inscription values(17,'6042179L',-1,124.89);
insert into Inscription values(17,'6512883W',-1,0.00);
insert into Inscription values(17,'6688002T',-1,156.60);
insert into Inscription values(17,'7422453J',-1,244.77);
insert into Inscription values(17,'7590878E',-1,156.96);
insert into Inscription values(17,'8058465B',-1,119.37);
insert into Inscription values(17,'8196193F',-1,192.60);
insert into Inscription values(18,'5685000Y',-1,0.00);
insert into Inscription values(18,'5806661N',-1,0.00);
insert into Inscription values(18,'6140875P',-1,0.00);
insert into Inscription values(18,'6542320T',-1,0.00);
insert into Inscription values(18,'7118839U',-1,0.00);
insert into Inscription values(18,'8544662B',-1,0.00);
insert into Inscription values(20,'5679527Z',-1,1043.07);
insert into Inscription values(20,'8578906Y',-1,996.24);
insert into Inscription values(21,'8018131K',-1,1335.18);
insert into Inscription values(22,'5207415J',-1,247.76);
insert into Inscription values(22,'5661462N',-1,233.44);
insert into Inscription values(22,'6561519L',-1,200.16);
insert into Inscription values(22,'6586198L',-1,259.08);
insert into Inscription values(23,'5363278A',-1,0.00);
insert into Inscription values(23,'5369349Z',-1,0.00);
insert into Inscription values(23,'5385977Y',-1,0.00);
insert into Inscription values(23,'5842699K',-1,0.00);
insert into Inscription values(23,'5855699Q',-1,0.00);
insert into Inscription values(23,'6086843J',-1,0.00);
insert into Inscription values(23,'6358181R',-1,0.00);
insert into Inscription values(23,'6702307R',-1,0.00);
insert into Inscription values(23,'6889873T',-1,0.00);
insert into Inscription values(24,'5561384H',-1,140.40);
insert into Inscription values(24,'5847077U',-1,153.30);
insert into Inscription values(24,'5966381X',-1,225.00);
insert into Inscription values(25,'6993559V',-1,88.84);
insert into Inscription values(25,'7478532P',-1,130.50);
insert into Inscription values(25,'8045964N',-1,90.62);
insert into Inscription values(25,'8261920Y',-1,100.68);
insert into Inscription values(26,'5380675K',-1,0.00);
insert into Inscription values(26,'5841080A',-1,0.00);
insert into Inscription values(26,'6278957D',-1,0.00);
insert into Inscription values(26,'6853975Y',-1,0.00);
insert into Inscription values(26,'7141033T',-1,0.00);
insert into Inscription values(27,'7750860Y',-1,0.00);
insert into Inscription values(27,'8470180T',-1,126.58);
insert into Inscription values(28,'6183888T',-1,757.00);
insert into Inscription values(28,'7532892B',0,0.00);
insert into Inscription values(29,'7356505B',-1,0.00);
insert into Inscription values(30,'5685000Y',-1,286.62);
insert into Inscription values(30,'6539439L',-1,302.64);
insert into Inscription values(30,'7292674V',-1,320.82);
insert into Inscription values(30,'8379854M',-1,323.58);
insert into Inscription values(30,'8399203U',-1,309.48);
insert into Inscription values(31,'6282947Q',-1,142.74);
insert into Inscription values(31,'6459452U',0,0.00);
insert into Inscription values(31,'6560748Y',-1,0.00);
insert into Inscription values(31,'6682067R',-1,185.82);
insert into Inscription values(31,'6851923T',-1,176.94);
insert into Inscription values(31,'7183178C',-1,239.04);
insert into Inscription values(31,'7754232N',-1,0.00);
insert into Inscription values(31,'8033860G',-1,173.46);
insert into Inscription values(32,'5755049N',-1,0.00);
insert into Inscription values(32,'5994696Z',-1,0.00);
insert into Inscription values(32,'6388977Q',-1,0.00);
insert into Inscription values(32,'6855368M',-1,0.00);
insert into Inscription values(32,'6882038B',-1,0.00);
insert into Inscription values(32,'7193988C',-1,0.00);
insert into Inscription values(32,'7500803X',-1,0.00);
insert into Inscription values(32,'8100862K',-1,0.00);
insert into Inscription values(33,'5379323Q',-1,267.48);
insert into Inscription values(33,'6154954T',-1,0.00);
insert into Inscription values(33,'7284727G',-1,270.68);
insert into Inscription values(34,'5490558Y',-1,567.28);
insert into Inscription values(34,'5888728R',-1,475.20);
insert into Inscription values(34,'6544512A',-1,462.32);
insert into Inscription values(34,'7297879C',-1,587.28);
insert into Inscription values(34,'8070181L',-1,350.16);
insert into Inscription values(35,'6054503G',-1,0.00);
insert into Inscription values(35,'6128178N',-1,0.00);
insert into Inscription values(35,'6687655Q',-1,194.96);
insert into Inscription values(35,'6771168Q',-1,314.12);
insert into Inscription values(36,'5646951Q',-1,627.06);
insert into Inscription values(36,'7540751U',-1,918.40);
insert into Inscription values(37,'5592638E',-1,0.00);
insert into Inscription values(37,'5859545W',-1,0.00);
insert into Inscription values(37,'6131018A',-1,0.00);
insert into Inscription values(37,'6140875P',-1,0.00);
insert into Inscription values(37,'6899621N',-1,624.56);
insert into Inscription values(37,'7734381L',-1,394.80);
insert into Inscription values(37,'7774105P',-1,0.00);
insert into Inscription values(37,'8126260R',-1,386.00);
insert into Inscription values(38,'5466810K',-1,167.16);
insert into Inscription values(38,'6694924R',-1,237.80);
insert into Inscription values(38,'6831956P',-1,318.36);
insert into Inscription values(38,'8058123E',-1,179.36);
insert into Inscription values(39,'5723481A',-1,371.22);
insert into Inscription values(39,'6115516A',-1,276.00);
insert into Inscription values(39,'6669582W',-1,353.34);
insert into Inscription values(39,'8298357D',-1,386.64);
insert into Inscription values(39,'8318150T',-1,264.30);
insert into Inscription values(40,'5703629X',-1,0.00);
insert into Inscription values(40,'6083331R',-1,0.00);
insert into Inscription values(40,'6459452U',-1,0.00);
insert into Inscription values(40,'6746976V',-1,0.00);
insert into Inscription values(40,'7269589C',-1,0.00);
insert into Inscription values(40,'7422453J',-1,0.00);
insert into Inscription values(40,'7642838H',-1,0.00);
insert into Inscription values(41,'5582467Z',-1,0.00);
insert into Inscription values(41,'5621511N',-1,0.00);
insert into Inscription values(41,'5709857R',-1,177.80);
insert into Inscription values(41,'6183516N',-1,0.00);
insert into Inscription values(41,'6388893Z',-1,0.00);
insert into Inscription values(41,'7803406N',-1,211.44);
insert into Inscription values(41,'7862678P',-1,214.80);
insert into Inscription values(42,'5418294A',-1,447.12);
insert into Inscription values(42,'5542593H',-1,0.00);
insert into Inscription values(42,'6682995A',-1,273.78);
insert into Inscription values(42,'7339861K',-1,433.74);
insert into Inscription values(42,'8086567X',-1,0.00);
insert into Inscription values(42,'8173943W',-1,262.08);
insert into Inscription values(42,'8574806R',-1,240.12);
insert into Inscription values(43,'5518628J',-1,83.32);
insert into Inscription values(43,'6021979E',-1,0.00);
insert into Inscription values(43,'7447588E',-1,113.10);
insert into Inscription values(43,'7644063P',-1,135.68);
insert into Inscription values(43,'8083142Z',-1,131.94);
insert into Inscription values(44,'5628635G',-1,0.00);
insert into Inscription values(44,'5728436L',-1,0.00);
insert into Inscription values(44,'6263957Z',-1,0.00);
insert into Inscription values(44,'8279316G',-1,0.00);
insert into Inscription values(45,'5983559U',-1,120.54);
insert into Inscription values(45,'7994299F',-1,137.25);
insert into Inscription values(45,'8399203U',-1,123.03);
insert into Inscription values(46,'7263658F',-1,0.00);
insert into Inscription values(46,'7496457Y',-1,0.00);
insert into Inscription values(46,'8172625N',-1,0.00);
insert into Inscription values(46,'8334518J',-1,0.00);
insert into Inscription values(47,'5207415J',-1,205.52);
insert into Inscription values(47,'7975908Q',-1,296.64);
insert into Inscription values(47,'8431413E',-1,223.88);
insert into Inscription values(48,'5320239U',-1,370.24);
insert into Inscription values(48,'6191871V',-1,0.00);
insert into Inscription values(48,'6540490D',-1,0.00);
insert into Inscription values(48,'7356133X',-1,388.00);
insert into Inscription values(48,'7395875V',-1,0.00);
insert into Inscription values(48,'7823055W',-1,0.00);
insert into Inscription values(48,'7832516E',-1,0.00);
insert into Inscription values(49,'5418294A',-1,488.70);
insert into Inscription values(49,'6220726J',-1,0.00);
insert into Inscription values(49,'7118839U',-1,482.10);
insert into Inscription values(49,'7784916Q',-1,290.70);
insert into Inscription values(49,'8126260R',-1,0.00);
insert into Inscription values(50,'5903176W',-1,0.00);
insert into Inscription values(50,'5906259X',-1,0.00);
insert into Inscription values(50,'7292674V',-1,0.00);
insert into Inscription values(50,'8109230F',-1,0.00);
insert into Inscription values(50,'8132442L',-1,472.72);
insert into Inscription values(50,'8160529Q',-1,0.00);
insert into Inscription values(50,'8379854M',-1,0.00);
insert into Inscription values(51,'5369403H',-1,189.48);
insert into Inscription values(51,'6083331R',-1,0.00);
insert into Inscription values(51,'7950856K',-1,0.00);
insert into Inscription values(51,'8116381D',-1,0.00);
insert into Inscription values(52,'5437565X',-1,0.00);
insert into Inscription values(52,'5645722E',-1,277.56);
insert into Inscription values(52,'5916945M',-1,241.00);
insert into Inscription values(52,'6388977Q',-1,258.20);
insert into Inscription values(52,'7190103E',-1,237.36);
insert into Inscription values(52,'7554281A',-1,254.80);
insert into Inscription values(52,'8007349Q',-1,222.12);
insert into Inscription values(52,'8456797W',-1,159.52);
insert into Inscription values(53,'5994696Z',-1,0.00);
insert into Inscription values(53,'6660800A',-1,0.00);
insert into Inscription values(53,'6771168Q',-1,0.00);
insert into Inscription values(53,'7968175K',-1,0.00);
insert into Inscription values(54,'6778779N',-1,119.40);
insert into Inscription values(54,'7133679Z',0,0.00);
insert into Inscription values(55,'6382597F',-1,0.00);
insert into Inscription values(55,'6386889W',-1,0.00);
insert into Inscription values(55,'6539439L',-1,0.00);
insert into Inscription values(55,'7526716N',-1,0.00);
insert into Inscription values(55,'7774105P',-1,0.00);
insert into Inscription values(55,'7820082P',-1,0.00);
insert into Inscription values(55,'8282310L',-1,0.00);
insert into Inscription values(55,'8358038Z',-1,0.00);
insert into Inscription values(56,'5628635G',-1,157.14);
insert into Inscription values(56,'6518861U',-1,81.26);
insert into Inscription values(56,'7281548B',-1,0.00);
insert into Inscription values(56,'7586408W',-1,133.14);
insert into Inscription values(57,'5294136W',-1,0.00);
insert into Inscription values(57,'5859545W',-1,0.00);
insert into Inscription values(57,'6894003G',-1,0.00);
insert into Inscription values(57,'8021509G',-1,0.00);
insert into Inscription values(58,'6238651T',-1,0.00);
insert into Inscription values(58,'8216213R',-1,0.00);
insert into Inscription values(59,'5723379P',-1,0.00);
insert into Inscription values(59,'6171946M',-1,0.00);
insert into Inscription values(59,'6240370L',-1,0.00);
insert into Inscription values(59,'6460394T',-1,0.00);
insert into Inscription values(59,'7201786D',-1,0.00);
insert into Inscription values(59,'7374569L',-1,0.00);
insert into Inscription values(60,'5350113Q',-1,212.45);
insert into Inscription values(60,'5437191Q',-1,0.00);
insert into Inscription values(60,'7183178C',-1,0.00);
insert into Inscription values(60,'7281770T',-1,0.00);
insert into Inscription values(60,'7676645E',-1,0.00);
insert into Inscription values(61,'5895986F',-1,0.00);
insert into Inscription values(61,'7459234N',-1,0.00);
insert into Inscription values(61,'8025666A',-1,324.08);
insert into Inscription values(62,'5786167M',-1,0.00);
insert into Inscription values(62,'6756018Y',-1,244.74);
insert into Inscription values(62,'8238335M',-1,285.84);
insert into Inscription values(62,'8318150T',-1,0.00);
insert into Inscription values(62,'8431413E',-1,398.88);
insert into Inscription values(63,'5376567V',-1,220.92);
insert into Inscription values(63,'6016236M',-1,143.73);
insert into Inscription values(63,'7385936R',-1,133.53);
insert into Inscription values(63,'7992279K',-1,192.36);
insert into Inscription values(64,'5289449B',-1,0.00);
insert into Inscription values(64,'5644162J',-1,0.00);
insert into Inscription values(64,'5997101N',-1,271.16);
insert into Inscription values(64,'6086843J',-1,0.00);
insert into Inscription values(64,'7108760N',-1,282.84);
insert into Inscription values(64,'7327694K',-1,0.00);
insert into Inscription values(64,'7440792T',-1,0.00);
insert into Inscription values(64,'8206560Z',-1,181.16);
insert into Inscription values(65,'5726468X',-1,304.76);
insert into Inscription values(65,'6702307R',-1,298.32);
insert into Inscription values(66,'6873246V',-1,488.88);
insert into Inscription values(66,'7452659R',-1,0.00);
insert into Inscription values(67,'6306978L',-1,111.90);
insert into Inscription values(67,'7500803X',-1,150.74);
insert into Inscription values(68,'5418294A',-1,334.20);
insert into Inscription values(68,'6894003G',-1,356.10);
insert into Inscription values(68,'8021509G',-1,305.90);
insert into Inscription values(68,'8101457G',-1,396.65);
insert into Inscription values(69,'5872251G',-1,283.92);
insert into Inscription values(69,'5937418Q',-1,266.92);
insert into Inscription values(69,'7110865B',-1,283.76);
insert into Inscription values(70,'5669158D',-1,157.20);
insert into Inscription values(70,'5765889W',-1,181.68);
insert into Inscription values(70,'5791758P',-1,266.76);
insert into Inscription values(70,'6282947Q',-1,208.40);
insert into Inscription values(70,'6829118E',-1,285.84);
insert into Inscription values(70,'7721073W',-1,284.04);
insert into Inscription values(71,'5510841V',-1,153.33);
insert into Inscription values(71,'6293908E',-1,181.53);
insert into Inscription values(71,'7774105P',-1,170.85);
insert into Inscription values(71,'8173943W',-1,0.00);
insert into Inscription values(72,'6432491N',-1,154.76);
insert into Inscription values(72,'6951701X',-1,0.00);
insert into Inscription values(72,'7139149V',-1,142.84);
insert into Inscription values(73,'6045529C',0,0.00);
insert into Inscription values(73,'6338288U',-1,0.00);
insert into Inscription values(73,'7138408P',-1,0.00);
insert into Inscription values(73,'8206560Z',-1,0.00);
insert into Inscription values(74,'5437565X',-1,0.00);
insert into Inscription values(74,'6128178N',-1,0.00);
insert into Inscription values(74,'6238651T',-1,0.00);
insert into Inscription values(74,'6488615T',-1,0.00);
insert into Inscription values(74,'6687655Q',-1,0.00);
insert into Inscription values(74,'7197590T',-1,0.00);
insert into Inscription values(74,'7327694K',-1,0.00);
insert into Inscription values(74,'7554281A',-1,0.00);
insert into Inscription values(74,'7653904L',-1,0.00);
insert into Inscription values(75,'7485403H',-1,824.78);
insert into Inscription values(75,'7657837L',-1,646.03);
insert into Inscription values(76,'5612407T',-1,463.54);
insert into Inscription values(76,'8073747M',-1,851.62);
insert into Inscription values(77,'5584995X',-1,418.38);
insert into Inscription values(77,'5806661N',-1,291.30);
insert into Inscription values(77,'6005141C',-1,257.40);
insert into Inscription values(77,'6386889W',-1,447.54);
insert into Inscription values(77,'8126260R',-1,399.60);
insert into Inscription values(77,'8358038Z',-1,418.26);
insert into Inscription values(78,'6469038N',-1,0.00);
insert into Inscription values(78,'7439683M',-1,429.12);
insert into Inscription values(78,'7523282F',-1,395.04);
insert into Inscription values(78,'7766972L',-1,346.50);
insert into Inscription values(78,'8433036U',-1,236.22);
insert into Inscription values(79,'5316900P',-1,142.42);
insert into Inscription values(79,'6245903A',-1,96.74);
insert into Inscription values(79,'8101457G',-1,156.60);
insert into Inscription values(80,'5289449B',-1,0.00);
insert into Inscription values(80,'5369349Z',-1,0.00);
insert into Inscription values(80,'5855699Q',-1,0.00);
insert into Inscription values(80,'6086843J',-1,0.00);
insert into Inscription values(80,'6702307R',-1,0.00);
insert into Inscription values(80,'6889873T',-1,0.00);
insert into Inscription values(80,'7067529X',-1,0.00);
insert into Inscription values(80,'8164504L',-1,0.00);
insert into Inscription values(81,'5518628J',-1,0.00);
insert into Inscription values(81,'5908399Y',-1,0.00);
insert into Inscription values(81,'5969300V',-1,0.00);
insert into Inscription values(81,'6220281A',-1,0.00);
insert into Inscription values(81,'7644063P',-1,0.00);
insert into Inscription values(81,'7879178Z',-1,0.00);
insert into Inscription values(81,'8083142Z',-1,0.00);
insert into Inscription values(81,'8468091X',-1,0.00);
insert into Inscription values(82,'5582467Z',-1,250.08);
insert into Inscription values(82,'5720118V',-1,223.56);
insert into Inscription values(82,'6952227U',-1,293.76);
insert into Inscription values(82,'8192254Z',-1,293.12);
insert into Inscription values(83,'5344123E',-1,445.44);
insert into Inscription values(83,'6988388Z',-1,595.84);
insert into Inscription values(83,'8318150T',0,0.00);
insert into Inscription values(83,'8512520P',-1,551.12);
insert into Inscription values(84,'6245903A',-1,80.38);
insert into Inscription values(84,'6386889W',-1,102.10);
insert into Inscription values(84,'6712898D',-1,146.30);
insert into Inscription values(84,'7160300K',-1,96.56);
insert into Inscription values(84,'8279316G',-1,86.44);
insert into Inscription values(85,'5422967E',-1,0.00);
insert into Inscription values(85,'6187959T',-1,0.00);
insert into Inscription values(86,'8018131K',-1,0.00);
insert into Inscription values(87,'6228835Y',-1,0.00);
insert into Inscription values(87,'6388893Z',-1,0.00);
insert into Inscription values(87,'6406165Y',-1,0.00);
insert into Inscription values(87,'7311462R',-1,534.72);
insert into Inscription values(88,'7193988C',-1,217.30);
insert into Inscription values(88,'7440792T',-1,398.50);
insert into Inscription values(89,'5385977Y',-1,159.72);
insert into Inscription values(89,'5500339E',-1,280.20);
insert into Inscription values(89,'5755049N',-1,284.52);
insert into Inscription values(89,'6882038B',-1,263.00);
insert into Inscription values(89,'7138408P',-1,245.48);
insert into Inscription values(89,'7413719Q',-1,317.24);
insert into Inscription values(89,'8086443M',-1,288.88);
insert into Inscription values(89,'8241526F',-1,229.16);
insert into Inscription values(90,'5364047L',-1,1335.39);
insert into Inscription values(90,'8176007P',-1,1567.86);
insert into Inscription values(91,'6174331E',-1,273.05);
insert into Inscription values(91,'7696789A',-1,396.25);
insert into Inscription values(92,'5906259X',-1,0.00);
insert into Inscription values(92,'7471808F',-1,0.00);
insert into Inscription values(92,'7784916Q',-1,151.48);
insert into Inscription values(92,'8110994Y',-1,83.08);
insert into Inscription values(93,'7351040L',-1,708.40);
insert into Inscription values(93,'7869621L',-1,670.40);
insert into Inscription values(94,'5701341K',-1,0.00);
insert into Inscription values(94,'5723481A',-1,0.00);
insert into Inscription values(94,'6565428K',-1,0.00);
insert into Inscription values(95,'6147571T',-1,0.00);
insert into Inscription values(95,'6346754W',-1,0.00);
insert into Inscription values(95,'6439971U',-1,0.00);
insert into Inscription values(95,'6993559V',-1,0.00);
insert into Inscription values(95,'8050258F',-1,0.00);
insert into Inscription values(95,'8087591K',-1,0.00);
insert into Inscription values(95,'8126260R',-1,0.00);
insert into Inscription values(96,'6627296H',-1,0.00);
insert into Inscription values(96,'7238168Z',-1,0.00);
insert into Inscription values(97,'6829118E',-1,0.00);
insert into Inscription values(97,'7140024W',-1,0.00);
insert into Inscription values(97,'7967964F',-1,291.40);
insert into Inscription values(97,'7968655G',-1,0.00);
insert into Inscription values(97,'8116381D',-1,0.00);
insert into Inscription values(98,'6054503G',-1,0.00);
insert into Inscription values(98,'6358181R',-1,0.00);
insert into Inscription values(98,'6497569A',-1,0.00);
insert into Inscription values(98,'6660800A',-1,0.00);
insert into Inscription values(98,'6687655Q',-1,0.00);
insert into Inscription values(98,'6748778D',-1,0.00);
insert into Inscription values(98,'7502300Z',-1,0.00);
insert into Inscription values(98,'8254566E',-1,0.00);
insert into Inscription values(99,'5437191Q',-1,0.00);
insert into Inscription values(99,'6254849Z',-1,0.00);
insert into Inscription values(99,'6688002T',-1,0.00);
insert into Inscription values(99,'7590878E',-1,318.44);
insert into Inscription values(99,'7767226M',-1,0.00);
insert into Inscription values(99,'7838676A',-1,0.00);
insert into Inscription values(99,'7869824G',-1,0.00);
insert into Inscription values(100,'5927155K',-1,159.70);
insert into Inscription values(100,'6855368M',-1,94.80);
insert into Inscription values(100,'8139425B',-1,96.26);
insert into Inscription values(100,'8237832Q',-1,104.86);
insert into Inscription values(101,'5339675V',-1,0.00);
insert into Inscription values(101,'6858363T',-1,0.00);
insert into Inscription values(101,'6916001T',-1,0.00);
insert into Inscription values(101,'7599760J',-1,0.00);
insert into Inscription values(101,'7954339W',-1,0.00);
insert into Inscription values(102,'5294136W',-1,0.00);
insert into Inscription values(102,'5388753Q',-1,0.00);
insert into Inscription values(102,'6431481Q',-1,0.00);
insert into Inscription values(102,'7126217N',-1,0.00);
insert into Inscription values(102,'7466416V',-1,0.00);
insert into Inscription values(102,'8086567X',0,0.00);
insert into Inscription values(102,'8132442L',-1,0.00);
insert into Inscription values(103,'5847077U',-1,168.30);
insert into Inscription values(103,'5966381X',-1,172.50);
insert into Inscription values(104,'5542593H',-1,0.00);
insert into Inscription values(104,'7526716N',-1,0.00);
insert into Inscription values(104,'7820082P',-1,402.96);
insert into Inscription values(104,'8160529Q',-1,0.00);
insert into Inscription values(105,'5891178E',-1,0.00);
insert into Inscription values(105,'6988115C',-1,180.00);
insert into Inscription values(105,'7376050W',-1,0.00);
insert into Inscription values(105,'8080028P',-1,0.00);
insert into Inscription values(105,'8477522Y',-1,0.00);
insert into Inscription values(105,'8563996R',-1,0.00);
insert into Inscription values(106,'6191871V',-1,199.92);
insert into Inscription values(106,'7551507K',-1,136.41);
insert into Inscription values(106,'7832516E',-1,160.53);
insert into Inscription values(107,'5290570V',-1,0.00);
insert into Inscription values(107,'6045529C',-1,0.00);
insert into Inscription values(107,'6306978L',-1,0.00);
insert into Inscription values(107,'6308398E',-1,0.00);
insert into Inscription values(107,'7190103E',-1,0.00);
insert into Inscription values(107,'7413719Q',-1,0.00);
insert into Inscription values(107,'7954339W',-1,0.00);
insert into Inscription values(107,'8172625N',-1,0.00);
insert into Inscription values(108,'8046527A',-1,0.00);
insert into Inscription values(109,'5685000Y',-1,0.00);
insert into Inscription values(109,'5906259X',-1,413.88);
insert into Inscription values(109,'6131018A',-1,438.12);
insert into Inscription values(109,'6278957D',-1,0.00);
insert into Inscription values(109,'6518861U',-1,313.08);
insert into Inscription values(109,'6712898D',-1,443.10);
insert into Inscription values(110,'6147571T',-1,217.85);
insert into Inscription values(110,'6899621N',-1,222.10);
insert into Inscription values(110,'7339861K',-1,0.00);
insert into Inscription values(111,'6506338G',-1,0.00);
insert into Inscription values(111,'7426359E',-1,603.68);
insert into Inscription values(112,'6228835Y',-1,0.00);
insert into Inscription values(112,'6694924R',-1,0.00);
insert into Inscription values(112,'6744846E',-1,0.00);
insert into Inscription values(112,'7070771W',-1,205.20);
insert into Inscription values(112,'7767226M',-1,0.00);
insert into Inscription values(112,'7862678P',-1,389.30);
insert into Inscription values(112,'7869824G',-1,0.00);
insert into Inscription values(113,'7852679W',-1,848.54);
insert into Inscription values(113,'7975245V',-1,809.62);
insert into Inscription values(114,'5669158D',-1,200.56);
insert into Inscription values(114,'6124247Q',-1,229.08);
insert into Inscription values(114,'6682067R',-1,162.20);
insert into Inscription values(114,'7426830R',-1,224.28);
insert into Inscription values(114,'7642838H',-1,198.96);
insert into Inscription values(115,'5388753Q',-1,0.00);
insert into Inscription values(115,'6005141C',-1,0.00);
insert into Inscription values(115,'6346754W',-1,0.00);
insert into Inscription values(115,'6382597F',-1,0.00);
insert into Inscription values(116,'6388977Q',-1,244.83);
insert into Inscription values(116,'7197590T',-1,233.88);
insert into Inscription values(117,'5542593H',-1,0.00);
insert into Inscription values(117,'5592638E',-1,0.00);
insert into Inscription values(117,'5906259X',-1,0.00);
insert into Inscription values(117,'6431481Q',-1,0.00);
insert into Inscription values(117,'6542320T',-1,0.00);
insert into Inscription values(117,'6682995A',-1,0.00);
insert into Inscription values(118,'5646951Q',-1,688.05);
insert into Inscription values(118,'7540751U',-1,749.21);
insert into Inscription values(119,'5582467Z',-1,0.00);
insert into Inscription values(119,'5720118V',-1,0.00);
insert into Inscription values(119,'6530689A',-1,0.00);
insert into Inscription values(119,'6877795P',-1,0.00);
insert into Inscription values(119,'7426830R',-1,0.00);
insert into Inscription values(119,'7430099V',-1,0.00);
insert into Inscription values(119,'7535106H',-1,0.00);
insert into Inscription values(119,'7621538F',-1,0.00);
insert into Inscription values(119,'8033759X',-1,0.00);
insert into Inscription values(120,'5501250V',-1,283.44);
insert into Inscription values(120,'6975713X',-1,367.98);
insert into Inscription values(120,'7114912A',-1,368.10);
insert into Inscription values(120,'8070181L',-1,274.62);
insert into Inscription values(120,'8140282H',-1,394.08);
insert into Inscription values(121,'5752985V',-1,888.36);
insert into Inscription values(122,'5369403H',-1,300.25);
insert into Inscription values(122,'5720118V',-1,205.15);
insert into Inscription values(122,'6042179L',-1,399.40);
insert into Inscription values(122,'7105454V',-1,245.90);
insert into Inscription values(122,'7405439Q',-1,288.35);
insert into Inscription values(122,'8117984W',-1,363.05);
insert into Inscription values(122,'8275094T',-1,220.75);
insert into Inscription values(123,'5526502T',-1,0.00);
insert into Inscription values(123,'6526131W',-1,0.00);
insert into Inscription values(123,'7516105E',-1,0.00);
insert into Inscription values(124,'6254490J',-1,722.70);
insert into Inscription values(124,'6874992T',-1,512.50);
insert into Inscription values(125,'7126217N',-1,380.95);
insert into Inscription values(125,'7478532P',-1,0.00);
insert into Inscription values(125,'7702013D',-1,284.35);
insert into Inscription values(125,'8399203U',-1,345.75);
insert into Inscription values(126,'5316900P',-1,478.16);
insert into Inscription values(126,'5783214C',-1,318.00);
insert into Inscription values(126,'6382597F',-1,394.80);
insert into Inscription values(126,'6386889W',-1,513.92);
insert into Inscription values(126,'6469038N',-1,401.68);
insert into Inscription values(126,'6894003G',-1,563.44);
insert into Inscription values(126,'6993559V',-1,385.04);
insert into Inscription values(126,'7994299F',-1,613.28);
insert into Inscription values(127,'5290570V',-1,203.12);
insert into Inscription values(127,'6243541H',-1,296.08);
insert into Inscription values(127,'6308398E',-1,0.00);
insert into Inscription values(127,'6748778D',-1,215.88);
insert into Inscription values(127,'6916001T',-1,186.28);
insert into Inscription values(127,'6963884P',-1,250.52);
insert into Inscription values(127,'7139149V',-1,242.12);
insert into Inscription values(128,'6005141C',-1,203.95);
insert into Inscription values(128,'6439971U',-1,229.05);
insert into Inscription values(128,'7734381L',-1,222.20);
insert into Inscription values(129,'5753641H',-1,0.00);
insert into Inscription values(129,'7311462R',-1,0.00);
insert into Inscription values(129,'7430099V',-1,203.85);
insert into Inscription values(129,'7754232N',-1,0.00);
insert into Inscription values(129,'8196193F',-1,326.65);
insert into Inscription values(130,'5639922A',-1,0.00);
insert into Inscription values(130,'7191898F',-1,0.00);
insert into Inscription values(130,'8126260R',-1,151.44);
insert into Inscription values(130,'8282310L',-1,0.00);
insert into Inscription values(131,'5927155K',-1,0.00);
insert into Inscription values(131,'6771168Q',-1,0.00);
insert into Inscription values(131,'7113296U',-1,0.00);
insert into Inscription values(131,'7263658F',-1,0.00);
insert into Inscription values(131,'7294922N',-1,0.00);
insert into Inscription values(131,'7968175K',-1,0.00);
insert into Inscription values(131,'8139425B',-1,0.00);
insert into Inscription values(132,'5622359K',-1,0.00);
insert into Inscription values(132,'6855368M',-1,0.00);
insert into Inscription values(132,'7139149V',-1,0.00);
insert into Inscription values(133,'5510841V',-1,410.64);
insert into Inscription values(133,'5584995X',-1,0.00);
insert into Inscription values(133,'7281548B',-1,0.00);
insert into Inscription values(133,'7523282F',-1,250.44);
insert into Inscription values(133,'8101457G',-1,440.10);
insert into Inscription values(133,'8282310L',-1,0.00);
insert into Inscription values(134,'5339675V',-1,540.21);
insert into Inscription values(134,'5363278A',-1,0.00);
insert into Inscription values(134,'5369349Z',-1,0.00);
insert into Inscription values(134,'6917334R',-1,0.00);
insert into Inscription values(134,'6951701X',-1,0.00);
insert into Inscription values(134,'8254566E',-1,531.52);
insert into Inscription values(135,'6340694J',-1,317.22);
insert into Inscription values(135,'7576632V',-1,458.28);
insert into Inscription values(135,'8171791G',-1,453.78);
insert into Inscription values(135,'8189739Q',-1,428.82);
insert into Inscription values(135,'8238335M',-1,0.00);
insert into Inscription values(136,'5500339E',-1,0.00);
insert into Inscription values(136,'5755049N',-1,0.00);
insert into Inscription values(136,'6858363T',-1,0.00);
insert into Inscription values(137,'6518861U',-1,0.00);
insert into Inscription values(137,'8275121X',-1,0.00);
insert into Inscription values(138,'5538883A',-1,0.00);
insert into Inscription values(138,'5765889W',-1,0.00);
insert into Inscription values(138,'6136002T',-1,212.94);
insert into Inscription values(138,'6297469A',-1,0.00);
insert into Inscription values(138,'6682067R',-1,0.00);
insert into Inscription values(138,'6829118E',-1,0.00);
insert into Inscription values(138,'7635237W',-1,0.00);
insert into Inscription values(138,'7767226M',-1,0.00);
insert into Inscription values(138,'8053034Y',0,0.00);
insert into Inscription values(138,'8117984W',-1,0.00);
insert into Inscription values(139,'5521117P',-1,311.80);
insert into Inscription values(139,'6266525Q',-1,171.76);
insert into Inscription values(139,'7066334Y',-1,270.68);
insert into Inscription values(139,'7114912A',-1,186.52);
insert into Inscription values(140,'6136002T',-1,376.80);
insert into Inscription values(140,'6297469A',-1,0.00);
insert into Inscription values(140,'6952227U',-1,0.00);
insert into Inscription values(140,'7311462R',-1,575.12);
insert into Inscription values(140,'7887394E',-1,370.64);
insert into Inscription values(141,'5720574Q',-1,0.00);
insert into Inscription values(141,'5771041W',-1,0.00);
insert into Inscription values(141,'5891178E',-1,0.00);
insert into Inscription values(141,'6674312M',-1,636.88);
insert into Inscription values(142,'6573279U',-1,0.00);
insert into Inscription values(142,'6627296H',-1,0.00);
insert into Inscription values(142,'8334518J',-1,0.00);
insert into Inscription values(143,'5752985V',-1,724.40);
insert into Inscription values(144,'5709857R',-1,222.55);
insert into Inscription values(144,'5765889W',-1,0.00);
insert into Inscription values(144,'6406165Y',-1,0.00);
insert into Inscription values(144,'8275094T',-1,0.00);
insert into Inscription values(145,'5646809L',-1,263.96);
insert into Inscription values(145,'7714468R',0,0.00);
insert into Inscription values(146,'6016236M',-1,289.15);
insert into Inscription values(146,'6874492Z',-1,217.80);
insert into Inscription values(147,'5268414M',-1,191.68);
insert into Inscription values(147,'5872251G',-1,169.52);
insert into Inscription values(147,'6095349E',-1,191.80);
insert into Inscription values(147,'6866890L',-1,234.28);
insert into Inscription values(147,'6974703Z',-1,241.76);
insert into Inscription values(147,'7700469A',-1,0.00);
insert into Inscription values(148,'5258943T',-1,235.29);
insert into Inscription values(148,'5806661N',-1,234.63);
insert into Inscription values(148,'6542320T',-1,222.45);
insert into Inscription values(148,'7141033T',-1,171.87);
insert into Inscription values(148,'7994299F',-1,203.52);
insert into Inscription values(149,'7113296U',-1,0.00);
insert into Inscription values(149,'7238168Z',-1,0.00);
insert into Inscription values(149,'8100862K',-1,0.00);
insert into Inscription values(149,'8206560Z',-1,0.00);
insert into Inscription values(150,'6202630P',-1,156.36);
insert into Inscription values(150,'7067529X',-1,275.12);
insert into Inscription values(151,'5490558Y',-1,174.00);
insert into Inscription values(151,'7376050W',-1,173.28);
insert into Inscription values(151,'7576632V',-1,300.52);
insert into Inscription values(151,'8175321U',-1,318.36);
insert into Inscription values(152,'5726468X',-1,0.00);
insert into Inscription values(152,'5842699K',-1,0.00);
insert into Inscription values(152,'5916945M',-1,0.00);
insert into Inscription values(152,'5997101N',-1,0.00);
insert into Inscription values(152,'6202630P',-1,0.00);
insert into Inscription values(152,'6917334R',-1,0.00);
insert into Inscription values(152,'7693355T',-1,0.00);
insert into Inscription values(152,'7873280N',-1,0.00);
insert into Inscription values(152,'7954339W',-1,0.00);
insert into Inscription values(152,'8216213R',-1,0.00);
insert into Inscription values(153,'6147571T',0,0.00);
insert into Inscription values(153,'7466416V',-1,369.45);
insert into Inscription values(153,'8120143T',-1,234.10);
insert into Inscription values(154,'5644162J',-1,0.00);
insert into Inscription values(154,'7113296U',-1,0.00);
insert into Inscription values(154,'7873280N',-1,0.00);
insert into Inscription values(154,'7968175K',0,0.00);
insert into Inscription values(155,'5517282W',-1,292.36);
insert into Inscription values(155,'5610338U',-1,0.00);
insert into Inscription values(155,'6254849Z',-1,0.00);
insert into Inscription values(155,'7405439Q',-1,284.44);
insert into Inscription values(155,'7676645E',-1,0.00);
insert into Inscription values(155,'8053034Y',-1,0.00);
insert into Inscription values(156,'7238168Z',-1,0.00);
insert into Inscription values(156,'7599760J',-1,0.00);
insert into Inscription values(157,'6051031H',0,0.00);
insert into Inscription values(157,'6406165Y',-1,172.16);
insert into Inscription values(157,'6530689A',-1,174.16);
insert into Inscription values(157,'6761916J',-1,281.16);
insert into Inscription values(157,'6877795P',-1,0.00);
insert into Inscription values(157,'7311462R',-1,0.00);
insert into Inscription values(157,'8117984W',-1,0.00);
insert into Inscription values(158,'5841080A',-1,418.62);
insert into Inscription values(158,'6220726J',-1,475.92);
insert into Inscription values(158,'6382597F',-1,342.84);
insert into Inscription values(158,'6542320T',-1,374.10);
insert into Inscription values(158,'7766972L',-1,429.18);
insert into Inscription values(159,'5345011V',-1,248.10);
insert into Inscription values(159,'5592100V',-1,448.68);
insert into Inscription values(160,'7982521D',0,Null);
insert into Inscription values(161,'5510841V',0,Null);
insert into Inscription values(161,'5542593H',0,Null);
insert into Inscription values(161,'7744618N',0,Null);
insert into Inscription values(161,'7820082P',0,Null);
insert into Inscription values(161,'8261920Y',0,Null);
insert into Inscription values(162,'6916001T',0,Null);
insert into Inscription values(162,'8241526F',0,Null);
insert into Inscription values(163,'8119337R',0,Null);
insert into Inscription values(163,'8350816Z',0,Null);
insert into Inscription values(164,'6388893Z',0,Null);
insert into Inscription values(164,'7070771W',0,Null);
insert into Inscription values(164,'7887394E',0,Null);
insert into Inscription values(164,'8192254Z',0,Null);
insert into Inscription values(165,'6505921D',0,Null);
insert into Inscription values(165,'7475472N',0,Null);
insert into Inscription values(166,'5783214C',0,Null);
insert into Inscription values(166,'6853975Y',0,Null);
insert into Inscription values(166,'7292674V',0,Null);
insert into Inscription values(166,'8379854M',0,Null);
insert into Inscription values(167,'5316900P',0,Null);
insert into Inscription values(167,'5418294A',0,Null);
insert into Inscription values(167,'7471808F',0,Null);
insert into Inscription values(167,'7744618N',0,Null);
insert into Inscription values(167,'8279316G',0,Null);
insert into Inscription values(167,'8399203U',0,Null);
insert into Inscription values(167,'8544662B',0,Null);
insert into Inscription values(168,'5458854M',0,Null);
insert into Inscription values(168,'8012062N',0,Null);
insert into Inscription values(168,'8156278V',0,Null);
insert into Inscription values(168,'8402399T',0,Null);
go

exec sp_addlogin 'informa', 'ticien'
exec sp_grantdbaccess informa
exec sp_addsrvrolemember informa, securityadmin
exec sp_addrolemember db_owner, informa
exec sp_addlogin 'gestionForma', '65fic8ef'
exec sp_grantdbaccess gestionForma
exec sp_addrole gestion
exec sp_addrolemember gestion, gestionForma
go

grant select, insert, update, delete on activite to gestion
grant select, insert, update, delete on action to gestion
grant select, insert, update, delete on session to gestion
grant select, insert, update, delete on inscription to gestion
grant select, insert, update, delete on agent to gestion
grant select, insert, update, delete on lieu to gestion
grant select, insert, update, delete on distance to gestion
grant select, insert, update, delete on parametre to gestion
-- toutes autorisations accordes :  grer correctement par les lves
go
