﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using System.Collections.ObjectModel;// pour ObservableCollection
using System.Globalization; // pour cultureinfo



namespace covoiturage
{
    public partial class mesOffres : PhoneApplicationPage
    {
        private ObservableCollection<modele.OffreDepartEntreprise> mesOffresDepartEntreprise;
        private ObservableCollection<modele.OffreDepartDomicile> mesOffresDepartDomicile;
        private modele.Chauffeur chauffeur;
        public mesOffres()
        {
            InitializeComponent();
            this.chauffeur = (modele.Chauffeur)PhoneApplicationService.Current.State["chauffeur"];
            string idChauffeur = this.chauffeur.id.ToString(); 
            this.mesOffresDepartEntreprise = new ObservableCollection<modele.OffreDepartEntreprise>(modele.Contexte.getMesOffresDepartEntreprise(idChauffeur));
            this.mesOffresDepartDomicile = new ObservableCollection<modele.OffreDepartDomicile>(modele.Contexte.getMesOffresDepartDomicile(idChauffeur));
            this.lstDepartEntreprise.ItemsSource = this.mesOffresDepartEntreprise;
            this.lstDepartDomicile.ItemsSource = this.mesOffresDepartDomicile;
        
           

        }
       private void lstDepartEntreprise_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            modele.OffreDepartEntreprise offre ;
            if (e.AddedItems.Count > 0)
            {
                offre = (modele.OffreDepartEntreprise)e.AddedItems[0];
                var confirmer = MessageBox.Show("Confirmez la suppression", "Supprimer une offre", MessageBoxButton.OKCancel);
                if (confirmer == MessageBoxResult.OK)
                {
                    this.mesOffresDepartEntreprise.Remove(offre);
                    modele.Contexte.supprimeroffre(offre);
                }
            }
         
        }

       private void lstDepartDomicile_SelectionChanged(object sender, SelectionChangedEventArgs e)
       {
           modele.OffreDepartDomicile offre;
           if (e.AddedItems.Count > 0)
           {
               offre = (modele.OffreDepartDomicile)e.AddedItems[0];
               var confirmer = MessageBox.Show("Confirmez la suppression", "Supprimer une offre", MessageBoxButton.OKCancel);
               if (confirmer == MessageBoxResult.OK)
               {
                   this.mesOffresDepartDomicile.Remove(offre);
                   modele.Contexte.supprimeroffre(offre);
               }
           }
         
       }

       private void depart_Checked(object sender, RoutedEventArgs e)
       {
          
          
       }

       private void depart_Unchecked(object sender, RoutedEventArgs e)
       {
           

       }

        

       

       
    }
}