﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

using System.Collections.ObjectModel; //pour ObservableCollection


namespace covoiturage
{
    public partial class inscription : PhoneApplicationPage
    {
        public modele.Chauffeur unChauffeur;
        private ObservableCollection<ValidationError> errors = new ObservableCollection<ValidationError>();
        public inscription()
        {
            InitializeComponent();
            this.stPanelUser.Visibility = Visibility.Collapsed;
            unChauffeur = new modele.Chauffeur();
            this.LayoutRoot.DataContext = unChauffeur;
        }
        private void btnEnvoyer_Click(object sender, RoutedEventArgs e)
        {

            this.txtNom.GetBindingExpression(TextBox.TextProperty).UpdateSource();
            this.txtMail.GetBindingExpression(TextBox.TextProperty).UpdateSource();
            this.txtTel.GetBindingExpression(TextBox.TextProperty).UpdateSource();
            if (this.errors.Count == 0)
            {
                this.stPanelUser.Visibility = Visibility.Visible;
                String[] login = modele.Contexte.getLogin(this.txtNom.Text, this.txtPrenom.Text);
                txtUser.Text = login[0];
                txtMdp.Text = login[1];
                modele.Contexte.ajouteChauffeur(unChauffeur);
            }

        }
        private void StackPanel_BindingValidationError(object sender, ValidationErrorEventArgs e)
        {
            if (e.Action == ValidationErrorEventAction.Added)
            {
                errors.Add(e.Error);

            }
            else
                if (e.Action == ValidationErrorEventAction.Removed)
                {
                    errors.Remove(e.Error);
                }
            this.listBoxErreur.ItemsSource = this.errors;
        }
    }
}