﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell; // pour PhoneApplicationService
using Microsoft.Phone.Tasks; /// pour envoi de mail et tel

namespace covoiturage
{
    public partial class uneOffre : PhoneApplicationPage
    {
        private modele.Chauffeur chauffeur;
        public uneOffre()
        {
            InitializeComponent();
            if ((string)PhoneApplicationService.Current.State["typeOffre"] == "departEntreprise")
            {
                this.chauffeur = (modele.Chauffeur)PhoneApplicationService.Current.State["chauffeur"];
                this.txtLegendeRamassage.Visibility = Visibility.Collapsed;
            }
            else
            {
                this.txtLegendeRamassage.Visibility = Visibility.Visible;
                modele.OffreDepartDomicile offre = ((modele.OffreDepartDomicile)PhoneApplicationService.Current.State["offre"]);
                this.chauffeur = offre.chauffeur;
                List<string>  lesRamassages = offre.ramassages.ToList<string>();
                this.listRamassages.ItemsSource = lesRamassages;
            }
            this.stPanel.DataContext = this.chauffeur;
        }
        private void Image_Tap(object sender, GestureEventArgs e)
        {
            EmailComposeTask mail = new EmailComposeTask();
            mail.Show();
        }

        private void Image_Tap_1(object sender, GestureEventArgs e)
        {
            PhoneCallTask tel = new PhoneCallTask();
            tel.PhoneNumber = this.chauffeur.tel;
            tel.DisplayName = this.chauffeur.prenom;
            tel.Show();

        }
    }
}