﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Collections.ObjectModel; //pour ObservableCollection

namespace covoiturage
{
    public partial class inscription : PhoneApplicationPage
    {
            private ObservableCollection<ValidationError> errors = new ObservableCollection<ValidationError>();
            public modele.Chauffeur unChauffeur;
            public inscription()
            {
                InitializeComponent();
                unChauffeur = new modele.Chauffeur();
                this.LayoutRoot.DataContext = unChauffeur;
            }
        private void btnEnvoyer_Click(object sender, RoutedEventArgs e)
            {
                try
                {
                    this.txtNom.GetBindingExpression(TextBox.TextProperty).UpdateSource();

                    if (this.errors.Count == 0)
                    {

                      modele.Contexte.ajouteChauffeur(unChauffeur);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
          
        }

        private void StackPanel_BindingValidationError(object sender, ValidationErrorEventArgs e)
        {
            if (e.Action == ValidationErrorEventAction.Added)
            {
                errors.Add(e.Error);
            }
            else
                if (e.Action == ValidationErrorEventAction.Removed)
                {
                    errors.Remove(e.Error);
                }
            this.listBoxErreur.ItemsSource = this.errors;
        }

        
    }
}