--
-- PostgreSQL database dump
--

-- Dumped from database version 10.13 (Debian 10.13-1.pgdg90+1)
-- Dumped by pg_dump version 12.3 (Debian 12.3-1.pgdg100+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    name character varying NOT NULL,
    currency_id integer,
    code character varying(64) NOT NULL,
    deprecated boolean,
    user_type_id integer NOT NULL,
    internal_type character varying,
    internal_group character varying,
    reconcile boolean,
    note text,
    company_id integer NOT NULL,
    group_id integer,
    root_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.name IS 'Name';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.code IS 'Code';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.user_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.user_type_id IS 'Type';


--
-- Name: COLUMN account_account.internal_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.internal_type IS 'Internal Type';


--
-- Name: COLUMN account_account.internal_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.internal_group IS 'Internal Group';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.company_id IS 'Company';


--
-- Name: COLUMN account_account.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.group_id IS 'Group';


--
-- Name: COLUMN account_account.root_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.root_id IS 'Root';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    applicability character varying NOT NULL,
    color integer,
    active boolean,
    tax_negate boolean,
    country_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_account_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_template (
    id integer NOT NULL,
    name character varying NOT NULL,
    currency_id integer,
    code character varying(64) NOT NULL,
    user_type_id integer NOT NULL,
    reconcile boolean,
    note text,
    nocreate boolean,
    chart_template_id integer,
    group_id integer,
    root_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_template IS 'Templates for Accounts';


--
-- Name: COLUMN account_account_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.name IS 'Name';


--
-- Name: COLUMN account_account_template.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account_template.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.code IS 'Code';


--
-- Name: COLUMN account_account_template.user_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.user_type_id IS 'Type';


--
-- Name: COLUMN account_account_template.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.reconcile IS 'Allow Invoices & payments Matching';


--
-- Name: COLUMN account_account_template.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.note IS 'Note';


--
-- Name: COLUMN account_account_template.nocreate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.nocreate IS 'Optional Create';


--
-- Name: COLUMN account_account_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_account_template.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.group_id IS 'Group';


--
-- Name: COLUMN account_account_template.root_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.root_id IS 'Root';


--
-- Name: COLUMN account_account_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_account_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_template.write_date IS 'Last Updated on';


--
-- Name: account_account_template_account_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_template_account_tag (
    account_account_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_template_account_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_template_account_tag IS 'RELATION BETWEEN account_account_template AND account_account_tag';


--
-- Name: account_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_template_id_seq OWNED BY public.account_account_template.id;


--
-- Name: account_account_template_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_template_tax_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_account_template_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_template_tax_rel IS 'RELATION BETWEEN account_account_template AND account_tax_template';


--
-- Name: account_account_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    include_initial_balance boolean,
    type character varying NOT NULL,
    internal_group character varying NOT NULL,
    note text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_type IS 'Account Type';


--
-- Name: COLUMN account_account_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.name IS 'Account Type';


--
-- Name: COLUMN account_account_type.include_initial_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.include_initial_balance IS 'Bring Accounts Balance Forward';


--
-- Name: COLUMN account_account_type.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.type IS 'Type';


--
-- Name: COLUMN account_account_type.internal_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.internal_group IS 'Internal Group';


--
-- Name: COLUMN account_account_type.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.note IS 'Description';


--
-- Name: COLUMN account_account_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.create_date IS 'Created on';


--
-- Name: COLUMN account_account_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_type.write_date IS 'Last Updated on';


--
-- Name: account_account_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_type_id_seq OWNED BY public.account_account_type.id;


--
-- Name: account_account_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_type_rel (
    journal_id integer NOT NULL,
    account_id integer NOT NULL
);


--
-- Name: TABLE account_account_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_type_rel IS 'RELATION BETWEEN account_journal AND account_account';


--
-- Name: account_accrual_accounting_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_accrual_accounting_wizard (
    id integer NOT NULL,
    date date NOT NULL,
    company_id integer NOT NULL,
    account_type character varying,
    percentage double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_accrual_accounting_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_accrual_accounting_wizard IS 'Create accrual entry.';


--
-- Name: COLUMN account_accrual_accounting_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrual_accounting_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrual_accounting_wizard.account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_accrual_accounting_wizard.percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.percentage IS 'Percentage';


--
-- Name: COLUMN account_accrual_accounting_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrual_accounting_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrual_accounting_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrual_accounting_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrual_accounting_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrual_accounting_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_accrual_accounting_wizard_account_move_line_rel (
    account_accrual_accounting_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


--
-- Name: TABLE account_accrual_accounting_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_accrual_accounting_wizard_account_move_line_rel IS 'RELATION BETWEEN account_accrual_accounting_wizard AND account_move_line';


--
-- Name: account_accrual_accounting_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_accrual_accounting_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_accrual_accounting_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_accrual_accounting_wizard_id_seq OWNED BY public.account_accrual_accounting_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    code character varying,
    active boolean,
    group_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.group_id IS 'Group';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_distribution; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_distribution (
    id integer NOT NULL,
    account_id integer NOT NULL,
    percentage double precision NOT NULL,
    tag_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT account_analytic_distribution_check_percentage CHECK (((percentage >= (0)::double precision) AND (percentage <= (100)::double precision)))
);


--
-- Name: TABLE account_analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_distribution IS 'Analytic Account Distribution';


--
-- Name: COLUMN account_analytic_distribution.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_distribution.percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.percentage IS 'Percentage';


--
-- Name: COLUMN account_analytic_distribution.tag_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.tag_id IS 'Parent tag';


--
-- Name: COLUMN account_analytic_distribution.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_analytic_distribution_check_percentage ON account_analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_analytic_distribution_check_percentage ON public.account_analytic_distribution IS 'CHECK(percentage >= 0 AND percentage <= 100)';


--
-- Name: account_analytic_distribution_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_distribution_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_distribution_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_distribution_id_seq OWNED BY public.account_analytic_distribution.id;


--
-- Name: account_analytic_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_group (
    id integer NOT NULL,
    parent_path character varying,
    name character varying NOT NULL,
    description text,
    parent_id integer,
    complete_name character varying,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_group IS 'Analytic Categories';


--
-- Name: COLUMN account_analytic_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.name IS 'Name';


--
-- Name: COLUMN account_analytic_group.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.description IS 'Description';


--
-- Name: COLUMN account_analytic_group.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_group.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_group.write_date IS 'Last Updated on';


--
-- Name: account_analytic_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_group_id_seq OWNED BY public.account_analytic_group.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    name character varying NOT NULL,
    date date NOT NULL,
    amount numeric NOT NULL,
    unit_amount double precision,
    product_uom_id integer,
    account_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    group_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    product_id integer,
    general_account_id integer,
    move_id integer,
    code character varying(8),
    ref character varying,
    so_line integer
);


--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.group_id IS 'Group';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.move_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line_tag_rel (
    line_id integer NOT NULL,
    tag_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_line_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line_tag_rel IS 'RELATION BETWEEN account_analytic_line AND account_analytic_tag';


--
-- Name: account_analytic_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    active boolean,
    active_analytic_distribution boolean,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_tag IS 'Analytic Tags';


--
-- Name: COLUMN account_analytic_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.name IS 'Analytic Tag';


--
-- Name: COLUMN account_analytic_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.color IS 'Color Index';


--
-- Name: COLUMN account_analytic_tag.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.active IS 'Active';


--
-- Name: COLUMN account_analytic_tag.active_analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.active_analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_tag.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_tag.write_date IS 'Last Updated on';


--
-- Name: account_analytic_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_analytic_tag';


--
-- Name: account_analytic_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_tag_id_seq OWNED BY public.account_analytic_tag.id;


--
-- Name: account_analytic_tag_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_tag_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_tag_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_tag_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_analytic_tag';


--
-- Name: account_analytic_tag_sale_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_tag_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_tag_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_tag_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_analytic_tag';


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying,
    reference character varying,
    date date NOT NULL,
    date_done timestamp without time zone,
    balance_start numeric,
    balance_end_real numeric,
    accounting_date date,
    state character varying NOT NULL,
    journal_id integer NOT NULL,
    company_id integer,
    total_entry_encoding numeric,
    balance_end numeric,
    difference numeric,
    user_id integer,
    cashbox_start_id integer,
    cashbox_end_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.date_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.date_done IS 'Closed On';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.accounting_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.accounting_date IS 'Accounting Date';


--
-- Name: COLUMN account_bank_statement.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.state IS 'Status';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.total_entry_encoding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.total_entry_encoding IS 'Transactions Subtotal';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.difference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.difference IS 'Difference';


--
-- Name: COLUMN account_bank_statement.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.user_id IS 'Responsible';


--
-- Name: COLUMN account_bank_statement.cashbox_start_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.cashbox_start_id IS 'Starting Cashbox';


--
-- Name: COLUMN account_bank_statement.cashbox_end_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.cashbox_end_id IS 'Ending Cashbox';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_cashbox; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_cashbox (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement_cashbox; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_cashbox IS 'Bank Statement Cashbox';


--
-- Name: COLUMN account_bank_statement_cashbox.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_cashbox.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_cashbox.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_cashbox.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_cashbox_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_cashbox_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_cashbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_cashbox_id_seq OWNED BY public.account_bank_statement_cashbox.id;


--
-- Name: account_bank_statement_closebalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_closebalance (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement_closebalance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_closebalance IS 'Bank Statement Closing Balance';


--
-- Name: COLUMN account_bank_statement_closebalance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_closebalance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_closebalance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_closebalance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_closebalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_closebalance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_closebalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_closebalance_id_seq OWNED BY public.account_bank_statement_closebalance.id;


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_import (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_import IS 'Import Bank Statement';


--
-- Name: COLUMN account_bank_statement_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_import_id_seq OWNED BY public.account_bank_statement_import.id;


--
-- Name: account_bank_statement_import_ir_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_import_ir_attachment_rel (
    account_bank_statement_import_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


--
-- Name: TABLE account_bank_statement_import_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_import_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement_import AND ir_attachment';


--
-- Name: account_bank_statement_import_journal_creation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_import_journal_creation (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement_import_journal_creation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_import_journal_creation IS 'Journal Creation on Bank Statement Import';


--
-- Name: COLUMN account_bank_statement_import_journal_creation.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import_journal_creation.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_import_journal_creation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import_journal_creation.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_import_journal_creation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import_journal_creation.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_import_journal_creation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import_journal_creation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_import_journal_creation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_import_journal_creation.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_import_journal_creation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_import_journal_creation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_import_journal_creation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_import_journal_creation_id_seq OWNED BY public.account_bank_statement_import_journal_creation.id;


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    name character varying NOT NULL,
    date date NOT NULL,
    amount numeric,
    partner_id integer,
    account_number character varying,
    bank_account_id integer,
    account_id integer,
    statement_id integer NOT NULL,
    journal_id integer,
    partner_name character varying,
    ref character varying,
    note text,
    transaction_type character varying,
    sequence integer,
    company_id integer,
    amount_currency numeric,
    currency_id integer,
    move_name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    unique_import_id character varying
);


--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.name IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_bank_statement_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.account_id IS 'Counterpart Account';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.ref IS 'Reference';


--
-- Name: COLUMN account_bank_statement_line.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.note IS 'Notes';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_bank_statement_line.move_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.move_name IS 'Journal Entry Name';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    name character varying NOT NULL,
    rounding double precision NOT NULL,
    strategy character varying NOT NULL,
    account_id integer,
    rounding_method character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.account_id IS 'Account';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_cashbox_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_cashbox_line (
    id integer NOT NULL,
    coin_value numeric NOT NULL,
    number integer,
    cashbox_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_cashbox_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_cashbox_line IS 'CashBox Line';


--
-- Name: COLUMN account_cashbox_line.coin_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.coin_value IS 'Coin/Bill Value';


--
-- Name: COLUMN account_cashbox_line.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.number IS '#Coins/Bills';


--
-- Name: COLUMN account_cashbox_line.cashbox_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.cashbox_id IS 'Cashbox';


--
-- Name: COLUMN account_cashbox_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cashbox_line.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_cashbox_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_cashbox_line_id_seq OWNED BY public.account_cashbox_line.id;


--
-- Name: account_chart_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_chart_template (
    id integer NOT NULL,
    name character varying NOT NULL,
    parent_id integer,
    code_digits integer NOT NULL,
    visible boolean,
    currency_id integer NOT NULL,
    use_anglo_saxon boolean,
    complete_tax_set boolean,
    bank_account_code_prefix character varying NOT NULL,
    cash_account_code_prefix character varying NOT NULL,
    transfer_account_code_prefix character varying NOT NULL,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    default_pos_receivable_account_id integer,
    property_account_receivable_id integer,
    property_account_payable_id integer,
    property_account_expense_categ_id integer,
    property_account_income_categ_id integer,
    property_account_expense_id integer,
    property_account_income_id integer,
    property_stock_account_input_categ_id integer,
    property_stock_account_output_categ_id integer,
    property_stock_valuation_account_id integer,
    property_tax_payable_account_id integer,
    property_tax_receivable_account_id integer,
    property_advance_tax_payment_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_chart_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_chart_template IS 'Account Chart Template';


--
-- Name: COLUMN account_chart_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.name IS 'Name';


--
-- Name: COLUMN account_chart_template.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.parent_id IS 'Parent Chart Template';


--
-- Name: COLUMN account_chart_template.code_digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.code_digits IS '# of Digits';


--
-- Name: COLUMN account_chart_template.visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.visible IS 'Can be Visible?';


--
-- Name: COLUMN account_chart_template.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.currency_id IS 'Currency';


--
-- Name: COLUMN account_chart_template.use_anglo_saxon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.use_anglo_saxon IS 'Use Anglo-Saxon accounting';


--
-- Name: COLUMN account_chart_template.complete_tax_set; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.complete_tax_set IS 'Complete Set of Taxes';


--
-- Name: COLUMN account_chart_template.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN account_chart_template.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.cash_account_code_prefix IS 'Prefix of the main cash accounts';


--
-- Name: COLUMN account_chart_template.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.transfer_account_code_prefix IS 'Prefix of the main transfer accounts';


--
-- Name: COLUMN account_chart_template.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_income_account_id IS 'Cash Difference Income Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_expense_account_id IS 'Cash Difference Expense Account';


--
-- Name: COLUMN account_chart_template.default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.default_pos_receivable_account_id IS 'PoS receivable account';


--
-- Name: COLUMN account_chart_template.property_account_receivable_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_receivable_id IS 'Receivable Account';


--
-- Name: COLUMN account_chart_template.property_account_payable_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_payable_id IS 'Payable Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_categ_id IS 'Category of Expense Account';


--
-- Name: COLUMN account_chart_template.property_account_income_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_categ_id IS 'Category of Income Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_id IS 'Expense Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_account_income_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_id IS 'Income Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_stock_account_input_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_input_categ_id IS 'Input Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_account_output_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_output_categ_id IS 'Output Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_valuation_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_stock_valuation_account_id IS 'Account Template for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_tax_payable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_tax_payable_account_id IS 'Tax current account (payable)';


--
-- Name: COLUMN account_chart_template.property_tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_tax_receivable_account_id IS 'Tax current account (receivable)';


--
-- Name: COLUMN account_chart_template.property_advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.property_advance_tax_payment_account_id IS 'Advance tax payment account';


--
-- Name: COLUMN account_chart_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_chart_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.create_date IS 'Created on';


--
-- Name: COLUMN account_chart_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_chart_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_chart_template.write_date IS 'Last Updated on';


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_chart_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_chart_template_id_seq OWNED BY public.account_chart_template.id;


--
-- Name: account_common_journal_report; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_common_journal_report (
    id integer NOT NULL,
    amount_currency boolean,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_common_journal_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_common_journal_report IS 'Common Journal Report';


--
-- Name: COLUMN account_common_journal_report.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_common_journal_report.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.company_id IS 'Company';


--
-- Name: COLUMN account_common_journal_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_journal_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_journal_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_common_journal_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_journal_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_journal_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_journal_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_journal_report.write_date IS 'Last Updated on';


--
-- Name: account_common_journal_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_common_journal_report_account_journal_rel (
    account_common_journal_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_journal_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_common_journal_report_account_journal_rel IS 'RELATION BETWEEN account_common_journal_report AND account_journal';


--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_common_journal_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_common_journal_report_id_seq OWNED BY public.account_common_journal_report.id;


--
-- Name: account_common_report; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_common_report (
    id integer NOT NULL,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_common_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_common_report IS 'Account Common Report';


--
-- Name: COLUMN account_common_report.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.company_id IS 'Company';


--
-- Name: COLUMN account_common_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_common_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_common_report.write_date IS 'Last Updated on';


--
-- Name: account_common_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_common_report_account_journal_rel (
    account_common_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_common_report_account_journal_rel IS 'RELATION BETWEEN account_common_report AND account_journal';


--
-- Name: account_common_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_common_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_common_report_id_seq OWNED BY public.account_common_report.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    name character varying NOT NULL,
    active boolean,
    company_id integer NOT NULL,
    note text,
    auto_apply boolean,
    vat_required boolean,
    country_id integer,
    country_group_id integer,
    zip_from character varying,
    zip_to character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_account_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_account_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_account_template IS 'Accounts Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account_template.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.position_id IS 'Fiscal Mapping';


--
-- Name: COLUMN account_fiscal_position_account_template.account_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_src_id IS 'Account Source';


--
-- Name: COLUMN account_fiscal_position_account_template.account_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_dest_id IS 'Account Destination';


--
-- Name: COLUMN account_fiscal_position_account_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_account_template_id_seq OWNED BY public.account_fiscal_position_account_template.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_position_tax_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_tax_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_tax_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_tax_template IS 'Tax Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_src_id IS 'Tax Source';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_dest_id IS 'Replacement Tax';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_tax_template_id_seq OWNED BY public.account_fiscal_position_tax_template.id;


--
-- Name: account_fiscal_position_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_template (
    id integer NOT NULL,
    sequence integer,
    name character varying NOT NULL,
    chart_template_id integer NOT NULL,
    note text,
    auto_apply boolean,
    vat_required boolean,
    country_id integer,
    country_group_id integer,
    zip_from character varying,
    zip_to character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_template IS 'Template for Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.name IS 'Fiscal Position Template';


--
-- Name: COLUMN account_fiscal_position_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_fiscal_position_template.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position_template.auto_apply; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position_template.vat_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position_template.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position_template.country_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position_template.zip_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position_template.zip_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_template_id_seq OWNED BY public.account_fiscal_position_template.id;


--
-- Name: account_fiscal_position_template_res_country_state_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_template_res_country_state_rel (
    account_fiscal_position_template_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


--
-- Name: TABLE account_fiscal_position_template_res_country_state_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_template_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position_template AND res_country_state';


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_fr_fec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fr_fec (
    id integer NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    fec_data bytea,
    filename character varying(256),
    export_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fr_fec; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fr_fec IS 'Ficher Echange Informatise';


--
-- Name: COLUMN account_fr_fec.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.date_from IS 'Start Date';


--
-- Name: COLUMN account_fr_fec.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.date_to IS 'End Date';


--
-- Name: COLUMN account_fr_fec.fec_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.fec_data IS 'FEC File';


--
-- Name: COLUMN account_fr_fec.filename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.filename IS 'Filename';


--
-- Name: COLUMN account_fr_fec.export_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.export_type IS 'Export Type';


--
-- Name: COLUMN account_fr_fec.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.create_uid IS 'Created by';


--
-- Name: COLUMN account_fr_fec.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.create_date IS 'Created on';


--
-- Name: COLUMN account_fr_fec.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fr_fec.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fr_fec.write_date IS 'Last Updated on';


--
-- Name: account_fr_fec_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fr_fec_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fr_fec_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fr_fec_id_seq OWNED BY public.account_fr_fec.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    name character varying NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.name IS 'Number';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_path character varying,
    parent_id integer,
    name character varying NOT NULL,
    code_prefix character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.code_prefix IS 'Code Prefix';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(3) NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_payment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_payment_rel (
    payment_id integer NOT NULL,
    invoice_id integer NOT NULL
);


--
-- Name: TABLE account_invoice_payment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_payment_rel IS 'RELATION BETWEEN account_payment AND account_move';


--
-- Name: account_invoice_payment_rel_transient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_payment_rel_transient (
    payment_id integer NOT NULL,
    invoice_id integer NOT NULL
);


--
-- Name: TABLE account_invoice_payment_rel_transient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_payment_rel_transient IS 'RELATION BETWEEN account_payment_register AND account_move';


--
-- Name: account_invoice_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.account_invoice_report AS
SELECT
    NULL::integer AS id,
    NULL::integer AS move_id,
    NULL::integer AS product_id,
    NULL::integer AS account_id,
    NULL::integer AS analytic_account_id,
    NULL::integer AS journal_id,
    NULL::integer AS company_id,
    NULL::integer AS currency_id,
    NULL::integer AS commercial_partner_id,
    NULL::character varying AS name,
    NULL::character varying AS state,
    NULL::character varying AS type,
    NULL::integer AS partner_id,
    NULL::integer AS invoice_user_id,
    NULL::integer AS fiscal_position_id,
    NULL::character varying AS invoice_payment_state,
    NULL::date AS invoice_date,
    NULL::date AS invoice_date_due,
    NULL::integer AS invoice_payment_term_id,
    NULL::integer AS invoice_partner_bank_id,
    NULL::numeric AS residual,
    NULL::numeric AS amount_total,
    NULL::integer AS product_uom_id,
    NULL::integer AS product_categ_id,
    NULL::numeric AS quantity,
    NULL::numeric AS price_subtotal,
    NULL::numeric AS price_average,
    NULL::integer AS country_id,
    NULL::integer AS nbr_lines,
    NULL::integer AS team_id;


--
-- Name: account_invoice_send; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_send (
    id integer NOT NULL,
    is_email boolean,
    is_print boolean,
    printed boolean,
    composer_id integer NOT NULL,
    template_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    snailmail_is_letter boolean
);


--
-- Name: TABLE account_invoice_send; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_send IS 'Account Invoice Send';


--
-- Name: COLUMN account_invoice_send.is_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.is_email IS 'Email';


--
-- Name: COLUMN account_invoice_send.is_print; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.is_print IS 'Print';


--
-- Name: COLUMN account_invoice_send.printed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.printed IS 'Is Printed';


--
-- Name: COLUMN account_invoice_send.composer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.composer_id IS 'Composer';


--
-- Name: COLUMN account_invoice_send.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.template_id IS 'Use template';


--
-- Name: COLUMN account_invoice_send.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_send.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_send.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_send.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_send.snailmail_is_letter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_send.snailmail_is_letter IS 'Send by Post';


--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_invoice_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_invoice_send_id_seq OWNED BY public.account_invoice_send.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_transaction_rel (
    transaction_id integer NOT NULL,
    invoice_id integer NOT NULL
);


--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN payment_transaction AND account_move';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    code character varying(5) NOT NULL,
    active boolean,
    type character varying NOT NULL,
    default_credit_account_id integer,
    default_debit_account_id integer,
    restrict_mode_hash_table boolean,
    sequence_id integer NOT NULL,
    refund_sequence_id integer,
    sequence integer,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    currency_id integer,
    company_id integer NOT NULL,
    refund_sequence boolean,
    at_least_one_inbound boolean,
    at_least_one_outbound boolean,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    bank_statements_source character varying,
    post_at character varying,
    alias_id integer,
    secure_sequence_id integer,
    show_on_dashboard boolean,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.default_credit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.default_credit_account_id IS 'Default Credit Account';


--
-- Name: COLUMN account_journal.default_debit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.default_debit_account_id IS 'Default Debit Account';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Lock Posted Entries with Hash';


--
-- Name: COLUMN account_journal.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_journal.refund_sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.refund_sequence_id IS 'Credit Note Entry Sequence';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.at_least_one_inbound; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.at_least_one_inbound IS 'At Least One Inbound';


--
-- Name: COLUMN account_journal.at_least_one_outbound; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.at_least_one_outbound IS 'At Least One Outbound';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.post_at; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.post_at IS 'Post At';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.secure_sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.secure_sequence_id IS 'Secure Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_print_journal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_print_journal_rel (
    account_print_journal_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_print_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_print_journal_rel IS 'RELATION BETWEEN account_print_journal AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_account_reconcile_model_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_reconcile_model_template_rel (
    account_reconcile_model_template_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_reconcile_model_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_template_rel IS 'RELATION BETWEEN account_reconcile_model_template AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_journal_inbound_payment_method_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_inbound_payment_method_rel (
    journal_id integer NOT NULL,
    inbound_payment_method integer NOT NULL
);


--
-- Name: TABLE account_journal_inbound_payment_method_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_inbound_payment_method_rel IS 'RELATION BETWEEN account_journal AND account_payment_method';


--
-- Name: account_journal_outbound_payment_method_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_outbound_payment_method_rel (
    journal_id integer NOT NULL,
    outbound_payment_method integer NOT NULL
);


--
-- Name: TABLE account_journal_outbound_payment_method_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_outbound_payment_method_rel IS 'RELATION BETWEEN account_journal AND account_payment_method';


--
-- Name: account_journal_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_type_rel (
    journal_id integer NOT NULL,
    type_id integer NOT NULL
);


--
-- Name: TABLE account_journal_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_type_rel IS 'RELATION BETWEEN account_journal AND account_account_type';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    message_main_attachment_id integer,
    access_token character varying,
    name character varying NOT NULL,
    date date NOT NULL,
    ref character varying,
    narration text,
    state character varying NOT NULL,
    type character varying NOT NULL,
    to_check boolean,
    journal_id integer NOT NULL,
    company_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    commercial_partner_id integer,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_residual_signed numeric,
    tax_cash_basis_rec_id integer,
    auto_post boolean,
    reversed_entry_id integer,
    fiscal_position_id integer,
    invoice_user_id integer,
    invoice_payment_state character varying,
    invoice_date date,
    invoice_date_due date,
    invoice_payment_ref character varying,
    invoice_sent boolean,
    invoice_origin character varying,
    invoice_payment_term_id integer,
    invoice_partner_bank_id integer,
    invoice_incoterm_id integer,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_cash_rounding_id integer,
    secure_sequence_number integer,
    inalterable_hash character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    partner_shipping_id integer
);


--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move IS 'Journal Entries';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.type IS 'Type';


--
-- Name: COLUMN account_move.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.to_check IS 'To Check';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Post Automatically';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_payment_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_payment_state IS 'Payment';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.invoice_payment_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_payment_ref IS 'Payment Reference';


--
-- Name: COLUMN account_move.invoice_sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_sent IS 'Invoice Sent';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.invoice_partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_partner_bank_id IS 'Bank Account';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalteralbility No Gap Sequence #';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: account_move_account_invoice_send_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_account_invoice_send_rel (
    account_invoice_send_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_account_invoice_send_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_account_invoice_send_rel IS 'RELATION BETWEEN account_invoice_send AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    move_name character varying,
    date date,
    ref character varying,
    parent_state character varying,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    account_id integer,
    account_internal_type character varying,
    account_root_id integer,
    sequence integer,
    name character varying,
    quantity numeric,
    price_unit numeric,
    discount numeric,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    price_subtotal numeric,
    price_total numeric,
    reconciled boolean,
    blocked boolean,
    date_maturity date,
    currency_id integer,
    partner_id integer,
    product_uom_id integer,
    product_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_base_amount numeric,
    tax_exigible boolean,
    tax_repartition_line_id integer,
    tax_audit character varying,
    amount_residual numeric,
    amount_residual_currency numeric,
    full_reconcile_id integer,
    analytic_account_id integer,
    display_type character varying,
    is_rounding_line boolean,
    exclude_from_invoice_tab boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    purchase_line_id integer,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((COALESCE(((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])), false) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK (((currency_id IS NULL) OR (company_currency_id IS NULL) OR ((currency_id <> company_currency_id) AND (((balance > (0)::numeric) AND (amount_currency > (0)::numeric)) OR ((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric)))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((credit + debit) >= (0)::numeric) AND ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.account_internal_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.account_internal_type IS 'Internal Type';


--
-- Name: COLUMN account_move_line.account_root_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.account_root_id IS 'Account Root';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.blocked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.blocked IS 'No Follow-up';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Bank statement line reconciled with this entry';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.tax_exigible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_exigible IS 'Appears in VAT report';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Repartition Line';


--
-- Name: COLUMN account_move_line.tax_audit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_audit IS 'Tax Audit String';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching #';


--
-- Name: COLUMN account_move_line.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.is_rounding_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.is_rounding_line IS 'Is Rounding Line';


--
-- Name: COLUMN account_move_line.exclude_from_invoice_tab; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.exclude_from_invoice_tab IS 'Exclude From Invoice Tab';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(COALESCE(display_type IN (''line_section'', ''line_note''), ''f'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                currency_id IS NULL
                OR
                company_currency_id IS NULL
                OR
                (
                    (currency_id != company_currency_id)
                    AND
                    (
                        (balance > 0 AND amount_currency > 0)
                        OR (balance <= 0 AND amount_currency <= 0)
                        OR (balance >= 0 AND amount_currency >= 0)
                    )
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(credit + debit>=0 AND credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    move_id integer,
    date date NOT NULL,
    reason character varying,
    refund_method character varying NOT NULL,
    journal_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason';


--
-- Name: COLUMN account_move_reversal.refund_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.refund_method IS 'Credit Method';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    amount numeric,
    amount_currency numeric,
    currency_id integer,
    company_id integer,
    full_reconcile_id integer,
    max_date date,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_partial_reconcile.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.currency_id IS 'Currency';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying,
    payment_reference character varying,
    move_name character varying,
    destination_journal_id integer,
    state character varying,
    payment_type character varying NOT NULL,
    payment_method_id integer NOT NULL,
    partner_type character varying,
    partner_id integer,
    amount numeric NOT NULL,
    currency_id integer NOT NULL,
    payment_date date NOT NULL,
    communication character varying,
    journal_id integer NOT NULL,
    payment_difference_handling character varying,
    writeoff_account_id integer,
    writeoff_label character varying,
    partner_bank_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    payment_transaction_id integer,
    payment_token_id integer
);


--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.name IS 'Name';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.move_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.move_name IS 'Journal Entry Name';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Transfer To';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.state IS 'Status';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Partner';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.payment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_date IS 'Date';


--
-- Name: COLUMN account_payment.communication; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.communication IS 'Memo';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.payment_difference_handling; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment.writeoff_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment.writeoff_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment.partner_bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_bank_account_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved payment token';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    payment_date date NOT NULL,
    journal_id integer NOT NULL,
    payment_method_id integer NOT NULL,
    group_payment boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_register IS 'Register Payment';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.payment_method_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_method_id IS 'Payment Method Type';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payment';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    note text,
    company_id integer,
    sequence integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    value character varying NOT NULL,
    value_amount numeric,
    days integer NOT NULL,
    day_of_the_month integer,
    option character varying NOT NULL,
    payment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Type';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Value';


--
-- Name: COLUMN account_payment_term_line.days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.days IS 'Number of Days';


--
-- Name: COLUMN account_payment_term_line.day_of_the_month; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.day_of_the_month IS 'Day of the month';


--
-- Name: COLUMN account_payment_term_line.option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.option IS 'Options';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_print_journal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_print_journal (
    id integer NOT NULL,
    sort_selection character varying NOT NULL,
    amount_currency boolean,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_print_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_print_journal IS 'Account Print Journal';


--
-- Name: COLUMN account_print_journal.sort_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.sort_selection IS 'Entries Sorted by';


--
-- Name: COLUMN account_print_journal.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_print_journal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.company_id IS 'Company';


--
-- Name: COLUMN account_print_journal.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.date_from IS 'Start Date';


--
-- Name: COLUMN account_print_journal.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.date_to IS 'End Date';


--
-- Name: COLUMN account_print_journal.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.target_move IS 'Target Moves';


--
-- Name: COLUMN account_print_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_print_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_print_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_print_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_print_journal.write_date IS 'Last Updated on';


--
-- Name: account_print_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_print_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_print_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_print_journal_id_seq OWNED BY public.account_print_journal.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    rule_type character varying NOT NULL,
    auto_reconcile boolean,
    to_check boolean,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_amount_min double precision,
    match_amount_max double precision,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    match_same_currency boolean,
    match_total_amount boolean,
    match_total_amount_param double precision,
    match_partner boolean,
    account_id integer,
    journal_id integer,
    label character varying,
    amount_type character varying NOT NULL,
    force_tax_included boolean,
    amount numeric NOT NULL,
    amount_from_label_regex character varying,
    decimal_separator character varying,
    analytic_account_id integer,
    has_second_line boolean,
    second_account_id integer,
    second_journal_id integer,
    second_label character varying,
    second_amount_type character varying NOT NULL,
    force_second_tax_included boolean,
    second_amount numeric NOT NULL,
    second_amount_from_label_regex character varying,
    second_analytic_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Nature';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency Matching';


--
-- Name: COLUMN account_reconcile_model.match_total_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_total_amount IS 'Amount Matching';


--
-- Name: COLUMN account_reconcile_model.match_total_amount_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_total_amount_param IS 'Amount Matching %';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner Is Set';


--
-- Name: COLUMN account_reconcile_model.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.force_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.amount IS 'Write-off Amount';


--
-- Name: COLUMN account_reconcile_model.amount_from_label_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.amount_from_label_regex IS 'Amount from Label (regex)';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_reconcile_model.has_second_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.has_second_line IS 'Add a second line';


--
-- Name: COLUMN account_reconcile_model.second_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_account_id IS 'Second Account';


--
-- Name: COLUMN account_reconcile_model.second_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_journal_id IS 'Second Journal';


--
-- Name: COLUMN account_reconcile_model.second_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_label IS 'Second Journal Item Label';


--
-- Name: COLUMN account_reconcile_model.second_amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_amount_type IS 'Second Amount type';


--
-- Name: COLUMN account_reconcile_model.force_second_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.force_second_tax_included IS 'Second Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model.second_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_amount IS 'Second Write-off Amount';


--
-- Name: COLUMN account_reconcile_model.second_amount_from_label_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_amount_from_label_regex IS 'Second Amount from Label (regex)';


--
-- Name: COLUMN account_reconcile_model.second_analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.second_analytic_account_id IS 'Second Analytic Account';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_account_tax_bis_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_account_tax_bis_rel (
    account_reconcile_model_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_account_tax_bis_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_account_tax_bis_rel IS 'RELATION BETWEEN account_reconcile_model AND account_tax';


--
-- Name: account_reconcile_model_account_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_account_tax_rel (
    account_reconcile_model_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_account_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model AND account_tax';


--
-- Name: account_reconcile_model_analytic_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_analytic_tag_rel (
    account_reconcile_model_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_analytic_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_analytic_tag_rel IS 'RELATION BETWEEN account_reconcile_model AND account_analytic_tag';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_model_second_analytic_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_second_analytic_tag_rel (
    account_reconcile_model_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_second_analytic_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_second_analytic_tag_rel IS 'RELATION BETWEEN account_reconcile_model AND account_analytic_tag';


--
-- Name: account_reconcile_model_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer NOT NULL,
    rule_type character varying NOT NULL,
    auto_reconcile boolean,
    to_check boolean,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_amount_min double precision,
    match_amount_max double precision,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    match_same_currency boolean,
    match_total_amount boolean,
    match_total_amount_param double precision,
    match_partner boolean,
    account_id integer,
    label character varying,
    amount_type character varying NOT NULL,
    amount numeric NOT NULL,
    amount_from_label_regex character varying,
    decimal_separator character varying,
    force_tax_included boolean,
    has_second_line boolean,
    second_account_id integer,
    second_label character varying,
    second_amount_type character varying NOT NULL,
    second_amount numeric NOT NULL,
    second_amount_from_label_regex character varying,
    force_second_tax_included boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_reconcile_model_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_template IS 'Reconcile Model Template';


--
-- Name: COLUMN account_reconcile_model_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_reconcile_model_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.name IS 'Button Label';


--
-- Name: COLUMN account_reconcile_model_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_template.rule_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model_template.auto_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model_template.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model_template.match_nature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_nature IS 'Amount Nature';


--
-- Name: COLUMN account_reconcile_model_template.match_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model_template.match_label_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model_template.match_note_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_same_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_same_currency IS 'Same Currency Matching';


--
-- Name: COLUMN account_reconcile_model_template.match_total_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_total_amount IS 'Amount Matching';


--
-- Name: COLUMN account_reconcile_model_template.match_total_amount_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_total_amount_param IS 'Amount Matching %';


--
-- Name: COLUMN account_reconcile_model_template.match_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_partner IS 'Partner Is Set';


--
-- Name: COLUMN account_reconcile_model_template.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_template.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_template.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_template.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.amount IS 'Write-off Amount';


--
-- Name: COLUMN account_reconcile_model_template.amount_from_label_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.amount_from_label_regex IS 'Amount from Label (regex)';


--
-- Name: COLUMN account_reconcile_model_template.decimal_separator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model_template.force_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_template.has_second_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.has_second_line IS 'Add a second line';


--
-- Name: COLUMN account_reconcile_model_template.second_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.second_account_id IS 'Second Account';


--
-- Name: COLUMN account_reconcile_model_template.second_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.second_label IS 'Second Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_template.second_amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.second_amount_type IS 'Second Amount type';


--
-- Name: COLUMN account_reconcile_model_template.second_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.second_amount IS 'Second Write-off Amount';


--
-- Name: COLUMN account_reconcile_model_template.second_amount_from_label_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.second_amount_from_label_regex IS 'Second Amount from Label (regex)';


--
-- Name: COLUMN account_reconcile_model_template.force_second_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.force_second_tax_included IS 'Second Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_template_account_tax_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_template_account_tax_template_rel (
    account_reconcile_model_template_id integer NOT NULL,
    account_tax_template_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_template_account_tax_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_template_account_tax_template_rel IS 'RELATION BETWEEN account_reconcile_model_template AND account_tax_template';


--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_model_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_model_template_id_seq OWNED BY public.account_reconcile_model_template.id;


--
-- Name: account_reconcile_model_template_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_template_res_partner_category_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_template_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner_category';


--
-- Name: account_reconcile_model_template_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_template_res_partner_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_template_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner';


--
-- Name: account_reconcile_model_tmpl_account_tax_bis_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_tmpl_account_tax_bis_rel (
    account_reconcile_model_template_id integer NOT NULL,
    account_tax_template_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_tmpl_account_tax_bis_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_tmpl_account_tax_bis_rel IS 'RELATION BETWEEN account_reconcile_model_template AND account_tax_template';


--
-- Name: account_root; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.account_root AS
 SELECT DISTINCT ((ascii((account_account.code)::text) * 1000) + ascii("substring"((account_account.code)::text, 2, 1))) AS id,
    "left"((account_account.code)::text, 2) AS name,
    ascii((account_account.code)::text) AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL)
UNION ALL
 SELECT DISTINCT ascii((account_account.code)::text) AS id,
    "left"((account_account.code)::text, 1) AS name,
    NULL::integer AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL);


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    new_journal_name character varying NOT NULL,
    new_journal_code character varying NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_code IS 'Code';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    amount_type character varying NOT NULL,
    active boolean,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    amount numeric NOT NULL,
    description character varying,
    price_include boolean,
    include_base_amount boolean,
    analytic boolean,
    tax_group_id integer NOT NULL,
    tax_exigibility character varying,
    cash_basis_transition_account_id integer,
    cash_basis_base_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.description IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.price_include; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Due';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_financial_tags; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_financial_tags (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_tax_repartition_financial_tags; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_financial_tags IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_account_tag';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    factor_percent double precision NOT NULL,
    repartition_type character varying NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    company_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.invoice_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line.refund_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_repartition_line_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_line_template (
    id integer NOT NULL,
    factor_percent double precision NOT NULL,
    repartition_type character varying NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_repartition_line_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_line_template IS 'Tax Repartition Line Template';


--
-- Name: COLUMN account_tax_repartition_line_template.factor_percent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line_template.repartition_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line_template.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line_template.invoice_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.refund_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_repartition_line_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_repartition_line_template_id_seq OWNED BY public.account_tax_repartition_line_template.id;


--
-- Name: account_tax_repartition_minus_report_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_minus_report_line (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


--
-- Name: TABLE account_tax_repartition_minus_report_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_minus_report_line IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_tax_report_line';


--
-- Name: account_tax_repartition_plus_report_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_plus_report_line (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


--
-- Name: TABLE account_tax_repartition_plus_report_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_plus_report_line IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_tax_report_line';


--
-- Name: account_tax_report_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_report_line (
    id integer NOT NULL,
    parent_path character varying,
    name character varying NOT NULL,
    country_id integer NOT NULL,
    report_action_id integer,
    parent_id integer,
    sequence integer NOT NULL,
    tag_name character varying,
    code character varying,
    formula character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_report_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_report_line IS 'Account Tax Report Line';


--
-- Name: COLUMN account_tax_report_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.name IS 'Name';


--
-- Name: COLUMN account_tax_report_line.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.country_id IS 'Country';


--
-- Name: COLUMN account_tax_report_line.report_action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.report_action_id IS 'Report Action';


--
-- Name: COLUMN account_tax_report_line.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_tax_report_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_report_line.tag_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.tag_name IS 'Tag Name';


--
-- Name: COLUMN account_tax_report_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.code IS 'Code';


--
-- Name: COLUMN account_tax_report_line.formula; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.formula IS 'Formula';


--
-- Name: COLUMN account_tax_report_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_report_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_report_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_report_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_report_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_report_line_id_seq OWNED BY public.account_tax_report_line.id;


--
-- Name: account_tax_report_line_tags_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_report_line_tags_rel (
    account_account_tag_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


--
-- Name: TABLE account_tax_report_line_tags_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_report_line_tags_rel IS 'RELATION BETWEEN account_account_tag AND account_tax_report_line';


--
-- Name: account_tax_sale_advance_payment_inv_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_sale_advance_payment_inv_rel (
    sale_advance_payment_inv_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_sale_advance_payment_inv_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_sale_advance_payment_inv_rel IS 'RELATION BETWEEN sale_advance_payment_inv AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    amount_type character varying NOT NULL,
    active boolean,
    sequence integer NOT NULL,
    amount numeric NOT NULL,
    description character varying,
    price_include boolean,
    include_base_amount boolean,
    analytic boolean,
    tax_group_id integer,
    tax_exigibility character varying,
    cash_basis_transition_account_id integer,
    cash_basis_base_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_template IS 'Templates for Taxes';


--
-- Name: COLUMN account_tax_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_tax_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.name IS 'Tax Name';


--
-- Name: COLUMN account_tax_template.type_tax_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.type_tax_use IS 'Tax Scope';


--
-- Name: COLUMN account_tax_template.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax_template.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.active IS 'Active';


--
-- Name: COLUMN account_tax_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_template.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.amount IS 'Amount';


--
-- Name: COLUMN account_tax_template.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.description IS 'Display on Invoices';


--
-- Name: COLUMN account_tax_template.price_include; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax_template.include_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.include_base_amount IS 'Affect Subsequent Taxes';


--
-- Name: COLUMN account_tax_template.analytic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.analytic IS 'Analytic Cost';


--
-- Name: COLUMN account_tax_template.tax_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax_template.tax_exigibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.tax_exigibility IS 'Tax Due';


--
-- Name: COLUMN account_tax_template.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax_template.cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN account_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_tax_template_filiation_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_template_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


--
-- Name: TABLE account_tax_template_filiation_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_template_filiation_rel IS 'RELATION BETWEEN account_tax_template AND account_tax_template';


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_template_id_seq OWNED BY public.account_tax_template.id;


--
-- Name: account_unreconcile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_unreconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_unreconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_unreconcile IS 'Account Unreconcile';


--
-- Name: COLUMN account_unreconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_unreconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_unreconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_unreconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_unreconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_unreconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_unreconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_unreconcile.write_date IS 'Last Updated on';


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_unreconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_unreconcile_id_seq OWNED BY public.account_unreconcile.id;


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    res_model character varying,
    file bytea,
    file_name character varying,
    file_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    value character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    f double precision,
    m numeric,
    c character varying,
    currency_id integer,
    d date,
    dt timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    value double precision,
    value2 numeric,
    currency_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    name character varying,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    data bytea,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    data bytea NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    lang character varying NOT NULL,
    overwrite boolean,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.lang IS 'Language';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.state IS 'Status';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    show_all boolean,
    module_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    module_info text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    state character varying NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    exclude_contact boolean,
    exclude_journal_item boolean,
    maximum_group integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    aggr_ids character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_update_translations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_update_translations (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_update_translations; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_update_translations IS 'Update Translations';


--
-- Name: COLUMN base_update_translations.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_update_translations.lang IS 'Language';


--
-- Name: COLUMN base_update_translations.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_update_translations.create_uid IS 'Created by';


--
-- Name: COLUMN base_update_translations.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_update_translations.create_date IS 'Created on';


--
-- Name: COLUMN base_update_translations.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_update_translations.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_update_translations.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_update_translations.write_date IS 'Last Updated on';


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_update_translations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_update_translations_id_seq OWNED BY public.base_update_translations.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    channel character varying,
    message character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer NOT NULL,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    status character varying
);


--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: cash_box_out; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cash_box_out (
    id integer NOT NULL,
    name character varying NOT NULL,
    amount numeric NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE cash_box_out; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.cash_box_out IS 'Cash Box Out';


--
-- Name: COLUMN cash_box_out.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.name IS 'Reason';


--
-- Name: COLUMN cash_box_out.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.amount IS 'Amount';


--
-- Name: COLUMN cash_box_out.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.create_uid IS 'Created by';


--
-- Name: COLUMN cash_box_out.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.create_date IS 'Created on';


--
-- Name: COLUMN cash_box_out.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cash_box_out.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.cash_box_out.write_date IS 'Last Updated on';


--
-- Name: cash_box_out_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cash_box_out_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cash_box_out_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cash_box_out_id_seq OWNED BY public.cash_box_out.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    user_login character varying,
    new_passwd character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    sequence integer,
    active boolean,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    use_quotations boolean,
    invoiced_target integer
);


--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.use_quotations; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.use_quotations IS 'Quotations';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    name character varying NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    name character varying NOT NULL,
    periodicity character varying NOT NULL,
    next_run_date date,
    template_id integer NOT NULL,
    company_id integer,
    state character varying,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_all_sale_total boolean
);


--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Send Date';


--
-- Name: COLUMN digest_digest.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.template_id IS 'Email Template';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    tip_description text,
    group_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: email_template_preview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.email_template_preview (
    id integer NOT NULL,
    res_id character varying,
    preview_lang character varying,
    name character varying,
    model_id integer,
    model character varying,
    lang character varying,
    user_signature boolean,
    subject character varying,
    email_from character varying,
    use_default_to boolean,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    mail_server_id integer,
    body_html text,
    report_name character varying,
    report_template integer,
    ref_ir_act_window integer,
    auto_delete boolean,
    model_object_field integer,
    sub_object integer,
    sub_model_object_field integer,
    null_value character varying,
    copyvalue character varying,
    scheduled_date character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE email_template_preview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.email_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN email_template_preview.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.res_id IS 'Sample Document';


--
-- Name: COLUMN email_template_preview.preview_lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.preview_lang IS 'Template Preview Language';


--
-- Name: COLUMN email_template_preview.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.name IS 'Name';


--
-- Name: COLUMN email_template_preview.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.model_id IS 'Applies to';


--
-- Name: COLUMN email_template_preview.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.model IS 'Related Document Model';


--
-- Name: COLUMN email_template_preview.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.lang IS 'Language';


--
-- Name: COLUMN email_template_preview.user_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.user_signature IS 'Add Signature';


--
-- Name: COLUMN email_template_preview.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.subject IS 'Subject';


--
-- Name: COLUMN email_template_preview.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.email_from IS 'From';


--
-- Name: COLUMN email_template_preview.use_default_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.use_default_to IS 'Default recipients';


--
-- Name: COLUMN email_template_preview.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.email_to IS 'To (Emails)';


--
-- Name: COLUMN email_template_preview.partner_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.partner_to IS 'To (Partners)';


--
-- Name: COLUMN email_template_preview.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.email_cc IS 'Cc';


--
-- Name: COLUMN email_template_preview.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.reply_to IS 'Reply-To';


--
-- Name: COLUMN email_template_preview.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN email_template_preview.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.body_html IS 'Body';


--
-- Name: COLUMN email_template_preview.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.report_name IS 'Report Filename';


--
-- Name: COLUMN email_template_preview.report_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN email_template_preview.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN email_template_preview.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN email_template_preview.model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.model_object_field IS 'Field';


--
-- Name: COLUMN email_template_preview.sub_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.sub_object IS 'Sub-model';


--
-- Name: COLUMN email_template_preview.sub_model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.sub_model_object_field IS 'Sub-field';


--
-- Name: COLUMN email_template_preview.null_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.null_value IS 'Default Value';


--
-- Name: COLUMN email_template_preview.copyvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.copyvalue IS 'Placeholder Expression';


--
-- Name: COLUMN email_template_preview.scheduled_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN email_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN email_template_preview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN email_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN email_template_preview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.email_template_preview.write_date IS 'Last Updated on';


--
-- Name: email_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.email_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: email_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.email_template_preview_id_seq OWNED BY public.email_template_preview.id;


--
-- Name: email_template_preview_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.email_template_preview_res_partner_rel (
    email_template_preview_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE email_template_preview_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.email_template_preview_res_partner_rel IS 'RELATION BETWEEN email_template_preview AND res_partner';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    state character varying,
    server character varying,
    port integer,
    server_type character varying NOT NULL,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    "user" character varying,
    password character varying,
    object_id integer,
    priority integer,
    configuration text,
    script character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_name character varying,
    account_token character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.service_name IS 'Service Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    name character varying NOT NULL,
    type character varying NOT NULL,
    help text,
    binding_model_id integer,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.name IS 'Name';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_report_xml (
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    multi boolean,
    paperformat_id integer,
    print_report_name character varying,
    attachment_use boolean,
    attachment character varying
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server (
    usage character varying NOT NULL,
    state character varying NOT NULL,
    sequence integer,
    model_id integer NOT NULL,
    model_name character varying,
    code text,
    crud_model_id integer,
    link_field_id integer,
    template_id integer,
    activity_type_id integer,
    activity_summary character varying,
    activity_note text,
    activity_date_deadline_range integer,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying NOT NULL,
    activity_user_id integer,
    activity_user_field_name character varying,
    sms_template_id integer,
    sms_mass_keep_log boolean
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Create/Write Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link using field';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Summary';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'Activity User Type';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User field name';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_mass_keep_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.sms_mass_keep_log IS 'Log a note';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_mail_channel_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server_mail_channel_rel (
    ir_act_server_id integer NOT NULL,
    mail_channel_id integer NOT NULL
);


--
-- Name: TABLE ir_act_server_mail_channel_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_server_mail_channel_rel IS 'RELATION BETWEEN ir_act_server AND mail_channel';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_url (
    url text NOT NULL,
    target character varying NOT NULL
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_id integer,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    "limit" integer,
    search_view_id integer,
    filter boolean
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    view_mode character varying NOT NULL,
    act_window_id integer,
    multi boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    state character varying NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    res_model character varying,
    res_field character varying,
    res_id integer,
    company_id integer,
    type character varying NOT NULL,
    url character varying(1024),
    public boolean,
    access_token character varying,
    db_datas bytea,
    store_fname character varying,
    file_size integer,
    checksum character varying(40),
    mimetype character varying,
    index_content text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    key character varying NOT NULL,
    value text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    cron_name character varying,
    user_id integer NOT NULL,
    active boolean,
    interval_number integer,
    interval_type character varying,
    numbercall integer,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    priority integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    error character varying,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    name character varying,
    resource character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    name character varying,
    export_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    model_id character varying NOT NULL,
    is_default boolean,
    action_id integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    message text NOT NULL,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL
);


--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    name character varying NOT NULL,
    smtp_host character varying NOT NULL,
    smtp_port integer NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    sequence integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Description';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Security';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying NOT NULL,
    info text,
    state character varying,
    transient boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    model_id integer NOT NULL,
    group_id integer,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Object';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    name character varying NOT NULL,
    definition character varying,
    message character varying,
    model integer NOT NULL,
    module integer NOT NULL,
    type character varying(1) NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    date_init timestamp without time zone,
    date_update timestamp without time zone,
    module character varying NOT NULL,
    model character varying NOT NULL,
    res_id integer
);


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    relation_field_id integer,
    model_id integer NOT NULL,
    field_description character varying NOT NULL,
    help text,
    ttype character varying NOT NULL,
    copied boolean,
    related character varying,
    related_field_id integer,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    size integer,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    selectable boolean,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    compute text,
    depends character varying,
    store boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    tracking integer,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Object Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Object Relation';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    value character varying NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    name character varying NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name character varying NOT NULL,
    description text,
    sequence integer,
    visible boolean,
    exclusive boolean
);


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary character varying,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc character varying,
    category_id integer,
    description text,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    contributors text,
    published_version character varying,
    url character varying,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    name character varying,
    res_id character varying,
    company_id integer,
    fields_id integer NOT NULL,
    value_float double precision,
    value_integer integer,
    value_text text,
    value_binary bytea,
    value_reference character varying,
    value_datetime timestamp without time zone,
    type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    name character varying,
    active boolean,
    model_id integer NOT NULL,
    domain_force text,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Object';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    active boolean,
    prefix character varying,
    suffix character varying,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    use_date_range boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_001; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_001
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_003; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_003
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_006; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_006
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_024; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_024
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_025; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_025
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    value text NOT NULL,
    evaluation_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_translation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_translation (
    id integer NOT NULL,
    name character varying NOT NULL,
    res_id integer,
    lang character varying,
    type character varying,
    src text,
    value text,
    module character varying,
    state character varying,
    comments text
);


--
-- Name: TABLE ir_translation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_translation IS 'Translation';


--
-- Name: COLUMN ir_translation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.name IS 'Translated field';


--
-- Name: COLUMN ir_translation.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.res_id IS 'Record ID';


--
-- Name: COLUMN ir_translation.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.lang IS 'Language';


--
-- Name: COLUMN ir_translation.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.type IS 'Type';


--
-- Name: COLUMN ir_translation.src; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.src IS 'Internal Source';


--
-- Name: COLUMN ir_translation.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.value IS 'Translation Value';


--
-- Name: COLUMN ir_translation.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.module IS 'Module';


--
-- Name: COLUMN ir_translation.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.state IS 'Status';


--
-- Name: COLUMN ir_translation.comments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_translation.comments IS 'Translation comments';


--
-- Name: ir_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_translation_id_seq OWNED BY public.ir_translation.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    parent_path character varying,
    name character varying NOT NULL,
    active boolean,
    sequence integer,
    parent_id integer,
    web_icon character varying,
    action character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    priority integer NOT NULL,
    type character varying,
    arch_db text,
    arch_fs character varying,
    arch_updated boolean,
    arch_prev text,
    inherit_id integer,
    field_parent character varying,
    mode character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    arch text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_model character varying,
    res_id integer NOT NULL,
    res_name character varying,
    activity_type_id integer,
    summary character varying,
    note text,
    date_deadline date NOT NULL,
    automated boolean,
    user_id integer NOT NULL,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    summary character varying,
    sequence integer,
    active boolean,
    create_uid integer,
    delay_count integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model_id integer,
    default_next_type_id integer,
    force_next boolean,
    category character varying,
    default_user_id integer,
    default_description text,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Scheduled Date';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.res_model_id IS 'Model';


--
-- Name: COLUMN mail_activity_type.default_next_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.default_next_type_id IS 'Default Next Activity';


--
-- Name: COLUMN mail_activity_type.force_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.force_next IS 'Trigger Next Activity';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action to Perform';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.default_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.default_description IS 'Default Description';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_name character varying,
    alias_model_id integer NOT NULL,
    alias_user_id integer,
    alias_defaults text NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    alias_contact character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_user_id IS 'Owner';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    email character varying NOT NULL,
    active boolean,
    message_main_attachment_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_channel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_channel (
    id integer NOT NULL,
    name character varying NOT NULL,
    channel_type character varying,
    description text,
    uuid character varying(50),
    email_send boolean,
    public character varying NOT NULL,
    group_public_id integer,
    moderation boolean,
    moderation_notify boolean,
    moderation_notify_msg text,
    moderation_guidelines boolean,
    moderation_guidelines_msg text,
    alias_id integer NOT NULL,
    message_main_attachment_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_channel IS 'Discussion Channel';


--
-- Name: COLUMN mail_channel.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.name IS 'Name';


--
-- Name: COLUMN mail_channel.channel_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN mail_channel.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.description IS 'Description';


--
-- Name: COLUMN mail_channel.uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.uuid IS 'UUID';


--
-- Name: COLUMN mail_channel.email_send; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.email_send IS 'Send messages by email';


--
-- Name: COLUMN mail_channel.public; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.public IS 'Privacy';


--
-- Name: COLUMN mail_channel.group_public_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN mail_channel.moderation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.moderation IS 'Moderate this channel';


--
-- Name: COLUMN mail_channel.moderation_notify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.moderation_notify IS 'Automatic notification';


--
-- Name: COLUMN mail_channel.moderation_notify_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.moderation_notify_msg IS 'Notification message';


--
-- Name: COLUMN mail_channel.moderation_guidelines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.moderation_guidelines IS 'Send guidelines to new subscribers';


--
-- Name: COLUMN mail_channel.moderation_guidelines_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.moderation_guidelines_msg IS 'Guidelines';


--
-- Name: COLUMN mail_channel.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.alias_id IS 'Alias';


--
-- Name: COLUMN mail_channel.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_channel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel.write_date IS 'Last Updated on';


--
-- Name: mail_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_channel_id_seq OWNED BY public.mail_channel.id;


--
-- Name: mail_channel_mail_wizard_invite_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_channel_mail_wizard_invite_rel (
    mail_wizard_invite_id integer NOT NULL,
    mail_channel_id integer NOT NULL
);


--
-- Name: TABLE mail_channel_mail_wizard_invite_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_channel_mail_wizard_invite_rel IS 'RELATION BETWEEN mail_wizard_invite AND mail_channel';


--
-- Name: mail_channel_moderator_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_channel_moderator_rel (
    mail_channel_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE mail_channel_moderator_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_channel_moderator_rel IS 'RELATION BETWEEN mail_channel AND res_users';


--
-- Name: mail_channel_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_channel_partner (
    id integer NOT NULL,
    custom_channel_name character varying,
    partner_id integer,
    channel_id integer,
    fetched_message_id integer,
    seen_message_id integer,
    fold_state character varying,
    is_minimized boolean,
    is_pinned boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_channel_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_channel_partner IS 'Listeners of a Channel';


--
-- Name: COLUMN mail_channel_partner.custom_channel_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN mail_channel_partner.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.partner_id IS 'Recipient';


--
-- Name: COLUMN mail_channel_partner.channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.channel_id IS 'Channel';


--
-- Name: COLUMN mail_channel_partner.fetched_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN mail_channel_partner.seen_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN mail_channel_partner.fold_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN mail_channel_partner.is_minimized; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.is_minimized IS 'Conversation is minimized';


--
-- Name: COLUMN mail_channel_partner.is_pinned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.is_pinned IS 'Is pinned on the interface';


--
-- Name: COLUMN mail_channel_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_channel_partner.write_date IS 'Last Updated on';


--
-- Name: mail_channel_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_channel_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_channel_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_channel_partner_id_seq OWNED BY public.mail_channel_partner.id;


--
-- Name: mail_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_channel_res_groups_rel (
    mail_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


--
-- Name: TABLE mail_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_channel_res_groups_rel IS 'RELATION BETWEEN mail_channel AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    subject character varying,
    body text,
    parent_id integer,
    email_from character varying,
    author_id integer,
    model character varying,
    res_id integer,
    record_name character varying,
    message_type character varying NOT NULL,
    subtype_id integer,
    mail_activity_type_id integer,
    composition_mode character varying,
    reply_to character varying,
    no_auto_thread boolean,
    is_log boolean,
    use_active_domain boolean,
    active_domain text,
    notify boolean,
    auto_delete boolean,
    auto_delete_message boolean,
    template_id integer,
    mail_server_id integer,
    layout character varying,
    add_sign boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_compose_message.no_auto_thread; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.no_auto_thread IS 'No threading for answers';


--
-- Name: COLUMN mail_compose_message.is_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.is_log IS 'Log an Internal Note';


--
-- Name: COLUMN mail_compose_message.use_active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.use_active_domain IS 'Use active domain';


--
-- Name: COLUMN mail_compose_message.active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.active_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.notify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.notify IS 'Notify followers';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_message IS 'Delete Message Copy';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.layout IS 'Layout';


--
-- Name: COLUMN mail_compose_message.add_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.add_sign IS 'Add Sign';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer,
    partner_id integer,
    channel_id integer,
    CONSTRAINT mail_followers_partner_xor_channel CHECK (((partner_id IS NULL) <> (channel_id IS NULL)))
);


--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_followers.channel_id IS 'Listener';


--
-- Name: CONSTRAINT mail_followers_partner_xor_channel ON mail_followers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT mail_followers_partner_xor_channel ON public.mail_followers IS 'CHECK((partner_id IS NULL) != (channel_id IS NULL))';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    body_html text,
    "references" text,
    headers text,
    notification boolean,
    email_to text,
    email_cc character varying,
    state character varying,
    auto_delete boolean,
    failure_reason text,
    scheduled_date character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    fetchmail_server_id integer
);


--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Rich-text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.notification; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.notification IS 'Is Notification';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    subject character varying,
    date timestamp without time zone,
    body text,
    parent_id integer,
    model character varying,
    res_id integer,
    record_name character varying,
    message_type character varying NOT NULL,
    subtype_id integer,
    mail_activity_type_id integer,
    email_from character varying,
    author_id integer,
    no_auto_thread boolean,
    message_id character varying,
    reply_to character varying,
    mail_server_id integer,
    moderation_status character varying,
    moderator_id integer,
    email_layout_xmlid character varying,
    add_sign boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.no_auto_thread; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.no_auto_thread IS 'No threading for answers';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.moderation_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.moderation_status IS 'Moderation Status';


--
-- Name: COLUMN mail_message.moderator_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.moderator_id IS 'Moderated By';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.add_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.add_sign IS 'Add Sign';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_mail_channel_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_mail_channel_rel (
    mail_message_id integer NOT NULL,
    mail_channel_id integer NOT NULL
);


--
-- Name: TABLE mail_message_mail_channel_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_mail_channel_rel IS 'RELATION BETWEEN mail_message AND mail_channel';


--
-- Name: mail_message_res_partner_needaction_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_res_partner_needaction_rel (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    res_partner_id integer,
    is_read boolean,
    notification_type character varying NOT NULL,
    notification_status character varying,
    mail_id integer,
    failure_type character varying,
    failure_reason text,
    read_date timestamp without time zone,
    sms_id integer,
    sms_number character varying,
    CONSTRAINT mail_message_res_partner_needaction_rel_notification_partner_re CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


--
-- Name: TABLE mail_message_res_partner_needaction_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_res_partner_needaction_rel IS 'Message Notifications';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.res_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.res_partner_id IS 'Needaction Recipient';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.is_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.is_read IS 'Is Read';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.notification_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.notification_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.notification_status IS 'Email Status';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.mail_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.mail_id IS 'Mail';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.failure_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.failure_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.read_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.read_date IS 'Read Date';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.sms_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.sms_id IS 'SMS';


--
-- Name: COLUMN mail_message_res_partner_needaction_rel.sms_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_res_partner_needaction_rel.sms_number IS 'SMS Number';


--
-- Name: CONSTRAINT mail_message_res_partner_needaction_rel_notification_partner_re ON mail_message_res_partner_needaction_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT mail_message_res_partner_needaction_rel_notification_partner_re ON public.mail_message_res_partner_needaction_rel IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_message_res_partner_needaction_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_message_res_partner_needaction_rel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_message_res_partner_needaction_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_message_res_partner_needaction_rel_id_seq OWNED BY public.mail_message_res_partner_needaction_rel.id;


--
-- Name: mail_message_res_partner_needaction_rel_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_res_partner_needaction_rel_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_message_res_partner_needaction_rel_id integer NOT NULL
);


--
-- Name: TABLE mail_message_res_partner_needaction_rel_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_res_partner_needaction_rel_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_message_res_partner_needaction_rel';


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    internal boolean,
    parent_id integer,
    relation_field character varying,
    res_model character varying,
    "default" boolean,
    sequence integer,
    hidden boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_moderation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_moderation (
    id integer NOT NULL,
    email character varying NOT NULL,
    status character varying NOT NULL,
    channel_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_moderation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_moderation IS 'Channel black/white list';


--
-- Name: COLUMN mail_moderation.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.email IS 'Email';


--
-- Name: COLUMN mail_moderation.status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.status IS 'Status';


--
-- Name: COLUMN mail_moderation.channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.channel_id IS 'Channel';


--
-- Name: COLUMN mail_moderation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_moderation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.create_date IS 'Created on';


--
-- Name: COLUMN mail_moderation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_moderation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_moderation.write_date IS 'Last Updated on';


--
-- Name: mail_moderation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_moderation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_moderation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_moderation_id_seq OWNED BY public.mail_moderation.id;


--
-- Name: mail_resend_cancel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_resend_cancel (
    id integer NOT NULL,
    model character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_resend_cancel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_resend_cancel IS 'Dismiss notification for resend by model';


--
-- Name: COLUMN mail_resend_cancel.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_cancel.model IS 'Model';


--
-- Name: COLUMN mail_resend_cancel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_cancel.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_cancel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_cancel.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_cancel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_cancel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_cancel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_cancel.write_date IS 'Last Updated on';


--
-- Name: mail_resend_cancel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_resend_cancel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_resend_cancel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_resend_cancel_id_seq OWNED BY public.mail_resend_cancel.id;


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    resend boolean,
    resend_wizard_id integer,
    message character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additionnal information for mail resend';


--
-- Name: COLUMN mail_resend_partner.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.partner_id IS 'Partner';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Send Again';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Help message';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_shortcode; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_shortcode (
    id integer NOT NULL,
    source character varying NOT NULL,
    substitution text NOT NULL,
    description character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_shortcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_shortcode IS 'Canned Response / Shortcode';


--
-- Name: COLUMN mail_shortcode.source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.source IS 'Shortcut';


--
-- Name: COLUMN mail_shortcode.substitution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.substitution IS 'Substitution';


--
-- Name: COLUMN mail_shortcode.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.description IS 'Description';


--
-- Name: COLUMN mail_shortcode.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.create_uid IS 'Created by';


--
-- Name: COLUMN mail_shortcode.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.create_date IS 'Created on';


--
-- Name: COLUMN mail_shortcode.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_shortcode.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_shortcode.write_date IS 'Last Updated on';


--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_shortcode_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_shortcode_id_seq OWNED BY public.mail_shortcode.id;


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    name character varying,
    model_id integer,
    model character varying,
    lang character varying,
    user_signature boolean,
    subject character varying,
    email_from character varying,
    use_default_to boolean,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    mail_server_id integer,
    body_html text,
    report_name character varying,
    report_template integer,
    ref_ir_act_window integer,
    auto_delete boolean,
    model_object_field integer,
    sub_object integer,
    sub_model_object_field integer,
    null_value character varying,
    copyvalue character varying,
    scheduled_date character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.user_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.user_signature IS 'Add Signature';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.report_name IS 'Report Filename';


--
-- Name: COLUMN mail_template.report_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.model_object_field IS 'Field';


--
-- Name: COLUMN mail_template.sub_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.sub_object IS 'Sub-model';


--
-- Name: COLUMN mail_template.sub_model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.sub_model_object_field IS 'Sub-field';


--
-- Name: COLUMN mail_template.null_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.null_value IS 'Default Value';


--
-- Name: COLUMN mail_template.copyvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.copyvalue IS 'Placeholder Expression';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field character varying NOT NULL,
    field_desc character varying NOT NULL,
    field_type character varying,
    old_value_integer integer,
    old_value_float double precision,
    old_value_monetary double precision,
    old_value_char character varying,
    old_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_integer integer,
    new_value_float double precision,
    new_value_monetary double precision,
    new_value_char character varying,
    new_value_text text,
    new_value_datetime timestamp without time zone,
    mail_message_id integer NOT NULL,
    tracking_sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.field IS 'Changed Field';


--
-- Name: COLUMN mail_tracking_value.field_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.field_desc IS 'Field Description';


--
-- Name: COLUMN mail_tracking_value.field_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.field_type IS 'Field Type';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.old_value_monetary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_monetary IS 'Old Value Monetary';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_monetary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_monetary IS 'New Value Monetary';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.tracking_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.tracking_sequence IS 'Tracking field sequence';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer,
    message text,
    send_mail boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.send_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.send_mail IS 'Send Email';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: payment_acquirer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_acquirer (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    display_as character varying,
    description text,
    sequence integer,
    provider character varying NOT NULL,
    company_id integer NOT NULL,
    view_template_id integer,
    registration_view_template_id integer,
    state character varying NOT NULL,
    capture_manually boolean,
    journal_id integer,
    check_validity boolean,
    pre_msg text,
    auth_msg text,
    pending_msg text,
    done_msg text,
    cancel_msg text,
    save_token character varying,
    fees_active boolean,
    fees_dom_fixed double precision,
    fees_dom_var double precision,
    fees_int_fixed double precision,
    fees_int_var double precision,
    qr_code boolean,
    module_id integer,
    module_state character varying,
    payment_flow character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    so_reference_type character varying
);


--
-- Name: TABLE payment_acquirer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_acquirer IS 'Payment Acquirer';


--
-- Name: COLUMN payment_acquirer.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.name IS 'Name';


--
-- Name: COLUMN payment_acquirer.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.color IS 'Color';


--
-- Name: COLUMN payment_acquirer.display_as; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.display_as IS 'Displayed as';


--
-- Name: COLUMN payment_acquirer.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.description IS 'Description';


--
-- Name: COLUMN payment_acquirer.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.sequence IS 'Sequence';


--
-- Name: COLUMN payment_acquirer.provider; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.provider IS 'Provider';


--
-- Name: COLUMN payment_acquirer.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.company_id IS 'Company';


--
-- Name: COLUMN payment_acquirer.view_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.view_template_id IS 'Form Button Template';


--
-- Name: COLUMN payment_acquirer.registration_view_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.registration_view_template_id IS 'S2S Form Template';


--
-- Name: COLUMN payment_acquirer.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.state IS 'State';


--
-- Name: COLUMN payment_acquirer.capture_manually; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.capture_manually IS 'Capture Amount Manually';


--
-- Name: COLUMN payment_acquirer.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.journal_id IS 'Payment Journal';


--
-- Name: COLUMN payment_acquirer.check_validity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.check_validity IS 'Verify Card Validity';


--
-- Name: COLUMN payment_acquirer.pre_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.pre_msg IS 'Help Message';


--
-- Name: COLUMN payment_acquirer.auth_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.auth_msg IS 'Authorize Message';


--
-- Name: COLUMN payment_acquirer.pending_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.pending_msg IS 'Pending Message';


--
-- Name: COLUMN payment_acquirer.done_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.done_msg IS 'Done Message';


--
-- Name: COLUMN payment_acquirer.cancel_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.cancel_msg IS 'Cancel Message';


--
-- Name: COLUMN payment_acquirer.save_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.save_token IS 'Save Cards';


--
-- Name: COLUMN payment_acquirer.fees_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.fees_active IS 'Add Extra Fees';


--
-- Name: COLUMN payment_acquirer.fees_dom_fixed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.fees_dom_fixed IS 'Fixed domestic fees';


--
-- Name: COLUMN payment_acquirer.fees_dom_var; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.fees_dom_var IS 'Variable domestic fees (in percents)';


--
-- Name: COLUMN payment_acquirer.fees_int_fixed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.fees_int_fixed IS 'Fixed international fees';


--
-- Name: COLUMN payment_acquirer.fees_int_var; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.fees_int_var IS 'Variable international fees (in percents)';


--
-- Name: COLUMN payment_acquirer.qr_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.qr_code IS 'Use SEPA QR Code';


--
-- Name: COLUMN payment_acquirer.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.module_id IS 'Corresponding Module';


--
-- Name: COLUMN payment_acquirer.module_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.module_state IS 'Installation State';


--
-- Name: COLUMN payment_acquirer.payment_flow; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.payment_flow IS 'Payment Flow';


--
-- Name: COLUMN payment_acquirer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.create_uid IS 'Created by';


--
-- Name: COLUMN payment_acquirer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.create_date IS 'Created on';


--
-- Name: COLUMN payment_acquirer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_acquirer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_acquirer.so_reference_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer.so_reference_type IS 'Communication';


--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_acquirer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_acquirer_id_seq OWNED BY public.payment_acquirer.id;


--
-- Name: payment_acquirer_onboarding_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_acquirer_onboarding_wizard (
    id integer NOT NULL,
    payment_method character varying,
    paypal_user_type character varying,
    paypal_email_account character varying,
    paypal_seller_account character varying,
    paypal_pdt_token character varying,
    stripe_secret_key character varying,
    stripe_publishable_key character varying,
    manual_name character varying,
    journal_name character varying,
    acc_number character varying,
    manual_post_msg text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE payment_acquirer_onboarding_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_acquirer_onboarding_wizard IS 'Payment acquire onboarding wizard';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_user_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_user_type IS 'Paypal User Type';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_email_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_email_account IS 'Email';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_seller_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_seller_account IS 'Merchant Account ID';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_pdt_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_pdt_token IS 'PDT Identity Token';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.stripe_secret_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.stripe_secret_key IS 'Stripe Secret Key';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.stripe_publishable_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.stripe_publishable_key IS 'Stripe Publishable Key';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.manual_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.manual_name IS 'Method';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.journal_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.journal_name IS 'Bank Name';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.acc_number IS 'Account Number';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.manual_post_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.manual_post_msg IS 'Payment Instructions';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_acquirer_onboarding_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_acquirer_onboarding_wizard_id_seq OWNED BY public.payment_acquirer_onboarding_wizard.id;


--
-- Name: payment_acquirer_payment_icon_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_acquirer_payment_icon_rel (
    payment_acquirer_id integer NOT NULL,
    payment_icon_id integer NOT NULL
);


--
-- Name: TABLE payment_acquirer_payment_icon_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_acquirer_payment_icon_rel IS 'RELATION BETWEEN payment_acquirer AND payment_icon';


--
-- Name: payment_country_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_country_rel (
    payment_id integer NOT NULL,
    country_id integer NOT NULL
);


--
-- Name: TABLE payment_country_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_country_rel IS 'RELATION BETWEEN payment_acquirer AND res_country';


--
-- Name: payment_icon; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_icon (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE payment_icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_icon IS 'Payment Icon';


--
-- Name: COLUMN payment_icon.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_icon.name IS 'Name';


--
-- Name: COLUMN payment_icon.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_icon.create_uid IS 'Created by';


--
-- Name: COLUMN payment_icon.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_icon.create_date IS 'Created on';


--
-- Name: COLUMN payment_icon.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_icon.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_icon.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_icon.write_date IS 'Last Updated on';


--
-- Name: payment_icon_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_icon_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_icon_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_icon_id_seq OWNED BY public.payment_icon.id;


--
-- Name: payment_link_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_link_wizard (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer NOT NULL,
    amount numeric NOT NULL,
    amount_max numeric,
    currency_id integer,
    partner_id integer,
    description character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE payment_link_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_link_wizard IS 'Generate Payment Link';


--
-- Name: COLUMN payment_link_wizard.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN payment_link_wizard.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN payment_link_wizard.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.amount IS 'Amount';


--
-- Name: COLUMN payment_link_wizard.amount_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.amount_max IS 'Amount Max';


--
-- Name: COLUMN payment_link_wizard.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.currency_id IS 'Currency';


--
-- Name: COLUMN payment_link_wizard.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN payment_link_wizard.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.description IS 'Payment Ref';


--
-- Name: COLUMN payment_link_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_link_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_link_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_link_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_link_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_link_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_link_wizard_id_seq OWNED BY public.payment_link_wizard.id;


--
-- Name: payment_token; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_token (
    id integer NOT NULL,
    name character varying,
    partner_id integer NOT NULL,
    acquirer_id integer NOT NULL,
    company_id integer,
    acquirer_ref character varying NOT NULL,
    active boolean,
    verified boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE payment_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_token IS 'Payment Token';


--
-- Name: COLUMN payment_token.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.name IS 'Name';


--
-- Name: COLUMN payment_token.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.partner_id IS 'Partner';


--
-- Name: COLUMN payment_token.acquirer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.acquirer_id IS 'Acquirer Account';


--
-- Name: COLUMN payment_token.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.company_id IS 'Company';


--
-- Name: COLUMN payment_token.acquirer_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.acquirer_ref IS 'Acquirer Ref.';


--
-- Name: COLUMN payment_token.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.active IS 'Active';


--
-- Name: COLUMN payment_token.verified; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.verified IS 'Verified';


--
-- Name: COLUMN payment_token.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.create_uid IS 'Created by';


--
-- Name: COLUMN payment_token.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.create_date IS 'Created on';


--
-- Name: COLUMN payment_token.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_token.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_token.write_date IS 'Last Updated on';


--
-- Name: payment_token_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_token_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_token_id_seq OWNED BY public.payment_token.id;


--
-- Name: payment_transaction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payment_transaction (
    id integer NOT NULL,
    date timestamp without time zone,
    acquirer_id integer NOT NULL,
    type character varying NOT NULL,
    state character varying NOT NULL,
    state_message text,
    amount numeric NOT NULL,
    fees numeric,
    currency_id integer NOT NULL,
    reference character varying NOT NULL,
    acquirer_reference character varying,
    partner_id integer,
    partner_name character varying,
    partner_lang character varying,
    partner_email character varying,
    partner_zip character varying,
    partner_address character varying,
    partner_city character varying,
    partner_country_id integer NOT NULL,
    partner_phone character varying,
    html_3ds character varying,
    callback_model_id integer,
    callback_res_id integer,
    callback_method character varying,
    callback_hash character varying,
    return_url character varying,
    is_processed boolean,
    payment_token_id integer,
    payment_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE payment_transaction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.payment_transaction IS 'Payment Transaction';


--
-- Name: COLUMN payment_transaction.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.date IS 'Validation Date';


--
-- Name: COLUMN payment_transaction.acquirer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.acquirer_id IS 'Acquirer';


--
-- Name: COLUMN payment_transaction.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.type IS 'Type';


--
-- Name: COLUMN payment_transaction.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.state IS 'Status';


--
-- Name: COLUMN payment_transaction.state_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.state_message IS 'Message';


--
-- Name: COLUMN payment_transaction.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.amount IS 'Amount';


--
-- Name: COLUMN payment_transaction.fees; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.fees IS 'Fees';


--
-- Name: COLUMN payment_transaction.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.currency_id IS 'Currency';


--
-- Name: COLUMN payment_transaction.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.reference IS 'Reference';


--
-- Name: COLUMN payment_transaction.acquirer_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.acquirer_reference IS 'Acquirer Reference';


--
-- Name: COLUMN payment_transaction.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_id IS 'Customer';


--
-- Name: COLUMN payment_transaction.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_name IS 'Partner Name';


--
-- Name: COLUMN payment_transaction.partner_lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_lang IS 'Language';


--
-- Name: COLUMN payment_transaction.partner_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_email IS 'Email';


--
-- Name: COLUMN payment_transaction.partner_zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_zip IS 'Zip';


--
-- Name: COLUMN payment_transaction.partner_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_address IS 'Address';


--
-- Name: COLUMN payment_transaction.partner_city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_city IS 'City';


--
-- Name: COLUMN payment_transaction.partner_country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_country_id IS 'Country';


--
-- Name: COLUMN payment_transaction.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.partner_phone IS 'Phone';


--
-- Name: COLUMN payment_transaction.html_3ds; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.html_3ds IS '3D Secure HTML';


--
-- Name: COLUMN payment_transaction.callback_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.callback_model_id IS 'Callback Document Model';


--
-- Name: COLUMN payment_transaction.callback_res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.callback_res_id IS 'Callback Document ID';


--
-- Name: COLUMN payment_transaction.callback_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.callback_method IS 'Callback Method';


--
-- Name: COLUMN payment_transaction.callback_hash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.callback_hash IS 'Callback Hash';


--
-- Name: COLUMN payment_transaction.return_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.return_url IS 'Return URL after payment';


--
-- Name: COLUMN payment_transaction.is_processed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.is_processed IS 'Has the payment been post processed';


--
-- Name: COLUMN payment_transaction.payment_token_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.payment_token_id IS 'Payment Token';


--
-- Name: COLUMN payment_transaction.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.payment_id IS 'Payment';


--
-- Name: COLUMN payment_transaction.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.create_uid IS 'Created by';


--
-- Name: COLUMN payment_transaction.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.create_date IS 'Created on';


--
-- Name: COLUMN payment_transaction.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_transaction.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payment_transaction.write_date IS 'Last Updated on';


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payment_transaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payment_transaction_id_seq OWNED BY public.payment_transaction.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    message_main_attachment_id integer,
    number character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer NOT NULL,
    note text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    welcome_message text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    email character varying,
    in_portal boolean,
    user_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.in_portal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.in_portal IS 'In Portal';


--
-- Name: COLUMN portal_wizard_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.user_id IS 'Login User';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_variant character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    display_type character varying NOT NULL
);


--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variants Creation Mode';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    sale_order_line_id integer NOT NULL,
    custom_value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.sale_order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.sale_order_line_id IS 'Sales Order Line';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_attribute_custom_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNED BY public.product_attribute_custom_value.id;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_attribute_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_attribute_id_seq OWNED BY public.product_attribute.id;


--
-- Name: product_attribute_product_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attribute_product_template_rel (
    product_attribute_id integer NOT NULL,
    product_template_id integer NOT NULL
);


--
-- Name: TABLE product_attribute_product_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attribute_product_template_rel IS 'RELATION BETWEEN product_attribute AND product_template';


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attribute_value (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    is_custom boolean,
    html_color character varying
);


--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attribute_value IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_value.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.name IS 'Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_value.is_custom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.is_custom IS 'Is custom value';


--
-- Name: COLUMN product_attribute_value.html_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_attribute_value.html_color IS 'Color';


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_attribute_value_id_seq OWNED BY public.product_attribute_value.id;


--
-- Name: product_attribute_value_product_template_attribute_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_attribute_value_product_template_attribute_line_rel (
    product_attribute_value_id integer NOT NULL,
    product_template_attribute_line_id integer NOT NULL
);


--
-- Name: TABLE product_attribute_value_product_template_attribute_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_attribute_value_product_template_attribute_line_rel IS 'RELATION BETWEEN product_attribute_value AND product_template_attribute_line';


--
-- Name: product_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_category (
    id integer NOT NULL,
    parent_path character varying,
    name character varying NOT NULL,
    complete_name character varying,
    parent_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_category IS 'Product Category';


--
-- Name: COLUMN product_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.name IS 'Name';


--
-- Name: COLUMN product_category.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.complete_name IS 'Complete Name';


--
-- Name: COLUMN product_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.create_date IS 'Created on';


--
-- Name: COLUMN product_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_category.write_date IS 'Last Updated on';


--
-- Name: product_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_category_id_seq OWNED BY public.product_category.id;


--
-- Name: product_packaging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_packaging (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    product_id integer,
    qty double precision,
    barcode character varying,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_packaging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_packaging IS 'Product Packaging';


--
-- Name: COLUMN product_packaging.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.name IS 'Package Type';


--
-- Name: COLUMN product_packaging.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.sequence IS 'Sequence';


--
-- Name: COLUMN product_packaging.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.product_id IS 'Product';


--
-- Name: COLUMN product_packaging.qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.qty IS 'Contained Quantity';


--
-- Name: COLUMN product_packaging.barcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.barcode IS 'Barcode';


--
-- Name: COLUMN product_packaging.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.company_id IS 'Company';


--
-- Name: COLUMN product_packaging.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.create_uid IS 'Created by';


--
-- Name: COLUMN product_packaging.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.create_date IS 'Created on';


--
-- Name: COLUMN product_packaging.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_packaging.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_packaging.write_date IS 'Last Updated on';


--
-- Name: product_packaging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_packaging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_packaging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_packaging_id_seq OWNED BY public.product_packaging.id;


--
-- Name: product_price_list; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_price_list (
    id integer NOT NULL,
    price_list integer NOT NULL,
    qty1 integer,
    qty2 integer,
    qty3 integer,
    qty4 integer,
    qty5 integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_price_list; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_price_list IS 'Product Price per Unit Based on Pricelist Version';


--
-- Name: COLUMN product_price_list.price_list; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.price_list IS 'PriceList';


--
-- Name: COLUMN product_price_list.qty1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.qty1 IS 'Quantity-1';


--
-- Name: COLUMN product_price_list.qty2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.qty2 IS 'Quantity-2';


--
-- Name: COLUMN product_price_list.qty3; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.qty3 IS 'Quantity-3';


--
-- Name: COLUMN product_price_list.qty4; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.qty4 IS 'Quantity-4';


--
-- Name: COLUMN product_price_list.qty5; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.qty5 IS 'Quantity-5';


--
-- Name: COLUMN product_price_list.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.create_uid IS 'Created by';


--
-- Name: COLUMN product_price_list.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.create_date IS 'Created on';


--
-- Name: COLUMN product_price_list.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_price_list.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_price_list.write_date IS 'Last Updated on';


--
-- Name: product_price_list_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_price_list_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_price_list_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_price_list_id_seq OWNED BY public.product_price_list.id;


--
-- Name: product_pricelist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_pricelist (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    currency_id integer NOT NULL,
    company_id integer,
    sequence integer,
    discount_policy character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_pricelist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_pricelist IS 'Pricelist';


--
-- Name: COLUMN product_pricelist.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.name IS 'Pricelist Name';


--
-- Name: COLUMN product_pricelist.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.active IS 'Active';


--
-- Name: COLUMN product_pricelist.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.sequence IS 'Sequence';


--
-- Name: COLUMN product_pricelist.discount_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.discount_policy IS 'Discount Policy';


--
-- Name: COLUMN product_pricelist.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_pricelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_pricelist_id_seq OWNED BY public.product_pricelist.id;


--
-- Name: product_pricelist_item; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_pricelist_item (
    id integer NOT NULL,
    product_tmpl_id integer,
    product_id integer,
    categ_id integer,
    min_quantity integer,
    applied_on character varying NOT NULL,
    base character varying NOT NULL,
    base_pricelist_id integer,
    pricelist_id integer NOT NULL,
    price_surcharge numeric,
    price_discount numeric,
    price_round numeric,
    price_min_margin numeric,
    price_max_margin numeric,
    company_id integer,
    currency_id integer,
    active boolean,
    date_start date,
    date_end date,
    compute_price character varying NOT NULL,
    fixed_price numeric,
    percent_price double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_pricelist_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_pricelist_item IS 'Pricelist Rule';


--
-- Name: COLUMN product_pricelist_item.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.product_tmpl_id IS 'Product';


--
-- Name: COLUMN product_pricelist_item.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.product_id IS 'Product Variant';


--
-- Name: COLUMN product_pricelist_item.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.categ_id IS 'Product Category';


--
-- Name: COLUMN product_pricelist_item.min_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.min_quantity IS 'Min. Quantity';


--
-- Name: COLUMN product_pricelist_item.applied_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.applied_on IS 'Apply On';


--
-- Name: COLUMN product_pricelist_item.base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.base IS 'Based on';


--
-- Name: COLUMN product_pricelist_item.base_pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.base_pricelist_id IS 'Other Pricelist';


--
-- Name: COLUMN product_pricelist_item.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN product_pricelist_item.price_surcharge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.price_surcharge IS 'Price Surcharge';


--
-- Name: COLUMN product_pricelist_item.price_discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.price_discount IS 'Price Discount';


--
-- Name: COLUMN product_pricelist_item.price_round; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.price_round IS 'Price Rounding';


--
-- Name: COLUMN product_pricelist_item.price_min_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.price_min_margin IS 'Min. Price Margin';


--
-- Name: COLUMN product_pricelist_item.price_max_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.price_max_margin IS 'Max. Price Margin';


--
-- Name: COLUMN product_pricelist_item.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_item.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist_item.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.active IS 'Active';


--
-- Name: COLUMN product_pricelist_item.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.date_start IS 'Start Date';


--
-- Name: COLUMN product_pricelist_item.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.date_end IS 'End Date';


--
-- Name: COLUMN product_pricelist_item.compute_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.compute_price IS 'Compute Price';


--
-- Name: COLUMN product_pricelist_item.fixed_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN product_pricelist_item.percent_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.percent_price IS 'Percentage Price';


--
-- Name: COLUMN product_pricelist_item.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_item.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_item.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_item.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_pricelist_item.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_pricelist_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_pricelist_item_id_seq OWNED BY public.product_pricelist_item.id;


--
-- Name: product_product; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_product (
    id integer NOT NULL,
    message_main_attachment_id integer,
    default_code character varying,
    active boolean,
    product_tmpl_id integer NOT NULL,
    barcode character varying,
    combination_indices character varying,
    volume numeric,
    weight numeric,
    can_image_variant_1024_be_zoomed boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_product; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_product IS 'Product';


--
-- Name: COLUMN product_product.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_product.default_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_product.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.active IS 'Active';


--
-- Name: COLUMN product_product.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_product.barcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.barcode IS 'Barcode';


--
-- Name: COLUMN product_product.combination_indices; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.combination_indices IS 'Combination Indices';


--
-- Name: COLUMN product_product.volume; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.volume IS 'Volume';


--
-- Name: COLUMN product_product.weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.weight IS 'Weight';


--
-- Name: COLUMN product_product.can_image_variant_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.can_image_variant_1024_be_zoomed IS 'Can Variant Image 1024 be zoomed';


--
-- Name: COLUMN product_product.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.create_uid IS 'Created by';


--
-- Name: COLUMN product_product.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.create_date IS 'Created on';


--
-- Name: COLUMN product_product.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_product.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_product.write_date IS 'Last Updated on';


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_product_id_seq OWNED BY public.product_product.id;


--
-- Name: product_supplier_taxes_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_supplier_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE product_supplier_taxes_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_supplier_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_supplierinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_supplierinfo (
    id integer NOT NULL,
    name integer NOT NULL,
    product_name character varying,
    product_code character varying,
    sequence integer,
    min_qty double precision NOT NULL,
    price numeric NOT NULL,
    company_id integer,
    currency_id integer NOT NULL,
    date_start date,
    date_end date,
    product_id integer,
    product_tmpl_id integer,
    delay integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_supplierinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_supplierinfo IS 'Supplier Pricelist';


--
-- Name: COLUMN product_supplierinfo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.name IS 'Vendor';


--
-- Name: COLUMN product_supplierinfo.product_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.product_name IS 'Vendor Product Name';


--
-- Name: COLUMN product_supplierinfo.product_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.product_code IS 'Vendor Product Code';


--
-- Name: COLUMN product_supplierinfo.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.sequence IS 'Sequence';


--
-- Name: COLUMN product_supplierinfo.min_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.min_qty IS 'Quantity';


--
-- Name: COLUMN product_supplierinfo.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.price IS 'Price';


--
-- Name: COLUMN product_supplierinfo.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.company_id IS 'Company';


--
-- Name: COLUMN product_supplierinfo.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.currency_id IS 'Currency';


--
-- Name: COLUMN product_supplierinfo.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.date_start IS 'Start Date';


--
-- Name: COLUMN product_supplierinfo.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.date_end IS 'End Date';


--
-- Name: COLUMN product_supplierinfo.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.product_id IS 'Product Variant';


--
-- Name: COLUMN product_supplierinfo.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_supplierinfo.delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.delay IS 'Delivery Lead Time';


--
-- Name: COLUMN product_supplierinfo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.create_uid IS 'Created by';


--
-- Name: COLUMN product_supplierinfo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.create_date IS 'Created on';


--
-- Name: COLUMN product_supplierinfo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_supplierinfo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_supplierinfo.write_date IS 'Last Updated on';


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_supplierinfo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_supplierinfo_id_seq OWNED BY public.product_supplierinfo.id;


--
-- Name: product_taxes_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE product_taxes_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_template (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    sequence integer,
    description text,
    description_purchase text,
    description_sale text,
    type character varying NOT NULL,
    rental boolean,
    categ_id integer NOT NULL,
    list_price numeric,
    volume numeric,
    weight numeric,
    sale_ok boolean,
    purchase_ok boolean,
    uom_id integer NOT NULL,
    uom_po_id integer NOT NULL,
    company_id integer,
    active boolean,
    color integer,
    default_code character varying,
    can_image_1024_be_zoomed boolean,
    has_configurable_attributes boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    service_type character varying,
    sale_line_warn character varying NOT NULL,
    sale_line_warn_msg text,
    expense_policy character varying,
    invoice_policy character varying,
    purchase_method character varying,
    purchase_line_warn character varying NOT NULL,
    purchase_line_warn_msg text,
    service_to_purchase boolean,
    CONSTRAINT product_template_service_to_purchase CHECK (((((type)::text <> 'service'::text) AND (service_to_purchase <> true)) OR ((type)::text = 'service'::text)))
);


--
-- Name: TABLE product_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_template IS 'Product Template';


--
-- Name: COLUMN product_template.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.name IS 'Name';


--
-- Name: COLUMN product_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.sequence IS 'Sequence';


--
-- Name: COLUMN product_template.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.description IS 'Description';


--
-- Name: COLUMN product_template.description_purchase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.description_purchase IS 'Purchase Description';


--
-- Name: COLUMN product_template.description_sale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.description_sale IS 'Sales Description';


--
-- Name: COLUMN product_template.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.type IS 'Product Type';


--
-- Name: COLUMN product_template.rental; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.rental IS 'Can be Rent';


--
-- Name: COLUMN product_template.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.categ_id IS 'Product Category';


--
-- Name: COLUMN product_template.list_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.list_price IS 'Sales Price';


--
-- Name: COLUMN product_template.volume; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.volume IS 'Volume';


--
-- Name: COLUMN product_template.weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.weight IS 'Weight';


--
-- Name: COLUMN product_template.sale_ok; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.sale_ok IS 'Can be Sold';


--
-- Name: COLUMN product_template.purchase_ok; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.purchase_ok IS 'Can be Purchased';


--
-- Name: COLUMN product_template.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN product_template.uom_po_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.uom_po_id IS 'Purchase Unit of Measure';


--
-- Name: COLUMN product_template.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.company_id IS 'Company';


--
-- Name: COLUMN product_template.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.active IS 'Active';


--
-- Name: COLUMN product_template.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.color IS 'Color Index';


--
-- Name: COLUMN product_template.default_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_template.can_image_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.can_image_1024_be_zoomed IS 'Can Image 1024 be zoomed';


--
-- Name: COLUMN product_template.has_configurable_attributes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.has_configurable_attributes IS 'Is a configurable product';


--
-- Name: COLUMN product_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.create_uid IS 'Created by';


--
-- Name: COLUMN product_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.create_date IS 'Created on';


--
-- Name: COLUMN product_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_template.service_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.service_type IS 'Track Service';


--
-- Name: COLUMN product_template.sale_line_warn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.sale_line_warn IS 'Sales Order Line';


--
-- Name: COLUMN product_template.sale_line_warn_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.sale_line_warn_msg IS 'Message for Sales Order Line';


--
-- Name: COLUMN product_template.expense_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.expense_policy IS 'Re-Invoice Expenses';


--
-- Name: COLUMN product_template.invoice_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN product_template.purchase_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.purchase_method IS 'Control Policy';


--
-- Name: COLUMN product_template.purchase_line_warn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.purchase_line_warn IS 'Purchase Order Line';


--
-- Name: COLUMN product_template.purchase_line_warn_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.purchase_line_warn_msg IS 'Message for Purchase Order Line';


--
-- Name: COLUMN product_template.service_to_purchase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template.service_to_purchase IS 'Purchase Automatically';


--
-- Name: CONSTRAINT product_template_service_to_purchase ON product_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT product_template_service_to_purchase ON public.product_template IS 'CHECK((type != ''service'' AND service_to_purchase != true) or (type = ''service''))';


--
-- Name: product_template_attribute_exclusion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_template_attribute_exclusion (
    id integer NOT NULL,
    product_template_attribute_value_id integer,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_template_attribute_exclusion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_template_attribute_exclusion IS 'Product Template Attribute Exclusion';


--
-- Name: COLUMN product_template_attribute_exclusion.product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_exclusion.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_exclusion.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_exclusion.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_template_attribute_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNED BY public.product_template_attribute_exclusion.id;


--
-- Name: product_template_attribute_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_template_attribute_line (
    id integer NOT NULL,
    active boolean,
    product_tmpl_id integer NOT NULL,
    attribute_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_template_attribute_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_template_attribute_line IS 'Product Template Attribute Line';


--
-- Name: COLUMN product_template_attribute_line.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.active IS 'Active';


--
-- Name: COLUMN product_template_attribute_line.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_line.attribute_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_line.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_template_attribute_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_template_attribute_line_id_seq OWNED BY public.product_template_attribute_line.id;


--
-- Name: product_template_attribute_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_template_attribute_value (
    id integer NOT NULL,
    ptav_active boolean,
    product_attribute_value_id integer NOT NULL,
    attribute_line_id integer NOT NULL,
    price_extra numeric,
    product_tmpl_id integer,
    attribute_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_template_attribute_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_template_attribute_value IS 'Product Template Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.ptav_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.ptav_active IS 'Active';


--
-- Name: COLUMN product_template_attribute_value.product_attribute_value_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.product_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.attribute_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_line_id IS 'Attribute Line';


--
-- Name: COLUMN product_template_attribute_value.price_extra; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.price_extra IS 'Value Price Extra';


--
-- Name: COLUMN product_template_attribute_value.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.product_template_attribute_value.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_template_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_template_attribute_value_id_seq OWNED BY public.product_template_attribute_value.id;


--
-- Name: product_template_attribute_value_sale_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_template_attribute_value_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


--
-- Name: TABLE product_template_attribute_value_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_template_attribute_value_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND product_template_attribute_value';


--
-- Name: product_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.product_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.product_template_id_seq OWNED BY public.product_template.id;


--
-- Name: product_variant_combination; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.product_variant_combination (
    product_product_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


--
-- Name: TABLE product_variant_combination; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.product_variant_combination IS 'RELATION BETWEEN product_product AND product_template_attribute_value';


--
-- Name: purchase_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.purchase_order (
    id integer NOT NULL,
    access_token character varying,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    origin character varying,
    partner_ref character varying,
    date_order timestamp without time zone NOT NULL,
    date_approve timestamp without time zone,
    partner_id integer NOT NULL,
    dest_address_id integer,
    currency_id integer NOT NULL,
    state character varying,
    notes text,
    invoice_count integer,
    invoice_status character varying,
    date_planned timestamp without time zone,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    fiscal_position_id integer,
    payment_term_id integer,
    incoterm_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_rate double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE purchase_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.purchase_order IS 'Purchase Order';


--
-- Name: COLUMN purchase_order.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.access_token IS 'Security Token';


--
-- Name: COLUMN purchase_order.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN purchase_order.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.name IS 'Order Reference';


--
-- Name: COLUMN purchase_order.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.origin IS 'Source Document';


--
-- Name: COLUMN purchase_order.partner_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.partner_ref IS 'Vendor Reference';


--
-- Name: COLUMN purchase_order.date_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.date_order IS 'Order Date';


--
-- Name: COLUMN purchase_order.date_approve; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.date_approve IS 'Confirmation Date';


--
-- Name: COLUMN purchase_order.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.partner_id IS 'Vendor';


--
-- Name: COLUMN purchase_order.dest_address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.dest_address_id IS 'Drop Ship Address';


--
-- Name: COLUMN purchase_order.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.currency_id IS 'Currency';


--
-- Name: COLUMN purchase_order.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.state IS 'Status';


--
-- Name: COLUMN purchase_order.notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.notes IS 'Terms and Conditions';


--
-- Name: COLUMN purchase_order.invoice_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.invoice_count IS 'Bill Count';


--
-- Name: COLUMN purchase_order.invoice_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.invoice_status IS 'Billing Status';


--
-- Name: COLUMN purchase_order.date_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.date_planned IS 'Receipt Date';


--
-- Name: COLUMN purchase_order.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN purchase_order.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.amount_tax IS 'Taxes';


--
-- Name: COLUMN purchase_order.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.amount_total IS 'Total';


--
-- Name: COLUMN purchase_order.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN purchase_order.payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN purchase_order.incoterm_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.incoterm_id IS 'Incoterm';


--
-- Name: COLUMN purchase_order.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.user_id IS 'Purchase Representative';


--
-- Name: COLUMN purchase_order.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.company_id IS 'Company';


--
-- Name: COLUMN purchase_order.currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN purchase_order.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_order.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN purchase_order.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order.write_date IS 'Last Updated on';


--
-- Name: purchase_bill_union; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.purchase_bill_union AS
 SELECT account_move.id,
    account_move.name,
    account_move.ref AS reference,
    account_move.partner_id,
    account_move.date,
    account_move.amount_untaxed AS amount,
    account_move.currency_id,
    account_move.company_id,
    account_move.id AS vendor_bill_id,
    NULL::integer AS purchase_order_id
   FROM public.account_move
  WHERE (((account_move.type)::text = 'in_invoice'::text) AND ((account_move.state)::text = 'posted'::text))
UNION
 SELECT (- purchase_order.id) AS id,
    purchase_order.name,
    purchase_order.partner_ref AS reference,
    purchase_order.partner_id,
    (purchase_order.date_order)::date AS date,
    purchase_order.amount_untaxed AS amount,
    purchase_order.currency_id,
    purchase_order.company_id,
    NULL::integer AS vendor_bill_id,
    purchase_order.id AS purchase_order_id
   FROM public.purchase_order
  WHERE (((purchase_order.state)::text = ANY ((ARRAY['purchase'::character varying, 'done'::character varying])::text[])) AND ((purchase_order.invoice_status)::text = ANY ((ARRAY['to invoice'::character varying, 'no'::character varying])::text[])));


--
-- Name: purchase_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.purchase_order_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.purchase_order_id_seq OWNED BY public.purchase_order.id;


--
-- Name: purchase_order_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.purchase_order_line (
    id integer NOT NULL,
    name text NOT NULL,
    sequence integer,
    product_qty numeric NOT NULL,
    product_uom_qty double precision,
    date_planned timestamp without time zone,
    product_uom integer,
    product_id integer,
    price_unit numeric NOT NULL,
    price_subtotal numeric,
    price_total numeric,
    price_tax double precision,
    order_id integer NOT NULL,
    account_analytic_id integer,
    company_id integer,
    state character varying,
    qty_invoiced numeric,
    qty_received_method character varying,
    qty_received numeric,
    qty_received_manual numeric,
    partner_id integer,
    currency_id integer,
    display_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    sale_order_id integer,
    sale_line_id integer,
    CONSTRAINT purchase_order_line_accountable_required_fields CHECK (((display_type IS NOT NULL) OR ((product_id IS NOT NULL) AND (product_uom IS NOT NULL) AND (date_planned IS NOT NULL)))),
    CONSTRAINT purchase_order_line_non_accountable_null_fields CHECK (((display_type IS NULL) OR ((product_id IS NULL) AND (price_unit = (0)::numeric) AND (product_uom_qty = (0)::double precision) AND (product_uom IS NULL) AND (date_planned IS NULL))))
);


--
-- Name: TABLE purchase_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.purchase_order_line IS 'Purchase Order Line';


--
-- Name: COLUMN purchase_order_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.name IS 'Description';


--
-- Name: COLUMN purchase_order_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.sequence IS 'Sequence';


--
-- Name: COLUMN purchase_order_line.product_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.product_qty IS 'Quantity';


--
-- Name: COLUMN purchase_order_line.product_uom_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.product_uom_qty IS 'Total Quantity';


--
-- Name: COLUMN purchase_order_line.date_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.date_planned IS 'Scheduled Date';


--
-- Name: COLUMN purchase_order_line.product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.product_uom IS 'Unit of Measure';


--
-- Name: COLUMN purchase_order_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.product_id IS 'Product';


--
-- Name: COLUMN purchase_order_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN purchase_order_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN purchase_order_line.price_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.price_total IS 'Total';


--
-- Name: COLUMN purchase_order_line.price_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.price_tax IS 'Tax';


--
-- Name: COLUMN purchase_order_line.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.order_id IS 'Order Reference';


--
-- Name: COLUMN purchase_order_line.account_analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.account_analytic_id IS 'Analytic Account';


--
-- Name: COLUMN purchase_order_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.company_id IS 'Company';


--
-- Name: COLUMN purchase_order_line.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.state IS 'Status';


--
-- Name: COLUMN purchase_order_line.qty_invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.qty_invoiced IS 'Billed Qty';


--
-- Name: COLUMN purchase_order_line.qty_received_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.qty_received_method IS 'Received Qty Method';


--
-- Name: COLUMN purchase_order_line.qty_received; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.qty_received IS 'Received Qty';


--
-- Name: COLUMN purchase_order_line.qty_received_manual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.qty_received_manual IS 'Manual Received Qty';


--
-- Name: COLUMN purchase_order_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.partner_id IS 'Partner';


--
-- Name: COLUMN purchase_order_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.currency_id IS 'Currency';


--
-- Name: COLUMN purchase_order_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.display_type IS 'Display Type';


--
-- Name: COLUMN purchase_order_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_order_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN purchase_order_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_order_line.sale_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.sale_order_id IS 'Sale Order';


--
-- Name: COLUMN purchase_order_line.sale_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchase_order_line.sale_line_id IS 'Origin Sale Item';


--
-- Name: CONSTRAINT purchase_order_line_accountable_required_fields ON purchase_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT purchase_order_line_accountable_required_fields ON public.purchase_order_line IS 'CHECK(display_type IS NOT NULL OR (product_id IS NOT NULL AND product_uom IS NOT NULL AND date_planned IS NOT NULL))';


--
-- Name: CONSTRAINT purchase_order_line_non_accountable_null_fields ON purchase_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT purchase_order_line_non_accountable_null_fields ON public.purchase_order_line IS 'CHECK(display_type IS NULL OR (product_id IS NULL AND price_unit = 0 AND product_uom_qty = 0 AND product_uom IS NULL AND date_planned is NULL))';


--
-- Name: purchase_order_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.purchase_order_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.purchase_order_line_id_seq OWNED BY public.purchase_order_line.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_id integer,
    report_header text,
    report_footer text,
    logo_web bytea,
    account_no character varying,
    email character varying,
    phone character varying,
    company_registry character varying,
    paperformat_id integer,
    external_report_layout_id integer,
    base_onboarding_company_state character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    partner_gid integer,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    resource_calendar_id integer,
    fiscalyear_last_day integer NOT NULL,
    fiscalyear_last_month character varying NOT NULL,
    period_lock_date date,
    fiscalyear_lock_date date,
    tax_lock_date date,
    transfer_account_id integer,
    expects_chart_of_accounts boolean,
    chart_template_id integer,
    bank_account_code_prefix character varying,
    cash_account_code_prefix character varying,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    transfer_account_code_prefix character varying,
    account_sale_tax_id integer,
    account_purchase_tax_id integer,
    tax_cash_basis_journal_id integer,
    tax_calculation_rounding_method character varying,
    currency_exchange_journal_id integer,
    anglo_saxon_accounting boolean,
    property_stock_account_input_categ_id integer,
    property_stock_account_output_categ_id integer,
    property_stock_valuation_account_id integer,
    tax_exigibility boolean,
    account_bank_reconciliation_start date,
    incoterm_id integer,
    qr_code boolean,
    invoice_is_email boolean,
    invoice_is_print boolean,
    account_opening_move_id integer,
    account_setup_bank_data_state character varying,
    account_setup_fy_data_state character varying,
    account_setup_coa_state character varying,
    account_onboarding_invoice_layout_state character varying,
    account_onboarding_sample_invoice_state character varying,
    account_onboarding_sale_tax_state character varying,
    account_invoice_onboarding_state character varying,
    account_dashboard_onboarding_state character varying,
    invoice_terms text,
    account_default_pos_receivable_account_id integer,
    expense_accrual_account_id integer,
    revenue_accrual_account_id integer,
    accrual_default_journal_id integer,
    payment_acquirer_onboarding_state character varying,
    payment_onboarding_payment_method character varying,
    invoice_is_snailmail boolean,
    vat_check_vies boolean,
    l10n_fr_closing_sequence_id integer,
    ape character varying,
    portal_confirmation_sign boolean,
    portal_confirmation_pay boolean,
    quotation_validity_days integer,
    sale_quotation_onboarding_state character varying,
    sale_onboarding_order_confirmation_state character varying,
    sale_onboarding_sample_quotation_state character varying,
    sale_onboarding_payment_method character varying,
    po_lead double precision NOT NULL,
    po_lock character varying,
    po_double_validation character varying,
    po_double_validation_amount numeric,
    CONSTRAINT res_company_check_quotation_validity_days CHECK ((quotation_validity_days > 0))
);


--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.account_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_no IS 'Account No.';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.company_registry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.company_registry IS 'Company Registry';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.base_onboarding_company_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.base_onboarding_company_state IS 'State of the onboarding company step';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.partner_gid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.partner_gid IS 'Company database ID';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.fiscalyear_last_day; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_day IS 'Fiscalyear Last Day';


--
-- Name: COLUMN res_company.fiscalyear_last_month; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_month IS 'Fiscalyear Last Month';


--
-- Name: COLUMN res_company.period_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.period_lock_date IS 'Lock Date for Non-Advisers';


--
-- Name: COLUMN res_company.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.fiscalyear_lock_date IS 'Lock Date';


--
-- Name: COLUMN res_company.tax_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.tax_lock_date IS 'Tax Lock Date';


--
-- Name: COLUMN res_company.transfer_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.transfer_account_id IS 'Inter-Banks Transfer Account';


--
-- Name: COLUMN res_company.expects_chart_of_accounts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.expects_chart_of_accounts IS 'Expects a Chart of Accounts';


--
-- Name: COLUMN res_company.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN res_company.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN res_company.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.cash_account_code_prefix IS 'Prefix of the cash accounts';


--
-- Name: COLUMN res_company.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.default_cash_difference_income_account_id IS 'Cash Difference Income Account';


--
-- Name: COLUMN res_company.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.default_cash_difference_expense_account_id IS 'Cash Difference Expense Account';


--
-- Name: COLUMN res_company.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.transfer_account_code_prefix IS 'Prefix of the transfer accounts';


--
-- Name: COLUMN res_company.account_sale_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_sale_tax_id IS 'Default Sale Tax';


--
-- Name: COLUMN res_company.account_purchase_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_purchase_tax_id IS 'Default Purchase Tax';


--
-- Name: COLUMN res_company.tax_cash_basis_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.tax_cash_basis_journal_id IS 'Cash Basis Journal';


--
-- Name: COLUMN res_company.tax_calculation_rounding_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.tax_calculation_rounding_method IS 'Tax Calculation Rounding Method';


--
-- Name: COLUMN res_company.currency_exchange_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.currency_exchange_journal_id IS 'Exchange Gain or Loss Journal';


--
-- Name: COLUMN res_company.anglo_saxon_accounting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.anglo_saxon_accounting IS 'Use anglo-saxon accounting';


--
-- Name: COLUMN res_company.property_stock_account_input_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.property_stock_account_input_categ_id IS 'Input Account for Stock Valuation';


--
-- Name: COLUMN res_company.property_stock_account_output_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.property_stock_account_output_categ_id IS 'Output Account for Stock Valuation';


--
-- Name: COLUMN res_company.property_stock_valuation_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.property_stock_valuation_account_id IS 'Account Template for Stock Valuation';


--
-- Name: COLUMN res_company.tax_exigibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.tax_exigibility IS 'Use Cash Basis';


--
-- Name: COLUMN res_company.account_bank_reconciliation_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_bank_reconciliation_start IS 'Bank Reconciliation Threshold';


--
-- Name: COLUMN res_company.incoterm_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.incoterm_id IS 'Default incoterm';


--
-- Name: COLUMN res_company.qr_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.qr_code IS 'Display SEPA QR code';


--
-- Name: COLUMN res_company.invoice_is_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.invoice_is_email IS 'Email by default';


--
-- Name: COLUMN res_company.invoice_is_print; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.invoice_is_print IS 'Print by default';


--
-- Name: COLUMN res_company.account_opening_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_opening_move_id IS 'Opening Journal Entry';


--
-- Name: COLUMN res_company.account_setup_bank_data_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_setup_bank_data_state IS 'State of the onboarding bank data step';


--
-- Name: COLUMN res_company.account_setup_fy_data_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_setup_fy_data_state IS 'State of the onboarding fiscal year step';


--
-- Name: COLUMN res_company.account_setup_coa_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_setup_coa_state IS 'State of the onboarding charts of account step';


--
-- Name: COLUMN res_company.account_onboarding_invoice_layout_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_onboarding_invoice_layout_state IS 'State of the onboarding invoice layout step';


--
-- Name: COLUMN res_company.account_onboarding_sample_invoice_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_onboarding_sample_invoice_state IS 'State of the onboarding sample invoice step';


--
-- Name: COLUMN res_company.account_onboarding_sale_tax_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_onboarding_sale_tax_state IS 'State of the onboarding sale tax step';


--
-- Name: COLUMN res_company.account_invoice_onboarding_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_invoice_onboarding_state IS 'State of the account invoice onboarding panel';


--
-- Name: COLUMN res_company.account_dashboard_onboarding_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_dashboard_onboarding_state IS 'State of the account dashboard onboarding panel';


--
-- Name: COLUMN res_company.invoice_terms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.invoice_terms IS 'Default Terms and Conditions';


--
-- Name: COLUMN res_company.account_default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.account_default_pos_receivable_account_id IS 'Default PoS Receivable Account';


--
-- Name: COLUMN res_company.expense_accrual_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.expense_accrual_account_id IS 'Expense Accrual Account';


--
-- Name: COLUMN res_company.revenue_accrual_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.revenue_accrual_account_id IS 'Revenue Accrual Account';


--
-- Name: COLUMN res_company.accrual_default_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.accrual_default_journal_id IS 'Accrual Default Journal';


--
-- Name: COLUMN res_company.payment_acquirer_onboarding_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.payment_acquirer_onboarding_state IS 'State of the onboarding payment acquirer step';


--
-- Name: COLUMN res_company.payment_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.payment_onboarding_payment_method IS 'Selected onboarding payment method';


--
-- Name: COLUMN res_company.invoice_is_snailmail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.invoice_is_snailmail IS 'Send by Post';


--
-- Name: COLUMN res_company.vat_check_vies; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.vat_check_vies IS 'Verify VAT Numbers';


--
-- Name: COLUMN res_company.l10n_fr_closing_sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.l10n_fr_closing_sequence_id IS 'Sequence to use to build sale closings';


--
-- Name: COLUMN res_company.ape; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.ape IS 'APE';


--
-- Name: COLUMN res_company.portal_confirmation_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.portal_confirmation_sign IS 'Online Signature';


--
-- Name: COLUMN res_company.portal_confirmation_pay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.portal_confirmation_pay IS 'Online Payment';


--
-- Name: COLUMN res_company.quotation_validity_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.quotation_validity_days IS 'Default Quotation Validity (Days)';


--
-- Name: COLUMN res_company.sale_quotation_onboarding_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.sale_quotation_onboarding_state IS 'State of the sale onboarding panel';


--
-- Name: COLUMN res_company.sale_onboarding_order_confirmation_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.sale_onboarding_order_confirmation_state IS 'State of the onboarding confirmation order step';


--
-- Name: COLUMN res_company.sale_onboarding_sample_quotation_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.sale_onboarding_sample_quotation_state IS 'State of the onboarding sample quotation step';


--
-- Name: COLUMN res_company.sale_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.sale_onboarding_payment_method IS 'Sale onboarding selected payment method';


--
-- Name: COLUMN res_company.po_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.po_lead IS 'Purchase Lead Time';


--
-- Name: COLUMN res_company.po_lock; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.po_lock IS 'Purchase Order Modification';


--
-- Name: COLUMN res_company.po_double_validation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.po_double_validation IS 'Levels of Approvals';


--
-- Name: COLUMN res_company.po_double_validation_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.po_double_validation_amount IS 'Double validation amount';


--
-- Name: CONSTRAINT res_company_check_quotation_validity_days ON res_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_company_check_quotation_validity_days ON public.res_company IS 'CHECK(quotation_validity_days > 0)';


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    name date NOT NULL,
    rate numeric,
    currency_id integer,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    name character varying,
    company_id integer,
    create_date timestamp without time zone,
    display_name character varying,
    date date,
    title integer,
    parent_id integer,
    ref character varying,
    lang character varying,
    tz character varying,
    user_id integer,
    vat character varying,
    website character varying,
    comment text,
    credit_limit double precision,
    active boolean,
    employee boolean,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state_id integer,
    country_id integer,
    partner_latitude numeric,
    partner_longitude numeric,
    email character varying,
    phone character varying,
    mobile character varying,
    is_company boolean,
    industry_id integer,
    color integer,
    partner_share boolean,
    commercial_partner_id integer,
    commercial_company_name character varying,
    company_name character varying,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    email_normalized character varying,
    message_bounce integer,
    signup_token character varying,
    signup_type character varying,
    signup_expiration timestamp without time zone,
    partner_gid integer,
    additional_info character varying,
    phone_sanitized character varying,
    debit_limit numeric,
    last_time_entries_checked timestamp without time zone,
    invoice_warn character varying,
    invoice_warn_msg text,
    supplier_rank integer,
    customer_rank integer,
    siret character varying(14),
    team_id integer,
    sale_warn character varying,
    sale_warn_msg text,
    purchase_warn character varying,
    purchase_warn_msg text,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


--
-- Name: COLUMN res_partner.display_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.display_name IS 'Display Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.credit_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.credit_limit IS 'Credit Limit';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.signup_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.signup_token IS 'Signup Token';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.signup_expiration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.signup_expiration IS 'Signup Expiration';


--
-- Name: COLUMN res_partner.partner_gid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_gid IS 'Company database ID';


--
-- Name: COLUMN res_partner.additional_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.additional_info IS 'Additional info';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.debit_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.debit_limit IS 'Payable Limit';


--
-- Name: COLUMN res_partner.last_time_entries_checked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.last_time_entries_checked IS 'Latest Invoices & Payments Matching Date';


--
-- Name: COLUMN res_partner.invoice_warn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.invoice_warn IS 'Invoice';


--
-- Name: COLUMN res_partner.invoice_warn_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.invoice_warn_msg IS 'Message for Invoice';


--
-- Name: COLUMN res_partner.supplier_rank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.supplier_rank IS 'Supplier Rank';


--
-- Name: COLUMN res_partner.customer_rank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.customer_rank IS 'Customer Rank';


--
-- Name: COLUMN res_partner.siret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.siret IS 'SIRET';


--
-- Name: COLUMN res_partner.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.team_id IS 'Sales Team';


--
-- Name: COLUMN res_partner.sale_warn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.sale_warn IS 'Sales Warnings';


--
-- Name: COLUMN res_partner.sale_warn_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.sale_warn_msg IS 'Message for Sales Order';


--
-- Name: COLUMN res_partner.purchase_warn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.purchase_warn IS 'Purchase Order';


--
-- Name: COLUMN res_partner.purchase_warn_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.purchase_warn_msg IS 'Message for Purchase Order';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: uom_uom; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.uom_uom (
    id integer NOT NULL,
    name character varying NOT NULL,
    category_id integer NOT NULL,
    factor numeric NOT NULL,
    rounding numeric NOT NULL,
    active boolean,
    uom_type character varying NOT NULL,
    measure_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT uom_uom_factor_gt_zero CHECK ((factor <> (0)::numeric)),
    CONSTRAINT uom_uom_factor_reference_is_one CHECK (((((uom_type)::text = 'reference'::text) AND (factor = 1.0)) OR ((uom_type)::text <> 'reference'::text))),
    CONSTRAINT uom_uom_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


--
-- Name: TABLE uom_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.uom_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN uom_uom.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.name IS 'Unit of Measure';


--
-- Name: COLUMN uom_uom.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.category_id IS 'Category';


--
-- Name: COLUMN uom_uom.factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.factor IS 'Ratio';


--
-- Name: COLUMN uom_uom.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.rounding IS 'Rounding Precision';


--
-- Name: COLUMN uom_uom.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.active IS 'Active';


--
-- Name: COLUMN uom_uom.uom_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.uom_type IS 'Type';


--
-- Name: COLUMN uom_uom.measure_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.measure_type IS 'Type of measurement category';


--
-- Name: COLUMN uom_uom.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.create_uid IS 'Created by';


--
-- Name: COLUMN uom_uom.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.create_date IS 'Created on';


--
-- Name: COLUMN uom_uom.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_uom.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_uom.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT uom_uom_factor_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT uom_uom_factor_gt_zero ON public.uom_uom IS 'CHECK (factor!=0)';


--
-- Name: CONSTRAINT uom_uom_factor_reference_is_one ON uom_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT uom_uom_factor_reference_is_one ON public.uom_uom IS 'CHECK((uom_type = ''reference'' AND factor = 1.0) OR (uom_type != ''reference''))';


--
-- Name: CONSTRAINT uom_uom_rounding_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT uom_uom_rounding_gt_zero ON public.uom_uom IS 'CHECK (rounding>0)';


--
-- Name: purchase_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.purchase_report AS
 WITH currency_rate AS (
         SELECT r.currency_id,
            COALESCE(r.company_id, c.id) AS company_id,
            r.rate,
            r.name AS date_start,
            ( SELECT r2.name
                   FROM public.res_currency_rate r2
                  WHERE ((r2.name > r.name) AND (r2.currency_id = r.currency_id) AND ((r2.company_id IS NULL) OR (r2.company_id = c.id)))
                  ORDER BY r2.name
                 LIMIT 1) AS date_end
           FROM (public.res_currency_rate r
             JOIN public.res_company c ON (((r.company_id IS NULL) OR (r.company_id = c.id))))
        )
 SELECT po.id AS order_id,
    min(l.id) AS id,
    po.date_order,
    po.state,
    po.date_approve,
    po.dest_address_id,
    po.partner_id,
    po.user_id,
    po.company_id,
    po.fiscal_position_id,
    l.product_id,
    p.product_tmpl_id,
    t.categ_id AS category_id,
    po.currency_id,
    t.uom_id AS product_uom,
    (date_part('epoch'::text, age(po.date_approve, po.date_order)) / ((((24 * 60) * 60))::numeric(16,2))::double precision) AS delay,
    (date_part('epoch'::text, age(l.date_planned, po.date_order)) / ((((24 * 60) * 60))::numeric(16,2))::double precision) AS delay_pass,
    count(*) AS nbr_lines,
    (sum(((l.price_total)::double precision / COALESCE(po.currency_rate, (1.0)::double precision))))::numeric(16,2) AS price_total,
    ((sum((((l.product_qty * l.price_unit))::double precision / COALESCE(po.currency_rate, (1.0)::double precision))) / (NULLIF(sum(((l.product_qty / line_uom.factor) * product_uom.factor)), 0.0))::double precision))::numeric(16,2) AS price_average,
    partner.country_id,
    partner.commercial_partner_id,
    analytic_account.id AS account_analytic_id,
    sum((((p.weight * l.product_qty) / line_uom.factor) * product_uom.factor)) AS weight,
    sum((((p.volume * l.product_qty) / line_uom.factor) * product_uom.factor)) AS volume,
    (sum(((l.price_subtotal)::double precision / COALESCE(po.currency_rate, (1.0)::double precision))))::numeric(16,2) AS untaxed_total,
    sum(((l.product_qty / line_uom.factor) * product_uom.factor)) AS qty_ordered,
    sum(((l.qty_received / line_uom.factor) * product_uom.factor)) AS qty_received,
    sum(((l.qty_invoiced / line_uom.factor) * product_uom.factor)) AS qty_billed,
        CASE
            WHEN ((t.purchase_method)::text = 'purchase'::text) THEN (sum(((l.product_qty / line_uom.factor) * product_uom.factor)) - sum(((l.qty_invoiced / line_uom.factor) * product_uom.factor)))
            ELSE (sum(((l.qty_received / line_uom.factor) * product_uom.factor)) - sum(((l.qty_invoiced / line_uom.factor) * product_uom.factor)))
        END AS qty_to_be_billed
   FROM ((((((((public.purchase_order_line l
     JOIN public.purchase_order po ON ((l.order_id = po.id)))
     JOIN public.res_partner partner ON ((po.partner_id = partner.id)))
     LEFT JOIN public.product_product p ON ((l.product_id = p.id)))
     LEFT JOIN public.product_template t ON ((p.product_tmpl_id = t.id)))
     LEFT JOIN public.uom_uom line_uom ON ((line_uom.id = l.product_uom)))
     LEFT JOIN public.uom_uom product_uom ON ((product_uom.id = t.uom_id)))
     LEFT JOIN public.account_analytic_account analytic_account ON ((l.account_analytic_id = analytic_account.id)))
     LEFT JOIN currency_rate cr ON (((cr.currency_id = po.currency_id) AND (cr.company_id = po.company_id) AND (cr.date_start <= COALESCE((po.date_order)::timestamp with time zone, now())) AND ((cr.date_end IS NULL) OR (cr.date_end > COALESCE((po.date_order)::timestamp with time zone, now()))))))
  GROUP BY po.company_id, po.user_id, po.partner_id, line_uom.factor, po.currency_id, l.price_unit, po.date_approve, l.date_planned, l.product_uom, po.dest_address_id, po.fiscal_position_id, l.product_id, p.product_tmpl_id, t.categ_id, po.date_order, po.state, line_uom.uom_type, line_uom.category_id, t.uom_id, t.purchase_method, line_uom.id, product_uom.factor, partner.country_id, partner.commercial_partner_id, analytic_account.id, po.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: sale_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order (
    id integer NOT NULL,
    access_token character varying,
    message_main_attachment_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    name character varying NOT NULL,
    origin character varying,
    client_order_ref character varying,
    reference character varying,
    state character varying,
    date_order timestamp without time zone NOT NULL,
    validity_date date,
    require_signature boolean,
    require_payment boolean,
    create_date timestamp without time zone,
    user_id integer,
    partner_id integer NOT NULL,
    partner_invoice_id integer NOT NULL,
    partner_shipping_id integer NOT NULL,
    pricelist_id integer NOT NULL,
    analytic_account_id integer,
    invoice_status character varying,
    note text,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    currency_rate numeric,
    payment_term_id integer,
    fiscal_position_id integer,
    company_id integer NOT NULL,
    team_id integer,
    signed_by character varying,
    signed_on timestamp without time zone,
    commitment_date timestamp without time zone,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    sale_order_template_id integer,
    CONSTRAINT sale_order_date_order_conditional_required CHECK (((((state)::text = ANY ((ARRAY['sale'::character varying, 'done'::character varying])::text[])) AND (date_order IS NOT NULL)) OR ((state)::text <> ALL ((ARRAY['sale'::character varying, 'done'::character varying])::text[]))))
);


--
-- Name: TABLE sale_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order IS 'Sales Order';


--
-- Name: COLUMN sale_order.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.access_token IS 'Security Token';


--
-- Name: COLUMN sale_order.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN sale_order.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.campaign_id IS 'Campaign';


--
-- Name: COLUMN sale_order.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.source_id IS 'Source';


--
-- Name: COLUMN sale_order.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.medium_id IS 'Medium';


--
-- Name: COLUMN sale_order.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.name IS 'Order Reference';


--
-- Name: COLUMN sale_order.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.origin IS 'Source Document';


--
-- Name: COLUMN sale_order.client_order_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.client_order_ref IS 'Customer Reference';


--
-- Name: COLUMN sale_order.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.reference IS 'Payment Ref.';


--
-- Name: COLUMN sale_order.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.state IS 'Status';


--
-- Name: COLUMN sale_order.date_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.date_order IS 'Order Date';


--
-- Name: COLUMN sale_order.validity_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.validity_date IS 'Expiration';


--
-- Name: COLUMN sale_order.require_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.require_signature IS 'Online Signature';


--
-- Name: COLUMN sale_order.require_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.require_payment IS 'Online Payment';


--
-- Name: COLUMN sale_order.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.create_date IS 'Creation Date';


--
-- Name: COLUMN sale_order.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.user_id IS 'Salesperson';


--
-- Name: COLUMN sale_order.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_id IS 'Customer';


--
-- Name: COLUMN sale_order.partner_invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_invoice_id IS 'Invoice Address';


--
-- Name: COLUMN sale_order.partner_shipping_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN sale_order.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN sale_order.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN sale_order.invoice_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.invoice_status IS 'Invoice Status';


--
-- Name: COLUMN sale_order.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.note IS 'Terms and conditions';


--
-- Name: COLUMN sale_order.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN sale_order.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_tax IS 'Taxes';


--
-- Name: COLUMN sale_order.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_total IS 'Total';


--
-- Name: COLUMN sale_order.currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN sale_order.payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN sale_order.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN sale_order.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.company_id IS 'Company';


--
-- Name: COLUMN sale_order.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.team_id IS 'Sales Team';


--
-- Name: COLUMN sale_order.signed_by; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.signed_by IS 'Signed By';


--
-- Name: COLUMN sale_order.signed_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.signed_on IS 'Signed On';


--
-- Name: COLUMN sale_order.commitment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.commitment_date IS 'Delivery Date';


--
-- Name: COLUMN sale_order.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.write_date IS 'Last Updated on';


--
-- Name: COLUMN sale_order.sale_order_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.sale_order_template_id IS 'Quotation Template';


--
-- Name: CONSTRAINT sale_order_date_order_conditional_required ON sale_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_date_order_conditional_required ON public.sale_order IS 'CHECK( (state IN (''sale'', ''done'') AND date_order IS NOT NULL) OR state NOT IN (''sale'', ''done'') )';


--
-- Name: sale_order_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_line (
    id integer NOT NULL,
    order_id integer NOT NULL,
    name text NOT NULL,
    sequence integer,
    invoice_status character varying,
    price_unit numeric NOT NULL,
    price_subtotal numeric,
    price_tax double precision,
    price_total numeric,
    price_reduce numeric,
    price_reduce_taxinc numeric,
    price_reduce_taxexcl numeric,
    discount numeric,
    product_id integer,
    product_uom_qty numeric NOT NULL,
    product_uom integer,
    qty_delivered_method character varying,
    qty_delivered numeric,
    qty_delivered_manual numeric,
    qty_to_invoice numeric,
    qty_invoiced numeric,
    untaxed_amount_invoiced numeric,
    untaxed_amount_to_invoice numeric,
    salesman_id integer,
    currency_id integer,
    company_id integer,
    order_partner_id integer,
    is_expense boolean,
    is_downpayment boolean,
    state character varying,
    customer_lead double precision NOT NULL,
    display_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT sale_order_line_accountable_required_fields CHECK (((display_type IS NOT NULL) OR ((product_id IS NOT NULL) AND (product_uom IS NOT NULL)))),
    CONSTRAINT sale_order_line_non_accountable_null_fields CHECK (((display_type IS NULL) OR ((product_id IS NULL) AND (price_unit = (0)::numeric) AND (product_uom_qty = (0)::numeric) AND (product_uom IS NULL) AND (customer_lead = (0)::double precision))))
);


--
-- Name: TABLE sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_line IS 'Sales Order Line';


--
-- Name: COLUMN sale_order_line.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.order_id IS 'Order Reference';


--
-- Name: COLUMN sale_order_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.name IS 'Description';


--
-- Name: COLUMN sale_order_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.sequence IS 'Sequence';


--
-- Name: COLUMN sale_order_line.invoice_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.invoice_status IS 'Invoice Status';


--
-- Name: COLUMN sale_order_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN sale_order_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN sale_order_line.price_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_tax IS 'Total Tax';


--
-- Name: COLUMN sale_order_line.price_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_total IS 'Total';


--
-- Name: COLUMN sale_order_line.price_reduce; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_reduce IS 'Price Reduce';


--
-- Name: COLUMN sale_order_line.price_reduce_taxinc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_reduce_taxinc IS 'Price Reduce Tax inc';


--
-- Name: COLUMN sale_order_line.price_reduce_taxexcl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_reduce_taxexcl IS 'Price Reduce Tax excl';


--
-- Name: COLUMN sale_order_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.discount IS 'Discount (%)';


--
-- Name: COLUMN sale_order_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_id IS 'Product';


--
-- Name: COLUMN sale_order_line.product_uom_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_uom_qty IS 'Quantity';


--
-- Name: COLUMN sale_order_line.product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_uom IS 'Unit of Measure';


--
-- Name: COLUMN sale_order_line.qty_delivered_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_delivered_method IS 'Method to update delivered qty';


--
-- Name: COLUMN sale_order_line.qty_delivered; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_delivered IS 'Delivered Quantity';


--
-- Name: COLUMN sale_order_line.qty_delivered_manual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_delivered_manual IS 'Delivered Manually';


--
-- Name: COLUMN sale_order_line.qty_to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_to_invoice IS 'To Invoice Quantity';


--
-- Name: COLUMN sale_order_line.qty_invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_invoiced IS 'Invoiced Quantity';


--
-- Name: COLUMN sale_order_line.untaxed_amount_invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.untaxed_amount_invoiced IS 'Untaxed Invoiced Amount';


--
-- Name: COLUMN sale_order_line.untaxed_amount_to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.untaxed_amount_to_invoice IS 'Untaxed Amount To Invoice';


--
-- Name: COLUMN sale_order_line.salesman_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.salesman_id IS 'Salesperson';


--
-- Name: COLUMN sale_order_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.currency_id IS 'Currency';


--
-- Name: COLUMN sale_order_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.company_id IS 'Company';


--
-- Name: COLUMN sale_order_line.order_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.order_partner_id IS 'Customer';


--
-- Name: COLUMN sale_order_line.is_expense; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.is_expense IS 'Is expense';


--
-- Name: COLUMN sale_order_line.is_downpayment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.is_downpayment IS 'Is a down payment';


--
-- Name: COLUMN sale_order_line.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.state IS 'Order Status';


--
-- Name: COLUMN sale_order_line.customer_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.customer_lead IS 'Lead Time';


--
-- Name: COLUMN sale_order_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.display_type IS 'Display Type';


--
-- Name: COLUMN sale_order_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT sale_order_line_accountable_required_fields ON sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_line_accountable_required_fields ON public.sale_order_line IS 'CHECK(display_type IS NOT NULL OR (product_id IS NOT NULL AND product_uom IS NOT NULL))';


--
-- Name: CONSTRAINT sale_order_line_non_accountable_null_fields ON sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_line_non_accountable_null_fields ON public.sale_order_line IS 'CHECK(display_type IS NULL OR (product_id IS NULL AND price_unit = 0 AND product_uom_qty = 0 AND product_uom IS NULL AND customer_lead = 0))';


--
-- Name: report_all_channels_sales; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.report_all_channels_sales AS
 SELECT foo.id,
    foo.name,
    foo.partner_id,
    foo.product_id,
    foo.product_tmpl_id,
    foo.date_order,
    foo.user_id,
    foo.categ_id,
    foo.company_id,
    foo.price_total,
    foo.pricelist_id,
    foo.analytic_account_id,
    foo.country_id,
    foo.team_id,
    foo.price_subtotal,
    foo.product_qty
   FROM ( SELECT sol.id,
            so.name,
            so.partner_id,
            sol.product_id,
            pro.product_tmpl_id,
            so.date_order,
            so.user_id,
            pt.categ_id,
            so.company_id,
            (sol.price_total /
                CASE COALESCE(so.currency_rate, (0)::numeric)
                    WHEN 0 THEN 1.0
                    ELSE so.currency_rate
                END) AS price_total,
            so.pricelist_id,
            rp.country_id,
            (sol.price_subtotal /
                CASE COALESCE(so.currency_rate, (0)::numeric)
                    WHEN 0 THEN 1.0
                    ELSE so.currency_rate
                END) AS price_subtotal,
            ((sol.product_uom_qty / u.factor) * u2.factor) AS product_qty,
            so.analytic_account_id,
            so.team_id
           FROM (((((((public.sale_order_line sol
             JOIN public.sale_order so ON ((sol.order_id = so.id)))
             LEFT JOIN public.product_product pro ON ((sol.product_id = pro.id)))
             JOIN public.res_partner rp ON ((so.partner_id = rp.id)))
             LEFT JOIN public.product_template pt ON ((pro.product_tmpl_id = pt.id)))
             LEFT JOIN public.product_pricelist pp ON ((so.pricelist_id = pp.id)))
             LEFT JOIN public.uom_uom u ON ((u.id = sol.product_uom)))
             LEFT JOIN public.uom_uom u2 ON ((u2.id = pt.uom_id)))
          WHERE ((so.state)::text = ANY ((ARRAY['sale'::character varying, 'done'::character varying])::text[]))) foo;


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    image character varying,
    pdf character varying,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    name character varying NOT NULL,
    "default" boolean,
    format character varying,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision,
    page_height integer,
    page_width integer,
    orientation character varying,
    header_line boolean,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format ?';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state integer,
    country integer,
    email character varying,
    phone character varying,
    active boolean,
    bic character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    company_id integer NOT NULL,
    user_default_rights boolean,
    external_email_server_default boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_google_drive boolean,
    module_google_spreadsheet boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_base_gengo boolean,
    module_inter_company_rules boolean,
    module_pad boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    group_multi_currency boolean,
    show_effect boolean,
    fail_counter integer,
    alias_domain character varying,
    unsplash_access_key character varying,
    auth_signup_reset_password boolean,
    auth_signup_uninvited character varying,
    auth_signup_template_user_id integer,
    group_discount_per_so_line boolean,
    group_uom boolean,
    group_product_variant boolean,
    module_sale_product_configurator boolean,
    module_sale_product_matrix boolean,
    group_stock_packaging boolean,
    group_product_pricelist boolean,
    group_sale_pricelist boolean,
    product_pricelist_setting character varying,
    product_weight_in_lbs character varying,
    product_volume_volume_in_cubic_feet character varying,
    digest_emails boolean,
    digest_id integer,
    chart_template_id integer,
    module_account_accountant boolean,
    group_analytic_accounting boolean,
    group_analytic_tags boolean,
    group_warning_account boolean,
    group_cash_rounding boolean,
    group_fiscal_year boolean,
    group_show_line_subtotals_tax_excluded boolean,
    group_show_line_subtotals_tax_included boolean,
    show_line_subtotals_tax_selection character varying NOT NULL,
    module_account_budget boolean,
    module_account_payment boolean,
    module_account_reports boolean,
    module_account_check_printing boolean,
    module_account_batch_payment boolean,
    module_account_sepa boolean,
    module_account_sepa_direct_debit boolean,
    module_account_plaid boolean,
    module_account_yodlee boolean,
    module_account_bank_statement_import_qif boolean,
    module_account_bank_statement_import_ofx boolean,
    module_account_bank_statement_import_csv boolean,
    module_account_bank_statement_import_camt boolean,
    module_currency_rate_live boolean,
    module_account_intrastat boolean,
    module_product_margin boolean,
    module_l10n_eu_service boolean,
    module_account_taxcloud boolean,
    module_account_invoice_extract boolean,
    module_snailmail_account boolean,
    use_invoice_terms boolean,
    group_auto_done_setting boolean,
    module_sale_margin boolean,
    use_quotation_validity_days boolean,
    group_warning_sale boolean,
    group_sale_delivery_address boolean,
    group_proforma_sales boolean,
    default_invoice_policy character varying,
    deposit_default_product_id integer,
    module_website_sale_digital boolean,
    module_delivery boolean,
    module_delivery_dhl boolean,
    module_delivery_fedex boolean,
    module_delivery_ups boolean,
    module_delivery_usps boolean,
    module_delivery_bpost boolean,
    module_delivery_easypost boolean,
    module_product_email_template boolean,
    module_sale_coupon boolean,
    module_sale_amazon boolean,
    automatic_invoice boolean,
    template_id integer,
    confirmation_template_id integer,
    group_sale_order_template boolean,
    default_sale_order_template_id integer,
    module_sale_quotation_builder boolean,
    lock_confirmed_po boolean,
    po_order_approval boolean,
    default_purchase_method character varying,
    group_warning_purchase boolean,
    module_account_3way_match boolean,
    module_purchase_requisition boolean,
    module_purchase_product_matrix boolean,
    use_po_lead boolean
);


--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'External Email Servers';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_google_drive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_google_drive IS 'Attach Google documents to any record';


--
-- Name: COLUMN res_config_settings.module_google_spreadsheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_google_spreadsheet IS 'Google Spreadsheet';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_base_gengo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_base_gengo IS 'Translate Your Website with Gengo';


--
-- Name: COLUMN res_config_settings.module_inter_company_rules; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_pad; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_pad IS 'Collaborative Pads';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Asterisk (VoIP)';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.fail_counter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.fail_counter IS 'Fail Mail';


--
-- Name: COLUMN res_config_settings.alias_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.alias_domain IS 'Alias Domain';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.group_discount_per_so_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_discount_per_so_line IS 'Discounts';


--
-- Name: COLUMN res_config_settings.group_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_uom IS 'Units of Measure';


--
-- Name: COLUMN res_config_settings.group_product_variant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_product_variant IS 'Variants';


--
-- Name: COLUMN res_config_settings.module_sale_product_configurator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_product_configurator IS 'Product Configurator';


--
-- Name: COLUMN res_config_settings.module_sale_product_matrix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_product_matrix IS 'Sales Grid Entry';


--
-- Name: COLUMN res_config_settings.group_stock_packaging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_stock_packaging IS 'Product Packagings';


--
-- Name: COLUMN res_config_settings.group_product_pricelist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_product_pricelist IS 'Pricelists';


--
-- Name: COLUMN res_config_settings.group_sale_pricelist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_sale_pricelist IS 'Advanced Pricelists';


--
-- Name: COLUMN res_config_settings.product_pricelist_setting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.product_pricelist_setting IS 'Pricelists Method';


--
-- Name: COLUMN res_config_settings.product_weight_in_lbs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.product_weight_in_lbs IS 'Weight unit of measure';


--
-- Name: COLUMN res_config_settings.product_volume_volume_in_cubic_feet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.product_volume_volume_in_cubic_feet IS 'Volume unit of measure';


--
-- Name: COLUMN res_config_settings.digest_emails; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.digest_emails IS 'Digest Emails';


--
-- Name: COLUMN res_config_settings.digest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.digest_id IS 'Digest Email';


--
-- Name: COLUMN res_config_settings.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.chart_template_id IS 'Template';


--
-- Name: COLUMN res_config_settings.module_account_accountant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_accountant IS 'Accounting';


--
-- Name: COLUMN res_config_settings.group_analytic_accounting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_analytic_accounting IS 'Analytic Accounting';


--
-- Name: COLUMN res_config_settings.group_analytic_tags; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_analytic_tags IS 'Analytic Tags';


--
-- Name: COLUMN res_config_settings.group_warning_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_warning_account IS 'Warnings in Invoices';


--
-- Name: COLUMN res_config_settings.group_cash_rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_cash_rounding IS 'Cash Rounding';


--
-- Name: COLUMN res_config_settings.group_fiscal_year; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_fiscal_year IS 'Fiscal Years';


--
-- Name: COLUMN res_config_settings.group_show_line_subtotals_tax_excluded; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_show_line_subtotals_tax_excluded IS 'Show line subtotals without taxes (B2B)';


--
-- Name: COLUMN res_config_settings.group_show_line_subtotals_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_show_line_subtotals_tax_included IS 'Show line subtotals with taxes (B2C)';


--
-- Name: COLUMN res_config_settings.show_line_subtotals_tax_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.show_line_subtotals_tax_selection IS 'Line Subtotals Tax Display';


--
-- Name: COLUMN res_config_settings.module_account_budget; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_budget IS 'Budget Management';


--
-- Name: COLUMN res_config_settings.module_account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_payment IS 'Invoice Online Payment';


--
-- Name: COLUMN res_config_settings.module_account_reports; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_reports IS 'Dynamic Reports';


--
-- Name: COLUMN res_config_settings.module_account_check_printing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_check_printing IS 'Allow check printing and deposits';


--
-- Name: COLUMN res_config_settings.module_account_batch_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_batch_payment IS 'Use batch payments';


--
-- Name: COLUMN res_config_settings.module_account_sepa; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_sepa IS 'SEPA Credit Transfer (SCT)';


--
-- Name: COLUMN res_config_settings.module_account_sepa_direct_debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_sepa_direct_debit IS 'Use SEPA Direct Debit';


--
-- Name: COLUMN res_config_settings.module_account_plaid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_plaid IS 'Plaid Connector';


--
-- Name: COLUMN res_config_settings.module_account_yodlee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_yodlee IS 'Bank Interface - Sync your bank feeds automatically';


--
-- Name: COLUMN res_config_settings.module_account_bank_statement_import_qif; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_bank_statement_import_qif IS 'Import .qif files';


--
-- Name: COLUMN res_config_settings.module_account_bank_statement_import_ofx; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_bank_statement_import_ofx IS 'Import in .ofx format';


--
-- Name: COLUMN res_config_settings.module_account_bank_statement_import_csv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_bank_statement_import_csv IS 'Import in .csv format';


--
-- Name: COLUMN res_config_settings.module_account_bank_statement_import_camt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_bank_statement_import_camt IS 'Import in CAMT.053 format';


--
-- Name: COLUMN res_config_settings.module_currency_rate_live; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_currency_rate_live IS 'Automatic Currency Rates';


--
-- Name: COLUMN res_config_settings.module_account_intrastat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_intrastat IS 'Intrastat';


--
-- Name: COLUMN res_config_settings.module_product_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_product_margin IS 'Allow Product Margin';


--
-- Name: COLUMN res_config_settings.module_l10n_eu_service; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_l10n_eu_service IS 'EU Digital Goods VAT';


--
-- Name: COLUMN res_config_settings.module_account_taxcloud; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_taxcloud IS 'Account TaxCloud';


--
-- Name: COLUMN res_config_settings.module_account_invoice_extract; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_invoice_extract IS 'Bill Digitalization';


--
-- Name: COLUMN res_config_settings.module_snailmail_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_snailmail_account IS 'Snailmail';


--
-- Name: COLUMN res_config_settings.use_invoice_terms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.use_invoice_terms IS 'Default Terms & Conditions';


--
-- Name: COLUMN res_config_settings.group_auto_done_setting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_auto_done_setting IS 'Lock Confirmed Sales';


--
-- Name: COLUMN res_config_settings.module_sale_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_margin IS 'Margins';


--
-- Name: COLUMN res_config_settings.use_quotation_validity_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.use_quotation_validity_days IS 'Default Quotation Validity';


--
-- Name: COLUMN res_config_settings.group_warning_sale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_warning_sale IS 'Sale Order Warnings';


--
-- Name: COLUMN res_config_settings.group_sale_delivery_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_sale_delivery_address IS 'Customer Addresses';


--
-- Name: COLUMN res_config_settings.group_proforma_sales; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_proforma_sales IS 'Pro-Forma Invoice';


--
-- Name: COLUMN res_config_settings.default_invoice_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.default_invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN res_config_settings.deposit_default_product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.deposit_default_product_id IS 'Deposit Product';


--
-- Name: COLUMN res_config_settings.module_website_sale_digital; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_website_sale_digital IS 'Digital Content';


--
-- Name: COLUMN res_config_settings.module_delivery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery IS 'Shipping Costs';


--
-- Name: COLUMN res_config_settings.module_delivery_dhl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_dhl IS 'DHL Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_fedex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_fedex IS 'FedEx Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_ups; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_ups IS 'UPS Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_usps; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_usps IS 'USPS Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_bpost; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_bpost IS 'bpost Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_easypost; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_easypost IS 'Easypost Connector';


--
-- Name: COLUMN res_config_settings.module_product_email_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_product_email_template IS 'Specific Email';


--
-- Name: COLUMN res_config_settings.module_sale_coupon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_coupon IS 'Coupons & Promotions';


--
-- Name: COLUMN res_config_settings.module_sale_amazon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_amazon IS 'Amazon Sync';


--
-- Name: COLUMN res_config_settings.automatic_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.automatic_invoice IS 'Automatic Invoice';


--
-- Name: COLUMN res_config_settings.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.template_id IS 'Email Template';


--
-- Name: COLUMN res_config_settings.confirmation_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.confirmation_template_id IS 'Confirmation Email';


--
-- Name: COLUMN res_config_settings.group_sale_order_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_sale_order_template IS 'Quotation Templates';


--
-- Name: COLUMN res_config_settings.default_sale_order_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.default_sale_order_template_id IS 'Default Template';


--
-- Name: COLUMN res_config_settings.module_sale_quotation_builder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_sale_quotation_builder IS 'Quotation Builder';


--
-- Name: COLUMN res_config_settings.lock_confirmed_po; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.lock_confirmed_po IS 'Lock Confirmed Orders';


--
-- Name: COLUMN res_config_settings.po_order_approval; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.po_order_approval IS 'Purchase Order Approval';


--
-- Name: COLUMN res_config_settings.default_purchase_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.default_purchase_method IS 'Bill Control';


--
-- Name: COLUMN res_config_settings.group_warning_purchase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_warning_purchase IS 'Purchase Warnings';


--
-- Name: COLUMN res_config_settings.module_account_3way_match; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_3way_match IS '3-way matching: purchases, receptions and bills';


--
-- Name: COLUMN res_config_settings.module_purchase_requisition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_purchase_requisition IS 'Purchase Agreements';


--
-- Name: COLUMN res_config_settings.module_purchase_product_matrix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_purchase_product_matrix IS 'Purchase Grid Entry';


--
-- Name: COLUMN res_config_settings.use_po_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.use_po_lead IS 'Security Lead Time for Purchase';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(2),
    address_format text,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    name_position character varying,
    vat_label character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_group_pricelist_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_group_pricelist_rel (
    pricelist_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


--
-- Name: TABLE res_country_group_pricelist_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_group_pricelist_rel IS 'RELATION BETWEEN product_pricelist AND res_country_group';


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    rounding numeric,
    decimal_places integer,
    active boolean,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name character varying NOT NULL,
    comment text,
    category_id integer,
    color integer,
    share boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    active boolean,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_partner_autocomplete_sync; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_autocomplete_sync (
    id integer NOT NULL,
    partner_id integer,
    synched boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_autocomplete_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_autocomplete_sync IS 'Partner Autocomplete Sync';


--
-- Name: COLUMN res_partner_autocomplete_sync.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.partner_id IS 'Partner';


--
-- Name: COLUMN res_partner_autocomplete_sync.synched; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.synched IS 'Is synched';


--
-- Name: COLUMN res_partner_autocomplete_sync.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_autocomplete_sync.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_autocomplete_sync.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_autocomplete_sync.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_autocomplete_sync.write_date IS 'Last Updated on';


--
-- Name: res_partner_autocomplete_sync_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_autocomplete_sync_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_autocomplete_sync_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_autocomplete_sync_id_seq OWNED BY public.res_partner_autocomplete_sync.id;


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    parent_path character varying,
    name character varying NOT NULL,
    color integer,
    parent_id integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color Index';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    name character varying,
    full_name character varying,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_sms_composer_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_sms_composer_rel (
    sms_composer_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE res_partner_sms_composer_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_sms_composer_rel IS 'RELATION BETWEEN sms_composer AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    name character varying NOT NULL,
    shortcut character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    active boolean DEFAULT true,
    login character varying NOT NULL,
    password character varying,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_date timestamp without time zone,
    signature text,
    action_id integer,
    share boolean,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    alias_id integer,
    notification_type character varying NOT NULL,
    out_of_office_message character varying,
    chatter_position character varying,
    sidebar_visible boolean,
    sale_team_id integer
);


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.alias_id IS 'Alias';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.out_of_office_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.out_of_office_message IS 'Chat Status';


--
-- Name: COLUMN res_users.chatter_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.chatter_position IS 'Chatter Position';


--
-- Name: COLUMN res_users.sidebar_visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.sidebar_visible IS 'Show App Sidebar';


--
-- Name: COLUMN res_users.sale_team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.sale_team_id IS 'User''s Sales Team';


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    reset_mode character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    name character varying NOT NULL,
    company_id integer,
    hours_per_day double precision,
    tz character varying NOT NULL,
    two_weeks_calendar boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_calendar_attendance (
    id integer NOT NULL,
    name character varying NOT NULL,
    dayofweek character varying NOT NULL,
    date_from date,
    date_to date,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL,
    calendar_id integer NOT NULL,
    day_period character varying NOT NULL,
    resource_id integer,
    week_type character varying,
    display_type character varying,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.date_from IS 'Starting Date';


--
-- Name: COLUMN resource_calendar_attendance.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: COLUMN resource_calendar_attendance.day_period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.day_period IS 'Day Period';


--
-- Name: COLUMN resource_calendar_attendance.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_attendance.week_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.week_type IS 'Week Even/Odd';


--
-- Name: COLUMN resource_calendar_attendance.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.display_type IS 'Display Type';


--
-- Name: COLUMN resource_calendar_attendance.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.sequence IS 'Sequence';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.resource_calendar_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNED BY public.resource_calendar_attendance.id;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.resource_calendar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.resource_calendar_id_seq OWNED BY public.resource_calendar.id;


--
-- Name: resource_calendar_leaves; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_calendar_leaves (
    id integer NOT NULL,
    name character varying,
    company_id integer,
    calendar_id integer,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    resource_id integer,
    time_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE resource_calendar_leaves; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.resource_calendar_leaves IS 'Resource Time Off Detail';


--
-- Name: COLUMN resource_calendar_leaves.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.name IS 'Reason';


--
-- Name: COLUMN resource_calendar_leaves.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar_leaves.calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_calendar_leaves.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_from IS 'Start Date';


--
-- Name: COLUMN resource_calendar_leaves.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_leaves.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_leaves.time_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.time_type IS 'Time Type';


--
-- Name: COLUMN resource_calendar_leaves.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_leaves.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_leaves.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_leaves.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.resource_calendar_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNED BY public.resource_calendar_leaves.id;


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    company_id integer,
    resource_type character varying NOT NULL,
    user_id integer,
    time_efficiency double precision NOT NULL,
    calendar_id integer NOT NULL,
    tz character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Resource Type';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.resource_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource_resource.id;


--
-- Name: resource_test; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_test (
    id integer NOT NULL,
    name character varying,
    resource_id integer NOT NULL,
    company_id integer,
    resource_calendar_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE resource_test; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.resource_test IS 'Test Resource Model';


--
-- Name: COLUMN resource_test.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.name IS 'Name';


--
-- Name: COLUMN resource_test.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.resource_id IS 'Resource';


--
-- Name: COLUMN resource_test.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.company_id IS 'Company';


--
-- Name: COLUMN resource_test.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_test.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.create_uid IS 'Created by';


--
-- Name: COLUMN resource_test.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.create_date IS 'Created on';


--
-- Name: COLUMN resource_test.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_test.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.resource_test.write_date IS 'Last Updated on';


--
-- Name: resource_test_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.resource_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: resource_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.resource_test_id_seq OWNED BY public.resource_test.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: sale_advance_payment_inv; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_advance_payment_inv (
    id integer NOT NULL,
    advance_payment_method character varying NOT NULL,
    deduct_down_payments boolean,
    has_down_payments boolean,
    product_id integer,
    count integer,
    amount numeric,
    currency_id integer,
    fixed_amount numeric,
    deposit_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sale_advance_payment_inv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_advance_payment_inv IS 'Sales Advance Payment Invoice';


--
-- Name: COLUMN sale_advance_payment_inv.advance_payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.advance_payment_method IS 'Create Invoice';


--
-- Name: COLUMN sale_advance_payment_inv.deduct_down_payments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.deduct_down_payments IS 'Deduct down payments';


--
-- Name: COLUMN sale_advance_payment_inv.has_down_payments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.has_down_payments IS 'Has down payments';


--
-- Name: COLUMN sale_advance_payment_inv.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.product_id IS 'Down Payment Product';


--
-- Name: COLUMN sale_advance_payment_inv.count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.count IS 'Order Count';


--
-- Name: COLUMN sale_advance_payment_inv.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.amount IS 'Down Payment Amount';


--
-- Name: COLUMN sale_advance_payment_inv.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.currency_id IS 'Currency';


--
-- Name: COLUMN sale_advance_payment_inv.fixed_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.fixed_amount IS 'Down Payment Amount(Fixed)';


--
-- Name: COLUMN sale_advance_payment_inv.deposit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.deposit_account_id IS 'Income Account';


--
-- Name: COLUMN sale_advance_payment_inv.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.create_uid IS 'Created by';


--
-- Name: COLUMN sale_advance_payment_inv.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.create_date IS 'Created on';


--
-- Name: COLUMN sale_advance_payment_inv.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_advance_payment_inv.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_advance_payment_inv.write_date IS 'Last Updated on';


--
-- Name: sale_advance_payment_inv_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_advance_payment_inv_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_advance_payment_inv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_advance_payment_inv_id_seq OWNED BY public.sale_advance_payment_inv.id;


--
-- Name: sale_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_id_seq OWNED BY public.sale_order.id;


--
-- Name: sale_order_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_line_id_seq OWNED BY public.sale_order_line.id;


--
-- Name: sale_order_line_invoice_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_line_invoice_rel (
    invoice_line_id integer NOT NULL,
    order_line_id integer NOT NULL
);


--
-- Name: TABLE sale_order_line_invoice_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_line_invoice_rel IS 'RELATION BETWEEN account_move_line AND sale_order_line';


--
-- Name: sale_order_option; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_option (
    id integer NOT NULL,
    order_id integer,
    line_id integer,
    name text NOT NULL,
    product_id integer NOT NULL,
    price_unit numeric NOT NULL,
    discount numeric,
    uom_id integer NOT NULL,
    quantity numeric NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sale_order_option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_option IS 'Sale Options';


--
-- Name: COLUMN sale_order_option.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.order_id IS 'Sales Order Reference';


--
-- Name: COLUMN sale_order_option.line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.line_id IS 'Line';


--
-- Name: COLUMN sale_order_option.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.name IS 'Description';


--
-- Name: COLUMN sale_order_option.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.product_id IS 'Product';


--
-- Name: COLUMN sale_order_option.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.price_unit IS 'Unit Price';


--
-- Name: COLUMN sale_order_option.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.discount IS 'Discount (%)';


--
-- Name: COLUMN sale_order_option.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.uom_id IS 'Unit of Measure ';


--
-- Name: COLUMN sale_order_option.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.quantity IS 'Quantity';


--
-- Name: COLUMN sale_order_option.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.sequence IS 'Sequence';


--
-- Name: COLUMN sale_order_option.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_option.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_option.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_option.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_option.write_date IS 'Last Updated on';


--
-- Name: sale_order_option_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_option_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_option_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_option_id_seq OWNED BY public.sale_order_option.id;


--
-- Name: sale_order_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_template (
    id integer NOT NULL,
    name character varying NOT NULL,
    note text,
    number_of_days integer,
    require_signature boolean,
    require_payment boolean,
    mail_template_id integer,
    active boolean,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sale_order_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_template IS 'Quotation Template';


--
-- Name: COLUMN sale_order_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.name IS 'Quotation Template';


--
-- Name: COLUMN sale_order_template.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.note IS 'Terms and conditions';


--
-- Name: COLUMN sale_order_template.number_of_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.number_of_days IS 'Quotation Duration';


--
-- Name: COLUMN sale_order_template.require_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.require_signature IS 'Online Signature';


--
-- Name: COLUMN sale_order_template.require_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.require_payment IS 'Online Payment';


--
-- Name: COLUMN sale_order_template.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.mail_template_id IS 'Confirmation Mail';


--
-- Name: COLUMN sale_order_template.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.active IS 'Active';


--
-- Name: COLUMN sale_order_template.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.company_id IS 'Company';


--
-- Name: COLUMN sale_order_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template.write_date IS 'Last Updated on';


--
-- Name: sale_order_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_template_id_seq OWNED BY public.sale_order_template.id;


--
-- Name: sale_order_template_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_template_line (
    id integer NOT NULL,
    sequence integer,
    sale_order_template_id integer NOT NULL,
    company_id integer,
    name text NOT NULL,
    product_id integer,
    price_unit numeric NOT NULL,
    discount numeric,
    product_uom_qty numeric NOT NULL,
    product_uom_id integer,
    display_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT sale_order_template_line_accountable_product_id_required CHECK (((display_type IS NOT NULL) OR ((product_id IS NOT NULL) AND (product_uom_id IS NOT NULL)))),
    CONSTRAINT sale_order_template_line_non_accountable_fields_null CHECK (((display_type IS NULL) OR ((product_id IS NULL) AND (price_unit = (0)::numeric) AND (product_uom_qty = (0)::numeric) AND (product_uom_id IS NULL))))
);


--
-- Name: TABLE sale_order_template_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_template_line IS 'Quotation Template Line';


--
-- Name: COLUMN sale_order_template_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.sequence IS 'Sequence';


--
-- Name: COLUMN sale_order_template_line.sale_order_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.sale_order_template_id IS 'Quotation Template Reference';


--
-- Name: COLUMN sale_order_template_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.company_id IS 'Company';


--
-- Name: COLUMN sale_order_template_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.name IS 'Description';


--
-- Name: COLUMN sale_order_template_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.product_id IS 'Product';


--
-- Name: COLUMN sale_order_template_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN sale_order_template_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.discount IS 'Discount (%)';


--
-- Name: COLUMN sale_order_template_line.product_uom_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.product_uom_qty IS 'Quantity';


--
-- Name: COLUMN sale_order_template_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN sale_order_template_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.display_type IS 'Display Type';


--
-- Name: COLUMN sale_order_template_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_template_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_template_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_template_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT sale_order_template_line_accountable_product_id_required ON sale_order_template_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_template_line_accountable_product_id_required ON public.sale_order_template_line IS 'CHECK(display_type IS NOT NULL OR (product_id IS NOT NULL AND product_uom_id IS NOT NULL))';


--
-- Name: CONSTRAINT sale_order_template_line_non_accountable_fields_null ON sale_order_template_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_template_line_non_accountable_fields_null ON public.sale_order_template_line IS 'CHECK(display_type IS NULL OR (product_id IS NULL AND price_unit = 0 AND product_uom_qty = 0 AND product_uom_id IS NULL))';


--
-- Name: sale_order_template_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_template_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_template_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_template_line_id_seq OWNED BY public.sale_order_template_line.id;


--
-- Name: sale_order_template_option; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_template_option (
    id integer NOT NULL,
    sale_order_template_id integer NOT NULL,
    company_id integer,
    name text NOT NULL,
    product_id integer NOT NULL,
    price_unit numeric NOT NULL,
    discount numeric,
    uom_id integer NOT NULL,
    quantity numeric NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sale_order_template_option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_template_option IS 'Quotation Template Option';


--
-- Name: COLUMN sale_order_template_option.sale_order_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.sale_order_template_id IS 'Quotation Template Reference';


--
-- Name: COLUMN sale_order_template_option.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.company_id IS 'Company';


--
-- Name: COLUMN sale_order_template_option.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.name IS 'Description';


--
-- Name: COLUMN sale_order_template_option.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.product_id IS 'Product';


--
-- Name: COLUMN sale_order_template_option.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.price_unit IS 'Unit Price';


--
-- Name: COLUMN sale_order_template_option.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.discount IS 'Discount (%)';


--
-- Name: COLUMN sale_order_template_option.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.uom_id IS 'Unit of Measure ';


--
-- Name: COLUMN sale_order_template_option.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.quantity IS 'Quantity';


--
-- Name: COLUMN sale_order_template_option.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_template_option.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_template_option.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_template_option.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_template_option.write_date IS 'Last Updated on';


--
-- Name: sale_order_template_option_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_order_template_option_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_order_template_option_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_order_template_option_id_seq OWNED BY public.sale_order_template_option.id;


--
-- Name: sale_order_transaction_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_transaction_rel (
    sale_order_id integer NOT NULL,
    transaction_id integer NOT NULL
);


--
-- Name: TABLE sale_order_transaction_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_transaction_rel IS 'RELATION BETWEEN sale_order AND payment_transaction';


--
-- Name: sale_payment_acquirer_onboarding_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_payment_acquirer_onboarding_wizard (
    id integer NOT NULL,
    paypal_user_type character varying,
    paypal_email_account character varying,
    paypal_seller_account character varying,
    paypal_pdt_token character varying,
    stripe_secret_key character varying,
    stripe_publishable_key character varying,
    manual_name character varying,
    journal_name character varying,
    acc_number character varying,
    manual_post_msg text,
    payment_method character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sale_payment_acquirer_onboarding_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_payment_acquirer_onboarding_wizard IS 'Sale Payment acquire onboarding wizard';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.paypal_user_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.paypal_user_type IS 'Paypal User Type';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.paypal_email_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.paypal_email_account IS 'Email';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.paypal_seller_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.paypal_seller_account IS 'Merchant Account ID';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.paypal_pdt_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.paypal_pdt_token IS 'PDT Identity Token';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.stripe_secret_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.stripe_secret_key IS 'Stripe Secret Key';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.stripe_publishable_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.stripe_publishable_key IS 'Stripe Publishable Key';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.manual_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.manual_name IS 'Method';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.journal_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.journal_name IS 'Bank Name';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.acc_number IS 'Account Number';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.manual_post_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.manual_post_msg IS 'Payment Instructions';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.payment_method IS 'Payment Method';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.create_date IS 'Created on';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_payment_acquirer_onboarding_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_payment_acquirer_onboarding_wizard.write_date IS 'Last Updated on';


--
-- Name: sale_payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sale_payment_acquirer_onboarding_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sale_payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sale_payment_acquirer_onboarding_wizard_id_seq OWNED BY public.sale_payment_acquirer_onboarding_wizard.id;


--
-- Name: sale_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.sale_report AS
 SELECT min(l.id) AS id,
    l.product_id,
    t.uom_id AS product_uom,
    sum(((l.product_uom_qty / u.factor) * u2.factor)) AS product_uom_qty,
    sum(((l.qty_delivered / u.factor) * u2.factor)) AS qty_delivered,
    sum(((l.qty_invoiced / u.factor) * u2.factor)) AS qty_invoiced,
    sum(((l.qty_to_invoice / u.factor) * u2.factor)) AS qty_to_invoice,
    sum((l.price_total /
        CASE COALESCE(s.currency_rate, (0)::numeric)
            WHEN 0 THEN 1.0
            ELSE s.currency_rate
        END)) AS price_total,
    sum((l.price_subtotal /
        CASE COALESCE(s.currency_rate, (0)::numeric)
            WHEN 0 THEN 1.0
            ELSE s.currency_rate
        END)) AS price_subtotal,
    sum((l.untaxed_amount_to_invoice /
        CASE COALESCE(s.currency_rate, (0)::numeric)
            WHEN 0 THEN 1.0
            ELSE s.currency_rate
        END)) AS untaxed_amount_to_invoice,
    sum((l.untaxed_amount_invoiced /
        CASE COALESCE(s.currency_rate, (0)::numeric)
            WHEN 0 THEN 1.0
            ELSE s.currency_rate
        END)) AS untaxed_amount_invoiced,
    count(*) AS nbr,
    s.name,
    s.date_order AS date,
    s.state,
    s.partner_id,
    s.user_id,
    s.company_id,
    s.campaign_id,
    s.medium_id,
    s.source_id,
    (date_part('epoch'::text, avg((date_trunc('day'::text, s.date_order) - date_trunc('day'::text, s.create_date)))) / ((((24 * 60) * 60))::numeric(16,2))::double precision) AS delay,
    t.categ_id,
    s.pricelist_id,
    s.analytic_account_id,
    s.team_id,
    p.product_tmpl_id,
    partner.country_id,
    partner.industry_id,
    partner.commercial_partner_id,
    sum((((p.weight * l.product_uom_qty) / u.factor) * u2.factor)) AS weight,
    sum((((p.volume * l.product_uom_qty) / u.factor) * u2.factor)) AS volume,
    l.discount,
    sum(((((l.price_unit * l.product_uom_qty) * l.discount) / 100.0) /
        CASE COALESCE(s.currency_rate, (0)::numeric)
            WHEN 0 THEN 1.0
            ELSE s.currency_rate
        END)) AS discount_amount,
    s.id AS order_id
   FROM (((((((public.sale_order_line l
     JOIN public.sale_order s ON ((l.order_id = s.id)))
     JOIN public.res_partner partner ON ((s.partner_id = partner.id)))
     LEFT JOIN public.product_product p ON ((l.product_id = p.id)))
     LEFT JOIN public.product_template t ON ((p.product_tmpl_id = t.id)))
     LEFT JOIN public.uom_uom u ON ((u.id = l.product_uom)))
     LEFT JOIN public.uom_uom u2 ON ((u2.id = t.uom_id)))
     LEFT JOIN public.product_pricelist pp ON ((s.pricelist_id = pp.id)))
  WHERE (l.product_id IS NOT NULL)
  GROUP BY l.product_id, l.order_id, t.uom_id, t.categ_id, s.name, s.date_order, s.partner_id, s.user_id, s.state, s.company_id, s.campaign_id, s.medium_id, s.source_id, s.pricelist_id, s.analytic_account_id, s.team_id, p.product_tmpl_id, partner.country_id, partner.industry_id, partner.commercial_partner_id, l.discount, s.id;


--
-- Name: sms_cancel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_cancel (
    id integer NOT NULL,
    model character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_cancel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_cancel IS 'Dismiss notification for resend by model';


--
-- Name: COLUMN sms_cancel.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_cancel.model IS 'Model';


--
-- Name: COLUMN sms_cancel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_cancel.create_uid IS 'Created by';


--
-- Name: COLUMN sms_cancel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_cancel.create_date IS 'Created on';


--
-- Name: COLUMN sms_cancel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_cancel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_cancel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_cancel.write_date IS 'Last Updated on';


--
-- Name: sms_cancel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_cancel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_cancel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_cancel_id_seq OWNED BY public.sms_cancel.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_id integer,
    res_ids character varying,
    use_active_domain boolean,
    active_domain text,
    mass_keep_log boolean,
    mass_force_send boolean,
    mass_use_blacklist boolean,
    number_field_name character varying,
    numbers character varying,
    template_id integer,
    body text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.use_active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.use_active_domain IS 'Use active domain';


--
-- Name: COLUMN sms_composer.active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.active_domain IS 'Active domain';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.mass_use_blacklist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.mass_use_blacklist IS 'Use blacklist';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Field holding number';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_resend; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_resend (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_resend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_resend IS 'SMS Resend';


--
-- Name: COLUMN sms_resend.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend.mail_message_id IS 'Message';


--
-- Name: COLUMN sms_resend.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend.create_uid IS 'Created by';


--
-- Name: COLUMN sms_resend.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend.create_date IS 'Created on';


--
-- Name: COLUMN sms_resend.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_resend.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend.write_date IS 'Last Updated on';


--
-- Name: sms_resend_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_resend_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_resend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_resend_id_seq OWNED BY public.sms_resend.id;


--
-- Name: sms_resend_recipient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_resend_recipient (
    id integer NOT NULL,
    sms_resend_id integer NOT NULL,
    notification_id integer NOT NULL,
    resend boolean,
    partner_name character varying,
    sms_number character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_resend_recipient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_resend_recipient IS 'Resend Notification';


--
-- Name: COLUMN sms_resend_recipient.sms_resend_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.sms_resend_id IS 'Sms Resend';


--
-- Name: COLUMN sms_resend_recipient.notification_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.notification_id IS 'Notification';


--
-- Name: COLUMN sms_resend_recipient.resend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.resend IS 'Resend';


--
-- Name: COLUMN sms_resend_recipient.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.partner_name IS 'Recipient';


--
-- Name: COLUMN sms_resend_recipient.sms_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.sms_number IS 'Number';


--
-- Name: COLUMN sms_resend_recipient.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.create_uid IS 'Created by';


--
-- Name: COLUMN sms_resend_recipient.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.create_date IS 'Created on';


--
-- Name: COLUMN sms_resend_recipient.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_resend_recipient.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_resend_recipient.write_date IS 'Last Updated on';


--
-- Name: sms_resend_recipient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_resend_recipient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_resend_recipient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_resend_recipient_id_seq OWNED BY public.sms_resend_recipient.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    number character varying,
    body text,
    partner_id integer,
    mail_message_id integer,
    state character varying NOT NULL,
    error_code character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.error_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.error_code IS 'Error Code';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    name character varying,
    model_id integer NOT NULL,
    model character varying,
    body character varying NOT NULL,
    lang character varying,
    sidebar_action_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer,
    lang character varying,
    res_id integer,
    name character varying,
    model character varying,
    body character varying NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.res_id IS 'Record ID';


--
-- Name: COLUMN sms_template_preview.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.name IS 'Name';


--
-- Name: COLUMN sms_template_preview.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template_preview.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.body IS 'Body';


--
-- Name: COLUMN sms_template_preview.sidebar_action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    model character varying NOT NULL,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    color boolean,
    cover boolean,
    duplex boolean,
    state character varying NOT NULL,
    error_code character varying,
    info_msg character varying,
    message_id integer,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state_id integer,
    country_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_cancel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.snailmail_letter_cancel (
    id integer NOT NULL,
    model character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE snailmail_letter_cancel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.snailmail_letter_cancel IS 'Dismiss notification for resend by model';


--
-- Name: COLUMN snailmail_letter_cancel.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_cancel.model IS 'Model';


--
-- Name: COLUMN snailmail_letter_cancel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_cancel.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter_cancel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_cancel.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter_cancel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_cancel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter_cancel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_cancel.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_cancel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.snailmail_letter_cancel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: snailmail_letter_cancel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.snailmail_letter_cancel_id_seq OWNED BY public.snailmail_letter_cancel.id;


--
-- Name: snailmail_letter_format_error; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.snailmail_letter_format_error (
    id integer NOT NULL,
    message_id integer,
    snailmail_cover boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE snailmail_letter_format_error; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.snailmail_letter_format_error IS 'Format Error Sending a Snailmail Letter';


--
-- Name: COLUMN snailmail_letter_format_error.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.message_id IS 'Message';


--
-- Name: COLUMN snailmail_letter_format_error.snailmail_cover; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN snailmail_letter_format_error.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter_format_error.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter_format_error.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter_format_error.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_format_error.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_format_error_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.snailmail_letter_format_error_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: snailmail_letter_format_error_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.snailmail_letter_format_error_id_seq OWNED BY public.snailmail_letter_format_error.id;


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: snailmail_letter_missing_required_fields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.snailmail_letter_missing_required_fields (
    id integer NOT NULL,
    partner_id integer,
    letter_id integer,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state_id integer,
    country_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE snailmail_letter_missing_required_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.snailmail_letter_missing_required_fields IS 'Update address of partner';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.partner_id IS 'Partner';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.letter_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.letter_id IS 'Letter';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.street IS 'Street';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.city IS 'City';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_missing_required_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.snailmail_letter_missing_required_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: snailmail_letter_missing_required_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.snailmail_letter_missing_required_fields_id_seq OWNED BY public.snailmail_letter_missing_required_fields.id;


--
-- Name: tax_adjustments_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.tax_adjustments_wizard (
    id integer NOT NULL,
    reason character varying NOT NULL,
    journal_id integer NOT NULL,
    date date NOT NULL,
    debit_account_id integer NOT NULL,
    credit_account_id integer NOT NULL,
    amount numeric NOT NULL,
    adjustment_type character varying NOT NULL,
    tax_report_line_id integer NOT NULL,
    company_currency_id integer,
    country_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE tax_adjustments_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.tax_adjustments_wizard IS 'Tax Adjustments Wizard';


--
-- Name: COLUMN tax_adjustments_wizard.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.reason IS 'Justification';


--
-- Name: COLUMN tax_adjustments_wizard.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN tax_adjustments_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.date IS 'Date';


--
-- Name: COLUMN tax_adjustments_wizard.debit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.debit_account_id IS 'Debit account';


--
-- Name: COLUMN tax_adjustments_wizard.credit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.credit_account_id IS 'Credit account';


--
-- Name: COLUMN tax_adjustments_wizard.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.amount IS 'Amount';


--
-- Name: COLUMN tax_adjustments_wizard.adjustment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.adjustment_type IS 'Adjustment Type';


--
-- Name: COLUMN tax_adjustments_wizard.tax_report_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.tax_report_line_id IS 'Report Line';


--
-- Name: COLUMN tax_adjustments_wizard.company_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN tax_adjustments_wizard.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.country_id IS 'Country';


--
-- Name: COLUMN tax_adjustments_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN tax_adjustments_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.create_date IS 'Created on';


--
-- Name: COLUMN tax_adjustments_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN tax_adjustments_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.tax_adjustments_wizard.write_date IS 'Last Updated on';


--
-- Name: tax_adjustments_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.tax_adjustments_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tax_adjustments_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.tax_adjustments_wizard_id_seq OWNED BY public.tax_adjustments_wizard.id;


--
-- Name: team_favorite_user_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.team_favorite_user_rel (
    team_id integer NOT NULL,
    user_id integer NOT NULL
);


--
-- Name: TABLE team_favorite_user_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.team_favorite_user_rel IS 'RELATION BETWEEN crm_team AND res_users';


--
-- Name: uom_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.uom_category (
    id integer NOT NULL,
    name character varying NOT NULL,
    measure_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE uom_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.uom_category IS 'Product UoM Categories';


--
-- Name: COLUMN uom_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.name IS 'Unit of Measure Category';


--
-- Name: COLUMN uom_category.measure_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.measure_type IS 'Type of Measure';


--
-- Name: COLUMN uom_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.create_uid IS 'Created by';


--
-- Name: COLUMN uom_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.create_date IS 'Created on';


--
-- Name: COLUMN uom_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.uom_category.write_date IS 'Last Updated on';


--
-- Name: uom_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.uom_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: uom_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.uom_category_id_seq OWNED BY public.uom_category.id;


--
-- Name: uom_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.uom_uom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: uom_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.uom_uom_id_seq OWNED BY public.uom_uom.id;


--
-- Name: utm_campaign; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_campaign (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    stage_id integer NOT NULL,
    is_website boolean,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    company_id integer
);


--
-- Name: TABLE utm_campaign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_campaign IS 'UTM Campaign';


--
-- Name: COLUMN utm_campaign.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.name IS 'Campaign Name';


--
-- Name: COLUMN utm_campaign.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.user_id IS 'Responsible';


--
-- Name: COLUMN utm_campaign.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.stage_id IS 'Stage';


--
-- Name: COLUMN utm_campaign.is_website; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.is_website IS 'Is Website';


--
-- Name: COLUMN utm_campaign.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.color IS 'Color Index';


--
-- Name: COLUMN utm_campaign.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.create_uid IS 'Created by';


--
-- Name: COLUMN utm_campaign.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.create_date IS 'Created on';


--
-- Name: COLUMN utm_campaign.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_campaign.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.write_date IS 'Last Updated on';


--
-- Name: COLUMN utm_campaign.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_campaign.company_id IS 'Company';


--
-- Name: utm_campaign_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.utm_campaign_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: utm_campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.utm_campaign_id_seq OWNED BY public.utm_campaign.id;


--
-- Name: utm_medium; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_medium (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE utm_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_medium IS 'UTM Medium';


--
-- Name: COLUMN utm_medium.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.name IS 'Medium Name';


--
-- Name: COLUMN utm_medium.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.active IS 'Active';


--
-- Name: COLUMN utm_medium.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.create_uid IS 'Created by';


--
-- Name: COLUMN utm_medium.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.create_date IS 'Created on';


--
-- Name: COLUMN utm_medium.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_medium.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_medium.write_date IS 'Last Updated on';


--
-- Name: utm_medium_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.utm_medium_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: utm_medium_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.utm_medium_id_seq OWNED BY public.utm_medium.id;


--
-- Name: utm_source; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_source (
    id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE utm_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_source IS 'UTM Source';


--
-- Name: COLUMN utm_source.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_source.name IS 'Source Name';


--
-- Name: COLUMN utm_source.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_source.create_uid IS 'Created by';


--
-- Name: COLUMN utm_source.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_source.create_date IS 'Created on';


--
-- Name: COLUMN utm_source.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_source.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_source.write_date IS 'Last Updated on';


--
-- Name: utm_source_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.utm_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: utm_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.utm_source_id_seq OWNED BY public.utm_source.id;


--
-- Name: utm_stage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_stage (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE utm_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_stage IS 'Campaign Stage';


--
-- Name: COLUMN utm_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.name IS 'Name';


--
-- Name: COLUMN utm_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN utm_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN utm_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.create_date IS 'Created on';


--
-- Name: COLUMN utm_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_stage.write_date IS 'Last Updated on';


--
-- Name: utm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.utm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: utm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.utm_stage_id_seq OWNED BY public.utm_stage.id;


--
-- Name: utm_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE utm_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_tag IS 'UTM Tag';


--
-- Name: COLUMN utm_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.name IS 'Name';


--
-- Name: COLUMN utm_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.color IS 'Color Index';


--
-- Name: COLUMN utm_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN utm_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.create_date IS 'Created on';


--
-- Name: COLUMN utm_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.utm_tag.write_date IS 'Last Updated on';


--
-- Name: utm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.utm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: utm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.utm_tag_id_seq OWNED BY public.utm_tag.id;


--
-- Name: utm_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.utm_tag_rel (
    tag_id integer NOT NULL,
    campaign_id integer NOT NULL
);


--
-- Name: TABLE utm_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.utm_tag_rel IS 'RELATION BETWEEN utm_campaign AND utm_tag';


--
-- Name: validate_account_move; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.validate_account_move (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE validate_account_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.validate_account_move IS 'Validate Account Move';


--
-- Name: COLUMN validate_account_move.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.validate_account_move.create_uid IS 'Created by';


--
-- Name: COLUMN validate_account_move.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.validate_account_move.create_date IS 'Created on';


--
-- Name: COLUMN validate_account_move.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.validate_account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN validate_account_move.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.validate_account_move.write_date IS 'Last Updated on';


--
-- Name: validate_account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.validate_account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: validate_account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.validate_account_move_id_seq OWNED BY public.validate_account_move.id;


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "char" character varying,
    "integer" integer,
    "float" double precision,
    "numeric" numeric,
    many2one integer,
    "binary" bytea,
    date date,
    datetime timestamp without time zone,
    selection_str character varying,
    html text,
    text text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer
);


--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: account_account id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_account ALTER COLUMN id SET DEFAULT nextval('public.account_account_id_seq'::regclass);


--
-- Name: account_account_tag id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_account_tag ALTER COLUMN id SET DEFAULT nextval('public.account_account_tag_id_seq'::regclass);


--
-- Name: account_account_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_account_template ALTER COLUMN id SET DEFAULT nextval('public.account_account_template_id_seq'::regclass);


--
-- Name: account_account_type id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_account_type ALTER COLUMN id SET DEFAULT nextval('public.account_account_type_id_seq'::regclass);


--
-- Name: account_accrual_accounting_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_accrual_accounting_wizard ALTER COLUMN id SET DEFAULT nextval('public.account_accrual_accounting_wizard_id_seq'::regclass);


--
-- Name: account_analytic_account id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_analytic_account ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_account_id_seq'::regclass);


--
-- Name: account_analytic_distribution id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_analytic_distribution ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_distribution_id_seq'::regclass);


--
-- Name: account_analytic_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_analytic_group ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_group_id_seq'::regclass);


--
-- Name: account_analytic_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_analytic_line ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_line_id_seq'::regclass);


--
-- Name: account_analytic_tag id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_analytic_tag ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_tag_id_seq'::regclass);


--
-- Name: account_bank_statement id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_id_seq'::regclass);


--
-- Name: account_bank_statement_cashbox id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement_cashbox ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_cashbox_id_seq'::regclass);


--
-- Name: account_bank_statement_closebalance id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement_closebalance ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_closebalance_id_seq'::regclass);


--
-- Name: account_bank_statement_import id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement_import ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_import_id_seq'::regclass);


--
-- Name: account_bank_statement_import_journal_creation id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement_import_journal_creation ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_import_journal_creation_id_seq'::regclass);


--
-- Name: account_bank_statement_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_bank_statement_line ALTER COLUMN id SET DEFAULT nextval('public.account_bank_statement_line_id_seq'::regclass);


--
-- Name: account_cash_rounding id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_cash_rounding ALTER COLUMN id SET DEFAULT nextval('public.account_cash_rounding_id_seq'::regclass);


--
-- Name: account_cashbox_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_cashbox_line ALTER COLUMN id SET DEFAULT nextval('public.account_cashbox_line_id_seq'::regclass);


--
-- Name: account_chart_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_chart_template ALTER COLUMN id SET DEFAULT nextval('public.account_chart_template_id_seq'::regclass);


--
-- Name: account_common_journal_report id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_common_journal_report ALTER COLUMN id SET DEFAULT nextval('public.account_common_journal_report_id_seq'::regclass);


--
-- Name: account_common_report id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_common_report ALTER COLUMN id SET DEFAULT nextval('public.account_common_report_id_seq'::regclass);


--
-- Name: account_financial_year_op id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_financial_year_op ALTER COLUMN id SET DEFAULT nextval('public.account_financial_year_op_id_seq'::regclass);


--
-- Name: account_fiscal_position id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_id_seq'::regclass);


--
-- Name: account_fiscal_position_account id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position_account ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_account_id_seq'::regclass);


--
-- Name: account_fiscal_position_account_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position_account_template ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_account_template_id_seq'::regclass);


--
-- Name: account_fiscal_position_tax id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position_tax ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_tax_id_seq'::regclass);


--
-- Name: account_fiscal_position_tax_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position_tax_template ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_tax_template_id_seq'::regclass);


--
-- Name: account_fiscal_position_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_position_template ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_position_template_id_seq'::regclass);


--
-- Name: account_fiscal_year id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fiscal_year ALTER COLUMN id SET DEFAULT nextval('public.account_fiscal_year_id_seq'::regclass);


--
-- Name: account_fr_fec id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_fr_fec ALTER COLUMN id SET DEFAULT nextval('public.account_fr_fec_id_seq'::regclass);


--
-- Name: account_full_reconcile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_full_reconcile ALTER COLUMN id SET DEFAULT nextval('public.account_full_reconcile_id_seq'::regclass);


--
-- Name: account_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_group ALTER COLUMN id SET DEFAULT nextval('public.account_group_id_seq'::regclass);


--
-- Name: account_incoterms id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_incoterms ALTER COLUMN id SET DEFAULT nextval('public.account_incoterms_id_seq'::regclass);


--
-- Name: account_invoice_send id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_invoice_send ALTER COLUMN id SET DEFAULT nextval('public.account_invoice_send_id_seq'::regclass);


--
-- Name: account_journal id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_journal ALTER COLUMN id SET DEFAULT nextval('public.account_journal_id_seq'::regclass);


--
-- Name: account_journal_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_journal_group ALTER COLUMN id SET DEFAULT nextval('public.account_journal_group_id_seq'::regclass);


--
-- Name: account_move id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_move ALTER COLUMN id SET DEFAULT nextval('public.account_move_id_seq'::regclass);


--
-- Name: account_move_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_move_line ALTER COLUMN id SET DEFAULT nextval('public.account_move_line_id_seq'::regclass);


--
-- Name: account_move_reversal id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_move_reversal ALTER COLUMN id SET DEFAULT nextval('public.account_move_reversal_id_seq'::regclass);


--
-- Name: account_partial_reconcile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_partial_reconcile ALTER COLUMN id SET DEFAULT nextval('public.account_partial_reconcile_id_seq'::regclass);


--
-- Name: account_payment id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_payment ALTER COLUMN id SET DEFAULT nextval('public.account_payment_id_seq'::regclass);


--
-- Name: account_payment_method id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_payment_method ALTER COLUMN id SET DEFAULT nextval('public.account_payment_method_id_seq'::regclass);


--
-- Name: account_payment_register id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_payment_register ALTER COLUMN id SET DEFAULT nextval('public.account_payment_register_id_seq'::regclass);


--
-- Name: account_payment_term id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_payment_term ALTER COLUMN id SET DEFAULT nextval('public.account_payment_term_id_seq'::regclass);


--
-- Name: account_payment_term_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_payment_term_line ALTER COLUMN id SET DEFAULT nextval('public.account_payment_term_line_id_seq'::regclass);


--
-- Name: account_print_journal id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_print_journal ALTER COLUMN id SET DEFAULT nextval('public.account_print_journal_id_seq'::regclass);


--
-- Name: account_reconcile_model id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_reconcile_model ALTER COLUMN id SET DEFAULT nextval('public.account_reconcile_model_id_seq'::regclass);


--
-- Name: account_reconcile_model_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_reconcile_model_template ALTER COLUMN id SET DEFAULT nextval('public.account_reconcile_model_template_id_seq'::regclass);


--
-- Name: account_setup_bank_manual_config id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_setup_bank_manual_config ALTER COLUMN id SET DEFAULT nextval('public.account_setup_bank_manual_config_id_seq'::regclass);


--
-- Name: account_tax id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax ALTER COLUMN id SET DEFAULT nextval('public.account_tax_id_seq'::regclass);


--
-- Name: account_tax_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax_group ALTER COLUMN id SET DEFAULT nextval('public.account_tax_group_id_seq'::regclass);


--
-- Name: account_tax_repartition_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax_repartition_line ALTER COLUMN id SET DEFAULT nextval('public.account_tax_repartition_line_id_seq'::regclass);


--
-- Name: account_tax_repartition_line_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax_repartition_line_template ALTER COLUMN id SET DEFAULT nextval('public.account_tax_repartition_line_template_id_seq'::regclass);


--
-- Name: account_tax_report_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax_report_line ALTER COLUMN id SET DEFAULT nextval('public.account_tax_report_line_id_seq'::regclass);


--
-- Name: account_tax_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_tax_template ALTER COLUMN id SET DEFAULT nextval('public.account_tax_template_id_seq'::regclass);


--
-- Name: account_unreconcile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.account_unreconcile ALTER COLUMN id SET DEFAULT nextval('public.account_unreconcile_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_tests_models_char id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_noreadonly id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char_noreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_noreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_readonly id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char_readonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_readonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_required id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_states id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char_states ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_states_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_stillreadonly id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_char_stillreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_stillreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_complex id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_complex ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_complex_id_seq'::regclass);


--
-- Name: base_import_tests_models_float id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_float ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_float_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_m2o ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_related id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required_related id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_o2m ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m_child id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_o2m_child ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_child_id_seq'::regclass);


--
-- Name: base_import_tests_models_preview id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_tests_models_preview ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_preview_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: base_update_translations id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_update_translations ALTER COLUMN id SET DEFAULT nextval('public.base_update_translations_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: cash_box_out id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.cash_box_out ALTER COLUMN id SET DEFAULT nextval('public.cash_box_out_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: crm_team id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.crm_team ALTER COLUMN id SET DEFAULT nextval('public.crm_team_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: digest_digest id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.digest_digest ALTER COLUMN id SET DEFAULT nextval('public.digest_digest_id_seq'::regclass);


--
-- Name: digest_tip id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.digest_tip ALTER COLUMN id SET DEFAULT nextval('public.digest_tip_id_seq'::regclass);


--
-- Name: email_template_preview id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.email_template_preview ALTER COLUMN id SET DEFAULT nextval('public.email_template_preview_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_server_object_lines id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_server_object_lines ALTER COLUMN id SET DEFAULT nextval('public.ir_server_object_lines_id_seq'::regclass);


--
-- Name: ir_translation id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_translation ALTER COLUMN id SET DEFAULT nextval('public.ir_translation_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_channel id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_channel ALTER COLUMN id SET DEFAULT nextval('public.mail_channel_id_seq'::regclass);


--
-- Name: mail_channel_partner id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_channel_partner ALTER COLUMN id SET DEFAULT nextval('public.mail_channel_partner_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_res_partner_needaction_rel id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_message_res_partner_needaction_rel ALTER COLUMN id SET DEFAULT nextval('public.mail_message_res_partner_needaction_rel_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_moderation id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_moderation ALTER COLUMN id SET DEFAULT nextval('public.mail_moderation_id_seq'::regclass);


--
-- Name: mail_resend_cancel id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_resend_cancel ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_cancel_id_seq'::regclass);


--
-- Name: mail_resend_message id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_resend_message ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_message_id_seq'::regclass);


--
-- Name: mail_resend_partner id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_resend_partner ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_partner_id_seq'::regclass);


--
-- Name: mail_shortcode id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_shortcode ALTER COLUMN id SET DEFAULT nextval('public.mail_shortcode_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: mail_wizard_invite id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.mail_wizard_invite ALTER COLUMN id SET DEFAULT nextval('public.mail_wizard_invite_id_seq'::regclass);


--
-- Name: payment_acquirer id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_acquirer ALTER COLUMN id SET DEFAULT nextval('public.payment_acquirer_id_seq'::regclass);


--
-- Name: payment_acquirer_onboarding_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_acquirer_onboarding_wizard ALTER COLUMN id SET DEFAULT nextval('public.payment_acquirer_onboarding_wizard_id_seq'::regclass);


--
-- Name: payment_icon id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_icon ALTER COLUMN id SET DEFAULT nextval('public.payment_icon_id_seq'::regclass);


--
-- Name: payment_link_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_link_wizard ALTER COLUMN id SET DEFAULT nextval('public.payment_link_wizard_id_seq'::regclass);


--
-- Name: payment_token id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_token ALTER COLUMN id SET DEFAULT nextval('public.payment_token_id_seq'::regclass);


--
-- Name: payment_transaction id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payment_transaction ALTER COLUMN id SET DEFAULT nextval('public.payment_transaction_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: portal_share id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.portal_share ALTER COLUMN id SET DEFAULT nextval('public.portal_share_id_seq'::regclass);


--
-- Name: portal_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.portal_wizard ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_id_seq'::regclass);


--
-- Name: portal_wizard_user id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.portal_wizard_user ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_user_id_seq'::regclass);


--
-- Name: product_attribute id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_attribute ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_id_seq'::regclass);


--
-- Name: product_attribute_custom_value id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_attribute_custom_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_custom_value_id_seq'::regclass);


--
-- Name: product_attribute_value id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_value_id_seq'::regclass);


--
-- Name: product_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_category ALTER COLUMN id SET DEFAULT nextval('public.product_category_id_seq'::regclass);


--
-- Name: product_packaging id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_packaging ALTER COLUMN id SET DEFAULT nextval('public.product_packaging_id_seq'::regclass);


--
-- Name: product_price_list id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_price_list ALTER COLUMN id SET DEFAULT nextval('public.product_price_list_id_seq'::regclass);


--
-- Name: product_pricelist id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_pricelist ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_id_seq'::regclass);


--
-- Name: product_pricelist_item id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_pricelist_item ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_item_id_seq'::regclass);


--
-- Name: product_product id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_product ALTER COLUMN id SET DEFAULT nextval('public.product_product_id_seq'::regclass);


--
-- Name: product_supplierinfo id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_supplierinfo ALTER COLUMN id SET DEFAULT nextval('public.product_supplierinfo_id_seq'::regclass);


--
-- Name: product_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_template ALTER COLUMN id SET DEFAULT nextval('public.product_template_id_seq'::regclass);


--
-- Name: product_template_attribute_exclusion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_template_attribute_exclusion ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_exclusion_id_seq'::regclass);


--
-- Name: product_template_attribute_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_template_attribute_line ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_line_id_seq'::regclass);


--
-- Name: product_template_attribute_value id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.product_template_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_value_id_seq'::regclass);


--
-- Name: purchase_order id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.purchase_order ALTER COLUMN id SET DEFAULT nextval('public.purchase_order_id_seq'::regclass);


--
-- Name: purchase_order_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.purchase_order_line ALTER COLUMN id SET DEFAULT nextval('public.purchase_order_line_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_autocomplete_sync id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_autocomplete_sync ALTER COLUMN id SET DEFAULT nextval('public.res_partner_autocomplete_sync_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: resource_calendar id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.resource_calendar ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_id_seq'::regclass);


--
-- Name: resource_calendar_attendance id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.resource_calendar_attendance ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_attendance_id_seq'::regclass);


--
-- Name: resource_calendar_leaves id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.resource_calendar_leaves ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_leaves_id_seq'::regclass);


--
-- Name: resource_resource id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.resource_resource ALTER COLUMN id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: resource_test id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.resource_test ALTER COLUMN id SET DEFAULT nextval('public.resource_test_id_seq'::regclass);


--
-- Name: sale_advance_payment_inv id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_advance_payment_inv ALTER COLUMN id SET DEFAULT nextval('public.sale_advance_payment_inv_id_seq'::regclass);


--
-- Name: sale_order id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order ALTER COLUMN id SET DEFAULT nextval('public.sale_order_id_seq'::regclass);


--
-- Name: sale_order_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order_line ALTER COLUMN id SET DEFAULT nextval('public.sale_order_line_id_seq'::regclass);


--
-- Name: sale_order_option id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order_option ALTER COLUMN id SET DEFAULT nextval('public.sale_order_option_id_seq'::regclass);


--
-- Name: sale_order_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order_template ALTER COLUMN id SET DEFAULT nextval('public.sale_order_template_id_seq'::regclass);


--
-- Name: sale_order_template_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order_template_line ALTER COLUMN id SET DEFAULT nextval('public.sale_order_template_line_id_seq'::regclass);


--
-- Name: sale_order_template_option id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_order_template_option ALTER COLUMN id SET DEFAULT nextval('public.sale_order_template_option_id_seq'::regclass);


--
-- Name: sale_payment_acquirer_onboarding_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sale_payment_acquirer_onboarding_wizard ALTER COLUMN id SET DEFAULT nextval('public.sale_payment_acquirer_onboarding_wizard_id_seq'::regclass);


--
-- Name: sms_cancel id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_cancel ALTER COLUMN id SET DEFAULT nextval('public.sms_cancel_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_resend id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_resend ALTER COLUMN id SET DEFAULT nextval('public.sms_resend_id_seq'::regclass);


--
-- Name: sms_resend_recipient id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_resend_recipient ALTER COLUMN id SET DEFAULT nextval('public.sms_resend_recipient_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: snailmail_letter_cancel id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.snailmail_letter_cancel ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_cancel_id_seq'::regclass);


--
-- Name: snailmail_letter_format_error id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.snailmail_letter_format_error ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_format_error_id_seq'::regclass);


--
-- Name: snailmail_letter_missing_required_fields id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.snailmail_letter_missing_required_fields ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_missing_required_fields_id_seq'::regclass);


--
-- Name: tax_adjustments_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tax_adjustments_wizard ALTER COLUMN id SET DEFAULT nextval('public.tax_adjustments_wizard_id_seq'::regclass);


--
-- Name: uom_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.uom_category ALTER COLUMN id SET DEFAULT nextval('public.uom_category_id_seq'::regclass);


--
-- Name: uom_uom id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.uom_uom ALTER COLUMN id SET DEFAULT nextval('public.uom_uom_id_seq'::regclass);


--
-- Name: utm_campaign id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.utm_campaign ALTER COLUMN id SET DEFAULT nextval('public.utm_campaign_id_seq'::regclass);


--
-- Name: utm_medium id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.utm_medium ALTER COLUMN id SET DEFAULT nextval('public.utm_medium_id_seq'::regclass);


--
-- Name: utm_source id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.utm_source ALTER COLUMN id SET DEFAULT nextval('public.utm_source_id_seq'::regclass);


--
-- Name: utm_stage id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.utm_stage ALTER COLUMN id SET DEFAULT nextval('public.utm_stage_id_seq'::regclass);


--
-- Name: utm_tag id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.utm_tag ALTER COLUMN id SET DEFAULT nextval('public.utm_tag_id_seq'::regclass);


--
-- Name: validate_account_move id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.validate_account_move ALTER COLUMN id SET DEFAULT nextval('public.validate_account_move_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: account_account; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.account_account (id, name, currency_id, code, deprecated, user_type_id, internal_type, internal_group, reconcile, note, company_id, group_id, root_id, create_uid, create_date, write_uid, write_date) FROM stdin;
84	Dépôts	\N	165100	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
1	Transfert de liquidités	\N	580001	f	5	other	asset	t	\N	1	\N	53056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
2	Capital souscrit - non appelé	\N	101100	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
3	Capital souscrit - appelé non versé	\N	101200	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
4	 Capital souscrit appelé, versé	\N	101300	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
5	Capital non amorti	\N	101310	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
6	Capital amorti	\N	101320	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
7	Capital souscrit soumis à des réglementations particulières	\N	101800	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
8	 Fonds fiduciaires	\N	102000	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
9	Primes d'émission	\N	104100	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
10	Primes de fusion	\N	104200	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
11	Primes d'apport	\N	104300	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
12	Primes de conversion d'obligations en actions	\N	104400	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
13	Bons de souscription d'actions	\N	104500	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
14	Réserve spéciale de réévaluation	\N	105100	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
15	Écart de réévaluation libre	\N	105200	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
16	Réserve de réévaluation	\N	105300	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
17	Écarts de réévaluation (autres opérations légales)	\N	105500	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
18	Autres écarts de réévaluation en France	\N	105700	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
19	Autres écarts de réévaluation à l'étranger	\N	105800	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
20	 Réserve légale	\N	106100	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
21	Réserve légale proprement dite	\N	106110	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
22	Plus-values nettes à long terme	\N	106120	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
23	Réserves indisponibles	\N	106200	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
24	Réserves statutaires ou contractuelles	\N	106300	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
25	 Réserves réglementées	\N	106400	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
26	Plus-values nettes à long terme	\N	106410	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
27	Réserves consécutives à l'octroi de subventions d'investissement	\N	106430	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
28	Autres réserves réglementées	\N	106480	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
29	 Autres réserves	\N	106800	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
30	Réserve de propre assureur	\N	106810	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
31	Réserves diverses	\N	106880	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
32	Écarts d'équivalence	\N	107000	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
33	Compte de l'exploitant	\N	108000	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
34	Actionnaires : capital souscrit - non appelé	\N	109000	f	11	other	equity	f	\N	1	\N	49048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
35	Report à nouveau (solde créditeur)	\N	110000	f	11	other	equity	f	\N	1	\N	49049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
36	Report à nouveau (solde débiteur)	\N	119000	f	11	other	equity	f	\N	1	\N	49049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
37	Résultat de l'exercice (bénéfice)	\N	120000	f	11	other	equity	f	\N	1	\N	49050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
38	Résultat de l'exercice (perte)	\N	129000	f	11	other	equity	f	\N	1	\N	49050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
39	Subventions d'équipement - État	\N	131100	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
40	Subventions d'équipement - Régions	\N	131200	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
41	Subventions d'équipement - Départements	\N	131300	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
42	Subventions d'équipement - Communes	\N	131400	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
43	Subventions d'équipement - Collectivités publiques	\N	131500	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
44	Subventions d'équipement - Entreprises publiques	\N	131600	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
45	Subventions d'équipement - Entreprises et organismes privés	\N	131700	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
46	Subventions d'équipement - Autres	\N	131800	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
47	Autres subventions d'investissement (même ventilation que celle du compte 131)	\N	138000	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
48	Subventions d'équipement inscrites au compte de résultat - État	\N	139110	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
192	Titres immobilisés de l'activité de portefeuille	\N	273000	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
49	Subventions d'équipement inscrites au compte de résultat - Régions	\N	139120	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
50	Subventions d'équipement inscrites au compte de résultat - Départements	\N	139130	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
51	Subventions d'équipement inscrites au compte de résultat - Communes	\N	139140	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
52	Subventions d'équipement inscrites au compte de résultat - Collectivités publiques	\N	139150	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
53	Subventions d'équipement inscrites au compte de résultat - Entreprises publiques	\N	139160	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
54	Subventions d'équipement inscrites au compte de résultat - Entreprises et organismes privés	\N	139170	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
55	Subventions d'équipement inscrites au compte de résultat - Autres	\N	139180	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
56	Autres subventions d'investissement (même ventilation que celle du compte 1391)	\N	139800	f	11	other	equity	f	\N	1	\N	49051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
57	Provisions reconstitution des gisements miniers et pétroliers	\N	142300	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
58	Provisions pour investissement (participation des salariés)	\N	142400	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
59	Provisions réglementées relatives aux stocks - Hausse de prix	\N	143100	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
60	Provisions réglementées relatives aux stocks - Fluctuation des cours	\N	143200	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
61	Provisions réglementées relatives aux autres éléments de l'actif	\N	144000	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
62	Amortissements dérogatoires	\N	145000	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
63	Provision spéciale de réévaluation	\N	146000	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
64	Plus-values réinvesties	\N	147000	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
65	Autres provisions réglementées	\N	148000	f	9	other	liability	f	\N	1	\N	49052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
66	Provisions pour litiges	\N	151100	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
67	Provisions pour garanties données aux clients	\N	151200	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
68	Provisions pour pertes sur marchés à terme	\N	151300	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
69	Provisions pour amendes et pénalités	\N	151400	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
70	Provisions pour pertes de change	\N	151500	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
71	Provisions pour pertes sur contrats	\N	151600	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
72	Autres provisions pour risques	\N	151800	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
73	Provisions pour pensions et obligations similaires	\N	153000	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
74	Provisions pour restructurations	\N	154000	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
75	Provisions pour impôts	\N	155000	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
76	Provisions pour renouvellement des immobilisations (entreprises concessionnaires)	\N	156000	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
77	 Provisions pour charges à répartir sur plusieurs exercices	\N	157000	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
78	Provisions pour charges à répartir sur plusieurs exercices - Gros entretien ou grandes révisions	\N	157200	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
79	Provisions pour remises en état	\N	158100	f	9	other	liability	f	\N	1	\N	49053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
80	Emprunts obligataires convertibles	\N	161000	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
81	Obligations représentatives de passifs nets remis en fiducie	\N	162000	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
82	Autres emprunts obligataires	\N	163000	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
83	Emprunts auprès des établissements de crédit	\N	164000	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
85	Cautionnements	\N	165500	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
86	Participation des salariés aux résultats - Comptes bloqués	\N	166100	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
87	Participation des salariés aux résultats - Fonds de participation	\N	166200	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
88	Emprunts et dettes assortis de conditions particulières - Emissions de titres participatifs	\N	167100	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
89	Emprunts et dettes assortis de conditions particulières - Avances conditionnées de l'État	\N	167400	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
90	Emprunts et dettes assortis de conditions particulières - Emprunts participatifs	\N	167500	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
91	Autres emprunts et dettes assimilées - Autres emprunts	\N	168100	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
92	Autres emprunts et dettes assimilées - Rentes viagères capitalisées	\N	168500	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
93	Autres emprunts et dettes assimilées - Autres dettes	\N	168700	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
94	Intérêts courus	\N	168800	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
95	Intérêts courus sur emprunts obligataires convertibles	\N	168810	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
96	Intérêts courus sur autres emprunts obligataires	\N	168830	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
97	Intérêts courus sur emprunts auprès des établissements de crédit	\N	168840	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
98	Intérêts courus sur dépôts et cautionnements reçus	\N	168850	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
99	Intérêts courus sur participation des salariés aux résultats	\N	168860	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
100	Intérêts courus sur emprunts et dettes assortis de conditions particulières	\N	168870	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
101	Intérêts courus sur autres emprunts et dettes assimilées	\N	168880	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
102	Primes de remboursement des obligations	\N	169000	f	9	other	liability	f	\N	1	\N	49054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
103	Dettes rattachées à des participations (groupe)	\N	171000	f	9	other	liability	f	\N	1	\N	49055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
104	Dettes rattachées à des participations (hors groupe)	\N	174000	f	9	other	liability	f	\N	1	\N	49055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
105	Dettes rattachées à des sociétés en participation - Principal	\N	178100	f	9	other	liability	f	\N	1	\N	49055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
106	Dettes rattachées à des sociétés en participation - Intérêts courus	\N	178800	f	9	other	liability	f	\N	1	\N	49055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
107	Comptes de liaison des établissements	\N	181000	f	9	other	liability	f	\N	1	\N	49056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
108	Biens et prestations de services échangés entre établissements (charges)	\N	186000	f	9	other	liability	f	\N	1	\N	49056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
109	Biens et prestations de services échangés entre établissements (produits)	\N	187000	f	9	other	liability	f	\N	1	\N	49056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
110	Comptes de liaison des sociétés en participation	\N	188000	f	9	other	liability	f	\N	1	\N	49056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
111	Immobilisations incorporelles - Frais d'établissement - Frais de constitution	\N	201100	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
112	 Frais de premier établissement	\N	201200	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
113	Immobilisations incorporelles - Frais d'établissement - Frais de prospection	\N	201210	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
114	Immobilisations incorporelles - Frais d'établissement - Frais de publicité	\N	201220	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
115	Immobilisations incorporelles - Frais d'augmentation de capital et d'opérations diverses (fusions, scissions, transformations)	\N	201300	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
116	Immobilisations incorporelles - Frais de recherche et de développement	\N	203000	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
117	Immobilisations incorporelles - Concessions et droits similaires, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires	\N	205000	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
118	Immobilisations incorporelles - Droit au bail	\N	206000	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
119	Immobilisations incorporelles - Fonds commercial	\N	207000	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
120	Autres immobilisations incorporelles	\N	208000	f	8	other	asset	f	\N	1	\N	50048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
121	Immobilisations corporelles - Terrains nus	\N	211100	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
122	Immobilisations corporelles - Terrains aménagés	\N	211200	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
123	Immobilisations corporelles - Sous-sols et sur-sols	\N	211300	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
124	Terrains de carrières (Tréfonds)	\N	211400	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
125	Terrains bâtis	\N	211500	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
126	Immobilisations corporelles - Terrains bâtis - Ensembles immobiliers industriels	\N	211510	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
127	Immobilisations corporelles - Terrains bâtis - Ensembles immobiliers administratifs et commerciaux	\N	211550	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
128	 Autres ensembles immobiliers	\N	211580	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
129	Immobilisations corporelles - Terrains bâtis affectés aux opérations professionnelles	\N	211581	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
130	Immobilisations corporelles - Terrains bâtis affectés aux opérations non professionnelles	\N	211588	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
131	Immobilisations corporelles - Compte d'ordre sur immobilisations	\N	211600	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
132	Immobilisations corporelles - Agencements et aménagements de terrains (même ventilation que celle du compte 211)	\N	212000	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
133	 Bâtiments	\N	213100	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
134	Immobilisations corporelles - Bâtiments - Ensembles immobiliers industriels	\N	213110	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
135	Immobilisations corporelles - Bâtiments - Ensembles immobiliers administratifs et commerciaux	\N	213150	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
136	Immobilisations corporelles - Bâtiments affectés aux opérations professionnelles	\N	213181	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
137	Immobilisations corporelles - Bâtiments affectés aux opérations non professionnelles	\N	213188	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
138	Immobilisations corporelles - Installations générales, agencements, aménagements des constructions (même ventilation que celle du compte 2131)	\N	213500	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
139	 Ensembles immobiliers industriels (A, B)	\N	213510	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
140	 Ensembles immobiliers administratifs et commerciaux (A, B)	\N	213550	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
141	 affectés aux opérations professionnelles (A, B)	\N	213581	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
142	 affectés aux opérations non professionnelles (A, B)	\N	213588	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
143	Immobilisations corporelles - Ouvrages d'infrastructure - Voies de terre	\N	213810	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
144	Immobilisations corporelles - Ouvrages d'infrastructure - Voies de fer	\N	213820	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
145	Immobilisations corporelles - Ouvrages d'infrastructure - Voies d'eau	\N	213830	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
146	Immobilisations corporelles - Ouvrages d'infrastructure - Barrages	\N	213840	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
147	Immobilisations corporelles - Ouvrages d'infrastructure - Pistes d'aérodromes	\N	213850	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
148	Immobilisations corporelles - Constructions sur sol d'autrui (même ventilation que celle du compte 213)	\N	214000	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
149	Immobilisations corporelles - Installations complexes spécialisées sur sol propre	\N	215110	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
150	Immobilisations corporelles - Installations complexes spécialisées sur sol d'autrui	\N	215140	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
151	Immobilisations corporelles - Installations à caractère spécifique sur sol propre	\N	215310	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
152	Immobilisations corporelles - Installations à caractère spécifique sur sol d'autrui	\N	215340	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
153	Immobilisations corporelles - Matériels industriels	\N	215400	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
154	Immobilisations corporelles - Outillage industriel	\N	215500	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
155	Immobilisations corporelles - Agencements et aménagements des matériels et outillage industriels	\N	215700	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
156	Immobilisations corporelles - Installations générales agencements aménagements divers	\N	218100	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
157	Immobilisations corporelles - Matériel de transport	\N	218200	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
158	Immobilisations corporelles - Matériel de bureau et matériel informatique	\N	218300	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
159	Immobilisations corporelles - Mobilier	\N	218400	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
160	Immobilisations corporelles - Cheptel	\N	218500	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
161	Immobilisations corporelles - Emballages récupérables	\N	218600	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
162	Mali de fusions sur actifs corporels	\N	218700	f	8	other	asset	f	\N	1	\N	50049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
163	Immobilisations mises en concession	\N	220000	f	8	other	asset	f	\N	1	\N	50050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
164	Immobilisations corporelles en cours - Terrains	\N	231200	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
165	Immobilisations corporelles en cours - Constructions	\N	231300	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
166	Immobilisations corporelles en cours - Installations techniques matériel et outillage industriels	\N	231500	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
167	Autres immobilisations corporelles en cours	\N	231800	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
168	Immobilisations incorporelles en cours	\N	232000	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
169	Avances et acomptes versés sur commandes d'immobilisations incorporelles	\N	237000	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
170	Avances et acomptes versés sur commandes d'immobilisations corporelles - Terrains	\N	238200	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
171	Avances et acomptes versés sur commandes d'immobilisations corporelles - Constructions	\N	238300	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
172	Avances et acomptes versés sur commandes d'immobilisations corporelles - Installations techniques matériel et outillage industriels	\N	238500	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
173	Avances et acomptes versés sur commandes d'immobilisations corporelles - Autres immobilisations corporelles	\N	238800	f	8	other	asset	f	\N	1	\N	50051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
174	Parts dans des entreprises liées et créances sur des entreprises liées	\N	250000	f	8	other	asset	f	\N	1	\N	50053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
175	Titres de participation - Actions	\N	261100	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
176	Autres titres de participation	\N	261800	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
177	Autres formes de participation	\N	266000	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
178	Droits représentatifs d’actifs nets remis en fiducie	\N	266100	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
179	Créances rattachées à des participations (groupe)	\N	267100	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
180	Créances rattachées à des participations (hors groupe)	\N	267400	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
181	Versements représentatifs d'apports non capitalisés (appel de fonds)	\N	267500	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
182	Avances consolidables	\N	267600	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
183	Autres créances rattachées à des participations	\N	267700	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
184	Créances rattachées à des participations - Intérêts courus	\N	267800	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
185	Créances rattachées à des sociétés en participation - Principal	\N	268100	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
186	Créances rattachées à des sociétés en participation - Intérêts courus	\N	268800	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
187	Versements restant à effectuer sur titres de participation non libérés	\N	269000	f	8	other	asset	f	\N	1	\N	50054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
188	Titres immobilisés autres que les titres immobilisés de l'activité de portefeuille - Actions	\N	271100	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
189	Titres immobilisés autres que les titres immobilisés de l'activité de portefeuille - Autres titres	\N	271800	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
190	Titres immobilisés - Obligations	\N	272100	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
191	Titres immobilisés - Bons	\N	272200	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
193	Prêts participatifs	\N	274100	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
194	Prêts aux associés	\N	274200	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
195	Prêts au personnel	\N	274300	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
196	Autres prêts	\N	274800	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
197	Dépôts	\N	275100	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
198	Cautionnements	\N	275500	f	8	other	asset	t	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
199	Autres créances immobilisées - Créances diverses	\N	276100	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
200	Autres créances immobilisées - Intérêts courus sur titres immobilisés (droits de créance)	\N	276820	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
201	Autres créances immobilisées - Intérêts courus sur prêts	\N	276840	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
202	Autres créances immobilisées - Intérêts courus sur dépôts et cautionnements	\N	276850	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
203	Autres créances immobilisées - Intérêts courus sur créances diverses	\N	276880	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
204	Actions propres ou parts propres	\N	277100	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
205	Actions propres ou parts propres en voie d'annulation	\N	277200	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
206	 Mali de fusion sur actifs financiers	\N	278000	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
207	Versements restant à effectuer sur titres immobilisés non libérés	\N	279000	f	8	other	asset	f	\N	1	\N	50055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
208	Amortissements des immobilisations incorporelles - Frais d'établissement (même ventilation que celle du compte 201)	\N	280100	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
209	Amortissements des immobilisations incorporelles - Frais de recherche et de développement	\N	280300	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
210	Amortissements des immobilisations incorporelles - Concessions et droits similaires, brevets, licences, logiciels, droits et valeurs similaires	\N	280500	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
211	Amortissements des immobilisations incorporelles - Fonds commercial	\N	280700	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
212	Amortissements des autres immobilisations incorporelles	\N	280800	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
213	 Amortissements du mali de fusion sur actifs incorporels	\N	280810	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
214	Amortissements des immobilisations corporelles - Agencements aménagements de terrains (même ventilation que celle du compte 212)	\N	281200	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
215	Amortissements des immobilisations corporelles - Constructions (même ventilation que celle du compte 213)	\N	281300	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
216	Amortissements des immobilisations corporelles - Constructions sur sol d'autrui (même ventilation que celle du compte 214)	\N	281400	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
217	Amortissements des immobilisations corporelles - Installations matériel et outillage industriels (même ventilation que celle du compte 215)	\N	281500	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
218	Amortissements des autres immobilisations corporelles (même ventilation que celle du compte 218)	\N	281800	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
219	 Amortissement du mali de fusion sur actifs corporels	\N	281870	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
220	Amortissements des immobilisations mises en concession	\N	282000	f	8	other	asset	f	\N	1	\N	50056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
221	Dépréciations des immobilisations incorporelles - Marques, procédés, droits et valeurs similaires	\N	290500	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
222	Dépréciations des immobilisations incorporelles - Droit au bail	\N	290600	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
223	Dépréciations des immobilisations incorporelles - Fonds commercial	\N	290700	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
224	Dépréciations des autres immobilisations incorporelles	\N	290800	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
225	Dépréciation du mali de fusion sur actifs incorporels	\N	290810	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
226	 Dépréciation du mali de fusion sur actifs corporels	\N	291870	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
227	Dépréciations des immobilisations mises en concession	\N	292000	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
228	Dépréciations des immobilisations corporelles en cours	\N	293100	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
229	Dépréciations des immobilisations incorporelles en cours	\N	293200	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
230	Provisions pour dépréciation des titres de participation	\N	296100	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
231	Provisions pour dépréciation des autres formes de participation	\N	296600	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
232	Provisions pour dépréciation des créances rattachées à des participations (même ventilation que celle du compte 267)	\N	296700	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
233	Provisions pour dépréciation des créances rattachées à des sociétés en participation (même ventilation que celle du compte 268)	\N	296800	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
234	Provisions pour dépréciation des titres immobilisés autres que les titres immobilisés de l'activité de portefeuille - droit de propriété (ventilation : 271)	\N	297100	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
235	Provisions pour dépréciation des titres immobilisés - droit de créance (même ventilation que celle du compte 272)	\N	297200	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
236	Provisions pour dépréciation des titres immobilisés de l'activité de portefeuille	\N	297300	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
287	Fournisseurs et comptes rattachés	\N	400000	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
237	Provisions pour dépréciation des prêts (même ventilation que celle du compte 274)	\N	297400	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
238	Provisions pour dépréciation des dépôts et cautionnements versés (même ventilation que celle du compte 275)	\N	297500	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
239	Provisions pour dépréciation des autres créances immobilisées (même ventilation que celle du compte 276)	\N	297600	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
240	 Dépréciation du mali de fusion sur actifs financiers	\N	297870	f	8	other	asset	f	\N	1	\N	50057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
241	Matières premières (ou groupe) A	\N	311000	f	5	other	asset	f	\N	1	\N	51049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
242	Matières premières (ou groupe) B	\N	312000	f	5	other	asset	f	\N	1	\N	51049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
243	Fournitures A, B, C, ..	\N	317000	f	5	other	asset	f	\N	1	\N	51049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
244	Matières consommables (ou groupe) C	\N	321100	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
245	Matières consommables (ou groupe) D	\N	321200	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
246	Combustibles	\N	322100	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
247	Produits d'entretien	\N	322200	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
248	Fournitures d'atelier et d usine	\N	322300	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
249	Fournitures de magasin	\N	322400	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
250	Fournitures de bureau	\N	322500	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
251	Emballages perdus	\N	326100	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
252	Emballages récupérables non identifiables	\N	326500	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
253	Emballages à usage mixte	\N	326700	f	5	other	asset	f	\N	1	\N	51050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
254	Produit en cours P 1	\N	331100	f	5	other	asset	f	\N	1	\N	51051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
255	Produit en cours P 2	\N	331200	f	5	other	asset	f	\N	1	\N	51051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
256	Travaux en cours T 1	\N	335100	f	5	other	asset	f	\N	1	\N	51051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
257	Travaux en cours T 2	\N	335200	f	5	other	asset	f	\N	1	\N	51051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
258	Études en cours E 1	\N	341100	f	5	other	asset	f	\N	1	\N	51052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
259	Études en cours E 2	\N	341200	f	5	other	asset	f	\N	1	\N	51052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
260	Prestations de services en cours S 1	\N	345100	f	5	other	asset	f	\N	1	\N	51052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
261	Prestations de services en cours S 2	\N	345200	f	5	other	asset	f	\N	1	\N	51052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
262	Stocks produits intermédiaires (ou groupe) A	\N	351100	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
263	Stocks produits intermédiaires (ou groupe) B	\N	351200	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
264	Stocks produits finis (ou groupe) A	\N	355100	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
265	Stocks produits finis (ou groupe) B	\N	355200	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
266	Stocks produits résiduels - Déchets	\N	358100	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
267	Stocks produits résiduels - Rebuts	\N	358500	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
268	Stocks produits résiduels - Matières de récupération	\N	358600	f	5	other	asset	f	\N	1	\N	51053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
269	Stocks provenant d'immobilisations	\N	360000	f	5	other	asset	f	\N	1	\N	51054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
270	Stocks de marchandises (ou groupe) A	\N	371000	f	5	other	asset	f	\N	1	\N	51055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
271	Stocks de marchandises (ou groupe) B	\N	372000	f	5	other	asset	f	\N	1	\N	51055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
272	Stocks en voie d'acheminement	\N	380000	f	5	other	asset	f	\N	1	\N	51056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
273	Provisions pour dépréciation des matières premières (ou groupe) A	\N	391100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
274	Provisions pour dépréciation des matières premières (ou groupe) B	\N	391200	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
275	Provisions pour dépréciation des fournitures A, B, C, ..	\N	391700	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
276	Provisions pour dépréciation des matières consommables (même ventilation que celle du compte 321)	\N	392100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
277	Provisions pour dépréciation des fournitures consommables (même ventilation que celle du compte 322)	\N	392200	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
278	Provisions pour dépréciation des emballages (même ventilation que celle du compte 326)	\N	392600	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
279	Provisions pour dépréciation des produits en cours (même ventilation que celle du compte 331)	\N	393100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
280	Provisions pour dépréciation des travaux en cours (même ventilation que celle du compte 335)	\N	393500	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
281	Provisions pour dépréciation des études en cours (même ventilation que celle du compte 341)	\N	394100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
282	Provisions pour dépréciation des prestations de services en cours (même ventilation que celle du compte 345)	\N	394500	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
283	Provisions pour dépréciation des produits intermédiaires (même ventilation que celle du compte 351)	\N	395100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
284	Provisions pour dépréciation des produits finis (même ventilation que celle du compte 355)	\N	395500	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
285	Provisions pour dépréciation des stocks de marchandises (ou groupe) A	\N	397100	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
286	Provisions pour dépréciation des stocks de marchandises (ou groupe) B	\N	397200	f	5	other	asset	f	\N	1	\N	51057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
345	Crédit de TVA à reporter	\N	445670	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
288	Fournisseurs - Achats de biens et prestations de services	\N	401100	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
289	Fournisseurs - Retenues de garantie	\N	401700	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
290	Fournisseurs - Effets à payer	\N	403000	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
291	Fournisseurs - Achats d'immobilisations	\N	404100	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
292	Fournisseurs d'immobilisations - Retenues de garantie	\N	404700	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
293	Fournisseurs d'immobilisations - Effets à payer	\N	405000	f	2	payable	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
294	Factures non parvenues - Fournisseurs	\N	408100	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
295	Factures non parvenues - Fournisseurs d'immobilisations	\N	408400	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
296	Factures non parvenues - Fournisseurs - Intérêts courus	\N	408800	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
297	 Fournisseurs  avance et acomptes versés sur commandes	\N	409100	f	9	other	liability	f	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
298	Fournisseurs débiteurs - Créances pour emballages et matériel à rendre	\N	409600	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
299	Fournisseurs débiteurs - Autres avoirs des fournisseurs d'exploitation	\N	409710	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
300	Fournisseurs débiteurs - Autres avoirs des fournisseurs d'immobilisations	\N	409740	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
301	Fournisseurs débiteurs - Rabais, remises, ristournes à obtenir et autres avoirs non encore reçus	\N	409800	f	9	other	liability	t	\N	1	\N	52048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
302	Clients et comptes rattachés	\N	410000	f	1	receivable	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
303	Clients - Ventes de biens ou de prestations de services	\N	411100	f	1	receivable	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
304	PoS - Clients - Ventes de biens ou de prestations de services	\N	411101	f	1	receivable	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
305	Clients - Retenues de garantie	\N	411700	f	1	receivable	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
306	Clients - Effets à recevoir	\N	413000	f	1	receivable	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
307	Clients douteux ou litigieux	\N	416000	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
308	Clients - Factures à établir	\N	418100	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
309	Clients - Intérêts courus non encore facturés	\N	418800	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
310	Clients créditeurs - Avances et acomptes reçus sur commandes	\N	419100	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
311	Clients créditeurs - Dettes pour emballages et matériels consignés	\N	419600	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
312	Clients créditeurs - Autres avoirs	\N	419700	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
313	Clients créditeurs - Rabais, remises, ristournes à accorder et autres avoirs à établir	\N	419800	f	5	other	asset	t	\N	1	\N	52049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
314	Personnel - Rémunérations dues	\N	421000	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
315	Comités d'entreprise, d'établissement	\N	422000	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
316	Participation des salariés aux résultats - Réserve spéciale	\N	424600	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
317	Participation des salariés aux résultats - Comptes courants	\N	424800	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
318	Personnel - Avances et acomptes	\N	425000	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
319	Personnel - Dépôts	\N	426000	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
320	Personnel - Oppositions	\N	427000	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
321	Personnel - Dettes provisionnées pour congés à payer	\N	428200	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
322	Personnel - Dettes provisionnées pour participation des salariés aux résultats	\N	428400	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
323	Personnel - Autres charges à payer	\N	428600	f	9	other	liability	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
324	Personnel - Produits à recevoir	\N	428700	f	5	other	asset	t	\N	1	\N	52050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
325	Sécurité Sociale	\N	431000	f	9	other	liability	t	\N	1	\N	52051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
326	Autres organismes sociaux	\N	437000	f	9	other	liability	t	\N	1	\N	52051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
327	Charges sociales sur congés à payer	\N	438200	f	9	other	liability	t	\N	1	\N	52051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
328	Organismes sociaux - Autres charges à payer	\N	438600	f	9	other	liability	t	\N	1	\N	52051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
329	Organismes sociaux - Produits à recevoir	\N	438700	f	5	other	asset	t	\N	1	\N	52051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
330	État - Subventions à recevoir - Subventions d'investissement	\N	441100	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
331	État - Subventions à recevoir - Subventions d'exploitation	\N	441700	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
332	État - Subventions à recevoir - Subventions d'équilibre	\N	441800	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
333	État - Subventions à recevoir - Avances sur subventions	\N	441900	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
336	Créances sur l'État résultant de la suppression de la règle du décalage d'un mois en matière de TVA	\N	443100	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
337	État - Intérêts courus sur créances figurant au compte 4431	\N	443800	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
342	TVA déductible sur immobilisations	\N	445620	f	5	other	asset	f	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
343	TVA déductible transférée par d'autres entreprises	\N	445630	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
344	TVA déductible sur autres biens et services	\N	445660	f	5	other	asset	f	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
346	Taxes déductibles assimilées à la TVA	\N	445680	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
350	Acomptes - Régime simplifié d'imposition	\N	445810	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
351	Acomptes - Régime du forfait	\N	445820	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
352	Remboursement de taxes sur le chiffre d'affaires demandé	\N	445830	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
354	Taxes sur le chiffre d'affaires sur factures non parvenues	\N	445860	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
360	État - Produits à recevoir	\N	448700	f	5	other	asset	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
334	État - Impôts et taxes recouvrables sur des tiers - Obligataires	\N	442400	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
335	État - Impôts et taxes recouvrables sur des tiers - Associés	\N	442500	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
338	État - Impôts sur les bénéfices	\N	444000	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
339	 TVA due intracommunautaire	\N	445200	f	9	other	liability	f	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
340	TVA à décaisser	\N	445510	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
341	Taxes assimilées à la TVA	\N	445580	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
347	TVA collectée	\N	445710	f	9	other	liability	f	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
348	Taxes collectées assimilées à la TVA	\N	445780	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
349	Taxes sur le chiffre d'affaires à régulariser ou en attente	\N	445800	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
353	TVA récupérée d'avance	\N	445840	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
355	Taxes sur le chiffre d'affaires sur factures à établir	\N	445870	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
356	Obligations cautionnées	\N	446000	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
357	Autres impôts, taxes et versements assimilés	\N	447000	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
358	État - Charges fiscales sur congés à payer	\N	448200	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
359	État - Charges à payer	\N	448600	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
361	Quotas d'émission à restituer à l'État	\N	449000	f	9	other	liability	t	\N	1	\N	52052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
362	Groupe	\N	451000	f	9	other	liability	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
363	Associés - Comptes courants - Principal	\N	455100	f	9	other	liability	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
364	Associés - Comptes courants - Intérêts courus	\N	455800	f	9	other	liability	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
373	Associés - Dividendes à payer	\N	457000	f	9	other	liability	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
365	Associés - Comptes d'apport en société - Apports en nature	\N	456110	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
366	Associés - Comptes d'apport en société - Apports en numéraire	\N	456150	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
367	Actionnaires - Capital souscrit et appelé, non versé	\N	456210	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
368	Associés - Capital appelé, non versé	\N	456250	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
369	Associés - Versements reçus sur augmentation de capital	\N	456300	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
370	Associés - Versements anticipés	\N	456400	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
371	Actionnaires défaillants	\N	456600	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
372	Associés - Capital à rembourser	\N	456700	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
374	Associés - Opérations faites en commun et en GIE - Opérations courantes	\N	458100	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
375	Associés - Opérations faites en commun et en GIE - Intérêts courus	\N	458800	f	5	other	asset	t	\N	1	\N	52053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
376	Créances sur cessions d'immobilisations	\N	462000	f	5	other	asset	t	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
378	Créances sur cessions de valeurs mobilières de placement	\N	465000	f	5	other	asset	t	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
381	Produits à recevoir	\N	468700	f	5	other	asset	t	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
377	Dettes sur acquisitions de valeurs mobilières de placement	\N	464000	f	9	other	liability	t	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
379	Autres comptes débiteurs ou créditeurs	\N	467000	f	9	other	liability	f	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
380	Charges à payer	\N	468600	f	9	other	liability	t	\N	1	\N	52054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
382	Compte d'attente	\N	471000	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
383	 Comptes d'attente	\N	472000	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
384	 Comptes d'attente	\N	473000	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
385	 Comptes d'attente	\N	474000	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
386	 Comptes d'attente	\N	475000	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
387	Différence de conversion - Actif - Diminution des créances	\N	476100	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
388	Différence de conversion - Actif - Augmentation des dettes	\N	476200	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
389	Différence de conversion - Actif - Différences compensées par couverture de change	\N	476800	f	5	other	asset	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
390	Différences de conversion - Passif - Augmentation des créances	\N	477100	f	9	other	liability	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
391	Différences de conversion - Passif - Diminution des dettes	\N	477200	f	9	other	liability	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
392	Différences de conversion - Passif - Différences compensées par couverture de change	\N	477800	f	9	other	liability	t	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
393	Autres comptes transitoires	\N	478000	f	9	other	liability	f	\N	1	\N	52055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
394	Charges à répartir sur plusieurs exercices - Frais d'émission des emprunts	\N	481600	f	5	other	asset	t	\N	1	\N	52056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
395	Charges constatées d'avance	\N	486000	f	5	other	asset	t	\N	1	\N	52056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
397	Comptes de répartition périodique des charges	\N	488600	f	5	other	asset	t	\N	1	\N	52056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
396	Produits constatés d'avance	\N	487000	f	9	other	liability	t	\N	1	\N	52056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
398	Comptes de répartition périodique des produits	\N	488700	f	9	other	liability	t	\N	1	\N	52056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
399	Provisions pour dépréciation des comptes de clients	\N	491000	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
400	Provisions pour dépréciation des comptes du groupe	\N	495100	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
401	Provisions pour dépréciation des comptes courants des associés	\N	495500	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
402	Provisions pour dépréciation des opérations faites en commun et en GIE	\N	495800	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
403	Provisions pour dépréciation des créances sur cessions d'immobilisations	\N	496200	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
404	Provisions pour dépréciation des créances sur cessions de valeurs mobilières de placement	\N	496500	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
405	Provisions pour dépréciation - Autres comptes débiteurs	\N	496700	f	5	other	asset	t	\N	1	\N	52057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
406	Valeurs mobilières de placement - Parts dans entreprises liées	\N	501000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
407	Valeurs mobilières de placement - Actions propres	\N	502000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
408	Actons destinées à être attribuées aux employés et affectées à des plans déterminés	\N	502100	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
409	Actons disponibles pour être attribuées aux employés ou pour la régularisation des cours de la bourse	\N	502200	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
410	Valeurs mobilières de placement - Titres cotés	\N	503100	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
411	Valeurs mobilières de placement - Titres non cotés	\N	503500	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
412	Valeurs mobilières de placement - Autres titres conférant un droit de propriété	\N	504000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
413	Obligations et bons émis par la société et rachetés par elle	\N	505000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
414	Obligations cotés	\N	506100	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
415	Obligations non cotés	\N	506500	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
416	Bons du Trésor et bons de caisse à court terme	\N	507000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
417	Autres valeurs mobilières de placement	\N	508100	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
418	Bons de souscription	\N	508200	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
419	Intérêts courus sur obligations, bons et valeurs assimilées	\N	508800	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
420	Versements restant à effectuer sur valeurs mobilières de placement non libérées	\N	509000	f	3	liquidity	asset	f	\N	1	\N	53048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
421	Coupons échus à l'encaissement	\N	511100	f	3	liquidity	asset	t	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
422	Chèques à encaisser	\N	511200	f	3	liquidity	asset	t	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
423	Effets à l'encaissement	\N	511300	f	3	liquidity	asset	t	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
424	Effets à l'escompte	\N	511400	f	3	liquidity	asset	t	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
425	 Comptes en monnaie nationale	\N	512100	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
426	Banques - Comptes en devises	\N	512400	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
427	Chèques postaux	\N	514000	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
428	Caisses du Trésor et des établissements publics	\N	515000	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
429	Sociétés de bourse	\N	516000	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
430	Autres organismes financiers	\N	517000	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
431	Intérêts courus à payer	\N	518100	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
432	Intérêts courus à recevoir	\N	518800	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
433	Concours bancaires courants - Crédit de mobilisation de créances commerciales (CMCC)	\N	519100	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
434	Concours bancaires courants - Mobilisation de créances nées à l'étranger	\N	519300	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
435	Concours bancaires courants - Intérêts courus sur concours bancaires courants	\N	519800	f	3	liquidity	asset	f	\N	1	\N	53049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
436	Instruments de trésorerie	\N	520000	f	3	liquidity	asset	f	\N	1	\N	53050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
437	Caisse en monnaie nationale	\N	531100	f	3	liquidity	asset	f	\N	1	\N	53051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
438	Caisse en devises	\N	531400	f	3	liquidity	asset	f	\N	1	\N	53051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
439	Caisse succursale (ou usine) A	\N	532000	f	3	liquidity	asset	f	\N	1	\N	53051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
440	Caisse succursale (ou usine) B	\N	533000	f	3	liquidity	asset	f	\N	1	\N	53051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
441	Régies d'avances et accréditifs	\N	540000	f	3	liquidity	asset	f	\N	1	\N	53052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
442	Provisions pour dépréciation des actions	\N	590300	f	5	other	asset	f	\N	1	\N	53057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
443	Provisions pour dépréciation des autres titres conférant un droit de propriété	\N	590400	f	5	other	asset	f	\N	1	\N	53057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
444	Provisions pour dépréciation des obligations	\N	590600	f	5	other	asset	f	\N	1	\N	53057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
445	Provisions pour dépréciation des autres valeurs mobilières de placement et créances assimilées (provisions)	\N	590800	f	5	other	asset	f	\N	1	\N	53057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
446	Achats stockés - Matières premières (ou groupe) A	\N	601100	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
447	Achats stockés - matières premières (ou groupe) B	\N	601200	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
448	Achats stockés - Fournitures A, B, C, ..	\N	601700	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
449	Achats stockés - Matières consommables (ou groupe) C	\N	602110	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
450	Achats stockés - Matières consommables (ou groupe) D	\N	602120	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
451	Achats stockés - Combustibles	\N	602210	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
452	Achats stockés - Produits d'entretien	\N	602220	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
453	Achats stockés - Fournitures d'atelier et d'usine	\N	602230	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
454	Achats stockés - Fournitures de magasin	\N	602240	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
455	Achats stockés - Fournitures de bureau	\N	602250	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
456	Achats stockés - Emballages perdus	\N	602610	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
457	Achats stockés - Emballages récupérables non identifiables	\N	602650	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
458	Achats stockés - Emballages à usage mixte	\N	602670	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
459	Variation des stocks de matières premières (et fournitures)	\N	603100	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
460	Variation des stocks des autres approvisionnements	\N	603200	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
461	Variation des stocks de marchandises	\N	603700	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
462	Achats d'études et prestations de services	\N	604000	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
463	Achats de matériel équipements et travaux	\N	605000	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
464	Fournitures non stockables (eau, énergie...)	\N	606100	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
465	Fournitures d'entretien et de petit équipement	\N	606300	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
466	Fournitures administratives	\N	606400	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
467	Achats autres matières et fournitures	\N	606800	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
468	Achats de marchandises (ou groupe) A	\N	607100	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
469	Achats de marchandises (ou groupe) B	\N	607200	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
470	Frais accessoires incorporés aux achats	\N	608000	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
471	Rabais, remises et ristournes obtenus sur achats de matières premières (et fournitures)	\N	609100	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
472	Rabais, remises et ristournes obtenus sur achats d'autres approvisionnements stockés	\N	609200	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
473	Rabais, remises et ristournes obtenus sur achats d'études et prestations de services	\N	609400	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
474	Rabais, remises et ristournes obtenus sur achats de matériel, équipements et travaux	\N	609500	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
475	Rabais, remises et ristournes obtenus sur achats d'approvisionnements non stockés	\N	609600	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
476	Rabais, remises et ristournes obtenus sur achats de marchandises	\N	609700	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
477	Rabais, remises et ristournes non affectés	\N	609800	f	15	other	expense	f	\N	1	\N	54048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
478	Sous-traitance générale	\N	611000	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
479	Redevances de crédit-bail mobilier	\N	612200	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
480	Redevances de crédit-bail immobilier	\N	612500	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
481	Locations immobilières	\N	613200	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
482	Locations mobilières	\N	613500	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
483	Locations malis sur emballages	\N	613600	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
484	Charges locatives et de copropriété	\N	614000	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
485	Entretien et réparations sur biens immobiliers	\N	615200	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
486	Entretien et réparations sur biens mobiliers	\N	615500	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
487	Maintenance	\N	615600	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
488	Assurance multirisques	\N	616100	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
489	Assurance obligatoire dommage construction	\N	616200	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
490	Assurance transport sur achats	\N	616360	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
491	Assurance transport sur ventes	\N	616370	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
492	Assurance transport sur autres biens	\N	616380	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
493	Assurance risques d'exploitation	\N	616400	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
494	Assurance insolvabilité clients	\N	616500	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
495	Études et recherches	\N	617000	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
496	Documentation générale	\N	618100	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
497	Documentation technique	\N	618300	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
498	Frais de colloques, séminaires, conférences	\N	618500	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
499	Rabais, remises et ristournes obtenus sur services extérieurs	\N	619000	f	15	other	expense	f	\N	1	\N	54049	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
504	Rémunérations des transitaires	\N	622400	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
500	Personnel intérimaire	\N	621100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
501	Personnel détaché ou prêté à l'entreprise	\N	621400	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
502	Commissions et courtages sur achats	\N	622100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
503	Commissions et courtages sur ventes	\N	622200	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
505	Rémunérations d'affacturage	\N	622500	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
506	Honoraires	\N	622600	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
507	Frais d'actes et de contentieux	\N	622700	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
508	Rémunérations d'intermédiaires et honoraires - Divers	\N	622800	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
509	Annonces et insertions	\N	623100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
510	Échantillons	\N	623200	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
511	Foires et expositions	\N	623300	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
512	Cadeaux à la clientèle	\N	623400	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
513	Primes	\N	623500	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
514	Catalogues et imprimés	\N	623600	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
515	Publications	\N	623700	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
516	Publicité, publications, relations publiques - Divers (pourboires, dons courants...)	\N	623800	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
517	Transports sur achats	\N	624100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
518	Transports sur ventes	\N	624200	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
519	Transports entre établissements ou chantiers	\N	624300	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
520	Transports administratifs	\N	624400	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
521	Transports collectifs du personnel	\N	624700	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
522	Transports divers	\N	624800	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
523	Voyages et déplacements	\N	625100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
524	Frais de déménagement	\N	625500	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
525	Missions	\N	625600	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
526	Réceptions	\N	625700	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
527	Frais postaux et frais de télécommunications	\N	626000	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
528	Frais sur titres (achat, vente, garde)	\N	627100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
529	Commissions et frais sur émission d'emprunts	\N	627200	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
530	Frais sur effets	\N	627500	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
531	Location de coffres	\N	627600	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
532	Autres frais et commissions sur prestations de services	\N	627800	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
533	Concours divers (cotisations...)	\N	628100	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
534	Frais de recrutement de personnel	\N	628400	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
535	Rabais, remises et ristournes obtenus sur autres services extérieurs	\N	629000	f	15	other	expense	f	\N	1	\N	54050	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
536	Taxe sur les salaires	\N	631100	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
537	Taxe d'apprentissage	\N	631200	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
538	Participation des employeurs à la formation professionnelle continue	\N	631300	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
539	Cotisation pour défaut d'investissement obligatoire dans la construction	\N	631400	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
540	Autres impôts, taxes et versements assimilés sur rémunérations (administrations des impôts)	\N	631800	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
541	Versement de transport	\N	633100	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
542	Allocation logement	\N	633200	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
543	Participation des employeurs à la formation professionnelle continue	\N	633300	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
544	Participation des employeurs à l'effort de construction	\N	633400	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
545	Versements libératoires ouvrant droit à l'exonération de la taxe d'apprentissage	\N	633500	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
546	Autres impôts, taxes et versements assimilés sur rémunérations (autres organismes)	\N	633800	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
547	 Contribution économique territoriale	\N	635110	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
548	Taxes foncières	\N	635120	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
549	Autres impôts locaux	\N	635130	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
550	Taxe sur les véhicules des sociétés	\N	635140	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
551	Taxes sur le chiffre d'affaires non récupérables	\N	635200	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
552	Impôts indirects	\N	635300	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
553	Droits de mutation	\N	635410	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
554	Autres droits	\N	635800	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
555	Contribution sociale de solidarité à la charge des sociétés	\N	637100	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
556	Taxes perçues par les organismes publics internationaux	\N	637200	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
557	Impôts et taxes exigibles à l'étranger	\N	637400	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
558	Taxes diverses (autres organismes)	\N	637800	f	15	other	expense	f	\N	1	\N	54051	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
559	Salaires et appointements	\N	641100	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
560	Congés payés	\N	641200	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
561	Primes et gratifications	\N	641300	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
562	Indemnités et avantages divers	\N	641400	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
563	Supplément familial	\N	641500	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
564	Rémunération du travail de l'exploitant	\N	644000	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
565	Cotisations à l'URSSAF	\N	645100	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
566	Cotisations aux mutuelles	\N	645200	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
567	Cotisations aux caisses de retraites	\N	645300	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
568	Cotisations aux ASSEDIC	\N	645400	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
569	Cotisations aux autres organismes sociaux	\N	645800	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
570	Cotisations sociales personnelles de l'exploitant	\N	646000	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
571	Prestations directes	\N	647100	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
572	Versements aux comités d'entreprise et d'établissement	\N	647200	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
573	Versements aux comités d'hygiène et de sécurité	\N	647300	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
574	Versements aux autres oeuvres sociales	\N	647400	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
575	Médecine du travail, pharmacie	\N	647500	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
576	Autres charges de personnel	\N	648000	f	15	other	expense	f	\N	1	\N	54052	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
577	Redevances pour concessions brevets, licences, marques, procédés, logiciels	\N	651100	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
578	Droits d'auteur et de reproduction	\N	651600	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
579	Autres droits et valeurs similaires	\N	651800	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
580	Jetons de présence	\N	653000	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
581	Créances de l'exercice	\N	654100	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
582	Créances des exercices antérieurs	\N	654400	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
583	Quote-part de bénéfice transférée (comptabilité du gérant)	\N	655100	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
584	Quote-part de perte supportée (comptabilité des associés non gérants)	\N	655500	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
585	Charges diverses de gestion courante	\N	658000	f	15	other	expense	f	\N	1	\N	54053	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
586	Intérêts des emprunts et dettes assimilées	\N	661160	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
587	Intérêts des dettes rattachées à des participations	\N	661170	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
588	Charges de la fiducie, résultat de la période	\N	661200	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
589	Intérêts des comptes courants et des dépôts créditeurs	\N	661500	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
590	Intérêts bancaires et sur opérations de financement (escompte, ...)	\N	661600	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
591	Intérêts des obligations cautionnées	\N	661700	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
592	Intérêts des dettes commerciales	\N	661810	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
593	Intérêts des dettes diverses	\N	661880	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
594	Pertes sur créances liées à des participations	\N	664000	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
595	Escomptes accordés	\N	665000	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
596	Pertes de change	\N	666000	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
597	Charges nettes sur cessions de valeurs mobilières de placement	\N	667000	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
598	Autres charges financières	\N	668000	f	15	other	expense	f	\N	1	\N	54054	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
599	Charges exceptionnelles - Pénalités sur marchés (et dédits payés sur achats et ventes)	\N	671100	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
600	Charges exceptionnelles - Pénalités, amendes fiscales et pénales	\N	671200	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
601	Charges exceptionnelles - Dons, libéralités	\N	671300	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
602	Charges exceptionnelles - Créances devenues irrécouvrables dans l'exercice	\N	671400	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
603	Charges exceptionnelles - Subventions accordées	\N	671500	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
604	Charges exceptionnelles - Rappels d'impôts (autres qu'impôts sur les bénéfices)	\N	671700	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
605	Autres charges exceptionnelles sur opération de gestion	\N	671800	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
606	Charges exceptionnelles sur exercices antérieurs (en cours d'exercice seulement)	\N	672000	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
607	Opérations liées à la constitution de fiducie 	\N	674100	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
608	Opérations liées à la liquidation de la fiducie	\N	674200	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
609	Valeurs comptables des éléments d'actif cédés - Immobilisations incorporelles	\N	675100	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
610	Valeurs comptables des éléments d'actif cédés - Immobilisations corporelles	\N	675200	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
611	Valeurs comptables des éléments d'actif cédés - Immobilisations financières	\N	675600	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
612	Valeurs comptables des éléments d'actif cédés - Autres éléments d'actif	\N	675800	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
613	Charges exceptionnelles - Malis provenant de clauses d'indexation	\N	678100	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
614	Charges exceptionnelles - Lots	\N	678200	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
615	Charges exceptionnelles - Malis provenant du rachat par l'entreprise d'actions et obligations émises par elle-même	\N	678300	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
616	Charges exceptionnelles diverses	\N	678800	f	15	other	expense	f	\N	1	\N	54055	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
617	 Dotations aux amortissements sur immobilisations incorporelles et corporelles	\N	681100	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
618	Dotations aux amortissements sur immobilisations incorporelles	\N	681110	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
619	Dotations aux amortissements sur immobilisations corporelles	\N	681120	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
620	Dotations aux amortissements des charges d'exploitation à répartir	\N	681200	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
621	Dotations aux provisions pour risques et charges d'exploitation	\N	681500	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
622	Dotations aux dépréciations des immobilisations incorporelles	\N	681610	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
623	Dotations aux dépréciations des immobilisations corporelles	\N	681620	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
624	Dotations aux dépréciations des stocks et en-cours	\N	681730	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
625	Dotations aux dépréciations des créances	\N	681740	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
626	Dotations aux amortissements des primes de remboursement des obligations	\N	686100	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
627	Dotations aux provisions pour risques et charges financiers	\N	686500	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
628	Dotations aux dépréciations des immobilisations financières	\N	686620	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
629	Dotations aux dépréciations des valeurs mobilières de placement	\N	686650	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
630	Autres dotations aux amortissements, dépréciations et provisions - Charges financières	\N	686800	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
631	Dotations aux amortissements exceptionnels des immobilisations	\N	687100	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
632	Dotations aux provisions réglementées exceptionnelles (immobilisations) - Amortissements dérogatoires	\N	687250	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
633	Dotations aux provisions réglementées exceptionnelles (stocks)	\N	687300	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
634	Dotations aux autres provisions réglementées exceptionnelles	\N	687400	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
635	Dotations aux provisions exceptionnelles	\N	687500	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
636	Dotations aux dépréciations exceptionnelles	\N	687600	f	15	other	expense	f	\N	1	\N	54056	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
637	Participation des salariés aux résultats	\N	691000	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
638	Impôts sur les bénéfices dus en France	\N	695100	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
639	Contribution additionnelle à l'impôt sur les bénéfices	\N	695200	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
640	Impôts sur les bénéfices dus à l'étranger	\N	695400	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
641	Supplément d'impôt sur les sociétés lié aux distributions	\N	696000	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
642	Intégration fiscale - Charges	\N	698100	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
643	Intégration fiscale - Produits	\N	698900	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
644	Produits, Reports en arrière des déficits	\N	699000	f	15	other	expense	f	\N	1	\N	54057	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
645	Ventes de produits finis (ou groupe) A	\N	701100	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
646	Ventes de produits finis (ou groupe) B	\N	701200	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
647	Ventes de produits intermédiaires	\N	702000	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
648	Ventes de produits résiduels	\N	703000	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
649	Ventes de travaux de catégorie (ou activité) A	\N	704100	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
650	Ventes de travaux de catégorie (ou activité) B	\N	704200	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
651	Ventes d'études	\N	705000	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
652	Ventes de prestations de services	\N	706000	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
653	Ventes de marchandises (ou groupe) A	\N	707100	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
654	Ventes de marchandises (ou groupe) B	\N	707200	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
655	Produits des services exploités dans l'intérêt du personnel	\N	708100	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
656	Commissions et courtages	\N	708200	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
657	Locations diverses	\N	708300	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
658	Mise à disposition de personnel facturée	\N	708400	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
659	Ports et frais accessoires facturés	\N	708500	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
660	Bonis sur reprises d'emballages consignés	\N	708600	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
661	Bonifications obtenues des clients et primes sur ventes	\N	708700	f	13	other	income	f	\N	1	\N	55048	1	2020-11-04 10:36:05.40614	1	2020-11-04 10:36:05.40614
662	Autres produits d'activités annexes (cessions d'approv