﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Linq
{
    delegate void RequeteLinq();
    public partial class Fm_principal : Form
    {
        private Modele bd;
        private List<RequeteLinq> lesRequetes;
        public Fm_principal()
        {
            InitializeComponent();
            bd = new Modele();
            lesRequetes = new List<RequeteLinq>();
            listerRequetes();
        }
        private void listerRequetes()
        {
            cb_requete.Items.Add("requete0 : nom des employés");
            lesRequetes.Add(requete0);
            cb_requete.Items.Add("requete1 : nom et prénom des employés");
            lesRequetes.Add(requete1);
            cb_requete.Items.Add("requete2 : service des employés");
            lesRequetes.Add(requete2);
            cb_requete.Items.Add("requete3 : nom et service des employés");
            lesRequetes.Add(requete3);
            cb_requete.Items.Add("requete4 : nom et service des employés avec un type anonyme");
            lesRequetes.Add(requete4);
            cb_requete.Items.Add("requete5 : nom et prénom des employés masculins");
            lesRequetes.Add(requete5);
            cb_requete.Items.Add("requete6 : employés masculins gagnant plus de 3000 euros");
            lesRequetes.Add(requete6);
            cb_requete.Items.Add("requete7 : employés du service commercial");
            lesRequetes.Add(requete7);
            cb_requete.Items.Add("requete8 : employés cadres");
            lesRequetes.Add(requete8);
            cb_requete.Items.Add("requete9 : employés dont le nom contient 'du'");
            lesRequetes.Add(requete9);
            cb_requete.Items.Add("requete10 : employés travaillant dans un atelier");
            lesRequetes.Add(requete10);
            cb_requete.Items.Add("requete11 : services productifs");
            lesRequetes.Add(requete11);
            cb_requete.Items.Add("requete12 : employés masculins triés par nom");
            lesRequetes.Add(requete12);
            cb_requete.Items.Add("requete13 : employés triés par longueur de prénom");
            lesRequetes.Add(requete13);
            cb_requete.Items.Add("requete14 : employés triés par sexe et prénom");
            lesRequetes.Add(requete14);
            cb_requete.Items.Add("requete15 : nombre d'employés");
            lesRequetes.Add(requete15);
            cb_requete.Items.Add("requete16 : nombre de cadres");
            lesRequetes.Add(requete16);
            cb_requete.Items.Add("requete17 : salaire maximum, plus petit nom et salaire moyen");
            lesRequetes.Add(requete17);
            cb_requete.Items.Add("requete18 : masse salariale des cadres");
            lesRequetes.Add(requete18);
            cb_requete.Items.Add("requete19 : effectif par diplômes");
            lesRequetes.Add(requete19);
            cb_requete.Items.Add("requete20 : jointure employé-service");
            lesRequetes.Add(requete20);
            cb_requete.Items.Add("requete21 : jointure employé-service avec sélection");
            lesRequetes.Add(requete21);
            cb_requete.Items.Add("requete22 : jointure employé-diplôme");
            lesRequetes.Add(requete22);
            cb_requete.Items.Add("requete23 : jointure employé-diplôme avec sélection");
            lesRequetes.Add(requete23);
            cb_requete.Items.Add("requete24 : effectif des services");
            lesRequetes.Add(requete24);
            cb_requete.Items.Add("requete25 : salaire moyen des services");
            lesRequetes.Add(requete25);
            cb_requete.Items.Add("requete26 : salaire moyen par service et statut");
            lesRequetes.Add(requete26);
            cb_requete.Items.Add("requete27 : salaire maximum des employés masculins par service employant plus d'un homme");
            lesRequetes.Add(requete27);
            cb_requete.Items.Add("requete28 : employés gagnant plus que l'employé n°1");
            lesRequetes.Add(requete28);
            cb_requete.Items.Add("requete29 : employés gagnant plus que l'employé n°1, version 2");
            lesRequetes.Add(requete29);
            cb_requete.Items.Add("requete30 : employés gagnant plus que la moyenne des salaires du service n°1");
            lesRequetes.Add(requete30);
            cb_requete.Items.Add("requete31 : employés gagnant plus que la moyenne des salaires du service n°1, version 2");
            lesRequetes.Add(requete31);
            cb_requete.Items.Add("requete32 : employés gagnant plus que la moyenne des salaires de leur service");
            lesRequetes.Add(requete32);
            cb_requete.Items.Add("requete33 : services employant des salariés non diplômés");
            lesRequetes.Add(requete33);
            cb_requete.Items.Add("requete34 : services et employés, affichage des diplômes pour les cadres d'un service administratif");
            lesRequetes.Add(requete34);
            cb_requete.Items.Add("requete35 : effectif des services, version group join");
            lesRequetes.Add(requete35);
            cb_requete.Items.Add("requete36 : employés masculins d'un service productif");
            lesRequetes.Add(requete36);
            cb_requete.Items.Add("requete37 : employés gagnant plus que l'employé n°1, enchainement de requêtes");
            lesRequetes.Add(requete37);
            cb_requete.Items.Add("requete38 : employés de sexe féminin ou travaillant dans un atelier");
            lesRequetes.Add(requete38);
        }
        private void bt_ok_Click(object sender, EventArgs e)
        {
            if (cb_requete.SelectedIndex != -1)
            {
                tb_resultat.Clear();
                lesRequetes[cb_requete.SelectedIndex]();
            }
        }
        private void requete0()
        {
            var req =
                from emp in bd.Employe
                select emp.emp_nom;
            foreach (string s in req)
            {
                tb_resultat.AppendText(s);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete1()
        {
            var req =
                from emp in bd.Employe
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete2()
        {
            var req =
                from emp in bd.Employe
                select emp.LeService;
            foreach (Service s in req.Distinct())
            {
                tb_resultat.AppendText(s.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete3()
        {
            var req =
                from emp in bd.Employe.Include("LeService")
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.LeService.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete4()
        {
            var req =
                from emp in bd.Employe
                select new { LeNom = emp.emp_nom, LaDesignation = emp.LeService.ser_designation };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeNom + " " + res.LaDesignation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete5()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_sexe == "M"
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete6()
        {
            var req =
                from emp in bd.Employe
                where (emp.emp_sexe == "M") && (emp.emp_salaire > 3000)
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom + " " + e.emp_salaire.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete7()
        {
            var req =
                from emp in bd.Employe
                where emp.LeService.ser_designation == "Commercial"
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete8()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_cadre.Value // ou emp.emp_cadre == true
                orderby emp.emp_nom
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete9()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_nom.Contains("du") // ou SubString, StartWith, etc...
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete10()
        {
            var req =
                from emp in bd.Employe
                where emp.LeService.ser_designation.StartsWith("Atelier")
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete11()
        {
            var req =
                from sce in bd.Service.OfType<SceProductif>()
                select sce;
            foreach (SceProductif s in req)
            {
                tb_resultat.AppendText(s.ser_designation + " " + s.ser_produit);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete12()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_sexe == "M"
                orderby emp.emp_nom ascending
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_sexe + " " + e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete13()
        {
            var req =
                from emp in bd.Employe
                orderby emp.emp_prenom.Length ascending
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_prenom + " " + e.emp_nom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete14()
        {
            var req =
                from emp in bd.Employe
                orderby emp.emp_sexe ascending, emp.emp_prenom descending
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_sexe + " " + e.emp_prenom + " " + e.emp_nom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete15()
        {
            int nb = bd.Employe.Count();
            tb_resultat.AppendText("Nombre d'employés : " + nb.ToString());
            tb_resultat.AppendText(Environment.NewLine);
        }
        private void requete16()
        {
            int nb = bd.Employe.Count(emp => emp.emp_cadre == true);
            tb_resultat.AppendText("Nombre de cadres : " + nb.ToString());
            tb_resultat.AppendText(Environment.NewLine);
        }
        private void requete17()
        {
            decimal maxSalaire = (decimal)bd.Employe.Max(emp => emp.emp_salaire);
            tb_resultat.AppendText("Salaire maximum : " + maxSalaire.ToString());
            tb_resultat.AppendText(Environment.NewLine);
            string minNom = bd.Employe.Min(emp => emp.emp_nom);
            tb_resultat.AppendText("Plus petit nom : " + minNom);
            tb_resultat.AppendText(Environment.NewLine);
            decimal avgSalaire = (decimal)bd.Employe.Average(emp => emp.emp_salaire);
            tb_resultat.AppendText("Salaire moyen : " + avgSalaire.ToString());
            tb_resultat.AppendText(Environment.NewLine);
        }
        private void requete18()
        {
            decimal maxSalaire = (decimal)bd.Employe.Where(emp => emp.emp_cadre == true).Sum(emp => emp.emp_salaire);
            tb_resultat.AppendText("Masse salariale des cadres : " + maxSalaire.ToString());
            tb_resultat.AppendText(Environment.NewLine);
        }
        private void requete19()
        {
            var req =
                from dip in bd.Diplome
                select new { LeDiplome = dip, Effectif = dip.LesEmployes.Count };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeDiplome.dip_libelle + " : " + res.Effectif.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete20()
        {
            var req =
                from emp in bd.Employe
                join sce in bd.Service on emp.LeService equals sce
                select new { LeService = sce, LeEmploye = emp };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeEmploye.emp_nom + " " + res.LeService.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete21()
        {
            var req =
                from emp in bd.Employe
                join sce in bd.Service on emp.LeService equals sce
                where sce.ser_designation.StartsWith("Atelier") && emp.emp_cadre==true
                select new { LeService = sce, LeEmploye = emp };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeEmploye.emp_nom + " " + res.LeService.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete22()
        {
            var req =
                from emp in bd.Employe
                from dip in emp.LesDiplomes
                orderby emp.emp_nom ascending
                select new { LeEmploye = emp, LeDiplome = dip };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeEmploye.emp_nom + " " + res.LeDiplome.dip_libelle);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete23()
        {
            var req =
                from dip in bd.Diplome
                where dip.dip_libelle == "Bts" // condition sur le diplôme
                from emp in dip.LesEmployes
                where emp.emp_nom.StartsWith("du") // condition sur l'employé
                select new { LeEmploye = emp, LeDiplome = dip };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeEmploye.emp_nom + " " + res.LeDiplome.dip_libelle);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete24()
        {
            var req =
                from emp in bd.Employe
                group emp by emp.LeService into groupeService
                select new { DesService = groupeService.Key.ser_designation, Nb = groupeService.Count() };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.DesService + " : " + res.Nb.ToString() + " employés");
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete25()
        {
            var req =
                from emp in bd.Employe
                group emp by emp.LeService into groupeService
                select new { 
                    DesService = groupeService.Key.ser_designation, 
                    SalaireMoyen = groupeService.Average(emp2 => emp2.emp_salaire) 
                };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.DesService + " : " + res.SalaireMoyen.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete26()
        {
            var req =
                from emp in bd.Employe
                group emp by new { LeService = emp.LeService, LeStatut = emp.emp_cadre } into groupe
                select new
                {
                    DesService=groupe.Key.LeService.ser_designation,
                    Statut=groupe.Key.LeStatut,
                    SalaireMoyen=groupe.Average(emp2 => emp2.emp_salaire)
                };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.DesService + ", " + res.Statut.ToString() + " : " + res.SalaireMoyen.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete27()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_sexe == "M"
                group emp by emp.LeService into groupeService
                where groupeService.Count() >= 2
                select new
                {
                    DesService = groupeService.Key.ser_designation,
                    SalaireMaximum = groupeService.Max(emp2 => emp2.emp_salaire)
                };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.DesService + " : " + res.SalaireMaximum.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete28()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_salaire > 
                    (from empRef in bd.Employe where empRef.emp_id == 1 select empRef.emp_salaire).FirstOrDefault()
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom + " : " + e.emp_salaire.ToString());
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete29()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_salaire > bd.Employe.FirstOrDefault(emp2 => emp2.emp_id == 1).emp_salaire
                select emp;
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.emp_nom + " " + res.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete30()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_salaire > 
                    (from sce in bd.Service 
                     where sce.ser_id == 1 
                     select sce.LesEmployes.Average(emp2 => emp2.emp_salaire)).FirstOrDefault()
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete31()
        {
            var req =
                from sce in bd.Service
                where sce.ser_id == 1
                from emp in bd.Employe
                where emp.emp_salaire > sce.LesEmployes.Average(emp2 => emp2.emp_salaire)
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete32()
        {
            var req =
                from emp in bd.Employe
                where emp.emp_salaire > emp.LeService.LesEmployes.Average(emp2 => emp2.emp_salaire)
                select emp;
            foreach (Employe e in req)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete33()
        {
            var req =
                from emp in bd.Employe
                where emp.LesDiplomes.Count == 0
                select emp.LeService;
            foreach (Service s in req.Distinct())
            {
                tb_resultat.AppendText(s.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete34()
        {
            var req =
                from sce in bd.Service
                select sce;
            foreach (Service s in req.ToList())
            {
                tb_resultat.AppendText(s.ser_designation);
                tb_resultat.AppendText(Environment.NewLine);
                if (!s.LesEmployes.IsLoaded)
                {
                    try
                    {
                        s.LesEmployes.Load();
                    }
                    catch (Exception pb)
                    {
                        MessageBox.Show(pb.ToString());
                    }
                }
                foreach (Employe e in s.LesEmployes)
                {
                    tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                    tb_resultat.AppendText(Environment.NewLine);
                    if (s.GetType() == typeof(SceAdministratif) && e.emp_cadre == true)
                    {
                        if (!e.LesDiplomes.IsLoaded)
                        {
                            e.LesDiplomes.Load();
                        }
                        foreach (Diplome d in e.LesDiplomes)
                        {
                            tb_resultat.AppendText(d.dip_libelle);
                            tb_resultat.AppendText(Environment.NewLine);
                        }
                    }
                }
            }
        }
        private void requete35()
        {
            var req =
            from sce in bd.Service
            join emp in bd.Employe on sce equals emp.LeService into LesSalaries
            select new { LeService = sce, LesAffectes = LesSalaries };
            foreach (var res in req)
            {
                tb_resultat.AppendText(res.LeService.ser_designation + ":" + res.LesAffectes.Count() + " employés");
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete36()
        {
            var req1 =
                from emp in bd.Employe
                join sce in bd.Service.OfType<SceProductif>() on emp.LeService equals sce
                select emp;
            var req2 =
                from emp in req1
                where emp.emp_sexe == "M"
                select emp;
            foreach (Employe e in req2)
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete37()
        {
            var req1 =
                from emp in bd.Employe
                where emp.emp_id == 1
                select emp.emp_salaire;
            var req2 =
                from emp2 in bd.Employe
                where emp2.emp_salaire > req1.FirstOrDefault()
                select emp2;
            foreach (Employe e in req2)
            {
                tb_resultat.AppendText(e.emp_nom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
        private void requete38()
        {
            var req1 =
                from emp in bd.Employe
                where emp.emp_sexe == "F"
                select emp;
            var req2 =
                from emp in bd.Employe
                join sce in bd.Service on emp.LeService equals sce
                where sce.ser_designation.StartsWith("Atelier")
                select emp;
            foreach (Employe e in req1.Union(req2))
            {
                tb_resultat.AppendText(e.emp_nom + " " + e.emp_prenom);
                tb_resultat.AppendText(Environment.NewLine);
            }
        }
    }
}
