﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace LiaisonDonnees
{
    public class Service
    {
        private int id;
        public int Id
        {
            get { return id; }
            set { id = value; }
        }
        private string designation;
        public string Designation
        {
            get { return designation; }
            set { designation = value; }
        }
        private List<Employe> lesEmployes;
        public List<Employe> LesEmployes
        {
            get { return lesEmployes; }
            set { lesEmployes = value; }
        }
        public Service This
        {
            get { return this; }
        }
        private static int dernierId = 0;
        public Service(string p_designation)
        {
            dernierId++;
            id = dernierId;
            designation = p_designation;
            lesEmployes = new List<Employe>();
        }
        public Service()
        {
            dernierId++;
            id = dernierId;
            lesEmployes = new List<Employe>();
        }
        public Service(XmlElement x_service)
        {
            XmlAttribute x_attr;
            x_attr = x_service.Attributes[0];
            id = int.Parse(x_attr.Value);
            if (id > dernierId)
            {
                dernierId = id;
            }
            designation = x_service.ChildNodes[0].InnerText;
            lesEmployes = new List<Employe>();
        }
        public override string ToString()
        {
            return designation;
        }
        public void PreparerSuppression()
        {
            foreach (Employe leEmploye in lesEmployes)
            {
                leEmploye.SupprimerService();
            }
        }
        public XmlElement MajElementXml(XmlDocument x_doc, XmlElement x_lesServices)
        {
            XmlElement x_elt;
            XmlAttribute x_attr;
            XmlElement x_service = x_doc.CreateElement("service");
            x_lesServices.AppendChild(x_service);
            x_attr = x_doc.CreateAttribute("id");
            x_attr.Value = id.ToString();
            x_service.Attributes.Append(x_attr);
            x_elt = x_doc.CreateElement("designation");
            x_elt.InnerText = designation;
            x_service.AppendChild(x_elt);
            return x_lesServices;
        }
    }
}
