﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LiaisonDonnees
{
    public partial class Fm_service : Form
    {
        private Donnees bd;
        public Fm_service(Donnees p_bd)
        {
            InitializeComponent();
            bd = p_bd;
            bs.CurrentChanged += new EventHandler(bs_CurrentChanged);
            bs.DataSource = bd.GetServices();
            tb_id.DataBindings.Add("Text", bs, "Id");
            tb_designation.DataBindings.Add("Text", bs, "Designation");
            bn.BindingSource = bs;
        }

        void bs_CurrentChanged(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                bs_employes.DataSource = ((Service)bs.Current).LesEmployes;
            }
            else
            {
                bs_employes.DataSource = null;
            }
        }

        private void Fm_service_FormClosing(object sender, FormClosingEventArgs e)
        {
            bs.EndEdit();
        }

        private void bindingNavigatorDeleteItem_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Service leService = (Service)bs.Current;
                leService.PreparerSuppression();
                bs.RemoveCurrent();
            }
        }

        private void enregistrerToolStripButton_Click(object sender, EventArgs e)
        {
            bs.EndEdit();
            bd.Sauver();
        }
    }
}
