﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LiaisonDonnees
{
    public partial class Fm_employe : Form
    {
        private Donnees bd;
        public Fm_employe(Donnees p_bd)
        {
            InitializeComponent();
            bd = p_bd;
            cb_service.DataSource = bd.GetServices();
            bs.CurrentChanged += new EventHandler(bs_CurrentChanged);
            bs.DataSource = bd.GetEmployes();
        }

        void bs_CurrentChanged(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Employe leEmploye = (Employe)bs.Current;
                if (leEmploye.Sexe == 'F')
                {
                    rb_feminin.Checked = true;
                }
                else
                {
                    rb_masculin.Checked = true;
                }
                if (leEmploye.LeService == null)
                {
                    cb_service.SelectedIndex = -1;
                }
                bs_diplomesPossedes.DataSource = leEmploye.LesDiplomes;
                bs_autresDiplomes.DataSource = bd.GetDiplomes().Except(leEmploye.LesDiplomes);
            }
            else
            {
                bs_diplomesPossedes.DataSource = null;
                bs_autresDiplomes.DataSource = bd.GetDiplomes();
            }
        }

        private void rb_sexe_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Employe leEmploye = (Employe)bs.Current;
                if (rb_feminin.Checked)
                {
                    leEmploye.Sexe = 'F';
                }
                else
                {
                    leEmploye.Sexe = 'M';
                }
            }
        }

        private void Fm_employe_FormClosing(object sender, FormClosingEventArgs e)
        {
            bs.EndEdit();
        }

        private void bindingNavigatorDeleteItem_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Employe leEmploye = (Employe)bs.Current;
                leEmploye.PreparerSuppression();
                bs.RemoveCurrent();
            }
        }

        private void bt_versDiplomesPossedes_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                if (lb_autresDiplomes.SelectedIndex != -1)
                {
                    Employe leEmploye = (Employe)bs.Current;
                    Diplome leDiplome = (Diplome)bs_autresDiplomes.Current;
                    leEmploye.AjouterDiplome(leDiplome);
                    bs_diplomesPossedes.ResetBindings(false);
                    bs_autresDiplomes.Remove(leDiplome);
                }
            }
        }
        private void bt_versAutresDiplomes_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                if (lb_diplomesPossedes.SelectedIndex != -1)
                {
                    Employe leEmploye = (Employe)bs.Current;
                    Diplome leDiplome = (Diplome)bs_diplomesPossedes.Current;
                    leEmploye.SupprimerDiplome(leDiplome, true);
                    bs_diplomesPossedes.ResetBindings(false);
                    bs_autresDiplomes.Add(leDiplome);
                }
            }
        }

        private void employeBindingNavigatorSaveItem_Click(object sender, EventArgs e)
        {
            bs.EndEdit();
            bd.Sauver();
        }
    }
}
