﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace LiaisonDonnees
{
    public class Employe
    {
        private int id;
        public int Id
        {
            get { return id; }
            set { id = value; }
        }
        private string nom;
        public string Nom
        {
            get { return nom; }
            set { nom = value; }
        }
        private string prenom;
        public string Prenom
        {
            get { return prenom; }
            set { prenom = value; }
        }
        private char sexe;
        public char Sexe
        {
            get { return sexe; }
            set { sexe = value; }
        }
        public string StrSexe
        {
            get { return sexe.ToString(); }
            set { sexe = value[0]; }
        }
        private bool cadre;
        public bool Cadre
        {
            get { return cadre; }
            set { cadre = value; }
        }
        private decimal salaire;
        public decimal Salaire
        {
            get { return salaire; }
            set { salaire = value; }
        }
        private Service leService;
        public Service LeService
        {
            get { return leService; }
            set
            {
                if (leService != null)
                {
                    leService.LesEmployes.Remove(this);
                }
                leService = value;
                if (leService != null)
                {
                    leService.LesEmployes.Add(this);
                }
            }
        }
        private List<Diplome> lesDiplomes;
        public List<Diplome> LesDiplomes
        {
            get { return lesDiplomes; }
            set { lesDiplomes = value; }
        }
        private static int dernierId = 0;
        public Employe(string p_nom, string p_prenom, char p_sexe, bool p_cadre, decimal p_salaire)
        {
            dernierId++;
            id = dernierId;
            nom = p_nom;
            prenom = p_prenom;
            sexe = p_sexe;
            cadre = p_cadre;
            salaire = p_salaire;
            lesDiplomes = new List<Diplome>();
        }
        public Employe()
        {
            dernierId++;
            id = dernierId;
            sexe = 'F';
            lesDiplomes = new List<Diplome>();
        }
        public Employe(XmlElement x_employe, Donnees bd)
        {
            XmlAttribute x_attr;
            x_attr = x_employe.Attributes[0];
            id = int.Parse(x_attr.Value);
            if (id > dernierId)
            {
                dernierId = id;
            }
            nom = x_employe.ChildNodes[0].InnerText;
            prenom = x_employe.ChildNodes[1].InnerText;
            sexe = x_employe.ChildNodes[2].InnerText[0];
            cadre = bool.Parse(x_employe.ChildNodes[3].InnerText);
            salaire = decimal.Parse(x_employe.ChildNodes[4].InnerText);
            if (x_employe.ChildNodes[5].InnerText != "")
            {
                int idService = int.Parse(x_employe.ChildNodes[5].InnerText);
                LeService = bd.GetServiceParId(idService);
                // Utilisation de LINQ
                // var requeteService = from sce in bd.GetServices() where sce.Id == idService select sce;
                // LeService = requeteService.First();
            }
            else
            {
                leService = null;
            }
            lesDiplomes = new List<Diplome>();
            int idDiplome;
            foreach (XmlElement x_diplome in x_employe.ChildNodes[6])
            {
                idDiplome = int.Parse(x_diplome.ChildNodes[0].InnerText);
                AjouterDiplome(bd.GetDiplomeParId(idDiplome));
                // Utilisation de LINQ
                // var requeteDiplome = from leBonDiplome in bd.GetDiplomes() where leBonDiplome.Id == idDiplome select leBonDiplome;
                // AjouterDiplome(requeteDiplome.First());
            }
        }
        public override string ToString()
        {
            return nom + " " + prenom;
        }
        public void AjouterDiplome(Diplome p_diplome)
        {
            LesDiplomes.Add(p_diplome);
            p_diplome.LesEmployes.Add(this);
        }
        public void SupprimerDiplome(Diplome p_diplome, bool majDiplome)
        {
            LesDiplomes.Remove(p_diplome);
            if (majDiplome)
            {
                p_diplome.LesEmployes.Remove(this);
            }
        }
        public void SupprimerService()
        {
            leService = null;
        }
        public void PreparerSuppression()
        {
            LeService = null;
            foreach (Diplome leDiplome in lesDiplomes)
            {
                leDiplome.LesEmployes.Remove(this);
            }
        }
        public XmlElement MajElementXml(XmlDocument x_doc, XmlElement x_lesEmployes)
        {
            XmlElement x_elt;
            XmlAttribute x_attr;
            XmlElement x_employe = x_doc.CreateElement("employe");
            x_lesEmployes.AppendChild(x_employe);
            x_attr = x_doc.CreateAttribute("id");
            x_attr.Value = id.ToString();
            x_employe.Attributes.Append(x_attr);
            x_elt = x_doc.CreateElement("nom");
            x_elt.InnerText = nom;
            x_employe.AppendChild(x_elt);
            x_elt = x_doc.CreateElement("prenom");
            x_elt.InnerText = prenom;
            x_employe.AppendChild(x_elt);
            x_elt = x_doc.CreateElement("sexe");
            x_elt.InnerText = sexe.ToString();
            x_employe.AppendChild(x_elt);
            x_elt = x_doc.CreateElement("cadre");
            x_elt.InnerText = cadre.ToString();
            x_employe.AppendChild(x_elt);
            x_elt = x_doc.CreateElement("salaire");
            x_elt.InnerText = salaire.ToString();
            x_employe.AppendChild(x_elt);
            x_elt = x_doc.CreateElement("service");
            if (leService != null)
            {
                x_elt.InnerText = leService.Id.ToString();
            }
            x_employe.AppendChild(x_elt);
            XmlElement x_diplomes = x_doc.CreateElement("diplomes");
            x_employe.AppendChild(x_diplomes);
            foreach (Diplome unDiplome in lesDiplomes)
            {
                x_elt = x_doc.CreateElement("id");
                x_elt.InnerText = unDiplome.Id.ToString();
                x_diplomes.AppendChild(x_elt);
            }
            return x_lesEmployes;
        }
    }
}
