﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace LiaisonDonnees
{
    public class Donnees
    {
        private List<Service> lesServices;
        private List<Employe> lesEmployes;
        private List<Diplome> lesDiplomes;
        public Donnees()
        {
            lesServices = new List<Service>();
            lesEmployes = new List<Employe>();
            lesDiplomes = new List<Diplome>();
        }
        public void Charger()
        {
            XmlDocument x_doc = new XmlDocument();
            x_doc.Load("donnees.xml");
            XmlElement x_liste;
            x_liste = (XmlElement)x_doc.ChildNodes[0].ChildNodes[0];
            Service unService;
            foreach (XmlElement x_service in x_liste)
            {
                unService = new Service(x_service);
                lesServices.Add(unService);
            }
            x_liste = (XmlElement)x_doc.ChildNodes[0].ChildNodes[1];
            Diplome unDiplome;
            foreach (XmlElement x_diplome in x_liste)
            {
                unDiplome = new Diplome(x_diplome);
                lesDiplomes.Add(unDiplome);
            }
            x_liste = (XmlElement)x_doc.ChildNodes[0].ChildNodes[2];
            Employe unEmploye;
            foreach (XmlElement x_employe in x_liste)
            {
                unEmploye = new Employe(x_employe, this);
                lesEmployes.Add(unEmploye);
            }
        }
        //public void Charger()
        //{
        //    Employe unEmploye;
        //    lesServices.Add(new Service("Fabrication"));
        //    lesServices.Add(new Service("Expédition"));
        //    lesServices.Add(new Service("Compabilité"));
        //    lesDiplomes.Add(new Diplome("BAC"));
        //    lesDiplomes.Add(new Diplome("BTS"));
        //    lesDiplomes.Add(new Diplome("Licence"));
        //    unEmploye = new Employe("Dupont", "Paul", 'M', true, 10000);
        //    unEmploye.LeService = lesServices[0];
        //    unEmploye.AjouterDiplome(lesDiplomes[0]);
        //    lesEmployes.Add(unEmploye);
        //    unEmploye = new Employe("Durand", "Alice", 'F', true, 8000);
        //    unEmploye.LeService = lesServices[0];
        //    unEmploye.AjouterDiplome(lesDiplomes[0]);
        //    lesEmployes.Add(unEmploye);
        //    unEmploye = new Employe("Dubois", "Jean", 'M', false, 5000);
        //    unEmploye.LeService = lesServices[1];
        //    unEmploye.AjouterDiplome(lesDiplomes[0]);
        //    unEmploye.AjouterDiplome(lesDiplomes[1]);
        //    lesEmployes.Add(unEmploye);
        //    unEmploye = new Employe("Martin", "Paul", 'M', true, 10000);
        //    unEmploye.LeService = lesServices[1];
        //    unEmploye.AjouterDiplome(lesDiplomes[0]);
        //    unEmploye.AjouterDiplome(lesDiplomes[1]);
        //    lesEmployes.Add(unEmploye);
        //    unEmploye = new Employe("Louvel", "Alice", 'F', true, 8000);
        //    unEmploye.LeService = lesServices[1];
        //    unEmploye.AjouterDiplome(lesDiplomes[0]);
        //    unEmploye.AjouterDiplome(lesDiplomes[1]);
        //    unEmploye.AjouterDiplome(lesDiplomes[2]);
        //    lesEmployes.Add(unEmploye);
        //    unEmploye = new Employe("Bauret", "Thierry", 'M', false, 5000);
        //    unEmploye.LeService = lesServices[2];
        //    unEmploye.AjouterDiplome(lesDiplomes[2]);
        //    lesEmployes.Add(unEmploye);
        //}
        public void Sauver()
        {
            XmlDocument x_doc = new XmlDocument();
            XmlElement x_racine, x_liste;
            x_racine = x_doc.CreateElement("donnees");
            x_doc.AppendChild(x_racine);
            x_liste = x_doc.CreateElement("services");
            x_racine.AppendChild(x_liste);
            foreach (Service unService in lesServices)
            {
                unService.MajElementXml(x_doc, x_liste);
            }
            x_liste = x_doc.CreateElement("diplomes");
            x_racine.AppendChild(x_liste);
            foreach (Diplome unDiplome in lesDiplomes)
            {
                unDiplome.MajElementXml(x_doc, x_liste);
            }
            x_liste = x_doc.CreateElement("employes");
            x_racine.AppendChild(x_liste);
            foreach (Employe unEmploye in lesEmployes)
            {
                unEmploye.MajElementXml(x_doc, x_liste);
            }
            x_doc.Save("donnees.xml");
        }
        public List<Service> GetServices()
        {
            return lesServices;
        }
        public List<Employe> GetEmployes()
        {
            return lesEmployes;
        }
        public List<Diplome> GetDiplomes()
        {
            return lesDiplomes;
        }
        public Service GetServiceParId(int p_id)
        {
            // Attention, sortie prématurée de la boucle "foreach" dès que le service est trouvé
            foreach (Service unService in lesServices)
            {
                if (unService.Id == p_id)
                {
                    return unService;
                }
            }
            return null;
        }
        public Diplome GetDiplomeParId(int p_id)
        {
            // Attention, sortie prématurée de la boucle "foreach" dès que le diplôme est trouvé
            foreach (Diplome unDiplome in lesDiplomes)
            {
                if (unDiplome.Id == p_id)
                {
                    return unDiplome;
                }
            }
            return null;
        }
    }
}
