﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace LiaisonDonnees
{
    public class Diplome
    {
        private int id;
        public int Id
        {
            get { return id; }
            set { id = value; }
        }
        private string libelle;
        public string Libelle
        {
            get { return libelle; }
            set { libelle = value; }
        }
        private List<Employe> lesEmployes;
        public List<Employe> LesEmployes
        {
            get { return lesEmployes; }
            set { lesEmployes = value; }
        }
        private static int dernierId = 0;
        public Diplome(string p_libelle)
        {
            dernierId++;
            id = dernierId;
            libelle = p_libelle;
            lesEmployes = new List<Employe>();
        }
        public Diplome()
        {
            dernierId++;
            id = dernierId;
            lesEmployes = new List<Employe>();
        }
        public Diplome(XmlElement x_diplome)
        {
            XmlAttribute x_attr;
            x_attr = x_diplome.Attributes[0];
            id = int.Parse(x_attr.Value);
            if (id > dernierId)
            {
                dernierId = id;
            }
            libelle = x_diplome.ChildNodes[0].InnerText;
            lesEmployes = new List<Employe>();
        }
        public override string ToString()
        {
            return libelle;
        }
        public void PreparerSuppression()
        {
            foreach (Employe leEmploye in lesEmployes)
            {
                leEmploye.SupprimerDiplome(this, false);
            }
        }
        public XmlElement MajElementXml(XmlDocument x_doc, XmlElement x_lesDiplomes)
        {
            XmlElement x_elt;
            XmlAttribute x_attr;
            XmlElement x_diplome = x_doc.CreateElement("diplome");
            x_lesDiplomes.AppendChild(x_diplome);
            x_attr = x_doc.CreateAttribute("id");
            x_attr.Value = id.ToString();
            x_diplome.Attributes.Append(x_attr);
            x_elt = x_doc.CreateElement("libelle");
            x_elt.InnerText = libelle;
            x_diplome.AppendChild(x_elt);
            return x_lesDiplomes;
        }
    }
}
