﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EntityFramework
{
    public partial class Service
    {
        public string Produit
        {
            get
            {
                if (GetType() == typeof(SceProductif))
                {
                    return ((SceProductif)this).ser_produit;
                }
                else
                {
                    return null;
                }
            }
            set
            {
                if (GetType() == typeof(SceProductif))
                {
                    ((SceProductif)this).ser_produit = value;
                }
            }
        }
        public int Capacite
        {
            get
            {
                if (GetType() == typeof(SceProductif))
                {
                    if (((SceProductif)this).ser_capacite != null) // Value n'est pas accessible si null
                    {
                        return ((SceProductif)this).ser_capacite.Value;
                    }
                }
                return 0;
            }
            set
            {
                if (GetType() == typeof(SceProductif))
                {
                    ((SceProductif)this).ser_capacite = value;
                }
            }
        }
        public decimal Budget
        {
            get
            {
                if (GetType() == typeof(SceAdministratif))
                {
                    if (((SceAdministratif)this).ser_budget != null) // Value n'est pas accessible si null
                    {
                        return ((SceAdministratif)this).ser_budget.Value;
                    }
                }
                return 0;
            }
            set
            {
                if (GetType() == typeof(SceAdministratif))
                {
                    ((SceAdministratif)this).ser_budget = value;
                }
            }
        }
        public Service This
        {
            get { return this; }
        }
    }
}
