﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EntityFramework
{
    public partial class Fm_service : Form
    {
        Modele bd;
        //public Fm_service(Modele p_bd)
        //{
        //    InitializeComponent();
        //    bd = p_bd;
        //    cb_recherche.ValueMember = "ser_id";
        //    cb_recherche.DisplayMember = "ser_designation";
        //    cb_recherche.DataSource = bd.Service;
        //    cb_recherche.SelectedIndex = -1;
        //    bs.DataSource = bd.Service.Include("LesEmployes");
        //    lb_employe.DisplayMember = "Patronyme";
        //}
        public Fm_service(Modele p_bd)
        {
            InitializeComponent();
            bd = p_bd;
            cb_recherche.DisplayMember = "ser_designation";
            cb_recherche.DataSource = bd.Service;
            cb_recherche.SelectedIndex = -1;
            bs.DataSource = bd.Service.Include("LesEmployes");
            lb_employe.DisplayMember = "Patronyme";
        }

        private void bs_CurrentChanged(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                bd.SaveChanges();
                if (bs.Current.GetType() == typeof(SceProductif))
                {
                    rb_productif.Checked = true;
                    pn_productif.Visible = true;
                    pn_administratif.Visible = false;
                }
                else
                {
                    rb_administratif.Checked = true;
                    pn_productif.Visible = false;
                    pn_administratif.Visible = true;
                }
            }
        }
        private void serviceBindingNavigatorSaveItem_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                bs.EndEdit();
                bd.SaveChanges();
            }
        }

        private void Fm_service_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (bs.Current != null)
            {
                bs.EndEdit();
                bd.SaveChanges();
            }
        }

        private void bt_plusService_Click(object sender, EventArgs e)
        {
            if (((Button)sender).Name == "bt_plusProductif")
            {
                bs.Add(new SceProductif());
            }
            else
            {
                bs.Add(new SceAdministratif());
            }
            bs.RaiseListChangedEvents = false;
            bd.SaveChanges();
            bs.RaiseListChangedEvents = true;
            bs.MoveLast();
            bs.ResetCurrentItem();
        }

        private void bindingNavigatorDeleteItem_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Service leService = (Service)bs.Current;
                if (leService.LesEmployes.Count == 0)
                {
                    bs.RemoveCurrent();
                    bd.SaveChanges();
                    bs.DataSource = bd.Service.Include("LesEmployes");
                }
                else
                {
                    MessageBox.Show("Impossible de supprimer ce service, des employés y sont affectés !");
                }
            }
        }

        //private void cb_recherche_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    if (cb_recherche.SelectedIndex != -1)
        //    {
        //        int numSce = (int)cb_recherche.SelectedValue;
        //        var req =
        //            from sce in bd.Service
        //            where sce.ser_id == numSce
        //            select sce;
        //        Service leService = req.First();
        //        bs.Position = bs.List.IndexOf(leService);
        //    }
        //}
        private void cb_recherche_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cb_recherche.SelectedIndex != -1)
            {
                bs.Position = bs.List.IndexOf((Service)cb_recherche.SelectedValue);
            }
        }
    }
}

