﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EntityFramework
{
    public partial class Fm_employeGrille : Form
    {
        private Modele bd;
        public Fm_employeGrille(Modele p_bd)
        {
            InitializeComponent();
            bd = p_bd;
            bs.DataSource = bd.Employe.Include("LesDiplomes");
            bs_service.DataSource = bd.Service;
            cb_service.ValueMember = "This";
            txt_diplome.DataPropertyName = "PlusHautDiplome";
        }

        private void Fm_employeGrille_FormClosing(object sender, FormClosingEventArgs e)
        {
            dg_employe.EndEdit();
            bs.EndEdit();
            bd.SaveChanges();
        }

        private void bs_CurrentChanged(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Employe leEmploye = (Employe)bs.Current;
                if (leEmploye.EntityState == EntityState.Detached)
                {
                    bs.EndEdit();
                    bd.SaveChanges();
                }
            }
        }

        private void dg_employe_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (dg_employe.Columns[e.ColumnIndex].Name=="bt_details")
            {
                Employe leEmploye = (Employe)dg_employe.CurrentRow.DataBoundItem;
                if (leEmploye != null)
                {
                    Fm_employe femp = new Fm_employe(bd, leEmploye);
                    femp.ShowDialog();
                }
            }
        }
    }
}
