﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EntityFramework
{
    public partial class Fm_employe : Form
    {
        private Modele bd;
        public Fm_employe(Modele p_bd)
        {
            InitializeComponent();
            bd = p_bd;
            bs.DataSource = bd.Employe.Include("LesDiplomes");
            bs_service.DataSource = bd.Service;
            cb_recherche.DisplayMember = "Patronyme";
            var reqRechercheService =
                from sce in bd.Service
                orderby sce.ser_designation
                select sce;
            cb_rechercheService.DataSource = reqRechercheService;
            cb_rechercheService.DisplayMember = "ser_designation";
        }

        public Fm_employe(Modele p_bd, int idDiplome)
        {
            InitializeComponent();
            bd = p_bd;
            var reqTitulaires =
                from dip in bd.Diplome
                where dip.dip_id == idDiplome
                from emp in dip.LesEmployes
                select emp;
            bs.DataSource = reqTitulaires;
            bs_service.DataSource = bd.Service;
            cb_recherche.DisplayMember = "Patronyme";
            var reqRechercheService =
                from sce in bd.Service
                orderby sce.ser_designation
                select sce;
            cb_rechercheService.DataSource = reqRechercheService;
            cb_rechercheService.DisplayMember = "ser_designation";
        }
        public Fm_employe(Modele p_bd, Employe leEmploye) : this(p_bd)
        {
            bs.Position = bs.List.IndexOf(leEmploye);
        }

        private void bs_CurrentChanged(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                Employe leEmploye = (Employe)bs.Current;
                if (leEmploye.LeService == null)
                {
                    cb_service.SelectedIndex = -1;
                }
                if (leEmploye.EntityState == EntityState.Detached)
                {
                    bs.EndEdit();
                    bs.RaiseListChangedEvents = false;
                    bd.SaveChanges();
                    bs.RaiseListChangedEvents = true;
                    bs.ResetCurrentItem();
                }
                else
                {
                    bd.SaveChanges();
                }
                bs_autresDiplomes.DataSource = bd.Diplome.ToList().Except(leEmploye.LesDiplomes).ToList();
                lb_autresDiplomes.DisplayMember = "dip_libelle";
            }
        }

        private void bt_versAutresDiplomes_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                if (lb_diplomesPossedes.SelectedIndex != -1)
                {
                    Employe leEmploye = (Employe)bs.Current;
                    Diplome leDiplome = (Diplome)lb_diplomesPossedes.SelectedItem;
                    leEmploye.LesDiplomes.Remove(leDiplome);
                    bs_autresDiplomes.Add(leDiplome);
                }
            }
        }
        private void bt_versDiplomesPossedes_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                if (lb_autresDiplomes.SelectedIndex != -1)
                {
                    Employe leEmploye = (Employe)bs.Current;
                    Diplome leDiplome = (Diplome)lb_autresDiplomes.SelectedItem;
                    leEmploye.LesDiplomes.Add(leDiplome);
                    bs_autresDiplomes.Remove(leDiplome);
                }
            }
        }

        private void employeBindingNavigatorSaveItem_Click(object sender, EventArgs e)
        {
            if (bs.Current != null)
            {
                bs.EndEdit();
                bd.SaveChanges();
            }
        }
        private void Fm_employe_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (bs.Current != null)
            {
                bs.EndEdit();
                bd.SaveChanges();
            }
        }

        private void cb_rechercheService_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cb_rechercheService.SelectedIndex != -1)
            {
                int idService = ((Service)cb_rechercheService.SelectedValue).ser_id;
                var reqRechercheEmploye =
                    from emp in bd.Employe
                    where emp.LeService.ser_id == idService
                    orderby emp.emp_nom,emp.emp_prenom
                    select emp;
                cb_rechercheEmploye.DataSource = reqRechercheEmploye;
                cb_rechercheEmploye.DisplayMember = "Patronyme";
            }
        }

        private void cb_rechercheEmploye_SelectionChangeCommitted(object sender, EventArgs e)
        {
            if (cb_rechercheEmploye.SelectedIndex != -1)
            {
                bs.Position = bs.List.IndexOf(cb_rechercheEmploye.SelectedValue);
            }
        }
    }
}
