CREATE DATABASE stemaSQLLCD DEFAULT CHARACTER SET latin1 COLLATE latin1_general_ci;

USE stemaSQLLCD; 

-- Table: product_category

-- DROP TABLE product_category;

CREATE TABLE product_category
(
  id serial NOT NULL,
  parent_id int(4),
  name varchar(64) NOT NULL,
  PRIMARY KEY (id),
  
 ) ;

-- Table: product_product

-- DROP TABLE product_product;

CREATE TABLE product_product
(
  id serial NOT NULL,
  product_tmpl_id int(4) NOT NULL,
  default_code varchar(64),
  active bool, 
  CONSTRAINT product_product_pkey PRIMARY KEY (id),
 ) ;

-- Table: product_template

-- DROP TABLE product_template;

CREATE TABLE product_template
(
  id serial NOT NULL,
  supply_method varchar(16) NOT NULL,
  uos_id int(4),
  standard_price numeric(16,2) NOT NULL,
  sale_ok bool,
  categ_id int(4) NOT NULL,
  name varchar(64) NOT NULL,
  CONSTRAINT product_template_pkey PRIMARY KEY (id),
  );
 
ALTER TABLE product_category
ADD CONSTRAINT product_category_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES product_category (id) 
  ON UPDATE NO ACTION ON DELETE SET NULL; 
  
ALTER TABLE product_product
	ADD CONSTRAINT product_product_product_tmpl_id_fkey FOREIGN KEY (product_tmpl_id)REFERENCES product_template (id) 
	ON UPDATE NO ACTION ON DELETE SET NULL,

-- Table: product_uom_categ

-- DROP TABLE product_uom_categ;

CREATE TABLE product_uom_categ
(
  id serial NOT NULL,
  name varchar(64) NOT NULL,
  CONSTRAINT product_uom_categ_pkey PRIMARY KEY (id),
  ) ;
  
-- Table: product_uom

-- DROP TABLE product_uom;

CREATE TABLE product_uom
(
  id serial NOT NULL,
  active bool,
  category_id int(4) NOT NULL,
  name varchar(64) NOT NULL,
  CONSTRAINT product_uom_pkey PRIMARY KEY (id),
  CONSTRAINT product_uom_category_id_fkey FOREIGN KEY (category_id) REFERENCES product_uom_categ (id) 
  ON UPDATE NO ACTION ON DELETE CASCADE,
 ) ;
 
ALTER TABLE product_template
  ADD CONSTRAINT product_template_categ_id_fkey FOREIGN KEY (categ_id) REFERENCES product_category (id) 
  ON UPDATE NO ACTION ON DELETE SET NULL,
  ADD CONSTRAINT product_template_uos_id_fkey FOREIGN KEY (uos_id) REFERENCES product_uom (id)
  ON UPDATE NO ACTION ON DELETE SET NULL,
  ) ;

 -- Table: mrp_routing

-- DROP TABLE mrp_routing;

CREATE TABLE mrp_routing
(
  id serial NOT NULL,
  name varchar(64) NOT NULL,
  bom_id int(4),
  CONSTRAINT mrp_routing_pkey PRIMARY KEY (id),
  ) ;
  
ALTER TABLE mrp_routing
DROP bom_id;

-- Table: mrp_bom

-- DROP TABLE mrp_bom;

CREATE TABLE mrp_bom
(
  id serial NOT NULL,
  name varchar(64) NOT NULL,
  product_uom int(4) NOT NULL,
  routing_id int(4),
  bom_id int(4),
  product_id int(4) NOT NULL,
  CONSTRAINT mrp_bom_pkey PRIMARY KEY (id),
  CONSTRAINT mrp_bom_bom_id_fkey FOREIGN KEY (bom_id) REFERENCES mrp_bom (id)
  ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT mrp_bom_product_id_fkey FOREIGN KEY (product_id) REFERENCES product_product (id)
  ON UPDATE NO ACTION ON DELETE SET NULL,
  CONSTRAINT mrp_bom_product_uom_fkey FOREIGN KEY (product_uom)REFERENCES product_uom (id)   
  ON UPDATE NO ACTION ON DELETE SET NULL
  CONSTRAINT mrp_bom_routing_id_fkey FOREIGN KEY (routing_id) REFERENCES mrp_routing (id)
  ON UPDATE NO ACTION ON DELETE SET NULL,
  ) ;

 ALTER TABLE mrp_bom
  ADD product_qty float(8) NOT NULL;

CREATE TABLE Essai(
	id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
	truc DECIMAL(6,2) NOT NULL,
	bidule INTEGER NOT NULL,
	CONSTRAINT Essai_pk PRIMARY KEY (id)

RENAME Essai TO Essai2;
	
DROP TABLE Essai2;

GRANT ALL PRIVILEGES ON stemaSQLLCD.* to "Celuiquipeuttout" IDENTIFIED BY "faire";
GRANT SELECT, INSERT, UPDATE, DELETE ON stemaSQLLCD.* to "Celuiquinepeutpas" IDENTIFIED BY "Toutfaire";
REVOKE DELETE ON stemaSQLLCD.* TO 'Celuiquinepeutpas' IDENTIFIED BY 'Toutfaire';



















