DROP DATABASE IF EXISTS AMBULANCE;

CREATE DATABASE AMBULANCE DEFAULT CHARACTER SET UTF8 COLLATE UTF8_general_ci;

USE AMBULANCE;

CREATE TABLE Equipe
 (
   code CHAR(1),
   ambulancier CHAR(32),
   chauffeur CHAR(32) NULL,  
   PRIMARY KEY (code) 
 ) 
TYPE=InnoDB;

CREATE TABLE Patient
 (
   numero INTEGER(2) AUTO_INCREMENT,
   nom CHAR(32) NOT NULL,
   prenom CHAR(32) NULL,
   adresse CHAR(64) NULL,
   telephone CHAR(14) NULL,  
   PRIMARY KEY (numero) 
 ) 
TYPE=InnoDB;

CREATE TABLE Presence
 (
   id INTEGER(2) AUTO_INCREMENT,
   codeEquipe CHAR(1) NOT NULL,
   jour DATE NOT NULL,
   heureDebut TIME NOT NULL,
   heureFin TIME NOT NULL,  
   PRIMARY KEY (id) 
 ) 
TYPE=InnoDB;


CREATE TABLE Mission
 (
   numero INTEGER(2) NOT NULL AUTO_INCREMENT,
   numeroPatient INTEGER(2) NOT NULL,
   codeEquipe CHAR(1) NOT NULL,
   motif CHAR(64) NULL,
   dateMission DATE NOT NULL,
   heureRV TIME NOT NULL,
   lieuRV CHAR(64) NOT NULL,
   lieuDestination CHAR(64) NOT NULL,
   observation CHAR(64) NULL,
   priseEnChargeSS BOOL NOT NULL,
   duree TIME NOT NULL,
   heureDepart TIME NOT NULL,  
   PRIMARY KEY (numero) 
 ) 
TYPE=InnoDB;


ALTER TABLE Presence 
  ADD FOREIGN KEY FK_PRESENCE_EQUIPE (codeEquipe)
      REFERENCES Equipe (code) ;


ALTER TABLE Mission 
  ADD FOREIGN KEY FK_MISSION_PATIENT (numeroPatient)
      REFERENCES PATIENT (numero) ;


ALTER TABLE Mission 
  ADD FOREIGN KEY FK_MISSION_EQUIPE (codeEquipe)
      REFERENCES EQUIPE (code) ;

insert into Equipe values('A','Alan','Charline');
insert into Equipe values('B','Baptiste','Kendra');
insert into Equipe values('C','Elodie','');
insert into Equipe values('D','Geoffrey','Olivier');
insert into Equipe values('E','Idriz','Pascal');
insert into Equipe values('F','Lucie','');
insert into Equipe values('G','Mathieu','');
insert into Equipe values('H','Nadjim','');
insert into Equipe values('I','Quentin','');
insert into Equipe values('J','Salim','Dimitri');
insert into Equipe values('K','Thomas','Hugo');

insert into Presence values(1,'A','2008-11-3','7:0','15:30');
insert into Presence values(2,'B','2008-11-3','10:0','15:0');
insert into Presence values(3,'C','2008-11-3','7:0','14:30');
insert into Presence values(4,'D','2008-11-3','9:0','21:0');
insert into Presence values(5,'E','2008-11-3','10:0','18:30');
insert into Presence values(6,'F','2008-11-3','6:0','15:0');
insert into Presence values(7,'G','2008-11-3','7:0','15:30');
insert into Presence values(8,'H','2008-11-3','10:0','19:0');
insert into Presence values(9,'I','2008-11-3','10:0','18:30');
insert into Presence values(10,'J','2008-11-3','6:0','15:0');
insert into Presence values(11,'K','2008-11-3','10:0','21:0');
insert into Presence values(12,'B','2008-11-4','10:0','21:0');
insert into Presence values(13,'C','2008-11-4','10:0','18:30');
insert into Presence values(14,'E','2008-11-4','7:0','15:30');
insert into Presence values(15,'F','2008-11-4','10:0','18:30');
insert into Presence values(16,'G','2008-11-4','6:0','15:0');
insert into Presence values(17,'H','2008-11-4','7:0','15:30');
insert into Presence values(18,'I','2008-11-4','10:0','19:0');
insert into Presence values(19,'K','2008-11-4','7:0','14:30');
insert into Presence values(20,'A','2008-11-5','7:0','15:30');
insert into Presence values(21,'B','2008-11-5','6:0','15:0');
insert into Presence values(22,'C','2008-11-5','6:0','15:0');
insert into Presence values(23,'D','2008-11-5','6:0','15:0');
insert into Presence values(24,'F','2008-11-5','10:0','18:30');
insert into Presence values(25,'G','2008-11-5','10:0','18:30');
insert into Presence values(26,'H','2008-11-5','6:0','15:0');
insert into Presence values(27,'I','2008-11-5','6:0','15:0');
insert into Presence values(28,'J','2008-11-5','7:0','15:30');
insert into Presence values(29,'K','2008-11-5','10:0','18:30');
insert into Presence values(30,'A','2008-11-6','7:0','15:30');
insert into Presence values(31,'B','2008-11-6','9:0','21:0');
insert into Presence values(32,'D','2008-11-6','7:0','14:30');
insert into Presence values(33,'E','2008-11-6','10:0','15:0');
insert into Presence values(34,'F','2008-11-6','6:0','15:0');
insert into Presence values(35,'H','2008-11-6','9:0','21:0');
insert into Presence values(36,'I','2008-11-6','10:0','18:30');
insert into Presence values(37,'J','2008-11-6','9:0','21:0');
insert into Presence values(38,'K','2008-11-6','7:0','14:30');
insert into Presence values(39,'B','2008-11-7','10:0','19:0');
insert into Presence values(40,'C','2008-11-7','7:0','14:30');
insert into Presence values(41,'D','2008-11-7','6:0','15:0');
insert into Presence values(42,'E','2008-11-7','7:0','15:30');
insert into Presence values(43,'F','2008-11-7','6:0','15:0');
insert into Presence values(44,'G','2008-11-7','7:0','15:30');
insert into Presence values(45,'I','2008-11-7','10:0','19:0');
insert into Presence values(46,'J','2008-11-7','10:0','18:30');

insert into Patient values(60,'Bisotey','Stéphane','Bassevelle - 18 boulevard colbert','01 98 64 23 66');
insert into Patient values(61,'Francon','Isabelle','Sammeron - 10, rue de la tour gouzangrez','01 55 17 18 58');
insert into Patient values(62,'Villemer','Ludovic','Rebais - 1 rue d''edimbourg','01 58 27 36 45');
insert into Patient values(63,'Feghali','Rodolphe','Trilport - 21 rue des bas pres','01 48 24 21 37');
insert into Patient values(64,'Plana','Valérie','Centre rééducation cardiaque de la brie','01 32 29 31 10');
insert into Patient values(65,'Magontier','Virginie','Association Residences Et Foyers','01 32 92 25 51');
insert into Patient values(66,'Le','David','Coulommiers - 56 blvrd de saint denis','01 33 09 51 95');
insert into Patient values(67,'Garcia','Nadege','Mortery - 28 rue vassal','01 11 41 58 17');
insert into Patient values(68,'Pasti','Marie','MaisonRouge - 3, rue dautancourt','01 51 24 83 43');
insert into Patient values(69,'Mona','Stéphanie','LeChâtelet-en-Brie - 12 avenue rachel','01 73 86 17 61');
insert into Patient values(70,'Freppel','Marie Odile','Saint-JeanDeux-Jumeaux - 15 rue du general leclerc','01 32 82 55 17');
insert into Patient values(71,'Dunand','Rodolphe','MaisonRouge - 3, rue dautancourt','01 53 53 43 71');
insert into Patient values(72,'Champin','Karine','Boissy 24 rue de la grange','01 41 08 31 18');
insert into Patient values(73,'Cany','Nicolas','Marolles-en-Brie - 22 rue courteline','01 15 52 21 58');
insert into Patient values(74,'Fevrier','Renaud','Saint-Germain-sur-Morin - 11 rue des federes','01 13 91 57 97');
insert into Patient values(75,'Delcroix','Nadine','Fontenailles - 53 rue éléonore jarry','01 21 68 20 80');
insert into Patient values(76,'Detat','Laetitia','Centre rééducation cardiaque de la brie','01 83 42 67 15');
insert into Patient values(77,'Joudoux','Sandrine','Ussy-sur-Marne - 39 rue de metz','01 00 01 52 69');
insert into Patient values(78,'Marchand','Christel','Centre rééducation cardiaque de la brie','01 58 94 58 48');
insert into Patient values(79,'Huret','Stéphanie','Thénisy - 25 rue bisson','01 48 59 56 13');
insert into Patient values(80,'Hang','Stéphanie','Résidence les Floralies','01 01 37 50 72');
insert into Patient values(81,'Gibert','Muriel','Mortcerf - 17 rue guillaume apollinaire','01 30 20 11 57');
insert into Patient values(82,'Bazin','Cédric','Choisy en brie 4 La Fresnois','01 57 86 14 42');
insert into Patient values(83,'Dalard','Sandrine','Mouroux - 19 rue des coudreaux','01 83 41 88 70');
insert into Patient values(84,'Teurlay','Laurent','Maison de Retraite Le Marais','01 24 73 03 66');
insert into Patient values(85,'Le Cour','Caroline','Crégy-lès-Meaux - 3 allee de la cle saint pierre','01 77 83 74 80');
insert into Patient values(86,'Boureau','Olivier','La ferté/gaucher 14 rue Washington','01 64 46 68 31');
insert into Patient values(87,'Boucharel','Marie Claire','Coulommiers - 22 avenue réaumur','01 74 35 74 04');
insert into Patient values(88,'Orfanidis','Stéphane','Provins - 5 rue dorian','01 49 74 65 14');
insert into Patient values(89,'Pomariega','Cyril','Mouroux 215 Av de la libération','01 53 87 88 46');
insert into Patient values(90,'Regeffe','Valérie','Maison de Retraite Le Marais','01 14 73 18 79');
insert into Patient values(91,'Dufourcq','Nathalie','Coulommiers - 1 rue auguste renoir','01 44 75 61 07');
insert into Patient values(92,'Geoffroy','Matthieu','Meigneux - 13 rue du petit robinson','01 66 35 62 41');
insert into Patient values(93,'Touchais','Violaine','Saint-Cyr-sur-Morin - 21 rue marbeau','01 11 58 95 43');
insert into Patient values(94,'Feyt','Thierry','Maison Retraite Saint Aile','01 84 97 23 42');
insert into Patient values(95,'Sartron','Matthieu','LaFerté-Gaucher - 104 avenue thiers','01 27 23 88 72');
insert into Patient values(96,'Labreze','Christophe','Saint-Cyr/Morin - 21 rue marbeau','01 31 40 59 79');
insert into Patient values(97,'Bonnin','Anne','Coulommiers - 15 rue du grenier saint lazarre','01 72 76 52 35');
insert into Patient values(98,'Murat','David','Coulommiers - 53 rue des princes de wagram','01 26 44 61 62');
insert into Patient values(99,'Ferte','Stéphane','Magny-le-Hongre - les vergers clairbois','01 73 78 69 84');
insert into Patient values(100,'Billa','Isabelle','Mouroux - 20 rue des mustangs','01 21 32 83 11');
insert into Patient values(101,'Lataste','Benoit','Boissy - 5 rue les faures','01 82 53 38 89');
insert into Patient values(102,'Potonne','Omar','Mouroux - 125 cours gambetta','01 33 80 33 13');
insert into Patient values(103,'Cabaco','Sophie','Coulommiers - 178 chemin de suze','01 85 56 62 14');
insert into Patient values(104,'Balan','Arnaud','Rebais - 4 rue antoine watteau','01 96 43 14 16');
insert into Patient values(105,'Charry','Charlène','Ussy-sur-Marne - 51 rue voltaire','01 56 47 84 12');
insert into Patient values(106,'Bellicard','Christophe','Thénisy - 6 rue renaudel','01 32 56 81 00');
insert into Patient values(107,'Bouchet','Linda','Boissy - 44 rue des lauriers','01 25 69 99 27');
insert into Patient values(108,'Berthier','Fabrice','Mortcerf - 2 rue Tared','01 56 84 12 00');
insert into Patient values(109,'Brukhnoff','Caroline','Mouroux - 54 impasse Tissier','01 64 21 11 50');
insert into Patient values(110,'Carliton','Stéphane','Maisonrouge - 14 rue clignancourt','01 82 14 58 99');

insert into Mission values(1,91,'F','accident','2008-11-3','6:15','Coulommiers - 1 rue auguste renoir','CH Meaux Saint Fiacre','Rdv Tél 2/11 16 H',-1,'0:55','6:15');
insert into Mission values(2,64,'J','soins journaliers','2008-11-3','6:15','CH Arbeltier De Coulommiers','CHU Montfermeil','Fax 16 H 30 veille',-1,'0:45','6:15');
insert into Mission values(3,68,'A','accident','2008-11-3','7:0','Clinique de tournan','CHU Necker','Embouteillage',0,'1:45','7:0');
insert into Mission values(4,72,'C','urgence domicile','2008-11-3','7:0','Boissy 24 rue de la grange','CH La ferté Saint Jean','Rdv fixé le 30/10',-1,'0:15','7:0');
insert into Mission values(5,94,'G','retour domicile','2008-11-3','7:0','CH Lagny Sur Marne','Maison Retraite Saint Aile','Mel 17 H veille',-1,'1:0','7:0');
insert into Mission values(6,78,'F','rééducation journalière','2008-11-3','7:45','Clinique de Thorigny','Centre rééducation cardiaque de la brie','Rdv fixé le 27/10',0,'1:0','7:45');
insert into Mission values(7,90,'C','retour domicile','2008-11-3','8:0','CH Meaux Saint Fiacre','Maison de Retraite Le Marais','Embouteillage entrée Meaux',-1,'0:30','8:15');
insert into Mission values(8,108,'J','rééducation journalière','2008-11-3','8:15','Clinique de tournan','Centre rééducation cardiaque de la brie','à tarder à donner l''heure de fin de mission',-1,'1:15','8:0');
insert into Mission values(9,65,'G','retour domicile','2008-11-3','8:15','Clinique Saint Faron','Association Residences Et Foyers','Patient pris plus tôt',-1,'1:0','8:15');
insert into Mission values(10,96,'C','transport demande médecin','2008-11-3','9:0','Saint-Cyr/Morin - 21 rue marbeau','CH Arbeltier De Coulommiers','heure fin de mission tardive',0,'0:45','9:30');
insert into Mission values(11,109,'A','rééducation hebdomadaire','2008-11-3','9:0','Clinique de Thorigny','Centre rééducation cardiaque de la brie','Patient avait compris 10 H',-1,'1:30','9:15');
insert into Mission values(12,108,'F','accident de la route','2008-11-3','9:45','MaisonRouge - 3, rue dautancourt','CH Arbeltier De Coulommiers','Tél 2/11 15 H00',-1,'0:15','10:0');
insert into Mission values(13,66,'E','accident de moto','2008-11-3','10:0','Coulommiers - 56 blvrd de saint denis','CH Arbeltier De Coulommiers','A du faire le plein',0,'0:0','10:15');
insert into Mission values(14,76,'I','urgence domicile','2008-11-3','10:0','Clinique de Thorigny','CHU Necker','Travaux sur la route',0,'1:45','10:30');
insert into Mission values(15,82,'D','coma','2008-11-3','10:15','Choisy en brie 4 La Fresnois','Clinique la Francilienne','Rdv fixé le 27/10',-1,'1:0','9:15');
insert into Mission values(16,84,'H','perte de connaissance','2008-11-3','10:15','Clinique la Francilienne','CHU Saint Louis','retard/Travaux',-1,'2:15','10:15');
insert into Mission values(17,100,'K','accident','2008-11-3','10:30','CH Arbeltier De Coulommiers','CH Garches','Appel 8 H ce jour Antenne Crécy ',-1,'3:30','10:30');
insert into Mission values(18,101,'E','urgence médecin','2008-11-3','10:30','CH Arbeltier De Coulommiers','CH Lagny Sur Marne','Appel 8 H 30 ce jour',0,'1:0','10:30');
insert into Mission values(19,81,'B','examen cardiaque','2008-11-3','10:30','Mortcerf - 17 rue guillaume apollinaire','CH Arbeltier De Coulommiers','Erreur dans l''adresse appel patient',0,'1:15','10:30');
insert into Mission values(20,95,'F','accident','2008-11-3','11:15','LaFerté-Gaucher - 104 avenue thiers','Clinique Ange Gardien','Client pas prêt attendait le véhicule pour 13 H',-1,'0:45','11:45');
insert into Mission values(21,102,'A','évanouissement','2008-11-3','11:45','CH Meaux Saint Faron','CHU Bichat','retard/Embouteillage',-1,'2:0','11:45');
insert into Mission values(22,98,'F','retour domicile','2008-11-3','12:30','CH Arbeltier De Coulommiers','Coulommiers - 53 rue des princes de wagram','CH arbeltier prévenu du retard',0,'0:45','12:45');
insert into Mission values(23,110,'C','urgence domicile','2008-11-3','12:30','Maison de Retraite Le Marais','CH Arbeltier De Coulommiers','Erreur planning Rdv prévu 13:45',0,'0:45','13:30');
insert into Mission values(24,80,'B','retour domicile','2008-11-3','12:30','CH La ferté Saint Jean','Résidence les Floralies','Fax 17 H 00 veille',-1,'0:45','12:30');
insert into Mission values(25,83,'H','retour domicile','2008-11-3','12:45','Clinique des moulins','Mouroux - 19 rue des coudreaux','Appel 11 H ce jour',0,'0:30','13:0');
insert into Mission values(26,104,'D','arrêt cardiaque','2008-11-3','12:45','CH Arbeltier De Coulommiers','CHU Pitié','Service accueil arrivée non prévenu',-1,'2:15','12:45');
insert into Mission values(27,87,'I','retour domicile','2008-11-3','13:0','CH d''Orgemont','Coulommiers - 22 avenue réaumur','Appel 11 H ce jour',-1,'0:45','13:0');
insert into Mission values(28,105,'E','accouchement difficile','2008-11-3','13:15','CH Arbeltier De Coulommiers','CHU Necker','Fax 16 H 45 veille',0,'2:0','13:15');
insert into Mission values(29,61,'H','retour domicile','2008-11-3','13:45','Clinique des moulins','Sammeron - 10, rue de la tour gouzangrez','Appel 12 H ce jour',0,'0:30','14:0');
insert into Mission values(30,86,'F','transport demande médecin','2008-11-3','14:0','La ferté/gaucher 14 rue Washington','CH Meaux Saint Faron','Rdv pris par chauffeur',-1,'0:45','14:15');
insert into Mission values(31,63,'B','retour domicile','2008-11-3','14:0','CH Arbeltier De Coulommiers','Trilport - 21 rue des bas pres','Appel 13 H 30 ce jour',-1,'0:30','14:0');
insert into Mission values(32,77,'A','accident cérébral','2008-11-3','14:15','Clinique des moulins','Ussy-sur-Marne - 39 rue de metz','Appel 12 H 45 ce jour',-1,'0:45','14:30');
insert into Mission values(33,67,'I','retour domicile','2008-11-3','14:15','Clinique des moulins','Mortery - 28 rue vassal','Appel 13 H ce jour',-1,'0:30','14:15');
insert into Mission values(34,89,'J','perte de connaissance','2008-11-3','14:45','Mouroux 215 Av de la libération','CH Arbeltier De Coulommiers','Rdv fixé le 27/10',-1,'0:15','14:45');
insert into Mission values(35,60,'G','retour domicile','2008-11-3','14:45','CH Arbeltier De Coulommiers','Bassevelle - 18 boulevard colbert','Appel 12 H 45 ce jour',0,'0:45','14:45');
insert into Mission values(36,85,'I','retour domicile','2008-11-3','15:0','Clinique des moulins','Crégy-lès-Meaux - 3 allee de la cle saint pierre','Erreur planning Rdv prévu par le client à 15:30',0,'1:0','15:30');
insert into Mission values(37,73,'H','retour domicile','2008-11-3','15:0','CH Arbeltier De Coulommiers','Marolles-en-Brie - 22 rue courteline','Appel 14 H 30 ce jour',-1,'0:15','15:0');
insert into Mission values(38,79,'D','retour domicile','2008-11-3','15:45','Clinique des moulins','Thénisy - 25 rue bisson','Appel 14 H 15 ce jour',0,'0:45','16:0');
insert into Mission values(39,93,'H','retour domicile','2008-11-3','16:0','CH Arbeltier De Coulommiers','Saint-Cyr-sur-Morin - 21 rue marbeau','Appel 15 H 15 ce jour',-1,'0:30','16:0');
insert into Mission values(40,99,'E','retour domicile','2008-11-3','16:0','Clinique des moulins','Magny-le-Hongre - les vergers clairbois','Appel 15 H 45 ce jour',0,'0:30','16:15');
insert into Mission values(41,75,'K','retour domicile','2008-11-3','16:15','CH Arbeltier De Coulommiers','Fontenailles - 53 rue éléonore jarry','Appel 15 H 45 ce jour',-1,'0:15','16:15');
insert into Mission values(42,69,'I','retour domicile','2008-11-3','16:45','Clinique des moulins','LeChâtelet-en-Brie - 12 avenue rachel','Appel 15 H 30 ce jour',-1,'0:30','17:0');
insert into Mission values(43,71,'D','retour domicile','2008-11-3','17:15','CH Arbeltier De Coulommiers','MaisonRouge - 3, rue dautancourt','Appel 16 H 45 ce jour',-1,'0:15','17:15');
insert into Mission values(44,74,'H','retour domicile','2008-11-3','17:15','CH Arbeltier De Coulommiers','Saint-Germain-sur-Morin - 11 rue des federes','Appel 15 H 45 ce jour',-1,'0:30','17:15');
insert into Mission values(45,88,'E','retour domicile','2008-11-3','17:30','Clinique des moulins','Provins - 5 rue dorian','Appel 17 H 00 ce jour',-1,'0:45','17:30');
insert into Mission values(46,92,'K','retour domicile','2008-11-3','17:30','CH Arbeltier De Coulommiers','Meigneux - 13 rue du petit robinson','Appel 17 H ce jour',0,'0:30','17:30');
insert into Mission values(47,70,'I','retour domicile','2008-11-3','18:0','CH Arbeltier De Coulommiers','Saint-JeanDeux-Jumeaux - 15 rue du general leclerc','Appel 17 H 15 ce jour',-1,'0:30','18:0');
insert into Mission values(48,62,'D','retour domicile','2008-11-3','18:15','Clinique des moulins','Rebais - 1 rue d''edimbourg','Appel 18 H ce jour',0,'0:30','18:15');
insert into Mission values(49,97,'H','retour domicile','2008-11-3','18:30','CH Arbeltier De Coulommiers','Coulommiers - 15 rue du grenier saint lazarre','Appel 18 H ce jour',0,'0:30','18:30');
insert into Mission values(50,106,'K','coma','2008-11-3','18:45','CH Arbeltier De Coulommiers','CHU Pitié','Appel 17 H 30 ce jour',-1,'2:15','18:30');
insert into Mission values(51,107,'D','urgence par médecin','2008-11-3','19:15','Clinique des moulins','CHU Necker','Appel 11 H ce jour',0,'1:45','19:15');

