// Version du 01/04/2000
#ifndef _CHAINE
#define _CHAINE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>

const int _maxcar=255;
class chaine {
	char adr[256];
public:
	chaine(char * ="");
	chaine(const chaine &);
	chaine & operator=(const chaine &);
	friend ostream & operator<<(ostream &,chaine);
	friend istream & operator>>(istream &,chaine &);
	friend int lgchaine(const chaine &);
	friend chaine operator+(const chaine&,const chaine&);
	char & operator[](int);
	char operator[](int) const;
	friend chaine souschaine(const chaine&,int,int);
	friend int pos(const chaine&,const chaine&);
	friend char * cv_chainec(chaine&);
	friend int est_entier(chaine);
	friend int est_reel(chaine);
	friend int est_num(chaine);
	friend double cv_num(chaine);
	friend chaine cv_chaine(double);
	int operator==(const chaine &);
	int operator!=(const chaine &);
	friend int operator!=(const char *,const chaine &);
	friend int operator==(const char *,const chaine &);
};

int operator!=(const char * c,const chaine & ch) {
	return strcmp(c,ch.adr);
}

int operator==(const char * c,const chaine & ch) {
	return !strcmp(c,ch.adr);
}

int chaine::operator==(const chaine & ch) {
	return !strcmp(ch.adr,adr);
}

int chaine::operator!=(const chaine & ch) {
	return strcmp(ch.adr,adr);
}

int pos(const chaine& ssch,const chaine& ch)
{
	const int nonok=1,ok=2,echec=3,succes=4;
	int pos,car,etat;
	int resultat;
	int lg=lgchaine(ch),nb=lgchaine(ssch);
	pos=1;
	car=1;
	etat=nonok;
	while (etat!=echec && etat!=succes) {
		switch (etat) {
			case nonok :
				if (pos>lg) {
					resultat=0;
					etat=echec;
					}
				else
					if (ch[pos]!=ssch[car])
						pos++;
					else {
						pos++;
						car++;
						etat=ok;
					}
				break;
			case ok :
				if (car>nb) {
					resultat=pos-nb;
					etat=succes;
					}
				else
					if (pos>lg) {
						resultat=0;
						etat=echec;
						}
					else
						if (ch[pos]==ssch[car]) {
							pos++;
							car++;
							}
						else {
							etat=nonok;
							car=1;
						}
				break;
		}
	}
	return resultat;
}

chaine::chaine(char *st)
{
	strncpy(adr,st,_maxcar);
}
chaine::chaine(const chaine &ch)
{
	strncpy(adr,ch.adr,_maxcar);
}
chaine & chaine::operator=(const chaine &ch)
{
	if (&ch!=this)
		strncpy(adr,ch.adr,_maxcar);
	return *this;
}
ostream & operator<<(ostream &sortie,chaine ch)
{
	sortie<<ch.adr;
	return sortie;
}
istream & operator>>(istream &entree,chaine &ch)
{
	char temp[256];
	entree>>ws;
	entree.getline(temp,_maxcar+1);
	strncpy(ch.adr,temp,_maxcar);
	return entree;
}
int lgchaine(const chaine & ch)
{
	return strlen(ch.adr);
}
chaine operator+(const chaine &ch1,const chaine &ch2)
{
	chaine res("");
	strncpy(res.adr,ch1.adr,_maxcar);
	strncat(res.adr,ch2.adr,_maxcar-strlen(ch1.adr));
	return res;
}
char & chaine::operator[](int i)
{
	if (i>strlen(adr))
		i=strlen(adr);
	else
		if (i<1)
			i=1;
	return adr[i-1];
}
char chaine::operator[](int i) const
{
	if (i>strlen(adr))
		i=strlen(adr);
	else
		if (i<1)
			i=1;
	return adr[i-1];
}
chaine souschaine(const chaine & ch,int deb,int nb) {
	chaine res("");
	strncpy(res.adr,ch.adr+deb-1,nb);
	return res;
}
char * cv_chainec(chaine& c) {
	return c.adr;
}
int est_entier(chaine c) {
	long l;
	char temp[256]="";
	int nb=sscanf(c.adr,"%ld%s",&l,temp);
	return (strlen(temp)==0 && nb==1);
}
int est_reel(chaine c) {
	double d;
	char temp[256]="";
	int nb=sscanf(c.adr,"%lf%s",&d,temp);
	return (strlen(temp)==0 && nb==1);
}
int est_num(chaine c) {
	return (est_entier(c) || est_reel(c));
}
double cv_num(chaine(c)) {
	if (est_reel(c))
		return atof(c.adr);
	else
		return atol(c.adr);
}
chaine cv_chaine(double d) {
	chaine res;
	sprintf(res.adr,"%g",d);
	return res;
}
#endif