﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Reflection;

namespace Serveur
{
    [Serializable]  // La classe est sérialisable
    class MessageReseau
    {
        private IPAddress ipEmetteur;
        private string texte;
        public MessageReseau(IPAddress p_ipEmetteur, string p_texte)
        {
            ipEmetteur = p_ipEmetteur;
            texte = p_texte;
        }
        public IPAddress GetIpEmetteur()
        {
            return ipEmetteur;
        }
        public string GetTexte()
        {
            return texte;
        }
        public static byte[] Serialiser(MessageReseau p_message)
        {
            MemoryStream flux = new MemoryStream();
            BinaryFormatter formateur = new BinaryFormatter();
            formateur.Serialize(flux, p_message);
            byte[] buffer = flux.GetBuffer();
            flux.Close();
            return buffer;
        }
        public static MessageReseau Deserialiser(byte[] p_buffer)
        {
            MemoryStream flux = new MemoryStream(p_buffer);
            BinaryFormatter formateur = new BinaryFormatter();
            formateur.Binder = new TypeDeserialisation();
            object obj = formateur.Deserialize(flux);
            flux.Close();
            return (MessageReseau)obj;
        }
    }
    class TypeDeserialisation : SerializationBinder
    {
        // Nécessaire pour indiquer le type d'objet retourné par la désérialisation
        public override Type BindToType(string assemblyName, string typeName)
        {
            if (typeName == "Client.MessageReseau")
            {
                typeName = "Serveur.MessageReseau";
            }
            string infosType = typeName + "," + Assembly.GetExecutingAssembly().FullName;
            return Type.GetType(infosType);
        }
    }
}
