﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace Serveur
{
    public partial class Fm_serveur : Form
    {
        public Fm_serveur()
        {
            InitializeComponent();
            init();
        }
        private int nbMessages;
        private int lgMessage = 1000;
        private IPAddress adrIpLocale;
        private Socket sock;
        private IPEndPoint epRecepteur;
        byte[] messageBytes;
        private IPAddress getAdrIpLocaleV4()
        {
            string hote = Dns.GetHostName();
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void init()
        {
            nbMessages = 0;
            messageBytes = new byte[lgMessage]; 
            adrIpLocale = getAdrIpLocaleV4();
            sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            epRecepteur = new IPEndPoint(adrIpLocale, 33000);
            sock.Bind(epRecepteur);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sock.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        private void recevoir(IAsyncResult AR)
        {
            BackgroundWorker worker = new BackgroundWorker();
            worker.DoWork += new DoWorkEventHandler(worker_DoWork);
            worker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(worker_RunWorkerCompleted);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sock.EndReceiveFrom(AR, ref epTemp);
            // Créer un nouveau message par désérialisation des bytes reçus
            MessageReseau leMessage = MessageReseau.Deserialiser(messageBytes);
            worker.RunWorkerAsync(leMessage);
            Array.Clear(messageBytes, 0, messageBytes.Length);
            sock.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            nbMessages++;
            e.Result = e.Argument;
        }
        void worker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            MessageReseau leMessage = (MessageReseau)e.Result;
            string element = leMessage.GetIpEmetteur().ToString() + " -> " + leMessage.GetTexte();
            lb_messages.Items.Add(element);
            lbl_nbMessages.Text = "Nombre de messages reçus : " + nbMessages.ToString();
        }
    }
}
