﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;

namespace Serveur
{
    public partial class Fm_serveur : Form
    {
        public Fm_serveur()
        {
            InitializeComponent();
            init();
        }
        private int nbMessages;
        private int lgMessage = 40;
        private IPAddress adrIpLocale;
        private Socket sock;
        private IPEndPoint epRecepteur;
        byte[] message;
        private IPAddress getAdrIpLocaleV4()
        {
            string hote = Dns.GetHostName();
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void init()
        {
            nbMessages = 0;
            message = new byte[lgMessage]; 
            adrIpLocale = getAdrIpLocaleV4();
            sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            epRecepteur = new IPEndPoint(adrIpLocale, 33000);
            sock.Bind(epRecepteur);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sock.BeginReceiveFrom(message, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        private void recevoir(IAsyncResult AR)
        {
            BackgroundWorker worker = new BackgroundWorker();
            worker.DoWork += new DoWorkEventHandler(worker_DoWork);
            worker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(worker_RunWorkerCompleted);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sock.EndReceiveFrom(AR, ref epTemp);
            string strMessage;
            strMessage = Encoding.Unicode.GetString(message, 0, message.Length);
            worker.RunWorkerAsync(strMessage);
            Array.Clear(message, 0, message.Length);
            sock.BeginReceiveFrom(message, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            nbMessages++;
            e.Result = e.Argument;
        }
        void worker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            string element = (string)e.Result;
            lb_messages.Items.Add(element);
            lbl_nbMessages.Text = "Nombre de messages reçus : " + nbMessages.ToString();
        }
    }
}
