﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;

namespace Serveur
{
    public partial class Fm_serveur : Form
    {
        public Fm_serveur()
        {
            InitializeComponent();
            initReception();
        }
        private static int lgMessage = 1000;
        private static int portServeur = 33000;
        private static int portClient = 33001;
        private IPAddress adrIpLocale;
        private Socket sockReception;
        private IPEndPoint epRecepteur;
        byte[] messageBytes;
        Dictionary<IPAddress, string> clients;
        private IPAddress getAdrIpLocaleV4(string hote)
        {
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void initReception()
        {
            clients = new Dictionary<IPAddress, string>();
            messageBytes = new byte[lgMessage]; 
            adrIpLocale = getAdrIpLocaleV4(Dns.GetHostName());
            sockReception = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            epRecepteur = new IPEndPoint(adrIpLocale, portServeur);
            sockReception.Bind(epRecepteur);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sockReception.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        private void recevoir(IAsyncResult AR)
        {
            BackgroundWorker worker = new BackgroundWorker();
            worker.DoWork += new DoWorkEventHandler(worker_DoWork);
            worker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(worker_RunWorkerCompleted);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sockReception.EndReceiveFrom(AR, ref epTemp);
            MessageChat leMessage = new MessageChat(messageBytes);
            worker.RunWorkerAsync(leMessage);
            Array.Clear(messageBytes, 0, messageBytes.Length);
            sockReception.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            MessageChat leMessage = (MessageChat)e.Argument;
            switch (leMessage.TypeMessage)
            {
                case 'C':
                    clients.Add(leMessage.IpEmetteur, leMessage.Texte);
                    break;
                case 'E':
                    string pseudo=clients[leMessage.IpEmetteur];
                    MessageChat messageRetransmis = new MessageChat('R', adrIpLocale, pseudo + " -> " + leMessage.Texte);
                    envoyerMulticast(messageRetransmis);
                    break;
                case 'D':
                    clients.Remove(leMessage.IpEmetteur);
                    break;
            }
            e.Result = e.Argument;
        }
        private void envoyerMulticast(MessageChat leMessage)
        {
            byte[] messageMulticast;
            Socket sockEmission = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            IPEndPoint epEmetteur = new IPEndPoint(adrIpLocale, 0);
            sockEmission.Bind(epEmetteur);
            IPAddress IpMulticast = IPAddress.Parse("224.168.100.2");
            IPEndPoint epRecepteur = new IPEndPoint(IpMulticast, portClient);
            messageMulticast = leMessage.GetInfos();
            sockEmission.SendTo(messageMulticast, epRecepteur);
            sockEmission.Close();
        }
        void worker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            MessageChat leMessage = (MessageChat)e.Result;
            switch (leMessage.TypeMessage)
            {
                case 'C':
                    lb_clients.Items.Add(leMessage.Texte);
                    break;
                case 'D':
                    lb_clients.Items.Remove(leMessage.Texte);
                    break;
            }
        }
    }
}
