﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;

namespace Client
{
    public partial class Fm_client : Form
    {
        public Fm_client()
        {
            InitializeComponent();
            adrIpLocale = getAdrIpLocaleV4();
        }
        private IPAddress adrIpLocale;
        private static IPAddress ipServeur = IPAddress.Parse("192.168.3.3");
        private static int portServeur = 33000;
        private static int portClient = 33001;
        private static int lgMessage = 1000;
        private Socket sockReception;
        private IPEndPoint epRecepteur;
        byte[] messageBytes;
        private IPAddress getAdrIpLocaleV4()
        {
            string hote = Dns.GetHostName();
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void envoyer(MessageChat leMessage)
        {
            byte[] messageBytes;
            Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            IPEndPoint epEmetteur = new IPEndPoint(adrIpLocale, 0);
            sock.Bind(epEmetteur);
            IPEndPoint epRecepteur = new IPEndPoint(ipServeur, portServeur);
            messageBytes = leMessage.GetInfos();
            sock.SendTo(messageBytes, epRecepteur);
            sock.Close();
            tb_message.Clear();
            tb_message.Focus();
        }

        private void bt_connecter_Click(object sender, EventArgs e)
        {
            if (tb_pseudo.Text != "")
            {
                bt_connecter.Enabled = false;
                tb_pseudo.Enabled = false;
                MessageChat leMessage = new MessageChat('C', adrIpLocale, tb_pseudo.Text);
                envoyer(leMessage);
                bt_envoyer.Enabled = true;
                tb_message.Enabled = true;
                initReception();
                tb_message.Focus();
            }
        }
        private void initReception()
        {
            messageBytes = new byte[lgMessage];
            sockReception = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            epRecepteur = new IPEndPoint(adrIpLocale, portClient);
            sockReception.Bind(epRecepteur);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sockReception.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        private void recevoir(IAsyncResult AR)
        {
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sockReception.EndReceiveFrom(AR, ref epTemp);
            MessageChat leMessage = new MessageChat(messageBytes);
            BackgroundWorker worker = new BackgroundWorker();
            worker.DoWork += new DoWorkEventHandler(worker_DoWork);
            worker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(worker_RunWorkerCompleted);
            worker.RunWorkerAsync(leMessage);
            Array.Clear(messageBytes, 0, messageBytes.Length);
            sockReception.BeginReceiveFrom(messageBytes, 0, lgMessage, SocketFlags.None, ref epTemp, new AsyncCallback(recevoir), null);
        }
        void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            e.Result = e.Argument;
        }
        void worker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            MessageChat leMessage = (MessageChat)e.Result;
            switch (leMessage.TypeMessage)
            {
                case 'R':
                    lb_messages.Items.Add(leMessage.Texte);
                    break;
            }
        }

        private void bt_envoyer_Click(object sender, EventArgs e)
        {
            MessageChat leMessage = new MessageChat('E', adrIpLocale, tb_message.Text);
            envoyer(leMessage);
        }

        private void Fm_client_FormClosing(object sender, FormClosingEventArgs e)
        {
            MessageChat leMessage = new MessageChat('D', adrIpLocale, tb_pseudo.Text);
            envoyer(leMessage);
        }
    }
}
