﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;

namespace Serveur
{
    public partial class Fm_serveur : Form
    {
        public Fm_serveur()
        {
            CheckForIllegalCrossThreadCalls = false;
            InitializeComponent();
            adrIpLocale = getAdrIpLocaleV4();
        }
        private IPAddress adrIpLocale;
        private IPAddress getAdrIpLocaleV4()
        {
            string hote = Dns.GetHostName();
            IPHostEntry ipLocales = Dns.GetHostEntry(hote);
            foreach (IPAddress ip in ipLocales.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                {
                    return ip;
                }
            }
            return null; // aucune adresse IP V4
        }
        private void bt_recevoir_Click(object sender, EventArgs e)
        {
            byte[] message = new byte[40];
            Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            IPEndPoint epRecepteur = new IPEndPoint(adrIpLocale, 33000);
            sock.Bind(epRecepteur);
            EndPoint epTemp = (EndPoint)new IPEndPoint(IPAddress.Any, 0);
            sock.ReceiveFrom(message, ref epTemp);
            IPEndPoint epEmetteur = (IPEndPoint)epTemp;
            string strMessage = Encoding.Unicode.GetString(message);
            MessageBox.Show(epEmetteur.Address.ToString() + " -> " + strMessage);
        }
    }
}
