--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account (
    id integer NOT NULL,
    parent_left integer,
    parent_right integer,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    reconcile boolean,
    user_type integer NOT NULL,
    write_uid integer,
    create_uid integer,
    company_id integer NOT NULL,
    shortcut character varying(12),
    note text,
    parent_id integer,
    type character varying NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    currency_id integer,
    name character varying NOT NULL,
    level integer,
    currency_mode character varying NOT NULL
);


--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account IS 'Account';


--
-- Name: COLUMN account_account.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.code IS 'Code';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.user_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.user_type IS 'Account Type';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.company_id IS 'Company';


--
-- Name: COLUMN account_account.shortcut; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.shortcut IS 'Shortcut';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.parent_id IS 'Parent';


--
-- Name: COLUMN account_account.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.type IS 'Internal Type';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.active IS 'Active';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.currency_id IS 'Secondary Currency';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.name IS 'Name';


--
-- Name: COLUMN account_account.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.level IS 'Level';


--
-- Name: COLUMN account_account.currency_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account.currency_mode IS 'Outgoing Currencies Rate';


--
-- Name: account_account_consol_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_consol_rel (
    child_id integer NOT NULL,
    parent_id integer NOT NULL
);


--
-- Name: TABLE account_account_consol_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_consol_rel IS 'RELATION BETWEEN account_account AND account_account';


--
-- Name: account_account_financial_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_financial_report (
    account_id integer NOT NULL,
    report_line_id integer NOT NULL
);


--
-- Name: TABLE account_account_financial_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_financial_report IS 'RELATION BETWEEN account_account AND account_financial_report';


--
-- Name: account_account_financial_report_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_financial_report_type (
    report_id integer NOT NULL,
    account_type_id integer NOT NULL
);


--
-- Name: TABLE account_account_financial_report_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_financial_report_type IS 'RELATION BETWEEN account_financial_report AND account_account_type';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_account_id_seq OWNED BY account_account.id;


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_account_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_template (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    currency_id integer,
    user_type integer NOT NULL,
    chart_template_id integer,
    shortcut character varying(12),
    write_uid integer,
    note text,
    parent_id integer,
    nocreate boolean,
    write_date timestamp without time zone,
    reconcile boolean,
    type character varying NOT NULL
);


--
-- Name: TABLE account_account_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_template IS 'Templates for Accounts';


--
-- Name: COLUMN account_account_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_template.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.code IS 'Code';


--
-- Name: COLUMN account_account_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_account_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.name IS 'Name';


--
-- Name: COLUMN account_account_template.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.currency_id IS 'Secondary Currency';


--
-- Name: COLUMN account_account_template.user_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.user_type IS 'Account Type';


--
-- Name: COLUMN account_account_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_account_template.shortcut; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.shortcut IS 'Shortcut';


--
-- Name: COLUMN account_account_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_template.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.note IS 'Note';


--
-- Name: COLUMN account_account_template.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.parent_id IS 'Parent Account Template';


--
-- Name: COLUMN account_account_template.nocreate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.nocreate IS 'Optional create';


--
-- Name: COLUMN account_account_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account_template.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account_template.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_template.type IS 'Internal Type';


--
-- Name: account_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_account_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_account_template_id_seq OWNED BY account_account_template.id;


--
-- Name: account_account_template_tax_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_template_tax_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_account_template_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_template_tax_rel IS 'RELATION BETWEEN account_account_template AND account_tax_template';


--
-- Name: account_account_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_type (
    id integer NOT NULL,
    create_uid integer,
    code character varying(32) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    note text,
    close_method character varying NOT NULL,
    report_type character varying NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_type IS 'Account Type';


--
-- Name: COLUMN account_account_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_type.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.code IS 'Code';


--
-- Name: COLUMN account_account_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.create_date IS 'Created on';


--
-- Name: COLUMN account_account_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.name IS 'Account Type';


--
-- Name: COLUMN account_account_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_type.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.note IS 'Description';


--
-- Name: COLUMN account_account_type.close_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.close_method IS 'Deferral Method';


--
-- Name: COLUMN account_account_type.report_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.report_type IS 'P&L / BS Category';


--
-- Name: COLUMN account_account_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_account_type.write_date IS 'Last Updated on';


--
-- Name: account_account_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_account_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_account_type_id_seq OWNED BY account_account_type.id;


--
-- Name: account_account_type_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_account_type_rel (
    journal_id integer NOT NULL,
    account_id integer NOT NULL
);


--
-- Name: TABLE account_account_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_account_type_rel IS 'RELATION BETWEEN account_journal AND account_account';


--
-- Name: account_addtmpl_wizard; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_addtmpl_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    cparent_id integer NOT NULL
);


--
-- Name: TABLE account_addtmpl_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_addtmpl_wizard IS 'account.addtmpl.wizard';


--
-- Name: COLUMN account_addtmpl_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_addtmpl_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_addtmpl_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_addtmpl_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_addtmpl_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_addtmpl_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_addtmpl_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_addtmpl_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_addtmpl_wizard.cparent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_addtmpl_wizard.cparent_id IS 'Parent target';


--
-- Name: account_addtmpl_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_addtmpl_wizard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_addtmpl_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_addtmpl_wizard_id_seq OWNED BY account_addtmpl_wizard.id;


--
-- Name: account_aged_trial_balance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_aged_trial_balance (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    period_length integer NOT NULL,
    period_to integer,
    date_from date,
    direction_selection character varying NOT NULL,
    result_selection character varying NOT NULL,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_aged_trial_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_aged_trial_balance IS 'Account Aged Trial balance Report';


--
-- Name: COLUMN account_aged_trial_balance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.create_uid IS 'Created by';


--
-- Name: COLUMN account_aged_trial_balance.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_aged_trial_balance.period_length; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.period_length IS 'Period Length (days)';


--
-- Name: COLUMN account_aged_trial_balance.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.period_to IS 'End Period';


--
-- Name: COLUMN account_aged_trial_balance.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.date_from IS 'Start Date';


--
-- Name: COLUMN account_aged_trial_balance.direction_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.direction_selection IS 'Analysis Direction';


--
-- Name: COLUMN account_aged_trial_balance.result_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.result_selection IS 'Partner''s';


--
-- Name: COLUMN account_aged_trial_balance.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.filter IS 'Filter by';


--
-- Name: COLUMN account_aged_trial_balance.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.period_from IS 'Start Period';


--
-- Name: COLUMN account_aged_trial_balance.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_aged_trial_balance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_aged_trial_balance.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.date_to IS 'End Date';


--
-- Name: COLUMN account_aged_trial_balance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.create_date IS 'Created on';


--
-- Name: COLUMN account_aged_trial_balance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_aged_trial_balance.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_aged_trial_balance.target_move IS 'Target Moves';


--
-- Name: account_aged_trial_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_aged_trial_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_aged_trial_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_aged_trial_balance_id_seq OWNED BY account_aged_trial_balance.id;


--
-- Name: account_aged_trial_balance_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_aged_trial_balance_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_aged_trial_balance_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_aged_trial_balance_journal_rel IS 'RELATION BETWEEN account_aged_trial_balance AND account_journal';


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_account (
    id integer NOT NULL,
    code character varying,
    create_date timestamp without time zone,
    quantity_max double precision,
    write_uid integer,
    currency_id integer,
    partner_id integer,
    create_uid integer,
    user_id integer,
    date_start date,
    message_last_post timestamp without time zone,
    company_id integer,
    parent_id integer,
    state character varying NOT NULL,
    manager_id integer,
    type character varying NOT NULL,
    description text,
    write_date timestamp without time zone,
    date date,
    name character varying NOT NULL,
    template_id integer,
    use_timesheets boolean,
    amount_max double precision,
    pricelist_id integer,
    to_invoice integer
);


--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.quantity_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.quantity_max IS 'Prepaid Service Units';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.user_id IS 'Project Manager';


--
-- Name: COLUMN account_analytic_account.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.date_start IS 'Start Date';


--
-- Name: COLUMN account_analytic_account.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.parent_id IS 'Parent Analytic Account';


--
-- Name: COLUMN account_analytic_account.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.state IS 'Status';


--
-- Name: COLUMN account_analytic_account.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.manager_id IS 'Account Manager';


--
-- Name: COLUMN account_analytic_account.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.type IS 'Type of Account';


--
-- Name: COLUMN account_analytic_account.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.description IS 'Description';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.date IS 'Expiration Date';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.name IS 'Account/Contract Name';


--
-- Name: COLUMN account_analytic_account.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.template_id IS 'Template of Contract';


--
-- Name: COLUMN account_analytic_account.use_timesheets; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.use_timesheets IS 'Timesheets';


--
-- Name: COLUMN account_analytic_account.amount_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.amount_max IS 'Max. Invoice Price';


--
-- Name: COLUMN account_analytic_account.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN account_analytic_account.to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_account.to_invoice IS 'Timesheet Invoicing Ratio';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_account_id_seq OWNED BY account_analytic_account.id;


--
-- Name: account_analytic_balance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_balance (
    id integer NOT NULL,
    date1 date NOT NULL,
    create_uid integer,
    date2 date NOT NULL,
    create_date timestamp without time zone,
    empty_acc boolean,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_balance IS 'Account Analytic Balance';


--
-- Name: COLUMN account_analytic_balance.date1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.date1 IS 'Start of period';


--
-- Name: COLUMN account_analytic_balance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_balance.date2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.date2 IS 'End of period';


--
-- Name: COLUMN account_analytic_balance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_balance.empty_acc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.empty_acc IS 'Empty Accounts ? ';


--
-- Name: COLUMN account_analytic_balance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_balance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_balance.write_date IS 'Last Updated on';


--
-- Name: account_analytic_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_balance_id_seq OWNED BY account_analytic_balance.id;


--
-- Name: account_analytic_chart; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_chart (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    from_date date,
    to_date date,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_chart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_chart IS 'Account Analytic Chart';


--
-- Name: COLUMN account_analytic_chart.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_chart.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_chart.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_chart.from_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.from_date IS 'From';


--
-- Name: COLUMN account_analytic_chart.to_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.to_date IS 'To';


--
-- Name: COLUMN account_analytic_chart.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_chart.write_date IS 'Last Updated on';


--
-- Name: account_analytic_chart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_chart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_chart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_chart_id_seq OWNED BY account_analytic_chart.id;


--
-- Name: account_analytic_cost_ledger; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_cost_ledger (
    id integer NOT NULL,
    date1 date NOT NULL,
    create_uid integer,
    date2 date NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_cost_ledger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_cost_ledger IS 'Account Analytic Cost Ledger';


--
-- Name: COLUMN account_analytic_cost_ledger.date1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.date1 IS 'Start of period';


--
-- Name: COLUMN account_analytic_cost_ledger.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_cost_ledger.date2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.date2 IS 'End of period';


--
-- Name: COLUMN account_analytic_cost_ledger.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_cost_ledger.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_cost_ledger.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger.write_date IS 'Last Updated on';


--
-- Name: account_analytic_cost_ledger_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_cost_ledger_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_cost_ledger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_cost_ledger_id_seq OWNED BY account_analytic_cost_ledger.id;


--
-- Name: account_analytic_cost_ledger_journal_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_cost_ledger_journal_report (
    id integer NOT NULL,
    date1 date NOT NULL,
    create_uid integer,
    date2 date NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_cost_ledger_journal_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_cost_ledger_journal_report IS 'Account Analytic Cost Ledger For Journal Report';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.date1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.date1 IS 'Start of period';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.date2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.date2 IS 'End of period';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_cost_ledger_journal_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_cost_ledger_journal_report.write_date IS 'Last Updated on';


--
-- Name: account_analytic_cost_ledger_journal_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_cost_ledger_journal_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_cost_ledger_journal_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_cost_ledger_journal_report_id_seq OWNED BY account_analytic_cost_ledger_journal_report.id;


--
-- Name: account_analytic_inverted_balance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_inverted_balance (
    id integer NOT NULL,
    date1 date NOT NULL,
    create_uid integer,
    date2 date NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_inverted_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_inverted_balance IS 'Account Analytic Inverted Balance';


--
-- Name: COLUMN account_analytic_inverted_balance.date1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.date1 IS 'Start of period';


--
-- Name: COLUMN account_analytic_inverted_balance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_inverted_balance.date2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.date2 IS 'End of period';


--
-- Name: COLUMN account_analytic_inverted_balance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_inverted_balance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_inverted_balance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_inverted_balance.write_date IS 'Last Updated on';


--
-- Name: account_analytic_inverted_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_inverted_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_inverted_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_inverted_balance_id_seq OWNED BY account_analytic_inverted_balance.id;


--
-- Name: account_analytic_journal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_journal (
    id integer NOT NULL,
    create_uid integer,
    code character varying(8),
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    active boolean,
    type character varying NOT NULL
);


--
-- Name: TABLE account_analytic_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_journal IS 'Analytic Journal';


--
-- Name: COLUMN account_analytic_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_journal.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.code IS 'Journal Code';


--
-- Name: COLUMN account_analytic_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_journal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_analytic_journal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_journal.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.active IS 'Active';


--
-- Name: COLUMN account_analytic_journal.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal.type IS 'Type';


--
-- Name: account_analytic_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_journal_id_seq OWNED BY account_analytic_journal.id;


--
-- Name: account_analytic_journal_name; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_journal_name (
    journal_line_id integer NOT NULL,
    journal_print_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_journal_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_journal_name IS 'RELATION BETWEEN account_analytic_journal_report AND account_analytic_journal';


--
-- Name: account_analytic_journal_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_journal_report (
    id integer NOT NULL,
    date1 date NOT NULL,
    create_uid integer,
    date2 date NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_journal_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_journal_report IS 'Account Analytic Journal';


--
-- Name: COLUMN account_analytic_journal_report.date1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.date1 IS 'Start of period';


--
-- Name: COLUMN account_analytic_journal_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_journal_report.date2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.date2 IS 'End of period';


--
-- Name: COLUMN account_analytic_journal_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_journal_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_journal_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_journal_report.write_date IS 'Last Updated on';


--
-- Name: account_analytic_journal_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_journal_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_journal_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_journal_report_id_seq OWNED BY account_analytic_journal_report.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_analytic_line (
    id integer NOT NULL,
    create_uid integer,
    user_id integer,
    account_id integer NOT NULL,
    company_id integer,
    write_uid integer,
    amount numeric NOT NULL,
    unit_amount double precision,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    name character varying NOT NULL,
    code character varying(8),
    general_account_id integer NOT NULL,
    product_uom_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    product_id integer,
    amount_currency numeric,
    ref character varying,
    move_id integer,
    invoice_id integer,
    to_invoice integer
);


--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.general_account_id IS 'General Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.journal_id IS 'Analytic Journal';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.move_id IS 'Move Line';


--
-- Name: COLUMN account_analytic_line.invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_analytic_line.to_invoice IS 'Invoiceable';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_analytic_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_analytic_line_id_seq OWNED BY account_analytic_line.id;


--
-- Name: account_automatic_reconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_automatic_reconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    power integer NOT NULL,
    max_amount double precision,
    unreconciled integer,
    reconciled integer,
    journal_id integer,
    allow_write_off boolean,
    writeoff_acc_id integer,
    period_id integer,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_automatic_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_automatic_reconcile IS 'Automatic Reconcile';


--
-- Name: COLUMN account_automatic_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_reconcile.power; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.power IS 'Power';


--
-- Name: COLUMN account_automatic_reconcile.max_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.max_amount IS 'Maximum write-off amount';


--
-- Name: COLUMN account_automatic_reconcile.unreconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.unreconciled IS 'Not reconciled transactions';


--
-- Name: COLUMN account_automatic_reconcile.reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.reconciled IS 'Reconciled transactions';


--
-- Name: COLUMN account_automatic_reconcile.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.journal_id IS 'Journal';


--
-- Name: COLUMN account_automatic_reconcile.allow_write_off; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.allow_write_off IS 'Allow write off';


--
-- Name: COLUMN account_automatic_reconcile.writeoff_acc_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.writeoff_acc_id IS 'Account';


--
-- Name: COLUMN account_automatic_reconcile.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.period_id IS 'Period';


--
-- Name: COLUMN account_automatic_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_automatic_reconcile.write_uid IS 'Last Updated by';


--
-- Name: account_automatic_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_automatic_reconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_automatic_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_automatic_reconcile_id_seq OWNED BY account_automatic_reconcile.id;


--
-- Name: account_balance_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_balance_report (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    display_account character varying NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_balance_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_balance_report IS 'Trial Balance Report';


--
-- Name: COLUMN account_balance_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_balance_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_balance_report.display_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.display_account IS 'Display Accounts';


--
-- Name: COLUMN account_balance_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_balance_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.period_to IS 'End Period';


--
-- Name: COLUMN account_balance_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.filter IS 'Filter by';


--
-- Name: COLUMN account_balance_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.period_from IS 'Start Period';


--
-- Name: COLUMN account_balance_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_balance_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_balance_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.date_to IS 'End Date';


--
-- Name: COLUMN account_balance_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.create_date IS 'Created on';


--
-- Name: COLUMN account_balance_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_balance_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_balance_report.target_move IS 'Target Moves';


--
-- Name: account_balance_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_balance_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_balance_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_balance_report_id_seq OWNED BY account_balance_report.id;


--
-- Name: account_balance_report_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_balance_report_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_balance_report_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_balance_report_journal_rel IS 'RELATION BETWEEN account_balance_report AND account_journal';


--
-- Name: account_bank_accounts_wizard; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_bank_accounts_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    bank_account_id integer NOT NULL,
    acc_name character varying NOT NULL,
    write_uid integer,
    currency_id integer,
    write_date timestamp without time zone,
    account_type character varying
);


--
-- Name: TABLE account_bank_accounts_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_bank_accounts_wizard IS 'account.bank.accounts.wizard';


--
-- Name: COLUMN account_bank_accounts_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_accounts_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_accounts_wizard.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_bank_accounts_wizard.acc_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.acc_name IS 'Account Name.';


--
-- Name: COLUMN account_bank_accounts_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_accounts_wizard.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.currency_id IS 'Secondary Currency';


--
-- Name: COLUMN account_bank_accounts_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_accounts_wizard.account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_accounts_wizard.account_type IS 'Account Type';


--
-- Name: account_bank_accounts_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_bank_accounts_wizard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_accounts_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_bank_accounts_wizard_id_seq OWNED BY account_bank_accounts_wizard.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_bank_statement (
    id integer NOT NULL,
    create_date timestamp without time zone,
    balance_start numeric,
    company_id integer,
    write_uid integer,
    create_uid integer,
    user_id integer,
    message_last_post timestamp without time zone,
    journal_id integer NOT NULL,
    state character varying NOT NULL,
    period_id integer NOT NULL,
    total_entry_encoding numeric,
    write_date timestamp without time zone,
    date date NOT NULL,
    name character varying,
    closing_date timestamp without time zone,
    balance_end numeric,
    balance_end_real numeric
);


--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.user_id IS 'Responsible';


--
-- Name: COLUMN account_bank_statement.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.state IS 'Status';


--
-- Name: COLUMN account_bank_statement.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.period_id IS 'Period';


--
-- Name: COLUMN account_bank_statement.total_entry_encoding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.total_entry_encoding IS 'Total Transactions';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.closing_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.closing_date IS 'Closed On';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_bank_statement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_bank_statement_id_seq OWNED BY account_bank_statement.id;


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_bank_statement_line (
    id integer NOT NULL,
    create_uid integer,
    note text,
    create_date timestamp without time zone,
    statement_id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    partner_name character varying,
    ref character varying,
    journal_id integer,
    amount_currency numeric,
    company_id integer,
    currency_id integer,
    amount numeric,
    write_date timestamp without time zone,
    bank_account_id integer,
    date date NOT NULL,
    journal_entry_id integer,
    write_uid integer,
    partner_id integer,
    account_id integer
);


--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.note IS 'Notes';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.name IS 'Communication';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.ref IS 'Reference';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_bank_statement_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line.journal_entry_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.journal_entry_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bank_statement_line.account_id IS 'Account';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_bank_statement_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_bank_statement_line_id_seq OWNED BY account_bank_statement_line.id;


--
-- Name: account_bilan_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_bilan_report (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    fiscalyear_id integer NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bilan_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_bilan_report IS 'Account Bilan Report';


--
-- Name: COLUMN account_bilan_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bilan_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_bilan_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bilan_report.create_date IS 'Created on';


--
-- Name: COLUMN account_bilan_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bilan_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bilan_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bilan_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_bilan_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_bilan_report.write_date IS 'Last Updated on';


--
-- Name: account_bilan_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_bilan_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bilan_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_bilan_report_id_seq OWNED BY account_bilan_report.id;


--
-- Name: account_cashbox_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_cashbox_line (
    id integer NOT NULL,
    bank_statement_id integer,
    create_date timestamp without time zone,
    create_uid integer,
    pieces numeric,
    number_closing integer,
    write_date timestamp without time zone,
    number_opening integer,
    write_uid integer
);


--
-- Name: TABLE account_cashbox_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_cashbox_line IS 'CashBox Line';


--
-- Name: COLUMN account_cashbox_line.bank_statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.bank_statement_id IS 'unknown';


--
-- Name: COLUMN account_cashbox_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_line.pieces; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.pieces IS 'Unit of Currency';


--
-- Name: COLUMN account_cashbox_line.number_closing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.number_closing IS 'Number of Units';


--
-- Name: COLUMN account_cashbox_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cashbox_line.number_opening; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.number_opening IS 'Number of Units';


--
-- Name: COLUMN account_cashbox_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cashbox_line.write_uid IS 'Last Updated by';


--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_cashbox_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_cashbox_line_id_seq OWNED BY account_cashbox_line.id;


--
-- Name: account_cdr_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_cdr_report (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    fiscalyear_id integer NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_cdr_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_cdr_report IS 'Account CDR Report';


--
-- Name: COLUMN account_cdr_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cdr_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_cdr_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cdr_report.create_date IS 'Created on';


--
-- Name: COLUMN account_cdr_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cdr_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cdr_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cdr_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_cdr_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_cdr_report.write_date IS 'Last Updated on';


--
-- Name: account_cdr_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_cdr_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_cdr_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_cdr_report_id_seq OWNED BY account_cdr_report.id;


--
-- Name: account_central_journal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_central_journal (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    amount_currency boolean,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_central_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_central_journal IS 'Account Central Journal';


--
-- Name: COLUMN account_central_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_central_journal.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_central_journal.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.date_from IS 'Start Date';


--
-- Name: COLUMN account_central_journal.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.period_to IS 'End Period';


--
-- Name: COLUMN account_central_journal.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.filter IS 'Filter by';


--
-- Name: COLUMN account_central_journal.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.period_from IS 'Start Period';


--
-- Name: COLUMN account_central_journal.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_central_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_central_journal.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.date_to IS 'End Date';


--
-- Name: COLUMN account_central_journal.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_central_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_central_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_central_journal.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_central_journal.target_move IS 'Target Moves';


--
-- Name: account_central_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_central_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_central_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_central_journal_id_seq OWNED BY account_central_journal.id;


--
-- Name: account_central_journal_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_central_journal_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_central_journal_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_central_journal_journal_rel IS 'RELATION BETWEEN account_central_journal AND account_journal';


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_change_currency (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    currency_id integer NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_change_currency.currency_id IS 'Change to';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_change_currency.write_date IS 'Last Updated on';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_change_currency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_change_currency_id_seq OWNED BY account_change_currency.id;


--
-- Name: account_chart; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_chart (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    period_to integer,
    write_uid integer,
    period_from integer,
    write_date timestamp without time zone,
    target_move character varying NOT NULL,
    fiscalyear integer
);


--
-- Name: TABLE account_chart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_chart IS 'Account chart';


--
-- Name: COLUMN account_chart.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.create_uid IS 'Created by';


--
-- Name: COLUMN account_chart.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.create_date IS 'Created on';


--
-- Name: COLUMN account_chart.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.period_to IS 'End period';


--
-- Name: COLUMN account_chart.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_chart.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.period_from IS 'Start period';


--
-- Name: COLUMN account_chart.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_chart.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.target_move IS 'Target Moves';


--
-- Name: COLUMN account_chart.fiscalyear; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart.fiscalyear IS 'Fiscal year';


--
-- Name: account_chart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_chart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_chart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_chart_id_seq OWNED BY account_chart.id;


--
-- Name: account_chart_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_chart_template (
    id integer NOT NULL,
    property_account_income_opening integer,
    create_date timestamp without time zone,
    write_uid integer,
    currency_id integer,
    visible boolean,
    tax_code_root_id integer,
    property_account_income integer,
    create_uid integer,
    complete_tax_set boolean,
    property_account_payable integer,
    parent_id integer,
    bank_account_view_id integer,
    property_account_expense_categ integer,
    property_account_expense_opening integer,
    write_date timestamp without time zone,
    property_account_income_categ integer,
    code_digits integer NOT NULL,
    name character varying NOT NULL,
    property_account_expense integer,
    property_account_receivable integer,
    account_root_id integer
);


--
-- Name: TABLE account_chart_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_chart_template IS 'Templates for Account Chart';


--
-- Name: COLUMN account_chart_template.property_account_income_opening; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_income_opening IS 'Opening Entries Income Account';


--
-- Name: COLUMN account_chart_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.create_date IS 'Created on';


--
-- Name: COLUMN account_chart_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_chart_template.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.currency_id IS 'Currency';


--
-- Name: COLUMN account_chart_template.visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.visible IS 'Can be Visible?';


--
-- Name: COLUMN account_chart_template.tax_code_root_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.tax_code_root_id IS 'Root Tax Code';


--
-- Name: COLUMN account_chart_template.property_account_income; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_income IS 'Income Account on Product Template';


--
-- Name: COLUMN account_chart_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_chart_template.complete_tax_set; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.complete_tax_set IS 'Complete Set of Taxes';


--
-- Name: COLUMN account_chart_template.property_account_payable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_payable IS 'Payable Account';


--
-- Name: COLUMN account_chart_template.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.parent_id IS 'Parent Chart Template';


--
-- Name: COLUMN account_chart_template.bank_account_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.bank_account_view_id IS 'Bank Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_categ; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_expense_categ IS 'Expense Category Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_opening; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_expense_opening IS 'Opening Entries Expense Account';


--
-- Name: COLUMN account_chart_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_chart_template.property_account_income_categ; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_income_categ IS 'Income Category Account';


--
-- Name: COLUMN account_chart_template.code_digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.code_digits IS '# of Digits';


--
-- Name: COLUMN account_chart_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.name IS 'Name';


--
-- Name: COLUMN account_chart_template.property_account_expense; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_expense IS 'Expense Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_account_receivable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.property_account_receivable IS 'Receivable Account';


--
-- Name: COLUMN account_chart_template.account_root_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_chart_template.account_root_id IS 'Root Account';


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_chart_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_chart_template_id_seq OWNED BY account_chart_template.id;


--
-- Name: account_common_account_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_account_report (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    display_account character varying NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_common_account_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_account_report IS 'Account Common Account Report';


--
-- Name: COLUMN account_common_account_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_account_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_common_account_report.display_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.display_account IS 'Display Accounts';


--
-- Name: COLUMN account_common_account_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_account_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.period_to IS 'End Period';


--
-- Name: COLUMN account_common_account_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.filter IS 'Filter by';


--
-- Name: COLUMN account_common_account_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.period_from IS 'Start Period';


--
-- Name: COLUMN account_common_account_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_common_account_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_common_account_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_account_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_account_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_account_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_account_report.target_move IS 'Target Moves';


--
-- Name: account_common_account_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_account_report_account_journal_rel (
    account_common_account_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_account_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_account_report_account_journal_rel IS 'RELATION BETWEEN account_common_account_report AND account_journal';


--
-- Name: account_common_account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_common_account_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_common_account_report_id_seq OWNED BY account_common_account_report.id;


--
-- Name: account_common_journal_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_journal_report (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    amount_currency boolean,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_common_journal_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_journal_report IS 'Account Common Journal Report';


--
-- Name: COLUMN account_common_journal_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_journal_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_common_journal_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_journal_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.period_to IS 'End Period';


--
-- Name: COLUMN account_common_journal_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.filter IS 'Filter by';


--
-- Name: COLUMN account_common_journal_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.period_from IS 'Start Period';


--
-- Name: COLUMN account_common_journal_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_common_journal_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_common_journal_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_journal_report.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_common_journal_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_journal_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_journal_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_journal_report.target_move IS 'Target Moves';


--
-- Name: account_common_journal_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_journal_report_account_journal_rel (
    account_common_journal_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_journal_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_journal_report_account_journal_rel IS 'RELATION BETWEEN account_common_journal_report AND account_journal';


--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_common_journal_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_common_journal_report_id_seq OWNED BY account_common_journal_report.id;


--
-- Name: account_common_partner_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_partner_report (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    period_to integer,
    date_from date,
    result_selection character varying NOT NULL,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_common_partner_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_partner_report IS 'Account Common Partner Report';


--
-- Name: COLUMN account_common_partner_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_partner_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_common_partner_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.period_to IS 'End Period';


--
-- Name: COLUMN account_common_partner_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_partner_report.result_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.result_selection IS 'Partner''s';


--
-- Name: COLUMN account_common_partner_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.filter IS 'Filter by';


--
-- Name: COLUMN account_common_partner_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.period_from IS 'Start Period';


--
-- Name: COLUMN account_common_partner_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_common_partner_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_common_partner_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_partner_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_partner_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_partner_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_partner_report.target_move IS 'Target Moves';


--
-- Name: account_common_partner_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_partner_report_account_journal_rel (
    account_common_partner_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_partner_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_partner_report_account_journal_rel IS 'RELATION BETWEEN account_common_partner_report AND account_journal';


--
-- Name: account_common_partner_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_common_partner_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_partner_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_common_partner_report_id_seq OWNED BY account_common_partner_report.id;


--
-- Name: account_common_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_report (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_common_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_report IS 'Account Common Report';


--
-- Name: COLUMN account_common_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_common_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.period_to IS 'End Period';


--
-- Name: COLUMN account_common_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.filter IS 'Filter by';


--
-- Name: COLUMN account_common_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.period_from IS 'Start Period';


--
-- Name: COLUMN account_common_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_common_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_common_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_common_report.target_move IS 'Target Moves';


--
-- Name: account_common_report_account_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_common_report_account_journal_rel (
    account_common_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_common_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_common_report_account_journal_rel IS 'RELATION BETWEEN account_common_report AND account_journal';


--
-- Name: account_common_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_common_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_common_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_common_report_id_seq OWNED BY account_common_report.id;


--
-- Name: account_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_config_settings (
    id integer NOT NULL,
    date_stop date NOT NULL,
    sale_journal_id integer,
    module_account_voucher boolean,
    module_account_asset boolean,
    period character varying NOT NULL,
    write_uid integer,
    module_account_accountant boolean,
    module_account_followup boolean,
    purchase_journal_id integer,
    create_date timestamp without time zone,
    has_chart_of_accounts boolean,
    sale_refund_journal_id integer,
    create_uid integer,
    complete_tax_set boolean,
    module_account_budget boolean,
    date_start date NOT NULL,
    purchase_refund_journal_id integer,
    company_id integer NOT NULL,
    group_check_supplier_invoice_total boolean,
    group_multi_currency boolean,
    group_proforma_invoices boolean,
    default_purchase_tax integer,
    module_product_email_template boolean,
    has_default_company boolean,
    purchase_tax_rate double precision,
    decimal_precision integer,
    default_sale_tax integer,
    has_fiscal_year boolean,
    module_account_payment boolean,
    sale_tax integer,
    purchase_tax integer,
    module_account_check_writing boolean,
    code_digits integer,
    write_date timestamp without time zone,
    sale_tax_rate double precision,
    chart_template_id integer,
    group_analytic_accounting boolean,
    module_payment_paypal boolean,
    module_payment_buckaroo boolean,
    module_payment_adyen boolean,
    module_payment_ogone boolean,
    group_analytic_account_for_sales boolean,
    module_sale_analytic_plans boolean,
    group_payment_options boolean,
    module_purchase_analytic_plans boolean,
    group_analytic_account_for_purchases boolean
);


--
-- Name: TABLE account_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_config_settings IS 'account.config.settings';


--
-- Name: COLUMN account_config_settings.date_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.date_stop IS 'End date';


--
-- Name: COLUMN account_config_settings.sale_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.sale_journal_id IS 'Sale journal';


--
-- Name: COLUMN account_config_settings.module_account_voucher; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_voucher IS 'Manage customer payments';


--
-- Name: COLUMN account_config_settings.module_account_asset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_asset IS 'Assets management';


--
-- Name: COLUMN account_config_settings.period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.period IS 'Periods';


--
-- Name: COLUMN account_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_config_settings.module_account_accountant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_accountant IS 'Full accounting features: journals, legal statements, chart of accounts, etc.';


--
-- Name: COLUMN account_config_settings.module_account_followup; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_followup IS 'Manage customer payment follow-ups';


--
-- Name: COLUMN account_config_settings.purchase_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.purchase_journal_id IS 'Purchase journal';


--
-- Name: COLUMN account_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN account_config_settings.has_chart_of_accounts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.has_chart_of_accounts IS 'Company has a chart of accounts';


--
-- Name: COLUMN account_config_settings.sale_refund_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.sale_refund_journal_id IS 'Sale refund journal';


--
-- Name: COLUMN account_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN account_config_settings.complete_tax_set; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.complete_tax_set IS 'Complete set of taxes';


--
-- Name: COLUMN account_config_settings.module_account_budget; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_budget IS 'Budget management';


--
-- Name: COLUMN account_config_settings.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.date_start IS 'Start date';


--
-- Name: COLUMN account_config_settings.purchase_refund_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.purchase_refund_journal_id IS 'Purchase refund journal';


--
-- Name: COLUMN account_config_settings.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.company_id IS 'Company';


--
-- Name: COLUMN account_config_settings.group_check_supplier_invoice_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_check_supplier_invoice_total IS 'Check the total of supplier invoices';


--
-- Name: COLUMN account_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_multi_currency IS 'Allow multi currencies';


--
-- Name: COLUMN account_config_settings.group_proforma_invoices; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_proforma_invoices IS 'Allow pro-forma invoices';


--
-- Name: COLUMN account_config_settings.default_purchase_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.default_purchase_tax IS 'Default purchase tax';


--
-- Name: COLUMN account_config_settings.module_product_email_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_product_email_template IS 'Send products tools and information at the invoice confirmation';


--
-- Name: COLUMN account_config_settings.has_default_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.has_default_company IS 'Has default company';


--
-- Name: COLUMN account_config_settings.purchase_tax_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.purchase_tax_rate IS 'Purchase tax (%)';


--
-- Name: COLUMN account_config_settings.decimal_precision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.decimal_precision IS 'Decimal precision on journal entries';


--
-- Name: COLUMN account_config_settings.default_sale_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.default_sale_tax IS 'Default sale tax';


--
-- Name: COLUMN account_config_settings.has_fiscal_year; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.has_fiscal_year IS 'Company has a fiscal year';


--
-- Name: COLUMN account_config_settings.module_account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_payment IS 'Manage payment orders';


--
-- Name: COLUMN account_config_settings.sale_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.sale_tax IS 'Default sale tax';


--
-- Name: COLUMN account_config_settings.purchase_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.purchase_tax IS 'Default purchase tax';


--
-- Name: COLUMN account_config_settings.module_account_check_writing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_account_check_writing IS 'Pay your suppliers by check';


--
-- Name: COLUMN account_config_settings.code_digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.code_digits IS '# of Digits';


--
-- Name: COLUMN account_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_config_settings.sale_tax_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.sale_tax_rate IS 'Sales tax (%)';


--
-- Name: COLUMN account_config_settings.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.chart_template_id IS 'Template';


--
-- Name: COLUMN account_config_settings.group_analytic_accounting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_analytic_accounting IS 'Analytic accounting';


--
-- Name: COLUMN account_config_settings.module_payment_paypal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_payment_paypal IS 'Manage Payments Using Paypal';


--
-- Name: COLUMN account_config_settings.module_payment_buckaroo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_payment_buckaroo IS 'Manage Payments Using Buckaroo';


--
-- Name: COLUMN account_config_settings.module_payment_adyen; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_payment_adyen IS 'Manage Payments Using Adyen';


--
-- Name: COLUMN account_config_settings.module_payment_ogone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_payment_ogone IS 'Manage Payments Using Ogone';


--
-- Name: COLUMN account_config_settings.group_analytic_account_for_sales; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_analytic_account_for_sales IS 'Analytic accounting for sales';


--
-- Name: COLUMN account_config_settings.module_sale_analytic_plans; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_sale_analytic_plans IS 'Use multiple analytic accounts on sales';


--
-- Name: COLUMN account_config_settings.group_payment_options; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_payment_options IS 'Show payment buttons to employees too';


--
-- Name: COLUMN account_config_settings.module_purchase_analytic_plans; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.module_purchase_analytic_plans IS 'Use multiple analytic accounts on orders';


--
-- Name: COLUMN account_config_settings.group_analytic_account_for_purchases; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_config_settings.group_analytic_account_for_purchases IS 'Analytic accounting for purchases';


--
-- Name: account_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_config_settings_id_seq OWNED BY account_config_settings.id;


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move (
    id integer NOT NULL,
    create_uid integer,
    partner_id integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    journal_id integer NOT NULL,
    state character varying NOT NULL,
    period_id integer NOT NULL,
    write_date timestamp without time zone,
    narration text,
    date date NOT NULL,
    balance numeric,
    ref character varying,
    to_check boolean
);


--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move IS 'Account Entry';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.name IS 'Number';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.state IS 'Status';


--
-- Name: COLUMN account_move.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.period_id IS 'Period';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.narration IS 'Internal Note';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.date IS 'Date';


--
-- Name: COLUMN account_move.balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.balance IS 'balance';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move.to_check IS 'To Review';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line (
    id integer NOT NULL,
    create_date timestamp without time zone,
    statement_id integer,
    company_id integer,
    currency_id integer,
    date_maturity date,
    partner_id integer,
    reconcile_partial_id integer,
    blocked boolean,
    analytic_account_id integer,
    create_uid integer,
    credit numeric,
    centralisation character varying(8),
    journal_id integer NOT NULL,
    reconcile_ref character varying,
    tax_code_id integer,
    state character varying,
    debit numeric,
    ref character varying,
    account_id integer NOT NULL,
    period_id integer NOT NULL,
    write_date timestamp without time zone,
    date_created date,
    date date NOT NULL,
    write_uid integer,
    move_id integer NOT NULL,
    name character varying NOT NULL,
    reconcile_id integer,
    tax_amount numeric,
    product_id integer,
    account_tax_id integer,
    product_uom_id integer,
    amount_currency numeric,
    quantity numeric,
    CONSTRAINT account_move_line_credit_debit1 CHECK (((credit * debit) = (0)::numeric)),
    CONSTRAINT account_move_line_credit_debit2 CHECK (((credit + debit) >= (0)::numeric))
);


--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line IS 'Journal Items';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.date_maturity IS 'Due date';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_partial_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.reconcile_partial_id IS 'Partial Reconcile';


--
-- Name: COLUMN account_move_line.blocked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.blocked IS 'No Follow-up';


--
-- Name: COLUMN account_move_line.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.centralisation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.centralisation IS 'Centralisation';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.reconcile_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.reconcile_ref IS 'Reconcile Ref';


--
-- Name: COLUMN account_move_line.tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.tax_code_id IS 'Tax Account';


--
-- Name: COLUMN account_move_line.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.state IS 'Status';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.period_id IS 'Period';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.date_created; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.date_created IS 'Creation date';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.date IS 'Effective date';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.name IS 'Name';


--
-- Name: COLUMN account_move_line.reconcile_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.reconcile_id IS 'Reconcile';


--
-- Name: COLUMN account_move_line.tax_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.tax_amount IS 'Tax/Base Amount';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.account_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.account_tax_id IS 'Tax';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line.quantity IS 'Quantity';


--
-- Name: account_period; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_period (
    id integer NOT NULL,
    create_uid integer,
    date_stop date NOT NULL,
    code character varying(12),
    create_date timestamp without time zone,
    name character varying NOT NULL,
    date_start date NOT NULL,
    company_id integer,
    write_uid integer,
    fiscalyear_id integer NOT NULL,
    state character varying,
    write_date timestamp without time zone,
    special boolean
);


--
-- Name: TABLE account_period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_period IS 'Account period';


--
-- Name: COLUMN account_period.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.create_uid IS 'Created by';


--
-- Name: COLUMN account_period.date_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.date_stop IS 'End of Period';


--
-- Name: COLUMN account_period.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.code IS 'Code';


--
-- Name: COLUMN account_period.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.create_date IS 'Created on';


--
-- Name: COLUMN account_period.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.name IS 'Period Name';


--
-- Name: COLUMN account_period.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.date_start IS 'Start of Period';


--
-- Name: COLUMN account_period.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.company_id IS 'Company';


--
-- Name: COLUMN account_period.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_period.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_period.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.state IS 'Status';


--
-- Name: COLUMN account_period.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_period.special; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period.special IS 'Opening/Closing Period';


--
-- Name: account_entries_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW account_entries_report AS
    SELECT l.id, am.date, l.date_maturity, l.date_created, am.ref, am.state AS move_state, l.state AS move_line_state, l.reconcile_id, l.partner_id, l.product_id, l.product_uom_id, am.company_id, am.journal_id, p.fiscalyear_id, am.period_id, l.account_id, l.analytic_account_id, a.type, a.user_type, 1 AS nbr, l.quantity, l.currency_id, l.amount_currency, l.debit, l.credit, (COALESCE(l.debit, 0.0) - COALESCE(l.credit, 0.0)) AS balance FROM (((account_move_line l LEFT JOIN account_account a ON ((l.account_id = a.id))) LEFT JOIN account_move am ON ((am.id = l.move_id))) LEFT JOIN account_period p ON ((am.period_id = p.id))) WHERE ((l.state)::text <> 'draft'::text);


--
-- Name: account_financial_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_financial_report (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    account_report_id integer,
    style_overwrite integer,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone,
    display_detail character varying,
    sign integer NOT NULL,
    type character varying,
    level integer
);


--
-- Name: TABLE account_financial_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_financial_report IS 'Account Report';


--
-- Name: COLUMN account_financial_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_report.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.name IS 'Report Name';


--
-- Name: COLUMN account_financial_report.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_financial_report.account_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.account_report_id IS 'Report Value';


--
-- Name: COLUMN account_financial_report.style_overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.style_overwrite IS 'Financial Report Style';


--
-- Name: COLUMN account_financial_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_report.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.parent_id IS 'Parent';


--
-- Name: COLUMN account_financial_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_financial_report.display_detail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.display_detail IS 'Display details';


--
-- Name: COLUMN account_financial_report.sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.sign IS 'Sign on Reports';


--
-- Name: COLUMN account_financial_report.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.type IS 'Type';


--
-- Name: COLUMN account_financial_report.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_financial_report.level IS 'Level';


--
-- Name: account_financial_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_financial_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_financial_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_financial_report_id_seq OWNED BY account_financial_report.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position (
    id integer NOT NULL,
    create_uid integer,
    country_group_id integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    country_id integer,
    company_id integer,
    auto_apply boolean,
    write_uid integer,
    note text,
    write_date timestamp without time zone,
    vat_required boolean,
    active boolean
);


--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.auto_apply IS 'Automatic';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position.active IS 'Active';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position_account (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    position_id integer NOT NULL,
    write_uid integer,
    account_dest_id integer NOT NULL,
    write_date timestamp without time zone,
    account_src_id integer NOT NULL
);


--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position_account IS 'Accounts Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.account_dest_id IS 'Account Destination';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account.account_src_id IS 'Account Source';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_account_id_seq OWNED BY account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position_account_template (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    position_id integer NOT NULL,
    write_uid integer,
    account_dest_id integer NOT NULL,
    write_date timestamp without time zone,
    account_src_id integer NOT NULL
);


--
-- Name: TABLE account_fiscal_position_account_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position_account_template IS 'Template Account Fiscal Mapping';


--
-- Name: COLUMN account_fiscal_position_account_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account_template.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.position_id IS 'Fiscal Mapping';


--
-- Name: COLUMN account_fiscal_position_account_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account_template.account_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.account_dest_id IS 'Account Destination';


--
-- Name: COLUMN account_fiscal_position_account_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position_account_template.account_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_account_template.account_src_id IS 'Account Source';


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_account_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_account_template_id_seq OWNED BY account_fiscal_position_account_template.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_id_seq OWNED BY account_fiscal_position.id;


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position_tax (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    write_uid integer,
    tax_dest_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position_tax IS 'Taxes Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.tax_src_id IS 'Tax Source';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.tax_dest_id IS 'Replacement Tax';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_tax_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_tax_id_seq OWNED BY account_fiscal_position_tax.id;


--
-- Name: account_fiscal_position_tax_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position_tax_template (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    write_uid integer,
    tax_dest_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_tax_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position_tax_template IS 'Template Tax Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax_template.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.tax_src_id IS 'Tax Source';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.tax_dest_id IS 'Replacement Tax';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_tax_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_tax_template_id_seq OWNED BY account_fiscal_position_tax_template.id;


--
-- Name: account_fiscal_position_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscal_position_template (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    chart_template_id integer NOT NULL,
    write_uid integer,
    note text,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscal_position_template IS 'Template for Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.name IS 'Fiscal Position Template';


--
-- Name: COLUMN account_fiscal_position_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_fiscal_position_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_template.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscal_position_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscal_position_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscal_position_template_id_seq OWNED BY account_fiscal_position_template.id;


--
-- Name: account_fiscalyear; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscalyear (
    id integer NOT NULL,
    create_uid integer,
    date_stop date NOT NULL,
    code character varying(6) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    end_journal_period_id integer,
    date_start date NOT NULL,
    company_id integer NOT NULL,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscalyear; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscalyear IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscalyear.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscalyear.date_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.date_stop IS 'End Date';


--
-- Name: COLUMN account_fiscalyear.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.code IS 'Code';


--
-- Name: COLUMN account_fiscalyear.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscalyear.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.name IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscalyear.end_journal_period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.end_journal_period_id IS 'End of Year Entries Journal';


--
-- Name: COLUMN account_fiscalyear.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.date_start IS 'Start Date';


--
-- Name: COLUMN account_fiscalyear.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.company_id IS 'Company';


--
-- Name: COLUMN account_fiscalyear.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscalyear.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.state IS 'Status';


--
-- Name: COLUMN account_fiscalyear.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear.write_date IS 'Last Updated on';


--
-- Name: account_fiscalyear_close; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscalyear_close (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    journal_id integer NOT NULL,
    report_name character varying NOT NULL,
    fy2_id integer NOT NULL,
    period_id integer NOT NULL,
    write_date timestamp without time zone,
    fy_id integer NOT NULL,
    write_uid integer
);


--
-- Name: TABLE account_fiscalyear_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscalyear_close IS 'Fiscalyear Close';


--
-- Name: COLUMN account_fiscalyear_close.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscalyear_close.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscalyear_close.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.journal_id IS 'Opening Entries Journal';


--
-- Name: COLUMN account_fiscalyear_close.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.report_name IS 'Name of new entries';


--
-- Name: COLUMN account_fiscalyear_close.fy2_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.fy2_id IS 'New Fiscal Year';


--
-- Name: COLUMN account_fiscalyear_close.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.period_id IS 'Opening Entries Period';


--
-- Name: COLUMN account_fiscalyear_close.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscalyear_close.fy_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.fy_id IS 'Fiscal Year to close';


--
-- Name: COLUMN account_fiscalyear_close.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close.write_uid IS 'Last Updated by';


--
-- Name: account_fiscalyear_close_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscalyear_close_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscalyear_close_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscalyear_close_id_seq OWNED BY account_fiscalyear_close.id;


--
-- Name: account_fiscalyear_close_state; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_fiscalyear_close_state (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    fy_id integer NOT NULL
);


--
-- Name: TABLE account_fiscalyear_close_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_fiscalyear_close_state IS 'Fiscalyear Close state';


--
-- Name: COLUMN account_fiscalyear_close_state.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close_state.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscalyear_close_state.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close_state.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscalyear_close_state.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscalyear_close_state.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close_state.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscalyear_close_state.fy_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_fiscalyear_close_state.fy_id IS 'Fiscal Year to Close';


--
-- Name: account_fiscalyear_close_state_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscalyear_close_state_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscalyear_close_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscalyear_close_state_id_seq OWNED BY account_fiscalyear_close_state.id;


--
-- Name: account_fiscalyear_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_fiscalyear_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscalyear_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_fiscalyear_id_seq OWNED BY account_fiscalyear.id;


--
-- Name: account_general_journal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_general_journal (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    amount_currency boolean,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_general_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_general_journal IS 'Account General Journal';


--
-- Name: COLUMN account_general_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_general_journal.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_general_journal.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.date_from IS 'Start Date';


--
-- Name: COLUMN account_general_journal.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.period_to IS 'End Period';


--
-- Name: COLUMN account_general_journal.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.filter IS 'Filter by';


--
-- Name: COLUMN account_general_journal.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.period_from IS 'Start Period';


--
-- Name: COLUMN account_general_journal.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_general_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_general_journal.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.date_to IS 'End Date';


--
-- Name: COLUMN account_general_journal.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_general_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_general_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_general_journal.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_general_journal.target_move IS 'Target Moves';


--
-- Name: account_general_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_general_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_general_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_general_journal_id_seq OWNED BY account_general_journal.id;


--
-- Name: account_general_journal_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_general_journal_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_general_journal_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_general_journal_journal_rel IS 'RELATION BETWEEN account_general_journal AND account_journal';


--
-- Name: account_installer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_installer (
    id integer NOT NULL,
    create_uid integer,
    date_stop date NOT NULL,
    create_date timestamp without time zone,
    date_start date NOT NULL,
    charts character varying NOT NULL,
    company_id integer NOT NULL,
    period character varying NOT NULL,
    write_date timestamp without time zone,
    has_default_company boolean,
    write_uid integer
);


--
-- Name: TABLE account_installer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_installer IS 'account.installer';


--
-- Name: COLUMN account_installer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.create_uid IS 'Created by';


--
-- Name: COLUMN account_installer.date_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.date_stop IS 'End Date';


--
-- Name: COLUMN account_installer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.create_date IS 'Created on';


--
-- Name: COLUMN account_installer.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.date_start IS 'Start Date';


--
-- Name: COLUMN account_installer.charts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.charts IS 'Accounting Package';


--
-- Name: COLUMN account_installer.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.company_id IS 'Company';


--
-- Name: COLUMN account_installer.period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.period IS 'Periods';


--
-- Name: COLUMN account_installer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_installer.has_default_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.has_default_company IS 'Has Default Company';


--
-- Name: COLUMN account_installer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_installer.write_uid IS 'Last Updated by';


--
-- Name: account_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_installer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_installer_id_seq OWNED BY account_installer.id;


--
-- Name: account_invoice; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice (
    id integer NOT NULL,
    comment text,
    date_due date,
    check_total numeric,
    reference character varying,
    payment_term integer,
    number character varying,
    message_last_post timestamp without time zone,
    company_id integer NOT NULL,
    currency_id integer NOT NULL,
    create_date timestamp without time zone,
    create_uid integer,
    fiscal_position integer,
    amount_untaxed numeric,
    partner_bank_id integer,
    partner_id integer NOT NULL,
    supplier_invoice_number character varying,
    reference_type character varying NOT NULL,
    journal_id integer NOT NULL,
    amount_tax numeric,
    state character varying,
    move_id integer,
    type character varying,
    internal_number character varying,
    account_id integer NOT NULL,
    reconciled boolean,
    residual numeric,
    move_name character varying,
    date_invoice date,
    period_id integer,
    write_date timestamp without time zone,
    user_id integer,
    write_uid integer,
    origin character varying,
    amount_total numeric,
    name character varying,
    sent boolean,
    commercial_partner_id integer,
    section_id integer
);


--
-- Name: TABLE account_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice IS 'Invoice';


--
-- Name: COLUMN account_invoice.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.comment IS 'Additional Information';


--
-- Name: COLUMN account_invoice.date_due; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.date_due IS 'Due Date';


--
-- Name: COLUMN account_invoice.check_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.check_total IS 'Verification Total';


--
-- Name: COLUMN account_invoice.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.reference IS 'Invoice Reference';


--
-- Name: COLUMN account_invoice.payment_term; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_invoice.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.number IS 'Number';


--
-- Name: COLUMN account_invoice.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN account_invoice.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.company_id IS 'Company';


--
-- Name: COLUMN account_invoice.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.currency_id IS 'Currency';


--
-- Name: COLUMN account_invoice.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice.fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_invoice.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.amount_untaxed IS 'Subtotal';


--
-- Name: COLUMN account_invoice.partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.partner_bank_id IS 'Bank Account';


--
-- Name: COLUMN account_invoice.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.partner_id IS 'Partner';


--
-- Name: COLUMN account_invoice.supplier_invoice_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.supplier_invoice_number IS 'Supplier Invoice Number';


--
-- Name: COLUMN account_invoice.reference_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.reference_type IS 'Payment Reference';


--
-- Name: COLUMN account_invoice.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.journal_id IS 'Journal';


--
-- Name: COLUMN account_invoice.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.amount_tax IS 'Tax';


--
-- Name: COLUMN account_invoice.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.state IS 'Status';


--
-- Name: COLUMN account_invoice.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_invoice.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.type IS 'Type';


--
-- Name: COLUMN account_invoice.internal_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.internal_number IS 'Invoice Number';


--
-- Name: COLUMN account_invoice.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.account_id IS 'Account';


--
-- Name: COLUMN account_invoice.reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.reconciled IS 'Paid/Reconciled';


--
-- Name: COLUMN account_invoice.residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.residual IS 'Balance';


--
-- Name: COLUMN account_invoice.move_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.move_name IS 'Journal Entry';


--
-- Name: COLUMN account_invoice.date_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.date_invoice IS 'Invoice Date';


--
-- Name: COLUMN account_invoice.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.period_id IS 'Force Period';


--
-- Name: COLUMN account_invoice.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.user_id IS 'Salesperson';


--
-- Name: COLUMN account_invoice.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.origin IS 'Source Document';


--
-- Name: COLUMN account_invoice.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.amount_total IS 'Total';


--
-- Name: COLUMN account_invoice.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.name IS 'Reference/Description';


--
-- Name: COLUMN account_invoice.sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.sent IS 'Sent';


--
-- Name: COLUMN account_invoice.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_invoice.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice.section_id IS 'Sales Team';


--
-- Name: account_invoice_cancel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_cancel (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_invoice_cancel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_cancel IS 'Cancel the Selected Invoices';


--
-- Name: COLUMN account_invoice_cancel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_cancel.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_cancel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_cancel.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_cancel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_cancel.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_cancel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_cancel.write_uid IS 'Last Updated by';


--
-- Name: account_invoice_cancel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_cancel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_cancel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_cancel_id_seq OWNED BY account_invoice_cancel.id;


--
-- Name: account_invoice_confirm; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_confirm (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_invoice_confirm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_confirm IS 'Confirm the selected invoices';


--
-- Name: COLUMN account_invoice_confirm.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_confirm.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_confirm.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_confirm.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_confirm.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_confirm.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_confirm.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_confirm.write_uid IS 'Last Updated by';


--
-- Name: account_invoice_confirm_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_confirm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_confirm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_confirm_id_seq OWNED BY account_invoice_confirm.id;


--
-- Name: account_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_id_seq OWNED BY account_invoice.id;


--
-- Name: account_invoice_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_line (
    id integer NOT NULL,
    origin character varying,
    create_uid integer,
    uos_id integer,
    create_date timestamp without time zone,
    account_id integer NOT NULL,
    sequence integer,
    invoice_id integer,
    price_unit numeric NOT NULL,
    price_subtotal numeric,
    company_id integer,
    write_uid integer,
    discount numeric,
    product_id integer,
    write_date timestamp without time zone,
    account_analytic_id integer,
    partner_id integer,
    quantity numeric NOT NULL,
    name text NOT NULL,
    purchase_line_id integer
);


--
-- Name: TABLE account_invoice_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_line IS 'Invoice Line';


--
-- Name: COLUMN account_invoice_line.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.origin IS 'Source Document';


--
-- Name: COLUMN account_invoice_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_line.uos_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.uos_id IS 'Unit of Measure';


--
-- Name: COLUMN account_invoice_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.account_id IS 'Account';


--
-- Name: COLUMN account_invoice_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_invoice_line.invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.invoice_id IS 'Invoice Reference';


--
-- Name: COLUMN account_invoice_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_invoice_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.price_subtotal IS 'Amount';


--
-- Name: COLUMN account_invoice_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.company_id IS 'Company';


--
-- Name: COLUMN account_invoice_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_invoice_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.product_id IS 'Product';


--
-- Name: COLUMN account_invoice_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_line.account_analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.account_analytic_id IS 'Analytic Account';


--
-- Name: COLUMN account_invoice_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_invoice_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_invoice_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.name IS 'Description';


--
-- Name: COLUMN account_invoice_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: account_invoice_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_line_id_seq OWNED BY account_invoice_line.id;


--
-- Name: account_invoice_line_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_line_tax (
    invoice_line_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_invoice_line_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_line_tax IS 'RELATION BETWEEN account_invoice_line AND account_tax';


--
-- Name: account_invoice_refund; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_refund (
    id integer NOT NULL,
    create_uid integer,
    filter_refund character varying NOT NULL,
    create_date timestamp without time zone,
    description character varying NOT NULL,
    journal_id integer,
    period integer,
    write_date timestamp without time zone,
    date date,
    write_uid integer
);


--
-- Name: TABLE account_invoice_refund; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_refund IS 'Invoice Refund';


--
-- Name: COLUMN account_invoice_refund.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_refund.filter_refund; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.filter_refund IS 'Refund Method';


--
-- Name: COLUMN account_invoice_refund.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_refund.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.description IS 'Reason';


--
-- Name: COLUMN account_invoice_refund.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.journal_id IS 'Refund Journal';


--
-- Name: COLUMN account_invoice_refund.period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.period IS 'Force period';


--
-- Name: COLUMN account_invoice_refund.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_refund.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.date IS 'Date';


--
-- Name: COLUMN account_invoice_refund.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_refund.write_uid IS 'Last Updated by';


--
-- Name: account_invoice_refund_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_refund_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_refund_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_refund_id_seq OWNED BY account_invoice_refund.id;


--
-- Name: product_product; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_product (
    id integer NOT NULL,
    ean13 character varying(13),
    create_date timestamp without time zone,
    default_code character varying,
    name_template character varying,
    create_uid integer,
    message_last_post timestamp without time zone,
    product_tmpl_id integer NOT NULL,
    image_variant bytea,
    write_uid integer,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE product_product; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_product IS 'Product';


--
-- Name: COLUMN product_product.ean13; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.ean13 IS 'EAN13 Barcode';


--
-- Name: COLUMN product_product.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.create_date IS 'Created on';


--
-- Name: COLUMN product_product.default_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_product.name_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.name_template IS 'Template Name';


--
-- Name: COLUMN product_product.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.create_uid IS 'Created by';


--
-- Name: COLUMN product_product.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN product_product.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_product.image_variant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.image_variant IS 'Variant Image';


--
-- Name: COLUMN product_product.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_product.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_product.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_product.active IS 'Active';


--
-- Name: product_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_template (
    id integer NOT NULL,
    warranty double precision,
    uos_id integer,
    list_price numeric,
    weight numeric,
    color integer,
    image bytea,
    write_uid integer,
    mes_type character varying,
    uom_id integer NOT NULL,
    description_purchase text,
    create_date timestamp without time zone,
    uos_coeff numeric,
    create_uid integer,
    sale_ok boolean,
    categ_id integer NOT NULL,
    product_manager integer,
    message_last_post timestamp without time zone,
    company_id integer,
    state character varying,
    uom_po_id integer NOT NULL,
    description_sale text,
    description text,
    weight_net numeric,
    volume double precision,
    write_date timestamp without time zone,
    active boolean,
    rental boolean,
    image_medium bytea,
    name character varying NOT NULL,
    type character varying NOT NULL,
    image_small bytea,
    track_all boolean,
    track_outgoing boolean,
    loc_rack character varying(16),
    loc_case character varying(16),
    track_incoming boolean,
    loc_row character varying(16),
    sale_delay double precision,
    purchase_ok boolean,
    hr_expense_ok boolean,
    website_sequence integer,
    website_meta_description text,
    website_meta_keywords character varying,
    website_meta_title character varying,
    website_published boolean,
    website_description text,
    website_size_x integer,
    website_size_y integer
);


--
-- Name: TABLE product_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_template IS 'Product Template';


--
-- Name: COLUMN product_template.warranty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.warranty IS 'Warranty';


--
-- Name: COLUMN product_template.uos_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.uos_id IS 'Unit of Sale';


--
-- Name: COLUMN product_template.list_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.list_price IS 'Sale Price';


--
-- Name: COLUMN product_template.weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.weight IS 'Gross Weight';


--
-- Name: COLUMN product_template.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.color IS 'Color Index';


--
-- Name: COLUMN product_template.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.image IS 'Image';


--
-- Name: COLUMN product_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template.mes_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.mes_type IS 'Measure Type';


--
-- Name: COLUMN product_template.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN product_template.description_purchase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.description_purchase IS 'Purchase Description';


--
-- Name: COLUMN product_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.create_date IS 'Created on';


--
-- Name: COLUMN product_template.uos_coeff; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.uos_coeff IS 'Unit of Measure -> UOS Coeff';


--
-- Name: COLUMN product_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.create_uid IS 'Created by';


--
-- Name: COLUMN product_template.sale_ok; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.sale_ok IS 'Can be Sold';


--
-- Name: COLUMN product_template.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.categ_id IS 'Internal Category';


--
-- Name: COLUMN product_template.product_manager; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.product_manager IS 'Product Manager';


--
-- Name: COLUMN product_template.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN product_template.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.company_id IS 'Company';


--
-- Name: COLUMN product_template.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.state IS 'Status';


--
-- Name: COLUMN product_template.uom_po_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.uom_po_id IS 'Purchase Unit of Measure';


--
-- Name: COLUMN product_template.description_sale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.description_sale IS 'Sale Description';


--
-- Name: COLUMN product_template.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.description IS 'Description';


--
-- Name: COLUMN product_template.weight_net; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.weight_net IS 'Net Weight';


--
-- Name: COLUMN product_template.volume; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.volume IS 'Volume';


--
-- Name: COLUMN product_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_template.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.active IS 'Active';


--
-- Name: COLUMN product_template.rental; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.rental IS 'Can be Rent';


--
-- Name: COLUMN product_template.image_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.image_medium IS 'Medium-sized image';


--
-- Name: COLUMN product_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.name IS 'Name';


--
-- Name: COLUMN product_template.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.type IS 'Product Type';


--
-- Name: COLUMN product_template.image_small; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.image_small IS 'Small-sized image';


--
-- Name: COLUMN product_template.track_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.track_all IS 'Full Lots Traceability';


--
-- Name: COLUMN product_template.track_outgoing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.track_outgoing IS 'Track Outgoing Lots';


--
-- Name: COLUMN product_template.loc_rack; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.loc_rack IS 'Rack';


--
-- Name: COLUMN product_template.loc_case; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.loc_case IS 'Case';


--
-- Name: COLUMN product_template.track_incoming; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.track_incoming IS 'Track Incoming Lots';


--
-- Name: COLUMN product_template.loc_row; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.loc_row IS 'Row';


--
-- Name: COLUMN product_template.sale_delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.sale_delay IS 'Customer Lead Time';


--
-- Name: COLUMN product_template.purchase_ok; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.purchase_ok IS 'Can be Purchased';


--
-- Name: COLUMN product_template.hr_expense_ok; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.hr_expense_ok IS 'Can be Expensed';


--
-- Name: COLUMN product_template.website_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_sequence IS 'Sequence';


--
-- Name: COLUMN product_template.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN product_template.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN product_template.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN product_template.website_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_published IS 'Available in the website';


--
-- Name: COLUMN product_template.website_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_description IS 'Description for the website';


--
-- Name: COLUMN product_template.website_size_x; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_size_x IS 'Size X';


--
-- Name: COLUMN product_template.website_size_y; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_template.website_size_y IS 'Size Y';


--
-- Name: product_uom; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_uom (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    rounding numeric NOT NULL,
    write_uid integer,
    active boolean,
    write_date timestamp without time zone,
    factor numeric NOT NULL,
    uom_type character varying NOT NULL,
    category_id integer NOT NULL,
    CONSTRAINT product_uom_factor_gt_zero CHECK ((factor <> (0)::numeric))
);


--
-- Name: TABLE product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN product_uom.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.create_uid IS 'Created by';


--
-- Name: COLUMN product_uom.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.create_date IS 'Created on';


--
-- Name: COLUMN product_uom.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.name IS 'Unit of Measure';


--
-- Name: COLUMN product_uom.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.rounding IS 'Rounding Precision';


--
-- Name: COLUMN product_uom.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_uom.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.active IS 'Active';


--
-- Name: COLUMN product_uom.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_uom.factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.factor IS 'Ratio';


--
-- Name: COLUMN product_uom.uom_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.uom_type IS 'Type';


--
-- Name: COLUMN product_uom.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom.category_id IS 'Unit of Measure Category';


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_currency_rate (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name timestamp without time zone NOT NULL,
    write_uid integer,
    currency_id integer,
    rate numeric,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.rate IS 'Rate';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner (
    id integer NOT NULL,
    name character varying NOT NULL,
    company_id integer,
    comment text,
    ean13 character varying(13),
    create_date timestamp without time zone,
    color integer,
    image_small bytea,
    image bytea,
    date date,
    street character varying,
    city character varying,
    display_name character varying,
    zip character varying(24),
    title integer,
    function character varying,
    country_id integer,
    parent_id integer,
    supplier boolean,
    ref character varying,
    email character varying,
    is_company boolean,
    website character varying,
    customer boolean,
    fax character varying,
    street2 character varying,
    employee boolean,
    credit_limit double precision,
    write_date timestamp without time zone,
    active boolean,
    tz character varying(64),
    write_uid integer,
    lang character varying,
    create_uid integer,
    image_medium bytea,
    phone character varying,
    mobile character varying,
    type character varying,
    use_parent_address boolean,
    user_id integer,
    birthdate character varying,
    vat character varying,
    state_id integer,
    commercial_partner_id integer,
    notify_email character varying NOT NULL,
    message_last_post timestamp without time zone,
    opt_out boolean,
    signup_type character varying,
    signup_expiration timestamp without time zone,
    signup_token character varying,
    last_reconciliation_date timestamp without time zone,
    vat_subjected boolean,
    debit_limit double precision,
    section_id integer,
    calendar_last_notif_ack timestamp without time zone
);


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.ean13; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.ean13 IS 'EAN13';


--
-- Name: COLUMN res_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.create_date IS 'Created on';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.image_small; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.image_small IS 'Small-sized image';


--
-- Name: COLUMN res_partner.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.image IS 'Image';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.display_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.display_name IS 'Name';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.supplier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.supplier IS 'Supplier';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.ref IS 'Contact Reference';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.website IS 'Website';


--
-- Name: COLUMN res_partner.customer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.customer IS 'Customer';


--
-- Name: COLUMN res_partner.fax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.fax IS 'Fax';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.credit_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.credit_limit IS 'Credit Limit';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.image_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.image_medium IS 'Medium-sized image';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.use_parent_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.use_parent_address IS 'Use Company Address';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.birthdate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.birthdate IS 'Birthdate';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.vat IS 'TIN';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.notify_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.notify_email IS 'Receive Inbox Notifications by Email';


--
-- Name: COLUMN res_partner.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN res_partner.opt_out; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.opt_out IS 'Opt-Out';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.signup_expiration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.signup_expiration IS 'Signup Expiration';


--
-- Name: COLUMN res_partner.signup_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.signup_token IS 'Signup Token';


--
-- Name: COLUMN res_partner.last_reconciliation_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.last_reconciliation_date IS 'Latest Full Reconciliation Date';


--
-- Name: COLUMN res_partner.vat_subjected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.vat_subjected IS 'VAT Legal Statement';


--
-- Name: COLUMN res_partner.debit_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.debit_limit IS 'Payable Limit';


--
-- Name: COLUMN res_partner.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.section_id IS 'Sales Team';


--
-- Name: COLUMN res_partner.calendar_last_notif_ack; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner.calendar_last_notif_ack IS 'Last notification marked as read from base Calendar';


--
-- Name: account_invoice_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW account_invoice_report AS
    WITH currency_rate(currency_id, rate, date_start, date_end) AS (SELECT r.currency_id, r.rate, r.name AS date_start, (SELECT r2.name FROM res_currency_rate r2 WHERE ((r2.name > r.name) AND (r2.currency_id = r.currency_id)) ORDER BY r2.name LIMIT 1) AS date_end FROM res_currency_rate r) SELECT sub.id, sub.date, sub.product_id, sub.partner_id, sub.country_id, sub.payment_term, sub.period_id, sub.uom_name, sub.currency_id, sub.journal_id, sub.fiscal_position, sub.user_id, sub.company_id, sub.nbr, sub.type, sub.state, sub.categ_id, sub.date_due, sub.account_id, sub.account_line_id, sub.partner_bank_id, sub.product_qty, (sub.price_total / cr.rate) AS price_total, (sub.price_average / cr.rate) AS price_average, cr.rate AS currency_rate, (sub.residual / cr.rate) AS residual, sub.commercial_partner_id, sub.section_id FROM ((SELECT min(ail.id) AS id, ai.date_invoice AS date, ail.product_id, ai.partner_id, ai.payment_term, ai.period_id, u2.name AS uom_name, ai.currency_id, ai.journal_id, ai.fiscal_position, ai.user_id, ai.company_id, count(ail.*) AS nbr, ai.type, ai.state, pt.categ_id, ai.date_due, ai.account_id, ail.account_id AS account_line_id, ai.partner_bank_id, sum(CASE WHEN ((ai.type)::text = ANY (ARRAY[('out_refund'::character varying)::text, ('in_invoice'::character varying)::text])) THEN (((- ail.quantity) / u.factor) * u2.factor) ELSE ((ail.quantity / u.factor) * u2.factor) END) AS product_qty, sum(CASE WHEN ((ai.type)::text = ANY (ARRAY[('out_refund'::character varying)::text, ('in_invoice'::character varying)::text])) THEN (- ail.price_subtotal) ELSE ail.price_subtotal END) AS price_total, (CASE WHEN ((ai.type)::text = ANY (ARRAY[('out_refund'::character varying)::text, ('in_invoice'::character varying)::text])) THEN sum((- ail.price_subtotal)) ELSE sum(ail.price_subtotal) END / CASE WHEN (sum(((ail.quantity / u.factor) * u2.factor)) <> (0)::numeric) THEN CASE WHEN ((ai.type)::text = ANY (ARRAY[('out_refund'::character varying)::text, ('in_invoice'::character varying)::text])) THEN sum((((- ail.quantity) / u.factor) * u2.factor)) ELSE sum(((ail.quantity / u.factor) * u2.factor)) END ELSE (1)::numeric END) AS price_average, ((CASE WHEN ((ai.type)::text = ANY (ARRAY[('out_refund'::character varying)::text, ('in_invoice'::character varying)::text])) THEN (- ai.residual) ELSE ai.residual END / ((SELECT count(*) AS count FROM account_invoice_line l WHERE (l.invoice_id = ai.id)))::numeric) * (count(*))::numeric) AS residual, ai.commercial_partner_id, partner.country_id, ai.section_id FROM ((((((account_invoice_line ail JOIN account_invoice ai ON ((ai.id = ail.invoice_id))) JOIN res_partner partner ON ((ai.commercial_partner_id = partner.id))) LEFT JOIN product_product pr ON ((pr.id = ail.product_id))) LEFT JOIN product_template pt ON ((pt.id = pr.product_tmpl_id))) LEFT JOIN product_uom u ON ((u.id = ail.uos_id))) LEFT JOIN product_uom u2 ON ((u2.id = pt.uom_id))) GROUP BY ail.product_id, ai.date_invoice, ai.id, ai.partner_id, ai.payment_term, ai.period_id, u2.name, u2.id, ai.currency_id, ai.journal_id, ai.fiscal_position, ai.user_id, ai.company_id, ai.type, ai.state, pt.categ_id, ai.date_due, ai.account_id, ail.account_id, ai.partner_bank_id, ai.residual, ai.amount_total, ai.commercial_partner_id, partner.country_id, ai.section_id) sub JOIN currency_rate cr ON ((((cr.currency_id = sub.currency_id) AND (cr.date_start <= COALESCE((sub.date)::timestamp with time zone, now()))) AND ((cr.date_end IS NULL) OR (cr.date_end > COALESCE((sub.date)::timestamp with time zone, now()))))));


--
-- Name: account_invoice_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_invoice_tax (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    account_id integer NOT NULL,
    sequence integer,
    company_id integer,
    invoice_id integer,
    manual boolean,
    base_amount numeric,
    write_uid integer,
    tax_code_id integer,
    amount numeric,
    base numeric,
    write_date timestamp without time zone,
    account_analytic_id integer,
    tax_amount numeric,
    base_code_id integer,
    name character varying NOT NULL
);


--
-- Name: TABLE account_invoice_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_invoice_tax IS 'Invoice Tax';


--
-- Name: COLUMN account_invoice_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_tax.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.account_id IS 'Tax Account';


--
-- Name: COLUMN account_invoice_tax.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_invoice_tax.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.company_id IS 'Company';


--
-- Name: COLUMN account_invoice_tax.invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.invoice_id IS 'Invoice Line';


--
-- Name: COLUMN account_invoice_tax.manual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.manual IS 'Manual';


--
-- Name: COLUMN account_invoice_tax.base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.base_amount IS 'Base Code Amount';


--
-- Name: COLUMN account_invoice_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_tax.tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.tax_code_id IS 'Tax Code';


--
-- Name: COLUMN account_invoice_tax.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.amount IS 'Amount';


--
-- Name: COLUMN account_invoice_tax.base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.base IS 'Base';


--
-- Name: COLUMN account_invoice_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_tax.account_analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.account_analytic_id IS 'Analytic account';


--
-- Name: COLUMN account_invoice_tax.tax_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.tax_amount IS 'Tax Code Amount';


--
-- Name: COLUMN account_invoice_tax.base_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.base_code_id IS 'Base Code';


--
-- Name: COLUMN account_invoice_tax.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_invoice_tax.name IS 'Tax Description';


--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_invoice_tax_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_invoice_tax_id_seq OWNED BY account_invoice_tax.id;


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal (
    id integer NOT NULL,
    code character varying(5) NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    loss_account_id integer,
    currency integer,
    internal_account_id integer,
    create_uid integer,
    user_id integer,
    cash_control boolean,
    centralisation boolean,
    company_id integer NOT NULL,
    profit_account_id integer,
    type character varying(32) NOT NULL,
    default_debit_account_id integer,
    default_credit_account_id integer,
    sequence_id integer NOT NULL,
    write_date timestamp without time zone,
    allow_date boolean,
    update_posted boolean,
    name character varying NOT NULL,
    analytic_journal_id integer,
    with_last_closing_balance boolean,
    entry_posted boolean,
    group_invoice_lines boolean
);


--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.code IS 'Code';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.currency IS 'Currency';


--
-- Name: COLUMN account_journal.internal_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.internal_account_id IS 'Internal Transfers Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.user_id IS 'User';


--
-- Name: COLUMN account_journal.cash_control; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.cash_control IS 'Cash Control';


--
-- Name: COLUMN account_journal.centralisation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.centralisation IS 'Centralized Counterpart';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.default_debit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.default_debit_account_id IS 'Default Debit Account';


--
-- Name: COLUMN account_journal.default_credit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.default_credit_account_id IS 'Default Credit Account';


--
-- Name: COLUMN account_journal.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.allow_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.allow_date IS 'Check Date in Period';


--
-- Name: COLUMN account_journal.update_posted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.update_posted IS 'Allow Cancelling Entries';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.analytic_journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.analytic_journal_id IS 'Analytic Journal';


--
-- Name: COLUMN account_journal.with_last_closing_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.with_last_closing_balance IS 'Opening With Last Closing Balance';


--
-- Name: COLUMN account_journal.entry_posted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.entry_posted IS 'Autopost Created Moves';


--
-- Name: COLUMN account_journal.group_invoice_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal.group_invoice_lines IS 'Group Invoice Lines';


--
-- Name: account_journal_account_vat_declaration_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_account_vat_declaration_rel (
    account_vat_declaration_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_vat_declaration_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_account_vat_declaration_rel IS 'RELATION BETWEEN account_vat_declaration AND account_journal';


--
-- Name: account_journal_accounting_report_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_accounting_report_rel (
    accounting_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_accounting_report_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_accounting_report_rel IS 'RELATION BETWEEN accounting_report AND account_journal';


--
-- Name: account_journal_cashbox_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_cashbox_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    journal_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    pieces numeric
);


--
-- Name: TABLE account_journal_cashbox_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_cashbox_line IS 'account.journal.cashbox.line';


--
-- Name: COLUMN account_journal_cashbox_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_cashbox_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_cashbox_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_journal_cashbox_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_cashbox_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal_cashbox_line.pieces; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_cashbox_line.pieces IS 'Values';


--
-- Name: account_journal_cashbox_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_journal_cashbox_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_cashbox_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_journal_cashbox_line_id_seq OWNED BY account_journal_cashbox_line.id;


--
-- Name: account_journal_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_group_rel (
    journal_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE account_journal_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_group_rel IS 'RELATION BETWEEN account_journal AND res_groups';


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_journal_id_seq OWNED BY account_journal.id;


--
-- Name: account_journal_period; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_period (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    state character varying NOT NULL,
    period_id integer NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    write_uid integer
);


--
-- Name: TABLE account_journal_period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_period IS 'Journal Period';


--
-- Name: COLUMN account_journal_period.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_period.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_period.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.name IS 'Journal-Period Name';


--
-- Name: COLUMN account_journal_period.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.company_id IS 'Company';


--
-- Name: COLUMN account_journal_period.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.journal_id IS 'Journal';


--
-- Name: COLUMN account_journal_period.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.state IS 'Status';


--
-- Name: COLUMN account_journal_period.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.period_id IS 'Period';


--
-- Name: COLUMN account_journal_period.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal_period.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.active IS 'Active';


--
-- Name: COLUMN account_journal_period.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_period.write_uid IS 'Last Updated by';


--
-- Name: account_journal_period_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_journal_period_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_journal_period_id_seq OWNED BY account_journal_period.id;


--
-- Name: account_journal_select; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_select (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_journal_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_select IS 'Account Journal Select';


--
-- Name: COLUMN account_journal_select.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_select.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_select.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_select.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_select.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_select.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal_select.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_journal_select.write_uid IS 'Last Updated by';


--
-- Name: account_journal_select_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_journal_select_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_select_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_journal_select_id_seq OWNED BY account_journal_select.id;


--
-- Name: account_journal_type_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_journal_type_rel (
    journal_id integer NOT NULL,
    type_id integer NOT NULL
);


--
-- Name: TABLE account_journal_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_journal_type_rel IS 'RELATION BETWEEN account_journal AND account_account_type';


--
-- Name: account_model; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_model (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    journal_id integer NOT NULL,
    company_id integer,
    write_date timestamp without time zone,
    write_uid integer,
    legend text
);


--
-- Name: TABLE account_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_model IS 'Account Model';


--
-- Name: COLUMN account_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.create_date IS 'Created on';


--
-- Name: COLUMN account_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.name IS 'Model Name';


--
-- Name: COLUMN account_model.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.journal_id IS 'Journal';


--
-- Name: COLUMN account_model.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.company_id IS 'Company';


--
-- Name: COLUMN account_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_model.legend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model.legend IS 'Legend';


--
-- Name: account_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_model_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_model_id_seq OWNED BY account_model.id;


--
-- Name: account_model_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_model_line (
    id integer NOT NULL,
    analytic_account_id integer,
    model_id integer NOT NULL,
    create_date timestamp without time zone,
    account_id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer NOT NULL,
    write_uid integer,
    currency_id integer,
    credit numeric,
    date_maturity character varying,
    write_date timestamp without time zone,
    debit numeric,
    amount_currency double precision,
    partner_id integer,
    create_uid integer,
    quantity numeric,
    CONSTRAINT account_model_line_credit_debit1 CHECK (((credit * debit) = (0)::numeric)),
    CONSTRAINT account_model_line_credit_debit2 CHECK (((credit + debit) >= (0)::numeric))
);


--
-- Name: TABLE account_model_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_model_line IS 'Account Model Entries';


--
-- Name: COLUMN account_model_line.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_model_line.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_model_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_model_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_model_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.name IS 'Name';


--
-- Name: COLUMN account_model_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_model_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_model_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_model_line.credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.credit IS 'Credit';


--
-- Name: COLUMN account_model_line.date_maturity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.date_maturity IS 'Maturity Date';


--
-- Name: COLUMN account_model_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_model_line.debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.debit IS 'Debit';


--
-- Name: COLUMN account_model_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_model_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_model_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_model_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_model_line.quantity IS 'Quantity';


--
-- Name: account_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_model_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_model_line_id_seq OWNED BY account_model_line.id;


--
-- Name: account_move_bank_reconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_bank_reconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    journal_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_bank_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_bank_reconcile IS 'Move bank reconcile';


--
-- Name: COLUMN account_move_bank_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_bank_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_bank_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_bank_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_move_bank_reconcile.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_bank_reconcile.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_bank_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_bank_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_bank_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_bank_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_move_bank_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_bank_reconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_bank_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_bank_reconcile_id_seq OWNED BY account_move_bank_reconcile.id;


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_id_seq OWNED BY account_move.id;


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_line_id_seq OWNED BY account_move_line.id;


--
-- Name: account_move_line_reconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line_reconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    writeoff numeric,
    write_uid integer,
    credit numeric,
    write_date timestamp without time zone,
    debit numeric,
    trans_nbr integer
);


--
-- Name: TABLE account_move_line_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line_reconcile IS 'Account move line reconcile';


--
-- Name: COLUMN account_move_line_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line_reconcile.writeoff; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.writeoff IS 'Write-Off amount';


--
-- Name: COLUMN account_move_line_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line_reconcile.credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.credit IS 'Credit amount';


--
-- Name: COLUMN account_move_line_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line_reconcile.debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.debit IS 'Debit amount';


--
-- Name: COLUMN account_move_line_reconcile.trans_nbr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile.trans_nbr IS '# of Transaction';


--
-- Name: account_move_line_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_line_reconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_line_reconcile_id_seq OWNED BY account_move_line_reconcile.id;


--
-- Name: account_move_line_reconcile_select; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line_reconcile_select (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    account_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_line_reconcile_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line_reconcile_select IS 'Move line reconcile select';


--
-- Name: COLUMN account_move_line_reconcile_select.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_select.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line_reconcile_select.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_select.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line_reconcile_select.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_select.account_id IS 'Account';


--
-- Name: COLUMN account_move_line_reconcile_select.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_select.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line_reconcile_select.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_select.write_date IS 'Last Updated on';


--
-- Name: account_move_line_reconcile_select_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_line_reconcile_select_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_reconcile_select_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_line_reconcile_select_id_seq OWNED BY account_move_line_reconcile_select.id;


--
-- Name: account_move_line_reconcile_writeoff; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line_reconcile_writeoff (
    id integer NOT NULL,
    comment character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    writeoff_acc_id integer NOT NULL,
    journal_id integer NOT NULL,
    analytic_id integer,
    write_date timestamp without time zone,
    date_p date,
    write_uid integer
);


--
-- Name: TABLE account_move_line_reconcile_writeoff; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line_reconcile_writeoff IS 'Account move line reconcile (writeoff)';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.comment IS 'Comment';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.writeoff_acc_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.writeoff_acc_id IS 'Write-Off account';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.journal_id IS 'Write-Off Journal';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.analytic_id IS 'Analytic Account';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.date_p; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.date_p IS 'Date';


--
-- Name: COLUMN account_move_line_reconcile_writeoff.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_reconcile_writeoff.write_uid IS 'Last Updated by';


--
-- Name: account_move_line_reconcile_writeoff_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_line_reconcile_writeoff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_reconcile_writeoff_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_line_reconcile_writeoff_id_seq OWNED BY account_move_line_reconcile_writeoff.id;


--
-- Name: account_move_line_relation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line_relation (
    move_id integer NOT NULL,
    line_id integer NOT NULL
);


--
-- Name: TABLE account_move_line_relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line_relation IS 'RELATION BETWEEN account_statement_from_invoice_lines AND account_move_line';


--
-- Name: account_move_line_unreconcile_select; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_line_unreconcile_select (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    account_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_line_unreconcile_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_line_unreconcile_select IS 'Unreconciliation';


--
-- Name: COLUMN account_move_line_unreconcile_select.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_unreconcile_select.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line_unreconcile_select.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_unreconcile_select.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line_unreconcile_select.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_unreconcile_select.account_id IS 'Account';


--
-- Name: COLUMN account_move_line_unreconcile_select.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_unreconcile_select.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line_unreconcile_select.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_line_unreconcile_select.write_date IS 'Last Updated on';


--
-- Name: account_move_line_unreconcile_select_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_line_unreconcile_select_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_unreconcile_select_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_line_unreconcile_select_id_seq OWNED BY account_move_line_unreconcile_select.id;


--
-- Name: account_move_reconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_move_reconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date date,
    name character varying NOT NULL,
    opening_reconciliation boolean,
    write_uid integer,
    write_date timestamp without time zone,
    type character varying NOT NULL
);


--
-- Name: TABLE account_move_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_move_reconcile IS 'Account Reconciliation';


--
-- Name: COLUMN account_move_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.create_date IS 'Creation date';


--
-- Name: COLUMN account_move_reconcile.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.name IS 'Name';


--
-- Name: COLUMN account_move_reconcile.opening_reconciliation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.opening_reconciliation IS 'Opening Entries Reconciliation';


--
-- Name: COLUMN account_move_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reconcile.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_move_reconcile.type IS 'Type';


--
-- Name: account_move_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_move_reconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_move_reconcile_id_seq OWNED BY account_move_reconcile.id;


--
-- Name: account_open_closed_fiscalyear; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_open_closed_fiscalyear (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    fyear_id integer NOT NULL
);


--
-- Name: TABLE account_open_closed_fiscalyear; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_open_closed_fiscalyear IS 'Choose Fiscal Year';


--
-- Name: COLUMN account_open_closed_fiscalyear.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_open_closed_fiscalyear.create_uid IS 'Created by';


--
-- Name: COLUMN account_open_closed_fiscalyear.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_open_closed_fiscalyear.create_date IS 'Created on';


--
-- Name: COLUMN account_open_closed_fiscalyear.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_open_closed_fiscalyear.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_open_closed_fiscalyear.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_open_closed_fiscalyear.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_open_closed_fiscalyear.fyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_open_closed_fiscalyear.fyear_id IS 'Fiscal Year';


--
-- Name: account_open_closed_fiscalyear_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_open_closed_fiscalyear_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_open_closed_fiscalyear_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_open_closed_fiscalyear_id_seq OWNED BY account_open_closed_fiscalyear.id;


--
-- Name: account_partner_balance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_partner_balance (
    id integer NOT NULL,
    create_uid integer,
    display_partner character varying,
    chart_account_id integer NOT NULL,
    result_selection character varying NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_partner_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_partner_balance IS 'Print Account Partner Balance';


--
-- Name: COLUMN account_partner_balance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.create_uid IS 'Created by';


--
-- Name: COLUMN account_partner_balance.display_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.display_partner IS 'Display Partners';


--
-- Name: COLUMN account_partner_balance.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_partner_balance.result_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.result_selection IS 'Partner''s';


--
-- Name: COLUMN account_partner_balance.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.date_from IS 'Start Date';


--
-- Name: COLUMN account_partner_balance.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.period_to IS 'End Period';


--
-- Name: COLUMN account_partner_balance.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.filter IS 'Filter by';


--
-- Name: COLUMN account_partner_balance.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.period_from IS 'Start Period';


--
-- Name: COLUMN account_partner_balance.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_partner_balance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_partner_balance.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.date_to IS 'End Date';


--
-- Name: COLUMN account_partner_balance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.create_date IS 'Created on';


--
-- Name: COLUMN account_partner_balance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partner_balance.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_balance.target_move IS 'Target Moves';


--
-- Name: account_partner_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_partner_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_partner_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_partner_balance_id_seq OWNED BY account_partner_balance.id;


--
-- Name: account_partner_balance_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_partner_balance_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_partner_balance_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_partner_balance_journal_rel IS 'RELATION BETWEEN account_partner_balance AND account_journal';


--
-- Name: account_partner_ledger; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_partner_ledger (
    id integer NOT NULL,
    create_uid integer,
    initial_balance boolean,
    chart_account_id integer NOT NULL,
    page_split boolean,
    period_to integer,
    date_from date,
    result_selection character varying NOT NULL,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    amount_currency boolean,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_partner_ledger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_partner_ledger IS 'Account Partner Ledger';


--
-- Name: COLUMN account_partner_ledger.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.create_uid IS 'Created by';


--
-- Name: COLUMN account_partner_ledger.initial_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.initial_balance IS 'Include Initial Balances';


--
-- Name: COLUMN account_partner_ledger.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_partner_ledger.page_split; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.page_split IS 'One Partner Per Page';


--
-- Name: COLUMN account_partner_ledger.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.period_to IS 'End Period';


--
-- Name: COLUMN account_partner_ledger.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.date_from IS 'Start Date';


--
-- Name: COLUMN account_partner_ledger.result_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.result_selection IS 'Partner''s';


--
-- Name: COLUMN account_partner_ledger.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.filter IS 'Filter by';


--
-- Name: COLUMN account_partner_ledger.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.period_from IS 'Start Period';


--
-- Name: COLUMN account_partner_ledger.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_partner_ledger.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_partner_ledger.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.date_to IS 'End Date';


--
-- Name: COLUMN account_partner_ledger.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_partner_ledger.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.create_date IS 'Created on';


--
-- Name: COLUMN account_partner_ledger.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partner_ledger.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_ledger.target_move IS 'Target Moves';


--
-- Name: account_partner_ledger_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_partner_ledger_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_partner_ledger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_partner_ledger_id_seq OWNED BY account_partner_ledger.id;


--
-- Name: account_partner_ledger_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_partner_ledger_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_partner_ledger_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_partner_ledger_journal_rel IS 'RELATION BETWEEN account_partner_ledger AND account_journal';


--
-- Name: account_partner_reconcile_process; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_partner_reconcile_process (
    id integer NOT NULL,
    create_uid integer,
    next_partner_id integer,
    create_date timestamp without time zone,
    to_reconcile double precision,
    write_uid integer,
    today_reconciled double precision,
    write_date timestamp without time zone,
    progress double precision
);


--
-- Name: TABLE account_partner_reconcile_process; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_partner_reconcile_process IS 'Reconcilation Process partner by partner';


--
-- Name: COLUMN account_partner_reconcile_process.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.create_uid IS 'Created by';


--
-- Name: COLUMN account_partner_reconcile_process.next_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.next_partner_id IS 'Next Partner to Reconcile';


--
-- Name: COLUMN account_partner_reconcile_process.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.create_date IS 'Created on';


--
-- Name: COLUMN account_partner_reconcile_process.to_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.to_reconcile IS 'Remaining Partners';


--
-- Name: COLUMN account_partner_reconcile_process.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partner_reconcile_process.today_reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.today_reconciled IS 'Partners Reconciled Today';


--
-- Name: COLUMN account_partner_reconcile_process.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_partner_reconcile_process.progress; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_partner_reconcile_process.progress IS 'Progress';


--
-- Name: account_partner_reconcile_process_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_partner_reconcile_process_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_partner_reconcile_process_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_partner_reconcile_process_id_seq OWNED BY account_partner_reconcile_process.id;


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_payment_term (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    note text,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_payment_term IS 'Payment Term';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.name IS 'Payment Term';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.note IS 'Description';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term.active IS 'Active';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_payment_term_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_payment_term_id_seq OWNED BY account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_payment_term_line (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    days2 integer NOT NULL,
    days integer NOT NULL,
    value character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    value_amount numeric
);


--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_payment_term_line IS 'Payment Term Line';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.payment_id IS 'Payment Term';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.days2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.days2 IS 'Day of the Month';


--
-- Name: COLUMN account_payment_term_line.days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.days IS 'Number of Days';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.value IS 'Computation';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_payment_term_line.value_amount IS 'Amount To Pay';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_payment_term_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_payment_term_line_id_seq OWNED BY account_payment_term_line.id;


--
-- Name: account_period_close; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_period_close (
    id integer NOT NULL,
    create_uid integer,
    sure boolean,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_period_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_period_close IS 'period close';


--
-- Name: COLUMN account_period_close.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period_close.create_uid IS 'Created by';


--
-- Name: COLUMN account_period_close.sure; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period_close.sure IS 'Check this box';


--
-- Name: COLUMN account_period_close.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period_close.create_date IS 'Created on';


--
-- Name: COLUMN account_period_close.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period_close.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_period_close.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_period_close.write_date IS 'Last Updated on';


--
-- Name: account_period_close_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_period_close_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_period_close_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_period_close_id_seq OWNED BY account_period_close.id;


--
-- Name: account_period_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_period_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_period_id_seq OWNED BY account_period.id;


--
-- Name: account_print_journal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_print_journal (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    sort_selection character varying NOT NULL,
    date_from date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    date_to date,
    amount_currency boolean,
    create_date timestamp without time zone,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_print_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_print_journal IS 'Account Print Journal';


--
-- Name: COLUMN account_print_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_print_journal.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_print_journal.sort_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.sort_selection IS 'Entries Sorted by';


--
-- Name: COLUMN account_print_journal.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.date_from IS 'Start Date';


--
-- Name: COLUMN account_print_journal.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.period_to IS 'End Period';


--
-- Name: COLUMN account_print_journal.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.filter IS 'Filter by';


--
-- Name: COLUMN account_print_journal.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.period_from IS 'Start Period';


--
-- Name: COLUMN account_print_journal.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_print_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_print_journal.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.date_to IS 'End Date';


--
-- Name: COLUMN account_print_journal.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_print_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_print_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_print_journal.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_print_journal.target_move IS 'Target Moves';


--
-- Name: account_print_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_print_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_print_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_print_journal_id_seq OWNED BY account_print_journal.id;


--
-- Name: account_print_journal_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_print_journal_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_print_journal_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_print_journal_journal_rel IS 'RELATION BETWEEN account_print_journal AND account_journal';


--
-- Name: account_report_general_ledger; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_report_general_ledger (
    id integer NOT NULL,
    create_uid integer,
    initial_balance boolean,
    chart_account_id integer NOT NULL,
    target_move character varying NOT NULL,
    display_account character varying NOT NULL,
    date_from date,
    period_to integer,
    write_uid integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    sortby character varying NOT NULL,
    write_date timestamp without time zone,
    date_to date,
    create_date timestamp without time zone,
    amount_currency boolean,
    landscape boolean
);


--
-- Name: TABLE account_report_general_ledger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_report_general_ledger IS 'General Ledger Report';


--
-- Name: COLUMN account_report_general_ledger.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_general_ledger.initial_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.initial_balance IS 'Include Initial Balances';


--
-- Name: COLUMN account_report_general_ledger.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_report_general_ledger.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.target_move IS 'Target Moves';


--
-- Name: COLUMN account_report_general_ledger.display_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.display_account IS 'Display Accounts';


--
-- Name: COLUMN account_report_general_ledger.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.date_from IS 'Start Date';


--
-- Name: COLUMN account_report_general_ledger.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.period_to IS 'End Period';


--
-- Name: COLUMN account_report_general_ledger.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_general_ledger.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.filter IS 'Filter by';


--
-- Name: COLUMN account_report_general_ledger.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.period_from IS 'Start Period';


--
-- Name: COLUMN account_report_general_ledger.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_report_general_ledger.sortby; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.sortby IS 'Sort by';


--
-- Name: COLUMN account_report_general_ledger.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_general_ledger.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.date_to IS 'End Date';


--
-- Name: COLUMN account_report_general_ledger.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.create_date IS 'Created on';


--
-- Name: COLUMN account_report_general_ledger.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_report_general_ledger.landscape; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_report_general_ledger.landscape IS 'Landscape Mode';


--
-- Name: account_report_general_ledger_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_report_general_ledger_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_general_ledger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_report_general_ledger_id_seq OWNED BY account_report_general_ledger.id;


--
-- Name: account_report_general_ledger_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_report_general_ledger_journal_rel (
    account_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE account_report_general_ledger_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_report_general_ledger_journal_rel IS 'RELATION BETWEEN account_report_general_ledger AND account_journal';


--
-- Name: account_sequence_fiscalyear; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_sequence_fiscalyear (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    fiscalyear_id integer NOT NULL,
    write_uid integer,
    sequence_id integer NOT NULL,
    write_date timestamp without time zone,
    sequence_main_id integer NOT NULL,
    CONSTRAINT account_sequence_fiscalyear_main_id CHECK ((sequence_main_id <> sequence_id))
);


--
-- Name: TABLE account_sequence_fiscalyear; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_sequence_fiscalyear IS 'account.sequence.fiscalyear';


--
-- Name: COLUMN account_sequence_fiscalyear.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.create_uid IS 'Created by';


--
-- Name: COLUMN account_sequence_fiscalyear.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.create_date IS 'Created on';


--
-- Name: COLUMN account_sequence_fiscalyear.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_sequence_fiscalyear.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_sequence_fiscalyear.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.sequence_id IS 'Sequence';


--
-- Name: COLUMN account_sequence_fiscalyear.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_sequence_fiscalyear.sequence_main_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_sequence_fiscalyear.sequence_main_id IS 'Main Sequence';


--
-- Name: account_sequence_fiscalyear_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_sequence_fiscalyear_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_sequence_fiscalyear_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_sequence_fiscalyear_id_seq OWNED BY account_sequence_fiscalyear.id;


--
-- Name: account_state_open; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_state_open (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_state_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_state_open IS 'Account State Open';


--
-- Name: COLUMN account_state_open.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_state_open.create_uid IS 'Created by';


--
-- Name: COLUMN account_state_open.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_state_open.create_date IS 'Created on';


--
-- Name: COLUMN account_state_open.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_state_open.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_state_open.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_state_open.write_uid IS 'Last Updated by';


--
-- Name: account_state_open_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_state_open_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_state_open_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_state_open_id_seq OWNED BY account_state_open.id;


--
-- Name: account_statement_from_invoice_lines; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_statement_from_invoice_lines (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_statement_from_invoice_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_statement_from_invoice_lines IS 'Entries by Statement from Invoices';


--
-- Name: COLUMN account_statement_from_invoice_lines.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_from_invoice_lines.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_from_invoice_lines.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_from_invoice_lines.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_from_invoice_lines.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_from_invoice_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_from_invoice_lines.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_from_invoice_lines.write_date IS 'Last Updated on';


--
-- Name: account_statement_from_invoice_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_statement_from_invoice_lines_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_statement_from_invoice_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_statement_from_invoice_lines_id_seq OWNED BY account_statement_from_invoice_lines.id;


--
-- Name: account_statement_operation_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_statement_operation_template (
    id integer NOT NULL,
    amount_type character varying NOT NULL,
    analytic_account_id integer,
    create_date timestamp without time zone,
    account_id integer,
    name character varying NOT NULL,
    create_uid integer,
    label character varying,
    amount numeric NOT NULL,
    write_date timestamp without time zone,
    write_uid integer,
    tax_id integer
);


--
-- Name: TABLE account_statement_operation_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_statement_operation_template IS 'Preset for the lines that can be created in a bank statement reconciliation';


--
-- Name: COLUMN account_statement_operation_template.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.amount_type IS 'Amount type';


--
-- Name: COLUMN account_statement_operation_template.analytic_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_statement_operation_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_operation_template.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.account_id IS 'Account';


--
-- Name: COLUMN account_statement_operation_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.name IS 'Button Label';


--
-- Name: COLUMN account_statement_operation_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_operation_template.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.label IS 'Label';


--
-- Name: COLUMN account_statement_operation_template.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.amount IS 'Amount';


--
-- Name: COLUMN account_statement_operation_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_statement_operation_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_operation_template.tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_statement_operation_template.tax_id IS 'Tax';


--
-- Name: account_statement_operation_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_statement_operation_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_statement_operation_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_statement_operation_template_id_seq OWNED BY account_statement_operation_template.id;


--
-- Name: account_subscription; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_subscription (
    id integer NOT NULL,
    model_id integer NOT NULL,
    period_nbr integer NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    create_uid integer,
    date_start date NOT NULL,
    write_uid integer,
    period_total integer NOT NULL,
    state character varying NOT NULL,
    period_type character varying NOT NULL,
    write_date timestamp without time zone,
    ref character varying
);


--
-- Name: TABLE account_subscription; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_subscription IS 'Account Subscription';


--
-- Name: COLUMN account_subscription.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.model_id IS 'Model';


--
-- Name: COLUMN account_subscription.period_nbr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.period_nbr IS 'Period';


--
-- Name: COLUMN account_subscription.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.create_date IS 'Created on';


--
-- Name: COLUMN account_subscription.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.name IS 'Name';


--
-- Name: COLUMN account_subscription.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.create_uid IS 'Created by';


--
-- Name: COLUMN account_subscription.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.date_start IS 'Start Date';


--
-- Name: COLUMN account_subscription.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_subscription.period_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.period_total IS 'Number of Periods';


--
-- Name: COLUMN account_subscription.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.state IS 'Status';


--
-- Name: COLUMN account_subscription.period_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.period_type IS 'Period Type';


--
-- Name: COLUMN account_subscription.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_subscription.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription.ref IS 'Reference';


--
-- Name: account_subscription_generate; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_subscription_generate (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    date date NOT NULL
);


--
-- Name: TABLE account_subscription_generate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_subscription_generate IS 'Subscription Compute';


--
-- Name: COLUMN account_subscription_generate.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_generate.create_uid IS 'Created by';


--
-- Name: COLUMN account_subscription_generate.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_generate.create_date IS 'Created on';


--
-- Name: COLUMN account_subscription_generate.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_generate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_subscription_generate.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_generate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_subscription_generate.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_generate.date IS 'Generate Entries Before';


--
-- Name: account_subscription_generate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_subscription_generate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_subscription_generate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_subscription_generate_id_seq OWNED BY account_subscription_generate.id;


--
-- Name: account_subscription_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_subscription_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_subscription_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_subscription_id_seq OWNED BY account_subscription.id;


--
-- Name: account_subscription_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_subscription_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    date date NOT NULL,
    subscription_id integer NOT NULL,
    move_id integer
);


--
-- Name: TABLE account_subscription_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_subscription_line IS 'Account Subscription Line';


--
-- Name: COLUMN account_subscription_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_subscription_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.create_date IS 'Created on';


--
-- Name: COLUMN account_subscription_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_subscription_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_subscription_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.date IS 'Date';


--
-- Name: COLUMN account_subscription_line.subscription_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.subscription_id IS 'Subscription';


--
-- Name: COLUMN account_subscription_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_subscription_line.move_id IS 'Entry';


--
-- Name: account_subscription_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_subscription_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_subscription_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_subscription_line_id_seq OWNED BY account_subscription_line.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_tax (
    id integer NOT NULL,
    domain character varying,
    create_date timestamp without time zone,
    account_analytic_paid_id integer,
    ref_tax_code_id integer,
    sequence integer NOT NULL,
    account_paid_id integer,
    write_uid integer,
    base_sign numeric,
    child_depend boolean,
    include_base_amount boolean,
    create_uid integer,
    ref_tax_sign numeric,
    applicable_type character varying NOT NULL,
    company_id integer NOT NULL,
    tax_code_id integer,
    parent_id integer,
    python_compute_inv text,
    python_applicable text,
    type character varying NOT NULL,
    ref_base_sign numeric,
    description character varying,
    type_tax_use character varying NOT NULL,
    base_code_id integer,
    account_analytic_collected_id integer,
    write_date timestamp without time zone,
    active boolean,
    ref_base_code_id integer,
    name character varying NOT NULL,
    account_collected_id integer,
    amount numeric NOT NULL,
    python_compute text,
    tax_sign numeric,
    price_include boolean
);


--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.domain IS 'Domain';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.account_analytic_paid_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.account_analytic_paid_id IS 'Refund Tax Analytic Account';


--
-- Name: COLUMN account_tax.ref_tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.ref_tax_code_id IS 'Refund Tax Code';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.account_paid_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.account_paid_id IS 'Refund Tax Account';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.base_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.base_sign IS 'Base Code Sign';


--
-- Name: COLUMN account_tax.child_depend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.child_depend IS 'Tax on Children';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.include_base_amount IS 'Included in base amount';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.ref_tax_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.ref_tax_sign IS 'Refund Tax Code Sign';


--
-- Name: COLUMN account_tax.applicable_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.applicable_type IS 'Applicability';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.tax_code_id IS 'Account Tax Code';


--
-- Name: COLUMN account_tax.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.parent_id IS 'Parent Tax Account';


--
-- Name: COLUMN account_tax.python_compute_inv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.python_compute_inv IS 'Python Code (reverse)';


--
-- Name: COLUMN account_tax.python_applicable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.python_applicable IS 'Applicable Code';


--
-- Name: COLUMN account_tax.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.type IS 'Tax Type';


--
-- Name: COLUMN account_tax.ref_base_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.ref_base_sign IS 'Refund Base Code Sign';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.description IS 'Tax Code';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.type_tax_use IS 'Tax Application';


--
-- Name: COLUMN account_tax.base_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.base_code_id IS 'Account Base Code';


--
-- Name: COLUMN account_tax.account_analytic_collected_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.account_analytic_collected_id IS 'Invoice Tax Analytic Account';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.ref_base_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.ref_base_code_id IS 'Refund Base Code';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.account_collected_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.account_collected_id IS 'Invoice Tax Account';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.python_compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.python_compute IS 'Python Code';


--
-- Name: COLUMN account_tax.tax_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.tax_sign IS 'Tax Code Sign';


--
-- Name: COLUMN account_tax.price_include; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax.price_include IS 'Tax Included in Price';


--
-- Name: account_tax_chart; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_tax_chart (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    period_id integer,
    write_date timestamp without time zone,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_tax_chart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_tax_chart IS 'Account tax chart';


--
-- Name: COLUMN account_tax_chart.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_chart.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_chart.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_chart.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.period_id IS 'Period';


--
-- Name: COLUMN account_tax_chart.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_chart.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_chart.target_move IS 'Target Moves';


--
-- Name: account_tax_chart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_tax_chart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_chart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_tax_chart_id_seq OWNED BY account_tax_chart.id;


--
-- Name: account_tax_code; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_tax_code (
    id integer NOT NULL,
    info text,
    create_uid integer,
    code character varying(64),
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    sign double precision NOT NULL,
    notprintable boolean,
    parent_id integer,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_tax_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_tax_code IS 'Tax Code';


--
-- Name: COLUMN account_tax_code.info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.info IS 'Description';


--
-- Name: COLUMN account_tax_code.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_code.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.code IS 'Case Code';


--
-- Name: COLUMN account_tax_code.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_code.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.name IS 'Tax Case Name';


--
-- Name: COLUMN account_tax_code.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_code.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.company_id IS 'Company';


--
-- Name: COLUMN account_tax_code.sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.sign IS 'Coefficent for parent';


--
-- Name: COLUMN account_tax_code.notprintable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.notprintable IS 'Not Printable in Invoice';


--
-- Name: COLUMN account_tax_code.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.parent_id IS 'Parent Code';


--
-- Name: COLUMN account_tax_code.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_code.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code.write_uid IS 'Last Updated by';


--
-- Name: account_tax_code_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_tax_code_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_tax_code_id_seq OWNED BY account_tax_code.id;


--
-- Name: account_tax_code_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_tax_code_template (
    id integer NOT NULL,
    info text,
    create_uid integer,
    code character varying(64),
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    sign double precision NOT NULL,
    notprintable boolean,
    parent_id integer,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_tax_code_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_tax_code_template IS 'Tax Code Template';


--
-- Name: COLUMN account_tax_code_template.info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.info IS 'Description';


--
-- Name: COLUMN account_tax_code_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_code_template.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.code IS 'Case Code';


--
-- Name: COLUMN account_tax_code_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_code_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.name IS 'Tax Case Name';


--
-- Name: COLUMN account_tax_code_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_code_template.sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.sign IS 'Sign For Parent';


--
-- Name: COLUMN account_tax_code_template.notprintable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.notprintable IS 'Not Printable in Invoice';


--
-- Name: COLUMN account_tax_code_template.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.parent_id IS 'Parent Code';


--
-- Name: COLUMN account_tax_code_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_code_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_code_template.write_uid IS 'Last Updated by';


--
-- Name: account_tax_code_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_tax_code_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_code_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_tax_code_template_id_seq OWNED BY account_tax_code_template.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_tax_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_tax_id_seq OWNED BY account_tax.id;


--
-- Name: account_tax_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_tax_template (
    id integer NOT NULL,
    domain character varying,
    create_date timestamp without time zone,
    ref_tax_code_id integer,
    sequence integer NOT NULL,
    write_uid integer,
    base_sign double precision,
    child_depend boolean,
    include_base_amount boolean,
    applicable_type character varying NOT NULL,
    create_uid integer,
    ref_base_code_id integer,
    name character varying NOT NULL,
    tax_code_id integer,
    parent_id integer,
    python_compute_inv text,
    ref_tax_sign double precision,
    type character varying NOT NULL,
    ref_base_sign double precision,
    description character varying,
    type_tax_use character varying NOT NULL,
    base_code_id integer,
    write_date timestamp without time zone,
    python_applicable text,
    account_paid_id integer,
    account_collected_id integer,
    chart_template_id integer NOT NULL,
    amount numeric NOT NULL,
    python_compute text,
    tax_sign double precision,
    price_include boolean
);


--
-- Name: TABLE account_tax_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_tax_template IS 'Templates for Taxes';


--
-- Name: COLUMN account_tax_template.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.domain IS 'Domain';


--
-- Name: COLUMN account_tax_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_template.ref_tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.ref_tax_code_id IS 'Refund Tax Code';


--
-- Name: COLUMN account_tax_template.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_template.base_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.base_sign IS 'Base Code Sign';


--
-- Name: COLUMN account_tax_template.child_depend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.child_depend IS 'Tax on Children';


--
-- Name: COLUMN account_tax_template.include_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.include_base_amount IS 'Include in Base Amount';


--
-- Name: COLUMN account_tax_template.applicable_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.applicable_type IS 'Applicable Type';


--
-- Name: COLUMN account_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_template.ref_base_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.ref_base_code_id IS 'Refund Base Code';


--
-- Name: COLUMN account_tax_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.name IS 'Tax Name';


--
-- Name: COLUMN account_tax_template.tax_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.tax_code_id IS 'Tax Code';


--
-- Name: COLUMN account_tax_template.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.parent_id IS 'Parent Tax Account';


--
-- Name: COLUMN account_tax_template.python_compute_inv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.python_compute_inv IS 'Python Code (reverse)';


--
-- Name: COLUMN account_tax_template.ref_tax_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.ref_tax_sign IS 'Refund Tax Code Sign';


--
-- Name: COLUMN account_tax_template.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.type IS 'Tax Type';


--
-- Name: COLUMN account_tax_template.ref_base_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.ref_base_sign IS 'Refund Base Code Sign';


--
-- Name: COLUMN account_tax_template.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.description IS 'Internal Name';


--
-- Name: COLUMN account_tax_template.type_tax_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.type_tax_use IS 'Tax Use In';


--
-- Name: COLUMN account_tax_template.base_code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.base_code_id IS 'Base Code';


--
-- Name: COLUMN account_tax_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_template.python_applicable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.python_applicable IS 'Applicable Code';


--
-- Name: COLUMN account_tax_template.account_paid_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.account_paid_id IS 'Refund Tax Account';


--
-- Name: COLUMN account_tax_template.account_collected_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.account_collected_id IS 'Invoice Tax Account';


--
-- Name: COLUMN account_tax_template.chart_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_tax_template.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.amount IS 'Amount';


--
-- Name: COLUMN account_tax_template.python_compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.python_compute IS 'Python Code';


--
-- Name: COLUMN account_tax_template.tax_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.tax_sign IS 'Tax Code Sign';


--
-- Name: COLUMN account_tax_template.price_include; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_tax_template.price_include IS 'Tax Included in Price';


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_tax_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_tax_template_id_seq OWNED BY account_tax_template.id;


--
-- Name: account_template_financial_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_template_financial_report (
    account_template_id integer NOT NULL,
    report_line_id integer NOT NULL
);


--
-- Name: TABLE account_template_financial_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_template_financial_report IS 'RELATION BETWEEN account_account_template AND account_financial_report';


--
-- Name: account_treasury_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW account_treasury_report AS
    SELECT p.id, p.fiscalyear_id, p.id AS period_id, sum(l.debit) AS debit, sum(l.credit) AS credit, sum((l.debit - l.credit)) AS balance, p.date_start AS date, am.company_id FROM (((account_move_line l LEFT JOIN account_account a ON ((l.account_id = a.id))) LEFT JOIN account_move am ON ((am.id = l.move_id))) LEFT JOIN account_period p ON ((am.period_id = p.id))) WHERE (((l.state)::text <> 'draft'::text) AND ((a.type)::text = 'liquidity'::text)) GROUP BY p.id, p.fiscalyear_id, p.date_start, am.company_id;


--
-- Name: account_unreconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_unreconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_unreconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_unreconcile IS 'Account Unreconcile';


--
-- Name: COLUMN account_unreconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_unreconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_unreconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_unreconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile.write_uid IS 'Last Updated by';


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_unreconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_unreconcile_id_seq OWNED BY account_unreconcile.id;


--
-- Name: account_unreconcile_reconcile; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_unreconcile_reconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE account_unreconcile_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_unreconcile_reconcile IS 'Account Unreconcile Reconcile';


--
-- Name: COLUMN account_unreconcile_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_unreconcile_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_unreconcile_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_unreconcile_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_unreconcile_reconcile.write_uid IS 'Last Updated by';


--
-- Name: account_unreconcile_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_unreconcile_reconcile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_unreconcile_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_unreconcile_reconcile_id_seq OWNED BY account_unreconcile_reconcile.id;


--
-- Name: account_use_model; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_use_model (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_use_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_use_model IS 'Use model';


--
-- Name: COLUMN account_use_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_use_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_use_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_use_model.create_date IS 'Created on';


--
-- Name: COLUMN account_use_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_use_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_use_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_use_model.write_date IS 'Last Updated on';


--
-- Name: account_use_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_use_model_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_use_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_use_model_id_seq OWNED BY account_use_model.id;


--
-- Name: account_use_model_relation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_use_model_relation (
    account_id integer NOT NULL,
    model_id integer NOT NULL
);


--
-- Name: TABLE account_use_model_relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_use_model_relation IS 'RELATION BETWEEN account_use_model AND account_model';


--
-- Name: account_vat_declaration; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_vat_declaration (
    id integer NOT NULL,
    create_uid integer,
    chart_account_id integer NOT NULL,
    date_from date,
    date_to date,
    period_to integer,
    filter character varying NOT NULL,
    period_from integer,
    fiscalyear_id integer,
    write_date timestamp without time zone,
    based_on character varying NOT NULL,
    display_detail boolean,
    create_date timestamp without time zone,
    chart_tax_id integer NOT NULL,
    write_uid integer,
    target_move character varying NOT NULL
);


--
-- Name: TABLE account_vat_declaration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_vat_declaration IS 'Account Vat Declaration';


--
-- Name: COLUMN account_vat_declaration.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.create_uid IS 'Created by';


--
-- Name: COLUMN account_vat_declaration.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN account_vat_declaration.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.date_from IS 'Start Date';


--
-- Name: COLUMN account_vat_declaration.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.date_to IS 'End Date';


--
-- Name: COLUMN account_vat_declaration.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.period_to IS 'End Period';


--
-- Name: COLUMN account_vat_declaration.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.filter IS 'Filter by';


--
-- Name: COLUMN account_vat_declaration.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.period_from IS 'Start Period';


--
-- Name: COLUMN account_vat_declaration.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN account_vat_declaration.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_vat_declaration.based_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.based_on IS 'Based on';


--
-- Name: COLUMN account_vat_declaration.display_detail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.display_detail IS 'Display Detail';


--
-- Name: COLUMN account_vat_declaration.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.create_date IS 'Created on';


--
-- Name: COLUMN account_vat_declaration.chart_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.chart_tax_id IS 'Chart of Tax';


--
-- Name: COLUMN account_vat_declaration.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_vat_declaration.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_vat_declaration.target_move IS 'Target Moves';


--
-- Name: account_vat_declaration_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_vat_declaration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_vat_declaration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_vat_declaration_id_seq OWNED BY account_vat_declaration.id;


--
-- Name: account_voucher; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_voucher (
    id integer NOT NULL,
    comment character varying NOT NULL,
    date_due date,
    create_date timestamp without time zone,
    is_multi_currency boolean,
    number character varying,
    journal_id integer NOT NULL,
    narration text,
    partner_id integer,
    payment_rate_currency_id integer NOT NULL,
    create_uid integer,
    reference character varying,
    pay_now character varying,
    message_last_post timestamp without time zone,
    writeoff_acc_id integer,
    state character varying,
    pre_line boolean,
    type character varying,
    payment_option character varying NOT NULL,
    account_id integer NOT NULL,
    company_id integer NOT NULL,
    period_id integer NOT NULL,
    write_date timestamp without time zone,
    date date,
    tax_amount numeric,
    write_uid integer,
    move_id integer,
    tax_id integer,
    payment_rate numeric NOT NULL,
    name character varying,
    analytic_id integer,
    amount numeric NOT NULL
);


--
-- Name: TABLE account_voucher; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_voucher IS 'Accounting Voucher';


--
-- Name: COLUMN account_voucher.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.comment IS 'Counterpart Comment';


--
-- Name: COLUMN account_voucher.date_due; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.date_due IS 'Due Date';


--
-- Name: COLUMN account_voucher.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.create_date IS 'Created on';


--
-- Name: COLUMN account_voucher.is_multi_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.is_multi_currency IS 'Multi Currency Voucher';


--
-- Name: COLUMN account_voucher.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.number IS 'Number';


--
-- Name: COLUMN account_voucher.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.journal_id IS 'Journal';


--
-- Name: COLUMN account_voucher.narration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.narration IS 'Notes';


--
-- Name: COLUMN account_voucher.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.partner_id IS 'Partner';


--
-- Name: COLUMN account_voucher.payment_rate_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.payment_rate_currency_id IS 'Payment Rate Currency';


--
-- Name: COLUMN account_voucher.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.create_uid IS 'Created by';


--
-- Name: COLUMN account_voucher.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.reference IS 'Ref #';


--
-- Name: COLUMN account_voucher.pay_now; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.pay_now IS 'Payment';


--
-- Name: COLUMN account_voucher.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN account_voucher.writeoff_acc_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.writeoff_acc_id IS 'Counterpart Account';


--
-- Name: COLUMN account_voucher.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.state IS 'Status';


--
-- Name: COLUMN account_voucher.pre_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.pre_line IS 'Previous Payments ?';


--
-- Name: COLUMN account_voucher.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.type IS 'Default Type';


--
-- Name: COLUMN account_voucher.payment_option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.payment_option IS 'Payment Difference';


--
-- Name: COLUMN account_voucher.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.account_id IS 'Account';


--
-- Name: COLUMN account_voucher.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.company_id IS 'Company';


--
-- Name: COLUMN account_voucher.period_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.period_id IS 'Period';


--
-- Name: COLUMN account_voucher.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_voucher.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.date IS 'Date';


--
-- Name: COLUMN account_voucher.tax_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.tax_amount IS 'Tax Amount';


--
-- Name: COLUMN account_voucher.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_voucher.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.move_id IS 'Account Entry';


--
-- Name: COLUMN account_voucher.tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.tax_id IS 'Tax';


--
-- Name: COLUMN account_voucher.payment_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.payment_rate IS 'Exchange Rate';


--
-- Name: COLUMN account_voucher.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.name IS 'Memo';


--
-- Name: COLUMN account_voucher.analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.analytic_id IS 'Write-Off Analytic Account';


--
-- Name: COLUMN account_voucher.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher.amount IS 'Total';


--
-- Name: account_voucher_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_voucher_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_voucher_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_voucher_id_seq OWNED BY account_voucher.id;


--
-- Name: account_voucher_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE account_voucher_line (
    id integer NOT NULL,
    create_date timestamp without time zone,
    reconcile boolean,
    write_uid integer,
    amount_unreconciled numeric,
    create_uid integer,
    untax_amount double precision,
    company_id integer,
    account_analytic_id integer,
    type character varying,
    account_id integer NOT NULL,
    write_date timestamp without time zone,
    voucher_id integer NOT NULL,
    amount_original numeric,
    name character varying,
    move_line_id integer,
    amount numeric
);


--
-- Name: TABLE account_voucher_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE account_voucher_line IS 'Voucher Lines';


--
-- Name: COLUMN account_voucher_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.create_date IS 'Created on';


--
-- Name: COLUMN account_voucher_line.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_voucher_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_voucher_line.amount_unreconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.amount_unreconciled IS 'Open Balance';


--
-- Name: COLUMN account_voucher_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_voucher_line.untax_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.untax_amount IS 'Untax Amount';


--
-- Name: COLUMN account_voucher_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.company_id IS 'Company';


--
-- Name: COLUMN account_voucher_line.account_analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.account_analytic_id IS 'Analytic Account';


--
-- Name: COLUMN account_voucher_line.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.type IS 'Dr/Cr';


--
-- Name: COLUMN account_voucher_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.account_id IS 'Account';


--
-- Name: COLUMN account_voucher_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_voucher_line.voucher_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.voucher_id IS 'Voucher';


--
-- Name: COLUMN account_voucher_line.amount_original; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.amount_original IS 'Original Amount';


--
-- Name: COLUMN account_voucher_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.name IS 'Description';


--
-- Name: COLUMN account_voucher_line.move_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_voucher_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN account_voucher_line.amount IS 'Amount';


--
-- Name: account_voucher_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE account_voucher_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_voucher_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE account_voucher_line_id_seq OWNED BY account_voucher_line.id;


--
-- Name: accounting_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounting_report (
    id integer NOT NULL,
    period_to_cmp integer,
    chart_account_id integer NOT NULL,
    period_from_cmp integer,
    account_report_id integer NOT NULL,
    period_to integer,
    date_to_cmp date,
    write_uid integer,
    fiscalyear_id integer,
    create_date timestamp without time zone,
    create_uid integer,
    fiscalyear_id_cmp integer,
    date_from date,
    period_from integer,
    label_filter character varying,
    filter_cmp character varying NOT NULL,
    enable_filter boolean,
    write_date timestamp without time zone,
    date_to date,
    filter character varying NOT NULL,
    date_from_cmp date,
    debit_credit boolean,
    target_move character varying NOT NULL
);


--
-- Name: TABLE accounting_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE accounting_report IS 'Accounting Report';


--
-- Name: COLUMN accounting_report.period_to_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.period_to_cmp IS 'End Period';


--
-- Name: COLUMN accounting_report.chart_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.chart_account_id IS 'Chart of Account';


--
-- Name: COLUMN accounting_report.period_from_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.period_from_cmp IS 'Start Period';


--
-- Name: COLUMN accounting_report.account_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.account_report_id IS 'Account Reports';


--
-- Name: COLUMN accounting_report.period_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.period_to IS 'End Period';


--
-- Name: COLUMN accounting_report.date_to_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.date_to_cmp IS 'End Date';


--
-- Name: COLUMN accounting_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN accounting_report.fiscalyear_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.fiscalyear_id IS 'Fiscal Year';


--
-- Name: COLUMN accounting_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.create_date IS 'Created on';


--
-- Name: COLUMN accounting_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.create_uid IS 'Created by';


--
-- Name: COLUMN accounting_report.fiscalyear_id_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.fiscalyear_id_cmp IS 'Fiscal Year';


--
-- Name: COLUMN accounting_report.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.date_from IS 'Start Date';


--
-- Name: COLUMN accounting_report.period_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.period_from IS 'Start Period';


--
-- Name: COLUMN accounting_report.label_filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.label_filter IS 'Column Label';


--
-- Name: COLUMN accounting_report.filter_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.filter_cmp IS 'Filter by';


--
-- Name: COLUMN accounting_report.enable_filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.enable_filter IS 'Enable Comparison';


--
-- Name: COLUMN accounting_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN accounting_report.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.date_to IS 'End Date';


--
-- Name: COLUMN accounting_report.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.filter IS 'Filter by';


--
-- Name: COLUMN accounting_report.date_from_cmp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.date_from_cmp IS 'Start Date';


--
-- Name: COLUMN accounting_report.debit_credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.debit_credit IS 'Display Debit/Credit Columns';


--
-- Name: COLUMN accounting_report.target_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN accounting_report.target_move IS 'Target Moves';


--
-- Name: accounting_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE accounting_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: accounting_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE accounting_report_id_seq OWNED BY accounting_report.id;


--
-- Name: analytic_entries_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW analytic_entries_report AS
    SELECT min(a.id) AS id, count(DISTINCT a.id) AS nbr, a.date, a.user_id, a.name, analytic.partner_id, a.company_id, a.currency_id, a.account_id, a.general_account_id, a.journal_id, a.move_id, a.product_id, a.product_uom_id, sum(a.amount) AS amount, sum(a.unit_amount) AS unit_amount FROM account_analytic_line a, account_analytic_account analytic WHERE (analytic.id = a.account_id) GROUP BY a.date, a.user_id, a.name, analytic.partner_id, a.company_id, a.currency_id, a.account_id, a.general_account_id, a.journal_id, a.move_id, a.product_id, a.product_uom_id;


--
-- Name: analytic_profit_emp_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE analytic_profit_emp_rel (
    analytic_id integer NOT NULL,
    emp_id integer NOT NULL
);


--
-- Name: TABLE analytic_profit_emp_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE analytic_profit_emp_rel IS 'RELATION BETWEEN hr_timesheet_analytic_profit AND res_users';


--
-- Name: analytic_profit_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE analytic_profit_journal_rel (
    analytic_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE analytic_profit_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE analytic_profit_journal_rel IS 'RELATION BETWEEN hr_timesheet_analytic_profit AND account_analytic_journal';


--
-- Name: base_action_rule; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_action_rule (
    id integer NOT NULL,
    create_uid integer,
    kind character varying,
    create_date timestamp without time zone,
    filter_pre_id integer,
    sequence integer,
    trg_date_calendar_id integer,
    act_user_id integer,
    last_run timestamp without time zone,
    write_uid integer,
    trg_date_range_type character varying,
    write_date timestamp without time zone,
    filter_id integer,
    active boolean,
    model_id integer NOT NULL,
    trg_date_id integer,
    trg_date_range integer,
    name character varying NOT NULL,
    trg_date_resource_field_id integer
);


--
-- Name: TABLE base_action_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_action_rule IS 'Action Rules';


--
-- Name: COLUMN base_action_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.create_uid IS 'Created by';


--
-- Name: COLUMN base_action_rule.kind; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.kind IS 'When to Run';


--
-- Name: COLUMN base_action_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.create_date IS 'Create Date';


--
-- Name: COLUMN base_action_rule.filter_pre_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.filter_pre_id IS 'Before Update Filter';


--
-- Name: COLUMN base_action_rule.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.sequence IS 'Sequence';


--
-- Name: COLUMN base_action_rule.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_action_rule.act_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.act_user_id IS 'Set Responsible';


--
-- Name: COLUMN base_action_rule.last_run; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.last_run IS 'Last Run';


--
-- Name: COLUMN base_action_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_action_rule.trg_date_range_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_action_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_action_rule.filter_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.filter_id IS 'Filter';


--
-- Name: COLUMN base_action_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.active IS 'Active';


--
-- Name: COLUMN base_action_rule.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.model_id IS 'Related Document Model';


--
-- Name: COLUMN base_action_rule.trg_date_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_action_rule.trg_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_action_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.name IS 'Rule Name';


--
-- Name: COLUMN base_action_rule.trg_date_resource_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule.trg_date_resource_field_id IS 'Use employee work schedule';


--
-- Name: base_action_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_action_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_action_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_action_rule_id_seq OWNED BY base_action_rule.id;


--
-- Name: base_action_rule_ir_act_server_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_action_rule_ir_act_server_rel (
    base_action_rule_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


--
-- Name: TABLE base_action_rule_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_action_rule_ir_act_server_rel IS 'RELATION BETWEEN base_action_rule AND ir_act_server';


--
-- Name: base_action_rule_lead_test; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_action_rule_lead_test (
    id integer NOT NULL,
    create_uid integer,
    user_id integer,
    name character varying NOT NULL,
    date_action_last timestamp without time zone,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone,
    active boolean,
    create_date timestamp without time zone,
    partner_id integer
);


--
-- Name: TABLE base_action_rule_lead_test; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_action_rule_lead_test IS 'base.action.rule.lead.test';


--
-- Name: COLUMN base_action_rule_lead_test.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_action_rule_lead_test.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.user_id IS 'Responsible';


--
-- Name: COLUMN base_action_rule_lead_test.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.name IS 'Subject';


--
-- Name: COLUMN base_action_rule_lead_test.date_action_last; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.date_action_last IS 'Last Action';


--
-- Name: COLUMN base_action_rule_lead_test.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_action_rule_lead_test.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.state IS 'Status';


--
-- Name: COLUMN base_action_rule_lead_test.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_action_rule_lead_test.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.active IS 'Active';


--
-- Name: COLUMN base_action_rule_lead_test.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.create_date IS 'Created on';


--
-- Name: COLUMN base_action_rule_lead_test.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_action_rule_lead_test.partner_id IS 'Partner';


--
-- Name: base_action_rule_lead_test_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_action_rule_lead_test_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_action_rule_lead_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_action_rule_lead_test_id_seq OWNED BY base_action_rule_lead_test.id;


--
-- Name: base_action_rule_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_action_rule_res_partner_rel (
    base_action_rule_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE base_action_rule_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_action_rule_res_partner_rel IS 'RELATION BETWEEN base_action_rule AND res_partner';


--
-- Name: base_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    module_google_drive boolean,
    module_base_import boolean,
    write_uid integer,
    module_portal boolean,
    module_google_calendar boolean,
    write_date timestamp without time zone,
    module_share boolean,
    font integer,
    module_auth_oauth boolean,
    module_multi_company boolean,
    alias_domain character varying,
    auth_signup_reset_password boolean,
    auth_signup_uninvited boolean,
    auth_signup_template_user_id integer
);


--
-- Name: TABLE base_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_config_settings IS 'base.config.settings';


--
-- Name: COLUMN base_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN base_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN base_config_settings.module_google_drive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_google_drive IS 'Attach Google documents to any record';


--
-- Name: COLUMN base_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_base_import IS 'Allow users to import data from CSV files';


--
-- Name: COLUMN base_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_config_settings.module_portal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_portal IS 'Activate the customer portal';


--
-- Name: COLUMN base_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN base_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_config_settings.module_share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_share IS 'Allow documents sharing';


--
-- Name: COLUMN base_config_settings.font; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.font IS 'Report Font';


--
-- Name: COLUMN base_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_auth_oauth IS 'Use external authentication providers, sign in with google, facebook, ...';


--
-- Name: COLUMN base_config_settings.module_multi_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.module_multi_company IS 'Manage multiple companies';


--
-- Name: COLUMN base_config_settings.alias_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.alias_domain IS 'Alias Domain';


--
-- Name: COLUMN base_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN base_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.auth_signup_uninvited IS 'Allow external users to sign up';


--
-- Name: COLUMN base_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: base_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_config_settings_id_seq OWNED BY base_config_settings.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_import (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file_type character varying,
    file_name character varying,
    write_uid integer,
    file bytea,
    res_model character varying
);


--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_import IS 'base_import.import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.file IS 'File';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_import.res_model IS 'Model';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_import_id_seq OWNED BY base_import_import.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char IS 'base_import.tests.models.char';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_id_seq OWNED BY base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char_noreadonly IS 'base_import.tests.models.char.noreadonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_noreadonly.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_noreadonly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_noreadonly_id_seq OWNED BY base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char_readonly (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char_readonly IS 'base_import.tests.models.char.readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_readonly.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_readonly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_readonly_id_seq OWNED BY base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char_required (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char_required IS 'base_import.tests.models.char.required';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_required.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_required_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_required_id_seq OWNED BY base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char_states (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char_states IS 'base_import.tests.models.char.states';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_states.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_states_id_seq OWNED BY base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_char_stillreadonly IS 'base_import.tests.models.char.stillreadonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_stillreadonly.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_char_stillreadonly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_char_stillreadonly_id_seq OWNED BY base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_m2o (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_m2o IS 'base_import.tests.models.m2o';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_m2o_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_m2o_id_seq OWNED BY base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_m2o_related (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_m2o_related IS 'base_import.tests.models.m2o.related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_related.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_m2o_related_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_m2o_related_id_seq OWNED BY base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_m2o_required (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_m2o_required IS 'base_import.tests.models.m2o.required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_m2o_required_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_m2o_required_id_seq OWNED BY base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_m2o_required_related IS 'base_import.tests.models.m2o.required.related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required_related.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_m2o_required_related_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_m2o_required_related_id_seq OWNED BY base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_o2m (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_o2m IS 'base_import.tests.models.o2m';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_o2m_child (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    value integer,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_o2m_child IS 'base_import.tests.models.o2m.child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.value IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.parent_id IS 'unknown';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_o2m_child_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_o2m_child_id_seq OWNED BY base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_o2m_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_o2m_id_seq OWNED BY base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_import_tests_models_preview (
    id integer NOT NULL,
    create_uid integer,
    othervalue integer,
    create_date timestamp without time zone,
    name character varying,
    write_uid integer,
    write_date timestamp without time zone,
    somevalue integer NOT NULL
);


--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_import_tests_models_preview IS 'base_import.tests.models.preview';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_import_tests_models_preview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_import_tests_models_preview_id_seq OWNED BY base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_language_export (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    format character varying NOT NULL,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone,
    data bytea
);


--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_language_export IS 'base.language.export';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.state IS 'unknown';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_language_export_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_language_export_id_seq OWNED BY base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_language_import (
    id integer NOT NULL,
    create_uid integer,
    code character varying(5) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    data bytea NOT NULL,
    overwrite boolean
);


--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.data IS 'File';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_language_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_language_import_id_seq OWNED BY base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_language_install (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone,
    overwrite boolean
);


--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.lang IS 'Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.state IS 'Status';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_language_install_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_language_install_id_seq OWNED BY base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_configuration; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_module_configuration (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE base_module_configuration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_module_configuration IS 'base.module.configuration';


--
-- Name: COLUMN base_module_configuration.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_configuration.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_configuration.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_configuration.create_date IS 'Created on';


--
-- Name: COLUMN base_module_configuration.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_configuration.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_configuration.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_configuration.write_uid IS 'Last Updated by';


--
-- Name: base_module_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_module_configuration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_module_configuration_id_seq OWNED BY base_module_configuration.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_module_update (
    id integer NOT NULL,
    create_uid integer,
    updated integer,
    added integer,
    create_date timestamp without time zone,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_module_update_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_module_update_id_seq OWNED BY base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    module_info text
);


--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_module_upgrade IS 'Module Upgrade';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_module_upgrade.module_info IS 'Modules to Update';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_module_upgrade_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_module_upgrade_id_seq OWNED BY base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    exclude_journal_item boolean,
    create_uid integer,
    current_line_id integer,
    create_date timestamp without time zone,
    group_by_name boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    group_by_is_company boolean,
    write_uid integer,
    state character varying NOT NULL,
    maximum_group integer,
    write_date timestamp without time zone,
    number_group integer,
    group_by_email boolean,
    dst_partner_id integer
);


--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_partner_merge_automatic_wizard IS 'base.partner.merge.automatic.wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_partner_merge_automatic_wizard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_partner_merge_automatic_wizard_id_seq OWNED BY base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_partner_merge_line (
    id integer NOT NULL,
    create_uid integer,
    aggr_ids character varying NOT NULL,
    wizard_id integer,
    write_uid integer,
    min_id integer,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_partner_merge_line IS 'base.partner.merge.line';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_partner_merge_line.create_date IS 'Created on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_partner_merge_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_partner_merge_line_id_seq OWNED BY base_partner_merge_line.id;


--
-- Name: base_setup_terminology; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_setup_terminology (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    partner character varying NOT NULL
);


--
-- Name: TABLE base_setup_terminology; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_setup_terminology IS 'base.setup.terminology';


--
-- Name: COLUMN base_setup_terminology.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_setup_terminology.create_uid IS 'Created by';


--
-- Name: COLUMN base_setup_terminology.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_setup_terminology.create_date IS 'Created on';


--
-- Name: COLUMN base_setup_terminology.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_setup_terminology.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_setup_terminology.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_setup_terminology.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_setup_terminology.partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_setup_terminology.partner IS 'How do you call a Customer';


--
-- Name: base_setup_terminology_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_setup_terminology_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_setup_terminology_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_setup_terminology_id_seq OWNED BY base_setup_terminology.id;


--
-- Name: base_update_translations; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE base_update_translations (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_update_translations; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE base_update_translations IS 'base.update.translations';


--
-- Name: COLUMN base_update_translations.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_update_translations.lang IS 'Language';


--
-- Name: COLUMN base_update_translations.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_update_translations.create_uid IS 'Created by';


--
-- Name: COLUMN base_update_translations.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_update_translations.create_date IS 'Created on';


--
-- Name: COLUMN base_update_translations.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_update_translations.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_update_translations.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN base_update_translations.write_date IS 'Last Updated on';


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE base_update_translations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE base_update_translations_id_seq OWNED BY base_update_translations.id;


--
-- Name: board_create; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE board_create (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    menu_parent_id integer NOT NULL
);


--
-- Name: TABLE board_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE board_create IS 'Board Creation';


--
-- Name: COLUMN board_create.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.create_uid IS 'Created by';


--
-- Name: COLUMN board_create.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.create_date IS 'Created on';


--
-- Name: COLUMN board_create.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.name IS 'Board Name';


--
-- Name: COLUMN board_create.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN board_create.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.write_date IS 'Last Updated on';


--
-- Name: COLUMN board_create.menu_parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN board_create.menu_parent_id IS 'Parent Menu';


--
-- Name: board_create_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE board_create_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: board_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE board_create_id_seq OWNED BY board_create.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bus_bus (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    message character varying,
    channel character varying
);


--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE bus_bus IS 'bus.bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.create_date IS 'Create date';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.write_date IS 'Last Updated on';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bus_bus.channel IS 'Channel';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE bus_bus_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE bus_bus_id_seq OWNED BY bus_bus.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_alarm (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    "interval" character varying NOT NULL,
    write_uid integer,
    duration_minutes integer,
    write_date timestamp without time zone,
    duration integer NOT NULL,
    type character varying NOT NULL
);


--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_alarm IS 'Event alarm';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.duration IS 'Amount';


--
-- Name: COLUMN calendar_alarm.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_alarm.type IS 'Type';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE calendar_alarm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE calendar_alarm_id_seq OWNED BY calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_attendee (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    cn character varying,
    access_token character varying,
    event_id integer,
    state character varying,
    email character varying,
    write_date timestamp without time zone,
    write_uid integer,
    partner_id integer,
    availability character varying
);


--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_attendee IS 'Attendee information';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.cn; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.cn IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.email IS 'Email';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.partner_id IS 'Contact';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_attendee.availability IS 'Free/Busy';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE calendar_attendee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE calendar_attendee_id_seq OWNED BY calendar_attendee.id;


--
-- Name: calendar_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_contacts (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    active boolean,
    user_id integer,
    partner_id integer NOT NULL
);


--
-- Name: TABLE calendar_contacts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_contacts IS 'calendar.contacts';


--
-- Name: COLUMN calendar_contacts.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_contacts.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.create_date IS 'Created on';


--
-- Name: COLUMN calendar_contacts.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_contacts.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_contacts.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.active IS 'active';


--
-- Name: COLUMN calendar_contacts.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.user_id IS 'Me';


--
-- Name: COLUMN calendar_contacts.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_contacts.partner_id IS 'Employee';


--
-- Name: calendar_contacts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE calendar_contacts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_contacts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE calendar_contacts_id_seq OWNED BY calendar_contacts.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_event (
    id integer NOT NULL,
    allday boolean,
    create_date timestamp without time zone,
    display_start character varying,
    message_last_post timestamp without time zone,
    start_datetime timestamp without time zone,
    write_uid integer,
    month_by character varying,
    rrule character varying,
    duration double precision,
    final_date date,
    create_uid integer,
    user_id integer,
    tu boolean,
    recurrency boolean,
    week_list character varying,
    day integer,
    start timestamp without time zone NOT NULL,
    state character varying,
    location character varying,
    th boolean,
    start_date date,
    fr boolean,
    recurrent_id_date timestamp without time zone,
    description text,
    stop_date date,
    stop timestamp without time zone NOT NULL,
    stop_datetime timestamp without time zone,
    write_date timestamp without time zone,
    active boolean,
    byday character varying,
    class character varying,
    count integer,
    end_type character varying,
    name character varying NOT NULL,
    we boolean,
    mo boolean,
    "interval" integer,
    su boolean,
    recurrent_id integer,
    sa boolean,
    rrule_type character varying,
    show_as character varying,
    opportunity_id integer,
    phonecall_id integer
);


--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_event IS 'Event';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.display_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.display_start IS 'Date';


--
-- Name: COLUMN calendar_event.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN calendar_event.start_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.start_datetime IS 'Start DateTime';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.month_by; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.month_by IS 'Option';


--
-- Name: COLUMN calendar_event.rrule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.rrule IS 'Recurrent Rule';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.final_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.final_date IS 'Repeat Until';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.user_id IS 'Responsible';


--
-- Name: COLUMN calendar_event.tu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.tu IS 'Tue';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.week_list; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.week_list IS 'Weekday';


--
-- Name: COLUMN calendar_event.day; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.day IS 'Date of month';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.start IS 'Calculated start';


--
-- Name: COLUMN calendar_event.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.state IS 'Status';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.th; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.th IS 'Thu';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.fr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.fr IS 'Fri';


--
-- Name: COLUMN calendar_event.recurrent_id_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.recurrent_id_date IS 'Recurrent ID date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.stop IS 'Calculated stop';


--
-- Name: COLUMN calendar_event.stop_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.stop_datetime IS 'End Datetime';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.byday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.byday IS 'By day';


--
-- Name: COLUMN calendar_event.class; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.class IS 'Privacy';


--
-- Name: COLUMN calendar_event.count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.count IS 'Repeat';


--
-- Name: COLUMN calendar_event.end_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.end_type IS 'Recurrence Termination';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.we; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.we IS 'Wed';


--
-- Name: COLUMN calendar_event.mo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.mo IS 'Mon';


--
-- Name: COLUMN calendar_event."interval"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event."interval" IS 'Repeat Every';


--
-- Name: COLUMN calendar_event.su; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.su IS 'Sun';


--
-- Name: COLUMN calendar_event.recurrent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.recurrent_id IS 'Recurrent ID';


--
-- Name: COLUMN calendar_event.sa; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.sa IS 'Sat';


--
-- Name: COLUMN calendar_event.rrule_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.rrule_type IS 'Recurrency';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.show_as IS 'Show Time as';


--
-- Name: COLUMN calendar_event.opportunity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN calendar_event.phonecall_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event.phonecall_id IS 'Phonecall';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE calendar_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE calendar_event_id_seq OWNED BY calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_event_res_partner_rel (
    calendar_event_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_event_res_partner_rel IS 'RELATION BETWEEN calendar_event AND res_partner';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendar_event_type (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE calendar_event_type IS 'Meeting Type';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE calendar_event_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE calendar_event_type_id_seq OWNED BY calendar_event_type.id;


--
-- Name: cash_box_in; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cash_box_in (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    amount numeric NOT NULL,
    write_date timestamp without time zone,
    ref character varying
);


--
-- Name: TABLE cash_box_in; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cash_box_in IS 'cash.box.in';


--
-- Name: COLUMN cash_box_in.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.create_uid IS 'Created by';


--
-- Name: COLUMN cash_box_in.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.create_date IS 'Created on';


--
-- Name: COLUMN cash_box_in.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.name IS 'Reason';


--
-- Name: COLUMN cash_box_in.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cash_box_in.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.amount IS 'Amount';


--
-- Name: COLUMN cash_box_in.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.write_date IS 'Last Updated on';


--
-- Name: COLUMN cash_box_in.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_in.ref IS 'Reference';


--
-- Name: cash_box_in_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cash_box_in_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cash_box_in_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cash_box_in_id_seq OWNED BY cash_box_in.id;


--
-- Name: cash_box_out; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cash_box_out (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    amount numeric NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE cash_box_out; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cash_box_out IS 'cash.box.out';


--
-- Name: COLUMN cash_box_out.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.create_uid IS 'Created by';


--
-- Name: COLUMN cash_box_out.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.create_date IS 'Created on';


--
-- Name: COLUMN cash_box_out.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.name IS 'Reason';


--
-- Name: COLUMN cash_box_out.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cash_box_out.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.amount IS 'Amount';


--
-- Name: COLUMN cash_box_out.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cash_box_out.write_date IS 'Last Updated on';


--
-- Name: cash_box_out_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cash_box_out_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cash_box_out_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cash_box_out_id_seq OWNED BY cash_box_out.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE change_password_user (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    user_login character varying,
    new_passwd character varying,
    wizard_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    user_id integer NOT NULL
);


--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE change_password_user IS 'Change Password Wizard User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.write_date IS 'Last Updated on';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_user.user_id IS 'User';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE change_password_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE change_password_user_id_seq OWNED BY change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE change_password_wizard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE change_password_wizard_id_seq OWNED BY change_password_wizard.id;


--
-- Name: crm_case_categ; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_case_categ (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    section_id integer,
    object_id integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_case_categ; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_case_categ IS 'Category of Case';


--
-- Name: COLUMN crm_case_categ.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.create_uid IS 'Created by';


--
-- Name: COLUMN crm_case_categ.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.create_date IS 'Created on';


--
-- Name: COLUMN crm_case_categ.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.name IS 'Name';


--
-- Name: COLUMN crm_case_categ.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_case_categ.object_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.object_id IS 'Object Name';


--
-- Name: COLUMN crm_case_categ.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_case_categ.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_categ.write_date IS 'Last Updated on';


--
-- Name: crm_case_categ_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_case_categ_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_case_categ_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_case_categ_id_seq OWNED BY crm_case_categ.id;


--
-- Name: crm_case_section; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_case_section (
    id integer NOT NULL,
    code character varying(8),
    working_hours numeric,
    color integer,
    write_uid integer,
    create_date timestamp without time zone,
    create_uid integer,
    user_id integer,
    message_last_post timestamp without time zone,
    note text,
    parent_id integer,
    complete_name character varying(256),
    write_date timestamp without time zone,
    active boolean,
    change_responsible boolean,
    name character varying(64) NOT NULL,
    reply_to character varying(64),
    alias_id integer NOT NULL,
    use_leads boolean,
    use_opportunities boolean,
    resource_calendar_id integer,
    use_quotations boolean,
    invoiced_target integer,
    invoiced_forecast integer
);


--
-- Name: TABLE crm_case_section; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_case_section IS 'Sales Teams';


--
-- Name: COLUMN crm_case_section.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.code IS 'Code';


--
-- Name: COLUMN crm_case_section.working_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.working_hours IS 'Working Hours';


--
-- Name: COLUMN crm_case_section.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.color IS 'Color Index';


--
-- Name: COLUMN crm_case_section.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_case_section.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.create_date IS 'Created on';


--
-- Name: COLUMN crm_case_section.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.create_uid IS 'Created by';


--
-- Name: COLUMN crm_case_section.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_case_section.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN crm_case_section.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.note IS 'Description';


--
-- Name: COLUMN crm_case_section.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.parent_id IS 'Parent Team';


--
-- Name: COLUMN crm_case_section.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.complete_name IS 'unknown';


--
-- Name: COLUMN crm_case_section.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_case_section.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.active IS 'Active';


--
-- Name: COLUMN crm_case_section.change_responsible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.change_responsible IS 'Reassign Escalated';


--
-- Name: COLUMN crm_case_section.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.name IS 'Sales Team';


--
-- Name: COLUMN crm_case_section.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.reply_to IS 'Reply-To';


--
-- Name: COLUMN crm_case_section.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.alias_id IS 'Alias';


--
-- Name: COLUMN crm_case_section.use_leads; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.use_leads IS 'Leads';


--
-- Name: COLUMN crm_case_section.use_opportunities; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.use_opportunities IS 'Opportunities';


--
-- Name: COLUMN crm_case_section.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.resource_calendar_id IS 'Working Time';


--
-- Name: COLUMN crm_case_section.use_quotations; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.use_quotations IS 'Quotations';


--
-- Name: COLUMN crm_case_section.invoiced_target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.invoiced_target IS 'Invoice Target';


--
-- Name: COLUMN crm_case_section.invoiced_forecast; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_section.invoiced_forecast IS 'Invoice Forecast';


--
-- Name: crm_case_section_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_case_section_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_case_section_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_case_section_id_seq OWNED BY crm_case_section.id;


--
-- Name: crm_case_stage; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_case_stage (
    id integer NOT NULL,
    create_uid integer,
    case_default boolean,
    requirements text,
    name character varying NOT NULL,
    probability double precision NOT NULL,
    sequence integer,
    on_change boolean,
    write_uid integer,
    fold boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    type character varying NOT NULL
);


--
-- Name: TABLE crm_case_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_case_stage IS 'Stage of case';


--
-- Name: COLUMN crm_case_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.create_uid IS 'Created by';


--
-- Name: COLUMN crm_case_stage.case_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.case_default IS 'Default to New Sales Team';


--
-- Name: COLUMN crm_case_stage.requirements; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.requirements IS 'Requirements';


--
-- Name: COLUMN crm_case_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.name IS 'Stage Name';


--
-- Name: COLUMN crm_case_stage.probability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.probability IS 'Probability (%)';


--
-- Name: COLUMN crm_case_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.sequence IS 'Sequence';


--
-- Name: COLUMN crm_case_stage.on_change; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.on_change IS 'Change Probability Automatically';


--
-- Name: COLUMN crm_case_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_case_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.fold IS 'Folded in Kanban View';


--
-- Name: COLUMN crm_case_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_case_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.create_date IS 'Created on';


--
-- Name: COLUMN crm_case_stage.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_case_stage.type IS 'Type';


--
-- Name: crm_case_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_case_stage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_case_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_case_stage_id_seq OWNED BY crm_case_stage.id;


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead (
    id integer NOT NULL,
    date_closed timestamp without time zone,
    create_date timestamp without time zone,
    date_deadline date,
    color integer,
    country_id integer,
    date_last_stage_update timestamp without time zone,
    date_action_last timestamp without time zone,
    campaign_id integer,
    day_close numeric,
    write_uid integer,
    active boolean,
    day_open numeric,
    contact_name character varying(64),
    partner_id integer,
    date_action_next timestamp without time zone,
    city character varying,
    user_id integer,
    opt_out boolean,
    date_open timestamp without time zone,
    title integer,
    partner_name character varying(64),
    planned_revenue double precision,
    message_last_post timestamp without time zone,
    company_id integer,
    priority character varying,
    email_cc text,
    ref character varying,
    planned_cost double precision,
    function character varying,
    fax character varying,
    zip character varying(24),
    description text,
    create_uid integer,
    street2 character varying,
    ref2 character varying,
    section_id integer,
    title_action character varying,
    phone character varying,
    probability double precision,
    write_date timestamp without time zone,
    payment_mode integer,
    date_action date,
    name character varying NOT NULL,
    stage_id integer,
    medium_id integer,
    mobile character varying,
    type character varying,
    street character varying,
    message_bounce integer,
    source_id integer,
    state_id integer,
    email_from character varying(128),
    referred character varying,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_closed IS 'Closed';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.create_date IS 'Creation Date';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_action_last; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_action_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.partner_id IS 'Partner';


--
-- Name: COLUMN crm_lead.date_action_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_action_next IS 'Next Action';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.opt_out; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.opt_out IS 'Opt-Out';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_open IS 'Assigned';


--
-- Name: COLUMN crm_lead.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.title IS 'Title';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.partner_name IS 'Customer Name';


--
-- Name: COLUMN crm_lead.planned_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.planned_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.email_cc IS 'Global CC';


--
-- Name: COLUMN crm_lead.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.ref IS 'Reference';


--
-- Name: COLUMN crm_lead.planned_cost; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.planned_cost IS 'Planned Costs';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.function IS 'Function';


--
-- Name: COLUMN crm_lead.fax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.fax IS 'Fax';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.ref2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.ref2 IS 'Reference 2';


--
-- Name: COLUMN crm_lead.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.title_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.title_action IS 'Next Action';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.probability IS 'Success Rate (%)';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.write_date IS 'Update Date';


--
-- Name: COLUMN crm_lead.payment_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.payment_mode IS 'Payment Mode';


--
-- Name: COLUMN crm_lead.date_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.date_action IS 'Next Action Date';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.name IS 'Subject';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.medium_id IS 'Channel';


--
-- Name: COLUMN crm_lead.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.mobile IS 'Mobile';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead.referred IS 'Referred By';


--
-- Name: crm_lead2opportunity_partner; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead2opportunity_partner (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    section_id integer,
    write_date timestamp without time zone,
    action character varying NOT NULL,
    user_id integer,
    write_uid integer,
    partner_id integer
);


--
-- Name: TABLE crm_lead2opportunity_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead2opportunity_partner IS 'Lead To Opportunity Partner';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead2opportunity_partner.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner.partner_id IS 'Customer';


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_lead2opportunity_partner_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_lead2opportunity_partner_id_seq OWNED BY crm_lead2opportunity_partner.id;


--
-- Name: crm_lead2opportunity_partner_mass; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead2opportunity_partner_mass (
    id integer NOT NULL,
    create_uid integer,
    deduplicate boolean,
    user_id integer,
    name character varying NOT NULL,
    force_assignation boolean,
    section_id integer,
    write_uid integer,
    write_date timestamp without time zone,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    partner_id integer
);


--
-- Name: TABLE crm_lead2opportunity_partner_mass; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead2opportunity_partner_mass IS 'Mass Lead To Opportunity Partner';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.deduplicate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.deduplicate IS 'Apply deduplication';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.force_assignation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.force_assignation IS 'Force assignation';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_lead2opportunity_partner_mass.partner_id IS 'Customer';


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_lead2opportunity_partner_mass_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_lead2opportunity_partner_mass_id_seq OWNED BY crm_lead2opportunity_partner_mass.id;


--
-- Name: crm_lead2opportunity_partner_mass_res_users_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead2opportunity_partner_mass_res_users_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE crm_lead2opportunity_partner_mass_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead2opportunity_partner_mass_res_users_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND res_users';


--
-- Name: crm_lead_category_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead_category_rel (
    lead_id integer NOT NULL,
    category_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead_category_rel IS 'RELATION BETWEEN crm_lead AND crm_case_categ';


--
-- Name: crm_lead_crm_lead2opportunity_partner_mass_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead_crm_lead2opportunity_partner_mass_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_mass_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead_crm_lead2opportunity_partner_mass_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_lead_crm_lead2opportunity_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead_crm_lead2opportunity_partner_rel (
    crm_lead2opportunity_partner_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_lead_crm_lead2opportunity_partner_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner AND crm_lead';


--
-- Name: crm_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_lead_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_lead_id_seq OWNED BY crm_lead.id;


--
-- Name: crm_lead_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_lead_report (
    id integer,
    date_deadline date,
    nbr_cases bigint,
    opening_date timestamp without time zone,
    date_closed timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    user_id integer,
    probability double precision,
    stage_id integer,
    type character varying,
    company_id integer,
    priority character varying,
    section_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    partner_id integer,
    country_id integer,
    planned_revenue double precision,
    probable_revenue double precision,
    create_date timestamp without time zone,
    delay_close double precision,
    delay_expected double precision,
    delay_open double precision
);


--
-- Name: crm_make_sale; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_make_sale (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    close boolean,
    partner_id integer NOT NULL
);


--
-- Name: TABLE crm_make_sale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_make_sale IS 'Make sales';


--
-- Name: COLUMN crm_make_sale.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.create_uid IS 'Created by';


--
-- Name: COLUMN crm_make_sale.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.create_date IS 'Created on';


--
-- Name: COLUMN crm_make_sale.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_make_sale.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_make_sale.close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.close IS 'Mark Won';


--
-- Name: COLUMN crm_make_sale.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_make_sale.partner_id IS 'Customer';


--
-- Name: crm_make_sale_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_make_sale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_make_sale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_make_sale_id_seq OWNED BY crm_make_sale.id;


--
-- Name: crm_merge_opportunity; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_merge_opportunity (
    id integer NOT NULL,
    create_uid integer,
    user_id integer,
    section_id integer,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE crm_merge_opportunity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_merge_opportunity IS 'Merge opportunities';


--
-- Name: COLUMN crm_merge_opportunity.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.create_uid IS 'Created by';


--
-- Name: COLUMN crm_merge_opportunity.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_merge_opportunity.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_merge_opportunity.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_merge_opportunity.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.create_date IS 'Created on';


--
-- Name: COLUMN crm_merge_opportunity.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_merge_opportunity.write_uid IS 'Last Updated by';


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_merge_opportunity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_merge_opportunity_id_seq OWNED BY crm_merge_opportunity.id;


--
-- Name: crm_opportunity_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_opportunity_report (
    id integer,
    date_deadline date,
    nbr_cases bigint,
    opening_date timestamp without time zone,
    date_closed timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    user_id integer,
    probability double precision,
    stage_id integer,
    type character varying,
    company_id integer,
    priority character varying,
    section_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    partner_id integer,
    country_id integer,
    total_revenue double precision,
    expected_revenue double precision,
    create_date timestamp without time zone,
    delay_close double precision,
    delay_expected double precision,
    delay_open double precision
);


--
-- Name: crm_partner_binding; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_partner_binding (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    action character varying NOT NULL,
    partner_id integer
);


--
-- Name: TABLE crm_partner_binding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_partner_binding IS 'Handle partner binding or generation in CRM wizards.';


--
-- Name: COLUMN crm_partner_binding.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.create_uid IS 'Created by';


--
-- Name: COLUMN crm_partner_binding.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.create_date IS 'Created on';


--
-- Name: COLUMN crm_partner_binding.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_partner_binding.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_partner_binding.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.action IS 'Related Customer';


--
-- Name: COLUMN crm_partner_binding.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_partner_binding.partner_id IS 'Customer';


--
-- Name: crm_partner_binding_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_partner_binding_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_partner_binding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_partner_binding_id_seq OWNED BY crm_partner_binding.id;


--
-- Name: crm_payment_mode; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_payment_mode (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    section_id integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_payment_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_payment_mode IS 'CRM Payment Mode';


--
-- Name: COLUMN crm_payment_mode.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.create_uid IS 'Created by';


--
-- Name: COLUMN crm_payment_mode.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.create_date IS 'Created on';


--
-- Name: COLUMN crm_payment_mode.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.name IS 'Name';


--
-- Name: COLUMN crm_payment_mode.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_payment_mode.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_payment_mode.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_payment_mode.write_date IS 'Last Updated on';


--
-- Name: crm_payment_mode_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_payment_mode_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_payment_mode_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_payment_mode_id_seq OWNED BY crm_payment_mode.id;


--
-- Name: crm_phonecall; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_phonecall (
    id integer NOT NULL,
    date_closed timestamp without time zone,
    create_date timestamp without time zone,
    date_action_last timestamp without time zone,
    write_uid integer,
    date timestamp without time zone,
    duration double precision,
    partner_id integer,
    date_action_next timestamp without time zone,
    create_uid integer,
    user_id integer,
    message_last_post timestamp without time zone,
    company_id integer,
    priority character varying,
    state character varying,
    description text,
    name character varying NOT NULL,
    section_id integer,
    partner_mobile character varying,
    write_date timestamp without time zone,
    active boolean,
    categ_id integer,
    opportunity_id integer,
    date_open timestamp without time zone,
    partner_phone character varying,
    email_from character varying(128)
);


--
-- Name: TABLE crm_phonecall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_phonecall IS 'Phonecall';


--
-- Name: COLUMN crm_phonecall.date_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.date_closed IS 'Closed';


--
-- Name: COLUMN crm_phonecall.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.create_date IS 'Creation Date';


--
-- Name: COLUMN crm_phonecall.date_action_last; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.date_action_last IS 'Last Action';


--
-- Name: COLUMN crm_phonecall.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_phonecall.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.date IS 'Date';


--
-- Name: COLUMN crm_phonecall.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.duration IS 'Duration';


--
-- Name: COLUMN crm_phonecall.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.partner_id IS 'Contact';


--
-- Name: COLUMN crm_phonecall.date_action_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.date_action_next IS 'Next Action';


--
-- Name: COLUMN crm_phonecall.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.create_uid IS 'Created by';


--
-- Name: COLUMN crm_phonecall.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.user_id IS 'Responsible';


--
-- Name: COLUMN crm_phonecall.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN crm_phonecall.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.company_id IS 'Company';


--
-- Name: COLUMN crm_phonecall.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.priority IS 'Priority';


--
-- Name: COLUMN crm_phonecall.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.state IS 'Status';


--
-- Name: COLUMN crm_phonecall.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.description IS 'Description';


--
-- Name: COLUMN crm_phonecall.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.name IS 'Call Summary';


--
-- Name: COLUMN crm_phonecall.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_phonecall.partner_mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.partner_mobile IS 'Mobile';


--
-- Name: COLUMN crm_phonecall.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_phonecall.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.active IS 'Active';


--
-- Name: COLUMN crm_phonecall.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.categ_id IS 'Category';


--
-- Name: COLUMN crm_phonecall.opportunity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.opportunity_id IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_phonecall.date_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.date_open IS 'Opened';


--
-- Name: COLUMN crm_phonecall.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.partner_phone IS 'Phone';


--
-- Name: COLUMN crm_phonecall.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall.email_from IS 'Email';


--
-- Name: crm_phonecall2phonecall; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_phonecall2phonecall (
    id integer NOT NULL,
    create_uid integer,
    user_id integer,
    name character varying NOT NULL,
    categ_id integer,
    section_id integer,
    write_uid integer,
    note text,
    phone character varying,
    write_date timestamp without time zone,
    date timestamp without time zone,
    create_date timestamp without time zone,
    contact_name character varying,
    partner_id integer,
    action character varying NOT NULL
);


--
-- Name: TABLE crm_phonecall2phonecall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_phonecall2phonecall IS 'Phonecall To Phonecall';


--
-- Name: COLUMN crm_phonecall2phonecall.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.create_uid IS 'Created by';


--
-- Name: COLUMN crm_phonecall2phonecall.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.user_id IS 'Assign To';


--
-- Name: COLUMN crm_phonecall2phonecall.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.name IS 'Call summary';


--
-- Name: COLUMN crm_phonecall2phonecall.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.categ_id IS 'Category';


--
-- Name: COLUMN crm_phonecall2phonecall.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_phonecall2phonecall.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_phonecall2phonecall.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.note IS 'Note';


--
-- Name: COLUMN crm_phonecall2phonecall.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.phone IS 'Phone';


--
-- Name: COLUMN crm_phonecall2phonecall.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_phonecall2phonecall.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.date IS 'Date';


--
-- Name: COLUMN crm_phonecall2phonecall.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.create_date IS 'Created on';


--
-- Name: COLUMN crm_phonecall2phonecall.contact_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.contact_name IS 'Contact';


--
-- Name: COLUMN crm_phonecall2phonecall.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.partner_id IS 'Partner';


--
-- Name: COLUMN crm_phonecall2phonecall.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_phonecall2phonecall.action IS 'Action';


--
-- Name: crm_phonecall2phonecall_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_phonecall2phonecall_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_phonecall2phonecall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_phonecall2phonecall_id_seq OWNED BY crm_phonecall2phonecall.id;


--
-- Name: crm_phonecall_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_phonecall_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_phonecall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_phonecall_id_seq OWNED BY crm_phonecall.id;


--
-- Name: crm_phonecall_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW crm_phonecall_report AS
    SELECT c.id, c.date_open AS opening_date, c.date_closed, c.state, c.user_id, c.section_id, c.categ_id, c.partner_id, c.duration, c.company_id, c.priority, 1 AS nbr, c.create_date, (date_part('epoch'::text, (c.date_closed - c.create_date)) / ((3600 * 24))::double precision) AS delay_close, (date_part('epoch'::text, (c.date_open - c.create_date)) / ((3600 * 24))::double precision) AS delay_open FROM crm_phonecall c;


--
-- Name: crm_segmentation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_segmentation (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    description text,
    partner_id integer,
    write_uid integer,
    state character varying,
    sales_purchase_active boolean,
    exclusif boolean,
    write_date timestamp without time zone,
    categ_id integer NOT NULL,
    name character varying NOT NULL
);


--
-- Name: TABLE crm_segmentation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_segmentation IS 'Partner Segmentation';


--
-- Name: COLUMN crm_segmentation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.create_uid IS 'Created by';


--
-- Name: COLUMN crm_segmentation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.create_date IS 'Created on';


--
-- Name: COLUMN crm_segmentation.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.description IS 'Description';


--
-- Name: COLUMN crm_segmentation.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.partner_id IS 'Max Partner ID processed';


--
-- Name: COLUMN crm_segmentation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_segmentation.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.state IS 'Execution Status';


--
-- Name: COLUMN crm_segmentation.sales_purchase_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.sales_purchase_active IS 'Use The Sales Purchase Rules';


--
-- Name: COLUMN crm_segmentation.exclusif; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.exclusif IS 'Exclusive';


--
-- Name: COLUMN crm_segmentation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_segmentation.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.categ_id IS 'Partner Category';


--
-- Name: COLUMN crm_segmentation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation.name IS 'Name';


--
-- Name: crm_segmentation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_segmentation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_segmentation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_segmentation_id_seq OWNED BY crm_segmentation.id;


--
-- Name: crm_segmentation_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_segmentation_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    expr_operator character varying NOT NULL,
    expr_value double precision NOT NULL,
    write_uid integer,
    expr_name character varying NOT NULL,
    write_date timestamp without time zone,
    segmentation_id integer,
    operator character varying NOT NULL,
    name character varying NOT NULL
);


--
-- Name: TABLE crm_segmentation_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_segmentation_line IS 'Segmentation line';


--
-- Name: COLUMN crm_segmentation_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.create_uid IS 'Created by';


--
-- Name: COLUMN crm_segmentation_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.create_date IS 'Created on';


--
-- Name: COLUMN crm_segmentation_line.expr_operator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.expr_operator IS 'Operator';


--
-- Name: COLUMN crm_segmentation_line.expr_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.expr_value IS 'Value';


--
-- Name: COLUMN crm_segmentation_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_segmentation_line.expr_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.expr_name IS 'Control Variable';


--
-- Name: COLUMN crm_segmentation_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_segmentation_line.segmentation_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.segmentation_id IS 'Segmentation';


--
-- Name: COLUMN crm_segmentation_line.operator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.operator IS 'Mandatory / Optional';


--
-- Name: COLUMN crm_segmentation_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_segmentation_line.name IS 'Rule Name';


--
-- Name: crm_segmentation_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_segmentation_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_segmentation_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_segmentation_line_id_seq OWNED BY crm_segmentation_line.id;


--
-- Name: crm_tracking_campaign; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_tracking_campaign (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    section_id integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_tracking_campaign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_tracking_campaign IS 'Campaign';


--
-- Name: COLUMN crm_tracking_campaign.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tracking_campaign.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.create_date IS 'Created on';


--
-- Name: COLUMN crm_tracking_campaign.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.name IS 'Campaign Name';


--
-- Name: COLUMN crm_tracking_campaign.section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.section_id IS 'Sales Team';


--
-- Name: COLUMN crm_tracking_campaign.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tracking_campaign.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_campaign.write_date IS 'Last Updated on';


--
-- Name: crm_tracking_campaign_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_tracking_campaign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_tracking_campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_tracking_campaign_id_seq OWNED BY crm_tracking_campaign.id;


--
-- Name: crm_tracking_medium; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_tracking_medium (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE crm_tracking_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_tracking_medium IS 'Channels';


--
-- Name: COLUMN crm_tracking_medium.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tracking_medium.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.create_date IS 'Created on';


--
-- Name: COLUMN crm_tracking_medium.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.name IS 'Channel Name';


--
-- Name: COLUMN crm_tracking_medium.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tracking_medium.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_tracking_medium.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_medium.active IS 'Active';


--
-- Name: crm_tracking_medium_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_tracking_medium_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_tracking_medium_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_tracking_medium_id_seq OWNED BY crm_tracking_medium.id;


--
-- Name: crm_tracking_source; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE crm_tracking_source (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_tracking_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE crm_tracking_source IS 'Source';


--
-- Name: COLUMN crm_tracking_source.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_source.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tracking_source.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_source.create_date IS 'Created on';


--
-- Name: COLUMN crm_tracking_source.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_source.name IS 'Source Name';


--
-- Name: COLUMN crm_tracking_source.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tracking_source.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN crm_tracking_source.write_date IS 'Last Updated on';


--
-- Name: crm_tracking_source_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE crm_tracking_source_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_tracking_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE crm_tracking_source_id_seq OWNED BY crm_tracking_source.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE decimal_precision IS 'decimal.precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE decimal_precision_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE decimal_precision_id_seq OWNED BY decimal_precision.id;


--
-- Name: decimal_precision_test; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE decimal_precision_test (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    float_2 numeric,
    "float" double precision,
    float_4 numeric,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE decimal_precision_test; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE decimal_precision_test IS 'decimal.precision.test';


--
-- Name: COLUMN decimal_precision_test.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision_test.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision_test.float_2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.float_2 IS 'unknown';


--
-- Name: COLUMN decimal_precision_test."float"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test."float" IS 'unknown';


--
-- Name: COLUMN decimal_precision_test.float_4; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.float_4 IS 'unknown';


--
-- Name: COLUMN decimal_precision_test.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision_test.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN decimal_precision_test.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_test_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE decimal_precision_test_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: decimal_precision_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE decimal_precision_test_id_seq OWNED BY decimal_precision_test.id;


--
-- Name: email_template; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_template (
    id integer NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    auto_delete boolean,
    mail_server_id integer,
    write_uid integer,
    partner_to character varying,
    ref_ir_act_window integer,
    subject character varying,
    create_uid integer,
    report_template integer,
    ref_ir_value integer,
    user_signature boolean,
    null_value character varying,
    email_cc character varying,
    model_id integer,
    sub_model_object_field integer,
    body_html text,
    email_to character varying,
    sub_object integer,
    copyvalue character varying,
    lang character varying,
    name character varying,
    model_object_field integer,
    report_name character varying,
    use_default_to boolean,
    reply_to character varying,
    model character varying,
    email_from character varying
);


--
-- Name: TABLE email_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE email_template IS 'Email Templates';


--
-- Name: COLUMN email_template.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.create_date IS 'Created on';


--
-- Name: COLUMN email_template.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN email_template.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN email_template.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN email_template.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN email_template.partner_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN email_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN email_template.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.subject IS 'Subject';


--
-- Name: COLUMN email_template.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.create_uid IS 'Created by';


--
-- Name: COLUMN email_template.report_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN email_template.ref_ir_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.ref_ir_value IS 'Sidebar Button';


--
-- Name: COLUMN email_template.user_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.user_signature IS 'Add Signature';


--
-- Name: COLUMN email_template.null_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.null_value IS 'Default Value';


--
-- Name: COLUMN email_template.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.email_cc IS 'Cc';


--
-- Name: COLUMN email_template.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.model_id IS 'Applies to';


--
-- Name: COLUMN email_template.sub_model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.sub_model_object_field IS 'Sub-field';


--
-- Name: COLUMN email_template.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.body_html IS 'Body';


--
-- Name: COLUMN email_template.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN email_template.sub_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.sub_object IS 'Sub-model';


--
-- Name: COLUMN email_template.copyvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.copyvalue IS 'Placeholder Expression';


--
-- Name: COLUMN email_template.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.lang IS 'Language';


--
-- Name: COLUMN email_template.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.name IS 'Name';


--
-- Name: COLUMN email_template.model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.model_object_field IS 'Field';


--
-- Name: COLUMN email_template.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.report_name IS 'Report Filename';


--
-- Name: COLUMN email_template.use_default_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN email_template.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.reply_to IS 'Reply-To';


--
-- Name: COLUMN email_template.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.model IS 'Related Document Model';


--
-- Name: COLUMN email_template.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template.email_from IS 'From';


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE email_template_attachment_rel IS 'RELATION BETWEEN email_template AND ir_attachment';


--
-- Name: email_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE email_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: email_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE email_template_id_seq OWNED BY email_template.id;


--
-- Name: email_template_preview; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_template_preview (
    id integer NOT NULL,
    create_date timestamp without time zone,
    sub_object integer,
    auto_delete boolean,
    mail_server_id integer,
    write_uid integer,
    partner_to character varying,
    ref_ir_act_window integer,
    subject character varying,
    create_uid integer,
    report_template integer,
    ref_ir_value integer,
    user_signature boolean,
    null_value character varying,
    email_cc character varying,
    res_id character varying,
    model_id integer,
    sub_model_object_field integer,
    body_html text,
    email_to character varying,
    write_date timestamp without time zone,
    copyvalue character varying,
    lang character varying,
    name character varying,
    model_object_field integer,
    report_name character varying,
    use_default_to boolean,
    reply_to character varying,
    model character varying,
    email_from character varying
);


--
-- Name: TABLE email_template_preview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE email_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN email_template_preview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN email_template_preview.sub_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.sub_object IS 'Sub-model';


--
-- Name: COLUMN email_template_preview.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN email_template_preview.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN email_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN email_template_preview.partner_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.partner_to IS 'To (Partners)';


--
-- Name: COLUMN email_template_preview.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN email_template_preview.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.subject IS 'Subject';


--
-- Name: COLUMN email_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN email_template_preview.report_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN email_template_preview.ref_ir_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.ref_ir_value IS 'Sidebar Button';


--
-- Name: COLUMN email_template_preview.user_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.user_signature IS 'Add Signature';


--
-- Name: COLUMN email_template_preview.null_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.null_value IS 'Default Value';


--
-- Name: COLUMN email_template_preview.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.email_cc IS 'Cc';


--
-- Name: COLUMN email_template_preview.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.res_id IS 'Sample Document';


--
-- Name: COLUMN email_template_preview.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.model_id IS 'Applies to';


--
-- Name: COLUMN email_template_preview.sub_model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.sub_model_object_field IS 'Sub-field';


--
-- Name: COLUMN email_template_preview.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.body_html IS 'Body';


--
-- Name: COLUMN email_template_preview.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.email_to IS 'To (Emails)';


--
-- Name: COLUMN email_template_preview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.write_date IS 'Last Updated on';


--
-- Name: COLUMN email_template_preview.copyvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.copyvalue IS 'Placeholder Expression';


--
-- Name: COLUMN email_template_preview.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.lang IS 'Language';


--
-- Name: COLUMN email_template_preview.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.name IS 'Name';


--
-- Name: COLUMN email_template_preview.model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.model_object_field IS 'Field';


--
-- Name: COLUMN email_template_preview.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.report_name IS 'Report Filename';


--
-- Name: COLUMN email_template_preview.use_default_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.use_default_to IS 'Default recipients';


--
-- Name: COLUMN email_template_preview.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.reply_to IS 'Reply-To';


--
-- Name: COLUMN email_template_preview.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.model IS 'Related Document Model';


--
-- Name: COLUMN email_template_preview.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN email_template_preview.email_from IS 'From';


--
-- Name: email_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE email_template_preview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: email_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE email_template_preview_id_seq OWNED BY email_template_preview.id;


--
-- Name: email_template_preview_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_template_preview_res_partner_rel (
    email_template_preview_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE email_template_preview_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE email_template_preview_res_partner_rel IS 'RELATION BETWEEN email_template_preview AND res_partner';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE employee_category_rel (
    category_id integer NOT NULL,
    emp_id integer NOT NULL
);


--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE employee_category_rel IS 'RELATION BETWEEN hr_employee_category AND hr_employee';


--
-- Name: fetchmail_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fetchmail_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE fetchmail_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE fetchmail_config_settings IS 'fetchmail.config.settings';


--
-- Name: COLUMN fetchmail_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_config_settings.write_uid IS 'Last Updated by';


--
-- Name: fetchmail_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE fetchmail_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: fetchmail_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE fetchmail_config_settings_id_seq OWNED BY fetchmail_config_settings.id;


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fetchmail_server (
    id integer NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    active boolean,
    port integer,
    create_uid integer,
    configuration text,
    script character varying,
    object_id integer,
    priority integer,
    attach boolean,
    state character varying,
    type character varying NOT NULL,
    action_id integer,
    "user" character varying,
    write_date timestamp without time zone,
    date timestamp without time zone,
    password character varying,
    name character varying NOT NULL,
    is_ssl boolean,
    server character varying,
    original boolean
);


--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE fetchmail_server IS 'POP/IMAP Server';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.action_id IS 'Server Action';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN fetchmail_server.original IS 'Keep Original';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE fetchmail_server_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE fetchmail_server_id_seq OWNED BY fetchmail_server.id;


--
-- Name: hr_action_reason; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_action_reason (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    action_type character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_action_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_action_reason IS 'Action Reason';


--
-- Name: COLUMN hr_action_reason.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_action_reason.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_action_reason.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.name IS 'Reason';


--
-- Name: COLUMN hr_action_reason.action_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.action_type IS 'Action Type';


--
-- Name: COLUMN hr_action_reason.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_action_reason.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_action_reason.write_date IS 'Last Updated on';


--
-- Name: hr_action_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_action_reason_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_action_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_action_reason_id_seq OWNED BY hr_action_reason.id;


--
-- Name: hr_analytic_timesheet; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_analytic_timesheet (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    line_id integer NOT NULL,
    write_date timestamp without time zone,
    partner_id integer,
    sheet_id integer
);


--
-- Name: TABLE hr_analytic_timesheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_analytic_timesheet IS 'Timesheet Line';


--
-- Name: COLUMN hr_analytic_timesheet.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.create_uid IS 'Created by';


--
-- Name: COLUMN hr_analytic_timesheet.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.create_date IS 'Created on';


--
-- Name: COLUMN hr_analytic_timesheet.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_analytic_timesheet.line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.line_id IS 'Analytic Line';


--
-- Name: COLUMN hr_analytic_timesheet.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_analytic_timesheet.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.partner_id IS 'Partner';


--
-- Name: COLUMN hr_analytic_timesheet.sheet_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_analytic_timesheet.sheet_id IS 'Sheet';


--
-- Name: hr_analytic_timesheet_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_analytic_timesheet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_analytic_timesheet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_analytic_timesheet_id_seq OWNED BY hr_analytic_timesheet.id;


--
-- Name: hr_applicant; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_applicant (
    id integer NOT NULL,
    date_closed timestamp without time zone,
    create_date timestamp without time zone,
    type_id integer,
    color integer,
    message_last_post timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    availability integer,
    day_close numeric,
    salary_expected_extra character varying,
    salary_proposed double precision,
    day_open numeric,
    partner_id integer,
    create_uid integer,
    user_id integer,
    job_id integer,
    date_open timestamp without time zone,
    partner_name character varying,
    last_stage_id integer,
    company_id integer,
    priority character varying,
    emp_id integer,
    email_cc text,
    department_id integer,
    description text,
    salary_expected double precision,
    title_action character varying(64),
    probability double precision,
    partner_mobile character varying(32),
    write_date timestamp without time zone,
    salary_proposed_extra character varying,
    active boolean,
    date_action date,
    write_uid integer,
    reference character varying,
    stage_id integer,
    name character varying NOT NULL,
    partner_phone character varying(32),
    source_id integer,
    response_id integer,
    email_from character varying(128)
);


--
-- Name: TABLE hr_applicant; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_applicant IS 'Applicant';


--
-- Name: COLUMN hr_applicant.date_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.date_closed IS 'Closed';


--
-- Name: COLUMN hr_applicant.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.create_date IS 'Creation Date';


--
-- Name: COLUMN hr_applicant.type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.type_id IS 'Degree';


--
-- Name: COLUMN hr_applicant.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.color IS 'Color Index';


--
-- Name: COLUMN hr_applicant.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_applicant.date_last_stage_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN hr_applicant.availability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.availability IS 'Availability';


--
-- Name: COLUMN hr_applicant.day_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.day_close IS 'Days to Close';


--
-- Name: COLUMN hr_applicant.salary_expected_extra; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.salary_expected_extra IS 'Expected Salary Extra';


--
-- Name: COLUMN hr_applicant.salary_proposed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.salary_proposed IS 'Proposed Salary';


--
-- Name: COLUMN hr_applicant.day_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.day_open IS 'Days to Open';


--
-- Name: COLUMN hr_applicant.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.partner_id IS 'Contact';


--
-- Name: COLUMN hr_applicant.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.create_uid IS 'Created by';


--
-- Name: COLUMN hr_applicant.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.user_id IS 'Responsible';


--
-- Name: COLUMN hr_applicant.job_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.job_id IS 'Applied Job';


--
-- Name: COLUMN hr_applicant.date_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.date_open IS 'Assigned';


--
-- Name: COLUMN hr_applicant.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.partner_name IS 'Applicant''s Name';


--
-- Name: COLUMN hr_applicant.last_stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.last_stage_id IS 'Last Stage';


--
-- Name: COLUMN hr_applicant.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.company_id IS 'Company';


--
-- Name: COLUMN hr_applicant.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.priority IS 'Appreciation';


--
-- Name: COLUMN hr_applicant.emp_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.emp_id IS 'Employee';


--
-- Name: COLUMN hr_applicant.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.email_cc IS 'Watchers Emails';


--
-- Name: COLUMN hr_applicant.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.department_id IS 'Department';


--
-- Name: COLUMN hr_applicant.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.description IS 'Description';


--
-- Name: COLUMN hr_applicant.salary_expected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.salary_expected IS 'Expected Salary';


--
-- Name: COLUMN hr_applicant.title_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.title_action IS 'Next Action';


--
-- Name: COLUMN hr_applicant.probability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.probability IS 'Probability';


--
-- Name: COLUMN hr_applicant.partner_mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.partner_mobile IS 'Mobile';


--
-- Name: COLUMN hr_applicant.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.write_date IS 'Update Date';


--
-- Name: COLUMN hr_applicant.salary_proposed_extra; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.salary_proposed_extra IS 'Proposed Salary Extra';


--
-- Name: COLUMN hr_applicant.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.active IS 'Active';


--
-- Name: COLUMN hr_applicant.date_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.date_action IS 'Next Action Date';


--
-- Name: COLUMN hr_applicant.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_applicant.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.reference IS 'Referred By';


--
-- Name: COLUMN hr_applicant.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.stage_id IS 'Stage';


--
-- Name: COLUMN hr_applicant.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.name IS 'Subject / Application Name';


--
-- Name: COLUMN hr_applicant.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.partner_phone IS 'Phone';


--
-- Name: COLUMN hr_applicant.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.source_id IS 'Source';


--
-- Name: COLUMN hr_applicant.response_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.response_id IS 'Response';


--
-- Name: COLUMN hr_applicant.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant.email_from IS 'Email';


--
-- Name: hr_applicant_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_applicant_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_applicant_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_applicant_category IS 'Category of applicant';


--
-- Name: COLUMN hr_applicant_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_applicant_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_applicant_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant_category.name IS 'Name';


--
-- Name: COLUMN hr_applicant_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_applicant_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_applicant_category.write_date IS 'Last Updated on';


--
-- Name: hr_applicant_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_applicant_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_applicant_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_applicant_category_id_seq OWNED BY hr_applicant_category.id;


--
-- Name: hr_applicant_hr_applicant_category_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_applicant_hr_applicant_category_rel (
    hr_applicant_id integer NOT NULL,
    hr_applicant_category_id integer NOT NULL
);


--
-- Name: TABLE hr_applicant_hr_applicant_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_applicant_hr_applicant_category_rel IS 'RELATION BETWEEN hr_applicant AND hr_applicant_category';


--
-- Name: hr_applicant_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_applicant_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_applicant_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_applicant_id_seq OWNED BY hr_applicant.id;


--
-- Name: hr_attendance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_attendance (
    id integer NOT NULL,
    create_uid integer,
    employee_id integer NOT NULL,
    create_date timestamp without time zone,
    name timestamp without time zone NOT NULL,
    write_uid integer,
    action_desc integer,
    write_date timestamp without time zone,
    action character varying NOT NULL,
    worked_hours numeric,
    sheet_id integer
);


--
-- Name: TABLE hr_attendance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_attendance IS 'Attendance';


--
-- Name: COLUMN hr_attendance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN hr_attendance.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.employee_id IS 'Employee';


--
-- Name: COLUMN hr_attendance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.create_date IS 'Created on';


--
-- Name: COLUMN hr_attendance.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.name IS 'Date';


--
-- Name: COLUMN hr_attendance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_attendance.action_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.action_desc IS 'Action Reason';


--
-- Name: COLUMN hr_attendance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_attendance.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.action IS 'Action';


--
-- Name: COLUMN hr_attendance.worked_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.worked_hours IS 'Worked Hours';


--
-- Name: COLUMN hr_attendance.sheet_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance.sheet_id IS 'Sheet';


--
-- Name: hr_attendance_error; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_attendance_error (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    end_date date NOT NULL,
    max_delay integer NOT NULL,
    write_date timestamp without time zone,
    init_date date NOT NULL,
    write_uid integer
);


--
-- Name: TABLE hr_attendance_error; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_attendance_error IS 'Print Error Attendance Report';


--
-- Name: COLUMN hr_attendance_error.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.create_uid IS 'Created by';


--
-- Name: COLUMN hr_attendance_error.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.create_date IS 'Created on';


--
-- Name: COLUMN hr_attendance_error.end_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.end_date IS 'Ending Date';


--
-- Name: COLUMN hr_attendance_error.max_delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.max_delay IS 'Max. Delay (Min)';


--
-- Name: COLUMN hr_attendance_error.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_attendance_error.init_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.init_date IS 'Starting Date';


--
-- Name: COLUMN hr_attendance_error.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_attendance_error.write_uid IS 'Last Updated by';


--
-- Name: hr_attendance_error_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_attendance_error_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_attendance_error_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_attendance_error_id_seq OWNED BY hr_attendance_error.id;


--
-- Name: hr_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_attendance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_attendance_id_seq OWNED BY hr_attendance.id;


--
-- Name: hr_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_config_settings (
    id integer NOT NULL,
    create_uid integer,
    module_hr_contract boolean,
    module_hr_holidays boolean,
    module_hr_timesheet boolean,
    module_hr_payroll boolean,
    module_hr_timesheet_sheet boolean,
    module_hr_attendance boolean,
    write_uid integer,
    module_hr_evaluation boolean,
    module_hr_expense boolean,
    write_date timestamp without time zone,
    module_hr_gamification boolean,
    create_date timestamp without time zone,
    module_account_analytic_analysis boolean,
    module_hr_recruitment boolean,
    module_document boolean,
    alias_prefix character varying,
    alias_domain character varying,
    group_hr_attendance boolean,
    timesheet_range character varying,
    timesheet_max_difference double precision,
    module_hr_payroll_account boolean
);


--
-- Name: TABLE hr_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_config_settings IS 'hr.config.settings';


--
-- Name: COLUMN hr_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN hr_config_settings.module_hr_contract; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_contract IS 'Record contracts per employee';


--
-- Name: COLUMN hr_config_settings.module_hr_holidays; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_holidays IS 'Manage holidays, leaves and allocation requests';


--
-- Name: COLUMN hr_config_settings.module_hr_timesheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_timesheet IS 'Manage timesheets';


--
-- Name: COLUMN hr_config_settings.module_hr_payroll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_payroll IS 'Manage payroll';


--
-- Name: COLUMN hr_config_settings.module_hr_timesheet_sheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_timesheet_sheet IS 'Allow timesheets validation by managers';


--
-- Name: COLUMN hr_config_settings.module_hr_attendance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_attendance IS 'Install attendances feature';


--
-- Name: COLUMN hr_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_config_settings.module_hr_evaluation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_evaluation IS 'Organize employees periodic evaluation';


--
-- Name: COLUMN hr_config_settings.module_hr_expense; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_expense IS 'Manage employees expenses';


--
-- Name: COLUMN hr_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_config_settings.module_hr_gamification; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_gamification IS 'Drive engagement with challenges and badges';


--
-- Name: COLUMN hr_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN hr_config_settings.module_account_analytic_analysis; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_account_analytic_analysis IS 'Allow invoicing based on timesheets (the sale application will be installed)';


--
-- Name: COLUMN hr_config_settings.module_hr_recruitment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_recruitment IS 'Manage the recruitment process';


--
-- Name: COLUMN hr_config_settings.module_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_document IS 'Allow the automatic indexation of resumes';


--
-- Name: COLUMN hr_config_settings.alias_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.alias_prefix IS 'Default Alias Name for Jobs';


--
-- Name: COLUMN hr_config_settings.alias_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.alias_domain IS 'Alias Domain';


--
-- Name: COLUMN hr_config_settings.group_hr_attendance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.group_hr_attendance IS 'Track attendances for all employees';


--
-- Name: COLUMN hr_config_settings.timesheet_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.timesheet_range IS 'Validate timesheets every';


--
-- Name: COLUMN hr_config_settings.timesheet_max_difference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.timesheet_max_difference IS 'Allow a difference of time between timesheets and attendances of (in hours)';


--
-- Name: COLUMN hr_config_settings.module_hr_payroll_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_config_settings.module_hr_payroll_account IS 'Link your payroll to accounting system';


--
-- Name: hr_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_config_settings_id_seq OWNED BY hr_config_settings.id;


--
-- Name: hr_contract; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_contract (
    id integer NOT NULL,
    visa_expire date,
    create_uid integer,
    employee_id integer NOT NULL,
    working_hours integer,
    job_id integer,
    name character varying NOT NULL,
    type_id integer NOT NULL,
    visa_no character varying,
    date_end date,
    date_start date NOT NULL,
    write_uid integer,
    permit_no character varying,
    advantages text,
    notes text,
    write_date timestamp without time zone,
    wage numeric NOT NULL,
    trial_date_end date,
    create_date timestamp without time zone,
    trial_date_start date,
    schedule_pay character varying,
    struct_id integer,
    coef character varying,
    qualif character varying,
    niveau character varying
);


--
-- Name: TABLE hr_contract; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_contract IS 'Contract';


--
-- Name: COLUMN hr_contract.visa_expire; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.visa_expire IS 'Visa Expire Date';


--
-- Name: COLUMN hr_contract.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.employee_id IS 'Employee';


--
-- Name: COLUMN hr_contract.working_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.working_hours IS 'Working Schedule';


--
-- Name: COLUMN hr_contract.job_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.job_id IS 'Job Title';


--
-- Name: COLUMN hr_contract.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.name IS 'Contract Reference';


--
-- Name: COLUMN hr_contract.type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.type_id IS 'Contract Type';


--
-- Name: COLUMN hr_contract.visa_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_contract.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.date_end IS 'End Date';


--
-- Name: COLUMN hr_contract.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.date_start IS 'Start Date';


--
-- Name: COLUMN hr_contract.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract.permit_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_contract.advantages; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.advantages IS 'Advantages';


--
-- Name: COLUMN hr_contract.notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.notes IS 'Notes';


--
-- Name: COLUMN hr_contract.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_contract.wage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.wage IS 'Wage';


--
-- Name: COLUMN hr_contract.trial_date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.trial_date_end IS 'Trial End Date';


--
-- Name: COLUMN hr_contract.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract.trial_date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.trial_date_start IS 'Trial Start Date';


--
-- Name: COLUMN hr_contract.schedule_pay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.schedule_pay IS 'Scheduled Pay';


--
-- Name: COLUMN hr_contract.struct_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.struct_id IS 'Salary Structure';


--
-- Name: COLUMN hr_contract.coef; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.coef IS 'Coefficient';


--
-- Name: COLUMN hr_contract.qualif; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.qualif IS 'Qualification';


--
-- Name: COLUMN hr_contract.niveau; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract.niveau IS 'Niveau';


--
-- Name: hr_contract_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_contract_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_contract_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_contract_id_seq OWNED BY hr_contract.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_contract_type (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract_type.name IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_contract_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_contract_type_id_seq OWNED BY hr_contract_type.id;


--
-- Name: hr_contribution_register; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_contribution_register (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    note text,
    write_date timestamp without time zone,
    partner_id integer
);


--
-- Name: TABLE hr_contribution_register; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_contribution_register IS 'Contribution Register';


--
-- Name: COLUMN hr_contribution_register.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contribution_register.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.create_date IS 'Created on';


--
-- Name: COLUMN hr_contribution_register.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.name IS 'Name';


--
-- Name: COLUMN hr_contribution_register.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.company_id IS 'Company';


--
-- Name: COLUMN hr_contribution_register.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contribution_register.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.note IS 'Description';


--
-- Name: COLUMN hr_contribution_register.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_contribution_register.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_contribution_register.partner_id IS 'Partner';


--
-- Name: hr_contribution_register_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_contribution_register_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_contribution_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_contribution_register_id_seq OWNED BY hr_contribution_register.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_department (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    note text,
    parent_id integer,
    manager_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_department IS 'hr.department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_department_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_department_id_seq OWNED BY hr_department.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_employee (
    id integer NOT NULL,
    address_id integer,
    create_date timestamp without time zone,
    coach_id integer,
    resource_id integer NOT NULL,
    color integer,
    message_last_post timestamp without time zone,
    image bytea,
    marital character varying,
    identification_id character varying,
    bank_account_id integer,
    job_id integer,
    work_phone character varying,
    country_id integer,
    parent_id integer,
    department_id integer,
    otherid character varying,
    mobile_phone character varying,
    create_uid integer,
    birthday date,
    write_date timestamp without time zone,
    sinid character varying,
    write_uid integer,
    work_email character varying(240),
    work_location character varying,
    image_medium bytea,
    gender character varying,
    ssnid character varying,
    image_small bytea,
    address_home_id integer,
    passport_id character varying,
    name_related character varying,
    notes text,
    evaluation_date date,
    evaluation_plan_id integer,
    uom_id integer,
    journal_id integer,
    product_id integer,
    manager boolean,
    medic_exam date,
    vehicle character varying,
    children integer,
    place_of_birth character varying,
    vehicle_distance integer
);


--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.address_id IS 'Working Address';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_employee.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.image IS 'Photo';


--
-- Name: COLUMN hr_employee.marital; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.marital IS 'Marital Status';


--
-- Name: COLUMN hr_employee.identification_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_employee.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.bank_account_id IS 'Bank Account Number';


--
-- Name: COLUMN hr_employee.job_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.job_id IS 'Job Title';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.country_id IS 'Nationality';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.department_id IS 'Department';


--
-- Name: COLUMN hr_employee.otherid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.otherid IS 'Other Id';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.birthday IS 'Date of Birth';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.sinid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.sinid IS 'SIN No';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.work_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.work_location IS 'Office Location';


--
-- Name: COLUMN hr_employee.image_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.image_medium IS 'Medium-sized photo';


--
-- Name: COLUMN hr_employee.gender; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.gender IS 'Gender';


--
-- Name: COLUMN hr_employee.ssnid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_employee.image_small; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.image_small IS 'Small-sized photo';


--
-- Name: COLUMN hr_employee.address_home_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.address_home_id IS 'Home Address';


--
-- Name: COLUMN hr_employee.passport_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_employee.name_related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.name_related IS 'Name';


--
-- Name: COLUMN hr_employee.notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.notes IS 'Notes';


--
-- Name: COLUMN hr_employee.evaluation_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.evaluation_date IS 'Next Appraisal Date';


--
-- Name: COLUMN hr_employee.evaluation_plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.evaluation_plan_id IS 'Appraisal Plan';


--
-- Name: COLUMN hr_employee.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN hr_employee.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.journal_id IS 'Analytic Journal';


--
-- Name: COLUMN hr_employee.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.product_id IS 'Product';


--
-- Name: COLUMN hr_employee.manager; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.manager IS 'Is a Manager';


--
-- Name: COLUMN hr_employee.medic_exam; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.medic_exam IS 'Medical Examination Date';


--
-- Name: COLUMN hr_employee.vehicle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.vehicle IS 'Company Vehicle';


--
-- Name: COLUMN hr_employee.children; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.children IS 'Number of Children';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.vehicle_distance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee.vehicle_distance IS 'Home-Work Dist.';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_employee_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.name IS 'Employee Tag';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.parent_id IS 'Parent Employee Tag';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_employee_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_employee_category_id_seq OWNED BY hr_employee_category.id;


--
-- Name: hr_employee_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_employee_group_rel (
    payslip_id integer NOT NULL,
    employee_id integer NOT NULL
);


--
-- Name: TABLE hr_employee_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_employee_group_rel IS 'RELATION BETWEEN hr_payslip_employees AND hr_employee';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_employee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_employee_id_seq OWNED BY hr_employee.id;


--
-- Name: hr_evaluation_evaluation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_evaluation_evaluation (
    id integer NOT NULL,
    create_uid integer,
    employee_id integer NOT NULL,
    create_date timestamp without time zone,
    rating character varying,
    date_close date,
    message_last_post timestamp without time zone,
    state character varying NOT NULL,
    write_uid integer,
    note_summary text,
    note_action text,
    write_date timestamp without time zone,
    date date NOT NULL,
    plan_id integer NOT NULL
);


--
-- Name: TABLE hr_evaluation_evaluation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_evaluation_evaluation IS 'Employee Appraisal';


--
-- Name: COLUMN hr_evaluation_evaluation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.create_uid IS 'Created by';


--
-- Name: COLUMN hr_evaluation_evaluation.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.employee_id IS 'Employee';


--
-- Name: COLUMN hr_evaluation_evaluation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.create_date IS 'Created on';


--
-- Name: COLUMN hr_evaluation_evaluation.rating; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.rating IS 'Appreciation';


--
-- Name: COLUMN hr_evaluation_evaluation.date_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.date_close IS 'Ending Date';


--
-- Name: COLUMN hr_evaluation_evaluation.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_evaluation_evaluation.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.state IS 'Status';


--
-- Name: COLUMN hr_evaluation_evaluation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_evaluation_evaluation.note_summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.note_summary IS 'Appraisal Summary';


--
-- Name: COLUMN hr_evaluation_evaluation.note_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.note_action IS 'Action Plan';


--
-- Name: COLUMN hr_evaluation_evaluation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_evaluation_evaluation.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.date IS 'Appraisal Deadline';


--
-- Name: COLUMN hr_evaluation_evaluation.plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_evaluation.plan_id IS 'Plan';


--
-- Name: hr_evaluation_evaluation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_evaluation_evaluation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_evaluation_evaluation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_evaluation_evaluation_id_seq OWNED BY hr_evaluation_evaluation.id;


--
-- Name: hr_evaluation_interview; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_evaluation_interview (
    id integer NOT NULL,
    create_date timestamp without time zone,
    phase_id integer NOT NULL,
    create_uid integer,
    message_last_post timestamp without time zone,
    write_uid integer,
    state character varying NOT NULL,
    evaluation_id integer NOT NULL,
    write_date timestamp without time zone,
    request_id integer,
    user_id integer
);


--
-- Name: TABLE hr_evaluation_interview; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_evaluation_interview IS 'Appraisal Interview';


--
-- Name: COLUMN hr_evaluation_interview.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.create_date IS 'Created on';


--
-- Name: COLUMN hr_evaluation_interview.phase_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.phase_id IS 'Appraisal Phase';


--
-- Name: COLUMN hr_evaluation_interview.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.create_uid IS 'Created by';


--
-- Name: COLUMN hr_evaluation_interview.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_evaluation_interview.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_evaluation_interview.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.state IS 'State';


--
-- Name: COLUMN hr_evaluation_interview.evaluation_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.evaluation_id IS 'Appraisal Plan';


--
-- Name: COLUMN hr_evaluation_interview.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_evaluation_interview.request_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.request_id IS 'Survey Request';


--
-- Name: COLUMN hr_evaluation_interview.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_interview.user_id IS 'Interviewer';


--
-- Name: hr_evaluation_interview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_evaluation_interview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_evaluation_interview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_evaluation_interview_id_seq OWNED BY hr_evaluation_interview.id;


--
-- Name: hr_evaluation_plan; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_evaluation_plan (
    id integer NOT NULL,
    create_uid integer,
    month_next integer,
    name character varying NOT NULL,
    month_first integer,
    company_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    active boolean,
    create_date timestamp without time zone
);


--
-- Name: TABLE hr_evaluation_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_evaluation_plan IS 'Appraisal Plan';


--
-- Name: COLUMN hr_evaluation_plan.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.create_uid IS 'Created by';


--
-- Name: COLUMN hr_evaluation_plan.month_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.month_next IS 'Periodicity of Appraisal (months)';


--
-- Name: COLUMN hr_evaluation_plan.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.name IS 'Appraisal Plan';


--
-- Name: COLUMN hr_evaluation_plan.month_first; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.month_first IS 'First Appraisal in (months)';


--
-- Name: COLUMN hr_evaluation_plan.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.company_id IS 'Company';


--
-- Name: COLUMN hr_evaluation_plan.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_evaluation_plan.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_evaluation_plan.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.active IS 'Active';


--
-- Name: COLUMN hr_evaluation_plan.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan.create_date IS 'Created on';


--
-- Name: hr_evaluation_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_evaluation_plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_evaluation_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_evaluation_plan_id_seq OWNED BY hr_evaluation_plan.id;


--
-- Name: hr_evaluation_plan_phase; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_evaluation_plan_phase (
    id integer NOT NULL,
    create_uid integer,
    plan_id integer,
    name character varying(64) NOT NULL,
    send_anonymous_manager boolean,
    sequence integer,
    company_id integer,
    mail_feature boolean,
    write_uid integer,
    email_subject text,
    write_date timestamp without time zone,
    mail_body text,
    send_anonymous_employee boolean,
    create_date timestamp without time zone,
    send_answer_employee boolean,
    survey_id integer NOT NULL,
    send_answer_manager boolean,
    action character varying NOT NULL,
    wait boolean
);


--
-- Name: TABLE hr_evaluation_plan_phase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_evaluation_plan_phase IS 'Appraisal Plan Phase';


--
-- Name: COLUMN hr_evaluation_plan_phase.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.create_uid IS 'Created by';


--
-- Name: COLUMN hr_evaluation_plan_phase.plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.plan_id IS 'Appraisal Plan';


--
-- Name: COLUMN hr_evaluation_plan_phase.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.name IS 'Phase';


--
-- Name: COLUMN hr_evaluation_plan_phase.send_anonymous_manager; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.send_anonymous_manager IS 'Anonymous Summary';


--
-- Name: COLUMN hr_evaluation_plan_phase.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.sequence IS 'Sequence';


--
-- Name: COLUMN hr_evaluation_plan_phase.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.company_id IS 'Company';


--
-- Name: COLUMN hr_evaluation_plan_phase.mail_feature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.mail_feature IS 'Send mail for this phase';


--
-- Name: COLUMN hr_evaluation_plan_phase.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_evaluation_plan_phase.email_subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.email_subject IS 'Subject';


--
-- Name: COLUMN hr_evaluation_plan_phase.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_evaluation_plan_phase.mail_body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.mail_body IS 'Email';


--
-- Name: COLUMN hr_evaluation_plan_phase.send_anonymous_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.send_anonymous_employee IS 'Anonymous Summary';


--
-- Name: COLUMN hr_evaluation_plan_phase.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.create_date IS 'Created on';


--
-- Name: COLUMN hr_evaluation_plan_phase.send_answer_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.send_answer_employee IS 'All Answers';


--
-- Name: COLUMN hr_evaluation_plan_phase.survey_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.survey_id IS 'Appraisal Form';


--
-- Name: COLUMN hr_evaluation_plan_phase.send_answer_manager; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.send_answer_manager IS 'All Answers';


--
-- Name: COLUMN hr_evaluation_plan_phase.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.action IS 'Action';


--
-- Name: COLUMN hr_evaluation_plan_phase.wait; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_evaluation_plan_phase.wait IS 'Wait Previous Phases';


--
-- Name: hr_evaluation_plan_phase_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_evaluation_plan_phase_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_evaluation_plan_phase_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_evaluation_plan_phase_id_seq OWNED BY hr_evaluation_plan_phase.id;


--
-- Name: hr_evaluation_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_evaluation_report AS
    SELECT min(l.id) AS id, s.create_date, s.employee_id, l.request_id, s.plan_id, s.rating, s.date AS deadline, s.date_close AS closed, count(l.*) AS nbr, s.state, (avg(date_part('epoch'::text, age(s.create_date, (('now'::text)::date)::timestamp without time zone))) / ((3600 * 24))::double precision) AS delay_date, (avg(date_part('epoch'::text, age((s.date)::timestamp with time zone, (('now'::text)::date)::timestamp with time zone))) / ((3600 * 24))::double precision) AS overpass_delay FROM (hr_evaluation_interview l LEFT JOIN hr_evaluation_evaluation s ON ((s.id = l.evaluation_id))) GROUP BY s.create_date, s.state, s.employee_id, s.date, s.date_close, l.request_id, s.rating, s.plan_id;


--
-- Name: hr_expense_expense; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_expense_expense (
    id integer NOT NULL,
    create_date timestamp without time zone,
    company_id integer NOT NULL,
    write_uid integer,
    currency_id integer NOT NULL,
    date_valid date,
    create_uid integer,
    employee_id integer NOT NULL,
    user_id integer NOT NULL,
    message_last_post timestamp without time zone,
    journal_id integer,
    note text,
    state character varying,
    user_valid integer,
    department_id integer,
    write_date timestamp without time zone,
    date date,
    date_confirm date,
    account_move_id integer,
    name character varying NOT NULL,
    amount numeric
);


--
-- Name: TABLE hr_expense_expense; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_expense_expense IS 'Expense';


--
-- Name: COLUMN hr_expense_expense.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.create_date IS 'Created on';


--
-- Name: COLUMN hr_expense_expense.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.company_id IS 'Company';


--
-- Name: COLUMN hr_expense_expense.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_expense_expense.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.currency_id IS 'Currency';


--
-- Name: COLUMN hr_expense_expense.date_valid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.date_valid IS 'Validation Date';


--
-- Name: COLUMN hr_expense_expense.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.create_uid IS 'Created by';


--
-- Name: COLUMN hr_expense_expense.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.employee_id IS 'Employee';


--
-- Name: COLUMN hr_expense_expense.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.user_id IS 'User';


--
-- Name: COLUMN hr_expense_expense.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_expense_expense.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.journal_id IS 'Force Journal';


--
-- Name: COLUMN hr_expense_expense.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.note IS 'Note';


--
-- Name: COLUMN hr_expense_expense.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.state IS 'Status';


--
-- Name: COLUMN hr_expense_expense.user_valid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.user_valid IS 'Validation By';


--
-- Name: COLUMN hr_expense_expense.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.department_id IS 'Department';


--
-- Name: COLUMN hr_expense_expense.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_expense_expense.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.date IS 'Date';


--
-- Name: COLUMN hr_expense_expense.date_confirm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.date_confirm IS 'Confirmation Date';


--
-- Name: COLUMN hr_expense_expense.account_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.account_move_id IS 'Ledger Posting';


--
-- Name: COLUMN hr_expense_expense.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.name IS 'Description';


--
-- Name: COLUMN hr_expense_expense.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_expense.amount IS 'Total Amount';


--
-- Name: hr_expense_expense_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_expense_expense_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_expense_expense_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_expense_expense_id_seq OWNED BY hr_expense_expense.id;


--
-- Name: hr_expense_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_expense_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    product_id integer,
    name character varying NOT NULL,
    sequence integer,
    description text,
    write_uid integer,
    date_value date NOT NULL,
    uom_id integer NOT NULL,
    expense_id integer,
    write_date timestamp without time zone,
    unit_amount numeric,
    unit_quantity numeric,
    ref character varying,
    analytic_account integer
);


--
-- Name: TABLE hr_expense_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_expense_line IS 'Expense Line';


--
-- Name: COLUMN hr_expense_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_expense_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_expense_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.product_id IS 'Product';


--
-- Name: COLUMN hr_expense_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.name IS 'Expense Note';


--
-- Name: COLUMN hr_expense_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.sequence IS 'Sequence';


--
-- Name: COLUMN hr_expense_line.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.description IS 'Description';


--
-- Name: COLUMN hr_expense_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_expense_line.date_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.date_value IS 'Date';


--
-- Name: COLUMN hr_expense_line.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN hr_expense_line.expense_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.expense_id IS 'Expense';


--
-- Name: COLUMN hr_expense_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_expense_line.unit_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.unit_amount IS 'Unit Price';


--
-- Name: COLUMN hr_expense_line.unit_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.unit_quantity IS 'Quantities';


--
-- Name: COLUMN hr_expense_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.ref IS 'Reference';


--
-- Name: COLUMN hr_expense_line.analytic_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_expense_line.analytic_account IS 'Analytic account';


--
-- Name: hr_expense_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_expense_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_expense_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_expense_line_id_seq OWNED BY hr_expense_line.id;


--
-- Name: hr_expense_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_expense_report AS
    SELECT min(l.id) AS id, s.date, s.create_date, s.employee_id, s.journal_id, s.currency_id, s.date_confirm, s.date_valid, s.user_valid AS user_id, s.department_id, (avg(date_part('epoch'::text, age((s.date_valid)::timestamp with time zone, (s.date)::timestamp with time zone))) / ((3600 * 24))::double precision) AS delay_valid, (avg(date_part('epoch'::text, age((s.date_valid)::timestamp with time zone, (s.date_confirm)::timestamp with time zone))) / ((3600 * 24))::double precision) AS delay_confirm, l.product_id, l.analytic_account, sum((l.unit_quantity * u.factor)) AS product_qty, s.company_id, sum((l.unit_quantity * l.unit_amount)) AS price_total, ((sum((l.unit_quantity * l.unit_amount)) / sum(CASE WHEN ((l.unit_quantity = (0)::numeric) OR (u.factor = (0)::numeric)) THEN (1)::numeric ELSE (l.unit_quantity * u.factor) END)))::numeric(16,2) AS price_average, count(*) AS nbr, (SELECT hr_expense_line.unit_quantity FROM hr_expense_line WHERE ((hr_expense_line.id = l.id) AND (hr_expense_line.product_id IS NOT NULL))) AS no_of_products, (SELECT hr_expense_line.analytic_account FROM hr_expense_line WHERE ((hr_expense_line.id = l.id) AND (hr_expense_line.analytic_account IS NOT NULL))) AS no_of_account, s.state FROM ((hr_expense_line l LEFT JOIN hr_expense_expense s ON ((s.id = l.expense_id))) LEFT JOIN product_uom u ON ((u.id = l.uom_id))) GROUP BY s.date, s.create_date, s.date_confirm, s.date_valid, l.product_id, l.analytic_account, s.currency_id, s.user_valid, s.department_id, l.uom_id, l.id, s.state, s.journal_id, s.company_id, s.employee_id;


--
-- Name: hr_holidays; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_holidays (
    id integer NOT NULL,
    create_date timestamp without time zone,
    meeting_id integer,
    write_uid integer,
    holiday_status_id integer NOT NULL,
    create_uid integer,
    employee_id integer,
    user_id integer,
    number_of_days_temp double precision,
    date_from timestamp without time zone,
    message_last_post timestamp without time zone,
    holiday_type character varying NOT NULL,
    parent_id integer,
    state character varying,
    manager_id integer,
    type character varying NOT NULL,
    department_id integer,
    manager_id2 integer,
    write_date timestamp without time zone,
    date_to timestamp without time zone,
    category_id integer,
    number_of_days numeric,
    name character varying(64),
    notes text,
    CONSTRAINT hr_holidays_date_check CHECK ((number_of_days_temp >= (0)::double precision)),
    CONSTRAINT hr_holidays_date_check2 CHECK ((((type)::text = 'add'::text) OR (date_from <= date_to))),
    CONSTRAINT hr_holidays_type_value CHECK (((((holiday_type)::text = 'employee'::text) AND (employee_id IS NOT NULL)) OR (((holiday_type)::text = 'category'::text) AND (category_id IS NOT NULL))))
);


--
-- Name: TABLE hr_holidays; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_holidays IS 'Leave';


--
-- Name: COLUMN hr_holidays.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays.meeting_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.meeting_id IS 'Meeting';


--
-- Name: COLUMN hr_holidays.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays.holiday_status_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.holiday_status_id IS 'Leave Type';


--
-- Name: COLUMN hr_holidays.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.employee_id IS 'Employee';


--
-- Name: COLUMN hr_holidays.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.user_id IS 'User';


--
-- Name: COLUMN hr_holidays.number_of_days_temp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.number_of_days_temp IS 'Allocation';


--
-- Name: COLUMN hr_holidays.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.date_from IS 'Start Date';


--
-- Name: COLUMN hr_holidays.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_holidays.holiday_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.holiday_type IS 'Allocation Mode';


--
-- Name: COLUMN hr_holidays.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.parent_id IS 'Parent';


--
-- Name: COLUMN hr_holidays.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.state IS 'Status';


--
-- Name: COLUMN hr_holidays.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.manager_id IS 'First Approval';


--
-- Name: COLUMN hr_holidays.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.type IS 'Request Type';


--
-- Name: COLUMN hr_holidays.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.department_id IS 'Department';


--
-- Name: COLUMN hr_holidays.manager_id2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.manager_id2 IS 'Second Approval';


--
-- Name: COLUMN hr_holidays.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_holidays.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.date_to IS 'End Date';


--
-- Name: COLUMN hr_holidays.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.category_id IS 'Employee Tag';


--
-- Name: COLUMN hr_holidays.number_of_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.number_of_days IS 'Number of Days';


--
-- Name: COLUMN hr_holidays.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.name IS 'Description';


--
-- Name: COLUMN hr_holidays.notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays.notes IS 'Reasons';


--
-- Name: hr_holidays_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_holidays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_holidays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_holidays_id_seq OWNED BY hr_holidays.id;


--
-- Name: hr_holidays_status; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_holidays_status (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying(64) NOT NULL,
    double_validation boolean,
    write_uid integer,
    color_name character varying NOT NULL,
    "limit" boolean,
    write_date timestamp without time zone,
    active boolean,
    categ_id integer
);


--
-- Name: TABLE hr_holidays_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_holidays_status IS 'Leave Type';


--
-- Name: COLUMN hr_holidays_status.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_status.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_status.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.name IS 'Leave Type';


--
-- Name: COLUMN hr_holidays_status.double_validation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.double_validation IS 'Apply Double Validation';


--
-- Name: COLUMN hr_holidays_status.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays_status.color_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.color_name IS 'Color in Report';


--
-- Name: COLUMN hr_holidays_status."limit"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status."limit" IS 'Allow to Override Limit';


--
-- Name: COLUMN hr_holidays_status.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_holidays_status.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.active IS 'Active';


--
-- Name: COLUMN hr_holidays_status.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_status.categ_id IS 'Meeting Type';


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE resource_resource (
    id integer NOT NULL,
    create_uid integer,
    time_efficiency double precision NOT NULL,
    code character varying(16),
    user_id integer,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    write_date timestamp without time zone,
    calendar_id integer,
    active boolean,
    create_date timestamp without time zone,
    resource_type character varying NOT NULL
);


--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE resource_resource IS 'Resource Detail';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: COLUMN resource_resource.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.code IS 'Code';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_resource.resource_type IS 'Resource Type';


--
-- Name: hr_holidays_remaining_leaves_user; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_holidays_remaining_leaves_user AS
    SELECT min(hrs.id) AS id, rr.name, sum(hrs.number_of_days) AS no_of_leaves, rr.user_id, hhs.name AS leave_type FROM hr_holidays hrs, hr_employee hre, resource_resource rr, hr_holidays_status hhs WHERE (((hrs.employee_id = hre.id) AND (hre.resource_id = rr.id)) AND (hhs.id = hrs.holiday_status_id)) GROUP BY rr.name, rr.user_id, hhs.name;


--
-- Name: hr_holidays_status_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_holidays_status_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_holidays_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_holidays_status_id_seq OWNED BY hr_holidays_status.id;


--
-- Name: hr_holidays_summary_dept; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_holidays_summary_dept (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    date_from date NOT NULL,
    holiday_type character varying NOT NULL,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE hr_holidays_summary_dept; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_holidays_summary_dept IS 'HR Leaves Summary Report By Department';


--
-- Name: COLUMN hr_holidays_summary_dept.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_summary_dept.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_summary_dept.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.date_from IS 'From';


--
-- Name: COLUMN hr_holidays_summary_dept.holiday_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.holiday_type IS 'Leave Type';


--
-- Name: COLUMN hr_holidays_summary_dept.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_holidays_summary_dept.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_dept.write_uid IS 'Last Updated by';


--
-- Name: hr_holidays_summary_dept_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_holidays_summary_dept_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_holidays_summary_dept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_holidays_summary_dept_id_seq OWNED BY hr_holidays_summary_dept.id;


--
-- Name: hr_holidays_summary_employee; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_holidays_summary_employee (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    date_from date NOT NULL,
    holiday_type character varying NOT NULL,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE hr_holidays_summary_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_holidays_summary_employee IS 'HR Leaves Summary Report By Employee';


--
-- Name: COLUMN hr_holidays_summary_employee.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_summary_employee.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_summary_employee.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.date_from IS 'From';


--
-- Name: COLUMN hr_holidays_summary_employee.holiday_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.holiday_type IS 'Select Leave Type';


--
-- Name: COLUMN hr_holidays_summary_employee.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_holidays_summary_employee.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_holidays_summary_employee.write_uid IS 'Last Updated by';


--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_holidays_summary_employee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_holidays_summary_employee_id_seq OWNED BY hr_holidays_summary_employee.id;


--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_job (
    id integer NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    create_uid integer,
    requirements text,
    message_last_post timestamp without time zone,
    company_id integer,
    state character varying NOT NULL,
    expected_employees integer,
    department_id integer,
    description text,
    write_date timestamp without time zone,
    name character varying NOT NULL,
    no_of_recruitment integer,
    no_of_hired_employee integer,
    no_of_employee integer,
    address_id integer,
    color integer,
    alias_id integer NOT NULL,
    manager_id integer,
    user_id integer,
    survey_id integer,
    CONSTRAINT hr_job_hired_employee_check CHECK ((no_of_hired_employee <= no_of_recruitment))
);


--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.state IS 'Status';


--
-- Name: COLUMN hr_job.expected_employees; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.expected_employees IS 'Total Forecasted Employees';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.write_date IS 'Update Date';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.name IS 'Job Name';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.no_of_recruitment IS 'Expected New Employees';


--
-- Name: COLUMN hr_job.no_of_hired_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.no_of_hired_employee IS 'Hired Employees';


--
-- Name: COLUMN hr_job.no_of_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.no_of_employee IS 'Current Number of Employees';


--
-- Name: COLUMN hr_job.address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.address_id IS 'Job Location';


--
-- Name: COLUMN hr_job.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.color IS 'Color Index';


--
-- Name: COLUMN hr_job.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.alias_id IS 'Alias';


--
-- Name: COLUMN hr_job.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.manager_id IS 'Department Manager';


--
-- Name: COLUMN hr_job.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.user_id IS 'Recruitment Responsible';


--
-- Name: COLUMN hr_job.survey_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_job.survey_id IS 'Interview Form';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_job_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_job_id_seq OWNED BY hr_job.id;


--
-- Name: hr_payroll_structure; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payroll_structure (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer NOT NULL,
    write_uid integer,
    note text,
    parent_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_payroll_structure; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payroll_structure IS 'Salary Structure';


--
-- Name: COLUMN hr_payroll_structure.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payroll_structure.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.code IS 'Reference';


--
-- Name: COLUMN hr_payroll_structure.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.create_date IS 'Created on';


--
-- Name: COLUMN hr_payroll_structure.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.name IS 'Name';


--
-- Name: COLUMN hr_payroll_structure.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.company_id IS 'Company';


--
-- Name: COLUMN hr_payroll_structure.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payroll_structure.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.note IS 'Description';


--
-- Name: COLUMN hr_payroll_structure.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.parent_id IS 'Parent';


--
-- Name: COLUMN hr_payroll_structure.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payroll_structure.write_date IS 'Last Updated on';


--
-- Name: hr_payroll_structure_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payroll_structure_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payroll_structure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payroll_structure_id_seq OWNED BY hr_payroll_structure.id;


--
-- Name: hr_payslip; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip (
    id integer NOT NULL,
    create_date timestamp without time zone,
    payslip_run_id integer,
    struct_id integer,
    number character varying,
    write_uid integer,
    create_uid integer,
    employee_id integer NOT NULL,
    contract_id integer,
    date_from date NOT NULL,
    company_id integer,
    note text,
    state character varying,
    credit_note boolean,
    paid boolean,
    write_date timestamp without time zone,
    date_to date NOT NULL,
    name character varying,
    payment_mode character varying
);


--
-- Name: TABLE hr_payslip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip IS 'Pay Slip';


--
-- Name: COLUMN hr_payslip.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip.payslip_run_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.payslip_run_id IS 'Payslip Batches';


--
-- Name: COLUMN hr_payslip.struct_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.struct_id IS 'Structure';


--
-- Name: COLUMN hr_payslip.number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.number IS 'Reference';


--
-- Name: COLUMN hr_payslip.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.employee_id IS 'Employee';


--
-- Name: COLUMN hr_payslip.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.contract_id IS 'Contract';


--
-- Name: COLUMN hr_payslip.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.date_from IS 'Date From';


--
-- Name: COLUMN hr_payslip.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.company_id IS 'Company';


--
-- Name: COLUMN hr_payslip.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.note IS 'Internal Note';


--
-- Name: COLUMN hr_payslip.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.state IS 'Status';


--
-- Name: COLUMN hr_payslip.credit_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.credit_note IS 'Credit Note';


--
-- Name: COLUMN hr_payslip.paid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.paid IS 'Made Payment Order ? ';


--
-- Name: COLUMN hr_payslip.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_payslip.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.date_to IS 'Date To';


--
-- Name: COLUMN hr_payslip.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.name IS 'Payslip Name';


--
-- Name: COLUMN hr_payslip.payment_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip.payment_mode IS 'Mode de paiement';


--
-- Name: hr_payslip_employees; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip_employees (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_payslip_employees; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip_employees IS 'Generate payslips for all selected employees';


--
-- Name: COLUMN hr_payslip_employees.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_employees.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip_employees.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_employees.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip_employees.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_employees.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip_employees.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_employees.write_date IS 'Last Updated on';


--
-- Name: hr_payslip_employees_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_employees_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_employees_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_employees_id_seq OWNED BY hr_payslip_employees.id;


--
-- Name: hr_payslip_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_id_seq OWNED BY hr_payslip.id;


--
-- Name: hr_payslip_input; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip_input (
    id integer NOT NULL,
    create_uid integer,
    code character varying(52) NOT NULL,
    create_date timestamp without time zone,
    contract_id integer NOT NULL,
    sequence integer NOT NULL,
    write_uid integer,
    amount double precision,
    write_date timestamp without time zone,
    payslip_id integer NOT NULL,
    name character varying NOT NULL
);


--
-- Name: TABLE hr_payslip_input; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip_input IS 'Payslip Input';


--
-- Name: COLUMN hr_payslip_input.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip_input.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.code IS 'Code';


--
-- Name: COLUMN hr_payslip_input.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip_input.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.contract_id IS 'Contract';


--
-- Name: COLUMN hr_payslip_input.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.sequence IS 'Sequence';


--
-- Name: COLUMN hr_payslip_input.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip_input.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.amount IS 'Amount';


--
-- Name: COLUMN hr_payslip_input.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_payslip_input.payslip_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.payslip_id IS 'Pay Slip';


--
-- Name: COLUMN hr_payslip_input.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_input.name IS 'Description';


--
-- Name: hr_payslip_input_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_input_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_input_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_input_id_seq OWNED BY hr_payslip_input.id;


--
-- Name: hr_payslip_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip_line (
    id integer NOT NULL,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    amount_select character varying NOT NULL,
    sequence integer NOT NULL,
    write_uid integer,
    rate numeric,
    appears_on_payslip boolean,
    condition_range character varying,
    total numeric,
    amount_fix numeric,
    create_uid integer,
    employee_id integer NOT NULL,
    contract_id integer NOT NULL,
    company_id integer,
    note text,
    amount_percentage numeric,
    condition_range_min double precision,
    condition_select character varying NOT NULL,
    amount_percentage_base character varying,
    register_id integer,
    slip_id integer NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    condition_range_max double precision,
    parent_rule_id integer,
    category_id integer NOT NULL,
    name character varying NOT NULL,
    condition_python text NOT NULL,
    amount_python_compute text,
    amount numeric,
    salary_rule_id integer NOT NULL,
    quantity numeric
);


--
-- Name: TABLE hr_payslip_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip_line IS 'Payslip Line';


--
-- Name: COLUMN hr_payslip_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.code IS 'Code';


--
-- Name: COLUMN hr_payslip_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip_line.amount_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount_select IS 'Amount Type';


--
-- Name: COLUMN hr_payslip_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.sequence IS 'Sequence';


--
-- Name: COLUMN hr_payslip_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip_line.rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.rate IS 'Rate (%)';


--
-- Name: COLUMN hr_payslip_line.appears_on_payslip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.appears_on_payslip IS 'Appears on Payslip';


--
-- Name: COLUMN hr_payslip_line.condition_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.condition_range IS 'Range Based on';


--
-- Name: COLUMN hr_payslip_line.total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.total IS 'Total';


--
-- Name: COLUMN hr_payslip_line.amount_fix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount_fix IS 'Fixed Amount';


--
-- Name: COLUMN hr_payslip_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip_line.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.employee_id IS 'Employee';


--
-- Name: COLUMN hr_payslip_line.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.contract_id IS 'Contract';


--
-- Name: COLUMN hr_payslip_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.company_id IS 'Company';


--
-- Name: COLUMN hr_payslip_line.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.note IS 'Description';


--
-- Name: COLUMN hr_payslip_line.amount_percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount_percentage IS 'Percentage (%)';


--
-- Name: COLUMN hr_payslip_line.condition_range_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.condition_range_min IS 'Minimum Range';


--
-- Name: COLUMN hr_payslip_line.condition_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.condition_select IS 'Condition Based on';


--
-- Name: COLUMN hr_payslip_line.amount_percentage_base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount_percentage_base IS 'Percentage based on';


--
-- Name: COLUMN hr_payslip_line.register_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.register_id IS 'Contribution Register';


--
-- Name: COLUMN hr_payslip_line.slip_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.slip_id IS 'Pay Slip';


--
-- Name: COLUMN hr_payslip_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_payslip_line.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.active IS 'Active';


--
-- Name: COLUMN hr_payslip_line.condition_range_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.condition_range_max IS 'Maximum Range';


--
-- Name: COLUMN hr_payslip_line.parent_rule_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.parent_rule_id IS 'Parent Salary Rule';


--
-- Name: COLUMN hr_payslip_line.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.category_id IS 'Category';


--
-- Name: COLUMN hr_payslip_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.name IS 'Name';


--
-- Name: COLUMN hr_payslip_line.condition_python; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.condition_python IS 'Python Condition';


--
-- Name: COLUMN hr_payslip_line.amount_python_compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount_python_compute IS 'Python Code';


--
-- Name: COLUMN hr_payslip_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.amount IS 'Amount';


--
-- Name: COLUMN hr_payslip_line.salary_rule_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.salary_rule_id IS 'Rule';


--
-- Name: COLUMN hr_payslip_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_line.quantity IS 'Quantity';


--
-- Name: hr_payslip_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_line_id_seq OWNED BY hr_payslip_line.id;


--
-- Name: hr_payslip_run; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip_run (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    credit_note boolean,
    date_end date NOT NULL,
    date_start date NOT NULL,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone,
    name character varying NOT NULL
);


--
-- Name: TABLE hr_payslip_run; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip_run IS 'Payslip Batches';


--
-- Name: COLUMN hr_payslip_run.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip_run.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip_run.credit_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.credit_note IS 'Credit Note';


--
-- Name: COLUMN hr_payslip_run.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.date_end IS 'Date To';


--
-- Name: COLUMN hr_payslip_run.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.date_start IS 'Date From';


--
-- Name: COLUMN hr_payslip_run.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip_run.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.state IS 'Status';


--
-- Name: COLUMN hr_payslip_run.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_payslip_run.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_run.name IS 'Name';


--
-- Name: hr_payslip_run_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_run_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_run_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_run_id_seq OWNED BY hr_payslip_run.id;


--
-- Name: hr_payslip_worked_days; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_payslip_worked_days (
    id integer NOT NULL,
    create_uid integer,
    code character varying(52) NOT NULL,
    create_date timestamp without time zone,
    contract_id integer NOT NULL,
    sequence integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    payslip_id integer NOT NULL,
    number_of_days double precision,
    number_of_hours double precision,
    name character varying NOT NULL
);


--
-- Name: TABLE hr_payslip_worked_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_payslip_worked_days IS 'Payslip Worked Days';


--
-- Name: COLUMN hr_payslip_worked_days.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payslip_worked_days.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.code IS 'Code';


--
-- Name: COLUMN hr_payslip_worked_days.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.create_date IS 'Created on';


--
-- Name: COLUMN hr_payslip_worked_days.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.contract_id IS 'Contract';


--
-- Name: COLUMN hr_payslip_worked_days.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.sequence IS 'Sequence';


--
-- Name: COLUMN hr_payslip_worked_days.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payslip_worked_days.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_payslip_worked_days.payslip_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.payslip_id IS 'Pay Slip';


--
-- Name: COLUMN hr_payslip_worked_days.number_of_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.number_of_days IS 'Number of Days';


--
-- Name: COLUMN hr_payslip_worked_days.number_of_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.number_of_hours IS 'Number of Hours';


--
-- Name: COLUMN hr_payslip_worked_days.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_payslip_worked_days.name IS 'Description';


--
-- Name: hr_payslip_worked_days_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_payslip_worked_days_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_payslip_worked_days_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_payslip_worked_days_id_seq OWNED BY hr_payslip_worked_days.id;


--
-- Name: hr_recruitment_degree; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_recruitment_degree (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_recruitment_degree; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_recruitment_degree IS 'Degree of Recruitment';


--
-- Name: COLUMN hr_recruitment_degree.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.create_uid IS 'Created by';


--
-- Name: COLUMN hr_recruitment_degree.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.create_date IS 'Created on';


--
-- Name: COLUMN hr_recruitment_degree.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.name IS 'Name';


--
-- Name: COLUMN hr_recruitment_degree.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.sequence IS 'Sequence';


--
-- Name: COLUMN hr_recruitment_degree.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_recruitment_degree.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_degree.write_date IS 'Last Updated on';


--
-- Name: hr_recruitment_degree_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_recruitment_degree_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_recruitment_degree_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_recruitment_degree_id_seq OWNED BY hr_recruitment_degree.id;


--
-- Name: hr_recruitment_partner_create; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_recruitment_partner_create (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    close boolean
);


--
-- Name: TABLE hr_recruitment_partner_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_recruitment_partner_create IS 'Create Partner from job application';


--
-- Name: COLUMN hr_recruitment_partner_create.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_partner_create.create_uid IS 'Created by';


--
-- Name: COLUMN hr_recruitment_partner_create.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_partner_create.create_date IS 'Created on';


--
-- Name: COLUMN hr_recruitment_partner_create.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_partner_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_recruitment_partner_create.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_partner_create.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_recruitment_partner_create.close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_partner_create.close IS 'Close job request';


--
-- Name: hr_recruitment_partner_create_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_recruitment_partner_create_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_recruitment_partner_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_recruitment_partner_create_id_seq OWNED BY hr_recruitment_partner_create.id;


--
-- Name: hr_recruitment_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_recruitment_report AS
    SELECT min(s.id) AS id, s.create_date AS date_create, date(s.date_closed) AS date_closed, s.date_last_stage_update, s.partner_id, s.company_id, s.user_id, s.job_id, s.type_id, sum(s.availability) AS available, s.department_id, s.priority, s.stage_id, s.last_stage_id, sum(s.salary_proposed) AS salary_prop, (sum(s.salary_proposed) / (count(*))::double precision) AS salary_prop_avg, sum(s.salary_expected) AS salary_exp, (sum(s.salary_expected) / (count(*))::double precision) AS salary_exp_avg, (date_part('epoch'::text, (s.write_date - s.create_date)) / ((3600 * 24))::double precision) AS delay_close, count(*) AS nbr FROM hr_applicant s GROUP BY s.date_open, s.create_date, s.write_date, s.date_closed, s.date_last_stage_update, s.partner_id, s.company_id, s.user_id, s.stage_id, s.last_stage_id, s.type_id, s.priority, s.job_id, s.department_id;


--
-- Name: hr_recruitment_source; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_recruitment_source (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_recruitment_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_recruitment_source IS 'Source of Applicants';


--
-- Name: COLUMN hr_recruitment_source.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_source.create_uid IS 'Created by';


--
-- Name: COLUMN hr_recruitment_source.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_source.create_date IS 'Created on';


--
-- Name: COLUMN hr_recruitment_source.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_source.name IS 'Source Name';


--
-- Name: COLUMN hr_recruitment_source.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_recruitment_source.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_source.write_date IS 'Last Updated on';


--
-- Name: hr_recruitment_source_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_recruitment_source_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_recruitment_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_recruitment_source_id_seq OWNED BY hr_recruitment_source.id;


--
-- Name: hr_recruitment_stage; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_recruitment_stage (
    id integer NOT NULL,
    create_uid integer,
    requirements text,
    name character varying NOT NULL,
    sequence integer,
    write_uid integer,
    fold boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    template_id integer,
    department_id integer
);


--
-- Name: TABLE hr_recruitment_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_recruitment_stage IS 'Stage of Recruitment';


--
-- Name: COLUMN hr_recruitment_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.create_uid IS 'Created by';


--
-- Name: COLUMN hr_recruitment_stage.requirements; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.requirements IS 'Requirements';


--
-- Name: COLUMN hr_recruitment_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.name IS 'Name';


--
-- Name: COLUMN hr_recruitment_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.sequence IS 'Sequence';


--
-- Name: COLUMN hr_recruitment_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_recruitment_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.fold IS 'Folded in Kanban View';


--
-- Name: COLUMN hr_recruitment_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_recruitment_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.create_date IS 'Created on';


--
-- Name: COLUMN hr_recruitment_stage.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.template_id IS 'Use template';


--
-- Name: COLUMN hr_recruitment_stage.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_recruitment_stage.department_id IS 'Specific to a Department';


--
-- Name: hr_recruitment_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_recruitment_stage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_recruitment_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_recruitment_stage_id_seq OWNED BY hr_recruitment_stage.id;


--
-- Name: hr_rule_input; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_rule_input (
    id integer NOT NULL,
    create_uid integer,
    code character varying(52) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    input_id integer NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_rule_input; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_rule_input IS 'Salary Rule Input';


--
-- Name: COLUMN hr_rule_input.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.create_uid IS 'Created by';


--
-- Name: COLUMN hr_rule_input.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.code IS 'Code';


--
-- Name: COLUMN hr_rule_input.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.create_date IS 'Created on';


--
-- Name: COLUMN hr_rule_input.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.name IS 'Description';


--
-- Name: COLUMN hr_rule_input.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_rule_input.input_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.input_id IS 'Salary Rule Input';


--
-- Name: COLUMN hr_rule_input.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_rule_input.write_date IS 'Last Updated on';


--
-- Name: hr_rule_input_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_rule_input_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_rule_input_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_rule_input_id_seq OWNED BY hr_rule_input.id;


--
-- Name: hr_salary_rule; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_salary_rule (
    id integer NOT NULL,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sequence integer NOT NULL,
    write_uid integer,
    appears_on_payslip boolean,
    condition_range character varying,
    amount_fix numeric,
    create_uid integer,
    parent_rule_id integer,
    company_id integer,
    note text,
    amount_percentage numeric,
    condition_range_min double precision,
    condition_select character varying NOT NULL,
    amount_percentage_base character varying,
    register_id integer,
    amount_select character varying NOT NULL,
    active boolean,
    condition_range_max double precision,
    name character varying NOT NULL,
    condition_python text NOT NULL,
    amount_python_compute text,
    category_id integer NOT NULL,
    quantity character varying
);


--
-- Name: TABLE hr_salary_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_salary_rule IS 'hr.salary.rule';


--
-- Name: COLUMN hr_salary_rule.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.code IS 'Code';


--
-- Name: COLUMN hr_salary_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.create_date IS 'Created on';


--
-- Name: COLUMN hr_salary_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_salary_rule.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.sequence IS 'Sequence';


--
-- Name: COLUMN hr_salary_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_salary_rule.appears_on_payslip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.appears_on_payslip IS 'Appears on Payslip';


--
-- Name: COLUMN hr_salary_rule.condition_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.condition_range IS 'Range Based on';


--
-- Name: COLUMN hr_salary_rule.amount_fix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.amount_fix IS 'Fixed Amount';


--
-- Name: COLUMN hr_salary_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.create_uid IS 'Created by';


--
-- Name: COLUMN hr_salary_rule.parent_rule_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.parent_rule_id IS 'Parent Salary Rule';


--
-- Name: COLUMN hr_salary_rule.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.company_id IS 'Company';


--
-- Name: COLUMN hr_salary_rule.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.note IS 'Description';


--
-- Name: COLUMN hr_salary_rule.amount_percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.amount_percentage IS 'Percentage (%)';


--
-- Name: COLUMN hr_salary_rule.condition_range_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.condition_range_min IS 'Minimum Range';


--
-- Name: COLUMN hr_salary_rule.condition_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.condition_select IS 'Condition Based on';


--
-- Name: COLUMN hr_salary_rule.amount_percentage_base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.amount_percentage_base IS 'Percentage based on';


--
-- Name: COLUMN hr_salary_rule.register_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.register_id IS 'Contribution Register';


--
-- Name: COLUMN hr_salary_rule.amount_select; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.amount_select IS 'Amount Type';


--
-- Name: COLUMN hr_salary_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.active IS 'Active';


--
-- Name: COLUMN hr_salary_rule.condition_range_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.condition_range_max IS 'Maximum Range';


--
-- Name: COLUMN hr_salary_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.name IS 'Name';


--
-- Name: COLUMN hr_salary_rule.condition_python; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.condition_python IS 'Python Condition';


--
-- Name: COLUMN hr_salary_rule.amount_python_compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.amount_python_compute IS 'Python Code';


--
-- Name: COLUMN hr_salary_rule.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.category_id IS 'Category';


--
-- Name: COLUMN hr_salary_rule.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule.quantity IS 'Quantity';


--
-- Name: hr_salary_rule_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_salary_rule_category (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    note text,
    parent_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_salary_rule_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_salary_rule_category IS 'Salary Rule Category';


--
-- Name: COLUMN hr_salary_rule_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_salary_rule_category.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.code IS 'Code';


--
-- Name: COLUMN hr_salary_rule_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_salary_rule_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.name IS 'Name';


--
-- Name: COLUMN hr_salary_rule_category.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.company_id IS 'Company';


--
-- Name: COLUMN hr_salary_rule_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_salary_rule_category.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.note IS 'Description';


--
-- Name: COLUMN hr_salary_rule_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.parent_id IS 'Parent';


--
-- Name: COLUMN hr_salary_rule_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_salary_rule_category.write_date IS 'Last Updated on';


--
-- Name: hr_salary_rule_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_salary_rule_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_salary_rule_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_salary_rule_category_id_seq OWNED BY hr_salary_rule_category.id;


--
-- Name: hr_salary_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_salary_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_salary_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_salary_rule_id_seq OWNED BY hr_salary_rule.id;


--
-- Name: hr_sign_in_project; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_sign_in_project (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    write_uid integer,
    date timestamp without time zone,
    server_date timestamp without time zone,
    write_date timestamp without time zone,
    emp_id integer
);


--
-- Name: TABLE hr_sign_in_project; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_sign_in_project IS 'Sign In By Project';


--
-- Name: COLUMN hr_sign_in_project.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.create_uid IS 'Created by';


--
-- Name: COLUMN hr_sign_in_project.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.create_date IS 'Created on';


--
-- Name: COLUMN hr_sign_in_project.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.name IS 'Employee''s Name';


--
-- Name: COLUMN hr_sign_in_project.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_sign_in_project.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.date IS 'Starting Date';


--
-- Name: COLUMN hr_sign_in_project.server_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.server_date IS 'Current Date';


--
-- Name: COLUMN hr_sign_in_project.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_sign_in_project.emp_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_in_project.emp_id IS 'Employee ID';


--
-- Name: hr_sign_in_project_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_sign_in_project_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_sign_in_project_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_sign_in_project_id_seq OWNED BY hr_sign_in_project.id;


--
-- Name: hr_sign_out_project; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_sign_out_project (
    id integer NOT NULL,
    info character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    account_id integer,
    date_start timestamp without time zone,
    write_uid integer,
    date timestamp without time zone,
    server_date timestamp without time zone NOT NULL,
    write_date timestamp without time zone,
    emp_id integer,
    analytic_amount double precision,
    name character varying NOT NULL
);


--
-- Name: TABLE hr_sign_out_project; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_sign_out_project IS 'Sign Out By Project';


--
-- Name: COLUMN hr_sign_out_project.info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.info IS 'Work Description';


--
-- Name: COLUMN hr_sign_out_project.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.create_uid IS 'Created by';


--
-- Name: COLUMN hr_sign_out_project.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.create_date IS 'Created on';


--
-- Name: COLUMN hr_sign_out_project.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.account_id IS 'Project / Analytic Account';


--
-- Name: COLUMN hr_sign_out_project.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.date_start IS 'Starting Date';


--
-- Name: COLUMN hr_sign_out_project.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_sign_out_project.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.date IS 'Closing Date';


--
-- Name: COLUMN hr_sign_out_project.server_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.server_date IS 'Current Date';


--
-- Name: COLUMN hr_sign_out_project.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_sign_out_project.emp_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.emp_id IS 'Employee ID';


--
-- Name: COLUMN hr_sign_out_project.analytic_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.analytic_amount IS 'Minimum Analytic Amount';


--
-- Name: COLUMN hr_sign_out_project.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_sign_out_project.name IS 'Employee''s Name';


--
-- Name: hr_sign_out_project_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_sign_out_project_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_sign_out_project_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_sign_out_project_id_seq OWNED BY hr_sign_out_project.id;


--
-- Name: hr_structure_salary_rule_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_structure_salary_rule_rel (
    struct_id integer NOT NULL,
    rule_id integer NOT NULL
);


--
-- Name: TABLE hr_structure_salary_rule_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_structure_salary_rule_rel IS 'RELATION BETWEEN hr_payroll_structure AND hr_salary_rule';


--
-- Name: hr_timesheet_analytic_profit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_analytic_profit (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    date_from date NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    date_to date NOT NULL
);


--
-- Name: TABLE hr_timesheet_analytic_profit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_analytic_profit IS 'Print Timesheet Profit';


--
-- Name: COLUMN hr_timesheet_analytic_profit.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_analytic_profit.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_analytic_profit.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.date_from IS 'From';


--
-- Name: COLUMN hr_timesheet_analytic_profit.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_analytic_profit.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_analytic_profit.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_analytic_profit.date_to IS 'To';


--
-- Name: hr_timesheet_analytic_profit_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_analytic_profit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_analytic_profit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_analytic_profit_id_seq OWNED BY hr_timesheet_analytic_profit.id;


--
-- Name: hr_timesheet_current_open; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_current_open (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE hr_timesheet_current_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_current_open IS 'hr.timesheet.current.open';


--
-- Name: COLUMN hr_timesheet_current_open.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_current_open.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_current_open.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_current_open.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_current_open.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_current_open.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_current_open.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_current_open.write_uid IS 'Last Updated by';


--
-- Name: hr_timesheet_current_open_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_current_open_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_current_open_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_current_open_id_seq OWNED BY hr_timesheet_current_open.id;


--
-- Name: hr_timesheet_invoice_create; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_invoice_create (
    id integer NOT NULL,
    create_uid integer,
    product integer,
    create_date timestamp without time zone,
    name boolean,
    price boolean,
    write_uid integer,
    write_date timestamp without time zone,
    "time" boolean,
    date boolean
);


--
-- Name: TABLE hr_timesheet_invoice_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_invoice_create IS 'Create invoice from timesheet';


--
-- Name: COLUMN hr_timesheet_invoice_create.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_invoice_create.product; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.product IS 'Force Product';


--
-- Name: COLUMN hr_timesheet_invoice_create.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_invoice_create.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.name IS 'Description';


--
-- Name: COLUMN hr_timesheet_invoice_create.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.price IS 'Cost';


--
-- Name: COLUMN hr_timesheet_invoice_create.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_invoice_create.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_invoice_create."time"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create."time" IS 'Time spent';


--
-- Name: COLUMN hr_timesheet_invoice_create.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create.date IS 'Date';


--
-- Name: hr_timesheet_invoice_create_final; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_invoice_create_final (
    id integer NOT NULL,
    create_uid integer,
    product integer,
    create_date timestamp without time zone,
    name boolean,
    price boolean,
    write_uid integer,
    write_date timestamp without time zone,
    "time" boolean,
    date boolean
);


--
-- Name: TABLE hr_timesheet_invoice_create_final; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_invoice_create_final IS 'Create invoice from timesheet final';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.product; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.product IS 'Product';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.name IS 'Log of Activity';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.price IS 'Cost';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_invoice_create_final."time"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final."time" IS 'Time Spent';


--
-- Name: COLUMN hr_timesheet_invoice_create_final.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_create_final.date IS 'Date';


--
-- Name: hr_timesheet_invoice_create_final_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_invoice_create_final_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_invoice_create_final_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_invoice_create_final_id_seq OWNED BY hr_timesheet_invoice_create_final.id;


--
-- Name: hr_timesheet_invoice_create_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_invoice_create_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_invoice_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_invoice_create_id_seq OWNED BY hr_timesheet_invoice_create.id;


--
-- Name: hr_timesheet_invoice_factor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_invoice_factor (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    factor double precision NOT NULL,
    customer_name character varying
);


--
-- Name: TABLE hr_timesheet_invoice_factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_invoice_factor IS 'Invoice Rate';


--
-- Name: COLUMN hr_timesheet_invoice_factor.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_invoice_factor.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_invoice_factor.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.name IS 'Internal Name';


--
-- Name: COLUMN hr_timesheet_invoice_factor.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_invoice_factor.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_invoice_factor.factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.factor IS 'Discount (%)';


--
-- Name: COLUMN hr_timesheet_invoice_factor.customer_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_invoice_factor.customer_name IS 'Name';


--
-- Name: hr_timesheet_invoice_factor_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_invoice_factor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_invoice_factor_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_invoice_factor_id_seq OWNED BY hr_timesheet_invoice_factor.id;


--
-- Name: hr_timesheet_sheet_sheet; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hr_timesheet_sheet_sheet (
    id integer NOT NULL,
    create_date timestamp without time zone,
    write_uid integer,
    create_uid integer,
    employee_id integer NOT NULL,
    user_id integer,
    date_from date NOT NULL,
    message_last_post timestamp without time zone,
    company_id integer,
    state character varying NOT NULL,
    department_id integer,
    write_date timestamp without time zone,
    date_to date NOT NULL,
    name character varying
);


--
-- Name: TABLE hr_timesheet_sheet_sheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE hr_timesheet_sheet_sheet IS 'Timesheet';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.employee_id IS 'Employee';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.user_id IS 'User';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.date_from IS 'Date from';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.company_id IS 'Company';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.state IS 'Status';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.department_id IS 'Department';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.date_to IS 'Date to';


--
-- Name: COLUMN hr_timesheet_sheet_sheet.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN hr_timesheet_sheet_sheet.name IS 'Note';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_users (
    id integer NOT NULL,
    active boolean DEFAULT true,
    login character varying(64) NOT NULL,
    password character varying DEFAULT NULL::character varying,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    login_date date,
    write_uid integer,
    write_date timestamp without time zone,
    signature text,
    action_id integer,
    password_crypt character varying,
    alias_id integer NOT NULL,
    display_groups_suggestions boolean,
    share boolean,
    default_section_id integer,
    display_employees_suggestions boolean
);


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.create_date IS 'Created on';


--
-- Name: COLUMN res_users.login_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.login_date IS 'Latest connection';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.signature IS 'Signature';


--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.password_crypt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.password_crypt IS 'Encrypted Password';


--
-- Name: COLUMN res_users.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.alias_id IS 'Alias';


--
-- Name: COLUMN res_users.display_groups_suggestions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.display_groups_suggestions IS 'Display Groups Suggestions';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.default_section_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.default_section_id IS 'Default Sales Team';


--
-- Name: COLUMN res_users.display_employees_suggestions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_users.display_employees_suggestions IS 'Display Employees Suggestions';


--
-- Name: hr_timesheet_sheet_sheet_day; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_timesheet_sheet_sheet_day AS
    SELECT bar.id, bar.name, bar.sheet_id, bar.total_timesheet, bar.total_attendance, (round(((bar.total_attendance - bar.total_timesheet))::numeric, 2))::double precision AS total_difference FROM (SELECT max(foo.id) AS id, foo.name, foo.sheet_id, foo.timezone, sum(foo.total_timesheet) AS total_timesheet, (CASE WHEN (sum(foo.orphan_attendances) <> (0)::numeric) THEN (sum(foo.total_attendance) + CASE WHEN (('now'::text)::date <> foo.name) THEN (1440)::double precision ELSE ((date_part('hour'::text, timezone((COALESCE(foo.timezone, 'UTC'::character varying))::text, timezone('UTC'::text, ('now'::text)::time with time zone))) * (60)::double precision) + date_part('minute'::text, timezone((COALESCE(foo.timezone, 'UTC'::character varying))::text, timezone('UTC'::text, ('now'::text)::time with time zone)))) END) ELSE sum(foo.total_attendance) END / (60)::double precision) AS total_attendance FROM (SELECT min(hrt.id) AS id, p.tz AS timezone, l.date AS name, s.id AS sheet_id, sum(l.unit_amount) AS total_timesheet, 0 AS orphan_attendances, 0.0 AS total_attendance FROM ((((((hr_analytic_timesheet hrt JOIN account_analytic_line l ON ((l.id = hrt.line_id))) LEFT JOIN hr_timesheet_sheet_sheet s ON ((s.id = hrt.sheet_id))) JOIN hr_employee e ON ((s.employee_id = e.id))) JOIN resource_resource r ON ((e.resource_id = r.id))) LEFT JOIN res_users u ON ((r.user_id = u.id))) LEFT JOIN res_partner p ON ((u.partner_id = p.id))) GROUP BY l.date, s.id, p.tz UNION SELECT (- min(a.id)) AS id, p.tz AS timezone, (timezone((COALESCE(p.tz, 'UTC'::character varying))::text, timezone('UTC'::text, a.name)))::date AS name, s.id AS sheet_id, 0.0 AS total_timesheet, sum(CASE WHEN ((a.action)::text = 'sign_in'::text) THEN (-1) ELSE 1 END) AS orphan_attendances, sum((((date_part('hour'::text, timezone((COALESCE(p.tz, 'UTC'::character varying))::text, timezone('UTC'::text, a.name))) * (60)::double precision) + date_part('minute'::text, timezone((COALESCE(p.tz, 'UTC'::character varying))::text, timezone('UTC'::text, a.name)))) * (CASE WHEN ((a.action)::text = 'sign_in'::text) THEN (-1) ELSE 1 END)::double precision)) AS total_attendance FROM (((((hr_attendance a LEFT JOIN hr_timesheet_sheet_sheet s ON ((s.id = a.sheet_id))) JOIN hr_employee e ON ((a.employee_id = e.id))) JOIN resource_resource r ON ((e.resource_id = r.id))) LEFT JOIN res_users u ON ((r.user_id = u.id))) LEFT JOIN res_partner p ON ((u.partner_id = p.id))) WHERE ((a.action)::text = ANY ((ARRAY['sign_in'::character varying, 'sign_out'::character varying])::text[])) GROUP BY (timezone((COALESCE(p.tz, 'UTC'::character varying))::text, timezone('UTC'::text, a.name)))::date, s.id, p.tz) foo GROUP BY foo.name, foo.sheet_id, foo.timezone) bar;


--
-- Name: hr_timesheet_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_timesheet_report AS
    WITH totals AS (SELECT d.sheet_id, d.name AS date, (sum(d.total_difference) / (COALESCE(sum(j.count), (1)::numeric))::double precision) AS total_diff, (sum(d.total_timesheet) / (COALESCE(sum(j.count), (1)::numeric))::double precision) AS total_timesheet, (sum(d.total_attendance) / (COALESCE(sum(j.count), (1)::numeric))::double precision) AS total_attendance FROM (hr_timesheet_sheet_sheet_day d LEFT JOIN (SELECT h.sheet_id, a.date, count(*) AS count FROM (account_analytic_line a JOIN hr_analytic_timesheet h ON ((h.line_id = a.id))) GROUP BY h.sheet_id, a.date) j ON (((d.sheet_id = j.sheet_id) AND (d.name = j.date)))) GROUP BY d.sheet_id, d.name) SELECT min(hat.id) AS id, aal.date, sum(aal.amount) AS cost, sum(aal.unit_amount) AS quantity, aal.account_id, aal.journal_id, aal.product_id, aal.general_account_id, aal.user_id, aal.company_id, aal.currency_id, htss.name, htss.date_from, htss.date_to, count(*) AS nbr, sum(t.total_diff) AS total_diff, sum(t.total_timesheet) AS total_timesheet, sum(t.total_attendance) AS total_attendance, aal.to_invoice, htss.department_id, htss.state FROM (((account_analytic_line aal JOIN hr_analytic_timesheet hat ON ((hat.line_id = aal.id))) LEFT JOIN hr_timesheet_sheet_sheet htss ON ((hat.sheet_id = htss.id))) LEFT JOIN totals t ON (((t.sheet_id = hat.sheet_id) AND (t.date = aal.date)))) GROUP BY aal.date, aal.account_id, aal.product_id, aal.general_account_id, aal.journal_id, aal.user_id, aal.company_id, aal.currency_id, htss.date_from, htss.date_to, aal.unit_amount, aal.amount, aal.to_invoice, htss.name, htss.state, htss.id, htss.department_id;


--
-- Name: hr_timesheet_sheet_sheet_account; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW hr_timesheet_sheet_sheet_account AS
    SELECT min(hrt.id) AS id, l.account_id AS name, s.id AS sheet_id, sum(l.unit_amount) AS total, l.to_invoice AS invoice_rate FROM (hr_analytic_timesheet hrt LEFT JOIN (account_analytic_line l LEFT JOIN hr_timesheet_sheet_sheet s ON ((((s.date_to >= l.date) AND (s.date_from <= l.date)) AND (s.user_id = l.user_id)))) ON ((l.id = hrt.line_id))) GROUP BY l.account_id, s.id, l.to_invoice;


--
-- Name: hr_timesheet_sheet_sheet_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hr_timesheet_sheet_sheet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_timesheet_sheet_sheet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE hr_timesheet_sheet_sheet_id_seq OWNED BY hr_timesheet_sheet_sheet.id;


--
-- Name: im_chat_message; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE im_chat_message (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone NOT NULL,
    write_uid integer,
    to_id integer NOT NULL,
    write_date timestamp without time zone,
    message character varying,
    type character varying,
    from_id integer
);


--
-- Name: TABLE im_chat_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE im_chat_message IS 'im_chat.message';


--
-- Name: COLUMN im_chat_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.create_uid IS 'Created by';


--
-- Name: COLUMN im_chat_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.create_date IS 'Create Date';


--
-- Name: COLUMN im_chat_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_chat_message.to_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.to_id IS 'Session To';


--
-- Name: COLUMN im_chat_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN im_chat_message.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.message IS 'Message';


--
-- Name: COLUMN im_chat_message.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.type IS 'Type';


--
-- Name: COLUMN im_chat_message.from_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_message.from_id IS 'Author';


--
-- Name: im_chat_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE im_chat_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: im_chat_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE im_chat_message_id_seq OWNED BY im_chat_message.id;


--
-- Name: im_chat_presence; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE im_chat_presence (
    id integer NOT NULL,
    status character varying,
    create_uid integer,
    create_date timestamp without time zone,
    last_presence timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    last_poll timestamp without time zone,
    user_id integer NOT NULL
);


--
-- Name: TABLE im_chat_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE im_chat_presence IS 'im_chat.presence';


--
-- Name: COLUMN im_chat_presence.status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.status IS 'IM Status';


--
-- Name: COLUMN im_chat_presence.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.create_uid IS 'Created by';


--
-- Name: COLUMN im_chat_presence.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.create_date IS 'Created on';


--
-- Name: COLUMN im_chat_presence.last_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN im_chat_presence.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_chat_presence.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.write_date IS 'Last Updated on';


--
-- Name: COLUMN im_chat_presence.last_poll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN im_chat_presence.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_presence.user_id IS 'Users';


--
-- Name: im_chat_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE im_chat_presence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: im_chat_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE im_chat_presence_id_seq OWNED BY im_chat_presence.id;


--
-- Name: im_chat_session; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE im_chat_session (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    uuid character varying(50),
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE im_chat_session; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE im_chat_session IS 'im_chat.session';


--
-- Name: COLUMN im_chat_session.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session.create_uid IS 'Created by';


--
-- Name: COLUMN im_chat_session.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session.create_date IS 'Created on';


--
-- Name: COLUMN im_chat_session.uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session.uuid IS 'UUID';


--
-- Name: COLUMN im_chat_session.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_chat_session.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session.write_date IS 'Last Updated on';


--
-- Name: im_chat_session_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE im_chat_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: im_chat_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE im_chat_session_id_seq OWNED BY im_chat_session.id;


--
-- Name: im_chat_session_res_users_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE im_chat_session_res_users_rel (
    id integer NOT NULL,
    create_uid integer,
    user_id integer NOT NULL,
    session_id integer NOT NULL,
    write_uid integer,
    state character varying,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE im_chat_session_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE im_chat_session_res_users_rel IS 'im_chat.conversation_state';


--
-- Name: COLUMN im_chat_session_res_users_rel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.create_uid IS 'Created by';


--
-- Name: COLUMN im_chat_session_res_users_rel.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.user_id IS 'Users';


--
-- Name: COLUMN im_chat_session_res_users_rel.session_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.session_id IS 'Session';


--
-- Name: COLUMN im_chat_session_res_users_rel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_chat_session_res_users_rel.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.state IS 'unknown';


--
-- Name: COLUMN im_chat_session_res_users_rel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.write_date IS 'Last Updated on';


--
-- Name: COLUMN im_chat_session_res_users_rel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN im_chat_session_res_users_rel.create_date IS 'Created on';


--
-- Name: im_chat_session_res_users_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE im_chat_session_res_users_rel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: im_chat_session_res_users_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE im_chat_session_res_users_rel_id_seq OWNED BY im_chat_session_res_users_rel.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_actions (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    help text,
    write_uid integer,
    write_date timestamp without time zone,
    usage character varying,
    type character varying NOT NULL,
    name character varying NOT NULL
);


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.help IS 'Action description';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_actions.usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.usage IS 'Action Usage';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions.name IS 'Name';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_client (
    res_model character varying,
    params_store bytea,
    tag character varying NOT NULL,
    context character varying NOT NULL
)
INHERITS (ir_actions);


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_client.params_store IS 'Params storage';


--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_client.context IS 'Context Value';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_report_xml (
    parser character varying,
    header boolean,
    report_type character varying NOT NULL,
    attachment character varying,
    report_sxw_content_data bytea,
    report_xml character varying,
    report_rml_content_data bytea,
    auto boolean,
    report_file character varying,
    multi boolean,
    report_xsl character varying,
    report_rml character varying,
    report_name character varying NOT NULL,
    attachment_use boolean,
    model character varying NOT NULL,
    paperformat_id integer
)
INHERITS (ir_actions);


--
-- Name: COLUMN ir_act_report_xml.parser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.parser IS 'Parser Class';


--
-- Name: COLUMN ir_act_report_xml.header; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.header IS 'Add RML Header';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.report_sxw_content_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_sxw_content_data IS 'SXW Content';


--
-- Name: COLUMN ir_act_report_xml.report_xml; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_xml IS 'XML Path';


--
-- Name: COLUMN ir_act_report_xml.report_rml_content_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_rml_content_data IS 'RML Content';


--
-- Name: COLUMN ir_act_report_xml.auto; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.auto IS 'Custom Python Parser';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.report_xsl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_xsl IS 'XSL Path';


--
-- Name: COLUMN ir_act_report_xml.report_rml; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_rml IS 'Main Report File Path/controller';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.model IS 'Model';


--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_report_xml.paperformat_id IS 'Paper format';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_server (
    code text,
    sequence integer,
    crud_model_id integer,
    condition character varying,
    ref_object character varying(128),
    id_object character varying(128),
    crud_model_name character varying,
    use_relational_model character varying NOT NULL,
    use_create character varying NOT NULL,
    wkf_field_id integer,
    wkf_model_id integer,
    state character varying NOT NULL,
    id_value character varying,
    action_id integer,
    model_id integer NOT NULL,
    sub_model_object_field integer,
    link_new_record boolean,
    wkf_transition_id integer,
    sub_object integer,
    use_write character varying NOT NULL,
    wkf_model_name character varying,
    copyvalue character varying,
    write_expression character varying,
    menu_ir_values_id integer,
    model_object_field integer,
    link_field_id integer,
    template_id integer,
    website_published boolean,
    website_path character varying
)
INHERITS (ir_actions);


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.condition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.condition IS 'Condition';


--
-- Name: COLUMN ir_act_server.ref_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.ref_object IS 'Reference record';


--
-- Name: COLUMN ir_act_server.id_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.id_object IS 'Record';


--
-- Name: COLUMN ir_act_server.crud_model_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.crud_model_name IS 'Create/Write Target Model Name';


--
-- Name: COLUMN ir_act_server.use_relational_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.use_relational_model IS 'Target Model';


--
-- Name: COLUMN ir_act_server.use_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.use_create IS 'Creation Policy';


--
-- Name: COLUMN ir_act_server.wkf_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.wkf_field_id IS 'Relation Field';


--
-- Name: COLUMN ir_act_server.wkf_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.wkf_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.id_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.id_value IS 'Record ID';


--
-- Name: COLUMN ir_act_server.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.action_id IS 'Client Action';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.model_id IS 'Base Model';


--
-- Name: COLUMN ir_act_server.sub_model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.sub_model_object_field IS 'Sub-field';


--
-- Name: COLUMN ir_act_server.link_new_record; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.link_new_record IS 'Attach the new record';


--
-- Name: COLUMN ir_act_server.wkf_transition_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.wkf_transition_id IS 'Signal to Trigger';


--
-- Name: COLUMN ir_act_server.sub_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.sub_object IS 'Sub-model';


--
-- Name: COLUMN ir_act_server.use_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.use_write IS 'Update Policy';


--
-- Name: COLUMN ir_act_server.wkf_model_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.wkf_model_name IS 'Target Model Name';


--
-- Name: COLUMN ir_act_server.copyvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.copyvalue IS 'Placeholder Expression';


--
-- Name: COLUMN ir_act_server.write_expression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.write_expression IS 'Expression';


--
-- Name: COLUMN ir_act_server.menu_ir_values_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.menu_ir_values_id IS 'More Menu entry';


--
-- Name: COLUMN ir_act_server.model_object_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.model_object_field IS 'Field';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.link_field_id IS 'Link using field';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.website_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.website_published IS 'Available on the Website';


--
-- Name: COLUMN ir_act_server.website_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_server.website_path IS 'Website Path';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (ir_actions);


--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_window (
    domain character varying,
    res_model character varying NOT NULL,
    search_view_id integer,
    view_type character varying NOT NULL,
    src_model character varying,
    view_id integer,
    auto_refresh integer,
    view_mode character varying NOT NULL,
    multi boolean,
    target character varying,
    auto_search boolean,
    res_id integer,
    filter boolean,
    "limit" integer,
    context character varying NOT NULL
)
INHERITS (ir_actions);


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.view_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.view_type IS 'View Type';


--
-- Name: COLUMN ir_act_window.src_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.src_model IS 'Source Model';


--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.auto_refresh; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.auto_refresh IS 'Auto-Refresh';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.multi IS 'Restrict to lists';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.auto_search; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.auto_search IS 'Auto Search';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.filter IS 'Filter';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window.context IS 'Context Value';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_act_window_view (
    id integer NOT NULL,
    create_uid integer,
    multi boolean,
    create_date timestamp without time zone,
    sequence integer,
    view_id integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    write_date timestamp without time zone,
    act_window_id integer
);


--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_act_window_view IS 'ir.actions.act_window.view';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_act_window_view.act_window_id IS 'Action';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_act_window_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_act_window_view_id_seq OWNED BY ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_actions_id_seq OWNED BY ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_actions_todo (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    sequence integer,
    write_uid integer,
    note text,
    state character varying NOT NULL,
    write_date timestamp without time zone,
    type character varying NOT NULL,
    action_id integer NOT NULL
);


--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.note IS 'Text';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_actions_todo.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.type IS 'Type';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_actions_todo.action_id IS 'Action';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_actions_todo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_actions_todo_id_seq OWNED BY ir_actions_todo.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_attachment (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    description text,
    url character varying(1024),
    res_model character varying,
    file_size integer,
    company_id integer,
    write_uid integer,
    res_name character varying,
    db_datas bytea,
    datas_fname character varying,
    write_date timestamp without time zone,
    type character varying NOT NULL,
    res_id integer,
    store_fname character varying,
    name character varying NOT NULL,
    datas_checksum character varying(40),
    datas_big bytea,
    mimetype character varying
);


--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_attachment IS 'ir.attachment';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.create_uid IS 'Owner';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.create_date IS 'Date Created';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.res_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.res_name IS 'Resource Name';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.datas_fname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.datas_fname IS 'File Name';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.name IS 'Attachment Name';


--
-- Name: COLUMN ir_attachment.datas_checksum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.datas_checksum IS 'Datas checksum';


--
-- Name: COLUMN ir_attachment.datas_big; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.datas_big IS 'Resized file content';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_attachment.mimetype IS 'Mime Type';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_attachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_attachment_id_seq OWNED BY ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value text NOT NULL,
    write_uid integer,
    key character varying NOT NULL
);


--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_config_parameter IS 'ir.config_parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_config_parameter.key IS 'Key';


--
-- Name: ir_config_parameter_groups_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_config_parameter_groups_rel (
    icp_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_config_parameter_groups_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_config_parameter_groups_rel IS 'RELATION BETWEEN ir_config_parameter AND res_groups';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_config_parameter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_config_parameter_id_seq OWNED BY ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_cron (
    id integer NOT NULL,
    function character varying,
    create_uid integer,
    args text,
    user_id integer NOT NULL,
    name character varying NOT NULL,
    interval_type character varying,
    numbercall integer,
    nextcall timestamp without time zone NOT NULL,
    priority integer,
    model character varying,
    doall boolean,
    write_date timestamp without time zone,
    active boolean,
    create_date timestamp without time zone,
    interval_number integer,
    write_uid integer
);


--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_cron IS 'ir.cron';


--
-- Name: COLUMN ir_cron.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.function IS 'Method';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.args; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.args IS 'Arguments';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.user_id IS 'User';


--
-- Name: COLUMN ir_cron.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.model IS 'Object';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_cron.write_uid IS 'Last Updated by';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_cron_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_cron_id_seq OWNED BY ir_cron.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_default (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    uid integer,
    ref_table character varying,
    company_id integer,
    value character varying,
    ref_id integer,
    write_date timestamp without time zone,
    field_tbl character varying,
    write_uid integer,
    field_name character varying,
    page character varying
);


--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_default IS 'ir.default';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.uid IS 'Users';


--
-- Name: COLUMN ir_default.ref_table; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.ref_table IS 'Table Ref.';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.value IS 'Default Value';


--
-- Name: COLUMN ir_default.ref_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.ref_id IS 'ID Ref.';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_default.field_tbl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.field_tbl IS 'Object';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.field_name IS 'Object Field';


--
-- Name: COLUMN ir_default.page; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_default.page IS 'View';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_default_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_default_id_seq OWNED BY ir_default.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_exports (
    id integer NOT NULL,
    create_uid integer,
    resource character varying,
    name character varying,
    write_uid integer,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_exports IS 'ir.exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports.create_date IS 'Created on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_exports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_exports_id_seq OWNED BY ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_exports_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    write_uid integer,
    write_date timestamp without time zone,
    export_id integer
);


--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_exports_line IS 'ir.exports.line';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_exports_line.export_id IS 'Export';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_exports_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_exports_line_id_seq OWNED BY ir_exports_line.id;


--
-- Name: ir_fields_converter; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_fields_converter (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE ir_fields_converter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_fields_converter IS 'ir.fields.converter';


--
-- Name: COLUMN ir_fields_converter.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_fields_converter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_fields_converter.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_fields_converter.create_date IS 'Created on';


--
-- Name: COLUMN ir_fields_converter.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_fields_converter.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_fields_converter.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_fields_converter.write_uid IS 'Last Updated by';


--
-- Name: ir_fields_converter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_fields_converter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_fields_converter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_fields_converter_id_seq OWNED BY ir_fields_converter.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_filters (
    id integer NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    user_id integer,
    name character varying NOT NULL,
    create_uid integer,
    write_uid integer,
    is_default boolean,
    context text NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    action_id integer
);


--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.is_default IS 'Default filter';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_filters.action_id IS 'Action';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_filters_id_seq OWNED BY ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_logging (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    level character varying,
    line character varying NOT NULL,
    dbname character varying,
    write_uid integer,
    func character varying NOT NULL,
    write_date timestamp without time zone,
    path character varying NOT NULL,
    message text NOT NULL,
    type character varying NOT NULL
);


--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_logging IS 'ir.logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.create_uid IS 'Uid';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.create_date IS 'Create Date';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_logging.type IS 'Type';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_logging_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_logging_id_seq OWNED BY ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_mail_server (
    id integer NOT NULL,
    create_uid integer,
    smtp_encryption character varying NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    smtp_port integer NOT NULL,
    smtp_host character varying NOT NULL,
    write_uid integer,
    smtp_pass character varying(64),
    smtp_debug boolean,
    write_date timestamp without time zone,
    active boolean,
    smtp_user character varying(64)
);


--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_mail_server IS 'ir.mail_server';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_encryption IS 'Connection Security';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.name IS 'Description';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_mail_server.smtp_user IS 'Username';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_mail_server_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_mail_server_id_seq OWNED BY ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model (
    id integer NOT NULL,
    model character varying NOT NULL,
    name character varying NOT NULL,
    state character varying,
    info text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    perm_read boolean,
    name character varying NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    write_date timestamp without time zone,
    perm_unlink boolean,
    perm_write boolean,
    create_date timestamp without time zone,
    perm_create boolean,
    group_id integer
);


--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_model_access IS 'ir.model.access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.model_id IS 'Object';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_access.group_id IS 'Group';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_access_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_access_id_seq OWNED BY ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_constraint (
    id integer NOT NULL,
    date_init timestamp without time zone,
    date_update timestamp without time zone,
    module integer NOT NULL,
    model integer NOT NULL,
    type character varying(1) NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_constraint_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_constraint_id_seq OWNED BY ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    noupdate boolean,
    name character varying NOT NULL,
    date_init timestamp without time zone,
    date_update timestamp without time zone,
    module character varying NOT NULL,
    model character varying NOT NULL,
    res_id integer
);


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_data_id_seq OWNED BY ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_fields (
    id integer NOT NULL,
    model character varying NOT NULL,
    model_id integer NOT NULL,
    name character varying NOT NULL,
    relation character varying,
    select_level character varying NOT NULL,
    field_description character varying NOT NULL,
    ttype character varying NOT NULL,
    state character varying DEFAULT 'base'::character varying NOT NULL,
    relation_field character varying,
    translate boolean DEFAULT false,
    serialization_field_id integer,
    domain character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    on_delete character varying,
    write_uid integer,
    selection character varying,
    size integer,
    create_uid integer,
    readonly boolean,
    complete_name character varying,
    selectable boolean,
    required boolean,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.selection IS 'Selection Options';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_fields.required IS 'Required';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_fields_id_seq OWNED BY ir_model_fields.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_id_seq OWNED BY ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_model_relation (
    id integer NOT NULL,
    date_init timestamp without time zone,
    date_update timestamp without time zone,
    module integer NOT NULL,
    model integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_relation.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_model_relation.write_date IS 'Last Updated on';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_model_relation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_model_relation_id_seq OWNED BY ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name character varying NOT NULL,
    description text,
    sequence integer,
    visible boolean
);


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_category.visible IS 'Visible';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_module_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_module_category_id_seq OWNED BY ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary character varying,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying,
    latest_version character varying,
    shortdesc character varying,
    category_id integer,
    description text,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying,
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    menus_by_module text,
    reports_by_module text,
    maintainer character varying,
    contributors text,
    views_by_module text,
    published_version character varying,
    url character varying
);


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_module_module.url IS 'URL';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_module_module_dependency (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    name character varying,
    module_id integer
);


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_module_module_dependency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_module_module_dependency_id_seq OWNED BY ir_module_module_dependency.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_module_module_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_module_module_id_seq OWNED BY ir_module_module.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_property (
    id integer NOT NULL,
    value_text text,
    value_float double precision,
    create_date timestamp without time zone,
    name character varying,
    create_uid integer,
    type character varying NOT NULL,
    company_id integer,
    write_uid integer,
    fields_id integer NOT NULL,
    value_datetime timestamp without time zone,
    value_binary bytea,
    write_date timestamp without time zone,
    value_reference character varying,
    value_integer integer,
    res_id character varying
);


--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_property IS 'ir.property';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_text IS 'Value';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_float IS 'Value';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_datetime IS 'Value';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_binary IS 'Value';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_reference IS 'Value';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.value_integer IS 'Value';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_property.res_id IS 'Resource';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_property_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_property_id_seq OWNED BY ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    domain_force text,
    name character varying,
    create_uid integer,
    global boolean,
    write_uid integer,
    active boolean,
    perm_read boolean,
    perm_unlink boolean,
    perm_write boolean,
    create_date timestamp without time zone,
    perm_create boolean,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((((perm_read <> false) OR (perm_write <> false)) OR (perm_create <> false)) OR (perm_unlink <> false)))
);


--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_rule IS 'ir.rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.model_id IS 'Object';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_rule.write_date IS 'Last Updated on';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_rule_id_seq OWNED BY ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_sequence (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64),
    create_date timestamp without time zone,
    name character varying(64) NOT NULL,
    number_next integer NOT NULL,
    implementation character varying NOT NULL,
    company_id integer,
    write_uid integer,
    padding integer NOT NULL,
    number_increment integer NOT NULL,
    prefix character varying,
    write_date timestamp without time zone,
    active boolean,
    suffix character varying
);


--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_sequence IS 'ir.sequence';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.code IS 'Sequence Type';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.padding IS 'Number Padding';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.number_increment IS 'Increment Number';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence.suffix IS 'Suffix';


--
-- Name: ir_sequence_001; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_001
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_003; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_003
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_006; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_006
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_007; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_007
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_008; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_008
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_009; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_009
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_010; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_010
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_011; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_011
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_012; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_012
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_013; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_013
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_014; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_014
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_015; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_015
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_016; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_016
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_017; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_017
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_018; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_018
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_019; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_019
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_020; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_020
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_021; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_021
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_030; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_030
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_031; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_031
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_032; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_032
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_033; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_033
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_034; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_034
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_035; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_035
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_036; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_036
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_037; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_037
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_038; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_038
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_039; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_039
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_040; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_040
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_041; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_041
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_042; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_042
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_043; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_043
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_044; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_044
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_sequence_id_seq OWNED BY ir_sequence.id;


--
-- Name: ir_sequence_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_sequence_type (
    id integer NOT NULL,
    create_uid integer,
    code character varying(32) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_sequence_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_sequence_type IS 'ir.sequence.type';


--
-- Name: COLUMN ir_sequence_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_type.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.code IS 'Code';


--
-- Name: COLUMN ir_sequence_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.name IS 'Name';


--
-- Name: COLUMN ir_sequence_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_sequence_type.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_sequence_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_sequence_type_id_seq OWNED BY ir_sequence_type.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_server_object_lines (
    id integer NOT NULL,
    create_uid integer,
    server_id integer,
    create_date timestamp without time zone,
    value text NOT NULL,
    col1 integer NOT NULL,
    write_date timestamp without time zone,
    write_uid integer,
    type character varying NOT NULL
);


--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_server_object_lines.type IS 'Evaluation Type';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_server_object_lines_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_server_object_lines_id_seq OWNED BY ir_server_object_lines.id;


--
-- Name: ir_translation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_translation (
    id integer NOT NULL,
    lang character varying,
    src text,
    name character varying NOT NULL,
    res_id integer,
    module character varying,
    state character varying,
    comments text,
    value text,
    type character varying
);


--
-- Name: TABLE ir_translation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_translation IS 'ir.translation';


--
-- Name: COLUMN ir_translation.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.lang IS 'Language';


--
-- Name: COLUMN ir_translation.src; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.src IS 'Old source';


--
-- Name: COLUMN ir_translation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.name IS 'Translated field';


--
-- Name: COLUMN ir_translation.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.res_id IS 'Record ID';


--
-- Name: COLUMN ir_translation.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.module IS 'Module';


--
-- Name: COLUMN ir_translation.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.state IS 'Status';


--
-- Name: COLUMN ir_translation.comments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.comments IS 'Translation comments';


--
-- Name: COLUMN ir_translation.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.value IS 'Translation Value';


--
-- Name: COLUMN ir_translation.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_translation.type IS 'Type';


--
-- Name: ir_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_translation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_translation_id_seq OWNED BY ir_translation.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_ui_menu (
    id integer NOT NULL,
    parent_left integer,
    parent_right integer,
    web_icon_data bytea,
    needaction_enabled boolean,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    icon character varying(64),
    sequence integer,
    web_icon_hover character varying,
    write_uid integer,
    parent_id integer,
    web_icon character varying,
    write_date timestamp without time zone,
    create_uid integer,
    web_icon_hover_data bytea,
    mail_group_id integer
);


--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_ui_menu IS 'ir.ui.menu';


--
-- Name: COLUMN ir_ui_menu.web_icon_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.web_icon_data IS 'Web Icon Image';


--
-- Name: COLUMN ir_ui_menu.needaction_enabled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.needaction_enabled IS 'Target model uses the need action mechanism';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.icon IS 'Icon';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.web_icon_hover; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.web_icon_hover IS 'Web Icon File (hover)';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.web_icon_hover_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.web_icon_hover_data IS 'Web Icon Image (hover)';


--
-- Name: COLUMN ir_ui_menu.mail_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_menu.mail_group_id IS 'Mail Group';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_ui_menu_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_ui_menu_id_seq OWNED BY ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_ui_view (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    inherit_id integer,
    arch text NOT NULL,
    write_uid integer,
    priority integer NOT NULL,
    mode character varying NOT NULL,
    active boolean,
    model character varying,
    model_data_id integer,
    type character varying,
    write_date timestamp without time zone,
    field_parent character varying,
    customize_show boolean,
    website_meta_title character varying(70),
    website_meta_description text,
    website_meta_keywords character varying,
    page boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL)))
);


--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_ui_view IS 'ir.ui.view';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.create_date IS 'Create Date';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.arch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.model IS 'Object';


--
-- Name: COLUMN ir_ui_view.model_data_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.model_data_id IS 'Model Data';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.write_date IS 'Last Modification Date';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: COLUMN ir_ui_view.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN ir_ui_view.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN ir_ui_view.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN ir_ui_view.page; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view.page IS 'Whether this view is a web page template (complete)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_ui_view_custom (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    user_id integer NOT NULL,
    ref_id integer NOT NULL,
    arch text NOT NULL
);


--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_ui_view_custom IS 'ir.ui.view.custom';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_ui_view_custom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_ui_view_custom_id_seq OWNED BY ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_ui_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_ui_view_id_seq OWNED BY ir_ui_view.id;


--
-- Name: ir_values; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ir_values (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    name character varying NOT NULL,
    create_uid integer,
    key2 character varying,
    company_id integer,
    value text,
    write_uid integer,
    key character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    model character varying NOT NULL,
    res_id integer,
    action_id integer
);


--
-- Name: TABLE ir_values; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ir_values IS 'ir.values';


--
-- Name: COLUMN ir_values.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.model_id IS 'Model (change only)';


--
-- Name: COLUMN ir_values.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.user_id IS 'User';


--
-- Name: COLUMN ir_values.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.name IS 'Name';


--
-- Name: COLUMN ir_values.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.create_uid IS 'Created by';


--
-- Name: COLUMN ir_values.key2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.key2 IS 'Qualifier';


--
-- Name: COLUMN ir_values.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.company_id IS 'Company';


--
-- Name: COLUMN ir_values.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.value IS 'Value';


--
-- Name: COLUMN ir_values.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_values.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.key IS 'Type';


--
-- Name: COLUMN ir_values.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_values.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.create_date IS 'Created on';


--
-- Name: COLUMN ir_values.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.model IS 'Model Name';


--
-- Name: COLUMN ir_values.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.res_id IS 'Record ID';


--
-- Name: COLUMN ir_values.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ir_values.action_id IS 'Action (change only)';


--
-- Name: ir_values_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE ir_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE ir_values_id_seq OWNED BY ir_values.id;


--
-- Name: knowledge_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE knowledge_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    module_document boolean,
    write_date timestamp without time zone
);


--
-- Name: TABLE knowledge_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE knowledge_config_settings IS 'knowledge.config.settings';


--
-- Name: COLUMN knowledge_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN knowledge_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN knowledge_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN knowledge_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN knowledge_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN knowledge_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN knowledge_config_settings.module_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN knowledge_config_settings.module_document IS 'Manage documents';


--
-- Name: COLUMN knowledge_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN knowledge_config_settings.write_date IS 'Last Updated on';


--
-- Name: knowledge_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE knowledge_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: knowledge_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE knowledge_config_settings_id_seq OWNED BY knowledge_config_settings.id;


--
-- Name: l10n_fr_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE l10n_fr_line (
    id integer NOT NULL,
    definition character varying,
    code character varying(64),
    create_date timestamp without time zone,
    name character varying,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    report_id integer
);


--
-- Name: TABLE l10n_fr_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE l10n_fr_line IS 'Report Lines for l10n_fr';


--
-- Name: COLUMN l10n_fr_line.definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.definition IS 'Definition';


--
-- Name: COLUMN l10n_fr_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.code IS 'Variable Name';


--
-- Name: COLUMN l10n_fr_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.create_date IS 'Created on';


--
-- Name: COLUMN l10n_fr_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.name IS 'Name';


--
-- Name: COLUMN l10n_fr_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_fr_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_fr_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN l10n_fr_line.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_line.report_id IS 'Report';


--
-- Name: l10n_fr_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE l10n_fr_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: l10n_fr_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE l10n_fr_line_id_seq OWNED BY l10n_fr_line.id;


--
-- Name: l10n_fr_report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE l10n_fr_report (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64),
    create_date timestamp without time zone,
    name character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE l10n_fr_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE l10n_fr_report IS 'Report for l10n_fr';


--
-- Name: COLUMN l10n_fr_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_fr_report.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.code IS 'Code';


--
-- Name: COLUMN l10n_fr_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.create_date IS 'Created on';


--
-- Name: COLUMN l10n_fr_report.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.name IS 'Name';


--
-- Name: COLUMN l10n_fr_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_fr_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN l10n_fr_report.write_date IS 'Last Updated on';


--
-- Name: l10n_fr_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE l10n_fr_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: l10n_fr_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE l10n_fr_report_id_seq OWNED BY l10n_fr_report.id;


--
-- Name: ledger_journal_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ledger_journal_rel (
    ledger_id integer NOT NULL,
    journal_id integer NOT NULL
);


--
-- Name: TABLE ledger_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ledger_journal_rel IS 'RELATION BETWEEN account_analytic_cost_ledger_journal_report AND account_analytic_journal';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_alias (
    id integer NOT NULL,
    create_uid integer,
    alias_parent_thread_id integer,
    alias_defaults text NOT NULL,
    alias_contact character varying NOT NULL,
    alias_parent_model_id integer,
    write_uid integer,
    alias_force_thread_id integer,
    alias_model_id integer NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    alias_user_id integer,
    alias_name character varying
);


--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.alias_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_user_id IS 'Owner';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_alias.alias_name IS 'Alias Name';


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_alias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_alias_id_seq OWNED BY mail_alias.id;


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_compose_message (
    id integer NOT NULL,
    create_date timestamp without time zone,
    no_auto_thread boolean,
    mail_server_id integer,
    write_uid integer,
    notify boolean,
    active_domain character varying,
    subject character varying,
    composition_mode character varying,
    create_uid integer,
    is_log boolean,
    parent_id integer,
    subtype_id integer,
    res_id integer,
    message_id character varying,
    body text,
    model character varying(128),
    record_name character varying,
    write_date timestamp without time zone,
    date timestamp without time zone,
    author_id integer,
    use_active_domain boolean,
    type character varying(12),
    reply_to character varying,
    email_from character varying,
    template_id integer
);


--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.no_auto_thread; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.no_auto_thread IS 'No threading for answers';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.notify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.notify IS 'Notify followers';


--
-- Name: COLUMN mail_compose_message.active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.active_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.is_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.is_log IS 'Log an Internal Note';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_compose_message.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_compose_message.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.date IS 'Date';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.use_active_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.use_active_domain IS 'Use active domain';


--
-- Name: COLUMN mail_compose_message.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_compose_message.template_id IS 'Use template';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_compose_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_compose_message_id_seq OWNED BY mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_followers (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer,
    partner_id integer NOT NULL
);


--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_followers.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_followers.partner_id IS 'Related Partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_followers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_followers_id_seq OWNED BY mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_group; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_group (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_date timestamp without time zone,
    description text,
    create_uid integer,
    message_last_post timestamp without time zone,
    image bytea,
    alias_id integer NOT NULL,
    group_public_id integer,
    write_uid integer,
    public character varying NOT NULL,
    image_medium bytea,
    image_small bytea,
    write_date timestamp without time zone,
    name character varying NOT NULL
);


--
-- Name: TABLE mail_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_group IS 'Discussion group';


--
-- Name: COLUMN mail_group.menu_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.menu_id IS 'Related Menu';


--
-- Name: COLUMN mail_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.create_date IS 'Created on';


--
-- Name: COLUMN mail_group.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.description IS 'Description';


--
-- Name: COLUMN mail_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.create_uid IS 'Created by';


--
-- Name: COLUMN mail_group.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN mail_group.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.image IS 'Photo';


--
-- Name: COLUMN mail_group.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.alias_id IS 'Alias';


--
-- Name: COLUMN mail_group.group_public_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN mail_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_group.public; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.public IS 'Privacy';


--
-- Name: COLUMN mail_group.image_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.image_medium IS 'Medium-sized photo';


--
-- Name: COLUMN mail_group.image_small; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.image_small IS 'Small-sized photo';


--
-- Name: COLUMN mail_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_group.name IS 'Name';


--
-- Name: mail_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_group_id_seq OWNED BY mail_group.id;


--
-- Name: mail_group_res_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_group_res_group_rel (
    mail_group_id integer NOT NULL,
    groups_id integer NOT NULL
);


--
-- Name: TABLE mail_group_res_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_group_res_group_rel IS 'RELATION BETWEEN mail_group AND res_groups';


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    notification boolean,
    auto_delete boolean,
    body_html text,
    write_uid integer,
    email_to text,
    headers text,
    state character varying,
    "references" text,
    write_date timestamp without time zone,
    email_cc character varying,
    fetchmail_server_id integer
);


--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.notification; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.notification IS 'Is Notification';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.body_html IS 'Rich-text Contents';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_mail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_mail_id_seq OWNED BY mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_message (
    id integer NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    mail_server_id integer,
    write_uid integer,
    subject character varying,
    create_uid integer,
    parent_id integer,
    subtype_id integer,
    res_id integer,
    message_id character varying,
    body text,
    model character varying(128),
    record_name character varying,
    no_auto_thread boolean,
    date timestamp without time zone,
    author_id integer,
    type character varying(12),
    reply_to character varying,
    email_from character varying,
    website_published boolean
);


--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_message IS 'Message';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.no_auto_thread; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.no_auto_thread IS 'No threading for answers';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.type IS 'Type';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.website_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message.website_published IS 'Published';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_message_id_seq OWNED BY mail_message.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_message_subtype (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    description text,
    sequence integer,
    "default" boolean,
    res_model character varying,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone,
    relation_field character varying,
    hidden boolean,
    name character varying NOT NULL
);


--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_message_subtype.name IS 'Message Type';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_message_subtype_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_message_subtype_id_seq OWNED BY mail_message_subtype.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_notification (
    id integer NOT NULL,
    is_read boolean,
    starred boolean,
    partner_id integer NOT NULL,
    message_id integer NOT NULL
);


--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_notification IS 'Notifications';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_notification.is_read IS 'Read';


--
-- Name: COLUMN mail_notification.starred; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_notification.starred IS 'Starred';


--
-- Name: COLUMN mail_notification.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_notification.partner_id IS 'Contact';


--
-- Name: COLUMN mail_notification.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_notification.message_id IS 'Message';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_notification_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_notification_id_seq OWNED BY mail_notification.id;


--
-- Name: mail_vote; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_vote (
    message_id integer NOT NULL,
    user_id integer NOT NULL
);


--
-- Name: TABLE mail_vote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_vote IS 'RELATION BETWEEN mail_message AND res_users';


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_wizard_invite (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    res_model character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    message text,
    res_id integer,
    send_mail boolean
);


--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.send_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN mail_wizard_invite.send_mail IS 'Send Email';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mail_wizard_invite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE mail_wizard_invite_id_seq OWNED BY mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: make_procurement; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE make_procurement (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    product_id integer NOT NULL,
    date_planned date NOT NULL,
    qty numeric NOT NULL,
    warehouse_id integer NOT NULL,
    uom_id integer NOT NULL,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE make_procurement; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE make_procurement IS 'Make Procurements';


--
-- Name: COLUMN make_procurement.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.create_uid IS 'Created by';


--
-- Name: COLUMN make_procurement.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.create_date IS 'Created on';


--
-- Name: COLUMN make_procurement.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.product_id IS 'Product';


--
-- Name: COLUMN make_procurement.date_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.date_planned IS 'Planned Date';


--
-- Name: COLUMN make_procurement.qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.qty IS 'Quantity';


--
-- Name: COLUMN make_procurement.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN make_procurement.uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN make_procurement.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.write_date IS 'Last Updated on';


--
-- Name: COLUMN make_procurement.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN make_procurement.write_uid IS 'Last Updated by';


--
-- Name: make_procurement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE make_procurement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: make_procurement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE make_procurement_id_seq OWNED BY make_procurement.id;


--
-- Name: marketing_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE marketing_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    module_marketing_campaign boolean,
    write_uid integer,
    write_date timestamp without time zone,
    module_mass_mailing boolean,
    module_crm_profiling boolean,
    module_marketing_campaign_crm_demo boolean
);


--
-- Name: TABLE marketing_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE marketing_config_settings IS 'marketing.config.settings';


--
-- Name: COLUMN marketing_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN marketing_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN marketing_config_settings.module_marketing_campaign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.module_marketing_campaign IS 'Marketing campaigns';


--
-- Name: COLUMN marketing_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN marketing_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN marketing_config_settings.module_mass_mailing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.module_mass_mailing IS 'Mass Mailing';


--
-- Name: COLUMN marketing_config_settings.module_crm_profiling; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.module_crm_profiling IS 'Track customer profile to focus your campaigns';


--
-- Name: COLUMN marketing_config_settings.module_marketing_campaign_crm_demo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN marketing_config_settings.module_marketing_campaign_crm_demo IS 'Demo data for marketing campaigns';


--
-- Name: marketing_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE marketing_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: marketing_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE marketing_config_settings_id_seq OWNED BY marketing_config_settings.id;


--
-- Name: meeting_category_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE meeting_category_rel (
    event_id integer NOT NULL,
    type_id integer NOT NULL
);


--
-- Name: TABLE meeting_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE meeting_category_rel IS 'RELATION BETWEEN calendar_event AND calendar_event_type';


--
-- Name: merge_opportunity_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE merge_opportunity_rel (
    merge_id integer NOT NULL,
    opportunity_id integer NOT NULL
);


--
-- Name: TABLE merge_opportunity_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE merge_opportunity_rel IS 'RELATION BETWEEN crm_merge_opportunity AND crm_lead';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: multi_company_default; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE multi_company_default (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    field_id integer,
    company_id integer NOT NULL,
    object_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    company_dest_id integer NOT NULL,
    expression character varying NOT NULL
);


--
-- Name: TABLE multi_company_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE multi_company_default IS 'Default multi company';


--
-- Name: COLUMN multi_company_default.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.create_uid IS 'Created by';


--
-- Name: COLUMN multi_company_default.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.create_date IS 'Created on';


--
-- Name: COLUMN multi_company_default.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.name IS 'Name';


--
-- Name: COLUMN multi_company_default.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.sequence IS 'Sequence';


--
-- Name: COLUMN multi_company_default.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.field_id IS 'Field';


--
-- Name: COLUMN multi_company_default.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.company_id IS 'Main Company';


--
-- Name: COLUMN multi_company_default.object_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.object_id IS 'Object';


--
-- Name: COLUMN multi_company_default.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN multi_company_default.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.write_date IS 'Last Updated on';


--
-- Name: COLUMN multi_company_default.company_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.company_dest_id IS 'Default Company';


--
-- Name: COLUMN multi_company_default.expression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN multi_company_default.expression IS 'Expression';


--
-- Name: multi_company_default_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE multi_company_default_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: multi_company_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE multi_company_default_id_seq OWNED BY multi_company_default.id;


--
-- Name: osv_memory_autovacuum; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE osv_memory_autovacuum (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE osv_memory_autovacuum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE osv_memory_autovacuum IS 'osv_memory.autovacuum';


--
-- Name: COLUMN osv_memory_autovacuum.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN osv_memory_autovacuum.create_uid IS 'Created by';


--
-- Name: COLUMN osv_memory_autovacuum.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN osv_memory_autovacuum.create_date IS 'Created on';


--
-- Name: COLUMN osv_memory_autovacuum.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN osv_memory_autovacuum.write_date IS 'Last Updated on';


--
-- Name: COLUMN osv_memory_autovacuum.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN osv_memory_autovacuum.write_uid IS 'Last Updated by';


--
-- Name: osv_memory_autovacuum_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE osv_memory_autovacuum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: osv_memory_autovacuum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE osv_memory_autovacuum_id_seq OWNED BY osv_memory_autovacuum.id;


--
-- Name: payment_acquirer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE payment_acquirer (
    id integer NOT NULL,
    create_uid integer,
    website_published boolean,
    fees_dom_fixed double precision,
    fees_dom_var double precision,
    name character varying NOT NULL,
    fees_active boolean,
    company_id integer NOT NULL,
    write_uid integer,
    post_msg text,
    fees_int_var double precision,
    view_template_id integer NOT NULL,
    write_date timestamp without time zone,
    provider character varying NOT NULL,
    create_date timestamp without time zone,
    pre_msg text,
    validation character varying,
    fees_int_fixed double precision,
    environment character varying
);


--
-- Name: TABLE payment_acquirer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE payment_acquirer IS 'Payment Acquirer';


--
-- Name: COLUMN payment_acquirer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.create_uid IS 'Created by';


--
-- Name: COLUMN payment_acquirer.website_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.website_published IS 'Visible in Portal / Website';


--
-- Name: COLUMN payment_acquirer.fees_dom_fixed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.fees_dom_fixed IS 'Fixed domestic fees';


--
-- Name: COLUMN payment_acquirer.fees_dom_var; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.fees_dom_var IS 'Variable domestic fees (in percents)';


--
-- Name: COLUMN payment_acquirer.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.name IS 'Name';


--
-- Name: COLUMN payment_acquirer.fees_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.fees_active IS 'Compute fees';


--
-- Name: COLUMN payment_acquirer.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.company_id IS 'Company';


--
-- Name: COLUMN payment_acquirer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_acquirer.post_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.post_msg IS 'Thanks Message';


--
-- Name: COLUMN payment_acquirer.fees_int_var; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.fees_int_var IS 'Variable international fees (in percents)';


--
-- Name: COLUMN payment_acquirer.view_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.view_template_id IS 'Form Button Template';


--
-- Name: COLUMN payment_acquirer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_acquirer.provider; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.provider IS 'Provider';


--
-- Name: COLUMN payment_acquirer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.create_date IS 'Created on';


--
-- Name: COLUMN payment_acquirer.pre_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.pre_msg IS 'Message';


--
-- Name: COLUMN payment_acquirer.validation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.validation IS 'Process Method';


--
-- Name: COLUMN payment_acquirer.fees_int_fixed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.fees_int_fixed IS 'Fixed international fees';


--
-- Name: COLUMN payment_acquirer.environment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_acquirer.environment IS 'Environment';


--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE payment_acquirer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE payment_acquirer_id_seq OWNED BY payment_acquirer.id;


--
-- Name: payment_transaction; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE payment_transaction (
    id integer NOT NULL,
    state_message text,
    create_date timestamp without time zone,
    reference character varying NOT NULL,
    write_uid integer,
    date_create timestamp without time zone NOT NULL,
    acquirer_id integer NOT NULL,
    fees numeric,
    partner_id integer,
    create_uid integer,
    partner_reference character varying,
    partner_name character varying,
    message_last_post timestamp without time zone,
    partner_phone character varying,
    state character varying NOT NULL,
    type character varying NOT NULL,
    partner_country_id integer NOT NULL,
    acquirer_reference character varying,
    partner_address character varying,
    partner_email character varying,
    partner_lang character varying,
    write_date timestamp without time zone,
    partner_zip character varying,
    currency_id integer NOT NULL,
    date_validate timestamp without time zone,
    partner_city character varying,
    amount numeric NOT NULL,
    sale_order_id integer
);


--
-- Name: TABLE payment_transaction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE payment_transaction IS 'Payment Transaction';


--
-- Name: COLUMN payment_transaction.state_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.state_message IS 'Message';


--
-- Name: COLUMN payment_transaction.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.create_date IS 'Created on';


--
-- Name: COLUMN payment_transaction.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.reference IS 'Order Reference';


--
-- Name: COLUMN payment_transaction.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_transaction.date_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.date_create IS 'Creation Date';


--
-- Name: COLUMN payment_transaction.acquirer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.acquirer_id IS 'Acquirer';


--
-- Name: COLUMN payment_transaction.fees; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.fees IS 'Fees';


--
-- Name: COLUMN payment_transaction.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_id IS 'Partner';


--
-- Name: COLUMN payment_transaction.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.create_uid IS 'Created by';


--
-- Name: COLUMN payment_transaction.partner_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_reference IS 'Partner Reference';


--
-- Name: COLUMN payment_transaction.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_name IS 'Partner Name';


--
-- Name: COLUMN payment_transaction.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN payment_transaction.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_phone IS 'Phone';


--
-- Name: COLUMN payment_transaction.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.state IS 'Status';


--
-- Name: COLUMN payment_transaction.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.type IS 'Type';


--
-- Name: COLUMN payment_transaction.partner_country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_country_id IS 'Country';


--
-- Name: COLUMN payment_transaction.acquirer_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.acquirer_reference IS 'Acquirer Order Reference';


--
-- Name: COLUMN payment_transaction.partner_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_address IS 'Address';


--
-- Name: COLUMN payment_transaction.partner_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_email IS 'Email';


--
-- Name: COLUMN payment_transaction.partner_lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_lang IS 'Lang';


--
-- Name: COLUMN payment_transaction.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_transaction.partner_zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_zip IS 'Zip';


--
-- Name: COLUMN payment_transaction.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.currency_id IS 'Currency';


--
-- Name: COLUMN payment_transaction.date_validate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.date_validate IS 'Validation Date';


--
-- Name: COLUMN payment_transaction.partner_city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.partner_city IS 'City';


--
-- Name: COLUMN payment_transaction.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.amount IS 'Amount';


--
-- Name: COLUMN payment_transaction.sale_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payment_transaction.sale_order_id IS 'Sale Order';


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE payment_transaction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE payment_transaction_id_seq OWNED BY payment_transaction.id;


--
-- Name: payslip_lines_contribution_register; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE payslip_lines_contribution_register (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    date_from date NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    date_to date NOT NULL
);


--
-- Name: TABLE payslip_lines_contribution_register; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE payslip_lines_contribution_register IS 'PaySlip Lines by Contribution Registers';


--
-- Name: COLUMN payslip_lines_contribution_register.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.create_uid IS 'Created by';


--
-- Name: COLUMN payslip_lines_contribution_register.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.create_date IS 'Created on';


--
-- Name: COLUMN payslip_lines_contribution_register.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.date_from IS 'Date From';


--
-- Name: COLUMN payslip_lines_contribution_register.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payslip_lines_contribution_register.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN payslip_lines_contribution_register.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN payslip_lines_contribution_register.date_to IS 'Date To';


--
-- Name: payslip_lines_contribution_register_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE payslip_lines_contribution_register_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payslip_lines_contribution_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE payslip_lines_contribution_register_id_seq OWNED BY payslip_lines_contribution_register.id;


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    welcome_message text,
    write_uid integer,
    write_date timestamp without time zone,
    portal_id integer NOT NULL
);


--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE portal_wizard IS 'Portal Access Management';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN portal_wizard.portal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard.portal_id IS 'Portal';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE portal_wizard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE portal_wizard_id_seq OWNED BY portal_wizard.id;


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE portal_wizard_user (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    wizard_id integer NOT NULL,
    write_uid integer,
    email character varying(240),
    write_date timestamp without time zone,
    in_portal boolean,
    partner_id integer NOT NULL
);


--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: COLUMN portal_wizard_user.in_portal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.in_portal IS 'In Portal';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN portal_wizard_user.partner_id IS 'Contact';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE portal_wizard_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE portal_wizard_user_id_seq OWNED BY portal_wizard_user.id;


--
-- Name: pricelist_partnerinfo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pricelist_partnerinfo (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    price numeric NOT NULL,
    suppinfo_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    min_quantity double precision NOT NULL
);


--
-- Name: TABLE pricelist_partnerinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pricelist_partnerinfo IS 'pricelist.partnerinfo';


--
-- Name: COLUMN pricelist_partnerinfo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.create_uid IS 'Created by';


--
-- Name: COLUMN pricelist_partnerinfo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.create_date IS 'Created on';


--
-- Name: COLUMN pricelist_partnerinfo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.name IS 'Description';


--
-- Name: COLUMN pricelist_partnerinfo.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.price IS 'Unit Price';


--
-- Name: COLUMN pricelist_partnerinfo.suppinfo_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.suppinfo_id IS 'Partner Information';


--
-- Name: COLUMN pricelist_partnerinfo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN pricelist_partnerinfo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.write_date IS 'Last Updated on';


--
-- Name: COLUMN pricelist_partnerinfo.min_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pricelist_partnerinfo.min_quantity IS 'Quantity';


--
-- Name: pricelist_partnerinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE pricelist_partnerinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: pricelist_partnerinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE pricelist_partnerinfo_id_seq OWNED BY pricelist_partnerinfo.id;


--
-- Name: procurement_group; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procurement_group (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    move_type character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    partner_id integer
);


--
-- Name: TABLE procurement_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procurement_group IS 'Procurement Requisition';


--
-- Name: COLUMN procurement_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.create_date IS 'Created on';


--
-- Name: COLUMN procurement_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.name IS 'Reference';


--
-- Name: COLUMN procurement_group.move_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.move_type IS 'Delivery Method';


--
-- Name: COLUMN procurement_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN procurement_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_group.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_group.partner_id IS 'Partner';


--
-- Name: procurement_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE procurement_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: procurement_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE procurement_group_id_seq OWNED BY procurement_group.id;


--
-- Name: procurement_order; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procurement_order (
    id integer NOT NULL,
    origin character varying,
    create_date timestamp without time zone,
    product_uom integer NOT NULL,
    product_uos_qty double precision,
    write_uid integer,
    product_qty numeric NOT NULL,
    product_uos integer,
    create_uid integer,
    message_last_post timestamp without time zone,
    company_id integer NOT NULL,
    priority character varying NOT NULL,
    state character varying NOT NULL,
    write_date timestamp without time zone,
    name text NOT NULL,
    product_id integer NOT NULL,
    date_planned timestamp without time zone NOT NULL,
    group_id integer,
    rule_id integer,
    sale_line_id integer,
    move_dest_id integer,
    location_id integer,
    partner_dest_id integer,
    orderpoint_id integer,
    warehouse_id integer,
    invoice_state character varying,
    purchase_line_id integer
);


--
-- Name: TABLE procurement_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procurement_order IS 'Procurement';


--
-- Name: COLUMN procurement_order.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.origin IS 'Source Document';


--
-- Name: COLUMN procurement_order.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.create_date IS 'Created on';


--
-- Name: COLUMN procurement_order.product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.product_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN procurement_order.product_uos_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.product_uos_qty IS 'UoS Quantity';


--
-- Name: COLUMN procurement_order.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN procurement_order.product_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.product_qty IS 'Quantity';


--
-- Name: COLUMN procurement_order.product_uos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.product_uos IS 'Product UoS';


--
-- Name: COLUMN procurement_order.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_order.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN procurement_order.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.company_id IS 'Company';


--
-- Name: COLUMN procurement_order.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.priority IS 'Priority';


--
-- Name: COLUMN procurement_order.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.state IS 'Status';


--
-- Name: COLUMN procurement_order.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_order.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.name IS 'Description';


--
-- Name: COLUMN procurement_order.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.product_id IS 'Product';


--
-- Name: COLUMN procurement_order.date_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.date_planned IS 'Scheduled Date';


--
-- Name: COLUMN procurement_order.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.group_id IS 'Procurement Group';


--
-- Name: COLUMN procurement_order.rule_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.rule_id IS 'Rule';


--
-- Name: COLUMN procurement_order.sale_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.sale_line_id IS 'Sale Order Line';


--
-- Name: COLUMN procurement_order.move_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.move_dest_id IS 'Destination Move';


--
-- Name: COLUMN procurement_order.location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.location_id IS 'Procurement Location';


--
-- Name: COLUMN procurement_order.partner_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.partner_dest_id IS 'Customer Address';


--
-- Name: COLUMN procurement_order.orderpoint_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.orderpoint_id IS 'Minimum Stock Rule';


--
-- Name: COLUMN procurement_order.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN procurement_order.invoice_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.invoice_state IS 'Invoice Control';


--
-- Name: COLUMN procurement_order.purchase_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order.purchase_line_id IS 'Purchase Order Line';


--
-- Name: procurement_order_compute_all; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procurement_order_compute_all (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE procurement_order_compute_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procurement_order_compute_all IS 'Compute all schedulers';


--
-- Name: COLUMN procurement_order_compute_all.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order_compute_all.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_order_compute_all.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order_compute_all.create_date IS 'Created on';


--
-- Name: COLUMN procurement_order_compute_all.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order_compute_all.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_order_compute_all.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_order_compute_all.write_uid IS 'Last Updated by';


--
-- Name: procurement_order_compute_all_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE procurement_order_compute_all_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: procurement_order_compute_all_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE procurement_order_compute_all_id_seq OWNED BY procurement_order_compute_all.id;


--
-- Name: procurement_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE procurement_order_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: procurement_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE procurement_order_id_seq OWNED BY procurement_order.id;


--
-- Name: procurement_orderpoint_compute; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procurement_orderpoint_compute (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE procurement_orderpoint_compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procurement_orderpoint_compute IS 'Compute Minimum Stock Rules';


--
-- Name: COLUMN procurement_orderpoint_compute.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_orderpoint_compute.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_orderpoint_compute.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_orderpoint_compute.create_date IS 'Created on';


--
-- Name: COLUMN procurement_orderpoint_compute.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_orderpoint_compute.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_orderpoint_compute.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_orderpoint_compute.write_uid IS 'Last Updated by';


--
-- Name: procurement_orderpoint_compute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE procurement_orderpoint_compute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: procurement_orderpoint_compute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE procurement_orderpoint_compute_id_seq OWNED BY procurement_orderpoint_compute.id;


--
-- Name: procurement_rule; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procurement_rule (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    company_id integer,
    write_uid integer,
    action character varying NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    group_id integer,
    group_propagation_option character varying,
    partner_address_id integer,
    location_id integer,
    location_src_id integer,
    picking_type_id integer,
    delay integer,
    warehouse_id integer,
    propagate boolean,
    procure_method character varying NOT NULL,
    route_sequence numeric,
    route_id integer,
    propagate_warehouse_id integer,
    invoice_state character varying
);


--
-- Name: TABLE procurement_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procurement_rule IS 'Procurement Rule';


--
-- Name: COLUMN procurement_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.create_date IS 'Created on';


--
-- Name: COLUMN procurement_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.name IS 'Name';


--
-- Name: COLUMN procurement_rule.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.sequence IS 'Sequence';


--
-- Name: COLUMN procurement_rule.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.company_id IS 'Company';


--
-- Name: COLUMN procurement_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN procurement_rule.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.action IS 'Action';


--
-- Name: COLUMN procurement_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.active IS 'Active';


--
-- Name: COLUMN procurement_rule.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.group_id IS 'Fixed Procurement Group';


--
-- Name: COLUMN procurement_rule.group_propagation_option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.group_propagation_option IS 'Propagation of Procurement Group';


--
-- Name: COLUMN procurement_rule.partner_address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.partner_address_id IS 'Partner Address';


--
-- Name: COLUMN procurement_rule.location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.location_id IS 'Procurement Location';


--
-- Name: COLUMN procurement_rule.location_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.location_src_id IS 'Source Location';


--
-- Name: COLUMN procurement_rule.picking_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.picking_type_id IS 'Picking Type';


--
-- Name: COLUMN procurement_rule.delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.delay IS 'Number of Days';


--
-- Name: COLUMN procurement_rule.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.warehouse_id IS 'Served Warehouse';


--
-- Name: COLUMN procurement_rule.propagate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.propagate IS 'Propagate cancel and split';


--
-- Name: COLUMN procurement_rule.procure_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.procure_method IS 'Move Supply Method';


--
-- Name: COLUMN procurement_rule.route_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.route_sequence IS 'Route Sequence';


--
-- Name: COLUMN procurement_rule.route_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.route_id IS 'Route';


--
-- Name: COLUMN procurement_rule.propagate_warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.propagate_warehouse_id IS 'Warehouse to Propagate';


--
-- Name: COLUMN procurement_rule.invoice_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN procurement_rule.invoice_state IS 'Invoice Status';


--
-- Name: procurement_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE procurement_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: procurement_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE procurement_rule_id_seq OWNED BY procurement_rule.id;


--
-- Name: product_accessory_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_accessory_rel (
    src_id integer NOT NULL,
    dest_id integer NOT NULL
);


--
-- Name: TABLE product_accessory_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_accessory_rel IS 'RELATION BETWEEN product_template AND product_product';


--
-- Name: product_alternative_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_alternative_rel (
    src_id integer NOT NULL,
    dest_id integer NOT NULL
);


--
-- Name: TABLE product_alternative_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_alternative_rel IS 'RELATION BETWEEN product_template AND product_template';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    type character varying
);


--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.name IS 'Name';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute.type IS 'Type';


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_attribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_attribute_id_seq OWNED BY product_attribute.id;


--
-- Name: product_attribute_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    product_tmpl_id integer NOT NULL,
    attribute_id integer NOT NULL,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_attribute_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute_line IS 'product.attribute.line';


--
-- Name: COLUMN product_attribute_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_line.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_attribute_line.attribute_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_line.write_date IS 'Last Updated on';


--
-- Name: product_attribute_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_attribute_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_attribute_line_id_seq OWNED BY product_attribute_line.id;


--
-- Name: product_attribute_line_product_attribute_value_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute_line_product_attribute_value_rel (
    line_id integer NOT NULL,
    val_id integer NOT NULL
);


--
-- Name: TABLE product_attribute_line_product_attribute_value_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute_line_product_attribute_value_rel IS 'RELATION BETWEEN product_attribute_line AND product_attribute_value';


--
-- Name: product_attribute_price; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute_price (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    price_extra numeric,
    product_tmpl_id integer NOT NULL,
    value_id integer NOT NULL,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE product_attribute_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute_price IS 'product.attribute.price';


--
-- Name: COLUMN product_attribute_price.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_price.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_price.price_extra; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.price_extra IS 'Price Extra';


--
-- Name: COLUMN product_attribute_price.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_attribute_price.value_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.value_id IS 'Product Attribute Value';


--
-- Name: COLUMN product_attribute_price.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_price.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_price.write_uid IS 'Last Updated by';


--
-- Name: product_attribute_price_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_attribute_price_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_price_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_attribute_price_id_seq OWNED BY product_attribute_price.id;


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute_value (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    write_date timestamp without time zone,
    write_uid integer,
    color character varying
);


--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute_value IS 'product.attribute.value';


--
-- Name: COLUMN product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_value.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.name IS 'Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_value.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_attribute_value.color IS 'HTML Color Index';


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_attribute_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_attribute_value_id_seq OWNED BY product_attribute_value.id;


--
-- Name: product_attribute_value_product_product_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_attribute_value_product_product_rel (
    att_id integer NOT NULL,
    prod_id integer NOT NULL
);


--
-- Name: TABLE product_attribute_value_product_product_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_attribute_value_product_product_rel IS 'RELATION BETWEEN product_attribute_value AND product_product';


--
-- Name: product_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_category (
    id integer NOT NULL,
    parent_left integer,
    parent_right integer,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone,
    type character varying,
    removal_strategy_id integer
);


--
-- Name: TABLE product_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_category IS 'Product Category';


--
-- Name: COLUMN product_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.create_date IS 'Created on';


--
-- Name: COLUMN product_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.name IS 'Name';


--
-- Name: COLUMN product_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.sequence IS 'Sequence';


--
-- Name: COLUMN product_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_category.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.type IS 'Category Type';


--
-- Name: COLUMN product_category.removal_strategy_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_category.removal_strategy_id IS 'Force Removal Strategy';


--
-- Name: product_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_category_id_seq OWNED BY product_category.id;


--
-- Name: product_packaging; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_packaging (
    id integer NOT NULL,
    create_uid integer,
    rows integer NOT NULL,
    create_date timestamp without time zone,
    name text,
    weight double precision,
    ean character varying(14),
    ul_qty integer,
    sequence integer,
    qty double precision,
    product_tmpl_id integer NOT NULL,
    ul integer NOT NULL,
    code character varying,
    write_date timestamp without time zone,
    ul_container integer,
    write_uid integer
);


--
-- Name: TABLE product_packaging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_packaging IS 'Packaging';


--
-- Name: COLUMN product_packaging.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.create_uid IS 'Created by';


--
-- Name: COLUMN product_packaging.rows; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.rows IS 'Number of Layers';


--
-- Name: COLUMN product_packaging.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.create_date IS 'Created on';


--
-- Name: COLUMN product_packaging.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.name IS 'Description';


--
-- Name: COLUMN product_packaging.weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.weight IS 'Total Package Weight';


--
-- Name: COLUMN product_packaging.ean; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.ean IS 'EAN';


--
-- Name: COLUMN product_packaging.ul_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.ul_qty IS 'Package by layer';


--
-- Name: COLUMN product_packaging.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.sequence IS 'Sequence';


--
-- Name: COLUMN product_packaging.qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.qty IS 'Quantity by Package';


--
-- Name: COLUMN product_packaging.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.product_tmpl_id IS 'Product';


--
-- Name: COLUMN product_packaging.ul; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.ul IS 'Package Logistic Unit';


--
-- Name: COLUMN product_packaging.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.code IS 'Code';


--
-- Name: COLUMN product_packaging.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_packaging.ul_container; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.ul_container IS 'Pallet Logistic Unit';


--
-- Name: COLUMN product_packaging.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_packaging.write_uid IS 'Last Updated by';


--
-- Name: product_packaging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_packaging_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_packaging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_packaging_id_seq OWNED BY product_packaging.id;


--
-- Name: product_price_history; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_price_history (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    company_id integer NOT NULL,
    datetime timestamp without time zone,
    cost double precision,
    product_template_id integer NOT NULL,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE product_price_history; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_price_history IS 'product.price.history';


--
-- Name: COLUMN product_price_history.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.create_uid IS 'Created by';


--
-- Name: COLUMN product_price_history.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.create_date IS 'Created on';


--
-- Name: COLUMN product_price_history.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.company_id IS 'unknown';


--
-- Name: COLUMN product_price_history.datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.datetime IS 'Historization Time';


--
-- Name: COLUMN product_price_history.cost; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.cost IS 'Historized Cost';


--
-- Name: COLUMN product_price_history.product_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.product_template_id IS 'Product Template';


--
-- Name: COLUMN product_price_history.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_price_history.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_history.write_uid IS 'Last Updated by';


--
-- Name: product_price_history_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_price_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_price_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_price_history_id_seq OWNED BY product_price_history.id;


--
-- Name: product_price_list; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_price_list (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    price_list integer NOT NULL,
    write_uid integer,
    qty1 integer,
    qty2 integer,
    qty3 integer,
    qty4 integer,
    qty5 integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_price_list; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_price_list IS 'Price List';


--
-- Name: COLUMN product_price_list.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.create_uid IS 'Created by';


--
-- Name: COLUMN product_price_list.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.create_date IS 'Created on';


--
-- Name: COLUMN product_price_list.price_list; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.price_list IS 'PriceList';


--
-- Name: COLUMN product_price_list.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_price_list.qty1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.qty1 IS 'Quantity-1';


--
-- Name: COLUMN product_price_list.qty2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.qty2 IS 'Quantity-2';


--
-- Name: COLUMN product_price_list.qty3; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.qty3 IS 'Quantity-3';


--
-- Name: COLUMN product_price_list.qty4; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.qty4 IS 'Quantity-4';


--
-- Name: COLUMN product_price_list.qty5; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.qty5 IS 'Quantity-5';


--
-- Name: COLUMN product_price_list.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_list.write_date IS 'Last Updated on';


--
-- Name: product_price_list_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_price_list_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_price_list_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_price_list_id_seq OWNED BY product_price_list.id;


--
-- Name: product_price_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_price_type (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    currency_id integer NOT NULL,
    field character varying(32) NOT NULL,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE product_price_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_price_type IS 'Price Type';


--
-- Name: COLUMN product_price_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.create_uid IS 'Created by';


--
-- Name: COLUMN product_price_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.create_date IS 'Created on';


--
-- Name: COLUMN product_price_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.name IS 'Price Name';


--
-- Name: COLUMN product_price_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_price_type.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.currency_id IS 'Currency';


--
-- Name: COLUMN product_price_type.field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.field IS 'Product Field';


--
-- Name: COLUMN product_price_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_price_type.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_price_type.active IS 'Active';


--
-- Name: product_price_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_price_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_price_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_price_type_id_seq OWNED BY product_price_type.id;


--
-- Name: product_pricelist; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_pricelist (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    currency_id integer NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    type character varying NOT NULL,
    code character varying
);


--
-- Name: TABLE product_pricelist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_pricelist IS 'Pricelist';


--
-- Name: COLUMN product_pricelist.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.name IS 'Pricelist Name';


--
-- Name: COLUMN product_pricelist.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_pricelist.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.active IS 'Active';


--
-- Name: COLUMN product_pricelist.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.type IS 'Pricelist Type';


--
-- Name: COLUMN product_pricelist.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist.code IS 'Promotional Code';


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_pricelist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_pricelist_id_seq OWNED BY product_pricelist.id;


--
-- Name: product_pricelist_item; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_pricelist_item (
    id integer NOT NULL,
    price_round numeric,
    create_uid integer,
    price_min_margin numeric,
    create_date timestamp without time zone,
    price_discount numeric,
    name character varying,
    sequence integer NOT NULL,
    price_max_margin numeric,
    company_id integer,
    write_uid integer,
    product_tmpl_id integer,
    product_id integer,
    base integer NOT NULL,
    base_pricelist_id integer,
    price_version_id integer NOT NULL,
    min_quantity integer NOT NULL,
    write_date timestamp without time zone,
    categ_id integer,
    price_surcharge numeric
);


--
-- Name: TABLE product_pricelist_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_pricelist_item IS 'Pricelist item';


--
-- Name: COLUMN product_pricelist_item.price_round; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_round IS 'Price Rounding';


--
-- Name: COLUMN product_pricelist_item.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_item.price_min_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_min_margin IS 'Min. Price Margin';


--
-- Name: COLUMN product_pricelist_item.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_item.price_discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_discount IS 'Price Discount';


--
-- Name: COLUMN product_pricelist_item.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.name IS 'Rule Name';


--
-- Name: COLUMN product_pricelist_item.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.sequence IS 'Sequence';


--
-- Name: COLUMN product_pricelist_item.price_max_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_max_margin IS 'Max. Price Margin';


--
-- Name: COLUMN product_pricelist_item.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_item.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_item.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_pricelist_item.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.product_id IS 'Product';


--
-- Name: COLUMN product_pricelist_item.base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.base IS 'Based on';


--
-- Name: COLUMN product_pricelist_item.base_pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.base_pricelist_id IS 'Other Pricelist';


--
-- Name: COLUMN product_pricelist_item.price_version_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_version_id IS 'Price List Version';


--
-- Name: COLUMN product_pricelist_item.min_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.min_quantity IS 'Min. Quantity';


--
-- Name: COLUMN product_pricelist_item.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_pricelist_item.categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.categ_id IS 'Product Category';


--
-- Name: COLUMN product_pricelist_item.price_surcharge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_item.price_surcharge IS 'Price Surcharge';


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_pricelist_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_pricelist_item_id_seq OWNED BY product_pricelist_item.id;


--
-- Name: product_pricelist_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_pricelist_type (
    id integer NOT NULL,
    key character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_pricelist_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_pricelist_type IS 'Pricelist Type';


--
-- Name: COLUMN product_pricelist_type.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.key IS 'Key';


--
-- Name: COLUMN product_pricelist_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.name IS 'Name';


--
-- Name: COLUMN product_pricelist_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_type.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_pricelist_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_pricelist_type_id_seq OWNED BY product_pricelist_type.id;


--
-- Name: product_pricelist_version; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_pricelist_version (
    id integer NOT NULL,
    create_uid integer,
    name character varying NOT NULL,
    date_end date,
    date_start date,
    company_id integer,
    write_uid integer,
    write_date timestamp without time zone,
    pricelist_id integer NOT NULL,
    active boolean,
    create_date timestamp without time zone
);


--
-- Name: TABLE product_pricelist_version; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_pricelist_version IS 'Pricelist Version';


--
-- Name: COLUMN product_pricelist_version.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_version.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.name IS 'Name';


--
-- Name: COLUMN product_pricelist_version.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.date_end IS 'End Date';


--
-- Name: COLUMN product_pricelist_version.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.date_start IS 'Start Date';


--
-- Name: COLUMN product_pricelist_version.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_version.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_version.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_pricelist_version.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.pricelist_id IS 'Price List';


--
-- Name: COLUMN product_pricelist_version.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.active IS 'Active';


--
-- Name: COLUMN product_pricelist_version.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_pricelist_version.create_date IS 'Created on';


--
-- Name: product_pricelist_version_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_pricelist_version_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_pricelist_version_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_pricelist_version_id_seq OWNED BY product_pricelist_version.id;


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_product_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_product_id_seq OWNED BY product_product.id;


--
-- Name: product_public_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_public_category (
    id integer NOT NULL,
    create_uid integer,
    image_medium bytea,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    sequence integer,
    image bytea,
    image_small bytea,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_public_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_public_category IS 'Public Category';


--
-- Name: COLUMN product_public_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_public_category.image_medium; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.image_medium IS 'Medium-sized image';


--
-- Name: COLUMN product_public_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.create_date IS 'Created on';


--
-- Name: COLUMN product_public_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.name IS 'Name';


--
-- Name: COLUMN product_public_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.sequence IS 'Sequence';


--
-- Name: COLUMN product_public_category.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.image IS 'Image';


--
-- Name: COLUMN product_public_category.image_small; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.image_small IS 'Smal-sized image';


--
-- Name: COLUMN product_public_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_public_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_public_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_public_category.write_date IS 'Last Updated on';


--
-- Name: product_public_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_public_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_public_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_public_category_id_seq OWNED BY product_public_category.id;


--
-- Name: product_public_category_product_template_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_public_category_product_template_rel (
    product_template_id integer NOT NULL,
    product_public_category_id integer NOT NULL
);


--
-- Name: TABLE product_public_category_product_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_public_category_product_template_rel IS 'RELATION BETWEEN product_template AND product_public_category';


--
-- Name: product_putaway; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_putaway (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    method character varying NOT NULL
);


--
-- Name: TABLE product_putaway; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_putaway IS 'Put Away Strategy';


--
-- Name: COLUMN product_putaway.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.create_uid IS 'Created by';


--
-- Name: COLUMN product_putaway.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.create_date IS 'Created on';


--
-- Name: COLUMN product_putaway.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.name IS 'Name';


--
-- Name: COLUMN product_putaway.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_putaway.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_putaway.method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_putaway.method IS 'Method';


--
-- Name: product_putaway_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_putaway_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_putaway_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_putaway_id_seq OWNED BY product_putaway.id;


--
-- Name: product_removal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_removal (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    method character varying NOT NULL
);


--
-- Name: TABLE product_removal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_removal IS 'Removal Strategy';


--
-- Name: COLUMN product_removal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.create_uid IS 'Created by';


--
-- Name: COLUMN product_removal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.create_date IS 'Created on';


--
-- Name: COLUMN product_removal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.name IS 'Name';


--
-- Name: COLUMN product_removal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_removal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_removal.method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_removal.method IS 'Method';


--
-- Name: product_removal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_removal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_removal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_removal_id_seq OWNED BY product_removal.id;


--
-- Name: product_style; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_style (
    id integer NOT NULL,
    html_class character varying,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_style; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_style IS 'product.style';


--
-- Name: COLUMN product_style.html_class; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.html_class IS 'HTML Classes';


--
-- Name: COLUMN product_style.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.create_uid IS 'Created by';


--
-- Name: COLUMN product_style.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.create_date IS 'Created on';


--
-- Name: COLUMN product_style.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.name IS 'Style Name';


--
-- Name: COLUMN product_style.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_style.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_style.write_date IS 'Last Updated on';


--
-- Name: product_style_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_style_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_style_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_style_id_seq OWNED BY product_style.id;


--
-- Name: product_style_product_template_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_style_product_template_rel (
    product_template_id integer NOT NULL,
    product_style_id integer NOT NULL
);


--
-- Name: TABLE product_style_product_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_style_product_template_rel IS 'RELATION BETWEEN product_template AND product_style';


--
-- Name: product_supplier_taxes_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_supplier_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE product_supplier_taxes_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_supplier_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_supplierinfo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_supplierinfo (
    id integer NOT NULL,
    create_uid integer,
    product_code character varying,
    create_date timestamp without time zone,
    name integer NOT NULL,
    sequence integer,
    product_name character varying,
    company_id integer,
    write_uid integer,
    delay integer NOT NULL,
    write_date timestamp without time zone,
    min_qty double precision NOT NULL,
    qty numeric,
    product_tmpl_id integer NOT NULL
);


--
-- Name: TABLE product_supplierinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_supplierinfo IS 'Information about a product supplier';


--
-- Name: COLUMN product_supplierinfo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.create_uid IS 'Created by';


--
-- Name: COLUMN product_supplierinfo.product_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.product_code IS 'Supplier Product Code';


--
-- Name: COLUMN product_supplierinfo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.create_date IS 'Created on';


--
-- Name: COLUMN product_supplierinfo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.name IS 'Supplier';


--
-- Name: COLUMN product_supplierinfo.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.sequence IS 'Sequence';


--
-- Name: COLUMN product_supplierinfo.product_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.product_name IS 'Supplier Product Name';


--
-- Name: COLUMN product_supplierinfo.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.company_id IS 'Company';


--
-- Name: COLUMN product_supplierinfo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_supplierinfo.delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.delay IS 'Delivery Lead Time';


--
-- Name: COLUMN product_supplierinfo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_supplierinfo.min_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.min_qty IS 'Minimal Quantity';


--
-- Name: COLUMN product_supplierinfo.qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.qty IS 'Quantity';


--
-- Name: COLUMN product_supplierinfo.product_tmpl_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_supplierinfo.product_tmpl_id IS 'Product Template';


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_supplierinfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_supplierinfo_id_seq OWNED BY product_supplierinfo.id;


--
-- Name: product_taxes_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE product_taxes_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_template_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_template_id_seq OWNED BY product_template.id;


--
-- Name: product_ul; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_ul (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    weight double precision,
    height double precision,
    width double precision,
    length double precision,
    write_date timestamp without time zone,
    write_uid integer,
    type character varying NOT NULL
);


--
-- Name: TABLE product_ul; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_ul IS 'Logistic Unit';


--
-- Name: COLUMN product_ul.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.create_uid IS 'Created by';


--
-- Name: COLUMN product_ul.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.create_date IS 'Created on';


--
-- Name: COLUMN product_ul.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.name IS 'Name';


--
-- Name: COLUMN product_ul.weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.weight IS 'Empty Package Weight';


--
-- Name: COLUMN product_ul.height; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.height IS 'Height';


--
-- Name: COLUMN product_ul.width; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.width IS 'Width';


--
-- Name: COLUMN product_ul.length; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.length IS 'Length';


--
-- Name: COLUMN product_ul.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_ul.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_ul.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_ul.type IS 'Type';


--
-- Name: product_ul_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_ul_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_ul_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_ul_id_seq OWNED BY product_ul.id;


--
-- Name: product_uom_categ; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE product_uom_categ (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE product_uom_categ; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE product_uom_categ IS 'Product uom categ';


--
-- Name: COLUMN product_uom_categ.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom_categ.create_uid IS 'Created by';


--
-- Name: COLUMN product_uom_categ.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom_categ.create_date IS 'Created on';


--
-- Name: COLUMN product_uom_categ.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom_categ.name IS 'Name';


--
-- Name: COLUMN product_uom_categ.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom_categ.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_uom_categ.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN product_uom_categ.write_date IS 'Last Updated on';


--
-- Name: product_uom_categ_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_uom_categ_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_uom_categ_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_uom_categ_id_seq OWNED BY product_uom_categ.id;


--
-- Name: product_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE product_uom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: product_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE product_uom_id_seq OWNED BY product_uom.id;


--
-- Name: project_account_analytic_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE project_account_analytic_line (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    from_date date,
    to_date date,
    write_date timestamp without time zone
);


--
-- Name: TABLE project_account_analytic_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE project_account_analytic_line IS 'Analytic Entries by line';


--
-- Name: COLUMN project_account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN project_account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN project_account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_account_analytic_line.from_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.from_date IS 'From';


--
-- Name: COLUMN project_account_analytic_line.to_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.to_date IS 'To';


--
-- Name: COLUMN project_account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN project_account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: project_account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE project_account_analytic_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: project_account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE project_account_analytic_line_id_seq OWNED BY project_account_analytic_line.id;


--
-- Name: purchase_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_config_settings (
    id integer NOT NULL,
    group_uom boolean,
    create_uid integer,
    module_purchase_analytic_plans boolean,
    create_date timestamp without time zone,
    module_stock_dropshipping boolean,
    group_costing_method boolean,
    group_purchase_pricelist boolean,
    module_purchase_requisition boolean,
    group_advance_purchase_requisition boolean,
    write_uid integer,
    module_purchase_double_validation boolean,
    group_analytic_account_for_purchases boolean,
    write_date timestamp without time zone,
    default_invoice_method character varying NOT NULL,
    module_warning boolean
);


--
-- Name: TABLE purchase_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_config_settings IS 'purchase.config.settings';


--
-- Name: COLUMN purchase_config_settings.group_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.group_uom IS 'Manage different units of measure for products';


--
-- Name: COLUMN purchase_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_config_settings.module_purchase_analytic_plans; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.module_purchase_analytic_plans IS 'Use multiple analytic accounts on purchase orders';


--
-- Name: COLUMN purchase_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN purchase_config_settings.module_stock_dropshipping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.module_stock_dropshipping IS 'Manage dropshipping';


--
-- Name: COLUMN purchase_config_settings.group_costing_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.group_costing_method IS 'Use ''Real Price'' or ''Average'' costing methods.';


--
-- Name: COLUMN purchase_config_settings.group_purchase_pricelist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.group_purchase_pricelist IS 'Manage pricelist per supplier';


--
-- Name: COLUMN purchase_config_settings.module_purchase_requisition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.module_purchase_requisition IS 'Manage calls for bids';


--
-- Name: COLUMN purchase_config_settings.group_advance_purchase_requisition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.group_advance_purchase_requisition IS 'Choose from several bids in a call for bids';


--
-- Name: COLUMN purchase_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN purchase_config_settings.module_purchase_double_validation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.module_purchase_double_validation IS 'Force two levels of approvals';


--
-- Name: COLUMN purchase_config_settings.group_analytic_account_for_purchases; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.group_analytic_account_for_purchases IS 'Analytic accounting for purchases';


--
-- Name: COLUMN purchase_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_config_settings.default_invoice_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.default_invoice_method IS 'Default invoicing control method';


--
-- Name: COLUMN purchase_config_settings.module_warning; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_config_settings.module_warning IS 'Alerts by products or supplier';


--
-- Name: purchase_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE purchase_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE purchase_config_settings_id_seq OWNED BY purchase_config_settings.id;


--
-- Name: purchase_invoice_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_invoice_rel (
    purchase_id integer NOT NULL,
    invoice_id integer NOT NULL
);


--
-- Name: TABLE purchase_invoice_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_invoice_rel IS 'RELATION BETWEEN purchase_order AND account_invoice';


--
-- Name: purchase_order; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order (
    id integer NOT NULL,
    origin character varying,
    create_date timestamp without time zone,
    company_id integer NOT NULL,
    currency_id integer NOT NULL,
    partner_ref character varying,
    date_order timestamp without time zone NOT NULL,
    partner_id integer NOT NULL,
    dest_address_id integer,
    create_uid integer,
    fiscal_position integer,
    amount_untaxed numeric,
    picking_type_id integer NOT NULL,
    location_id integer NOT NULL,
    message_last_post timestamp without time zone,
    journal_id integer,
    amount_tax numeric,
    state character varying,
    bid_validity date,
    pricelist_id integer NOT NULL,
    incoterm_id integer,
    bid_date date,
    payment_term_id integer,
    write_date timestamp without time zone,
    write_uid integer,
    date_approve date,
    amount_total numeric,
    name character varying NOT NULL,
    notes text,
    invoice_method character varying NOT NULL,
    shipped boolean,
    validator integer,
    minimum_planned_date date,
    related_location_id integer
);


--
-- Name: TABLE purchase_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order IS 'Purchase Order';


--
-- Name: COLUMN purchase_order.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.origin IS 'Source Document';


--
-- Name: COLUMN purchase_order.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.company_id IS 'Company';


--
-- Name: COLUMN purchase_order.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.currency_id IS 'Currency';


--
-- Name: COLUMN purchase_order.partner_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.partner_ref IS 'Supplier Reference';


--
-- Name: COLUMN purchase_order.date_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.date_order IS 'Order Date';


--
-- Name: COLUMN purchase_order.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.partner_id IS 'Supplier';


--
-- Name: COLUMN purchase_order.dest_address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.dest_address_id IS 'Customer Address (Direct Delivery)';


--
-- Name: COLUMN purchase_order.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.create_uid IS 'Responsible';


--
-- Name: COLUMN purchase_order.fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN purchase_order.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN purchase_order.picking_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.picking_type_id IS 'Deliver To';


--
-- Name: COLUMN purchase_order.location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.location_id IS 'Destination';


--
-- Name: COLUMN purchase_order.message_last_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.message_last_post IS 'Last Message Date';


--
-- Name: COLUMN purchase_order.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.journal_id IS 'Journal';


--
-- Name: COLUMN purchase_order.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.amount_tax IS 'Taxes';


--
-- Name: COLUMN purchase_order.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.state IS 'Status';


--
-- Name: COLUMN purchase_order.bid_validity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.bid_validity IS 'Bid Valid Until';


--
-- Name: COLUMN purchase_order.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN purchase_order.incoterm_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.incoterm_id IS 'Incoterm';


--
-- Name: COLUMN purchase_order.bid_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.bid_date IS 'Bid Received On';


--
-- Name: COLUMN purchase_order.payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.payment_term_id IS 'Payment Term';


--
-- Name: COLUMN purchase_order.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_order.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN purchase_order.date_approve; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.date_approve IS 'Date Approved';


--
-- Name: COLUMN purchase_order.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.amount_total IS 'Total';


--
-- Name: COLUMN purchase_order.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.name IS 'Order Reference';


--
-- Name: COLUMN purchase_order.notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.notes IS 'Terms and Conditions';


--
-- Name: COLUMN purchase_order.invoice_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.invoice_method IS 'Invoicing Control';


--
-- Name: COLUMN purchase_order.shipped; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.shipped IS 'Received';


--
-- Name: COLUMN purchase_order.validator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.validator IS 'Validated by';


--
-- Name: COLUMN purchase_order.minimum_planned_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.minimum_planned_date IS 'Expected Date';


--
-- Name: COLUMN purchase_order.related_location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order.related_location_id IS 'Related location';


--
-- Name: purchase_order_group; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order_group (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE purchase_order_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order_group IS 'Purchase Order Merge';


--
-- Name: COLUMN purchase_order_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_group.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_order_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_group.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_order_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_group.write_uid IS 'Last Updated by';


--
-- Name: purchase_order_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE purchase_order_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE purchase_order_group_id_seq OWNED BY purchase_order_group.id;


--
-- Name: purchase_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE purchase_order_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE purchase_order_id_seq OWNED BY purchase_order.id;


--
-- Name: purchase_order_line; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order_line (
    id integer NOT NULL,
    create_date timestamp without time zone,
    product_uom integer NOT NULL,
    price_unit numeric NOT NULL,
    write_uid integer,
    product_qty numeric NOT NULL,
    partner_id integer,
    invoiced boolean,
    create_uid integer,
    company_id integer,
    state character varying NOT NULL,
    account_analytic_id integer,
    order_id integer NOT NULL,
    write_date timestamp without time zone,
    name text NOT NULL,
    product_id integer,
    date_planned date NOT NULL
);


--
-- Name: TABLE purchase_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order_line IS 'Purchase Order Line';


--
-- Name: COLUMN purchase_order_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order_line.product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.product_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN purchase_order_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN purchase_order_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN purchase_order_line.product_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.product_qty IS 'Quantity';


--
-- Name: COLUMN purchase_order_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.partner_id IS 'Partner';


--
-- Name: COLUMN purchase_order_line.invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.invoiced IS 'Invoiced';


--
-- Name: COLUMN purchase_order_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_order_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.company_id IS 'Company';


--
-- Name: COLUMN purchase_order_line.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.state IS 'Status';


--
-- Name: COLUMN purchase_order_line.account_analytic_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.account_analytic_id IS 'Analytic Account';


--
-- Name: COLUMN purchase_order_line.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.order_id IS 'Order Reference';


--
-- Name: COLUMN purchase_order_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_order_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.name IS 'Description';


--
-- Name: COLUMN purchase_order_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.product_id IS 'Product';


--
-- Name: COLUMN purchase_order_line.date_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line.date_planned IS 'Scheduled Date';


--
-- Name: purchase_order_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE purchase_order_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE purchase_order_line_id_seq OWNED BY purchase_order_line.id;


--
-- Name: purchase_order_line_invoice; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order_line_invoice (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE purchase_order_line_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order_line_invoice IS 'Purchase Order Line Make Invoice';


--
-- Name: COLUMN purchase_order_line_invoice.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line_invoice.create_uid IS 'Created by';


--
-- Name: COLUMN purchase_order_line_invoice.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line_invoice.create_date IS 'Created on';


--
-- Name: COLUMN purchase_order_line_invoice.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line_invoice.write_date IS 'Last Updated on';


--
-- Name: COLUMN purchase_order_line_invoice.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN purchase_order_line_invoice.write_uid IS 'Last Updated by';


--
-- Name: purchase_order_line_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE purchase_order_line_invoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: purchase_order_line_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE purchase_order_line_invoice_id_seq OWNED BY purchase_order_line_invoice.id;


--
-- Name: purchase_order_line_invoice_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order_line_invoice_rel (
    order_line_id integer NOT NULL,
    invoice_id integer NOT NULL
);


--
-- Name: TABLE purchase_order_line_invoice_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order_line_invoice_rel IS 'RELATION BETWEEN purchase_order_line AND account_invoice_line';


--
-- Name: purchase_order_taxe; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE purchase_order_taxe (
    ord_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE purchase_order_taxe; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE purchase_order_taxe IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: stock_picking_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE stock_picking_type (
    id integer NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    sequence integer,
    color integer,
    write_uid integer,
    create_uid integer,
    default_location_dest_id integer,
    warehouse_id integer,
    sequence_id integer NOT NULL,
    write_date timestamp without time zone,
    active boolean,
    name character varying NOT NULL,
    return_picking_type_id integer,
    default_location_src_id integer
);


--
-- Name: TABLE stock_picking_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE stock_picking_type IS 'The picking type determines the picking view';


--
-- Name: COLUMN stock_picking_type.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.code IS 'Type of Operation';


--
-- Name: COLUMN stock_picking_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.create_date IS 'Created on';


--
-- Name: COLUMN stock_picking_type.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.sequence IS 'Sequence';


--
-- Name: COLUMN stock_picking_type.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.color IS 'Color';


--
-- Name: COLUMN stock_picking_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_picking_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.create_uid IS 'Created by';


--
-- Name: COLUMN stock_picking_type.default_location_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.default_location_dest_id IS 'Default Destination Location';


--
-- Name: COLUMN stock_picking_type.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_picking_type.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.sequence_id IS 'Reference Sequence';


--
-- Name: COLUMN stock_picking_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_picking_type.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.active IS 'Active';


--
-- Name: COLUMN stock_picking_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.name IS 'Picking Type Name';


--
-- Name: COLUMN stock_picking_type.return_picking_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.return_picking_type_id IS 'Picking Type for Returns';


--
-- Name: COLUMN stock_picking_type.default_location_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN stock_picking_type.default_location_src_id IS 'Default Source Location';


--
-- Name: purchase_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW purchase_report AS
    WITH currency_rate(currency_id, rate, date_start, date_end) AS (SELECT r.currency_id, r.rate, r.name AS date_start, (SELECT r2.name FROM res_currency_rate r2 WHERE ((r2.name > r.name) AND (r2.currency_id = r.currency_id)) ORDER BY r2.name LIMIT 1) AS date_end FROM res_currency_rate r) SELECT min(l.id) AS id, s.date_order AS date, l.state, s.date_approve, s.minimum_planned_date AS expected_date, s.dest_address_id, s.pricelist_id, s.validator, spt.warehouse_id AS picking_type_id, s.partner_id, s.create_uid AS user_id, s.company_id, l.product_id, t.categ_id AS category_id, t.uom_id AS product_uom, s.location_id, sum(((l.product_qty / u.factor) * u2.factor)) AS quantity, (date_part('epoch'::text, age((s.date_approve)::timestamp without time zone, s.date_order)) / ((((24 * 60) * 60))::numeric(16,2))::double precision) AS delay, (date_part('epoch'::text, age((l.date_planned)::timestamp without time zone, s.date_order)) / ((((24 * 60) * 60))::numeric(16,2))::double precision) AS delay_pass, count(*) AS nbr, (sum(((l.price_unit * cr.rate) * l.product_qty)))::numeric(16,2) AS price_total, (avg((((100.0 * ((l.price_unit * cr.rate) * l.product_qty)))::double precision / NULLIF((((ip.value_float * (l.product_qty)::double precision) / (u.factor)::double precision) * (u2.factor)::double precision), (0.0)::double precision))))::numeric(16,2) AS negociation, (sum((((ip.value_float * (l.product_qty)::double precision) / (u.factor)::double precision) * (u2.factor)::double precision)))::numeric(16,2) AS price_standard, ((sum(((l.product_qty * cr.rate) * l.price_unit)) / NULLIF(sum(((l.product_qty / u.factor) * u2.factor)), 0.0)))::numeric(16,2) AS price_average FROM ((((((((purchase_order_line l JOIN purchase_order s ON ((l.order_id = s.id))) LEFT JOIN product_product p ON ((l.product_id = p.id))) LEFT JOIN product_template t ON ((p.product_tmpl_id = t.id))) LEFT JOIN ir_property ip ON (((((ip.name)::text = 'standard_price'::text) AND ((ip.res_id)::text = pg_catalog.concat('product.template,', t.id))) AND (ip.company_id = s.company_id)))) LEFT JOIN product_uom u ON ((u.id = l.product_uom))) LEFT JOIN product_uom u2 ON ((u2.id = t.uom_id))) LEFT JOIN stock_picking_type spt ON ((spt.id = s.picking_type_id))) JOIN currency_rate cr ON ((((cr.currency_id = s.currency_id) AND (cr.date_start <= COALESCE((s.date_order)::timestamp with time zone, now()))) AND ((cr.date_end IS NULL) OR (cr.date_end > COALESCE((s.date_order)::timestamp with time zone, now())))))) GROUP BY s.company_id, s.create_uid, s.partner_id, u.factor, s.location_id, l.price_unit, s.date_approve, l.date_planned, l.product_uom, s.minimum_planned_date, s.pricelist_id, s.validator, s.dest_address_id, l.product_id, t.categ_id, s.date_order, l.state, spt.warehouse_id, u.uom_type, u.category_id, t.uom_id, u.id, u2.factor;


--
-- Name: reconcile_account_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE reconcile_account_rel (
    reconcile_id integer NOT NULL,
    account_id integer NOT NULL
);


--
-- Name: TABLE reconcile_account_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE reconcile_account_rel IS 'RELATION BETWEEN account_automatic_reconcile AND account_account';


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE report (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE report IS 'Report';


--
-- Name: COLUMN report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report.create_uid IS 'Created by';


--
-- Name: COLUMN report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report.create_date IS 'Created on';


--
-- Name: COLUMN report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report.write_date IS 'Last Updated on';


--
-- Name: COLUMN report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report.write_uid IS 'Last Updated by';


--
-- Name: report_account_analytic_line_to_invoice; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_account_analytic_line_to_invoice AS
    SELECT DISTINCT to_char((l.date)::timestamp with time zone, 'MM'::text) AS month, to_char((l.date)::timestamp with time zone, 'YYYY'::text) AS name, min(l.id) AS id, l.product_id, l.account_id, sum(l.amount) AS amount, sum((l.unit_amount * (t.list_price)::double precision)) AS sale_price, sum(l.unit_amount) AS unit_amount, l.product_uom_id FROM ((account_analytic_line l LEFT JOIN product_product p ON ((l.product_id = p.id))) LEFT JOIN product_template t ON ((p.product_tmpl_id = t.id))) WHERE ((l.invoice_id IS NULL) AND (l.to_invoice IS NOT NULL)) GROUP BY to_char((l.date)::timestamp with time zone, 'YYYY'::text), to_char((l.date)::timestamp with time zone, 'MM'::text), l.product_id, l.product_uom_id, l.account_id;


--
-- Name: report_account_receivable; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_account_receivable AS
    SELECT min(l.id) AS id, to_char((l.date)::timestamp with time zone, 'YYYY:IW'::text) AS name, sum((l.debit - l.credit)) AS balance, sum(l.debit) AS debit, sum(l.credit) AS credit, a.type FROM (account_move_line l LEFT JOIN account_account a ON ((l.account_id = a.id))) WHERE ((l.state)::text <> 'draft'::text) GROUP BY to_char((l.date)::timestamp with time zone, 'YYYY:IW'::text), a.type;


--
-- Name: report_account_sales; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_account_sales AS
    SELECT min(inv_line.id) AS id, to_char((inv.date_invoice)::timestamp with time zone, 'YYYY'::text) AS name, to_char((inv.date_invoice)::timestamp with time zone, 'MM'::text) AS month, sum(inv_line.price_subtotal) AS amount_total, inv.currency_id, inv.period_id, inv_line.product_id, sum(inv_line.quantity) AS quantity, account.id AS account_id FROM ((account_invoice_line inv_line JOIN account_invoice inv ON ((inv.id = inv_line.invoice_id))) JOIN account_account account ON ((account.id = inv_line.account_id))) WHERE ((inv.state)::text = ANY ((ARRAY['open'::character varying, 'paid'::character varying])::text[])) GROUP BY to_char((inv.date_invoice)::timestamp with time zone, 'YYYY'::text), to_char((inv.date_invoice)::timestamp with time zone, 'MM'::text), inv.currency_id, inv.period_id, inv_line.product_id, account.id;


--
-- Name: report_account_type_sales; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_account_type_sales AS
    SELECT min(inv_line.id) AS id, to_char((inv.date_invoice)::timestamp with time zone, 'YYYY'::text) AS name, to_char((inv.date_invoice)::timestamp with time zone, 'MM'::text) AS month, sum(inv_line.price_subtotal) AS amount_total, inv.currency_id, inv.period_id, inv_line.product_id, sum(inv_line.quantity) AS quantity, account.user_type FROM ((account_invoice_line inv_line JOIN account_invoice inv ON ((inv.id = inv_line.invoice_id))) JOIN account_account account ON ((account.id = inv_line.account_id))) WHERE ((inv.state)::text = ANY ((ARRAY['open'::character varying, 'paid'::character varying])::text[])) GROUP BY to_char((inv.date_invoice)::timestamp with time zone, 'YYYY'::text), to_char((inv.date_invoice)::timestamp with time zone, 'MM'::text), inv.currency_id, inv.period_id, inv_line.product_id, account.user_type;


--
-- Name: temp_range; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE temp_range (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE temp_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE temp_range IS 'A Temporary table used for Dashboard view';


--
-- Name: COLUMN temp_range.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN temp_range.create_uid IS 'Created by';


--
-- Name: COLUMN temp_range.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN temp_range.create_date IS 'Created on';


--
-- Name: COLUMN temp_range.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN temp_range.name IS 'Range';


--
-- Name: COLUMN temp_range.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN temp_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN temp_range.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN temp_range.write_date IS 'Last Updated on';


--
-- Name: report_aged_receivable; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_aged_receivable AS
    SELECT temp_range.id, temp_range.name FROM temp_range;


--
-- Name: report_analytic_account_close; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_analytic_account_close AS
    SELECT a.id, a.id AS name, a.state, sum(l.unit_amount) AS quantity, sum(l.amount) AS balance, a.partner_id, a.quantity_max, a.date AS date_deadline FROM (account_analytic_line l RIGHT JOIN account_analytic_account a ON ((l.account_id = a.id))) GROUP BY a.id, a.state, a.quantity_max, a.date, a.partner_id HAVING (((a.quantity_max > (0)::double precision) AND (sum(l.unit_amount) >= a.quantity_max)) OR (a.date <= ('now'::text)::date));


--
-- Name: report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE report_id_seq OWNED BY report.id;


--
-- Name: report_invoice_created; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_invoice_created AS
    SELECT inv.id, inv.name, inv.type, inv.number, inv.partner_id, inv.amount_untaxed, inv.amount_total, inv.currency_id, inv.date_invoice, inv.date_due, inv.residual, inv.state, inv.origin, inv.create_date FROM account_invoice inv WHERE ((to_date(to_char(inv.create_date, 'YYYY-MM-dd'::text), 'YYYY-MM-dd'::text) <= ('now'::text)::date) AND (to_date(to_char(inv.create_date, 'YYYY-MM-dd'::text), 'YYYY-MM-dd'::text) > (('now'::text)::date - 15)));


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE report_paperformat (
    id integer NOT NULL,
    create_uid integer,
    page_width integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    format character varying,
    "default" boolean,
    header_line boolean,
    header_spacing integer,
    dpi integer NOT NULL,
    write_uid integer,
    margin_right integer,
    margin_top integer,
    margin_left integer,
    write_date timestamp without time zone,
    margin_bottom integer,
    page_height integer,
    orientation character varying
);


--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE report_paperformat IS 'Allows customization of a report.';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat."default" IS 'Default paper format ?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN report_paperformat.orientation IS 'Orientation';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE report_paperformat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE report_paperformat_id_seq OWNED BY report_paperformat.id;


--
-- Name: report_stock_lines_date; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE report_stock_lines_date (
    id integer,
    product_id integer,
    date timestamp without time zone,
    move_date timestamp without time zone,
    active boolean
);


--
-- Name: report_timesheet_account; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_timesheet_account AS
    SELECT min(account_analytic_line.id) AS id, to_char(account_analytic_line.create_date, 'YYYY'::text) AS name, to_char(account_analytic_line.create_date, 'MM'::text) AS month, account_analytic_line.user_id, account_analytic_line.account_id, sum(account_analytic_line.unit_amount) AS quantity FROM account_analytic_line GROUP BY to_char(account_analytic_line.create_date, 'YYYY'::text), to_char(account_analytic_line.create_date, 'MM'::text), account_analytic_line.user_id, account_analytic_line.account_id;


--
-- Name: report_timesheet_account_date; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_timesheet_account_date AS
    SELECT min(account_analytic_line.id) AS id, to_char((account_analytic_line.date)::timestamp with time zone, 'YYYY'::text) AS name, to_char((account_analytic_line.date)::timestamp with time zone, 'MM'::text) AS month, account_analytic_line.user_id, account_analytic_line.account_id, sum(account_analytic_line.unit_amount) AS quantity FROM account_analytic_line GROUP BY to_char((account_analytic_line.date)::timestamp with time zone, 'YYYY'::text), to_char((account_analytic_line.date)::timestamp with time zone, 'MM'::text), account_analytic_line.user_id, account_analytic_line.account_id;


--
-- Name: report_timesheet_invoice; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_timesheet_invoice AS
    SELECT min(l.id) AS id, l.user_id, l.account_id, a.user_id AS manager_id, sum(l.unit_amount) AS quantity, sum((l.unit_amount * (t.list_price)::double precision)) AS amount_invoice FROM ((((account_analytic_line l LEFT JOIN hr_timesheet_invoice_factor f ON ((l.to_invoice = f.id))) LEFT JOIN account_analytic_account a ON ((l.account_id = a.id))) LEFT JOIN product_product p ON ((l.to_invoice = f.id))) LEFT JOIN product_template t ON ((l.to_invoice = f.id))) WHERE ((l.to_invoice IS NOT NULL) AND (l.invoice_id IS NULL)) GROUP BY l.user_id, l.account_id, a.user_id;


--
-- Name: report_timesheet_line; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_timesheet_line AS
    SELECT min(l.id) AS id, l.date, to_char((l.date)::timestamp with time zone, 'YYYY'::text) AS name, to_char((l.date)::timestamp with time zone, 'MM'::text) AS month, l.user_id, to_char((l.date)::timestamp with time zone, 'YYYY-MM-DD'::text) AS day, l.invoice_id, l.product_id, l.account_id, l.general_account_id, sum(l.unit_amount) AS quantity, sum(l.amount) AS cost FROM account_analytic_line l WHERE (l.user_id IS NOT NULL) GROUP BY l.date, l.user_id, l.product_id, l.account_id, l.general_account_id, l.invoice_id;


--
-- Name: report_timesheet_user; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW report_timesheet_user AS
    SELECT min(l.id) AS id, to_char((l.date)::timestamp with time zone, 'YYYY'::text) AS name, to_char((l.date)::timestamp with time zone, 'MM'::text) AS month, l.user_id, sum(l.unit_amount) AS quantity, sum(l.amount) AS cost FROM account_analytic_line l WHERE (l.user_id IS NOT NULL) GROUP BY l.date, to_char((l.date)::timestamp with time zone, 'YYYY'::text), to_char((l.date)::timestamp with time zone, 'MM'::text), l.user_id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_bank (
    id integer NOT NULL,
    email character varying,
    city character varying,
    fax character varying,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    zip character varying(24),
    create_uid integer,
    country integer,
    street2 character varying,
    bic character varying(64),
    write_uid integer,
    phone character varying,
    state integer,
    street character varying,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.fax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.fax IS 'Fax';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_bank.active IS 'Active';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_bank_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_bank_id_seq OWNED BY res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    rml_footer text,
    create_date timestamp without time zone,
    rml_header text NOT NULL,
    rml_paper_format character varying NOT NULL,
    write_uid integer,
    logo_web bytea,
    font integer,
    account_no character varying,
    parent_id integer,
    email character varying(64),
    create_uid integer,
    custom_footer boolean,
    phone character varying(64),
    rml_header2 text NOT NULL,
    rml_header3 text NOT NULL,
    write_date timestamp without time zone,
    rml_header1 character varying,
    company_registry character varying(64),
    paperformat_id integer,
    expense_currency_exchange_account_id integer,
    expects_chart_of_accounts boolean,
    paypal_account character varying(128),
    overdue_msg text,
    tax_calculation_rounding_method character varying,
    income_currency_exchange_account_id integer,
    vat_check_vies boolean,
    siret character varying(14),
    ape character varying,
    sale_note text,
    internal_transit_location_id integer,
    propagation_minimum_delta integer,
    po_lead double precision NOT NULL,
    security_lead double precision NOT NULL,
    timesheet_max_difference double precision,
    timesheet_range character varying,
    conv_coll character varying,
    org_ss character varying,
    cotisation_prevoyance numeric,
    plafond_secu numeric,
    nombre_employes integer
);


--
-- Name: COLUMN res_company.rml_footer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.create_date IS 'Created on';


--
-- Name: COLUMN res_company.rml_header; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_header IS 'RML Header';


--
-- Name: COLUMN res_company.rml_paper_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_paper_format IS 'Paper Format';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.font IS 'Font';


--
-- Name: COLUMN res_company.account_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.account_no IS 'Account No.';


--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.email IS 'Email';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.custom_footer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.custom_footer IS 'Custom Footer';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.rml_header2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_header2 IS 'RML Internal Header';


--
-- Name: COLUMN res_company.rml_header3; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_header3 IS 'RML Internal Header for Landscape Reports';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.rml_header1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.rml_header1 IS 'Company Tagline';


--
-- Name: COLUMN res_company.company_registry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.company_registry IS 'Company Registry';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN res_company.expects_chart_of_accounts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.expects_chart_of_accounts IS 'Expects a Chart of Accounts';


--
-- Name: COLUMN res_company.paypal_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.paypal_account IS 'Paypal Account';


--
-- Name: COLUMN res_company.overdue_msg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.overdue_msg IS 'Overdue Payments Message';


--
-- Name: COLUMN res_company.tax_calculation_rounding_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.tax_calculation_rounding_method IS 'Tax Calculation Rounding Method';


--
-- Name: COLUMN res_company.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN res_company.vat_check_vies; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.vat_check_vies IS 'VIES VAT Check';


--
-- Name: COLUMN res_company.siret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.siret IS 'SIRET';


--
-- Name: COLUMN res_company.ape; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.ape IS 'APE';


--
-- Name: COLUMN res_company.sale_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.sale_note IS 'Default Terms and Conditions';


--
-- Name: COLUMN res_company.internal_transit_location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.internal_transit_location_id IS 'Internal Transit Location';


--
-- Name: COLUMN res_company.propagation_minimum_delta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.propagation_minimum_delta IS 'Minimum Delta for Propagation of a Date Change on moves linked together';


--
-- Name: COLUMN res_company.po_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.po_lead IS 'Purchase Lead Time';


--
-- Name: COLUMN res_company.security_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.security_lead IS 'Security Days';


--
-- Name: COLUMN res_company.timesheet_max_difference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.timesheet_max_difference IS 'Timesheet allowed difference(Hours)';


--
-- Name: COLUMN res_company.timesheet_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.timesheet_range IS 'Timesheet range';


--
-- Name: COLUMN res_company.conv_coll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.conv_coll IS 'Convention collective';


--
-- Name: COLUMN res_company.org_ss; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.org_ss IS 'Organisme de securite sociale';


--
-- Name: COLUMN res_company.cotisation_prevoyance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.cotisation_prevoyance IS 'Cotisation Patronale Prevoyance';


--
-- Name: COLUMN res_company.plafond_secu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.plafond_secu IS 'Plafond de la Securite Sociale';


--
-- Name: COLUMN res_company.nombre_employes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_company.nombre_employes IS 'Nombre d''employes';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_company_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_company_id_seq OWNED BY res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_config (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_config IS 'res.config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config.write_uid IS 'Last Updated by';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_config_id_seq OWNED BY res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_config_installer IS 'res.config.installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_installer.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_config_installer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_config_installer_id_seq OWNED BY res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer
);


--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_config_settings IS 'res.config.settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_config_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_config_settings_id_seq OWNED BY res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_country (
    id integer NOT NULL,
    create_uid integer,
    code character varying(2),
    create_date timestamp without time zone,
    name character varying NOT NULL,
    image bytea,
    write_uid integer,
    currency_id integer,
    address_format text,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_country IS 'Country';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.image IS 'Image';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.address_format IS 'Address Format';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_country_group (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_country_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_country_group_id_seq OWNED BY res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_country_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_country_id_seq OWNED BY res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_country_state (
    id integer NOT NULL,
    create_uid integer,
    code character varying(3) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    country_id integer NOT NULL,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_country_state_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_country_state_id_seq OWNED BY res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    rounding numeric,
    symbol character varying(4),
    company_id integer,
    write_uid integer,
    base boolean,
    write_date timestamp without time zone,
    active boolean,
    "position" character varying,
    accuracy integer
);


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.symbol; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.symbol IS 'Symbol';


--
-- Name: COLUMN res_currency.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.company_id IS 'Company';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.base IS 'Base';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.accuracy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_currency.accuracy IS 'Computational Accuracy';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_currency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_currency_id_seq OWNED BY res_currency.id;


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_currency_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_currency_rate_id_seq OWNED BY res_currency_rate.id;


--
-- Name: res_font; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_font (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    family character varying NOT NULL,
    write_uid integer,
    mode character varying NOT NULL,
    write_date timestamp without time zone,
    path character varying NOT NULL
);


--
-- Name: TABLE res_font; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_font IS 'Fonts available';


--
-- Name: COLUMN res_font.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.create_uid IS 'Created by';


--
-- Name: COLUMN res_font.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.create_date IS 'Created on';


--
-- Name: COLUMN res_font.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.name IS 'Font Name';


--
-- Name: COLUMN res_font.family; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.family IS 'Font family';


--
-- Name: COLUMN res_font.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_font.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.mode IS 'Mode';


--
-- Name: COLUMN res_font.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_font.path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_font.path IS 'Path';


--
-- Name: res_font_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_font_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_font_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_font_id_seq OWNED BY res_font.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_groups (
    id integer NOT NULL,
    comment text,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    write_date timestamp without time zone,
    category_id integer,
    share boolean,
    is_portal boolean
);


--
-- Name: TABLE res_groups; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_groups IS 'Access Groups';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.name IS 'Name';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.is_portal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_groups.is_portal IS 'Portal';


--
-- Name: res_groups_action_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_groups_action_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE res_groups_action_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_groups_action_rel IS 'RELATION BETWEEN ir_actions_todo AND res_groups';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_groups_id_seq OWNED BY res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_lang (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(16) NOT NULL,
    date_format character varying NOT NULL,
    direction character varying NOT NULL,
    create_date timestamp without time zone,
    create_uid integer,
    thousands_sep character varying,
    translatable boolean,
    write_uid integer,
    time_format character varying NOT NULL,
    write_date timestamp without time zone,
    decimal_point character varying NOT NULL,
    active boolean,
    iso_code character varying(16),
    grouping character varying NOT NULL
);


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.translatable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.translatable IS 'Translatable';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.grouping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_lang.grouping IS 'Separator Format';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_lang_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_lang_id_seq OWNED BY res_lang.id;


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_bank (
    id integer NOT NULL,
    create_uid integer,
    owner_name character varying,
    create_date timestamp without time zone,
    name character varying,
    zip character varying(24),
    sequence integer,
    footer boolean,
    country_id integer,
    company_id integer,
    bank_name character varying,
    write_uid integer,
    state character varying NOT NULL,
    street character varying,
    city character varying,
    write_date timestamp without time zone,
    state_id integer,
    bank_bic character varying(16),
    partner_id integer,
    bank integer,
    acc_number character varying(64) NOT NULL,
    journal_id integer
);


--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.owner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.owner_name IS 'Account Owner Name';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.name IS 'Bank Account';


--
-- Name: COLUMN res_partner_bank.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.zip IS 'Zip';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.footer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.footer IS 'Display on Reports';


--
-- Name: COLUMN res_partner_bank.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.country_id IS 'Country';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.bank_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.bank_name IS 'Bank Name';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.state IS 'Bank Account Type';


--
-- Name: COLUMN res_partner_bank.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.street IS 'Street';


--
-- Name: COLUMN res_partner_bank.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.city IS 'City';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner_bank.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.state_id IS 'Fed. State';


--
-- Name: COLUMN res_partner_bank.bank_bic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.bank_bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.partner_id IS 'Account Owner';


--
-- Name: COLUMN res_partner_bank.bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.bank IS 'Bank';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank.journal_id IS 'Account Journal';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_bank_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_bank_id_seq OWNED BY res_partner_bank.id;


--
-- Name: res_partner_bank_type; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_bank_type (
    id integer NOT NULL,
    create_uid integer,
    code character varying(64) NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    format_layout text,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_bank_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_bank_type IS 'Bank Account Type';


--
-- Name: COLUMN res_partner_bank_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank_type.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.code IS 'Code';


--
-- Name: COLUMN res_partner_bank_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.name IS 'Name';


--
-- Name: COLUMN res_partner_bank_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank_type.format_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.format_layout IS 'Format Layout';


--
-- Name: COLUMN res_partner_bank_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_type_field; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_bank_type_field (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    required boolean,
    write_uid integer,
    readonly boolean,
    write_date timestamp without time zone,
    bank_type_id integer NOT NULL,
    size integer
);


--
-- Name: TABLE res_partner_bank_type_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_bank_type_field IS 'Bank type fields';


--
-- Name: COLUMN res_partner_bank_type_field.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank_type_field.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank_type_field.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.name IS 'Field Name';


--
-- Name: COLUMN res_partner_bank_type_field.required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.required IS 'Required';


--
-- Name: COLUMN res_partner_bank_type_field.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank_type_field.readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.readonly IS 'Readonly';


--
-- Name: COLUMN res_partner_bank_type_field.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner_bank_type_field.bank_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.bank_type_id IS 'Bank Type';


--
-- Name: COLUMN res_partner_bank_type_field.size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_bank_type_field.size IS 'Max. Size';


--
-- Name: res_partner_bank_type_field_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_bank_type_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_bank_type_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_bank_type_field_id_seq OWNED BY res_partner_bank_type_field.id;


--
-- Name: res_partner_bank_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_bank_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_bank_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_bank_type_id_seq OWNED BY res_partner_bank_type.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_category (
    id integer NOT NULL,
    parent_left integer,
    parent_right integer,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    write_uid integer,
    parent_id integer,
    write_date timestamp without time zone,
    active boolean
);


--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.name IS 'Category Name';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_category.active IS 'Active';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_category_id_seq OWNED BY res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_id_seq OWNED BY res_partner.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    domain character varying NOT NULL,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    shortcut character varying,
    write_uid integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_partner_title IS 'res.partner.title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.domain IS 'Domain';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_partner_title_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_partner_title_id_seq OWNED BY res_partner_title.id;


--
-- Name: res_request_link; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE res_request_link (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    object character varying NOT NULL,
    write_uid integer,
    priority integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_request_link; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE res_request_link IS 'res.request.link';


--
-- Name: COLUMN res_request_link.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.create_uid IS 'Created by';


--
-- Name: COLUMN res_request_link.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.create_date IS 'Created on';


--
-- Name: COLUMN res_request_link.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.name IS 'Name';


--
-- Name: COLUMN res_request_link.object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.object IS 'Object';


--
-- Name: COLUMN res_request_link.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_request_link.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.priority IS 'Priority';


--
-- Name: COLUMN res_request_link.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN res_request_link.write_date IS 'Last Updated on';


--
-- Name: res_request_link_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_request_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_request_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_request_link_id_seq OWNED BY res_request_link.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE res_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE res_users_id_seq OWNED BY res_users.id;


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE resource_calendar (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    company_id integer,
    write_uid integer,
    manager integer,
    write_date timestamp without time zone
);


--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE resource_calendar IS 'Resource Calendar';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.manager; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.manager IS 'Workgroup Manager';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE resource_calendar_attendance (
    id integer NOT NULL,
    dayofweek character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    name character varying NOT NULL,
    date_from date,
    write_uid integer,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL,
    write_date timestamp without time zone,
    calendar_id integer NOT NULL
);


--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.date_from IS 'Starting Date';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: resource_calendar_attendance_