CREATE USER utilpm PASSWORD 'utilpm';
ALTER DATABASE parole OWNER TO utilpm;

CREATE TABLE album
(
    codealbum         SMALLINT      	NOT NULL,
    titrealbum        VARCHAR(80)   	NULL,
    media 	      VARCHAR(20)	NULL,
    nomediteur        VARCHAR(40)   	NULL,
    CONSTRAINT pk_album PRIMARY KEY (codealbum)
);

CREATE TABLE artiste
(
    codeartiste       SMALLINT      	NOT NULL,
    nomartiste        VARCHAR(20)  	NULL,
    CONSTRAINT pk_artiste PRIMARY KEY (CODEARTISTE)
);

CREATE TABLE titre
(
    codealbum         SMALLINT   	NOT NULL,
    numeroplage       SMALLINT     	NOT NULL,
    titre             VARCHAR(80)  	NULL,
    CONSTRAINT pk_titre PRIMARY KEY (codealbum, numeroplage),
    CONSTRAINT fk_titre FOREIGN KEY  (codealbum)
    REFERENCES album(codealbum) ON DELETE CASCADE
);

CREATE TABLE participer
(
    codealbum         	SMALLINT     	NOT NULL,
    codeartiste         SMALLINT     	NOT NULL,
    CONSTRAINT pk_participer PRIMARY KEY (codealbum,codeartiste),
    CONSTRAINT fk1_participer FOREIGN KEY  (codealbum)
    REFERENCES album(codealbum) ON DELETE CASCADE,
    CONSTRAINT fk2_participer FOREIGN KEY  (codeartiste)
    REFERENCES artiste(codeartiste) ON DELETE CASCADE
);

CREATE TABLE avis
(
    codeavis         INTEGER         	NOT NULL,
    note             SMALLINT 	 	NULL,
    titrecommentaire VARCHAR(80)     	NULL,
    corpscommentaire VARCHAR(3000)    	NULL,
    dateavis         DATE            	NULL,
    codealbum        SMALLINT        	NOT NULL,    
    CONSTRAINT pk_avis PRIMARY KEY (codeavis),
    CONSTRAINT fk_avis FOREIGN KEY (codealbum)
    REFERENCES album(codealbum) ON DELETE CASCADE
);

CREATE TABLE eleve
(
    codeeleve         INTEGER        	NOT NULL,
    classe            VARCHAR(20)    	NULL,
    nom               VARCHAR(25)    	NULL,
    prenom            VARCHAR(25)    	NULL,
    datenaissance     DATE 	       	NULL,
    genre             CHAR(1)        	NULL,
    CONSTRAINT pk_eleve PRIMARY KEY (codeeleve)
);

CREATE VIEW titresRptsSurUnAlbum
AS SELECT codealbum, titre, COUNT( * ) AS NB
FROM titre
GROUP BY codealbum, titre
HAVING COUNT( * ) > 1
ORDER BY codealbum, titre;

ALTER TABLE album OWNER TO utilpm;
ALTER TABLE artiste OWNER TO utilpm;
ALTER TABLE titre OWNER TO utilpm;
ALTER TABLE participer OWNER TO utilpm;
ALTER TABLE avis OWNER TO utilpm;
ALTER TABLE eleve OWNER TO utilpm;

GRANT SELECT on titresRptsSurUnAlbum TO utilpm;



