package com.example.certamenu;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;

public class MainActivity extends Activity  implements OnItemClickListener {

	private ListView listView;
	private LesDuos lesDuos = new LesDuos();
	int CODE = 1;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	}
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// TODO Auto-generated method stub
		switch (item.getItemId()){
		case R.id.item1 :
			afficheListe();
			return true;
		default :
			return true;
		}
	}
	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
		// TODO Auto-generated method stub
		Intent intent = new Intent(MainActivity.this, AfficheActivity.class);
		Duo duo = lesDuos.get(listView.getAdapter().getItem(arg2));
		intent.putExtra("garcon", duo.getGarcon());
		intent.putExtra("fille", duo.getFille());
		intent.putExtra("epoque", duo.getEpoque());
		startActivityForResult(intent, CODE);
	}
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == CODE && resultCode == RESULT_OK) {
			if (data.hasExtra("cle"))
				lesDuos.modifieDuo(data.getExtras().getString("cle"),
								   data.getExtras().getString("epoque"));
		}
	}
	private void afficheListe(){
		listView = (ListView) findViewById(R.id.listView1);
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, 
			      android.R.layout.simple_list_item_1, lesDuos.donneListe());
		listView.setAdapter(adapter);
		listView.setOnItemClickListener(this);
	}
}
