package metier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class GestionBD {
	private SQLiteDatabase maBase;
	private BdHelper monBdHelper;

	public GestionBD(Context context) {
		monBdHelper = new BdHelper(context, "baseClientAchat", null, 1);
	}
	public void open(){
		maBase = monBdHelper.getWritableDatabase();
	}
	public void close(){
		maBase.close();
	}
	public long ajouteClient(Client client){
		ContentValues v = new ContentValues();
		v.put("nom", client.getNom());
		v.put("tel", client.getTel());
		return maBase.insert("client", null, v);
	}
	public void ajouteAchat(Achat achat){
		ContentValues v = new ContentValues();
		v.put("idclient", achat.getIdClient());
		v.put("montant", achat.getMontant());
		maBase.insert("achat", null, v);
	}
	public void supprimeClients(){
		maBase.delete("client", null, null);
	}
	public ArrayList<String> donneNomClients(){
		ArrayList<String> liste = new ArrayList<String>();
		Cursor c = maBase.rawQuery("select id, nom, tel from client order by nom",null);
		while (c.moveToNext())
			liste.add( c.getString(0)+"_"+c.getString(1)+"_"+c.getString(2));
		return liste;
	}
	public ArrayList<String> donneAchats(){
		ArrayList<String> liste = new ArrayList<String>();
		Cursor c = maBase.rawQuery("select nom, sum(montant) as montant from client" +
				" left outer join achat on id=idclient group by id order by nom",null);
		while (c.moveToNext()) liste.add(c.getString(0)+" "+c.getDouble(1));
		return liste;
	}
}
