package xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


public class MaSaxHandler extends DefaultHandler {

	   private Service service;
	   private List<Service> lesServices = new ArrayList<Service>();
	   private String valeur;

	   public void parse(InputStream is) throws ParserConfigurationException, SAXException, IOException{
		   SAXParserFactory factory = SAXParserFactory.newInstance();
		   SAXParser parser=factory.newSAXParser();
		   parser.parse(is,this);
	   }
	   public void startElement( String uri, String localName, String qName, Attributes attributes)
			   throws SAXException {
		   if (localName.equals("service"))  service = new Service();
	   }
	   public void characters(char[] ch,int start, int length) throws SAXException{
			valeur = new String(ch,start,length);
		}
	   public void endElement( String uri, String localName,String qName) throws SAXException {
	        if (localName.equals("service")) {
	        	lesServices.add(service);
	        }else if (localName.equals("nom")){
	        	service.setNom(valeur);
	        }else if (localName.equals("responsable")){
	        	service.setResponsable(valeur);
	        }
	    }
	   public List<Service> getLesServices() {
		return lesServices;
	   }
}
