using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche7
{
    public partial class Fm_employe : Form
    {
        private Ds_empSce dsReel;
        public Fm_employe(Ds_empSce ds)
        {
            InitializeComponent();
            bs_employe.DataSource = ds;
            bs_service.DataSource = ds;
            bs_recherche.DataSource = ds;
            dsReel = ds;
            bn_employe.ItemClicked+=new ToolStripItemClickedEventHandler(Fm_principal.Bn_ItemClicked);
            bindingNavigatorDeleteItem.Click+=new EventHandler(Fm_principal.Bn_DeleteItemClick);
        }

        private void bt_fermer_Click(object sender, EventArgs e)
        {
            Fm_principal.Bs_ValiderLigne(bs_employe);
            Hide();
        }


        private void Fm_employe_Load(object sender, EventArgs e)
        {
            bs_employe.CurrentChanged += new EventHandler(bs_employe_CurrentChanged);
            bs_employe_CurrentChanged(null, null);
        }

        void bs_employe_CurrentChanged(object sender, EventArgs e)
        {
            if (employeCourant != null)
            {
                if (employeCourant.sexe == "f")
                {
                    rb_feminin.Checked = true;
                }
                else
                {
                    rb_masculin.Checked = true;
                }
            }
        }

        private Ds_empSce.employeRow employeCourant
        {
            get
            {
                if (bs_employe.Current == null)
                {
                    return null;
                }
                else
                {
                    return (Ds_empSce.employeRow)((DataRowView)bs_employe.Current).Row;
                }
            }
        }

        private void bindingNavigatorAddNewItem_Click(object sender, EventArgs e)
        {
            tb_nom.Focus();
        }
        
        private void gb_sexeChanged(object sender, EventArgs e)
        {
            if (rb_feminin.Checked)
            {
                employeCourant.sexe = "f";
            }
            else
            {
                employeCourant.sexe = "m";
            }
        }

        private void cb_recherche_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cb_recherche.SelectedIndex!=-1)
            {
                string numEmploye;
                int posEmploye;
                numEmploye = cb_recherche.SelectedValue.ToString();
                posEmploye = bs_employe.Find("numero", numEmploye);
                bs_employe.Position = posEmploye;
            }
        }

        private void bt_masseSalariale_Click(object sender, EventArgs e)
        {
            string codeSce = employeCourant.sce;
            Ds_empSce.serviceRow service = dsReel.service.FindBycode(codeSce);
            string totalSalaires = service.masseSalariale.ToString();
            MessageBox.Show(totalSalaires);
        }

        private void cb_service_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cb_service.SelectedIndex != -1)
            {
                int effectif;
                string codeSce = cb_service.SelectedValue.ToString(); ;
                effectif = (int)dsReel.employe.Compute("Count(numero)", "sce='" + codeSce + "'");
                tb_effectif.Text = effectif.ToString();
            }
        }

    }
}