using System;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace Fiche6
{
    public partial class Fm_enumerateur : Form
    {
        Ds_empSce ds;
        public Fm_enumerateur(Ds_empSce p_ds)
        {
            InitializeComponent();
            ds = p_ds;
        }

        private void Fm_enumerateur_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
        }

        private void bt_services_Click(object sender, EventArgs e)
        {
            BindingSource bs = new BindingSource(ds, "service");
            string ligne;
            tb_resultat.Clear();
            bs.MoveFirst();
            foreach (DataRowView vueLigne in bs)
            {
                ligne = vueLigne.Row["code"].ToString() + "\t";
                ligne += vueLigne.Row["designation"].ToString();
                tb_resultat.AppendText(ligne + Environment.NewLine);
            }
        }

        private void bt_sceEmployes_Click(object sender, EventArgs e)
        {
            DataRowView vueService;
            BindingSource bs_service,bs_employe;
            bs_service = new BindingSource(ds, "service");
            tb_resultat.Clear();
            for(int i=0;i<bs_service.Count;i++)
            {
                vueService = (DataRowView)bs_service.Current;
                tb_resultat.AppendText(vueService.Row["designation"].ToString()+Environment.NewLine);
                bs_employe = new BindingSource(bs_service,"serviceEmploye");
                foreach (DataRowView vueEmploye in bs_employe)
                {
                    tb_resultat.AppendText("\t" + vueEmploye.Row["nom"].ToString() + Environment.NewLine);
                }
                bs_service.MoveNext();
            }
        }

        private void bt_augmenter_Click(object sender, System.EventArgs e)
        {
            BindingSource bs_employe = new BindingSource(ds, "employe");
            IEnumerator iterEmp = bs_employe.GetEnumerator();
            string salaireValue;
            decimal salaire;
            foreach (DataRowView vueLigne in bs_employe)
            {
                salaireValue = vueLigne.Row["salaire"].ToString();
                if (salaireValue != "")
                {
                    salaire = decimal.Parse(salaireValue);
                    salaire += 100;
                    vueLigne.Row["salaire"] = salaire;
                }
            }
        }

    }
}