using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;

namespace Fiche6
{
    public partial class Fm_principal : Form
    {
        Fm_service fs;
        Fm_employe fe;
        Fm_empSce fse;

        public Fm_principal()
        {
            InitializeComponent();
            ta_service.Fill(ds.service);
            ta_employe.Fill(ds.employe);
            ds.service.serviceRowChanged += new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds.service.serviceRowDeleted += new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds.employe.employeRowChanged += new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds.employe.employeRowDeleted += new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            fs = new Fm_service(ds);
            fe = new Fm_employe(ds);
            fse = new Fm_empSce(ds);
        }
        void employe_employeRowChangedOrDeleted(object sender, Ds_empSce.employeRowChangeEvent e)
        {
            if (e.Action == DataRowAction.Add)
            {
                string numEmploye;
                ta_employe.GetIdEmploye(out numEmploye);
                e.Row["numero"] = numEmploye;
            }
            if ((e.Action == DataRowAction.Add) || (e.Action == DataRowAction.Change) || (e.Action == DataRowAction.Delete))
            {
                try
                {
                    ta_employe.Update(e.Row);
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur SGBD : " + pb.ToString());
                    e.Row.RejectChanges();
                }
            }
        }
        void service_serviceRowChangedOrDeleted(object sender, Ds_empSce.serviceRowChangeEvent e)
        {
            if ((e.Action == DataRowAction.Add) || (e.Action == DataRowAction.Change) || (e.Action == DataRowAction.Delete))
            {
                try
                {
                    ta_service.Update(e.Row);
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur SGBD : " + pb.ToString());
                    e.Row.RejectChanges();
                }
            }
        }
        public static void Bn_DeleteItemClick(object sender, EventArgs e)
        {
            ToolStripButton bt = (ToolStripButton)sender;
            BindingNavigator bn = (BindingNavigator)bt.Owner;
            BindingSource bs = bn.BindingSource;
            try
            {
                bs.RemoveCurrent();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
            }
        }
        public static void Bs_ValiderLigne(BindingSource bs)
        {
            try
            {
                bs.EndEdit();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }
        public static void Bn_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            BindingNavigator bn = (BindingNavigator)sender;
            BindingSource bs = bn.BindingSource;
            if ((e.ClickedItem.Text != "Supprimer") && (e.ClickedItem != bn.CountItem))
            {
                Bs_ValiderLigne(bs);
            }
        }

        private void bt_service_Click(object sender, EventArgs e)
        {
            fs.Show();
        }
        private void bt_employe_Click(object sender, EventArgs e)
        {
            fe.Show();
        }

        private void bt_empSce_Click(object sender, EventArgs e)
        {
            fse.Show();
        }

        private void bt_nbServices_Click(object sender, EventArgs e)
        {
            int nb;

            // recherche dans le dataset
            nb = (int)ds.service.Compute("Count(code)", "");
            MessageBox.Show(nb.ToString());

            // recherche dans la base de donnes
            SqlConnection co;
            SqlCommand cmd;
            co = ta_service.Connection;
            cmd = new System.Data.SqlClient.SqlCommand("select count(*) from service",co);
            co.Open();
            nb = (int)cmd.ExecuteScalar();
            co.Close();
            MessageBox.Show(nb.ToString());
        }

        private void bt_listeServices_Click(object sender, EventArgs e)
        {
            SqlConnection co=ta_service.Connection;
            SqlDataReader rd;
            SqlCommand cmd = new SqlCommand("select * from service", co);
            co.Open();
            rd = cmd.ExecuteReader();
            while (rd.Read())
            {
                MessageBox.Show("Code : " + rd["code"] + ", Dsignation : " + rd["designation"]);
            }
            rd.Close();
            co.Close();
        }

        private void bt_modifierS1_Click(object sender, EventArgs e)
        {
            SqlConnection co=ta_service.Connection;
            SqlCommand cmd = new SqlCommand("update service set designation='Production' where code='S1'", co);
            co.Open();
            cmd.ExecuteNonQuery();
            co.Close();
        }

        private void bt_modifierEmploye_Click(object sender, EventArgs e)
        {
            ds.employe.Rows[2]["prenom"] = "Gdon";
        // mise  jour de la base de donnes totalement inutile !!!
            ta_employe.Update(ds.employe);
        }

        private void bt_ajoutService_Click(object sender, EventArgs e)
        {
            Ds_empSce.serviceRow r = ds.service.NewserviceRow();
            r.code = "S4";
            r.designation = "Emballage";
            ds.service.AddserviceRow(r);
        }

        private void bt_supprimerService_Click(object sender, EventArgs e)
        {
            ds.service.Rows.RemoveAt(3);
        }

        private void bt_recharger_Click(object sender, EventArgs e)
        {
            ds.employe.employeRowChanged -= new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds.employe.employeRowDeleted -= new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds.service.serviceRowChanged -= new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds.service.serviceRowDeleted -= new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds.EnforceConstraints = false;
            ta_employe.Fill(ds.employe);
            ta_service.Fill(ds.service);
            ds.EnforceConstraints = true;
            ds.employe.employeRowChanged += new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds.employe.employeRowDeleted += new Ds_empSce.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds.service.serviceRowChanged += new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds.service.serviceRowDeleted += new Ds_empSce.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
        }
    }
}