using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche6
{
    public partial class Fm_empSce : Form
    {
        public Fm_empSce(Ds_empSce ds)
        {
            InitializeComponent();
            bs_service.DataSource = ds;
            bs_serviceEmp.DataSource = ds;
            bs_employe.CurrentChanged += new EventHandler(bs_employe_CurrentChanged);
            bs_employe_CurrentChanged(null, null);
            bn_employe.ItemClicked+=new ToolStripItemClickedEventHandler(Fm_principal.Bn_ItemClicked);
            bn_employeDeleItem.Click+=new EventHandler(Fm_principal.Bn_DeleteItemClick);
            bn_service.ItemClicked+=new ToolStripItemClickedEventHandler(Fm_principal.Bn_ItemClicked);
            bn_serviceDeleteItem.Click+=new EventHandler(Fm_principal.Bn_DeleteItemClick);
        }

        private Ds_empSce.employeRow employeCourant
        {
            get
            {
                if (bs_employe.Current == null)
                {
                    return null;
                }
                else
                {
                    return (Ds_empSce.employeRow)((DataRowView)bs_employe.Current).Row;
                }
            }
        }

        void bs_employe_CurrentChanged(object sender, EventArgs e)
        {
            if (employeCourant != null)
            {
                if (employeCourant.sexe == "f")
                {
                    rb_feminin.Checked = true;
                }
                else
                {
                    rb_masculin.Checked = true;
                }
            }
        }

        private void gb_sexeChanged(object sender, EventArgs e)
        {
            if (rb_feminin.Checked)
            {
                employeCourant.sexe = "f";
            }
            else
            {
                employeCourant.sexe = "m";
            }
        }

        private void bt_fermer_Click(object sender, EventArgs e)
        {
            Fm_principal.Bs_ValiderLigne(bs_service);
            Fm_principal.Bs_ValiderLigne(bs_employe);
            Hide();
        }

    }
}