using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche4
{
    public partial class Fm_employe : Form
    {
        public Fm_employe()
        {
            InitializeComponent();
        }

        private void bt_fermer_Click(object sender, EventArgs e)
        {
            try
            {
                bs_employe.EndEdit();
                Hide();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_employe.CancelEdit();
            }
        }


        private void Fm_employe_Load(object sender, EventArgs e)
        {
            // TODO: cette ligne de code charge les donnes dans la table 'ds_employe.service'. Vous pouvez la dplacer ou la supprimer selon vos besoins.
            this.ta_service.Fill(this.ds_employe.service);
            // TODO: cette ligne de code charge les donnes dans la table 'ds_employe.employe'. Vous pouvez la dplacer ou la supprimer selon vos besoins.
            this.ta_employe.Fill(this.ds_employe.employe);
            ds_employe.employe.employeRowChanged += new Ds_employe.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            ds_employe.employe.employeRowDeleted += new Ds_employe.employeRowChangeEventHandler(employe_employeRowChangedOrDeleted);
            bs_employe.CurrentChanged += new EventHandler(bs_employe_CurrentChanged);
            bs_employe_CurrentChanged(null, null);
        }

        void bs_employe_CurrentChanged(object sender, EventArgs e)
        {
            if (employeCourant != null)
            {
                if (employeCourant.sexe == "f")
                {
                    rb_feminin.Checked = true;
                }
                else
                {
                    rb_masculin.Checked = true;
                }
            }
        }

        void employe_employeRowChangedOrDeleted(object sender, Ds_employe.employeRowChangeEvent e)
        {
            if (e.Action == DataRowAction.Add)
            {
                string numEmploye;
                ta_employe.GetIdEmploye(out numEmploye);
                e.Row["numero"] = numEmploye;
            }
            if ((e.Action==DataRowAction.Add)||(e.Action==DataRowAction.Change)||(e.Action==DataRowAction.Delete))
            {
                try
                {
                    ta_employe.Update(e.Row);
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur SGBD : " + pb.ToString());
                    e.Row.RejectChanges();
                }
            }
        }

        private Ds_employe.employeRow employeCourant
        {
            get
            {
                if (bs_employe.Current == null)
                {
                    return null;
                }
                else
                {
                    return (Ds_employe.employeRow)((DataRowView)bs_employe.Current).Row;
                }
            }
        }

        private void bn_employe_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            if ((e.ClickedItem.Text != "Supprimer") && (e.ClickedItem != bn_employe.CountItem))
            {
                try
                {
                    bs_employe.EndEdit();
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur DATASET : " + pb.ToString());
                    bs_employe.CancelEdit();
                }
            }
        }

        private void bindingNavigatorAddNewItem_Click(object sender, EventArgs e)
        {
            tb_nom.Focus();
        }
        
        private void gb_sexeChanged(object sender, EventArgs e)
        {
            if (rb_feminin.Checked)
            {
                employeCourant.sexe = "f";
            }
            else
            {
                employeCourant.sexe = "m";
            }
        }

        private void bt_recharger_Click(object sender, EventArgs e)
        {
            ta_service.Fill(ds_employe.service);
        }
    }
}