using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Fiche4
{
    public delegate void FonctionSurAjout();
    public partial class BarreNavigation : UserControl
    {
        private BindingSource bs;
        private FonctionSurAjout surAjout;
        public BarreNavigation()
        {
            InitializeComponent();
        }
        public void Init(BindingSource p_bs)
        {
            bs = p_bs;
            bs.PositionChanged += new EventHandler(bs_PositionChanged);
            bs_PositionChanged(null, null);
        }

        public void Init(BindingSource p_bs, FonctionSurAjout p_surAjout)
        {
            Init(p_bs);
            surAjout = p_surAjout;
        }
        public string Titre
        {
            get
            {
                return lbl_titre.Text;
            }
            set
            {
                lbl_titre.Text = value;
            }
        }

        void bs_PositionChanged(object sender, EventArgs e)
        {
            tb_posCpt.Text = bs.Position + 1 + "/" + bs.Count;
        }

        private void bt_premier_Click(object sender, EventArgs e)
        {
            try
            {
                bs.MoveFirst();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_precedent_Click(object sender, EventArgs e)
        {
            try
            {
                bs.MovePrevious();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_suivant_Click(object sender, EventArgs e)
        {
            try
            {
                bs.MoveNext();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_dernier_Click(object sender, EventArgs e)
        {
            try
            {
                bs.MoveLast();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_ajouter_Click(object sender, EventArgs e)
        {
            try
            {
                bs.AddNew();
                if (surAjout != null)
                {
                    surAjout();
                }
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_supprimer_Click(object sender, EventArgs e)
        {
            try
            {
                bs.RemoveCurrent();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

        private void bt_ok_Click(object sender, EventArgs e)
        {
            try
            {
                bs.EndEdit();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs.CancelEdit();
            }
        }

    }
}
